/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.scd.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DB2OS390Type;
import com.sas.etl.models.data.dbmstypes.DB2UNXPCType;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.ODBCSQLSVRPCType;
import com.sas.etl.models.data.dbmstypes.ODBCSQLSVRType;
import com.sas.etl.models.data.dbmstypes.SASIOHNAType;
import com.sas.etl.models.data.dbmstypes.SASType;
import com.sas.etl.models.data.impl.BaseDatabaseSchema;
import com.sas.etl.models.data.impl.BaseLibrary;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ILoaderTransform;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractLoaderTransform;
import com.sas.etl.models.job.impl.BaseLoaderModelListener;
import com.sas.etl.models.job.impl.BaseLoaderPromptModel;
import com.sas.etl.models.job.impl.BaseLoaderTransformValueChangedListener;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.scd.ISCDTransformModel;
import com.sas.etl.models.job.transforms.scd.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.text.SASFormat;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public abstract class AbstractSCDTransformModel
extends AbstractLoaderTransform
implements ISCDTransformModel {
    protected static final String CONNECTION_PROPERTY_NAME = "CONNECTION";
    protected static final String CONNECTION_GROUP_PROPERTY_NAME = "CONNECTION_GROUP";
    protected static final String CONNECTION_PROPERTY_DEFAULT = "GLOBAL";
    protected static final String INFORMIX_CONNECTION_GROUP_DEFAULT = "ETLSGRP";
    private static final String DEFAULT_FROMDTTM_NAME = "VALID_FROM_DTTM";
    private static final String DEFAULT_FROMDT_NAME = "VALID_FROM_DT";
    private static final String DEFAULT_TODTTM_NAME = "VALID_TO_DTTM";
    private static final String DEFAULT_TODT_NAME = "VALID_TO_DT";
    public static final String DEFAULT_FROMDATE_EXP = "%SYSFUNC(DATETIME())";
    private static final String DEFAULT_TODATE_EXP = "'01JAN5999:00:00:00'DT";
    private static final String TO_DATE_TRANSFORMROLE = "SCD2_TODATE";
    private static final String TO_DATE_MAP_NAME = "SCD Type 2 To Date Map";
    private static final String TO_DATE_MAP_DESC = "Contains Slowly Changing Dimension Type 2 To or End Date Column.";
    private static final String FROM_DATE_TRANSFORMROLE = "SCD2_FROMDATE";
    private static final String FROM_DATE_MAP_NAME = "SCD Type 2 From Date Map";
    private static final String FROM_DATE_MAP_DESC = "Contains Slowly Changing Dimension Type 2 From or Begin Date Column.";
    private static final String NAME_XREF_TABLE_NAME = "Cross-Reference Table Name";
    private static final String NAME_DATE_FORMAT_TYPE = "Format Type for Date";
    private static final String NAME_SQL_OPTIONS = "SQL Options";
    private static final String NAME_SQL_PASSTHRU = "Use SQL Pass-thru";
    private static final String NAME_TEMP_TABLE_LIBREF = "Libref to save insert and update temporary tables";
    private static final String NAME_CLOSE_RECS_NOT_IN_SOURCE = "Close out records not in source table";
    private static final String NAME_MULTI_UPDATE_ALLOWED = "Multiple updates allowed per day";
    private static final String NAME_ADD_INDEX_TEMP_TABLE = "Add an index to the update temp table";
    private static final String NAME_USE_PERM_XREF_INDEX_IF_SASDS = "Use index on permanent xreference sas dataset instead of proc sort";
    private static final String NAME_USE_BULKLOAD = "Use Bulkload";
    private static final String NAME_SORT_TEMP_XREF = "Sort target table records prior to creating temporary cross reference table:";
    private static final String NAME_TARGET_TABLE_INDEX_ADD = "Create an index on the target table";
    private static final String NAME_XREF_TABLE_INDEX_ADD = "Create an index on the permanent cross reference table";
    private static final String NAME_SPDS_UPDATE_TECHNIQUE = "SPDS update technique";
    private static final String NAME_CHANGE_DIGEST_VERSION = "Change digest version";
    private static final String NAME_CLOSE_RECORDS_WORK_TABLE_OPTIONS = "Close records work table options";
    private static final String NAME_MATCH_RECORDS_WORK_TABLE_OPTIONS = "Match records work table options";
    private static final String NAME_NEW_RECORDS_WORK_TABLE_OPTIONS = "New records work table options";
    private static final String NAME_TYPE1_RECORDS_WORK_TABLE_OPTIONS = "Type1 records work table options";
    private static final String OPTION_NAME_XREF_TABLE_NAME = "XrefTableName";
    private static final String OPTION_NAME_DATE_FORMAT_TYPE = "FMTTypeForDate";
    private static final String OPTION_NAME_SQL_OPTIONS = "SQLOptions";
    private static final String OPTION_NAME_USE_SQL_PASSTHRU = "SQLPassThru";
    private static final String OPTION_NAME_TEMP_TABLE_LIBREF = "SaveWorkTables";
    private static final String OPTION_NAME_CLOSE_RECS_NOT_IN_SOURCE = "CloseRecsNotInSource";
    private static final String OPTION_NAME_ALLOW_MULTI_UPDATES_PER_DAY = "MultiUpdatesPerDay";
    private static final String OPTION_NAME_TEMP_TABLE_INDEX_ADD = "TempTblIndex";
    private static final String OPTION_NAME_UPLOAD_LIBRARY = "UploadLibrary";
    private static final String OPTION_NAME_USE_PERM_XREF_INDEX_IF_SASDS = "UseIndexIfReadingSasds";
    private static final String OPTION_NAME_USE_BULKLOAD = "Bulkload";
    private static final String OPTION_NAME_SORT_TEMP_XREF = "SortTempXref";
    private static final String OPTION_NAME_TARGET_TABLE_INDEX_ADD = "TargetTblIndex";
    private static final String OPTION_NAME_XREF_TABLE_INDEX_ADD = "XrefTblIndex";
    private static final String OPTION_NAME_SPDS_UPDATE_TECHNIQUE = "SPDSUpdateTechnique";
    private static final String OPTION_NAME_CHANGE_DIGEST_VERSION = "ChangeDigestVersion";
    private static final String OPTION_NAME_CLOSE_RECORDS_WORK_TABLE_OPTIONS = "CloseRecordsWorkTableOptions";
    private static final String OPTION_NAME_MATCH_RECORDS_WORK_TABLE_OPTIONS = "MatchRecordsWorkTableOptions";
    private static final String OPTION_NAME_NEW_RECORDS_WORK_TABLE_OPTIONS = "NewRecordsWorkTableOptions";
    private static final String OPTION_NAME_TYPE1_RECORDS_WORK_TABLE_OPTIONS = "Type1RecordsWorkTableOptions";
    private static final String PROPERTY_ROLE_XREF_TABLE_NAME = "XREFTABLE";
    private static final String PROPERTY_ROLE_DATE_FORMAT_TYPE = "DATEFmtType";
    private static final int MAX_SUFFIX = 99999;
    private static Random rand = new Random();
    private static final String SCD_INDEX_PREFIX = "SCDIDX";
    private String m_sXrefTableName;
    private String m_sDateFormatType;
    private String m_sSQLOptions;
    private boolean m_bUseSQLPassthru;
    private String m_sTempTableLibref;
    private ILibrary m_uploadLibrary;
    private boolean m_bUseBulkload;
    private boolean m_bSortTempXref;
    private boolean m_bTargetTblIndexAdd;
    private boolean m_bXrefTblIndexAdd;
    private String m_sSPDSUpdateTechnique;
    private String m_sChangeDigestVersion;
    private String m_sCloseRecordsWorkTableOptions;
    private String m_sMatchRecordsWorkTableOptions;
    private String m_sNewRecordsWorkTableOptions;
    private String m_sType1RecordsWorkTableOptions;
    private boolean m_bCloseRecsNotInSource;
    private boolean m_bMultiUpdatesPerDay;
    private boolean m_bTempUpdateTblIndex;
    private boolean m_bUseIndexIfReadingSasds;
    private boolean m_bTrackChangesByDates;
    private IColumn m_fromDateColumn;
    private IColumn m_toDateColumn;
    private ITextExpression m_fromDateExpression;
    private ITextExpression m_toDateExpression;
    private List m_mlBusinessKeyColumns;
    private static final int LINE_LENGTH = 80;
    protected static final String MAXKEYMACRO = "etls_maxkey";
    protected static final String BEGDATEEXPMACRO = "etls_begdate";
    protected static final String ENDDATEEXPMACRO = "etls_enddate";
    protected static final String TEMPCLOSEDATE = "ETLS_CLSDATE";
    protected static final String TEMPNEWMAXKEY = "NewMaxKey";
    protected static final String TEMPGENKEY = "ETLS_KEY";
    protected static final String TEMPFROMDATE = "ETLS_FROMDATE";
    protected static final String TEMPTODATE = "ETLS_TODATE";
    protected static final String TEMPLOADTIME = "ETLS_LOADTIME";
    protected static final String TEMPSTGDIGEST = "ETLS_STGDIGEST";
    protected static final String TEMPTYPE1DIGEST = "ETLS_TYPE1DIGEST";
    protected static final String TEMPNEWVERSNUM = "ETLS_NEWVERS";
    protected static final String DIGESTCOLNAME = "DIGEST_VALUE";
    protected static final String TYPE1DIGESTCOLNAME = "DIGEST_VALUE_TYPE1";
    protected static final String WORKETLSMATCH = "work.etls_match";
    protected static final String TEMPMATCHTBLNAME = "ETLS_MATCH";
    protected static final String WORKETLSNEWRCD = "work.etls_newrcds";
    protected static final String TEMPNEWRCDTBLNAME = "ETLS_NEWRCDS";
    protected static final String WORKETLSCLOSE = "work.etls_close";
    protected static final String TEMPCLOSETBLNAME = "ETLS_CLOSE";
    protected static final String TEMPTYPE1TBLNAME = "ETLS_TYPE1";
    protected static final String WORKETLSTYPE1 = "work.etls_type1";
    protected static final String WORKTEMPXREF = "work.etls_tempxref";
    protected static final String TEMPXREFTBLNAME = "ETLS_TEMPXREF";
    protected static final String DBMSTEMPLIBREF = "etlstmp";
    private static final String SCD_OPTION_TRUE = "YES";
    private static final String SCD_OPTION_FALSE = "NO";
    private static final String DEFAULT_DATE_FORMAT_TYPE = "NONE";
    private static final String DEFAULT_CHANGE_DIGEST_VERSION = "V1_1";
    private static final String WORKSOURCENAME = "work.etls_source";
    private static final String DATE = "DATE";
    private static final String[] DEFAULT_LOAD_TIME_NAMES = new String[]{"PROCESSED_DTTM", "_LOADTM"};
    private static final String BULKLOAD_OPTION = "BULKLOAD=YES";
    private static final String DB2_BULKLOAD_OPTION = "BL_METHOD=CLILOAD";
    protected static final String SPDS_UPDATE_TECHNIQUE_MODIFY = "DataStepModify";
    protected static final String SPDS_UPDATE_TECHNIQUE_SQL = "SQLSet";
    private boolean m_bUseSCDChanges = Workspace.isSCDChangeUsed();

    public AbstractSCDTransformModel(String sID, IModel model) {
        super(sID, model);
        this.createConditionActionSetTemplates();
        this.m_sXrefTableName = "";
        this.m_sDateFormatType = DEFAULT_DATE_FORMAT_TYPE;
        this.m_sSQLOptions = "";
        this.m_bUseSQLPassthru = true;
        this.m_sTempTableLibref = "";
        this.m_bCloseRecsNotInSource = false;
        this.m_bTrackChangesByDates = true;
        this.m_bMultiUpdatesPerDay = false;
        this.m_bTempUpdateTblIndex = false;
        this.m_bUseIndexIfReadingSasds = false;
        this.m_bUseBulkload = false;
        this.m_bSortTempXref = false;
        this.m_bTargetTblIndexAdd = true;
        this.m_bXrefTblIndexAdd = true;
        this.m_sSPDSUpdateTechnique = SPDS_UPDATE_TECHNIQUE_SQL;
        this.m_sChangeDigestVersion = DEFAULT_CHANGE_DIGEST_VERSION;
        this.m_sCloseRecordsWorkTableOptions = "";
        this.m_sMatchRecordsWorkTableOptions = "";
        this.m_sNewRecordsWorkTableOptions = "";
        this.m_sType1RecordsWorkTableOptions = "";
        this.m_mlBusinessKeyColumns = new ModelList(this, new String[]{"SCDTransformModel:BusinessKeyAdded", "SCDTransformModel:BusinessKeyRemoved", "SCDTransformModel:BusinessKeyMoved"}, 0, IColumn.class);
        this.setDefaultLoadTimeColumnNames(DEFAULT_LOAD_TIME_NAMES);
        if (this.isNew()) {
            this.m_fromDateExpression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
            this.m_fromDateExpression.setText(DEFAULT_FROMDATE_EXP, new IColumn[0]);
            this.m_fromDateExpression.addNotifyListener(this);
            this.m_toDateExpression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
            this.m_toDateExpression.setText(DEFAULT_TODATE_EXP, new IColumn[0]);
            this.m_toDateExpression.addNotifyListener(this);
        }
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.loadConditionActionSetTemplatesFromOMR();
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETDATAMODIFIED");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLECREATED");
    }

    @Override
    protected void postAddDataTarget(IDataObject target) {
        super.postAddDataTarget(target);
        IColumn[] aCols = ((ITable)target).getColumns();
        for (int index = 0; index < aCols.length; ++index) {
            IColumn col = aCols[index];
            String sName = col.getColumnName(false);
            if (sName.equalsIgnoreCase(DEFAULT_FROMDTTM_NAME) || sName.equalsIgnoreCase(DEFAULT_FROMDT_NAME)) {
                this.setFromDateColumn(col);
                continue;
            }
            if (!sName.equalsIgnoreCase(DEFAULT_TODTTM_NAME) && !sName.equalsIgnoreCase(DEFAULT_TODT_NAME)) continue;
            this.setToDateColumn(col);
        }
    }

    @Override
    protected void preRemoveDataTarget(IDataObject target) {
        super.preRemoveDataTarget(target);
        this.setFromDateColumn(null);
        this.setToDateColumn(null);
        this.m_mlBusinessKeyColumns.clear();
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.isTrackChangesByDatesComplete() && this.m_mlBusinessKeyColumns.size() > 0 && this.isBusinessKeyComplete();
    }

    protected boolean isBusinessKeyComplete() {
        IColumn busKeyCol;
        return this.m_mlBusinessKeyColumns.size() != 1 || (busKeyCol = this.getBusinessKeyColumns()[0]) != this.m_fromDateColumn || !this.isTrackChangesByDates();
    }

    protected boolean isTrackChangesByDatesComplete() {
        if (this.isTrackChangesByDates()) {
            try {
                if (this.m_fromDateColumn == null || this.m_toDateColumn == null || this.m_fromDateExpression != null && this.m_fromDateExpression.isComplete() && this.m_fromDateExpression.getText(null, false).length() <= 0 || this.m_toDateExpression != null && this.m_toDateExpression.isComplete() && this.m_toDateExpression.getText(null, false).length() <= 0) {
                    return false;
                }
            }
            catch (RemoteException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (CodegenException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (MdException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (BadServerDefinitionException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (BadLibraryDefinitionException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (ServerException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.isTrackChangesByDates()) {
            if (this.m_fromDateColumn == null || this.m_toDateColumn == null) {
                lReasons.add(RB.getStringResource("AbstractSCDTransformModel.ReasonIncomplete.NoDates.txt"));
            }
            if (this.m_fromDateExpression == null) {
                lReasons.add(RB.getStringResource("AbstractSCDTransformModel.ReasonIncomplete.NoFromDateExpression.txt"));
            }
            if (this.m_toDateExpression == null) {
                lReasons.add(RB.getStringResource("AbstractSCDTransformModel.ReasonIncomplete.NoToDateExpression.txt"));
            }
            try {
                if (this.m_fromDateExpression != null && this.m_fromDateExpression.getText(null, false).length() == 0) {
                    lReasons.add(RB.getStringResource("AbstractSCDTransformModel.ReasonIncomplete.NoFromDateExpression.txt"));
                }
                if (this.m_toDateExpression != null && this.m_toDateExpression.getText(null, false).length() == 0) {
                    lReasons.add(RB.getStringResource("AbstractSCDTransformModel.ReasonIncomplete.NoToDateExpression.txt"));
                }
            }
            catch (RemoteException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (CodegenException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (MdException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (BadServerDefinitionException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (BadLibraryDefinitionException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            catch (ServerException e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            if (this.m_fromDateExpression != null && !this.m_fromDateExpression.isComplete()) {
                lReasons.addAll(this.m_fromDateExpression.getReasonsIncomplete());
            }
            if (this.m_toDateExpression != null && !this.m_toDateExpression.isComplete()) {
                lReasons.addAll(this.m_toDateExpression.getReasonsIncomplete());
            }
        }
        return lReasons;
    }

    @Override
    public void notify(NotifyEvent ev) {
        IObject source = (IObject)ev.getSource();
        if (ev.getType() == 0) {
            if (source instanceof IColumn) {
                IColumn column = (IColumn)source;
                if (this.m_fromDateColumn == column) {
                    this.setFromDateColumn(null);
                }
                if (this.m_toDateColumn == column) {
                    this.setToDateColumn(null);
                }
                if (this.m_mlBusinessKeyColumns.contains(column)) {
                    this.removeBusinessKeyColumn(column);
                }
            } else if (source instanceof IDataObject) {
                IDataObject dataObject = (IDataObject)source;
                if (this.getDataTargetList().contains(dataObject)) {
                    this.setFromDateColumn(null);
                    this.setToDateColumn(null);
                    this.m_mlBusinessKeyColumns.clear();
                }
            }
        }
        if (ev.getType() == 1 && (source == this.m_toDateExpression || source == this.m_fromDateExpression)) {
            this.fireModelChangedEvent("SCDTransfromModel:TranformChanged", source);
        }
        super.notify(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            IColumn oldFromColumn = this.m_fromDateColumn;
            IColumn oldToColumn = this.m_toDateColumn;
            ArrayList lOldBusCols = new ArrayList();
            for (int iBusCol = 0; iBusCol < this.m_mlBusinessKeyColumns.size(); ++iBusCol) {
                lOldBusCols.add(this.m_mlBusinessKeyColumns.get(iBusCol));
            }
            if (this.m_fromDateExpression != null) {
                this.m_fromDateExpression.replaceTableColumns(oldTable, newTable);
            }
            if (this.m_toDateExpression != null) {
                this.m_toDateExpression.replaceTableColumns(oldTable, newTable);
            }
            super.replaceTargetTable(oldTable, newTable, columnsMap, portIndexes);
            boolean bCaseSensitive = this.isQuotingNeeded() || newTable.isQuoted();
            IColumn[] newColumns = newTable.getColumns();
            block4: for (int iCol = 0; iCol < newColumns.length; ++iCol) {
                IColumn newColumn = newColumns[iCol];
                if (oldFromColumn != null && newColumn.equalsName(oldFromColumn, bCaseSensitive) && newColumn.getType() == oldFromColumn.getType()) {
                    this.setFromDateColumn(newColumn);
                }
                if (oldToColumn != null && newColumn.equalsName(oldToColumn, bCaseSensitive) && newColumn.getType() == oldToColumn.getType()) {
                    this.setToDateColumn(newColumn);
                }
                for (int iBusCol = 0; iBusCol < lOldBusCols.size(); ++iBusCol) {
                    IColumn oldBusColumn = (IColumn)lOldBusCols.get(iBusCol);
                    if (!newColumn.equalsName(oldBusColumn, bCaseSensitive) || newColumn.getType() != oldBusColumn.getType()) continue;
                    this.addBusinessKeyColumn(newColumn);
                    continue block4;
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cSCDOptionModel();
    }

    @Override
    public String getXrefTableName() {
        return this.m_sXrefTableName;
    }

    @Override
    public void setXrefTableName(String sOption) {
        if (this.m_sXrefTableName.equals(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetXrefTableNameUndoable(this.m_sXrefTableName, sOption));
        }
        this.m_sXrefTableName = sOption;
        this.fireModelChangedEvent("SCDTransform:XrefTableChanged", this.m_sXrefTableName);
    }

    public boolean isSASTable() {
        Object table;
        boolean bSASTable = false;
        List lSources = this.getDataSourceList();
        if (lSources != null && lSources.size() > 0 && (table = lSources.get(0)) instanceof IPhysicalTable) {
            if (this.getDataTarget() == null) {
                return false;
            }
            bSASTable = "SAS".equals(((IPhysicalTable)this.getDataTarget()).getDBMSType().getDBMSTypeName());
        }
        return bSASTable;
    }

    @Override
    public String getDateFormatType() {
        return this.m_sDateFormatType;
    }

    @Override
    public void setDateFormatType(String sOption) {
        if (this.m_sDateFormatType.equalsIgnoreCase(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDateFormatTypeUndoable(this.m_sDateFormatType, sOption));
        }
        this.m_sDateFormatType = sOption;
        this.fireModelChangedEvent("SCDTransform:DateFormatTypeChanged", this.m_sDateFormatType);
    }

    @Override
    public String getSQLOptions() {
        return this.m_sSQLOptions;
    }

    @Override
    public void setSQLOptions(String sOptions) {
        if (this.m_sSQLOptions.equalsIgnoreCase(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSQLOptionsUndoable(this.m_sSQLOptions, sOptions));
        }
        this.m_sSQLOptions = sOptions;
        this.fireModelChangedEvent("SCDTransform:SQLOptionsChanged", this.m_sSQLOptions);
    }

    @Override
    public String getCloseRecordsWorkTableOptions() {
        return this.m_sCloseRecordsWorkTableOptions;
    }

    @Override
    public void setCloseRecordsWorkTableOptions(String sOptions) {
        if (this.m_sCloseRecordsWorkTableOptions.equalsIgnoreCase(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCloseRecordsWorkTableOptionsUndoable(this.m_sCloseRecordsWorkTableOptions, sOptions));
        }
        this.m_sCloseRecordsWorkTableOptions = sOptions;
        this.fireModelChangedEvent("SCDTransform:CloseRecordsWorkTableOptionsChanged", this.m_sCloseRecordsWorkTableOptions);
    }

    @Override
    public String getMatchRecordsWorkTableOptions() {
        return this.m_sMatchRecordsWorkTableOptions;
    }

    @Override
    public void setMatchRecordsWorkTableOptions(String sOptions) {
        if (this.m_sMatchRecordsWorkTableOptions.equalsIgnoreCase(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMatchRecordsWorkTableOptionsUndoable(this.m_sMatchRecordsWorkTableOptions, sOptions));
        }
        this.m_sMatchRecordsWorkTableOptions = sOptions;
        this.fireModelChangedEvent("SCDTransform:MatchRecordsWorkTableOptionsChanged", this.m_sMatchRecordsWorkTableOptions);
    }

    @Override
    public String getNewRecordsWorkTableOptions() {
        return this.m_sNewRecordsWorkTableOptions;
    }

    @Override
    public void setNewRecordsWorkTableOptions(String sOptions) {
        if (this.m_sNewRecordsWorkTableOptions.equalsIgnoreCase(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNewRecordsWorkTableOptionsUndoable(this.m_sNewRecordsWorkTableOptions, sOptions));
        }
        this.m_sNewRecordsWorkTableOptions = sOptions;
        this.fireModelChangedEvent("SCDTransform:NewRecordsWorkTableOptionsChanged", this.m_sNewRecordsWorkTableOptions);
    }

    @Override
    public String getType1RecordsWorkTableOptions() {
        return this.m_sType1RecordsWorkTableOptions;
    }

    @Override
    public void setType1RecordsWorkTableOptions(String sOptions) {
        if (this.m_sType1RecordsWorkTableOptions.equalsIgnoreCase(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetType1RecordsWorkTableOptionsUndoable(this.m_sType1RecordsWorkTableOptions, sOptions));
        }
        this.m_sType1RecordsWorkTableOptions = sOptions;
        this.fireModelChangedEvent("SCDTransform:Type1RecordsWorkTableOptionsChanged", this.m_sType1RecordsWorkTableOptions);
    }

    @Override
    public boolean isSQLPassthru() {
        return this.m_bUseSQLPassthru;
    }

    @Override
    public void setUseSQLPassthru(boolean bOption) {
        if (this.m_bUseSQLPassthru == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseSQLPassthruUndoable(this.m_bUseSQLPassthru, bOption));
        }
        this.m_bUseSQLPassthru = bOption;
        this.fireModelChangedEvent("SCDTransform:UseSQLPassthruChanged", null);
    }

    public boolean isUseBulkload() {
        return this.m_bUseBulkload;
    }

    public void setUseBulkload(boolean bOption) {
        if (this.m_bUseBulkload == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseBulkloadUndoable(this.m_bUseBulkload, bOption));
        }
        this.m_bUseBulkload = bOption;
        this.fireModelChangedEvent("SCDTransform:UseBulkloadChanged", null);
    }

    public boolean isSortTempXref() {
        return this.m_bSortTempXref;
    }

    public void setSortTempXref(boolean bOption) {
        if (this.m_bSortTempXref == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSortTempXrefUndoable(this.m_bSortTempXref, bOption));
        }
        this.m_bSortTempXref = bOption;
        this.fireModelChangedEvent("SCDTransform:SortTempXrefChanged", null);
    }

    public boolean isTargetTblIndexAdd() {
        return this.m_bTargetTblIndexAdd;
    }

    public void setTargetTblIndexAdd(boolean bOption) {
        if (this.m_bTargetTblIndexAdd == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetTblIndexAddUndoable(this.m_bTargetTblIndexAdd, bOption));
        }
        this.m_bTargetTblIndexAdd = bOption;
        this.fireModelChangedEvent("SCDTransform:TargetTblIndexAddChanged", null);
    }

    public boolean isXrefTblIndexAdd() {
        return this.m_bXrefTblIndexAdd;
    }

    public void setXrefTblIndexAdd(boolean bOption) {
        if (this.m_bXrefTblIndexAdd == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetXrefTblIndexAddUndoable(this.m_bXrefTblIndexAdd, bOption));
        }
        this.m_bXrefTblIndexAdd = bOption;
        this.fireModelChangedEvent("SCDTransform:XrefTblIndexAddChanged", null);
    }

    @Override
    public String getSPDSUpdateTechnique() {
        return this.m_sSPDSUpdateTechnique;
    }

    @Override
    public void setSPDSUpdateTechnique(String sOption) {
        if (this.m_sSPDSUpdateTechnique.equalsIgnoreCase(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSPDSUpdateTechniqueUndoable(this.m_sSPDSUpdateTechnique, sOption));
        }
        this.m_sSPDSUpdateTechnique = sOption;
        this.fireModelChangedEvent("SCDTransform:SPDSUpdateTechniqueChanged", this.m_sSPDSUpdateTechnique);
    }

    public boolean isSPDS() {
        Object table;
        boolean bSPDS = false;
        List lSources = this.getDataSourceList();
        if (lSources != null && lSources.size() > 0 && (table = lSources.get(0)) instanceof IPhysicalTable) {
            if (this.getDataTarget() == null) {
                return false;
            }
            bSPDS = "SAS SPDS".equals(((IPhysicalTable)this.getDataTarget()).getDBMSType().getDBMSTypeName());
        }
        return bSPDS;
    }

    @Override
    public String getChangeDigestVersion() {
        return this.m_sChangeDigestVersion;
    }

    @Override
    public void setChangeDigestVersion(String sOption) {
        if (this.m_sChangeDigestVersion.equalsIgnoreCase(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetChangeDigestVersionUndoable(this.m_sChangeDigestVersion, sOption));
        }
        this.m_sChangeDigestVersion = sOption;
        this.fireModelChangedEvent("SCDTransform:ChangeDigestVersionChanged", this.m_sChangeDigestVersion);
    }

    public IDataObject getDataTarget() {
        if (this.getDataTargetsCount() > 0) {
            return this.getDataTargets()[0];
        }
        return null;
    }

    @Override
    public String getTempTableLibref() {
        return this.m_sTempTableLibref;
    }

    @Override
    public void setTempTableLibref(String sOption) {
        if (this.m_sTempTableLibref.equalsIgnoreCase(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTempTableLibrefUndoable(this.m_sTempTableLibref, sOption));
        }
        this.m_sTempTableLibref = sOption;
        this.fireModelChangedEvent("SCDTransform:TempTableLibrefChanged", this.m_sTempTableLibref);
    }

    @Override
    public boolean isCloseRecsNotInSource() {
        return this.m_bCloseRecsNotInSource;
    }

    @Override
    public void setCloseRecsNotInSource(boolean bOption) {
        if (this.m_bCloseRecsNotInSource == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCloseRecsNotInSourceUndoable(this.m_bCloseRecsNotInSource, bOption));
        }
        this.m_bCloseRecsNotInSource = bOption;
        this.fireModelChangedEvent("SCDTransform:CloseRecsNotInSourceChanged", null);
    }

    @Override
    public ILibrary getUploadLibrary() {
        return this.m_uploadLibrary;
    }

    @Override
    public void setUploadLibrary(ILibrary library) {
        if (this.m_uploadLibrary == library) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUploadLibraryUndoable(this.m_uploadLibrary, library));
        }
        this.m_uploadLibrary = library;
        this.fireModelChangedEvent("SCDTransformModel.UploadLibraryChanged", null);
    }

    @Override
    public boolean isMultiUpdatesPerDayAllowed() {
        return this.m_bMultiUpdatesPerDay;
    }

    @Override
    public void setMultiUpdatesPerDayAllowed(boolean bOption) {
        if (this.m_bMultiUpdatesPerDay == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMultiUpdatesPerDayAllowedUndoable(this.m_bMultiUpdatesPerDay, bOption));
        }
        this.m_bMultiUpdatesPerDay = bOption;
        this.fireModelChangedEvent("SCDTransform:MultiUpdatesPerDayAllowedChanged", null);
    }

    @Override
    public boolean isIndexAddedToUpdateTempTable() {
        return this.m_bTempUpdateTblIndex;
    }

    @Override
    public void setIndexAddedToUpdateTempTable(boolean bOption) {
        if (this.m_bTempUpdateTblIndex == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIndexAddedToUpdateTempTableUndoable(this.m_bTempUpdateTblIndex, bOption));
        }
        this.m_bTempUpdateTblIndex = bOption;
        this.fireModelChangedEvent("SCDTransform:TempUpdateTableIndexChnaged", null);
    }

    public boolean isUseIndexIfReadingSasds() {
        return this.m_bUseIndexIfReadingSasds;
    }

    public void setUseIndexIfReadingSasds(boolean bOption) {
        if (this.m_bUseIndexIfReadingSasds == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseIndexIfReadingSasdsUndoable(this.m_bUseIndexIfReadingSasds, bOption));
        }
        this.m_bUseIndexIfReadingSasds = bOption;
        this.fireModelChangedEvent("SCDTransformModel.UsePermXrefIndexIfSasdsChanged", null);
    }

    @Override
    public boolean isTrackChangesByDates() {
        return this.m_bTrackChangesByDates;
    }

    @Override
    public void setTrackChangesByDates(boolean bValue) {
        if (this.m_bTrackChangesByDates == bValue) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTrackChangesByDatesUndoable(this.m_bTrackChangesByDates, bValue));
        }
        this.m_bTrackChangesByDates = bValue;
        this.fireModelChangedEvent("SCDTransform:TrackByDatesChanged", null);
    }

    @Override
    public IColumn getFromDateColumn() {
        return this.m_fromDateColumn;
    }

    @Override
    public void setFromDateColumn(IColumn column) {
        if (this.m_fromDateColumn == column) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFromDateColumnUndoable(this.m_fromDateColumn, column));
        }
        this.m_fromDateColumn = column;
        this.fireModelChangedEvent("SCDTransform:FromDateColumnChanged", this.m_fromDateColumn);
    }

    @Override
    public IColumn getToDateColumn() {
        return this.m_toDateColumn;
    }

    @Override
    public void setToDateColumn(IColumn column) {
        if (this.m_toDateColumn == column) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetToDateColumnUndoable(this.m_toDateColumn, column));
        }
        this.m_toDateColumn = column;
        this.fireModelChangedEvent("SCDTransform:ToDateColumnChanged", this.m_toDateColumn);
    }

    @Override
    public ITextExpression getFromDateExpression() {
        return this.m_fromDateExpression;
    }

    @Override
    public void setFromDateExpression(ITextExpression expression) {
        if (this.m_fromDateExpression != null && this.m_fromDateExpression.equals(expression)) {
            return;
        }
        if (this.m_fromDateExpression != null) {
            this.addToDeletedObjects(this.m_fromDateExpression);
            this.m_fromDateExpression.removeNotifyListener(this);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFromDateExpressionUndoable(this.m_fromDateExpression, expression));
        }
        if (expression != null) {
            this.removeFromDeletedObjects(expression);
        }
        this.m_fromDateExpression = expression;
        if (this.m_fromDateExpression != null) {
            this.m_fromDateExpression.addNotifyListener(this);
        }
        this.fireModelChangedEvent("SCDTransform:FromDateExpressionChanged", this.m_fromDateExpression);
    }

    @Override
    public ITextExpression getToDateExpression() {
        return this.m_toDateExpression;
    }

    @Override
    public void setToDateExpression(ITextExpression expression) {
        if (this.m_toDateExpression != null && this.m_toDateExpression.equals(expression)) {
            return;
        }
        if (this.m_toDateExpression != null) {
            this.addToDeletedObjects(this.m_toDateExpression);
            this.m_toDateExpression.removeNotifyListener(this);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetToDateExpressionUndoable(this.m_toDateExpression, expression));
        }
        if (expression != null) {
            this.removeFromDeletedObjects(expression);
        }
        this.m_toDateExpression = expression;
        if (this.m_toDateExpression != null) {
            this.m_toDateExpression.addNotifyListener(this);
        }
        this.fireModelChangedEvent("SCDTransform:ToDateExpressionChanged", this.m_toDateExpression);
    }

    @Override
    public void addBusinessKeyColumn(IColumn column) {
        if (!this.m_mlBusinessKeyColumns.contains(column)) {
            this.m_mlBusinessKeyColumns.add(this.m_mlBusinessKeyColumns.size(), column);
        }
    }

    @Override
    public void addBusinessKeyColumn(int index, IColumn column) {
        if (!this.m_mlBusinessKeyColumns.contains(column)) {
            this.m_mlBusinessKeyColumns.add(index, column);
        }
    }

    @Override
    public List getBusinessKeyColumnsList() {
        return this.m_mlBusinessKeyColumns;
    }

    @Override
    public IColumn[] getBusinessKeyColumns() {
        return this.m_mlBusinessKeyColumns.toArray(new IColumn[this.m_mlBusinessKeyColumns.size()]);
    }

    @Override
    public void removeBusinessKeyColumn(IColumn column) {
        this.m_mlBusinessKeyColumns.remove(column);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        IMapping fromMapping;
        super.loadFromOMR(omr);
        this.m_mlBusinessKeyColumns.clear();
        this.loadBusinessKeyColumns(omr);
        this.setDateFormatType(this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_DATE_FORMAT_TYPE, DEFAULT_DATE_FORMAT_TYPE, 2));
        this.setSQLOptions(this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_SQL_OPTIONS, "", 2));
        this.setTempTableLibref(this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_TEMP_TABLE_LIBREF, "", 2));
        this.setXrefTableName(this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_XREF_TABLE_NAME, "", 2));
        String sCloseRecsNotInSource = this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_CLOSE_RECS_NOT_IN_SOURCE, SCD_OPTION_FALSE, 2);
        this.setCloseRecsNotInSource(sCloseRecsNotInSource.equalsIgnoreCase(SCD_OPTION_TRUE));
        String sUseSQLPassthru = this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_USE_SQL_PASSTHRU, SCD_OPTION_TRUE, 2);
        this.setUseSQLPassthru(sUseSQLPassthru.equalsIgnoreCase(SCD_OPTION_TRUE));
        String sAllowMultiUpdates = this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_ALLOW_MULTI_UPDATES_PER_DAY, SCD_OPTION_FALSE, 2);
        this.setMultiUpdatesPerDayAllowed(sAllowMultiUpdates.equalsIgnoreCase(SCD_OPTION_TRUE));
        String sTempTableIndex = this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_TEMP_TABLE_INDEX_ADD, SCD_OPTION_FALSE, 2);
        this.setIndexAddedToUpdateTempTable(sTempTableIndex.equalsIgnoreCase(SCD_OPTION_TRUE));
        String sUseIndexIfReadingSasds = this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_USE_PERM_XREF_INDEX_IF_SASDS, SCD_OPTION_FALSE, 2);
        this.setUseIndexIfReadingSasds(sUseIndexIfReadingSasds.equalsIgnoreCase(SCD_OPTION_TRUE));
        String sUseBulkload = this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_USE_BULKLOAD, SCD_OPTION_TRUE, 2);
        this.setUseBulkload(sUseBulkload.equalsIgnoreCase(SCD_OPTION_TRUE));
        String sSortTempXref = this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_SORT_TEMP_XREF, SCD_OPTION_FALSE, 2);
        this.setSortTempXref(sSortTempXref.equalsIgnoreCase(SCD_OPTION_TRUE));
        String sTargetTblIndexAdd = this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_TARGET_TABLE_INDEX_ADD, SCD_OPTION_TRUE, 2);
        this.setTargetTblIndexAdd(sTargetTblIndexAdd.equalsIgnoreCase(SCD_OPTION_TRUE));
        String sXrefTblIndexAdd = this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_XREF_TABLE_INDEX_ADD, SCD_OPTION_TRUE, 2);
        this.setXrefTblIndexAdd(sXrefTblIndexAdd.equalsIgnoreCase(SCD_OPTION_TRUE));
        this.setSPDSUpdateTechnique(this.loadStringOptionFromOMR(omr, OPTION_NAME_SPDS_UPDATE_TECHNIQUE, SPDS_UPDATE_TECHNIQUE_SQL));
        this.setChangeDigestVersion(this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_CHANGE_DIGEST_VERSION, DEFAULT_CHANGE_DIGEST_VERSION, 2));
        this.setCloseRecordsWorkTableOptions(this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_CLOSE_RECORDS_WORK_TABLE_OPTIONS, "", 2));
        this.setMatchRecordsWorkTableOptions(this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_MATCH_RECORDS_WORK_TABLE_OPTIONS, "", 2));
        this.setNewRecordsWorkTableOptions(this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_NEW_RECORDS_WORK_TABLE_OPTIONS, "", 2));
        this.setType1RecordsWorkTableOptions(this.loadPropertyFromOMR(omr, "OPTIONS", OPTION_NAME_TYPE1_RECORDS_WORK_TABLE_OPTIONS, "", 2));
        IPersistableObject[] librarys = this.loadOptionWithCustomListFromOMR(omr, "OPTIONS", OPTION_NAME_UPLOAD_LIBRARY, "");
        if (librarys != null && librarys.length > 0) {
            this.setUploadLibrary((ILibrary)librarys[0]);
        }
        if ((fromMapping = this.findTargetMapping(FROM_DATE_TRANSFORMROLE)) != null) {
            IMapping toMapping;
            this.setTrackChangesByDates(true);
            IColumn[] fromTargets = fromMapping.getTargets();
            if (fromTargets.length > 0) {
                this.m_fromDateColumn = fromTargets[0];
            }
            this.m_fromDateExpression = (ITextExpression)fromMapping.getExpression();
            if (this.m_fromDateExpression != null) {
                this.m_fromDateExpression.addNotifyListener(this);
            }
            if ((toMapping = this.findTargetMapping(TO_DATE_TRANSFORMROLE)) != null) {
                IColumn[] toTargets = toMapping.getTargets();
                if (toTargets.length > 0) {
                    this.m_toDateColumn = toTargets[0];
                }
                this.m_toDateExpression = (ITextExpression)toMapping.getExpression();
                if (this.m_toDateExpression != null) {
                    this.m_toDateExpression.addNotifyListener(this);
                }
            }
        } else {
            this.setTrackChangesByDates(false);
            if (this.m_fromDateExpression == null) {
                this.m_fromDateExpression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
            }
            this.m_fromDateExpression.setText(DEFAULT_FROMDATE_EXP, new IColumn[0]);
            this.m_fromDateExpression.addNotifyListener(this);
            if (this.m_toDateExpression == null) {
                this.m_toDateExpression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
            }
            this.m_toDateExpression.setText(DEFAULT_TODATE_EXP, new IColumn[0]);
            this.m_toDateExpression.addNotifyListener(this);
        }
        this.setChanged(false);
    }

    protected void loadBusinessKeyColumns(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] iPersistableObjectArray;
        if (!this.isChanged()) {
            return;
        }
        this.cleanupMappings();
        super.saveToOMR(omr);
        this.saveBusinessKeyColumns(omr);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_DATE_FORMAT_TYPE, OPTION_NAME_DATE_FORMAT_TYPE, PROPERTY_ROLE_DATE_FORMAT_TYPE, this.m_sDateFormatType, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_SQL_OPTIONS, OPTION_NAME_SQL_OPTIONS, OPTION_NAME_SQL_OPTIONS, this.m_sSQLOptions, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_TEMP_TABLE_LIBREF, OPTION_NAME_TEMP_TABLE_LIBREF, OPTION_NAME_TEMP_TABLE_LIBREF, this.m_sTempTableLibref, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_XREF_TABLE_NAME, OPTION_NAME_XREF_TABLE_NAME, PROPERTY_ROLE_XREF_TABLE_NAME, this.m_sXrefTableName, 12, 2);
        String sUseSQLPassthru = this.isSQLPassthru() ? SCD_OPTION_TRUE : SCD_OPTION_FALSE;
        String sCloseRecsNotInSource = this.isCloseRecsNotInSource() ? SCD_OPTION_TRUE : SCD_OPTION_FALSE;
        String sMultiUpdatesPerDay = this.isMultiUpdatesPerDayAllowed() ? SCD_OPTION_TRUE : SCD_OPTION_FALSE;
        String sUpdateTableIndex = this.isIndexAddedToUpdateTempTable() ? SCD_OPTION_TRUE : SCD_OPTION_FALSE;
        String sUseIndexIfReadeingSasds = this.isUseIndexIfReadingSasds() ? SCD_OPTION_TRUE : SCD_OPTION_FALSE;
        String sUseBulkload = this.isUseBulkload() ? SCD_OPTION_TRUE : SCD_OPTION_FALSE;
        String sSortTempXref = this.isSortTempXref() ? SCD_OPTION_TRUE : SCD_OPTION_FALSE;
        String sTargetTblIndexAdd = this.isTargetTblIndexAdd() ? SCD_OPTION_TRUE : SCD_OPTION_FALSE;
        String sXrefTblIndexAdd = this.isXrefTblIndexAdd() ? SCD_OPTION_TRUE : SCD_OPTION_FALSE;
        this.savePropertyToOMR(omr, "OPTIONS", NAME_SQL_PASSTHRU, OPTION_NAME_USE_SQL_PASSTHRU, OPTION_NAME_USE_SQL_PASSTHRU, sUseSQLPassthru, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_CLOSE_RECS_NOT_IN_SOURCE, OPTION_NAME_CLOSE_RECS_NOT_IN_SOURCE, OPTION_NAME_CLOSE_RECS_NOT_IN_SOURCE, sCloseRecsNotInSource, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_MULTI_UPDATE_ALLOWED, OPTION_NAME_ALLOW_MULTI_UPDATES_PER_DAY, OPTION_NAME_ALLOW_MULTI_UPDATES_PER_DAY, sMultiUpdatesPerDay, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_ADD_INDEX_TEMP_TABLE, OPTION_NAME_TEMP_TABLE_INDEX_ADD, OPTION_NAME_TEMP_TABLE_INDEX_ADD, sUpdateTableIndex, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_USE_PERM_XREF_INDEX_IF_SASDS, OPTION_NAME_USE_PERM_XREF_INDEX_IF_SASDS, OPTION_NAME_USE_PERM_XREF_INDEX_IF_SASDS, sUseIndexIfReadeingSasds, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_USE_BULKLOAD, OPTION_NAME_USE_BULKLOAD, OPTION_NAME_USE_BULKLOAD, sUseBulkload, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_SORT_TEMP_XREF, OPTION_NAME_SORT_TEMP_XREF, OPTION_NAME_SORT_TEMP_XREF, sSortTempXref, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_TARGET_TABLE_INDEX_ADD, OPTION_NAME_TARGET_TABLE_INDEX_ADD, OPTION_NAME_TARGET_TABLE_INDEX_ADD, sTargetTblIndexAdd, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_XREF_TABLE_INDEX_ADD, OPTION_NAME_XREF_TABLE_INDEX_ADD, OPTION_NAME_XREF_TABLE_INDEX_ADD, sXrefTblIndexAdd, 12, 2);
        this.saveStringOptionToOMR(omr, OPTION_NAME_SPDS_UPDATE_TECHNIQUE, this.m_sSPDSUpdateTechnique);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_CHANGE_DIGEST_VERSION, OPTION_NAME_CHANGE_DIGEST_VERSION, OPTION_NAME_CHANGE_DIGEST_VERSION, this.m_sChangeDigestVersion, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_CLOSE_RECORDS_WORK_TABLE_OPTIONS, OPTION_NAME_CLOSE_RECORDS_WORK_TABLE_OPTIONS, OPTION_NAME_CLOSE_RECORDS_WORK_TABLE_OPTIONS, this.m_sCloseRecordsWorkTableOptions, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_MATCH_RECORDS_WORK_TABLE_OPTIONS, OPTION_NAME_MATCH_RECORDS_WORK_TABLE_OPTIONS, OPTION_NAME_MATCH_RECORDS_WORK_TABLE_OPTIONS, this.m_sMatchRecordsWorkTableOptions, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_NEW_RECORDS_WORK_TABLE_OPTIONS, OPTION_NAME_NEW_RECORDS_WORK_TABLE_OPTIONS, OPTION_NAME_NEW_RECORDS_WORK_TABLE_OPTIONS, this.m_sNewRecordsWorkTableOptions, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", NAME_TYPE1_RECORDS_WORK_TABLE_OPTIONS, OPTION_NAME_TYPE1_RECORDS_WORK_TABLE_OPTIONS, OPTION_NAME_TYPE1_RECORDS_WORK_TABLE_OPTIONS, this.m_sType1RecordsWorkTableOptions, 12, 2);
        ILibrary uploadLibrary = this.getUploadLibrary();
        if (uploadLibrary == null) {
            iPersistableObjectArray = new IPersistableObject[]{};
        } else {
            IPersistableObject[] iPersistableObjectArray2 = new IPersistableObject[1];
            iPersistableObjectArray = iPersistableObjectArray2;
            iPersistableObjectArray2[0] = uploadLibrary;
        }
        IPersistableObject[] aObjects = iPersistableObjectArray;
        this.saveOptionWithCustomListToOMR(omr, "OPTIONS", OPTION_NAME_UPLOAD_LIBRARY, "", aObjects);
        this.setChanged(false);
    }

    protected void saveBusinessKeyColumns(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected void saveMappingsToOMR(OMRAdapter omr, ClassifierMap mdoCM, ITable tblTarget) throws MdException, RemoteException {
        if (this.isTrackChangesByDates() && this.m_fromDateColumn != null && this.m_toDateColumn != null) {
            IMapping mapping = this.findTargetMapping(FROM_DATE_TRANSFORMROLE);
            if (mapping == null) {
                IMapping fromDateMapping = this.createNewMapping();
                fromDateMapping.setName(FROM_DATE_MAP_NAME);
                fromDateMapping.setDescription(FROM_DATE_MAP_DESC);
                fromDateMapping.setType(FROM_DATE_TRANSFORMROLE);
                fromDateMapping.setExpression(this.m_fromDateExpression);
                fromDateMapping.addTarget(this.m_fromDateColumn);
                this.addMapping(fromDateMapping);
            } else {
                if (!mapping.containsInTargets(this.m_fromDateColumn)) {
                    if (mapping.getTargetCount() > 0) {
                        mapping.replaceTargetColumn(mapping.getTargets()[0], this.m_fromDateColumn);
                    } else if (mapping.getTargetCount() == 0) {
                        mapping.addTarget(this.m_fromDateColumn);
                    }
                }
                mapping.setExpression(this.m_fromDateExpression);
            }
            mapping = this.findTargetMapping(TO_DATE_TRANSFORMROLE);
            if (mapping == null) {
                IMapping toDateMapping = this.createNewMapping();
                toDateMapping.setName(TO_DATE_MAP_NAME);
                toDateMapping.setDescription(TO_DATE_MAP_DESC);
                toDateMapping.setType(TO_DATE_TRANSFORMROLE);
                toDateMapping.setExpression(this.m_toDateExpression);
                toDateMapping.addTarget(this.m_toDateColumn);
                this.addMapping(toDateMapping);
            } else {
                if (!mapping.containsInTargets(this.m_toDateColumn)) {
                    if (mapping.getTargetCount() > 0) {
                        mapping.replaceTargetColumn(mapping.getTargets()[0], this.m_toDateColumn);
                    } else if (mapping.getTargetCount() == 0) {
                        mapping.addTarget(this.m_toDateColumn);
                    }
                }
                mapping.setExpression(this.m_toDateExpression);
            }
        }
        super.saveMappingsToOMR(omr, mdoCM, tblTarget);
    }

    protected IMapping findTargetMapping(String sTransformRole) {
        ArrayList<IMapping> lMappings = new ArrayList<IMapping>(Arrays.asList(this.getSpecialMappings()));
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            String OMRTransformRole = mapping.getType();
            if (OMRTransformRole.length() <= 0 || !OMRTransformRole.equals(sTransformRole)) continue;
            return mapping;
        }
        return null;
    }

    public static boolean isFromDateColumnInList(List alColumns, IColumn column) {
        for (int i = 0; i < alColumns.size(); ++i) {
            IColumn colInList = (IColumn)alColumns.get(i);
            if (colInList != column) continue;
            return true;
        }
        return false;
    }

    protected String makeAnEqualJoinWhereClause(List columnsList, boolean usePassThru, String spacesToIndentNextLines, String tableAlias1, String tableAlias2, ICodeSegment codeSegment) {
        return this.makeAnEqualJoinWhereClause(columnsList, usePassThru, spacesToIndentNextLines, tableAlias1, tableAlias2, codeSegment, true);
    }

    protected String makeAnEqualJoinWhereClause(List columnsList, boolean usePassThru, String spacesToIndentNextLines, String tableAlias1, String tableAlias2, ICodeSegment codeSegment, boolean includeWhere) {
        StringBuffer string = new StringBuffer();
        int spacesLength = spacesToIndentNextLines.length();
        if (tableAlias1 != null) {
            if (tableAlias1.length() > 0 && (tableAlias1.contains("&") || tableAlias1.charAt(tableAlias1.trim().length() - 1) != '.')) {
                tableAlias1 = tableAlias1.concat(".");
            }
        } else {
            tableAlias1 = "";
        }
        if (tableAlias2 != null) {
            if (tableAlias2.length() > 0 && (tableAlias2.contains("&") || tableAlias2.charAt(tableAlias2.trim().length() - 1) != '.')) {
                tableAlias2 = tableAlias2.concat(".");
            }
        } else {
            tableAlias2 = "";
        }
        if (columnsList.size() > 0 && includeWhere) {
            string.append(" where ");
        }
        for (int i = 0; i < columnsList.size(); ++i) {
            IColumn col = (IColumn)columnsList.get(i);
            String colName = col.getColumnName(codeSegment, usePassThru);
            if (i == 0) {
                string.append(tableAlias1).append(colName).append(" = ").append(tableAlias2).append(colName).append("\n");
                continue;
            }
            string.append(spacesToIndentNextLines).append("   and ").append(tableAlias1).append(colName);
            if (colName.length() * 2 + spacesLength + 9 > 80) {
                string.append("\n").append(spacesToIndentNextLines);
            }
            string.append(" = ").append(tableAlias2).append(colName);
            string.append("\n");
        }
        return string.toString();
    }

    protected String makeAnEqualJoinWhereClause(List columnsList, boolean usePassThru, String spacesToIndentNextLines, String tableAlias1, String tableAlias2, ICodeSegment codeSegment, boolean includeWhere, String schemaName) {
        StringBuffer string = new StringBuffer();
        int spacesLength = spacesToIndentNextLines.length();
        if (tableAlias1 != null && tableAlias1.trim().length() > 0) {
            if (schemaName != null && schemaName.trim().length() > 0) {
                if (schemaName.charAt(schemaName.trim().length() - 1) != '.') {
                    schemaName = schemaName.concat(".");
                }
                tableAlias1 = schemaName + tableAlias1;
            }
            if (tableAlias1.contains("&") || tableAlias1.charAt(tableAlias1.trim().length() - 1) != '.') {
                tableAlias1 = tableAlias1.concat(".");
            }
        } else {
            tableAlias1 = "";
        }
        if (tableAlias2 != null && tableAlias2.trim().length() > 0) {
            if (schemaName != null && schemaName.trim().length() > 0) {
                if (schemaName.charAt(schemaName.trim().length() - 1) != '.') {
                    schemaName = schemaName.concat(".");
                }
                tableAlias2 = schemaName + tableAlias2;
            }
            if (tableAlias2.contains("&") || tableAlias2.charAt(tableAlias2.trim().length() - 1) != '.') {
                tableAlias2 = tableAlias2.concat(".");
            }
        } else {
            tableAlias2 = "";
        }
        if (columnsList.size() > 0 && includeWhere) {
            string.append(" where ");
        }
        for (int i = 0; i < columnsList.size(); ++i) {
            IColumn col = (IColumn)columnsList.get(i);
            String colName = col.getColumnName(codeSegment, usePassThru);
            if (i == 0) {
                string.append(tableAlias1).append(colName).append(" = ").append(tableAlias2).append(colName).append("\n");
                continue;
            }
            string.append(spacesToIndentNextLines).append("   and ").append(tableAlias1).append(colName);
            if (colName.length() * 2 + spacesLength + 9 > 80) {
                string.append("\n").append(spacesToIndentNextLines);
            }
            string.append(" = ").append(tableAlias2).append(colName);
            string.append("\n");
        }
        return string.toString();
    }

    protected boolean isSQLPassThruEnabled(ILibrary library) {
        return this.m_bUseSQLPassthru && library.getDBMSType().isPassThroughSupported();
    }

    protected boolean useTempLibrary(ICodeSegment codeSegment) throws BadLibraryDefinitionException {
        boolean bUseTempLibrary = false;
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        ILibrary targetLibrary = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        IDBMSType targetDBMSType = targetTable.getDBMSType();
        ILibrary upLoadLibrary = this.getUploadLibrary();
        String engine = targetLibrary.getEngine();
        boolean usePassThru = this.isSQLPassThruEnabled(targetLibrary);
        boolean targetLibraryPreassigned = targetLibrary.isPreAssigned();
        boolean tempTableSupport = false;
        tempTableSupport = targetDBMSType.getDBMSTypeName().equals("SAS SPDS") ? true : targetDBMSType.isDBMSTempSupported();
        if (tempTableSupport && !targetLibraryPreassigned && usePassThru && upLoadLibrary == null) {
            bUseTempLibrary = true;
        }
        return bUseTempLibrary;
    }

    protected ICodeSegment genCreateTargetTable(ICodeSegment codeSegment) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        codeSegment.addCommentLine("Create miscellaneous loader macros ").addSourceCode("%global etls_tableExist;\n").addSourceCode("%global etls_numIndex;\n").addSourceCode("%global etls_lastTable;\n").addSourceCode("%let etls_tableExist = -1; \n").addSourceCode("%let etls_numIndex = -1; \n").addSourceCode("%let etls_lastTable = &SYSLAST; \n\n").addSectionComment("Define load data macro").addSourceCode("\n");
        ITransformTableOptions sourceTableOptions = this.getTableOptionObject(source, true);
        String sSrcTableOptions = sourceTableOptions.getTableOptions(codeSegment.getCurrentServer());
        if (sSrcTableOptions != null && sSrcTableOptions.length() > 0) {
            codeSegment.addSourceCode("%let etls_tableOptions = %nrquote(").addSourceCode(sSrcTableOptions).addSourceCode(");\n\n");
        } else {
            codeSegment.addSourceCode("%let etls_tableOptions = ;\n\n");
        }
        IColumn loadTimeColumn = this.getLoadTimeColumn();
        if (loadTimeColumn != null) {
            codeSegment.addSectionComment("Set the load time column");
            String dtFormat = this.getJob().isUsingNLSDateFormat() ? "nldatm." : "datetime.";
            codeSegment.addSourceCode("%let etls_jobLoadTime = &SYSDATE9.:&SYSTIME;\n").addSourceCode("%let etls_loadTime = &etls_jobLoadTime; \n").addSourceCode("data _null_;\n").indent().addSourceCode("_loadtime = input(\"&etls_LoadTime\",DATETIME20.);\n").genPutStatement("The load time is:", "NOTE:", "_loadtime " + dtFormat, false).unIndent().addSourceCode("run;\n\n");
        }
        target.genTableExist(codeSegment);
        if (this.isTargetTblIndexAdd()) {
            target.getDBMSType().create(codeSegment, target, true, this.isConstraintEnabled(), this.isIndexEnabled(), true, "", this);
        } else {
            target.getDBMSType().create(codeSegment, target, true, this.isConstraintEnabled(), false, true, "", this);
        }
        return codeSegment;
    }

    private boolean isIndexEnabled() {
        boolean bEnabled = false;
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            bEnabled = dataTarget.getDBMSType().isIndexSupported() && !dataTarget.getDBMSType().getIndexesToCreate(dataTarget).isEmpty();
        }
        return bEnabled;
    }

    private boolean isConstraintEnabled() {
        boolean bEnabled = false;
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            bEnabled = dataTarget.getDBMSType().isConstraintSupported() && dataTarget.hasConstraints();
        }
        return bEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPhysicalTable genCreatePermanentXRefTable(ICodeSegment codeSegment, List lXrefColumns, List lIndexColumns, boolean hasDigestValue) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String sXrefTableName = this.getXrefTableName();
        int iTwoLevel = sXrefTableName.indexOf(".");
        if (iTwoLevel > -1) {
            sXrefTableName = sXrefTableName.substring(iTwoLevel + 1);
        }
        boolean bEventsEnabled = this.getModel().isModelEventsEnabled();
        boolean bUndoSupported = this.getModel().isUndoSupported();
        this.getModel().setModelEventsEnabled(false);
        this.getModel().setUndoSupported(false);
        try {
            IPhysicalTable xRefTable = this.getModel().getObjectFactory().createNewPhysicalTable(this.getID());
            xRefTable.setCompressed(false);
            xRefTable.setEncrypted(false);
            xRefTable.setSASTableName(sXrefTableName);
            IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
            xRefTable.setCaseSensitive(targetTable.isCaseSensitive());
            xRefTable.setSpecialCharacters(targetTable.isSpecialCharacters());
            xRefTable.setLibrary(targetTable.getCodeGenLibrary(codeSegment.getCurrentServer()));
            for (int i = 0; i < lXrefColumns.size(); ++i) {
                IColumn targetColumn = (IColumn)lXrefColumns.get(i);
                IColumn xRefColumn = this.getModel().getObjectFactory().createNewColumn(this.getID());
                targetColumn.deepCopy(xRefColumn);
                xRefTable.addColumn(xRefColumn);
            }
            if (hasDigestValue) {
                IColumn newColumn = this.getModel().getObjectFactory().createNewColumn(this.getID());
                newColumn.setName(DIGESTCOLNAME);
                newColumn.setLength(32);
                newColumn.setType(0);
                newColumn.setInformat("$32.");
                newColumn.setFormat("$32.");
                newColumn.setNullable(true);
                xRefTable.addColumn(newColumn);
            }
            IIndex xRefIndex = null;
            if (lIndexColumns.size() > 0) {
                xRefIndex = this.getModel().getObjectFactory().createNewIndex(this.getID());
                xRefIndex.setUnique(true);
                IColumn[] lNewXRefColumns = xRefTable.getColumns();
                for (int index = 0; index < lIndexColumns.size(); ++index) {
                    for (int xRefColsIndex = 0; xRefColsIndex < lNewXRefColumns.length; ++xRefColsIndex) {
                        if (!((IColumn)lIndexColumns.get(index)).getColumnName(false).equalsIgnoreCase(lNewXRefColumns[xRefColsIndex].getColumnName(false))) continue;
                        IColumn indexColumn = lNewXRefColumns[xRefColsIndex];
                        xRefIndex.getColumnsList().add(indexColumn);
                        indexColumn.setNullable(false);
                    }
                }
                if (lIndexColumns.size() == 1 && xRefTable.getDBMSType().isMatchingSimpleIndexNameRequired()) {
                    xRefIndex.setName(((IColumn)lIndexColumns.get(0)).getName());
                } else {
                    xRefIndex.setName("XRef" + codeSegment.getUniqueWorkTableName());
                }
                xRefTable.getIndexesList().add(xRefIndex);
            }
            xRefTable.genTableExist(codeSegment);
            if (this.isXrefTblIndexAdd()) {
                xRefTable.getDBMSType().create(codeSegment, xRefTable, true, false, true, true, "", this);
            } else {
                xRefTable.getDBMSType().create(codeSegment, xRefTable, true, false, false, true, "", this);
            }
            this.addToDeletedObjects(xRefTable);
            if (xRefIndex != null) {
                this.addToDeletedObjects(xRefTable);
            }
            IPhysicalTable iPhysicalTable = xRefTable;
            return iPhysicalTable;
        }
        finally {
            this.getModel().setModelEventsEnabled(bEventsEnabled);
            this.getModel().setUndoSupported(bUndoSupported);
        }
    }

    protected String genCreateTempXrefTable(String targetDSName, List busKeyList, List primaryKeyList, IColumn currentIndColumn, IColumn versNumColumn, boolean isRetainedKey, boolean hasDigestValue, String digestValues, String sXrefDSName, ICodeSegment codeSegment, String sTargetEngine, String digestValuesType1, String currentIndicatorYesValue, String currentIndicatorNoValue) throws MdException, RemoteException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        boolean useByStmtProcessing = true;
        if (sXrefDSName == null) {
            sXrefDSName = WORKTEMPXREF;
        }
        if (sXrefDSName.length() == 0) {
            sXrefDSName = WORKTEMPXREF;
        }
        codeSegment.addCommentLine("Remove any existing temporary cross reference file").genTableDelete(sXrefDSName);
        String sByBusKey = codeSegment.makeColumnList(busKeyList, "      ", codeSegment.isQuoting());
        IPhysicalTable target = this.getTargetTable();
        String sTargetReadOnlyOptions = target.getReadTableOptions(true);
        if (hasDigestValue) {
            String extraByColumnName = "";
            if (versNumColumn != null) {
                extraByColumnName = versNumColumn.getColumnName(codeSegment);
            } else if (this.isTrackChangesByDates() && this.m_toDateColumn != null) {
                extraByColumnName = this.getToDateColumn().getColumnName(codeSegment);
            }
            String sourceTableForMD5DataStep = targetDSName + " " + sTargetReadOnlyOptions;
            if (!sTargetEngine.equalsIgnoreCase("BASE") && this.isSortTempXref()) {
                codeSegment.addCommentLine("Sort target table records before creating the temporary cross reference table:");
                String targetTableReadOnlyOptions = this.getTargetTable().getReadTableOptions(false);
                if (currentIndColumn != null) {
                    codeSegment.addSourceCode("proc sort data = " + targetDSName + "(where = (" + currentIndColumn.getColumnName(codeSegment) + " = 1)");
                    if (targetTableReadOnlyOptions != null && targetTableReadOnlyOptions.trim().length() > 0) {
                        codeSegment.newLine();
                        codeSegment.addSourceCode(targetTableReadOnlyOptions);
                    }
                    codeSegment.addSourceCode(")");
                } else {
                    codeSegment.addSourceCode("proc sort data = " + targetDSName);
                    if (targetTableReadOnlyOptions != null && targetTableReadOnlyOptions.trim().length() > 0) {
                        codeSegment.addSourceCode("(" + targetTableReadOnlyOptions + ")");
                    }
                }
                codeSegment.newLine();
                codeSegment.indent().addSourceCode("\nout = ").addSourceCode(sXrefDSName).addSourceCode(";\n").addSourceCode("by ").addSourceCode(sByBusKey).addSourceCode(" ");
                codeSegment.addSourceCode(extraByColumnName).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
                sourceTableForMD5DataStep = sXrefDSName;
            }
            if (currentIndColumn == null) {
                if (sTargetEngine.equalsIgnoreCase("BASE") && !this.isUseIndexIfReadingSasds()) {
                    codeSegment.addCommentLine("Sort target table").addSourceCode("proc sort data = ").addSourceCode(targetDSName);
                    if (sTargetReadOnlyOptions.length() > 0) {
                        codeSegment.addSourceCode("\n").addSourceCode(sTargetReadOnlyOptions).addSourceCode("\n");
                    }
                    codeSegment.indent().addSourceCode("\nout = ").addSourceCode(sXrefDSName).addSourceCode(";\n").addSourceCode("by ").addSourceCode(sByBusKey).addSourceCode(" ");
                    codeSegment.addSourceCode(extraByColumnName).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
                    sourceTableForMD5DataStep = sXrefDSName;
                }
            } else if (sTargetEngine.equalsIgnoreCase("BASE") && !this.isUseIndexIfReadingSasds()) {
                useByStmtProcessing = false;
            }
            String keyList = "";
            if (primaryKeyList != null && primaryKeyList.size() > 0) {
                keyList = codeSegment.makeColumnList(primaryKeyList, "   ", codeSegment.isQuoting());
            }
            boolean bGenType1Digest = false;
            if (!digestValuesType1.equals("") && digestValuesType1.length() > 0) {
                bGenType1Digest = true;
            }
            this.genDigestValue(digestValues, sourceTableForMD5DataStep, sXrefDSName, keyList, busKeyList, currentIndColumn, versNumColumn, this.getFromDateColumn(), this.getToDateColumn(), true, codeSegment, bGenType1Digest, digestValuesType1, useByStmtProcessing, currentIndicatorYesValue, currentIndicatorNoValue);
            if (!useByStmtProcessing) {
                codeSegment.addCommentLine("Sort temporary cross reference table").addSourceCode("proc sort data = ").addSourceCode(sXrefDSName).indent().addSourceCode(";\n").addSourceCode("by ").addSourceCode(sByBusKey).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
            }
            return sXrefDSName;
        }
        if (currentIndColumn != null) {
            codeSegment.addSourceCode("data ").addSourceCode(sXrefDSName).addSourceCode(";\n").indent().addSourceCode("set ").addSourceCode(targetDSName);
            if (sTargetReadOnlyOptions.length() > 0) {
                codeSegment.addSourceCode("\n").addSourceCode(sTargetReadOnlyOptions).addSourceCode("\n");
            }
            codeSegment.addSourceCode(";\n").addSourceCode("where ").addSourceCode(currentIndColumn.getColumnName(codeSegment)).addSourceCode(" eq 1;\n").unIndent().addSourceCode("run;\n\n");
        } else {
            if (sTargetEngine.equals("BASE") && !this.isUseIndexIfReadingSasds()) {
                codeSegment.addCommentLine("Sort target table").addSourceCode("proc sort data = ").addSourceCode(targetDSName);
                if (sTargetReadOnlyOptions.length() > 0) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetReadOnlyOptions).addSourceCode("\n");
                }
                codeSegment.indent().addSourceCode("\nout = ").addSourceCode(sXrefDSName).addSourceCode(";\n").addSourceCode("by ").addSourceCode(sByBusKey).addSourceCode(" ");
                String savedColumnName = "";
                if (versNumColumn != null) {
                    savedColumnName = versNumColumn.getColumnName(codeSegment);
                } else if (this.m_toDateColumn != null) {
                    savedColumnName = this.getToDateColumn().getColumnName(codeSegment);
                }
                codeSegment.addSourceCode(savedColumnName).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
            }
            IColumn lastBKColumn = (IColumn)busKeyList.get(busKeyList.size() - 1);
            String keyList = "";
            if (primaryKeyList != null && primaryKeyList.size() > 0) {
                keyList = codeSegment.makeColumnList(primaryKeyList, "   ", codeSegment.isQuoting());
            }
            codeSegment.addCommentLine("Get the last key variable in each set of keys").addSourceCode("data ").addSourceCode(sXrefDSName).addSourceCode("; \n").indent();
            if (sTargetEngine.equals("BASE") && !this.isUseIndexIfReadingSasds()) {
                codeSegment.addSourceCode("set ").addSourceCode(sXrefDSName);
            } else {
                codeSegment.addSourceCode("set ").addSourceCode(targetDSName);
                if (sTargetReadOnlyOptions.length() > 0) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetReadOnlyOptions).addSourceCode("\n");
                }
            }
            codeSegment.addSourceCode("(keep = ").addSourceCode(keyList);
            codeSegment.addSourceCode(" ").addSourceCode(sByBusKey).addSourceCode("\n");
            if (this.m_fromDateColumn != null) {
                String fromDateName = this.getFromDateColumn().getColumnName(codeSegment);
                if (!isRetainedKey) {
                    codeSegment.addSourceCode(" ").addSourceCode(fromDateName).addSourceCode("\n");
                }
            }
            if (this.m_toDateColumn != null) {
                String toDateName = this.getToDateColumn().getColumnName(codeSegment);
                codeSegment.addSourceCode(toDateName);
            }
            codeSegment.addSourceCode(");\n");
            codeSegment.addSourceCode("by ").addSourceCode(sByBusKey);
            if (this.m_toDateColumn != null) {
                codeSegment.addSourceCode(" ").addSourceCode(this.getToDateColumn().getColumnName(codeSegment));
            }
            codeSegment.addSourceCode(";\n");
            if (!codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if last.").addSourceCode(lastBKColumn.getColumnName(codeSegment)).addSourceCode(";\n");
            } else {
                codeSegment.addSourceCode("if \"last.").addSourceCode(lastBKColumn.getColumnName(false)).addSourceCode("\"n;\n");
            }
            codeSegment.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        }
        return sXrefDSName;
    }

    protected void genDigestValue(String digestValues, String inputTableDSName, String outputTableDSName, String primaryKeys, List<IColumn> busKeyList, IColumn currIndColumn, IColumn versNumColumn, IColumn fromDateColumn, IColumn toDateColumn, boolean keepEndDate, ICodeSegment codeSegment, boolean genType1Digest, String digestValuesType1, boolean useByStmtProcessing, String currentIndicatorYesValue, String currentIndicatorNoValue) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String sBusKey = codeSegment.makeColumnList(busKeyList, "      ", codeSegment.isQuoting());
        IColumn lastBKColumn = busKeyList.get(busKeyList.size() - 1);
        String sByCols = sBusKey;
        String sKeepCols = primaryKeys + " " + sBusKey;
        String sFromDateName = "";
        String sToDateName = "";
        if (versNumColumn != null) {
            String sVersColumnName = versNumColumn.getColumnName(codeSegment);
            if (currIndColumn == null) {
                sByCols = sByCols + " " + sVersColumnName;
            }
            sKeepCols = sKeepCols + " " + sVersColumnName;
        } else if (toDateColumn != null && this.isTrackChangesByDates() && currIndColumn == null) {
            sToDateName = toDateColumn.getColumnName(codeSegment);
            sByCols = sByCols + " " + sToDateName;
        }
        if (fromDateColumn != null && this.isTrackChangesByDates()) {
            sFromDateName = fromDateColumn.getColumnName(codeSegment);
            sKeepCols = sKeepCols + " " + sFromDateName;
        }
        if (toDateColumn != null && this.isTrackChangesByDates() && keepEndDate) {
            sToDateName = toDateColumn.getColumnName(codeSegment);
            sKeepCols = sKeepCols + " " + sToDateName;
        }
        if (this.getChangeDigestVersion().equalsIgnoreCase(DEFAULT_CHANGE_DIGEST_VERSION)) {
            codeSegment.addCommentLine("Generate change digest (v1.1) ");
            codeSegment.addSourceCode("data ").addSourceCode(outputTableDSName);
            codeSegment.addSourceCode("(KEEP = ");
            codeSegment.addSourceCode(sKeepCols).addSourceCode(" DIGEST_VALUE");
            if (genType1Digest) {
                codeSegment.addSourceCode(" DIGEST_VALUE_TYPE1");
            }
            codeSegment.addSourceCode(" );\n").indent();
            String xrefTableName = this.getXrefTableName();
            if (xrefTableName != null && xrefTableName.trim().length() > 0) {
                String targetTableReadOnlyOptions = this.getTargetTable().getReadTableOptions(false);
                if (targetTableReadOnlyOptions != null && targetTableReadOnlyOptions.trim().length() > 0) {
                    String targetTableName = this.getTargetTable().getFullNameQuotedAsNeeded(codeSegment);
                    codeSegment.addSourceCode("set " + targetTableName);
                    codeSegment.addSourceCode(this.getTargetTable().getReadTableOptions(true) + ";");
                    codeSegment.newLine();
                } else {
                    String targetTableName = this.getTargetTable().getFullNameQuotedAsNeeded(codeSegment);
                    codeSegment.addSourceCode("set " + targetTableName).addSourceCode(";\n");
                }
            } else {
                codeSegment.addSourceCode("set ").addSourceCode(inputTableDSName).addSourceCode(";\n");
            }
            if (currIndColumn != null && !this.isSortTempXref()) {
                codeSegment.addSourceCode("where ").addSourceCode(currIndColumn.getColumnName(codeSegment)).addSourceCode(" = 1;\n");
            }
            if (useByStmtProcessing) {
                codeSegment.addSourceCode("by ").addSourceCode(sByCols).addSourceCode(";\n");
            }
            codeSegment.addSourceCode("length etls_md5 $16.;\n").addSourceCode("length DIGEST_VALUE $32.;\n");
            if (genType1Digest) {
                codeSegment.addSourceCode("length DIGEST_VALUE_TYPE1 $32.;\n");
            }
            if (useByStmtProcessing) {
                if (!codeSegment.isQuoting()) {
                    codeSegment.addSourceCode("if last.").addSourceCode(lastBKColumn.getColumnName(false)).addSourceCode(";\n");
                } else {
                    codeSegment.addSourceCode("if \"last.").addSourceCode(lastBKColumn.getColumnName(false)).addSourceCode("\"n;\n");
                }
            }
            codeSegment.addSourceCode("etls_str = '\"' ||").addSourceCode(digestValues).addSourceCode("|| '\"';\n").addSourceCode("etls_md5 = MD5(etls_str);\n").addSourceCode("DIGEST_VALUE=put(etls_md5, hex32.);\n");
            if (genType1Digest) {
                codeSegment.addSourceCode("etls_str_type1 = '\"' ||").addSourceCode(digestValuesType1).addSourceCode("|| '\"';\n").addSourceCode("etls_md5 = MD5(etls_str_type1);\n").addSourceCode("DIGEST_VALUE_TYPE1 = put(etls_md5, $hex32.);\n");
            }
        } else if (this.getChangeDigestVersion().equalsIgnoreCase("V2_1") || this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) {
            if (this.getChangeDigestVersion().equalsIgnoreCase("V2_1")) {
                codeSegment.addCommentLine("Generate change digest (v2.1) ");
            } else if (this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) {
                codeSegment.addCommentLine("Generate change digest (v2.2) ");
            }
            codeSegment.addSourceCode("data ").addSourceCode(outputTableDSName);
            codeSegment.addSourceCode("(keep = ").addSourceCode(sKeepCols).addSourceCode(" DIGEST_VALUE");
            if (genType1Digest) {
                codeSegment.addSourceCode(" DIGEST_VALUE_TYPE1");
            }
            codeSegment.addSourceCode(" );").newLine().indent();
            codeSegment.addSourceCode("length DIGEST_VALUE $32.");
            if (genType1Digest) {
                codeSegment.addSourceCode(" DIGEST_VALUE_TYPE1 $32.");
            }
            codeSegment.addSourceCode(";").newLine();
            codeSegment.addSourceCode("set ").addSourceCode(inputTableDSName).addSourceCode(";").newLine();
            if (currIndColumn != null && !this.isSortTempXref()) {
                codeSegment.newLine();
                codeSegment.addSourceCode("where " + currIndColumn.getColumnName(codeSegment));
                codeSegment.addSourceCode(" = " + currentIndicatorYesValue + ";");
                codeSegment.newLine();
            }
            if (useByStmtProcessing) {
                codeSegment.addSourceCode("by ").addSourceCode(sByCols).addSourceCode(";").newLine();
                if (!codeSegment.isQuoting()) {
                    codeSegment.addSourceCode("if last.").addSourceCode(lastBKColumn.getColumnName(false)).addSourceCode(";\n");
                } else {
                    codeSegment.addSourceCode("if \"last.").addSourceCode(lastBKColumn.getColumnName(false)).addSourceCode("\"n;\n");
                }
                codeSegment.addSourceCode("if last.").addSourceCode(lastBKColumn.getColumnName(false)).addSourceCode(";").newLine();
            }
            codeSegment.addSourceCode("DIGEST_VALUE = ").addSourceCode(digestValues).newLine();
            if (genType1Digest) {
                codeSegment.addSourceCode("DIGEST_VALUE_TYPE1 = ").addSourceCode(digestValuesType1).newLine();
            }
        }
        codeSegment.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syscc");
    }

    protected void genDigestValue(String digestValues, String inputTableDSName, String outputTableDSName, ICodeSegment codeSegment, boolean genType1Digest, String digestValuesType1) {
        if (this.getChangeDigestVersion().equalsIgnoreCase(DEFAULT_CHANGE_DIGEST_VERSION)) {
            codeSegment.addCommentLine("Generate change digest (v1.1)").addSourceCode("data ").addSourceCode(outputTableDSName).addSourceCode("(drop=etls_str etls_md5 ");
            if (genType1Digest) {
                codeSegment.addSourceCode(" etls_str_type1 ");
            }
            codeSegment.addSourceCode(");\n").indent().addSourceCode("set ").addSourceCode(inputTableDSName).addSourceCode(";\n").addSourceCode("length etls_md5 $16.;\n").addSourceCode("length DIGEST_VALUE $32.;\n");
            if (genType1Digest) {
                codeSegment.addSourceCode("length DIGEST_VALUE_TYPE1 $32.;\n");
            }
            codeSegment.addSourceCode("etls_str = '\"' ||").addSourceCode(digestValues).addSourceCode("|| '\"';\n").addSourceCode("etls_md5 = MD5(etls_str);\n").addSourceCode("DIGEST_VALUE=put(etls_md5, hex32.);\n");
            if (genType1Digest) {
                codeSegment.addSourceCode("etls_str_type1 = '\"' ||").addSourceCode(digestValuesType1).addSourceCode("|| '\"';\n").addSourceCode("etls_md5 = MD5(etls_str_type1);\n").addSourceCode("DIGEST_VALUE_TYPE1 =put(etls_md5, $hex32.);\n");
            }
        } else if (this.getChangeDigestVersion().equalsIgnoreCase("V2_1") || this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) {
            if (this.getChangeDigestVersion().equalsIgnoreCase("V2_1")) {
                codeSegment.addCommentLine("Generate change digest (v2.1) ");
            } else if (this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) {
                codeSegment.addCommentLine("Generate change digest (v2.2) ");
            }
            codeSegment.addSourceCode("data ").addSourceCode(outputTableDSName).addSourceCode(";").newLine();
            codeSegment.indent();
            codeSegment.addSourceCode("length DIGEST_VALUE $32.");
            if (genType1Digest) {
                codeSegment.addSourceCode(" DIGEST_VALUE_TYPE1 $32.");
            }
            codeSegment.addSourceCode(";").newLine();
            codeSegment.addSourceCode("set ").addSourceCode(inputTableDSName).addSourceCode(";").newLine();
            codeSegment.addSourceCode("DIGEST_VALUE = ").addSourceCode(digestValues).newLine();
            if (genType1Digest) {
                codeSegment.addSourceCode("DIGEST_VALUE_TYPE1 = ").addSourceCode(digestValuesType1).newLine();
            }
        }
        codeSegment.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syscc");
    }

    protected void genToDateExpression(ICodeSegment codeSegment) {
        boolean bUseDateTime = true;
        String sFormat = this.m_toDateColumn.getFormat();
        SASFormat sasFormat = null;
        if (sFormat != null && sFormat.length() > 0) {
            sasFormat = SASFormat.getInstance((String)sFormat);
        }
        if (sasFormat != null && sasFormat.isDateFormat()) {
            bUseDateTime = false;
        }
        codeSegment.addCommentLine("Generate the to date expression").addSourceCode("data _null_;\n").addSourceCode("   format todate");
        if (bUseDateTime) {
            codeSegment.addSourceCode(" DATETIME20.");
        } else {
            codeSegment.addSourceCode(" DATE9.");
        }
        codeSegment.addSourceCode(";\n").addSourceCode("   makedate = intnx('year', DATE(), 2000, 'sameday');\n");
        if (bUseDateTime) {
            codeSegment.addSourceCode("   todate = DHMS(makedate,0,0,0);\n");
        } else {
            codeSegment.addSourceCode("  todate = makedate;\n");
        }
        codeSegment.addSourceCode("   call symput(\"").addSourceCode(ENDDATEEXPMACRO).addSourceCode("\", todate);\n").addSourceCode("run;\n\n").genRCSetCall("&syserr");
    }

    protected static void genDateFixerUpperCode(ICodeSegment codeSegment, String fromDateName, String toDateName, List busKeyColumns, String formatDateOption, boolean bMultiUpdatesPerDay) throws MdException, RemoteException {
        String byBusKeyColumns = codeSegment.makeColumnList(busKeyColumns, "   ", codeSegment.isQuoting());
        IColumn lastBusKeyCol = (IColumn)busKeyColumns.get(busKeyColumns.size() - 1);
        String lastBusKeyName = lastBusKeyCol.getColumnName(false);
        codeSegment.addCommentLine("Sort the source table by business key and beginning/from date columns.").addSourceCode("proc sort data=").addSourceCode(WORKSOURCENAME).addSourceCode(";\n").indent().addSourceCode("by ").addSourceCode(byBusKeyColumns).addSourceCode(" ").addSourceCode(fromDateName).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        codeSegment.addSectionComment("Set beginning dates and close out any history records ").addSourceCode("data ").addSourceCode(WORKSOURCENAME).addSourceCode(" (drop = ");
        if (!bMultiUpdatesPerDay) {
            codeSegment.addSourceCode("etls_sameday ");
        }
        codeSegment.addSourceCode("etls_cnt etls_closedate);\n\n").indent().addSourceCode("set ").addSourceCode(WORKSOURCENAME).addSourceCode(";\n").addSourceCode("by ").addSourceCode(byBusKeyColumns).addSourceCode(";\n\n");
        if (formatDateOption.equals(DATE)) {
            codeSegment.addCommentLine("Convert the dates to datetimes if input dates are not null").addSourceCode("if ").addSourceCode(fromDateName).addSourceCode(" ne . then\n").indent().addSourceCode(fromDateName).addSourceCode(" = ").addSourceCode("DHMS(").addSourceCode(fromDateName).addSourceCode(",0,0,0);\n").unIndent().addSourceCode("if ").addSourceCode(toDateName).addSourceCode(" ne . then\n").indent().addSourceCode(toDateName).addSourceCode(" = ").addSourceCode("DHMS(").addSourceCode(toDateName).addSourceCode(",0,0,0);\n\n").unIndent();
        }
        codeSegment.addCommentLine("Set beginning dates if null").addSourceCode("if ").addSourceCode(fromDateName).addSourceCode(" eq . then\n").indent().addSourceCode(fromDateName).addSourceCode(" = &").addSourceCode(BEGDATEEXPMACRO).addSourceCode(";\n\n").unIndent();
        if (codeSegment.isQuoting()) {
            codeSegment.addSourceCode("if \"first.").addSourceCode(lastBusKeyCol.getColumnName(false)).addSourceCode("\"n then\n");
        } else {
            codeSegment.addSourceCode("if first.").addSourceCode(lastBusKeyName).addSourceCode(" then\n");
        }
        codeSegment.indent().addSourceCode("etls_cnt = 0;\n").unIndent().addSourceCode("else\n").indent().addSourceCode("etls_cnt + 1;\n\n").unIndent().addCommentLine("Close out any history records if they exist");
        if (codeSegment.isQuoting()) {
            codeSegment.addSourceCode("if not \"last.").addSourceCode(lastBusKeyCol.getColumnName(false)).addSourceCode("\"n then\n");
        } else {
            codeSegment.addSourceCode("if not last.").addSourceCode(lastBusKeyName).addSourceCode(" then\n");
        }
        codeSegment.addSourceCode("do;\n\n").indent().addSourceCode("obsnum = _n_ + 1;\n").addSourceCode("set ").addSourceCode(WORKSOURCENAME).addSourceCode("(keep = ").addSourceCode(fromDateName).addSourceCode("\n").indent().indent().indent().addSourceCode("rename = (").addSourceCode(fromDateName).addSourceCode(" = etls_closedate))\npoint = obsnum;\n\n").unIndent().unIndent().unIndent();
        if (formatDateOption.equals(DATE)) {
            codeSegment.addSourceCode("if etls_closedate ne . then\n").indent().addSourceCode("etls_closedate = DHMS(etls_closedate,0,0,0);\n\n").unIndent();
        }
        codeSegment.addSourceCode("if etls_closedate eq . then\n").indent().addSourceCode("etls_closedate = &").addSourceCode(BEGDATEEXPMACRO).addSourceCode(";\n\n").unIndent();
        if (!bMultiUpdatesPerDay) {
            codeSegment.addSourceCode("if ").addSourceCode(fromDateName).addSourceCode(" eq etls_closedate then\n").indent().addSourceCode("etls_closedate = etls_closedate + (etls_cnt + 1);\n\n").unIndent();
        }
        codeSegment.addSourceCode("if ").addSourceCode(toDateName).addSourceCode(" eq . then\n").indent().addSourceCode(toDateName).addSourceCode(" = etls_closedate - 1;\n\n").unIndent().unIndent().addSourceCode("end;\n\n");
        if (!bMultiUpdatesPerDay) {
            codeSegment.addCommentLine("Fix the beginning dates if needed").addSourceCode("etls_sameday = lag1(").addSourceCode(fromDateName).addSourceCode(");\n");
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if not \"first.").addSourceCode(lastBusKeyCol.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if not first.").addSourceCode(lastBusKeyName);
            }
            codeSegment.addSourceCode(" and etls_sameday eq ").addSourceCode(fromDateName).addSourceCode(" then\n").indent().addSourceCode(fromDateName).addSourceCode(" = ").addSourceCode(fromDateName).addSourceCode(" + etls_cnt;\n\n").unIndent();
        }
        codeSegment.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
    }

    protected void genGeneratedKeyMaxKey(IColumn maxKeyColumn, ITextExpression maxKeyRowSelector, boolean isNextKeyValue, ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        String whereClause;
        IPhysicalTable table = (IPhysicalTable)maxKeyColumn.getTable();
        String sReadOnlyOptions = table.getReadTableOptions(true);
        codeSegment.addCommentLine("Calculate the max generated key value and hold the value in the macro variable &etls_maxkey").addSourceCode("%let ").addSourceCode(MAXKEYMACRO).addSourceCode(" = -1;\n\n").addSourceCode("proc sql noprint;\n").indent().addSourceCode("select compress(put(max(").addSourceCode(maxKeyColumn.getColumnName(codeSegment)).addSourceCode("), best32.))\n").indent().addSourceCode("into :").addSourceCode(MAXKEYMACRO).addSourceCode("\n").indent().addSourceCode(" from ").addSourceCode(table.getFullNameQuotedAsNeeded(codeSegment));
        if (sReadOnlyOptions.length() > 0) {
            codeSegment.addSourceCode("\n").addSourceCode(sReadOnlyOptions).addSourceCode("\n");
        }
        if (maxKeyRowSelector != null && (whereClause = maxKeyRowSelector.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting())).length() > 0) {
            codeSegment.addSourceCode("\nwhere ").addSourceCode(whereClause);
        }
        codeSegment.addSourceCode(";\n").unIndent().unIndent().addSourceCode("quit;\n\n");
        codeSegment.addCommentLine("If \"etls_maxkey\" does not have a value, then set it to zero.").addSourceCode("%if (&").addSourceCode(MAXKEYMACRO).addSourceCode(" eq .)\n").indent().addSourceCode("%then %let ").addSourceCode(MAXKEYMACRO).addSourceCode(" = 0;\n\n").unIndent();
        if (isNextKeyValue) {
            codeSegment.addCommentLine("The key value returned is the next key to be used, subtract 1 to get the maximum key value").addSourceCode("%let ").addSourceCode(MAXKEYMACRO).addSourceCode(" = %eval(&").addSourceCode(MAXKEYMACRO).addSourceCode(" - 1);\n\n");
        }
        codeSegment.unIndent();
    }

    protected void genUpdateMaxKeyLookupTable(List busKeyColumns, IColumn maxKeyColumn, ITextExpression maxKeyRowSelector, IColumn fromDateColumn, String xrefDSName, boolean isRetainedKey, boolean hasDigestValue, String digestValues, boolean usePassThru, String sourceDSName, ICodeSegment codeSegment) throws BadServerDefinitionException, CodegenException, MdException, RemoteException, BadLibraryDefinitionException, ServerException {
        String selectList = codeSegment.makeColumnList(busKeyColumns, false, "   ", false, ", ", "A", codeSegment.isQuoting(), "   ", false);
        String joinClause = this.makeAnEqualJoinWhereClause(busKeyColumns, false, "   ", "A", "B", codeSegment, false);
        String whereCls = this.makeAnEqualJoinWhereClause(busKeyColumns, false, "   ", "A", "", codeSegment);
        if (isRetainedKey) {
            codeSegment.addCommentLine("Determine the number of retained keys being used").addSourceCode("proc sql noprint;\n").indent().addSourceCode("select compress(put(count(*), best32.))\n").indent().addSourceCode("into :etls_numberused \n").addSourceCode("from \n").indent().addSourceCode("(select distinct ").addSourceCode(selectList).addSourceCode("\n").indent().addSourceCode("from ").addSourceCode(sourceDSName).addSourceCode(" as A\n").addSourceCode("where not exists \n").indent().addSourceCode("(select ").addSourceCode(selectList).indent().addSourceCode("\nfrom ").addSourceCode(xrefDSName).addSourceCode("\n ").addSourceCode(whereCls).addSourceCode("));\n").unIndent().unIndent().unIndent().unIndent().unIndent().unIndent().addSourceCode("quit;\n\n").genRCSetCall("&sqlrc");
        } else {
            codeSegment.addCommentLine("Determine the number of surrogate keys being used").addSourceCode("proc sql noprint;\n").indent().addSourceCode("select compress(put(count(*), best32.))\n").indent().addSourceCode("into :etls_numberused\n").addSourceCode("from ").addSourceCode(sourceDSName).addSourceCode(" as A left join ").addSourceCode(xrefDSName).addSourceCode(" as B\n").addSourceCode("on ").addSourceCode(joinClause).addSourceCode("where A.DIGEST_VALUE ne B.DIGEST_VALUE");
            if (fromDateColumn != null && this.isTrackChangesByDates()) {
                String fromDateName = fromDateColumn.getColumnName(codeSegment, false);
                codeSegment.addSourceCode("\n").indent().addSourceCode(" and A.").addSourceCode(fromDateName).addSourceCode(" > B.").addSourceCode(fromDateName).unIndent();
            }
            codeSegment.addSourceCode(";\n").unIndent().unIndent().addSourceCode("quit;\n\n").genRCSetCall("&sqlrc");
        }
        codeSegment.addCommentLine("Update the generated key lookup table with number used").addSourceCode("%if &etls_numberused gt 0 %then\n").addSourceCode("%do;\n").indent().addSourceCode("proc sql ").addSourceCode(this.m_sSQLOptions).addSourceCode(";\n");
        IPhysicalTable maxKeyTable = (IPhysicalTable)maxKeyColumn.getTable();
        if (usePassThru) {
            this.genConnectStatement(codeSegment, maxKeyTable);
            maxKeyTable.getDBMSType().genExecuteBegin(codeSegment, maxKeyTable, "");
        }
        String maxKeyName = maxKeyColumn.getColumnName(codeSegment.isQuoting(), usePassThru);
        codeSegment.indent().addSourceCode("update ").addSourceCode(maxKeyTable.getFullNameQuotedAsNeeded(codeSegment, usePassThru)).addSourceCode("\n").indent();
        String sMaxKeyWriteOptions = maxKeyTable.getWriteTableOptions(true, "");
        if (!usePassThru && sMaxKeyWriteOptions.length() > 0) {
            codeSegment.addSourceCode(sMaxKeyWriteOptions).addSourceCode("\n");
        }
        codeSegment.addSourceCode("set ").addSourceCode(maxKeyName).addSourceCode(" = ").addSourceCode(maxKeyName).addSourceCode(" + &etls_numberused\n");
        if (maxKeyRowSelector != null && !"".equals(maxKeyRowSelector.getText(null, codeSegment.isQuoting()))) {
            codeSegment.addSourceCode("where ");
            maxKeyRowSelector.getGeneratedCode(codeSegment, usePassThru);
        }
        if (usePassThru) {
            maxKeyTable.getDBMSType().genExecuteEnd(codeSegment, maxKeyTable, "");
            maxKeyTable.getDBMSType().genDisconnect(codeSegment, maxKeyTable);
        } else {
            codeSegment.addSourceCode(";\n");
        }
        codeSegment.unIndent().unIndent().addSourceCode("quit;\n\n").genRCSetCall("&sqlrc").unIndent().addSourceCode("%end;\n\n");
    }

    protected void genCheckForOldMaxKeyMacroUsed(ICodeSegment codeSegment) {
        codeSegment.addCommentLine("Check to see if the old macro variable was used and set to new macro variable").addSourceCode("%if &maxkey ne %str() %then\n").indent().addSourceCode("%if &maxKey > 0 %then\n").indent().addSourceCode("%let ").addSourceCode(MAXKEYMACRO).addSourceCode(" = &maxkey;\n\n").unIndent().unIndent();
    }

    protected void genDateDataMergeStep(List lBusKeyColumns, IColumn currentIndColumn, IColumn versionColumn, boolean bIsRetainedKey, boolean bIsUniqueRetainedKey, IColumn generatedKeyColumn, String sChgRcdExpr, String sNewRcdExpr, boolean bHasDigest, String sSourceDSName, String sXrefDSName, List lType1Columns, ICodeSegment codeSegment, String currentIndicatorYesValue, String currentIndicatorNoValue) throws MdException, RemoteException {
        String sCurrIndColumnName;
        String sToDateInformat;
        String sFromDate = this.m_fromDateColumn.getColumnName(codeSegment);
        String sToDate = this.m_toDateColumn.getColumnName(codeSegment);
        IColumn firstBusKeyColumn = (IColumn)lBusKeyColumns.get(0);
        String firstBusKey = firstBusKeyColumn.getColumnName(codeSegment);
        IColumn lastBusKeyColumn = (IColumn)lBusKeyColumns.get(lBusKeyColumns.size() - 1);
        String lastBusKey = lastBusKeyColumn.getColumnName(codeSegment);
        String strBusKeyColumns = codeSegment.makeColumnList(lBusKeyColumns, " ", codeSegment.isQuoting());
        String sLoadTimeColumnName = "";
        if (this.getLoadTimeColumn() != null) {
            sLoadTimeColumnName = this.getLoadTimeColumn().getColumnName(codeSegment);
        }
        String sGeneratedKeyColumnName = "";
        boolean hasGeneratedKey = false;
        if (generatedKeyColumn != null) {
            hasGeneratedKey = true;
            sGeneratedKeyColumnName = generatedKeyColumn.getColumnName(codeSegment);
        }
        StringBuffer sbDigestValue = new StringBuffer();
        if (codeSegment.isQuoting()) {
            sbDigestValue.append("\"").append(DIGESTCOLNAME).append("\"n");
        } else {
            sbDigestValue.append(DIGESTCOLNAME);
        }
        ArrayList<String> dropList = new ArrayList<String>();
        ArrayList<String> keepList = new ArrayList<String>();
        ArrayList<String> lKeepType1 = new ArrayList<String>();
        StringBuffer retainClause = new StringBuffer();
        if (bHasDigest) {
            dropList.add(TEMPSTGDIGEST);
            dropList.add(DIGESTCOLNAME);
        }
        if (hasGeneratedKey) {
            retainClause.append(TEMPNEWMAXKEY).append(" &etls_maxkey");
            dropList.add(TEMPNEWMAXKEY);
            dropList.add(TEMPGENKEY);
            dropList.add(TEMPFROMDATE);
            keepList.add(TEMPGENKEY);
            lKeepType1.add(TEMPGENKEY);
            if (bIsRetainedKey) {
                keepList.add(TEMPFROMDATE);
                keepList.add(TEMPCLOSEDATE);
                dropList.add(TEMPFROMDATE);
                lKeepType1.add(TEMPFROMDATE);
            } else {
                keepList.add(TEMPCLOSEDATE);
            }
        } else {
            keepList.addAll(lBusKeyColumns);
            lKeepType1.addAll(lBusKeyColumns);
            dropList.add(TEMPFROMDATE);
            keepList.add(TEMPFROMDATE);
            lKeepType1.add(TEMPFROMDATE);
            keepList.add(TEMPCLOSEDATE);
        }
        dropList.add(TEMPCLOSEDATE);
        if (bHasDigest) {
            dropList.add(TEMPTODATE);
        }
        if (this.getLoadTimeColumn() != null) {
            dropList.add(TEMPLOADTIME);
            keepList.add(TEMPLOADTIME);
            lKeepType1.add(TEMPLOADTIME);
        }
        if (versionColumn != null) {
            dropList.add(TEMPNEWVERSNUM);
            retainClause.append(" ").append(TEMPNEWVERSNUM);
        }
        if (lType1Columns != null && lType1Columns.size() > 0) {
            lKeepType1.addAll(lType1Columns);
            dropList.add(TEMPTYPE1DIGEST);
            dropList.add(TYPE1DIGESTCOLNAME);
        }
        if (this.isMultiUpdatesPerDayAllowed() && !this.getTransformRole().equalsIgnoreCase("KeyEffDateLoader")) {
            dropList.add("recordClosed");
        }
        String dropClause = codeSegment.makeColumnList(dropList, "            ", codeSegment.isQuoting());
        String keepClause = codeSegment.makeColumnList(keepList, "            ", codeSegment.isQuoting());
        String sKeepType1Clause = codeSegment.makeColumnList(lKeepType1, "           ", codeSegment.isQuoting());
        codeSegment.addCommentLine("Data merge the cross-reference and source tables").addSourceCode("data ").addSourceCode(WORKETLSNEWRCD).addSourceCode("\n").indent().indent().addSourceCode(" (drop = ").addSourceCode(dropClause).addSourceCode(")\n").unIndent().addSourceCode(WORKETLSMATCH).addSourceCode("\n").indent().addSourceCode(" (drop = ").addSourceCode(dropClause).addSourceCode(")\n").unIndent().addSourceCode(WORKETLSCLOSE).addSourceCode("\n").indent().addSourceCode(" (keep = ").addSourceCode(keepClause).addSourceCode(")\n").unIndent();
        if (lType1Columns != null && lType1Columns.size() > 0) {
            codeSegment.addSourceCode(WORKETLSTYPE1).addSourceCode("\n").indent().addSourceCode(" (keep = ").addSourceCode(sKeepType1Clause).addSourceCode(")\n").unIndent();
        }
        codeSegment.addSourceCode(";\n");
        if (retainClause.length() > 0) {
            codeSegment.addSourceCode("retain ").addSourceCode(retainClause).addSourceCode(";\n\n");
        }
        codeSegment.addSourceCode("merge ").addSourceCode(sSourceDSName).addSourceCode("(in=inSort ");
        if (bHasDigest) {
            codeSegment.addSourceCode("rename=(").addSourceCode(sbDigestValue).addSourceCode(" = ").addSourceCode(TEMPSTGDIGEST);
            if (lType1Columns != null && lType1Columns.size() > 0) {
                codeSegment.addSourceCode(" ").addSourceCode(TYPE1DIGESTCOLNAME).addSourceCode(" = ").addSourceCode(TEMPTYPE1DIGEST);
            }
            codeSegment.addSourceCode("))\n");
        } else {
            codeSegment.addSourceCode(")\n");
        }
        codeSegment.indent().addSourceCode(sXrefDSName).addSourceCode(" (in=inXref ").addSourceCode("rename=(\n");
        if (hasGeneratedKey) {
            codeSegment.addSourceCode(sGeneratedKeyColumnName).addSourceCode(" = ").addSourceCode(TEMPGENKEY).addSourceCode("\n");
        }
        codeSegment.indent().indent().addSourceCode(sFromDate).addSourceCode(" = ").addSourceCode(TEMPFROMDATE).addSourceCode("\n");
        if (bHasDigest) {
            codeSegment.addSourceCode(sToDate).addSourceCode(" = ").addSourceCode(TEMPTODATE);
        }
        codeSegment.addSourceCode("));\n").unIndent().unIndent().unIndent().addSourceCode("by " + strBusKeyColumns + ";\n\n");
        codeSegment.addSourceCode("attrib ").addSourceCode(TEMPCLOSEDATE).addSourceCode(" length=8");
        String sToDateFormat = this.m_toDateColumn.getFormat();
        if (sToDateFormat.length() > 0) {
            codeSegment.addSourceCode(" format = ").addSourceCode(sToDateFormat);
        }
        if ((sToDateInformat = this.m_toDateColumn.getInformat()).length() > 0) {
            codeSegment.addSourceCode(" informat = ").addSourceCode(sToDateInformat);
        }
        codeSegment.addSourceCode(";\n");
        String sLoadTimeColumnFormat = "";
        String sLoadTimeColumnInformat = "";
        if (this.getLoadTimeColumn() != null) {
            codeSegment.addSourceCode(";\n").addSourceCode("attrib ").addSourceCode(TEMPLOADTIME).addSourceCode(" length=8");
            sLoadTimeColumnFormat = this.getLoadTimeColumn().getFormat();
            if (sLoadTimeColumnFormat.length() < 1) {
                sLoadTimeColumnFormat = "datetime20.";
            }
            codeSegment.addSourceCode(" format = ").addSourceCode(sLoadTimeColumnFormat);
            sLoadTimeColumnInformat = this.getLoadTimeColumn().getInformat();
            if (sLoadTimeColumnInformat.length() < 1) {
                sLoadTimeColumnInformat = "datetime20.";
            }
            codeSegment.addSourceCode(" informat = ").addSourceCode(sLoadTimeColumnInformat).addSourceCode(";\n");
        }
        codeSegment.addSourceCode("\n");
        if (this.isMultiUpdatesPerDayAllowed() && !this.getTransformRole().equalsIgnoreCase("KeyEffDateLoader")) {
            codeSegment.addCommentLine("For each new business key, initialize the record closed to false.").addSourceCode("retain recordClosed;\n");
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"first.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if first.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then\n").indent().addSourceCode(" recordClosed = 0;\n\n").unIndent();
        }
        codeSegment.addCommentLine("Process changes made to existing records").addSourceCode("if inSort and inXref then\n").addSourceCode("do;\n\n").indent();
        if (versionColumn != null) {
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"first.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if first.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then\n").indent().addSourceCode(TEMPNEWVERSNUM).addSourceCode(" = ").addSourceCode(versionColumn.getColumnName(codeSegment)).addSourceCode(";\n\n").unIndent();
        }
        if (currentIndColumn != null) {
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
            }
            sCurrIndColumnName = currentIndColumn.getColumnName(codeSegment);
            codeSegment.addSourceCode(" then");
            codeSegment.newLine();
            codeSegment.indent();
            codeSegment.addSourceCode(sCurrIndColumnName).addSourceCode(" = " + currentIndicatorYesValue + ";");
            codeSegment.newLine();
            codeSegment.unIndent();
            codeSegment.addSourceCode("else");
            codeSegment.newLine();
            codeSegment.indent();
            codeSegment.addSourceCode(sCurrIndColumnName).addSourceCode(" = " + currentIndicatorNoValue + ";");
            codeSegment.newLine(2);
            codeSegment.unIndent();
        }
        if (bHasDigest) {
            codeSegment.addSourceCode("if ").addSourceCode(TEMPSTGDIGEST).addSourceCode(" NE ").addSourceCode(sbDigestValue).addSourceCode(" then\ndo;\n\n").indent();
            codeSegment.addSourceCode("if ").addSourceCode(sFromDate).addSourceCode(" eq . then\n").indent().addSourceCode(sFromDate).addSourceCode(" = &").addSourceCode(BEGDATEEXPMACRO).addSourceCode(";\n\n").unIndent().addCommentLine("Ignore history records, only accept changes where the cross reference beginning date is less than the source beginning date").addSourceCode("if ").addSourceCode(TEMPFROMDATE);
            if (this.isMultiUpdatesPerDayAllowed()) {
                codeSegment.addSourceCode(" <= ");
            } else {
                codeSegment.addSourceCode(" < ");
            }
            codeSegment.addSourceCode(sFromDate).addSourceCode(" then\ndo;\n\n").indent().addSourceCode("if ").addSourceCode(sToDate).addSourceCode(" eq . then\n").indent().addSourceCode(sToDate).addSourceCode(" = &").addSourceCode(ENDDATEEXPMACRO).addSourceCode(";\n\n").unIndent();
            if (sLoadTimeColumnName.length() > 0) {
                codeSegment.addSourceCode(sLoadTimeColumnName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n").addSourceCode(TEMPLOADTIME).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
            }
            codeSegment.addCommentLine("Save off the close date").addSourceCode("if ").addSourceCode(TEMPTODATE).addSourceCode(" = &").addSourceCode(ENDDATEEXPMACRO).addSourceCode(" or ").addSourceCode(TEMPTODATE).addSourceCode(" > ").addSourceCode(sFromDate).addSourceCode(" then\ndo;\n\n").indent().addSourceCode("if ").addSourceCode(TEMPFROMDATE).addSourceCode(" < ").addSourceCode(sFromDate).addSourceCode(" then\n").indent().addSourceCode(TEMPCLOSEDATE).addSourceCode(" = ").addSourceCode(sFromDate).addSourceCode(" - 1;\n").unIndent().addSourceCode("else ").addSourceCode(TEMPCLOSEDATE).addSourceCode(" = ").addSourceCode(TEMPFROMDATE).addSourceCode(";\n\n");
            if (this.isMultiUpdatesPerDayAllowed()) {
                codeSegment.addSourceCode("if recordClosed = 0 then\ndo;\n\n").indent().addSourceCode("output ").addSourceCode(WORKETLSCLOSE).addSourceCode(";\n").addSourceCode("recordClosed = 1;\n\n").unIndent().addSourceCode("end;\n\n");
            } else {
                codeSegment.addSourceCode("output ").addSourceCode(WORKETLSCLOSE).addSourceCode(";\n\n");
            }
            codeSegment.unIndent().addSourceCode("end;\n\n");
            if (hasGeneratedKey) {
                if (bIsRetainedKey) {
                    codeSegment.addSourceCode(sGeneratedKeyColumnName).addSourceCode(" = ").addSourceCode(TEMPGENKEY).addSourceCode(";\n\n");
                } else {
                    codeSegment.addSourceCode(TEMPNEWMAXKEY).addSourceCode(" = ").addSourceCode(sChgRcdExpr).addSourceCode(";\n").addSourceCode(sGeneratedKeyColumnName).addSourceCode(" = ").addSourceCode(TEMPNEWMAXKEY).addSourceCode(";\n\n");
                }
            }
            codeSegment.addCommentLine("Overwrite the values to compare new records with from cross-reference ").addCommentLine("variable values to the new current values from source").addSourceCode(sbDigestValue).addSourceCode(" = ").addSourceCode(TEMPSTGDIGEST).addSourceCode(";\n").addSourceCode(TEMPFROMDATE).addSourceCode(" = ").addSourceCode(sFromDate).addSourceCode(";\n").addSourceCode(TEMPTODATE).addSourceCode(" = ").addSourceCode(sToDate).addSourceCode(";\n\n");
            if (versionColumn != null) {
                this.genVersionIncrement(versionColumn, lastBusKeyColumn, lastBusKey, codeSegment);
            }
            codeSegment.addSourceCode("output ").addSourceCode(WORKETLSMATCH).addSourceCode(";\n\n").unIndent().addSourceCode("end;\n\n").unIndent().addSourceCode("end;").addCommentLine(" End of digest values not equal ").addSourceCode("\n\n").addSourceCode("else do;\n\n").indent().addSourceCode("if ").addSourceCode(sToDate).addSourceCode(" ne . then\ndo;\n\n").indent().addCommentLine("If the cross-reference end date is greater then the source end date then close out the target record with the source end date");
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then\n").indent().addSourceCode("if ").addSourceCode(TEMPTODATE).addSourceCode(" gt ").addSourceCode(sToDate).addSourceCode(" then\ndo;\n\n").indent().addSourceCode(TEMPCLOSEDATE).addSourceCode(" = ").addSourceCode(sToDate).addSourceCode(";\n");
            if (sLoadTimeColumnName.length() > 0) {
                codeSegment.addSourceCode(TEMPLOADTIME).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
            }
            codeSegment.addSourceCode("output ").addSourceCode(WORKETLSCLOSE).addSourceCode(";\n\n").unIndent().addSourceCode("end;\n\n").unIndent().unIndent().addSourceCode("end;\n\n").addCommentLine("If the source beginning date is greater then both the cross-reference beginning and end date, then reactivate the closed out record").addSourceCode("if ").addSourceCode(sFromDate).addSourceCode(" gt ").addSourceCode(TEMPFROMDATE).addSourceCode(" and\n").indent().addSourceCode(sFromDate).addSourceCode(" gt ").addSourceCode(TEMPTODATE).addSourceCode(" then\n").unIndent().addSourceCode("do;\n\n").indent().addSourceCode("if ").addSourceCode(sToDate).addSourceCode(" eq . then\n").indent().addSourceCode(sToDate).addSourceCode(" = &").addSourceCode(ENDDATEEXPMACRO).addSourceCode(";\n\n").unIndent();
            if (sLoadTimeColumnName.length() > 0) {
                codeSegment.addSourceCode(sLoadTimeColumnName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n");
            }
            if (hasGeneratedKey) {
                if (bIsRetainedKey) {
                    codeSegment.addSourceCode(sGeneratedKeyColumnName).addSourceCode(" = ").addSourceCode(TEMPGENKEY).addSourceCode(";\n\n");
                } else {
                    codeSegment.addSourceCode(TEMPNEWMAXKEY).addSourceCode(" = ").addSourceCode(sChgRcdExpr).addSourceCode(";\n").addSourceCode(sGeneratedKeyColumnName).addSourceCode(" = ").addSourceCode(TEMPNEWMAXKEY).addSourceCode(";\n\n");
                }
            }
            codeSegment.addCommentLine("Update the cross-reference varaibles to the new current values").addSourceCode(sbDigestValue).addSourceCode(" = ").addSourceCode(TEMPSTGDIGEST).addSourceCode(";\n").addSourceCode(TEMPFROMDATE).addSourceCode(" = ").addSourceCode(sFromDate).addSourceCode(";\n").addSourceCode(TEMPTODATE).addSourceCode(" = ").addSourceCode(sToDate).addSourceCode(";\n\n");
            if (versionColumn != null) {
                this.genVersionIncrement(versionColumn, lastBusKeyColumn, lastBusKey, codeSegment);
            }
            codeSegment.addSourceCode("output ").addSourceCode(WORKETLSMATCH).addSourceCode(";\n\n").unIndent().addSourceCode("end;\n\n").unIndent();
            if (lType1Columns != null && lType1Columns.size() > 0) {
                codeSegment.indent().addSourceCode("else do;\n\n").indent().addCommentLine("Output to the type 1 work table if there are type 1 column changes");
                codeSegment.addSourceCode("if ").addSourceCode(TEMPTYPE1DIGEST).addSourceCode(" NE ").addSourceCode(TYPE1DIGESTCOLNAME).addSourceCode(" then\n").indent();
                if (codeSegment.isQuoting()) {
                    codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
                } else {
                    codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
                }
                codeSegment.addSourceCode(" then\ndo;\n").indent();
                if (sLoadTimeColumnName.length() > 0) {
                    codeSegment.addSourceCode(TEMPLOADTIME).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n");
                }
                codeSegment.addSourceCode("output ").addSourceCode(WORKETLSTYPE1).addSourceCode(";\n").unIndent().addSourceCode("end;\n\n").unIndent(2).addSourceCode("end;\n\n ").unIndent();
            }
            codeSegment.addSourceCode("end;  ").addCommentLine("End of digest values are equal").addSourceCode("\n").unIndent().addSourceCode("end;  ").addCommentLine("End of inSort and inXref").addSourceCode("\n");
        } else {
            if (sLoadTimeColumnName.length() > 0) {
                codeSegment.addSourceCode(sLoadTimeColumnName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n").addSourceCode(TEMPLOADTIME).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
            }
            codeSegment.addSourceCode("if ").addSourceCode(sFromDate).addSourceCode(" eq . then\n").indent().addSourceCode(sFromDate).addSourceCode(" = &").addSourceCode(BEGDATEEXPMACRO).addSourceCode(";\n\n").unIndent().addSourceCode("if ").addSourceCode(sToDate).addSourceCode(" ne . then \n").addSourceCode("do;\n\n").indent().addSourceCode("if ").addSourceCode(TEMPFROMDATE).addSourceCode(" gt ").addSourceCode(sToDate).addSourceCode(" then /* history record */\n").addSourceCode("do;\n\n").indent();
            if (versionColumn != null) {
                this.genVersionIncrement(versionColumn, lastBusKeyColumn, lastBusKey, codeSegment);
            }
            codeSegment.addSourceCode("if ").addSourceCode(sFromDate).addSourceCode(" ne . then \n").addSourceCode("do;\n\n").indent().addSourceCode("output ETLS_MATCH;\n\n").unIndent().addSourceCode("end;\n\n").addSourceCode("else do;\n\n").indent().addSourceCode(sFromDate).addSourceCode(" = ").addSourceCode(sToDate).addSourceCode(" - 1;\n").addSourceCode("output ETLS_MATCH;\n\n").unIndent().addSourceCode("end;\n\n").unIndent().addSourceCode("end;\n\n").addSourceCode("else do; /* check if close out */\n\n").indent().addSourceCode("if ").addSourceCode(sFromDate).addSourceCode(" eq . then \n").indent().addSourceCode(sFromDate).addSourceCode(" = &").addSourceCode(BEGDATEEXPMACRO).addSourceCode(";\n").unIndent().addSourceCode(TEMPCLOSEDATE).addSourceCode(" = ").addSourceCode(sFromDate).addSourceCode(" - 1; \n").addSourceCode("if ").addSourceCode(sFromDate).addSourceCode(" ne ").addSourceCode(TEMPFROMDATE).addSourceCode(" then\n").addSourceCode("do; /* close out */\n\n").indent();
            if (versionColumn != null) {
                this.genVersionIncrement(versionColumn, lastBusKeyColumn, lastBusKey, codeSegment);
            }
            codeSegment.addSourceCode("output ETLS_MATCH;\n").addSourceCode("output ETLS_CLOSE;\n\n").unIndent().addSourceCode("end;\n\n").unIndent().addSourceCode("end;\n\n").unIndent().addSourceCode("end;\n\n").addSourceCode("/* end date is missing */\n").addSourceCode("else if ").addSourceCode(sFromDate).addSourceCode(" ne . then\ndo;\n\n").indent().addSourceCode("if ").addSourceCode(sFromDate).addSourceCode(" ne ").addSourceCode(TEMPFROMDATE).addSourceCode(" then\n").addSourceCode("do; /* different beg dates so close out */\n\n").indent().addSourceCode(sToDate).addSourceCode(" = &").addSourceCode(ENDDATEEXPMACRO).addSourceCode(";\n").addSourceCode(TEMPCLOSEDATE).addSourceCode(" = ").addSourceCode(sFromDate).addSourceCode(" - 1; \n\n");
            if (versionColumn != null) {
                this.genVersionIncrement(versionColumn, lastBusKeyColumn, lastBusKey, codeSegment);
            }
            codeSegment.addSourceCode("output ").addSourceCode(WORKETLSMATCH).addSourceCode(";\n").addSourceCode("output ").addSourceCode(WORKETLSCLOSE).addSourceCode(";\n\n").unIndent().addSourceCode("end;\n\n").unIndent();
            if (lType1Columns != null && lType1Columns.size() > 0) {
                codeSegment.addSourceCode("else do;\n\n").indent().addCommentLine("Output to the type 1 work table if there are type 1 column changes");
                codeSegment.addSourceCode("if ").addSourceCode(TEMPTYPE1DIGEST).addSourceCode(" NE ").addSourceCode(TYPE1DIGESTCOLNAME).addSourceCode(" then\n").indent();
                if (codeSegment.isQuoting()) {
                    codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
                } else {
                    codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
                }
                codeSegment.addSourceCode(" then\ndo;\n").indent();
                if (sLoadTimeColumnName.length() > 0) {
                    codeSegment.addSourceCode(TEMPLOADTIME).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");");
                }
                codeSegment.addSourceCode("output ").addSourceCode(WORKETLSTYPE1).addSourceCode(";\n").unIndent().addSourceCode("end;\n\n").unIndent(2).addSourceCode("end; ").addSourceCode("\n").unIndent();
            }
            codeSegment.addSourceCode("end;\n\n").unIndent().addSourceCode("end;\n\n");
        }
        codeSegment.addCommentLine("Process new records").addSourceCode("else if inSort and not inXref then \n").addSourceCode("do;\n\n").indent();
        if (hasGeneratedKey) {
            if (bIsRetainedKey) {
                if (bIsUniqueRetainedKey) {
                    codeSegment.addSourceCode("if ");
                    int maxLength = 70;
                    int line = 3;
                    int lastColumn = lBusKeyColumns.size() - 1;
                    for (int i = 0; i < lBusKeyColumns.size(); ++i) {
                        IColumn col = (IColumn)lBusKeyColumns.get(i);
                        String name = col.getColumnName(codeSegment);
                        int length = name.length() + 1;
                        if (codeSegment.isQuoting()) {
                            codeSegment.addSourceCode("\"first.").addSourceCode(col.getColumnName(false)).addSourceCode("\"n ");
                            length = 8;
                        } else {
                            codeSegment.addSourceCode("first.").addSourceCode(name).addSourceCode(" ");
                            length = 6;
                        }
                        line = length;
                        if (i != lastColumn) {
                            codeSegment.addSourceCode(" or ");
                            line = 4;
                        }
                        if (line <= maxLength) continue;
                        codeSegment.addSourceCode("\n   ");
                        line = 3;
                    }
                } else if (codeSegment.isQuoting()) {
                    codeSegment.addSourceCode("if \"first.").addSourceCode(firstBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
                } else {
                    codeSegment.addSourceCode("if first.").addSourceCode(firstBusKey);
                }
                codeSegment.addSourceCode(" then\n").indent().addSourceCode(TEMPNEWMAXKEY).addSourceCode(" = ").addSourceCode(sNewRcdExpr).addSourceCode(";\n\n").unIndent().addSourceCode(sGeneratedKeyColumnName).addSourceCode(" = ").addSourceCode(TEMPNEWMAXKEY).addSourceCode(";\n\n");
            } else {
                codeSegment.addSourceCode(TEMPNEWMAXKEY).addSourceCode(" = ").addSourceCode(sNewRcdExpr).addSourceCode(";\n\n").addSourceCode(sGeneratedKeyColumnName).addSourceCode(" = ").addSourceCode(TEMPNEWMAXKEY).addSourceCode(";\n\n");
            }
        }
        if (currentIndColumn != null) {
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
            }
            sCurrIndColumnName = currentIndColumn.getColumnName(codeSegment);
            codeSegment.addSourceCode(" then");
            codeSegment.newLine();
            codeSegment.indent();
            codeSegment.addSourceCode(sCurrIndColumnName).addSourceCode(" = " + currentIndicatorYesValue + ";");
            codeSegment.newLine();
            codeSegment.unIndent();
            codeSegment.addSourceCode("else");
            codeSegment.newLine();
            codeSegment.indent();
            codeSegment.addSourceCode(sCurrIndColumnName).addSourceCode(" = " + currentIndicatorNoValue + ";");
            codeSegment.newLine(2);
            codeSegment.unIndent();
        }
        if (versionColumn != null) {
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"first.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if first.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then \n").indent().addSourceCode(TEMPNEWVERSNUM).addSourceCode(" = 0;\n").unIndent();
            this.genVersionIncrement(versionColumn, lastBusKeyColumn, lastBusKey, codeSegment);
        }
        codeSegment.addSourceCode("if ").addSourceCode(sFromDate).addSourceCode(" eq . then\n").indent().addSourceCode(sFromDate).addSourceCode(" = &").addSourceCode(BEGDATEEXPMACRO).addSourceCode(";\n").unIndent().addSourceCode("if ").addSourceCode(sToDate).addSourceCode(" eq . then \n").indent().addSourceCode(sToDate).addSourceCode(" = &").addSourceCode(ENDDATEEXPMACRO).addSourceCode(";\n\n").unIndent();
        if (sLoadTimeColumnName.length() > 0) {
            codeSegment.addSourceCode(sLoadTimeColumnName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
        }
        codeSegment.addSourceCode("output ").addSourceCode(WORKETLSNEWRCD).addSourceCode(";\n\n").unIndent().addSourceCode("end;\n\n");
        if (this.m_bCloseRecsNotInSource) {
            codeSegment.addCommentLine("Close out any records that are in the xref table but not in the source.").addSourceCode("else if inXref and not inSort then\n").indent().addSourceCode("do;\n\n").indent().addSourceCode(TEMPCLOSEDATE).addSourceCode(" = ");
            String sFormat = this.m_toDateColumn.getFormat();
            String sDateExpression = "DATETIME()";
            SASFormat sasFormat = null;
            if (sFormat != null && sFormat.length() > 0) {
                sasFormat = SASFormat.getInstance((String)sFormat);
            }
            if (sasFormat != null && sasFormat.isDateFormat()) {
                sDateExpression = "DATE()";
            }
            codeSegment.addSourceCode(sDateExpression).addSourceCode(";\n\n");
            if (sLoadTimeColumnName.length() > 0) {
                codeSegment.addSourceCode(sLoadTimeColumnName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n").addSourceCode(TEMPLOADTIME).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
            }
            codeSegment.addSourceCode("output ").addSourceCode(WORKETLSCLOSE).addSourceCode(";\n\n").unIndent().addSourceCode("end;\n\n");
        }
        codeSegment.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        codeSegment.addCommentLine("Sort the output from the data merge step").addSourceCode("proc sort data=").addSourceCode(WORKETLSCLOSE).addSourceCode(" nodupkey;\n").indent().addSourceCode("by ");
        if (hasGeneratedKey) {
            if (bIsRetainedKey) {
                codeSegment.addSourceCode(TEMPGENKEY).addSourceCode(" descending ").addSourceCode(TEMPFROMDATE).addSourceCode(";\n");
            } else {
                codeSegment.addSourceCode(TEMPGENKEY).addSourceCode(";\n");
            }
        } else {
            codeSegment.addSourceCode(strBusKeyColumns).addSourceCode(" descending ").addSourceCode(TEMPFROMDATE).addSourceCode(";\n");
        }
        codeSegment.unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
        if (lType1Columns != null && lType1Columns.size() > 0) {
            codeSegment.addSourceCode("proc sort data=").addSourceCode(WORKETLSTYPE1).addSourceCode(" nodupkey;\n").indent().addSourceCode("by ");
            if (hasGeneratedKey) {
                if (bIsRetainedKey) {
                    codeSegment.addSourceCode(TEMPGENKEY).addSourceCode(" descending ").addSourceCode(TEMPFROMDATE).addSourceCode(";\n");
                } else {
                    codeSegment.addSourceCode(TEMPGENKEY).addSourceCode(";\n");
                }
            } else {
                codeSegment.addSourceCode(strBusKeyColumns).addSourceCode(" descending ").addSourceCode(TEMPFROMDATE).addSourceCode(";\n");
            }
            codeSegment.unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
        }
        if (bIsRetainedKey || !hasGeneratedKey) {
            codeSegment.addSourceCode("proc sort data=").addSourceCode(WORKETLSMATCH).addSourceCode(" nodupkey").addSourceCode(";\n").indent().addSourceCode("by ");
            if (hasGeneratedKey) {
                if (bIsRetainedKey) {
                    codeSegment.addSourceCode(sGeneratedKeyColumnName).addSourceCode(" descending ").addSourceCode(sFromDate).addSourceCode(";\n");
                }
            } else {
                codeSegment.addSourceCode(strBusKeyColumns).addSourceCode(" descending ").addSourceCode(sFromDate).addSourceCode(";\n");
            }
            codeSegment.unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
        }
        this.genSaveWorkTableToPermanentLibref(lType1Columns, codeSegment);
        codeSegment.addCommentLine("Save record counts into macros").genGetNumRows(WORKETLSCLOSE, null, "etls_updatecnt", true).genRCSetCall("&syserr").genGetNumRows(WORKETLSMATCH, null, "etls_matchcnt", true).genRCSetCall("&syserr").genGetNumRows(WORKETLSNEWRCD, null, "etls_newcnt", true).genRCSetCall("&syserr");
        if (lType1Columns != null && lType1Columns.size() > 0) {
            codeSegment.genGetNumRows(WORKETLSTYPE1, null, "etls_type1cnt", true).genRCSetCall("&syserr");
        }
    }

    protected void genVersionIncrement(IColumn versionColumn, IColumn lastBusKeyColumn, String lastBusKey, ICodeSegment codeSegment) {
        if (versionColumn != null) {
            String sVersionColumnName = versionColumn.getColumnName(codeSegment);
            codeSegment.addSourceCode(sVersionColumnName).addSourceCode(" = sum(").addSourceCode(TEMPNEWVERSNUM).addSourceCode(",1);\n").addSourceCode(TEMPNEWVERSNUM).addSourceCode(" = ").addSourceCode(sVersionColumnName).addSourceCode(";\n");
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then \n").indent().addSourceCode(TEMPNEWVERSNUM).addSourceCode(" = 0;\n\n").unIndent();
        }
    }

    protected void genSaveWorkTableToPermanentLibref(List lType1Columns, ICodeSegment codeSegment) {
        this.genSaveWorkTableToPermanentLibref(lType1Columns, codeSegment, false);
    }

    protected void genSaveWorkTableToPermanentLibref(List lType1Columns, ICodeSegment codeSegment, boolean bTrackChangesByVersionOnly) {
        if (this.m_sTempTableLibref.length() > 0) {
            String saveClose = this.m_sTempTableLibref + "." + TEMPCLOSETBLNAME;
            String saveMatch = this.m_sTempTableLibref + "." + TEMPMATCHTBLNAME;
            String saveNew = this.m_sTempTableLibref + "." + TEMPNEWRCDTBLNAME;
            String saveType1 = this.m_sTempTableLibref + "." + TEMPTYPE1TBLNAME;
            codeSegment.addCommentLine("Save the insert and update work tables to a permanent location").addSourceCode("%if (%sysfunc(libref(").addSourceCode(this.m_sTempTableLibref.trim()).addSourceCode(")) = 0) %then\n%do;\n");
            if (!bTrackChangesByVersionOnly) {
                codeSegment.indent().genTableDelete(saveClose).addSourceCode("data ").addSourceCode(saveClose).addSourceCode(";\n").indent().addSourceCode("set ").addSourceCode(WORKETLSCLOSE).addSourceCode(";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
            }
            codeSegment.genTableDelete(saveMatch).addSourceCode("data ").addSourceCode(saveMatch).addSourceCode(";\n").indent().addSourceCode("set ").addSourceCode(WORKETLSMATCH).addSourceCode(";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr").genTableDelete(saveNew).addSourceCode("data ").addSourceCode(saveNew).addSourceCode(";\n").indent().addSourceCode("set ").addSourceCode(WORKETLSNEWRCD).addSourceCode(";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
            if (lType1Columns != null && lType1Columns.size() > 0) {
                codeSegment.genTableDelete(saveType1).addSourceCode("data ").addSourceCode(saveType1).addSourceCode(";\n").indent().addSourceCode("set ").addSourceCode(WORKETLSTYPE1).addSourceCode(";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
            }
            codeSegment.unIndent().addSourceCode("%end;\n").addSourceCode("%else %do;\n").indent().genPercentPutStatement("Libref to save the insert and update temporary datasets does not exist", "WARNING%QUOTE(:)").unIndent().addSourceCode("%end;\n\n");
        }
    }

    protected void genCheckUpdateTableStats(String exitLabel, boolean isDates, boolean isCurrentInd, boolean isVersion, boolean hasType1Columns, ICodeSegment codeSegment) {
        codeSegment.addCommentLine("Check to see if the update counts are greater than zero").addSourceCode("%if ");
        if (isDates || isCurrentInd) {
            codeSegment.addSourceCode("&etls_updatecnt le 0 and ");
        }
        codeSegment.addSourceCode("&etls_matchcnt le 0 and &etls_newcnt le 0 ");
        if (hasType1Columns) {
            codeSegment.addSourceCode("and &etls_type1cnt le 0\n");
        } else {
            codeSegment.addSourceCode("\n");
        }
        codeSegment.indent().addSourceCode("%then %goto ").addSourceCode(exitLabel).addSourceCode(";\n\n").unIndent();
    }

    protected void genDateUpdateTargetTable(List keyColumns, boolean usePassThru, IColumn generatedKeyCol, boolean isRetainedKey, IColumn currentIndColumn, List lType1Columns, ICodeSegment codeSegment, String currentIndicatorYesValue, String currentIndicatorNoValue) throws CodegenException, MdException, RemoteException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException {
        codeSegment.addSectionComment("Start of target table update");
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        String sTargetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment, usePassThru);
        ITransformTableOptions targetOptions = this.getTableOptionObject(targetTable, false);
        String sTargetOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
        String sTableAlias = targetTable.getTableName(codeSegment.isQuoting(), usePassThru);
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        boolean needsQuotes = codeSegment.isQuoting();
        boolean DBMSTempLib = false;
        String sToDateColumnName = this.m_toDateColumn.getColumnName(codeSegment, usePassThru);
        String sFromDateColumnName = this.m_fromDateColumn.getColumnName(codeSegment, usePassThru);
        String sGeneratedKeyColumnName = "";
        boolean hasGeneratedKey = false;
        if (generatedKeyCol != null) {
            hasGeneratedKey = true;
            sGeneratedKeyColumnName = generatedKeyCol.getColumnName(codeSegment, usePassThru);
        }
        String sLoadTimeColumnName = "";
        if (this.getLoadTimeColumn() != null) {
            sLoadTimeColumnName = this.getLoadTimeColumn().getColumnName(codeSegment, usePassThru);
        }
        ArrayList<String> lDeleteWorkTables = new ArrayList<String>();
        IDBMSType targetDBMSType = targetTable.getDBMSType();
        String engine = library.getEngine();
        if (targetDBMSType.getDBMSTypeName().equals("SAS") || targetDBMSType.getDBMSTypeName().equals("SAS SPDS") && this.getSPDSUpdateTechnique().equals(SPDS_UPDATE_TECHNIQUE_MODIFY)) {
            if (this.m_bTempUpdateTblIndex) {
                IWorkTable closeTable = this.createTempUpdateWorklTable(TEMPCLOSETBLNAME, keyColumns, hasGeneratedKey, isRetainedKey, new ArrayList());
                closeTable.getDBMSType().createIndexes2(codeSegment, closeTable, null, "");
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    IWorkTable type1Table = this.createTempUpdateWorklTable(TEMPTYPE1TBLNAME, keyColumns, hasGeneratedKey, isRetainedKey, lType1Columns);
                    type1Table.getDBMSType().createIndexes2(codeSegment, type1Table, null, "");
                }
            }
            ArrayList<IColumn> lTargetKeyCols = new ArrayList<IColumn>();
            boolean needFromDate = false;
            if (generatedKeyCol == null) {
                lTargetKeyCols.addAll(keyColumns);
                lTargetKeyCols.add(this.m_fromDateColumn);
                needFromDate = true;
            } else {
                lTargetKeyCols.add(generatedKeyCol);
                if (isRetainedKey) {
                    lTargetKeyCols.add(this.m_fromDateColumn);
                    needFromDate = true;
                }
            }
            String sCurrentIndColumnName = "";
            if (currentIndColumn != null) {
                sCurrentIndColumnName = currentIndColumn.getColumnName(codeSegment);
            }
            this.genUpdateUsingModify(lTargetKeyCols, sGeneratedKeyColumnName, sFromDateColumnName, sToDateColumnName, sCurrentIndColumnName, sLoadTimeColumnName, sTargetDSName, needFromDate, false, lType1Columns, codeSegment, currentIndicatorYesValue, currentIndicatorNoValue);
            lDeleteWorkTables.add(WORKETLSNEWRCD);
            lDeleteWorkTables.add(WORKETLSMATCH);
            lDeleteWorkTables.add(WORKETLSCLOSE);
            if (lType1Columns != null && lType1Columns.size() > 0) {
                lDeleteWorkTables.add(WORKETLSTYPE1);
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(lDeleteWorkTables).unIndent().addSourceCode("%end;\n\n");
        } else {
            String schema;
            String schema2;
            String strWorkNew = codeSegment.getUniqueWorkTableName();
            String strWorkMatch = codeSegment.getUniqueWorkTableName(20);
            String strWorkClose = codeSegment.getUniqueWorkTableName(60);
            String strWorkType1 = codeSegment.getUniqueWorkTableName(100);
            String delWorkNew = "";
            String delWorkMatch = "";
            String delWorkClose = "";
            String delWorkType1 = "";
            ILibrary uploadLibrary = this.getUploadLibrary();
            if (usePassThru) {
                String dbmsNewRcdTblNameUnique;
                String dbmsMatchTblNameUnquoted;
                String dbmsTempCloseUnquoted;
                if (uploadLibrary == null) {
                    if (this.useTempLibrary(codeSegment)) {
                        this.genDBMSTempTableLibname(targetTable, codeSegment);
                        DBMSTempLib = true;
                    } else {
                        uploadLibrary = library;
                    }
                }
                this.genDBMSTempCloseTable(strWorkClose, keyColumns, uploadLibrary, hasGeneratedKey, isRetainedKey, codeSegment);
                String dbmsTempClose = dbmsTempCloseUnquoted = strWorkClose;
                if (needsQuotes) {
                    dbmsTempClose = DBMSNamesUtil.getQuotedString(dbmsTempCloseUnquoted, true);
                }
                strWorkClose = dbmsTempClose;
                String delTemp = dbmsTempCloseUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsTempCloseUnquoted, false);
                }
                delWorkClose = uploadLibrary == null ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                this.genDBMSTempMatchOrNewRecordsTable(strWorkMatch, true, uploadLibrary, codeSegment);
                String dbmsTempMatch = dbmsMatchTblNameUnquoted = strWorkMatch;
                if (needsQuotes) {
                    dbmsTempMatch = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, true);
                }
                strWorkMatch = dbmsTempMatch;
                delTemp = dbmsMatchTblNameUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, false);
                }
                delWorkMatch = uploadLibrary == null ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                this.genDBMSTempMatchOrNewRecordsTable(strWorkNew, false, uploadLibrary, codeSegment);
                String dbmsTempNew = dbmsNewRcdTblNameUnique = strWorkNew;
                if (needsQuotes) {
                    dbmsTempNew = DBMSNamesUtil.getQuotedString(dbmsNewRcdTblNameUnique, true);
                }
                strWorkNew = dbmsTempNew;
                delTemp = dbmsNewRcdTblNameUnique;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsNewRcdTblNameUnique, false);
                }
                delWorkNew = uploadLibrary == null ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    String dbmsType1TblNameUnique;
                    this.genDBMSTempType1Table(strWorkType1, keyColumns, uploadLibrary, hasGeneratedKey, isRetainedKey, lType1Columns, codeSegment);
                    String dbmsTempType1 = dbmsType1TblNameUnique = strWorkType1;
                    if (needsQuotes) {
                        dbmsTempType1 = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, true);
                    }
                    strWorkType1 = dbmsTempType1;
                    delTemp = dbmsType1TblNameUnique;
                    if (needsQuotes) {
                        delTemp = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, false);
                    }
                    delWorkType1 = uploadLibrary == null ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                }
            } else {
                strWorkClose = WORKETLSCLOSE;
                strWorkMatch = WORKETLSMATCH;
                strWorkNew = WORKETLSNEWRCD;
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    strWorkType1 = WORKETLSTYPE1;
                }
            }
            String tempCloseDate = "";
            String tempFromDate = "";
            String tempGenKey = "";
            String tempLoadTime = "";
            if (codeSegment.isQuoting()) {
                tempGenKey = DBMSNamesUtil.getQuotedString(TEMPGENKEY, usePassThru);
                tempCloseDate = DBMSNamesUtil.getQuotedString(TEMPCLOSEDATE, usePassThru);
                tempFromDate = DBMSNamesUtil.getQuotedString(TEMPFROMDATE, usePassThru);
                tempLoadTime = DBMSNamesUtil.getQuotedString(TEMPLOADTIME, usePassThru);
            } else {
                tempGenKey = TEMPGENKEY;
                tempCloseDate = TEMPCLOSEDATE;
                tempFromDate = TEMPFROMDATE;
                tempLoadTime = TEMPLOADTIME;
            }
            String sTableAliasPt = "";
            if (sTableAlias.length() > 0) {
                sTableAliasPt = sTableAlias + ".";
            }
            StringBuffer sbWhereClause = new StringBuffer();
            if (hasGeneratedKey) {
                sbWhereClause.append(tempGenKey).append(" = ").append(sTableAliasPt).append(sGeneratedKeyColumnName);
                if (isRetainedKey) {
                    sbWhereClause.append("\nand ").append(tempFromDate).append(" = ").append(sTableAliasPt).append(sFromDateColumnName);
                }
            } else {
                sbWhereClause.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", sTableAlias, codeSegment, false)).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(tempFromDate).append(" = ").append(sTableAliasPt).append(sFromDateColumnName);
            }
            if (usePassThru) {
                codeSegment.addCommentLine("Update the target table using SQL pass-thru");
            } else {
                codeSegment.addCommentLine("Update the target table");
            }
            codeSegment.addSourceCode("proc sql ").addSourceCode(this.m_sSQLOptions).addSourceCode(";\n").indent().addCommentLine("Close out existing records");
            String uploadSchema = "";
            if (usePassThru) {
                if (uploadLibrary != null) {
                    uploadSchema = uploadLibrary.getDatabaseSchema().getSchemaName();
                    uploadSchema = DBMSNamesUtil.getQuotedName(uploadSchema, needsQuotes, needsQuotes, usePassThru);
                }
                this.genConnectStatement(codeSegment, targetTable);
                if (targetTable.getDBMSType() instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                    codeSegment.newLine().addSourceCode("execute (begin transaction) by ODBC;").newLine(2);
                }
                codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent();
                targetTable.getDBMSType().genExecuteBegin(codeSegment, targetTable, "");
            } else {
                codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent();
            }
            codeSegment.indent().addSourceCode("update ").addSourceCode(sTargetDSName);
            if (sTargetOptions.length() > 0 && !usePassThru) {
                codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
            }
            codeSegment.addSourceCode("\n").indent();
            if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                codeSegment.addSourceCode("from ");
                if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
            }
            codeSegment.addSourceCode("set ");
            if (currentIndColumn != null) {
                codeSegment.addSourceCode(currentIndColumn.getColumnName(needsQuotes, usePassThru)).addSourceCode(" = " + currentIndicatorNoValue + ",\n");
            }
            codeSegment.addSourceCode(sToDateColumnName);
            if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                codeSegment.addSourceCode(" = \n");
            } else {
                codeSegment.addSourceCode(" = (\n");
            }
            codeSegment.indent();
            if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                codeSegment.addSourceCode(tempCloseDate).addSourceCode("\n");
            } else {
                codeSegment.addSourceCode("select ").addSourceCode(tempCloseDate).addSourceCode("\n").indent().addSourceCode("from ");
                if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                } else if (usePassThru && this.useTempLibrary(codeSegment) && engine.startsWith("DB2")) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema2).addSourceCode(".");
                } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema2).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
            }
            codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
            if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                codeSegment.addSourceCode(" \n").unIndent().unIndent();
            } else {
                codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                codeSegment.addSourceCode("where exists ( select 1\n").indent().indent().addSourceCode("from ");
                if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                } else if (usePassThru && this.useTempLibrary(codeSegment) && engine.startsWith("DB2")) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema2).addSourceCode(".");
                } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema2).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkClose).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
            }
            if (usePassThru) {
                targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
            } else {
                codeSegment.addSourceCode(";\n");
            }
            codeSegment.unIndent().genRCSetCall("&sqlrc");
            if (sLoadTimeColumnName.length() > 0) {
                codeSegment.addCommentLine("Update the load time column");
                if (usePassThru) {
                    targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                }
                codeSegment.addSourceCode("update ").addSourceCode(sTargetDSName);
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                }
                codeSegment.addSourceCode("\n").indent();
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode("from ");
                    if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                }
                codeSegment.addSourceCode("set ").addSourceCode(sLoadTimeColumnName);
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(" = \n");
                } else {
                    codeSegment.addSourceCode(" = (\n");
                }
                codeSegment.indent();
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(tempLoadTime).addSourceCode("\n");
                } else {
                    codeSegment.addSourceCode("select ").addSourceCode(tempLoadTime).addSourceCode("\n").indent().addSourceCode("from ");
                    if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    } else if (usePassThru && this.useTempLibrary(codeSegment) && engine.startsWith("DB2")) {
                        codeSegment.addSourceCode("SESSION.");
                    } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                        schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema2).addSourceCode(".");
                    } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                        schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema2).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                }
                codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(" \n").unIndent().unIndent();
                } else {
                    codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                    codeSegment.addSourceCode("where exists ( select 1 \n").indent().indent().addSourceCode("from ");
                    if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    } else if (usePassThru && this.useTempLibrary(codeSegment) && engine.startsWith("DB2")) {
                        codeSegment.addSourceCode("SESSION.");
                    } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                        schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema2).addSourceCode(".");
                    } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                        schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema2).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
                }
                if (usePassThru) {
                    targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n\n");
                }
                codeSegment.genRCSetCall("&sqlrc");
            }
            codeSegment.unIndent().unIndent().unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No records on target table were closed.").addSourceCode("\n").unIndent().addSourceCode("%end;\n");
            if (lType1Columns != null && lType1Columns.size() > 0) {
                codeSegment.addCommentLine("Update the the type 1 column").addSourceCode("%if &etls_type1cnt gt 0 %then\n%do;\n\n").indent();
                for (int index = 0; index < lType1Columns.size(); ++index) {
                    String schema3;
                    IColumn column = (IColumn)lType1Columns.get(index);
                    String sColumnName = "";
                    if (usePassThru) {
                        targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                        sColumnName = column.getColumnName(needsQuotes, true);
                    } else {
                        sColumnName = column.getColumnName(needsQuotes, false);
                    }
                    codeSegment.addSourceCode("update ").addSourceCode(sTargetDSName);
                    if (sTargetOptions.length() > 0 && !usePassThru) {
                        codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                    }
                    codeSegment.addSourceCode("\n").indent();
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode("from ");
                        if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                    }
                    codeSegment.addSourceCode("set ").addSourceCode(sColumnName);
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(" = \n");
                    } else {
                        codeSegment.addSourceCode(" = (\n");
                    }
                    codeSegment.indent();
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(strWorkType1).addSourceCode(".").addSourceCode(sColumnName).addSourceCode("\n");
                    } else {
                        codeSegment.addSourceCode("select ").addSourceCode(sColumnName).addSourceCode("\n").indent().addSourceCode("from ");
                        if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        } else if (usePassThru && this.useTempLibrary(codeSegment) && engine.startsWith("DB2")) {
                            codeSegment.addSourceCode("SESSION.");
                        } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                            schema3 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema3).addSourceCode(".");
                        } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                            schema3 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema3).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                    }
                    codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(" \n").unIndent().unIndent();
                    } else {
                        codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                        codeSegment.addSourceCode("where exists ( select 1 \n").indent().indent().addSourceCode("from ");
                        if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        } else if (usePassThru && this.useTempLibrary(codeSegment) && engine.startsWith("DB2")) {
                            codeSegment.addSourceCode("SESSION.");
                        } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                            schema3 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema3).addSourceCode(".");
                        } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                            schema3 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema3).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkType1).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
                    }
                    if (usePassThru) {
                        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                    } else {
                        codeSegment.addSourceCode(";\n\n");
                    }
                    codeSegment.genRCSetCall("&sqlrc");
                }
                codeSegment.unIndent().unIndent().unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No type1 updates were made to target table.").addSourceCode("\n").unIndent().addSourceCode("%end;\n");
            }
            String selectList = codeSegment.makeColumnList(targetTable, true, "      ", usePassThru, ",", "", needsQuotes, "");
            String colList = codeSegment.makeColumnList(targetTable, false, "      ", usePassThru, ",", "", needsQuotes, "");
            codeSegment.addCommentLine("Insert the new matching records").addSourceCode("%if &etls_matchcnt gt 0 %then\n%do;\n\n").indent();
            if (usePassThru) {
                targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
            }
            codeSegment.addSourceCode("insert into ").addSourceCode(sTargetDSName).addSourceCode("\n").indent().addSourceCode("( ");
            if (sTargetOptions.length() > 0 && !usePassThru) {
                codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(",\n");
            }
            codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("Select ").addSourceCode(selectList).addSourceCode("\n").addSourceCode("from ");
            if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
            } else if (usePassThru && this.useTempLibrary(codeSegment) && engine.startsWith("DB2")) {
                codeSegment.addSourceCode("SESSION.");
            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                codeSegment.addSourceCode(schema).addSourceCode(".");
            } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                codeSegment.addSourceCode(schema).addSourceCode(".");
            }
            codeSegment.addSourceCode(strWorkMatch).unIndent();
            if (usePassThru) {
                targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
            } else {
                codeSegment.addSourceCode(";\n\n");
            }
            codeSegment.genRCSetCall("&sqlrc").unIndent().addSourceCode("%end;\n\n");
            codeSegment.addCommentLine("Insert the new dimension records").addSourceCode("%if &etls_newcnt gt 0 %then\n%do;\n\n").indent();
            if (usePassThru) {
                targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
            }
            codeSegment.addSourceCode("insert into ").addSourceCode(sTargetDSName).addSourceCode("\n").indent().addSourceCode("( ");
            if (sTargetOptions.length() > 0 && !usePassThru) {
                codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(",\n");
            }
            codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("select ").addSourceCode(selectList).addSourceCode("\n").addSourceCode("from ");
            if (usePassThru && uploadLibrary != null && uploadSchema.length() > 0) {
                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
            } else if (usePassThru && this.useTempLibrary(codeSegment) && engine.startsWith("DB2")) {
                codeSegment.addSourceCode("SESSION.");
            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                codeSegment.addSourceCode(schema).addSourceCode(".");
            } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                codeSegment.addSourceCode(schema).addSourceCode(".");
            }
            codeSegment.addSourceCode(strWorkNew).unIndent();
            if (usePassThru) {
                targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
            } else {
                codeSegment.addSourceCode(";\n\n");
            }
            codeSegment.genRCSetCall("&sqlrc").unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No new dimension records were added to target table.").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
            if (usePassThru) {
                if (targetDBMSType instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                    targetDBMSType.genExecuteCommit(codeSegment, targetTable, "execute (commit) by ODBC;");
                } else {
                    targetDBMSType.genExecuteCommit(codeSegment, targetTable, "");
                }
                codeSegment.newLine();
                targetDBMSType.genDisconnect(codeSegment, targetTable);
            }
            codeSegment.unIndent().addSourceCode("quit;\n\n");
            if (usePassThru) {
                lDeleteWorkTables.add(delWorkClose);
                lDeleteWorkTables.add(delWorkMatch);
                lDeleteWorkTables.add(delWorkNew);
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    lDeleteWorkTables.add(delWorkType1);
                }
                codeSegment.addCommentLine("Delete the work tables").genTableDelete(lDeleteWorkTables);
                if (uploadLibrary == null && this.useTempLibrary(codeSegment)) {
                    codeSegment.addCommentLine("Clear the temporary upload library").addSourceCode("libname ").addSourceCode(DBMSTEMPLIBREF).addSourceCode(" clear;\n\n");
                }
            }
            lDeleteWorkTables.clear();
            lDeleteWorkTables.add(WORKETLSNEWRCD);
            lDeleteWorkTables.add(WORKETLSMATCH);
            lDeleteWorkTables.add(WORKETLSCLOSE);
            if (lType1Columns != null && lType1Columns.size() > 0) {
                lDeleteWorkTables.add(WORKETLSTYPE1);
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(lDeleteWorkTables).unIndent().addSourceCode("%end;\n\n");
        }
    }

    protected void genDateUpdateTargetTableChangeForS1130594(List keyColumns, boolean usePassThru, boolean useTempLibrary, IColumn generatedKeyCol, boolean isRetainedKey, IColumn currentIndColumn, List lType1Columns, ICodeSegment codeSegment, String currentIndicatorYesValue, String currentIndicatorNoValue) throws CodegenException, MdException, RemoteException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException {
        codeSegment.addSectionComment("Start of target table update");
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        String sTargetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment, usePassThru);
        ITransformTableOptions targetOptions = this.getTableOptionObject(targetTable, false);
        String sTargetOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
        String sTableAlias = targetTable.getTableName(codeSegment.isQuoting(), usePassThru);
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        boolean needsQuotes = codeSegment.isQuoting();
        boolean DBMSTempLib = false;
        String sToDateColumnName = this.m_toDateColumn.getColumnName(codeSegment, usePassThru);
        String sFromDateColumnName = this.m_fromDateColumn.getColumnName(codeSegment, usePassThru);
        String sGeneratedKeyColumnName = "";
        boolean hasGeneratedKey = false;
        if (generatedKeyCol != null) {
            hasGeneratedKey = true;
            sGeneratedKeyColumnName = generatedKeyCol.getColumnName(codeSegment, usePassThru);
        }
        String sLoadTimeColumnName = "";
        if (this.getLoadTimeColumn() != null) {
            sLoadTimeColumnName = this.getLoadTimeColumn().getColumnName(codeSegment, usePassThru);
        }
        ArrayList<String> lDeleteWorkTables = new ArrayList<String>();
        IDBMSType targetDBMSType = targetTable.getDBMSType();
        String engine = library.getEngine();
        if (targetDBMSType.getDBMSTypeName().equals("SAS") || targetDBMSType.getDBMSTypeName().equals("SAS SPDS") && this.getSPDSUpdateTechnique().equals(SPDS_UPDATE_TECHNIQUE_MODIFY)) {
            if (this.m_bTempUpdateTblIndex) {
                IWorkTable closeTable = this.createTempUpdateWorklTable(TEMPCLOSETBLNAME, keyColumns, hasGeneratedKey, isRetainedKey, new ArrayList());
                closeTable.getDBMSType().createIndexes2(codeSegment, closeTable, null, "");
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    IWorkTable type1Table = this.createTempUpdateWorklTable(TEMPTYPE1TBLNAME, keyColumns, hasGeneratedKey, isRetainedKey, lType1Columns);
                    type1Table.getDBMSType().createIndexes2(codeSegment, type1Table, null, "");
                }
            }
            ArrayList<IColumn> lTargetKeyCols = new ArrayList<IColumn>();
            boolean needFromDate = false;
            if (generatedKeyCol == null) {
                lTargetKeyCols.addAll(keyColumns);
                lTargetKeyCols.add(this.m_fromDateColumn);
                needFromDate = true;
            } else {
                lTargetKeyCols.add(generatedKeyCol);
                if (isRetainedKey) {
                    lTargetKeyCols.add(this.m_fromDateColumn);
                    needFromDate = true;
                }
            }
            String sCurrentIndColumnName = "";
            if (currentIndColumn != null) {
                sCurrentIndColumnName = currentIndColumn.getColumnName(codeSegment);
            }
            this.genUpdateUsingModify(lTargetKeyCols, sGeneratedKeyColumnName, sFromDateColumnName, sToDateColumnName, sCurrentIndColumnName, sLoadTimeColumnName, sTargetDSName, needFromDate, false, lType1Columns, codeSegment, currentIndicatorYesValue, currentIndicatorNoValue);
            lDeleteWorkTables.add(WORKETLSNEWRCD);
            lDeleteWorkTables.add(WORKETLSMATCH);
            lDeleteWorkTables.add(WORKETLSCLOSE);
            if (lType1Columns != null && lType1Columns.size() > 0) {
                lDeleteWorkTables.add(WORKETLSTYPE1);
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(lDeleteWorkTables).unIndent().addSourceCode("%end;\n\n");
        } else {
            String schema;
            String strWorkNew = codeSegment.getUniqueWorkTableName();
            String strWorkMatch = codeSegment.getUniqueWorkTableName(20);
            String strWorkClose = codeSegment.getUniqueWorkTableName(60);
            String strWorkType1 = codeSegment.getUniqueWorkTableName(100);
            String delWorkNew = "";
            String delWorkMatch = "";
            String delWorkClose = "";
            String delWorkType1 = "";
            String dbmsTempCloseUnquoted = "";
            String dbmsMatchTblNameUnquoted = "";
            String dbmsNewRcdTblNameUnique = "";
            String dbmsType1TblNameUnique = "";
            ILibrary visualUploadLibrary = this.getUploadLibrary();
            ILibrary uploadLibrary = this.getRunTimeUploadLibrary(usePassThru, codeSegment, library);
            if (usePassThru) {
                if (useTempLibrary) {
                    this.genDBMSTempTableLibname(targetTable, codeSegment);
                    DBMSTempLib = true;
                }
                this.genDBMSTempCloseTable(strWorkClose, keyColumns, uploadLibrary, hasGeneratedKey, isRetainedKey, codeSegment);
                String dbmsTempClose = dbmsTempCloseUnquoted = strWorkClose;
                if (needsQuotes) {
                    dbmsTempClose = DBMSNamesUtil.getQuotedString(dbmsTempCloseUnquoted, true);
                }
                strWorkClose = dbmsTempClose;
                String delTemp = dbmsTempCloseUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsTempCloseUnquoted, false);
                }
                delWorkClose = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                this.genDBMSTempMatchOrNewRecordsTable(strWorkMatch, true, uploadLibrary, codeSegment);
                String dbmsTempMatch = dbmsMatchTblNameUnquoted = strWorkMatch;
                if (needsQuotes) {
                    dbmsTempMatch = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, true);
                }
                strWorkMatch = dbmsTempMatch;
                delTemp = dbmsMatchTblNameUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, false);
                }
                delWorkMatch = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                this.genDBMSTempMatchOrNewRecordsTable(strWorkNew, false, uploadLibrary, codeSegment);
                String dbmsTempNew = dbmsNewRcdTblNameUnique = strWorkNew;
                if (needsQuotes) {
                    dbmsTempNew = DBMSNamesUtil.getQuotedString(dbmsNewRcdTblNameUnique, true);
                }
                strWorkNew = dbmsTempNew;
                delTemp = dbmsNewRcdTblNameUnique;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsNewRcdTblNameUnique, false);
                }
                delWorkNew = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    this.genDBMSTempType1Table(strWorkType1, keyColumns, uploadLibrary, hasGeneratedKey, isRetainedKey, lType1Columns, codeSegment);
                    String dbmsTempType1 = dbmsType1TblNameUnique = strWorkType1;
                    if (needsQuotes) {
                        dbmsTempType1 = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, true);
                    }
                    strWorkType1 = dbmsTempType1;
                    delTemp = dbmsType1TblNameUnique;
                    if (needsQuotes) {
                        delTemp = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, false);
                    }
                    delWorkType1 = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                }
            } else {
                strWorkClose = WORKETLSCLOSE;
                strWorkMatch = WORKETLSMATCH;
                strWorkNew = WORKETLSNEWRCD;
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    strWorkType1 = WORKETLSTYPE1;
                }
            }
            String tempCloseDate = "";
            String tempFromDate = "";
            String tempGenKey = "";
            String tempLoadTime = "";
            if (codeSegment.isQuoting()) {
                tempGenKey = DBMSNamesUtil.getQuotedString(TEMPGENKEY, usePassThru);
                tempCloseDate = DBMSNamesUtil.getQuotedString(TEMPCLOSEDATE, usePassThru);
                tempFromDate = DBMSNamesUtil.getQuotedString(TEMPFROMDATE, usePassThru);
                tempLoadTime = DBMSNamesUtil.getQuotedString(TEMPLOADTIME, usePassThru);
            } else {
                tempGenKey = TEMPGENKEY;
                tempCloseDate = TEMPCLOSEDATE;
                tempFromDate = TEMPFROMDATE;
                tempLoadTime = TEMPLOADTIME;
            }
            String sTableAliasPt = "";
            if (sTableAlias.length() > 0) {
                sTableAliasPt = sTableAlias + ".";
            }
            StringBuffer sbWhereClause = new StringBuffer();
            StringBuffer sbWhereClauseStrWorkType1 = new StringBuffer();
            StringBuffer sbWhereClauseNoPassThru = new StringBuffer();
            StringBuffer sbWhereClauseStrWorkType1NoPassThru = new StringBuffer();
            String schemaName = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
            if (hasGeneratedKey) {
                if (usePassThru) {
                    sbWhereClause.append(strWorkClose).append(".").append(tempGenKey).append(" = ");
                    sbWhereClauseStrWorkType1.append(strWorkType1).append(".").append(tempGenKey).append(" = ");
                } else {
                    sbWhereClause.append(tempGenKey).append(" = ");
                    sbWhereClauseStrWorkType1.append(tempGenKey).append(" = ");
                    sbWhereClauseNoPassThru.append(tempGenKey).append(" = ");
                    sbWhereClauseStrWorkType1NoPassThru.append(tempGenKey).append(" = ");
                }
                if (usePassThru && targetTable.getDBMSType() instanceof DB2UNXPCType && schemaName != null && schemaName.trim().length() > 0) {
                    sbWhereClause.append(schemaName + ".");
                    sbWhereClauseStrWorkType1.append(schemaName + ".");
                }
                sbWhereClause.append(sTableAliasPt).append(sGeneratedKeyColumnName);
                sbWhereClauseStrWorkType1.append(sTableAliasPt).append(sGeneratedKeyColumnName);
                sbWhereClauseNoPassThru.append(sTableAliasPt).append(sGeneratedKeyColumnName);
                sbWhereClauseStrWorkType1NoPassThru.append(sTableAliasPt).append(sGeneratedKeyColumnName);
                if (isRetainedKey) {
                    if (usePassThru) {
                        sbWhereClause.append("\nand ").append(strWorkClose + "." + tempFromDate).append(" = ");
                        sbWhereClauseStrWorkType1.append("\nand ").append(strWorkType1 + "." + tempFromDate).append(" = ");
                    } else {
                        sbWhereClause.append("\nand ").append(tempFromDate).append(" = ");
                        sbWhereClauseStrWorkType1.append("\nand ").append(tempFromDate).append(" = ");
                        sbWhereClauseNoPassThru.append("\nand ").append(tempFromDate).append(" = ");
                        sbWhereClauseStrWorkType1NoPassThru.append("\nand ").append(tempFromDate).append(" = ");
                    }
                    if (usePassThru && targetTable.getDBMSType() instanceof DB2UNXPCType && schemaName != null && schemaName.trim().length() > 0) {
                        sbWhereClause.append(schemaName + ".");
                        sbWhereClauseStrWorkType1.append(schemaName + ".");
                    }
                    sbWhereClause.append(sTableAliasPt).append(sFromDateColumnName);
                    sbWhereClauseStrWorkType1.append(sTableAliasPt).append(sFromDateColumnName);
                    sbWhereClauseNoPassThru.append(sTableAliasPt).append(sFromDateColumnName);
                    sbWhereClauseStrWorkType1NoPassThru.append(sTableAliasPt).append(sFromDateColumnName);
                }
            } else if (usePassThru && targetTable.getDBMSType() instanceof DB2UNXPCType && schemaName != null && schemaName.trim().length() > 0) {
                sbWhereClause.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", sTableAlias, codeSegment, false, schemaName));
                sbWhereClause.append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(tempFromDate).append(" = ").append(schemaName).append(".").append(sTableAliasPt).append(sFromDateColumnName);
                sbWhereClauseStrWorkType1.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", sTableAlias, codeSegment, false, schemaName));
                sbWhereClauseStrWorkType1.append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(tempFromDate).append(" = ").append(schemaName).append(".").append(sTableAliasPt).append(sFromDateColumnName);
            } else {
                sbWhereClause.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", strWorkClose, sTableAlias, codeSegment, false));
                sbWhereClause.append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(strWorkClose + "." + tempFromDate).append(" = ").append(sTableAliasPt).append(sFromDateColumnName);
                sbWhereClauseStrWorkType1.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", strWorkType1, sTableAlias, codeSegment, false));
                sbWhereClauseStrWorkType1.append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(strWorkType1 + "." + tempFromDate).append(" = ").append(sTableAliasPt).append(sFromDateColumnName);
                sbWhereClauseNoPassThru.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", sTableAlias, codeSegment, false));
                sbWhereClauseNoPassThru.append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(tempFromDate).append(" = ").append(sTableAliasPt).append(sFromDateColumnName);
                sbWhereClauseStrWorkType1NoPassThru.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", sTableAlias, codeSegment, false));
                sbWhereClauseStrWorkType1NoPassThru.append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(tempFromDate).append(" = ").append(sTableAliasPt).append(sFromDateColumnName);
            }
            if (usePassThru) {
                codeSegment.addCommentLine("Update the target table using SQL pass-thru");
                strWorkNew = this.getTempTableName(usePassThru, useTempLibrary, targetDBMSType, dbmsNewRcdTblNameUnique);
                strWorkMatch = this.getTempTableName(usePassThru, useTempLibrary, targetDBMSType, dbmsMatchTblNameUnquoted);
                strWorkClose = this.getTempTableName(usePassThru, useTempLibrary, targetDBMSType, dbmsTempCloseUnquoted);
                strWorkType1 = this.getTempTableName(usePassThru, useTempLibrary, targetDBMSType, dbmsType1TblNameUnique);
            } else {
                codeSegment.addCommentLine("Update the target table");
            }
            if (needsQuotes && usePassThru) {
                strWorkNew = DBMSNamesUtil.getQuotedString(strWorkNew, true);
                strWorkMatch = DBMSNamesUtil.getQuotedString(strWorkMatch, true);
                strWorkClose = DBMSNamesUtil.getQuotedString(strWorkClose, true);
                strWorkType1 = DBMSNamesUtil.getQuotedString(strWorkType1, true);
            }
            codeSegment.addSourceCode("proc sql ").addSourceCode(this.m_sSQLOptions).addSourceCode(";\n").indent().addCommentLine("Close out existing records");
            String uploadSchema = "";
            if (usePassThru) {
                boolean bUseConnectUsing;
                if (visualUploadLibrary != null) {
                    uploadSchema = targetTable.getDBMSType().getDBMSTypeName().equals("SAS SPDS") ? uploadLibrary.getLibref() : uploadLibrary.getDatabaseSchema().getSchemaName();
                    uploadSchema = DBMSNamesUtil.getQuotedName(uploadSchema, needsQuotes, needsQuotes, usePassThru);
                }
                if (bUseConnectUsing = this.isUseConnectUsingEnabled()) {
                    codeSegment.addSourceCode("connect using " + uploadLibrary.getLibref() + " as " + uploadLibrary.getEngine() + ";\n");
                } else {
                    codeSegment.addSourceCode("connect to " + uploadLibrary.getEngine() + "\n").addSourceCode("( \n").indent();
                    codeSegment.addSourceCode(uploadLibrary.getConnectionOptions());
                    codeSegment.unIndent().addSourceCode("); \n");
                }
                if (targetTable.getDBMSType() instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                    codeSegment.newLine().addSourceCode("execute (begin transaction) by ODBC;").newLine(2);
                }
                codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent();
                targetTable.getDBMSType().genExecuteBegin(codeSegment, targetTable, "");
            } else {
                codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent();
            }
            codeSegment.indent().addSourceCode("update ").addSourceCode(sTargetDSName);
            if (sTargetOptions.length() > 0 && !usePassThru) {
                codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
            }
            codeSegment.addSourceCode("\n").indent();
            if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                codeSegment.addSourceCode("from ");
                if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
            }
            codeSegment.addSourceCode("set ");
            if (currentIndColumn != null) {
                codeSegment.addSourceCode(currentIndColumn.getColumnName(needsQuotes, usePassThru)).addSourceCode(" = " + currentIndicatorNoValue + ",\n");
            }
            codeSegment.addSourceCode(sToDateColumnName);
            if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                codeSegment.addSourceCode(" = \n");
            } else {
                codeSegment.addSourceCode(" = (\n");
            }
            codeSegment.indent();
            if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                codeSegment.addSourceCode(tempCloseDate).addSourceCode("\n");
            } else {
                codeSegment.addSourceCode("select ").addSourceCode(tempCloseDate).addSourceCode("\n").indent().addSourceCode("from ");
                if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    String schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema2).addSourceCode(".");
                } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    String schema3 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema3).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
            }
            if (usePassThru) {
                codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
            } else {
                codeSegment.addSourceCode("where ").addSourceCode(sbWhereClauseNoPassThru);
            }
            if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                codeSegment.addSourceCode(" \n").unIndent().unIndent();
            } else {
                codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                codeSegment.addSourceCode("where exists ( select 1\n").indent().indent().addSourceCode("from ");
                if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    String schema4 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema4).addSourceCode(".");
                } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    String schema5 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema5).addSourceCode(".");
                }
                if (usePassThru) {
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
                } else {
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClauseNoPassThru).addSourceCode(")").unIndent().unIndent();
                }
            }
            if (usePassThru) {
                targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
            } else {
                codeSegment.addSourceCode(";\n");
                codeSegment.unIndent().genRCSetCall("&sqlrc");
            }
            if (sLoadTimeColumnName.length() > 0) {
                codeSegment.addCommentLine("Update the load time column");
                if (usePassThru) {
                    targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                }
                codeSegment.addSourceCode("update ").addSourceCode(sTargetDSName);
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                }
                codeSegment.addSourceCode("\n").indent();
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode("from ");
                    if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                }
                codeSegment.addSourceCode("set ").addSourceCode(sLoadTimeColumnName);
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(" = \n");
                } else {
                    codeSegment.addSourceCode(" = (\n");
                }
                codeSegment.indent();
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(tempLoadTime).addSourceCode("\n");
                } else {
                    codeSegment.addSourceCode("select ").addSourceCode(tempLoadTime).addSourceCode("\n").indent().addSourceCode("from ");
                    if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                        codeSegment.addSourceCode("SESSION.");
                    } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                        String schema6 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema6).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                }
                codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(" \n").unIndent().unIndent();
                } else {
                    codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                    codeSegment.addSourceCode("where exists ( select 1 \n").indent().indent().addSourceCode("from ");
                    if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                        codeSegment.addSourceCode("SESSION.");
                    } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                        String schema7 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema7).addSourceCode(".");
                    } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                        String schema8 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema8).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
                }
                if (usePassThru) {
                    targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n\n");
                    codeSegment.genRCSetCall("&sqlrc");
                }
            }
            codeSegment.unIndent().unIndent().unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No records on target table were closed.").addSourceCode("\n").unIndent().addSourceCode("%end;\n");
            if (lType1Columns != null && lType1Columns.size() > 0) {
                codeSegment.addCommentLine("Update the the type 1 column").addSourceCode("%if &etls_type1cnt gt 0 %then\n%do;\n\n").indent();
                for (int index = 0; index < lType1Columns.size(); ++index) {
                    String schema9;
                    IColumn column = (IColumn)lType1Columns.get(index);
                    String sColumnName = "";
                    if (usePassThru) {
                        targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                        sColumnName = column.getColumnName(needsQuotes, true);
                    } else {
                        sColumnName = column.getColumnName(needsQuotes, false);
                    }
                    codeSegment.addSourceCode("update ").addSourceCode(sTargetDSName);
                    if (sTargetOptions.length() > 0 && !usePassThru) {
                        codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                    }
                    codeSegment.addSourceCode("\n").indent();
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode("from ");
                        if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                    }
                    codeSegment.addSourceCode("set ").addSourceCode(sColumnName);
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(" = \n");
                    } else {
                        codeSegment.addSourceCode(" = (\n");
                    }
                    codeSegment.indent();
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(strWorkType1).addSourceCode(".").addSourceCode(sColumnName).addSourceCode("\n");
                    } else {
                        codeSegment.addSourceCode("select ").addSourceCode(sColumnName).addSourceCode("\n").indent().addSourceCode("from ");
                        if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                            codeSegment.addSourceCode("SESSION.");
                        } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                            schema9 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema9).addSourceCode(".");
                        } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                            schema9 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema9).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                    }
                    if (usePassThru) {
                        codeSegment.addSourceCode("where ").addSourceCode(sbWhereClauseStrWorkType1);
                    } else {
                        codeSegment.addSourceCode("where ").addSourceCode(sbWhereClauseStrWorkType1NoPassThru);
                    }
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(" \n").unIndent().unIndent();
                    } else {
                        codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                        codeSegment.addSourceCode("where exists ( select 1 \n").indent().indent().addSourceCode("from ");
                        if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                            codeSegment.addSourceCode("SESSION.");
                        } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                            schema9 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema9).addSourceCode(".");
                        } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                            schema9 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema9).addSourceCode(".");
                        }
                        if (usePassThru) {
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClauseStrWorkType1).addSourceCode(")").unIndent().unIndent();
                        } else {
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClauseStrWorkType1NoPassThru).addSourceCode(")").unIndent().unIndent();
                        }
                    }
                    if (usePassThru) {
                        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                        continue;
                    }
                    codeSegment.addSourceCode(";\n\n");
                    codeSegment.genRCSetCall("&sqlrc");
                }
                codeSegment.unIndent().unIndent().unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No type1 updates were made to target table.").addSourceCode("\n").unIndent().addSourceCode("%end;\n");
            }
            String selectList = codeSegment.makeColumnList(targetTable, true, "      ", usePassThru, ",", "", needsQuotes, "");
            String colList = codeSegment.makeColumnList(targetTable, false, "      ", usePassThru, ",", "", needsQuotes, "");
            codeSegment.addCommentLine("Insert the new matching records").addSourceCode("%if &etls_matchcnt gt 0 %then\n%do;\n\n").indent();
            if (usePassThru) {
                targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
            }
            codeSegment.addSourceCode("insert into ").addSourceCode(sTargetDSName).addSourceCode("\n").indent().addSourceCode("( ");
            if (sTargetOptions.length() > 0 && !usePassThru) {
                codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(",\n");
            }
            codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("Select ").addSourceCode(selectList).addSourceCode("\n").addSourceCode("from ");
            if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
            } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                codeSegment.addSourceCode("SESSION.");
            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                codeSegment.addSourceCode(schema).addSourceCode(".");
            } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                codeSegment.addSourceCode(schema).addSourceCode(".");
            }
            codeSegment.addSourceCode(strWorkMatch).unIndent();
            if (usePassThru) {
                targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
            } else {
                codeSegment.addSourceCode(";\n\n");
                codeSegment.genRCSetCall("&sqlrc");
            }
            codeSegment.unIndent().addSourceCode("%end;\n\n");
            codeSegment.addCommentLine("Insert the new dimension records").addSourceCode("%if &etls_newcnt gt 0 %then\n%do;\n\n").indent();
            if (usePassThru) {
                targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
            }
            codeSegment.addSourceCode("insert into ").addSourceCode(sTargetDSName).addSourceCode("\n").indent().addSourceCode("( ");
            if (sTargetOptions.length() > 0 && !usePassThru) {
                codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(",\n");
            }
            codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("select ").addSourceCode(selectList).addSourceCode("\n").addSourceCode("from ");
            if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
            } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                codeSegment.addSourceCode("SESSION.");
            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                codeSegment.addSourceCode(schema).addSourceCode(".");
            } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                codeSegment.addSourceCode(schema).addSourceCode(".");
            }
            codeSegment.addSourceCode(strWorkNew).unIndent();
            if (usePassThru) {
                targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
            } else {
                codeSegment.addSourceCode(";\n\n");
                codeSegment.genRCSetCall("&sqlrc");
            }
            codeSegment.unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No new dimension records were added to target table.").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
            if (usePassThru) {
                if (targetDBMSType instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                    targetDBMSType.genExecuteCommit(codeSegment, targetTable, "execute (commit) by ODBC;");
                } else {
                    targetDBMSType.genExecuteCommit(codeSegment, targetTable, "");
                }
                codeSegment.newLine();
                targetDBMSType.genDisconnect(codeSegment, targetTable);
            }
            codeSegment.unIndent().addSourceCode("quit;\n\n");
            if (usePassThru) {
                lDeleteWorkTables.add(delWorkClose);
                lDeleteWorkTables.add(delWorkMatch);
                lDeleteWorkTables.add(delWorkNew);
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    lDeleteWorkTables.add(delWorkType1);
                }
                codeSegment.addCommentLine("Delete the work tables").genTableDelete(lDeleteWorkTables);
                if (visualUploadLibrary == null && useTempLibrary) {
                    codeSegment.addCommentLine("Clear the temporary upload library").addSourceCode("libname ").addSourceCode(DBMSTEMPLIBREF).addSourceCode(" clear;\n\n");
                }
            }
            lDeleteWorkTables.clear();
            lDeleteWorkTables.add(WORKETLSNEWRCD);
            lDeleteWorkTables.add(WORKETLSMATCH);
            lDeleteWorkTables.add(WORKETLSCLOSE);
            if (lType1Columns != null && lType1Columns.size() > 0) {
                lDeleteWorkTables.add(WORKETLSTYPE1);
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(lDeleteWorkTables).unIndent().addSourceCode("%end;\n\n");
        }
    }

    protected void genDateUpdateTargetTable(List keyColumns, boolean usePassThru, boolean useTempLibrary, IColumn generatedKeyCol, boolean isRetainedKey, IColumn currentIndColumn, List lType1Columns, ICodeSegment codeSegment, String currentIndicatorYesValue, String currentIndicatorNoValue) throws CodegenException, MdException, RemoteException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException {
        if (this.m_bUseSCDChanges) {
            this.genDateUpdateTargetTableChangeForS1130594(keyColumns, usePassThru, useTempLibrary, generatedKeyCol, isRetainedKey, currentIndColumn, lType1Columns, codeSegment, currentIndicatorYesValue, currentIndicatorNoValue);
            return;
        }
        codeSegment.addSectionComment("Start of target table update");
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        String sTargetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment, usePassThru);
        ITransformTableOptions targetOptions = this.getTableOptionObject(targetTable, false);
        String sTargetOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
        String sTableAlias = targetTable.getTableName(codeSegment.isQuoting(), usePassThru);
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        boolean needsQuotes = codeSegment.isQuoting();
        boolean DBMSTempLib = false;
        String sToDateColumnName = this.m_toDateColumn.getColumnName(codeSegment, usePassThru);
        String sFromDateColumnName = this.m_fromDateColumn.getColumnName(codeSegment, usePassThru);
        String sGeneratedKeyColumnName = "";
        boolean hasGeneratedKey = false;
        if (generatedKeyCol != null) {
            hasGeneratedKey = true;
            sGeneratedKeyColumnName = generatedKeyCol.getColumnName(codeSegment, usePassThru);
        }
        String sLoadTimeColumnName = "";
        if (this.getLoadTimeColumn() != null) {
            sLoadTimeColumnName = this.getLoadTimeColumn().getColumnName(codeSegment, usePassThru);
        }
        ArrayList<String> lDeleteWorkTables = new ArrayList<String>();
        IDBMSType targetDBMSType = targetTable.getDBMSType();
        String engine = library.getEngine();
        if (targetDBMSType.getDBMSTypeName().equals("SAS") || targetDBMSType.getDBMSTypeName().equals("SAS SPDS") && this.getSPDSUpdateTechnique().equals(SPDS_UPDATE_TECHNIQUE_MODIFY)) {
            if (this.m_bTempUpdateTblIndex) {
                IWorkTable closeTable = this.createTempUpdateWorklTable(TEMPCLOSETBLNAME, keyColumns, hasGeneratedKey, isRetainedKey, new ArrayList());
                closeTable.getDBMSType().createIndexes2(codeSegment, closeTable, null, "");
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    IWorkTable type1Table = this.createTempUpdateWorklTable(TEMPTYPE1TBLNAME, keyColumns, hasGeneratedKey, isRetainedKey, lType1Columns);
                    type1Table.getDBMSType().createIndexes2(codeSegment, type1Table, null, "");
                }
            }
            ArrayList<IColumn> lTargetKeyCols = new ArrayList<IColumn>();
            boolean needFromDate = false;
            if (generatedKeyCol == null) {
                lTargetKeyCols.addAll(keyColumns);
                lTargetKeyCols.add(this.m_fromDateColumn);
                needFromDate = true;
            } else {
                lTargetKeyCols.add(generatedKeyCol);
                if (isRetainedKey) {
                    lTargetKeyCols.add(this.m_fromDateColumn);
                    needFromDate = true;
                }
            }
            String sCurrentIndColumnName = "";
            if (currentIndColumn != null) {
                sCurrentIndColumnName = currentIndColumn.getColumnName(codeSegment);
            }
            this.genUpdateUsingModify(lTargetKeyCols, sGeneratedKeyColumnName, sFromDateColumnName, sToDateColumnName, sCurrentIndColumnName, sLoadTimeColumnName, sTargetDSName, needFromDate, false, lType1Columns, codeSegment, currentIndicatorYesValue, currentIndicatorNoValue);
            lDeleteWorkTables.add(WORKETLSNEWRCD);
            lDeleteWorkTables.add(WORKETLSMATCH);
            lDeleteWorkTables.add(WORKETLSCLOSE);
            if (lType1Columns != null && lType1Columns.size() > 0) {
                lDeleteWorkTables.add(WORKETLSTYPE1);
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(lDeleteWorkTables).unIndent().addSourceCode("%end;\n\n");
        } else {
            String strWorkNew = codeSegment.getUniqueWorkTableName();
            String strWorkMatch = codeSegment.getUniqueWorkTableName(20);
            String strWorkClose = codeSegment.getUniqueWorkTableName(60);
            String strWorkType1 = codeSegment.getUniqueWorkTableName(100);
            String delWorkNew = "";
            String delWorkMatch = "";
            String delWorkClose = "";
            String delWorkType1 = "";
            String dbmsTempCloseUnquoted = "";
            String dbmsMatchTblNameUnquoted = "";
            String dbmsNewRcdTblNameUnique = "";
            String dbmsType1TblNameUnique = "";
            ILibrary visualUploadLibrary = this.getUploadLibrary();
            ILibrary uploadLibrary = this.getRunTimeUploadLibrary(usePassThru, codeSegment, library);
            if (usePassThru) {
                if (useTempLibrary) {
                    this.genDBMSTempTableLibname(targetTable, codeSegment);
                    DBMSTempLib = true;
                }
                this.genDBMSTempCloseTable(strWorkClose, keyColumns, uploadLibrary, hasGeneratedKey, isRetainedKey, codeSegment);
                String dbmsTempClose = dbmsTempCloseUnquoted = strWorkClose;
                if (needsQuotes) {
                    dbmsTempClose = DBMSNamesUtil.getQuotedString(dbmsTempCloseUnquoted, true);
                }
                strWorkClose = dbmsTempClose;
                String delTemp = dbmsTempCloseUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsTempCloseUnquoted, false);
                }
                delWorkClose = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                this.genDBMSTempMatchOrNewRecordsTable(strWorkMatch, true, uploadLibrary, codeSegment);
                String dbmsTempMatch = dbmsMatchTblNameUnquoted = strWorkMatch;
                if (needsQuotes) {
                    dbmsTempMatch = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, true);
                }
                strWorkMatch = dbmsTempMatch;
                delTemp = dbmsMatchTblNameUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, false);
                }
                delWorkMatch = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                this.genDBMSTempMatchOrNewRecordsTable(strWorkNew, false, uploadLibrary, codeSegment);
                String dbmsTempNew = dbmsNewRcdTblNameUnique = strWorkNew;
                if (needsQuotes) {
                    dbmsTempNew = DBMSNamesUtil.getQuotedString(dbmsNewRcdTblNameUnique, true);
                }
                strWorkNew = dbmsTempNew;
                delTemp = dbmsNewRcdTblNameUnique;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsNewRcdTblNameUnique, false);
                }
                delWorkNew = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    this.genDBMSTempType1Table(strWorkType1, keyColumns, uploadLibrary, hasGeneratedKey, isRetainedKey, lType1Columns, codeSegment);
                    String dbmsTempType1 = dbmsType1TblNameUnique = strWorkType1;
                    if (needsQuotes) {
                        dbmsTempType1 = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, true);
                    }
                    strWorkType1 = dbmsTempType1;
                    delTemp = dbmsType1TblNameUnique;
                    if (needsQuotes) {
                        delTemp = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, false);
                    }
                    delWorkType1 = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                }
            } else {
                strWorkClose = WORKETLSCLOSE;
                strWorkMatch = WORKETLSMATCH;
                strWorkNew = WORKETLSNEWRCD;
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    strWorkType1 = WORKETLSTYPE1;
                }
            }
            String tempCloseDate = "";
            String tempFromDate = "";
            String tempGenKey = "";
            String tempLoadTime = "";
            if (codeSegment.isQuoting()) {
                tempGenKey = DBMSNamesUtil.getQuotedString(TEMPGENKEY, usePassThru);
                tempCloseDate = DBMSNamesUtil.getQuotedString(TEMPCLOSEDATE, usePassThru);
                tempFromDate = DBMSNamesUtil.getQuotedString(TEMPFROMDATE, usePassThru);
                tempLoadTime = DBMSNamesUtil.getQuotedString(TEMPLOADTIME, usePassThru);
            } else {
                tempGenKey = TEMPGENKEY;
                tempCloseDate = TEMPCLOSEDATE;
                tempFromDate = TEMPFROMDATE;
                tempLoadTime = TEMPLOADTIME;
            }
            String sTableAliasPt = "";
            if (sTableAlias.length() > 0) {
                sTableAliasPt = sTableAlias + ".";
            }
            StringBuffer sbWhereClause = new StringBuffer();
            String schemaName = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
            if (hasGeneratedKey) {
                sbWhereClause.append(tempGenKey).append(" = ");
                if (usePassThru && targetTable.getDBMSType() instanceof DB2UNXPCType && schemaName != null && schemaName.trim().length() > 0) {
                    sbWhereClause.append(schemaName + ".");
                }
                sbWhereClause.append(sTableAliasPt).append(sGeneratedKeyColumnName);
                if (isRetainedKey) {
                    sbWhereClause.append("\nand ").append(tempFromDate).append(" = ");
                    if (usePassThru && targetTable.getDBMSType() instanceof DB2UNXPCType && schemaName != null && schemaName.trim().length() > 0) {
                        sbWhereClause.append(schemaName + ".");
                    }
                    sbWhereClause.append(sTableAliasPt).append(sFromDateColumnName);
                }
            } else if (usePassThru && targetTable.getDBMSType() instanceof DB2UNXPCType && schemaName != null && schemaName.trim().length() > 0) {
                sbWhereClause.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", sTableAlias, codeSegment, false, schemaName));
                sbWhereClause.append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(tempFromDate).append(" = ").append(schemaName).append(".").append(sTableAliasPt).append(sFromDateColumnName);
            } else {
                sbWhereClause.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", sTableAlias, codeSegment, false));
                sbWhereClause.append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(tempFromDate).append(" = ").append(sTableAliasPt).append(sFromDateColumnName);
            }
            if (usePassThru) {
                codeSegment.addCommentLine("Update the target table using SQL pass-thru");
                strWorkNew = this.getTempTableName(usePassThru, useTempLibrary, targetDBMSType, dbmsNewRcdTblNameUnique);
                strWorkMatch = this.getTempTableName(usePassThru, useTempLibrary, targetDBMSType, dbmsMatchTblNameUnquoted);
                strWorkClose = this.getTempTableName(usePassThru, useTempLibrary, targetDBMSType, dbmsTempCloseUnquoted);
                strWorkType1 = this.getTempTableName(usePassThru, useTempLibrary, targetDBMSType, dbmsType1TblNameUnique);
            } else {
                codeSegment.addCommentLine("Update the target table");
            }
            if (needsQuotes && usePassThru) {
                strWorkNew = DBMSNamesUtil.getQuotedString(strWorkNew, true);
                strWorkMatch = DBMSNamesUtil.getQuotedString(strWorkMatch, true);
                strWorkClose = DBMSNamesUtil.getQuotedString(strWorkClose, true);
                strWorkType1 = DBMSNamesUtil.getQuotedString(strWorkType1, true);
            }
            if (engine.equalsIgnoreCase("NETEZZA") && usePassThru) {
                this.cgUpdateDateNetezza(codeSegment, usePassThru, currentIndColumn, currentIndicatorNoValue, strWorkClose, strWorkType1, strWorkMatch, strWorkNew, generatedKeyCol, isRetainedKey, keyColumns, lType1Columns);
            } else {
                String schema;
                codeSegment.addSourceCode("proc sql ").addSourceCode(this.m_sSQLOptions).addSourceCode(";\n").indent().addCommentLine("Close out existing records");
                String uploadSchema = "";
                if (usePassThru) {
                    boolean bUseConnectUsing;
                    if (visualUploadLibrary != null) {
                        uploadSchema = targetTable.getDBMSType().getDBMSTypeName().equals("SAS SPDS") ? uploadLibrary.getLibref() : uploadLibrary.getDatabaseSchema().getSchemaName();
                        uploadSchema = DBMSNamesUtil.getQuotedName(uploadSchema, needsQuotes, needsQuotes, usePassThru);
                    }
                    if (bUseConnectUsing = this.isUseConnectUsingEnabled()) {
                        codeSegment.addSourceCode("connect using " + uploadLibrary.getLibref() + " as " + uploadLibrary.getEngine() + ";\n");
                    } else {
                        codeSegment.addSourceCode("connect to " + uploadLibrary.getEngine() + "\n").addSourceCode("( \n").indent();
                        codeSegment.addSourceCode(uploadLibrary.getConnectionOptions());
                        codeSegment.unIndent().addSourceCode("); \n");
                    }
                    if (targetTable.getDBMSType() instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                        codeSegment.newLine().addSourceCode("execute (begin transaction) by ODBC;").newLine(2);
                    }
                    codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent();
                    targetTable.getDBMSType().genExecuteBegin(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent();
                }
                codeSegment.indent().addSourceCode("update ").addSourceCode(sTargetDSName);
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                }
                codeSegment.addSourceCode("\n").indent();
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode("from ");
                    if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                }
                codeSegment.addSourceCode("set ");
                if (currentIndColumn != null) {
                    codeSegment.addSourceCode(currentIndColumn.getColumnName(needsQuotes, usePassThru)).addSourceCode(" = " + currentIndicatorNoValue + ",\n");
                }
                codeSegment.addSourceCode(sToDateColumnName);
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(" = \n");
                } else {
                    codeSegment.addSourceCode(" = (\n");
                }
                codeSegment.indent();
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(tempCloseDate).addSourceCode("\n");
                } else {
                    codeSegment.addSourceCode("select ").addSourceCode(tempCloseDate).addSourceCode("\n").indent().addSourceCode("from ");
                    if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                        codeSegment.addSourceCode("SESSION.");
                    } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                        String schema2 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema2).addSourceCode(".");
                    } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                        String schema3 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema3).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                }
                codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(" \n").unIndent().unIndent();
                } else {
                    codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                    codeSegment.addSourceCode("where exists ( select 1\n").indent().indent().addSourceCode("from ");
                    if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                        codeSegment.addSourceCode("SESSION.");
                    } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                        String schema4 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema4).addSourceCode(".");
                    } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                        String schema5 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema5).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
                }
                if (usePassThru) {
                    targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n");
                    codeSegment.unIndent().genRCSetCall("&sqlrc");
                }
                if (sLoadTimeColumnName.length() > 0) {
                    codeSegment.addCommentLine("Update the load time column");
                    if (usePassThru) {
                        targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                    }
                    codeSegment.addSourceCode("update ").addSourceCode(sTargetDSName);
                    if (sTargetOptions.length() > 0 && !usePassThru) {
                        codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                    }
                    codeSegment.addSourceCode("\n").indent();
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode("from ");
                        if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                    }
                    codeSegment.addSourceCode("set ").addSourceCode(sLoadTimeColumnName);
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(" = \n");
                    } else {
                        codeSegment.addSourceCode(" = (\n");
                    }
                    codeSegment.indent();
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(tempLoadTime).addSourceCode("\n");
                    } else {
                        codeSegment.addSourceCode("select ").addSourceCode(tempLoadTime).addSourceCode("\n").indent().addSourceCode("from ");
                        if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                            codeSegment.addSourceCode("SESSION.");
                        } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                            String schema6 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema6).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                    }
                    codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(" \n").unIndent().unIndent();
                    } else {
                        codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                        codeSegment.addSourceCode("where exists ( select 1 \n").indent().indent().addSourceCode("from ");
                        if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                            codeSegment.addSourceCode("SESSION.");
                        } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                            String schema7 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema7).addSourceCode(".");
                        } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                            String schema8 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema8).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkClose).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
                    }
                    if (usePassThru) {
                        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                    } else {
                        codeSegment.addSourceCode(";\n\n");
                        codeSegment.genRCSetCall("&sqlrc");
                    }
                }
                codeSegment.unIndent().unIndent().unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No records on target table were closed.").addSourceCode("\n").unIndent().addSourceCode("%end;\n");
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    codeSegment.addCommentLine("Update the the type 1 column").addSourceCode("%if &etls_type1cnt gt 0 %then\n%do;\n\n").indent();
                    for (int index = 0; index < lType1Columns.size(); ++index) {
                        String schema9;
                        IColumn column = (IColumn)lType1Columns.get(index);
                        String sColumnName = "";
                        if (usePassThru) {
                            targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                            sColumnName = column.getColumnName(needsQuotes, true);
                        } else {
                            sColumnName = column.getColumnName(needsQuotes, false);
                        }
                        codeSegment.addSourceCode("update ").addSourceCode(sTargetDSName);
                        if (sTargetOptions.length() > 0 && !usePassThru) {
                            codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                        }
                        codeSegment.addSourceCode("\n").indent();
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode("from ");
                            if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                            }
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                        }
                        codeSegment.addSourceCode("set ").addSourceCode(sColumnName);
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode(" = \n");
                        } else {
                            codeSegment.addSourceCode(" = (\n");
                        }
                        codeSegment.indent();
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode(strWorkType1).addSourceCode(".").addSourceCode(sColumnName).addSourceCode("\n");
                        } else {
                            codeSegment.addSourceCode("select ").addSourceCode(sColumnName).addSourceCode("\n").indent().addSourceCode("from ");
                            if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                            } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                                codeSegment.addSourceCode("SESSION.");
                            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                                schema9 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema9).addSourceCode(".");
                            } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                                schema9 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema9).addSourceCode(".");
                            }
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                        }
                        codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode(" \n").unIndent().unIndent();
                        } else {
                            codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                            codeSegment.addSourceCode("where exists ( select 1 \n").indent().indent().addSourceCode("from ");
                            if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                            } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                                codeSegment.addSourceCode("SESSION.");
                            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                                schema9 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema9).addSourceCode(".");
                            } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                                schema9 = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema9).addSourceCode(".");
                            }
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
                        }
                        if (usePassThru) {
                            targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                            continue;
                        }
                        codeSegment.addSourceCode(";\n\n");
                        codeSegment.genRCSetCall("&sqlrc");
                    }
                    codeSegment.unIndent().unIndent().unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No type1 updates were made to target table.").addSourceCode("\n").unIndent().addSourceCode("%end;\n");
                }
                String selectList = codeSegment.makeColumnList(targetTable, true, "      ", usePassThru, ",", "", needsQuotes, "");
                String colList = codeSegment.makeColumnList(targetTable, false, "      ", usePassThru, ",", "", needsQuotes, "");
                codeSegment.addCommentLine("Insert the new matching records").addSourceCode("%if &etls_matchcnt gt 0 %then\n%do;\n\n").indent();
                if (usePassThru) {
                    targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                }
                codeSegment.addSourceCode("insert into ").addSourceCode(sTargetDSName).addSourceCode("\n").indent().addSourceCode("( ");
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(",\n");
                }
                codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("Select ").addSourceCode(selectList).addSourceCode("\n").addSourceCode("from ");
                if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkMatch).unIndent();
                if (usePassThru) {
                    targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n\n");
                    codeSegment.genRCSetCall("&sqlrc");
                }
                codeSegment.unIndent().addSourceCode("%end;\n\n");
                codeSegment.addCommentLine("Insert the new dimension records").addSourceCode("%if &etls_newcnt gt 0 %then\n%do;\n\n").indent();
                if (usePassThru) {
                    targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                }
                codeSegment.addSourceCode("insert into ").addSourceCode(sTargetDSName).addSourceCode("\n").indent().addSourceCode("( ");
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(",\n");
                }
                codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("select ").addSourceCode(selectList).addSourceCode("\n").addSourceCode("from ");
                if (usePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                } else if (usePassThru && useTempLibrary && targetDBMSType instanceof DB2UNXPCType) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                } else if (usePassThru && targetDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    schema = targetDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkNew).unIndent();
                if (usePassThru) {
                    targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n\n");
                    codeSegment.genRCSetCall("&sqlrc");
                }
                codeSegment.unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No new dimension records were added to target table.").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
                if (usePassThru) {
                    if (targetDBMSType instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                        targetDBMSType.genExecuteCommit(codeSegment, targetTable, "execute (commit) by ODBC;");
                    } else {
                        targetDBMSType.genExecuteCommit(codeSegment, targetTable, "");
                    }
                    codeSegment.newLine();
                    targetDBMSType.genDisconnect(codeSegment, targetTable);
                }
                codeSegment.unIndent().addSourceCode("quit;\n\n");
            }
            if (usePassThru) {
                lDeleteWorkTables.add(delWorkClose);
                lDeleteWorkTables.add(delWorkMatch);
                lDeleteWorkTables.add(delWorkNew);
                if (lType1Columns != null && lType1Columns.size() > 0) {
                    lDeleteWorkTables.add(delWorkType1);
                }
                codeSegment.addCommentLine("Delete the work tables").genTableDelete(lDeleteWorkTables);
                if (visualUploadLibrary == null && useTempLibrary) {
                    codeSegment.addCommentLine("Clear the temporary upload library").addSourceCode("libname ").addSourceCode(DBMSTEMPLIBREF).addSourceCode(" clear;\n\n");
                }
            }
            lDeleteWorkTables.clear();
            lDeleteWorkTables.add(WORKETLSNEWRCD);
            lDeleteWorkTables.add(WORKETLSMATCH);
            lDeleteWorkTables.add(WORKETLSCLOSE);
            if (lType1Columns != null && lType1Columns.size() > 0) {
                lDeleteWorkTables.add(WORKETLSTYPE1);
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(lDeleteWorkTables).unIndent().addSourceCode("%end;\n\n");
        }
    }

    protected void genUpdateUsingModify(List lKeyColumns, String sGenKeyColumnName, String sFromDateColumnName, String sToDateColumnName, String sCurrentIndColumnName, String sLoadTimeColumnName, String sTargetDSName, boolean bHasFromDateRename, boolean bIsVersionUpdate, List lType1Columns, ICodeSegment codeSegment, String currentIndicatorYesValue, String currentIndicatorNoValue) {
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        StringBuffer sTbl_opts = new StringBuffer();
        ITransformTableOptions targetOptions = this.getTableOptionObject(targetTable, false);
        sTbl_opts.append(targetOptions.getTableOptions(true, codeSegment.getCurrentServer()));
        StringBuffer modifyTableOptions = new StringBuffer();
        PhysicalTablePromptModelCollection c = targetOptions.getOptionModel();
        if (c != null) {
            IPromptDefinitionValue v = c.findDefinition("ENCRYPT");
            ArrayList<IPromptDefinitionValue> lSources = new ArrayList<IPromptDefinitionValue>(Arrays.asList(c.getDefinitions()));
            if (v != null) {
                lSources.remove(v);
                IPromptDefinitionValue[] defsList = lSources.toArray(new IPromptDefinitionValue[lSources.size()]);
                modifyTableOptions.append(targetOptions.getTableOptions(true, null, null, codeSegment.getCurrentServer(), defsList));
            }
        }
        List indexList = targetTable.getIndexesList();
        String sIndexName = "";
        boolean wasIndexFound = false;
        for (int i = 0; i < indexList.size(); ++i) {
            int keySize;
            IIndex index = (IIndex)indexList.get(i);
            sIndexName = index.getName();
            List colList = index.getColumnsList();
            int idxSize = colList.size();
            if (idxSize != (keySize = lKeyColumns.size())) continue;
            for (int j = 0; j < idxSize; ++j) {
                boolean wasColumnFound = false;
                IColumn column = (IColumn)colList.get(j);
                for (int k = 0; k < keySize; ++k) {
                    IColumn keyColumn = (IColumn)lKeyColumns.get(k);
                    if (keyColumn != column) continue;
                    wasColumnFound = true;
                    break;
                }
                if (!wasColumnFound) break;
                wasColumnFound = false;
                if (j != keySize - 1) continue;
                wasIndexFound = true;
            }
            if (wasIndexFound) break;
        }
        if (this.isTrackChangesByDates() || sCurrentIndColumnName != null && sCurrentIndColumnName.length() > 0) {
            String byList = codeSegment.makeColumnList(lKeyColumns, "   ", codeSegment.isQuoting());
            StringBuffer rename = new StringBuffer();
            if (sGenKeyColumnName.length() > 0) {
                if (bHasFromDateRename) {
                    rename.append(" (rename = (").append(TEMPGENKEY).append(" = ").append(sGenKeyColumnName).append("\n").append(TEMPFROMDATE).append(" = ").append(sFromDateColumnName).append("))");
                } else {
                    rename.append(" (rename = (").append(TEMPGENKEY).append(" = ").append(sGenKeyColumnName).append("))");
                }
            } else {
                rename.append(" (rename = (").append(TEMPFROMDATE).append(" = ").append(sFromDateColumnName).append("))");
            }
            codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent().addSourceCode("data ").addSourceCode(sTargetDSName);
            codeSegment.addSourceCode(";\n\n").indent();
            if (wasIndexFound) {
                codeSegment.addSourceCode("set ").addSourceCode(WORKETLSCLOSE).addSourceCode("\n").addSourceCode(rename).addSourceCode(";\n\n").addSourceCode("modify ").addSourceCode(sTargetDSName).addSourceCode("\n");
                if (modifyTableOptions != null && modifyTableOptions.length() > 0) {
                    codeSegment.addSourceCode(modifyTableOptions).newLine();
                }
                codeSegment.indent().addSourceCode("key = ").addSourceCode(sIndexName).addSourceCode(" / unique;\n\n").unIndent();
            } else {
                codeSegment.addSourceCode("modify ").addSourceCode(sTargetDSName).addSourceCode("\n");
                if (modifyTableOptions != null && modifyTableOptions.length() > 0) {
                    codeSegment.addSourceCode(modifyTableOptions).newLine();
                }
                codeSegment.indent().addSourceCode(WORKETLSCLOSE).addSourceCode("\n").addSourceCode(rename).addSourceCode("\n updatemode=nomissingcheck;\n\n").unIndent().addSourceCode("by ").addSourceCode(byList).addSourceCode(";\n\n");
            }
            if (sToDateColumnName != null) {
                codeSegment.addSourceCode(sToDateColumnName).addSourceCode(" = ").addSourceCode(TEMPCLOSEDATE).addSourceCode(";\n\n");
            }
            if (sCurrentIndColumnName != null && sCurrentIndColumnName.length() > 0) {
                codeSegment.addSourceCode(sCurrentIndColumnName).addSourceCode(" = " + currentIndicatorNoValue + ";\n\n");
            }
            if (sLoadTimeColumnName.length() > 0) {
                codeSegment.addSourceCode(sLoadTimeColumnName).addSourceCode(" = ").addSourceCode(TEMPLOADTIME).addSourceCode(";\n\n");
            }
            codeSegment.addSourceCode("if %sysrc(_SOK) eq _iorc_ then \n").indent().addSourceCode("replace;\n\n").unIndent().addSourceCode("_iorc_ = 0; \n_error_ = 0;\n\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr").unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No records were closed on target table.").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
        }
        if (lType1Columns != null && lType1Columns.size() > 0) {
            this.genType1ColumnnsModifyStep(lType1Columns, lKeyColumns, sGenKeyColumnName, sFromDateColumnName, sLoadTimeColumnName, sTargetDSName, sIndexName, bHasFromDateRename, codeSegment);
        }
        codeSegment.addSectionComment("Append the new records and matching datasets").addSourceCode("%if &etls_matchcnt gt 0 %then\n%do;\n\n").indent().addSourceCode("proc append base = ").addSourceCode(sTargetDSName).addSourceCode("\n").addSourceCode(sTbl_opts).addSourceCode("\n").indent().addSourceCode("data = ").addSourceCode(WORKETLSMATCH).addSourceCode(" force;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr", true).unIndent().addSourceCode("%end;\n");
        if (bIsVersionUpdate) {
            codeSegment.addSourceCode("%else %do;\n\n").indent().genPercentPutStatement("Append the new records and matching datasets").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
        }
        codeSegment.addSourceCode("%if &etls_newcnt gt 0 %then\n%do;\n\n").indent().addSourceCode("proc append base = ").addSourceCode(sTargetDSName).addSourceCode("\n").addSourceCode(sTbl_opts).addSourceCode("\n").indent().addSourceCode("data = ").addSourceCode(WORKETLSNEWRCD).addSourceCode(" force;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr").unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No new dimension records were added to target table.").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
    }

    protected void genType1ColumnnsModifyStep(List lType1Columns, List lKeyColumns, String sGenKeyColumnName, String sFromDateColumnName, String sLoadTimeColumnName, String sTargetDSName, String sIndexName, boolean bHasFromDateRename, ICodeSegment codeSegment) {
        IPhysicalTable target = this.getTargetTable();
        StringBuffer sTbl_opts = new StringBuffer();
        ITransformTableOptions targetOptions = this.getTableOptionObject(target, false);
        sTbl_opts.append(targetOptions.getTableOptions(true, codeSegment.getCurrentServer()));
        StringBuffer modifyTableOptions = new StringBuffer();
        PhysicalTablePromptModelCollection c = targetOptions.getOptionModel();
        if (c != null) {
            IPromptDefinitionValue v = c.findDefinition("ENCRYPT");
            ArrayList<IPromptDefinitionValue> lSources = new ArrayList<IPromptDefinitionValue>(Arrays.asList(c.getDefinitions()));
            if (v != null) {
                lSources.remove(v);
                IPromptDefinitionValue[] defsList = lSources.toArray(new IPromptDefinitionValue[lSources.size()]);
                modifyTableOptions.append(targetOptions.getTableOptions(true, null, null, codeSegment.getCurrentServer(), defsList));
            }
        }
        String byList = codeSegment.makeColumnList(lKeyColumns, "   ", codeSegment.isQuoting());
        StringBuffer rename = new StringBuffer();
        if (sGenKeyColumnName.length() > 0) {
            if (bHasFromDateRename) {
                rename.append(" (rename = (").append(TEMPGENKEY).append(" = ").append(sGenKeyColumnName).append("\n").append(TEMPFROMDATE).append(" = ").append(sFromDateColumnName).append("))");
            } else {
                rename.append(" (rename = (").append(TEMPGENKEY).append(" = ").append(sGenKeyColumnName).append("))");
            }
        } else {
            rename.append(" (rename = (").append(TEMPFROMDATE).append(" = ").append(sFromDateColumnName).append("))");
        }
        codeSegment.addSourceCode("%if &etls_type1cnt gt 0 %then\n%do;\n\n").indent().addSourceCode("data ").addSourceCode(sTargetDSName);
        codeSegment.addSourceCode(";\n\n").indent();
        codeSegment.addSourceCode("modify ").addSourceCode(sTargetDSName).addSourceCode("\n");
        if (modifyTableOptions != null && modifyTableOptions.length() > 0) {
            codeSegment.addSourceCode(modifyTableOptions).newLine();
        }
        codeSegment.indent().addSourceCode(WORKETLSTYPE1).addSourceCode("\n").addSourceCode(rename).addSourceCode("\n updatemode=nomissingcheck;\n\n").unIndent().addSourceCode("by ").addSourceCode(byList).addSourceCode(";\n\n");
        if (sLoadTimeColumnName.length() > 0) {
            codeSegment.addSourceCode(sLoadTimeColumnName).addSourceCode(" = ").addSourceCode(TEMPLOADTIME).addSourceCode(";\n\n");
        }
        codeSegment.addSourceCode("if %sysrc(_SOK) eq _iorc_ then \n").indent().addSourceCode("replace;\n\n").unIndent().addSourceCode("_iorc_ = 0; \n_error_ = 0;\n\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr").unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No target table type 1 update records were found.").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
    }

    protected void genUpdateXrefTable(String sTargetEngine, String sTargetDSName, IPhysicalTable xrefTable, List lBusKeyColumnList, IColumn currentIndColumn, IColumn versNumColumn, boolean bHasDigestValue, boolean bUsePassThru, String sDigestValues, List lPrimaryKeyList, ICodeSegment codeSegment, String currentIndicatorYesValue, String currentIndicatorNoValue) throws MdException, RemoteException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException, CodegenException {
        String xrefDSName = xrefTable.getFullNameQuotedAsNeeded(codeSegment, bUsePassThru);
        ILibrary library = xrefTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        IDBMSType xrefDBMSType = xrefTable.getDBMSType();
        boolean needsQuotes = codeSegment.isQuoting();
        boolean DBMSTempLib = false;
        IColumn[] xrefColumns = xrefTable.getColumns();
        String byBusKey = codeSegment.makeColumnList(lBusKeyColumnList, "      ", needsQuotes);
        xrefDBMSType.deleteAllRows(codeSegment, xrefTable, true);
        if (bHasDigestValue && (!sTargetEngine.equals("BASE") || sTargetEngine.equals("BASE") && this.isUseIndexIfReadingSasds())) {
            String sPrimaryKeyList = "";
            if (lPrimaryKeyList.size() > 0) {
                sPrimaryKeyList = codeSegment.makeColumnList(lPrimaryKeyList, "      ", needsQuotes);
            }
            IColumn sFromDateCol = null;
            if (this.isTrackChangesByDates()) {
                sFromDateCol = this.getFromDateColumn();
            }
            this.genDigestValue(sDigestValues, sTargetDSName, WORKTEMPXREF, sPrimaryKeyList, lBusKeyColumnList, currentIndColumn, versNumColumn, sFromDateCol, this.getToDateColumn(), false, codeSegment, false, "", true, currentIndicatorYesValue, currentIndicatorNoValue);
        } else {
            IPhysicalTable target = this.getTargetTable();
            String sTargetReadOnlyOptions = target.getReadTableOptions(true);
            if (currentIndColumn != null) {
                codeSegment.addSourceCode("data ").addSourceCode(WORKTEMPXREF).addSourceCode(";\n").indent().addSourceCode("set ").addSourceCode(sTargetDSName).addSourceCode(" ").addSourceCode(sTargetReadOnlyOptions).addSourceCode(";\n").addSourceCode("where ").addSourceCode(currentIndColumn.getColumnName(codeSegment)).addSourceCode(" eq " + currentIndicatorYesValue + ";\n").unIndent().addSourceCode("run;\n\n");
            } else {
                codeSegment.addCommentLine("Sort target table").addSourceCode("proc sort data = ").addSourceCode(sTargetDSName).addSourceCode(" ").addSourceCode(sTargetReadOnlyOptions).indent().addSourceCode("\nout = ").addSourceCode(WORKTEMPXREF).addSourceCode(";\n").addSourceCode("by ").addSourceCode(byBusKey).addSourceCode(" ");
                String savedColumnName = "";
                savedColumnName = versNumColumn != null ? versNumColumn.getColumnName(codeSegment) : this.m_toDateColumn.getColumnName(codeSegment);
                codeSegment.addSourceCode(savedColumnName).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
                IColumn lastBKColumn = (IColumn)lBusKeyColumnList.get(lBusKeyColumnList.size() - 1);
                codeSegment.addCommentLine("Get the last key variable in each set of keys").addSourceCode("data ").addSourceCode(WORKTEMPXREF).addSourceCode("; \n").indent().addSourceCode("set ").addSourceCode(WORKTEMPXREF).addSourceCode(";\n").addSourceCode("by ").addSourceCode(byBusKey).addSourceCode(";\n");
                if (!needsQuotes) {
                    codeSegment.addSourceCode("if last.").addSourceCode(lastBKColumn.getColumnName(false)).addSourceCode(";\n");
                } else {
                    codeSegment.addSourceCode("if \"last.").addSourceCode(lastBKColumn.getColumnName(false, false)).addSourceCode("\"n;\n");
                }
                codeSegment.indent().addSourceCode("output;\n").unIndent().unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
            }
            if (bHasDigestValue) {
                this.genDigestValue(sDigestValues, WORKTEMPXREF, WORKTEMPXREF, codeSegment, false, "");
            }
        }
        codeSegment.addCommentLine("Load the cross-reference table");
        String strWorkTable = "";
        String engine = library.getEngine();
        if (xrefDBMSType instanceof SASType) {
            String keepList = codeSegment.makeColumnList(xrefTable, false, "   ", false, " ", "", needsQuotes, "");
            codeSegment.addSectionComment("Append the new records and matching datasets").addSourceCode("proc append base = ").addSourceCode(xrefDSName).addSourceCode("\n").indent().addSourceCode("data = ").addSourceCode(WORKTEMPXREF).addSourceCode("\n(keep = ").addSourceCode(keepList).addSourceCode(")\nforce;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr", true);
            codeSegment.addSourceCode("%if &etls_debug lt 2 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(WORKTEMPXREF).unIndent().addSourceCode("%end;\n\n");
        } else {
            ILibrary uploadLibrary = this.getRunTimeUploadLibrary(bUsePassThru, codeSegment, library);
            ILibrary visualUploadLibrary = this.getUploadLibrary();
            String uploadLibref = "";
            String sasTempTable = "";
            String ptTempTable = "";
            String dbmsXrefTblNameUnquoted = "";
            if (bUsePassThru) {
                sasTempTable = dbmsXrefTblNameUnquoted = codeSegment.getUniqueWorkTableName(100);
                if (needsQuotes) {
                    sasTempTable = DBMSNamesUtil.getQuotedString(sasTempTable, false);
                }
                if (visualUploadLibrary == null && this.useTempLibrary(codeSegment)) {
                    this.genDBMSTempTableLibname(xrefTable, codeSegment);
                    DBMSTempLib = true;
                }
                if (visualUploadLibrary != null) {
                    uploadLibref = uploadLibrary.getLibref();
                }
                codeSegment.addSourceCode("proc sql;\n").indent().addSourceCode("create table ");
                if (visualUploadLibrary == null) {
                    codeSegment.addSourceCode(DBMSTEMPLIBREF);
                } else {
                    codeSegment.addSourceCode(uploadLibref);
                }
                codeSegment.addSourceCode(".").addSourceCode(sasTempTable);
                codeSegment.addSourceCode(" as\n").indent().addSourceCode("Select * from ").addSourceCode(WORKTEMPXREF).addSourceCode(";\n").unIndent().unIndent().addSourceCode("quit;\n").genRCSetCall("&sqlrc");
                ptTempTable = needsQuotes ? DBMSNamesUtil.getQuotedString(dbmsXrefTblNameUnquoted, true) : sasTempTable;
                strWorkTable = ptTempTable;
                strWorkTable = this.getTempTableName(bUsePassThru, this.useTempLibrary(codeSegment), xrefDBMSType, dbmsXrefTblNameUnquoted);
                if (needsQuotes) {
                    strWorkTable = DBMSNamesUtil.getQuotedString(strWorkTable, true);
                }
            } else {
                strWorkTable = WORKTEMPXREF;
            }
            codeSegment.addSourceCode("proc sql ").addSourceCode(this.m_sSQLOptions).addSourceCode(";\n").indent();
            String uploadSchema = "";
            if (bUsePassThru) {
                if (visualUploadLibrary != null) {
                    uploadSchema = xrefTable.getDBMSType().getDBMSTypeName().equals("SAS SPDS") ? uploadLibrary.getLibref() : uploadLibrary.getDatabaseSchema().getSchemaName(codeSegment.getCurrentServer(), this.getTargetTable(), true);
                }
                this.genConnectStatement(codeSegment, xrefTable);
                if (xrefTable.getDBMSType() instanceof ODBCSQLSVRType || xrefTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                    codeSegment.newLine().addSourceCode("execute (begin transaction) by ODBC;").newLine(2);
                }
                xrefDBMSType.genExecuteBegin(codeSegment, xrefTable, "");
            }
            codeSegment.addSourceCode("insert into ").addSourceCode(xrefDSName).addSourceCode("\n").indent();
            String colList = codeSegment.makeColumnList(Arrays.asList(xrefColumns), false, "   ", bUsePassThru, ",", "", codeSegment.isQuoting(), "", false);
            String selectList = codeSegment.makeColumnList(Arrays.asList(xrefColumns), true, "   ", bUsePassThru, ",", "", codeSegment.isQuoting(), "", false);
            codeSegment.addSourceCode("( ").addSourceCode(colList).addSourceCode(")\n\n").addSourceCode("select ").addSourceCode(selectList).unIndent().addSourceCode(" from ");
            if (bUsePassThru && visualUploadLibrary != null && uploadSchema.length() > 0) {
                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
            } else if (bUsePassThru && this.useTempLibrary(codeSegment) && engine.startsWith("DB2")) {
                codeSegment.addSourceCode("SESSION.");
            } else if (bUsePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                String schema = xrefDBMSType.getSchemaName(codeSegment.getCurrentServer(), xrefTable, true);
                codeSegment.addSourceCode(schema).addSourceCode(".");
            }
            codeSegment.addSourceCode(strWorkTable);
            if (bUsePassThru) {
                xrefDBMSType.genExecuteEnd(codeSegment, xrefTable, "");
                if (xrefDBMSType instanceof ODBCSQLSVRType || xrefTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                    xrefDBMSType.genExecuteCommit(codeSegment, xrefTable, "execute (commit) by ODBC;");
                } else {
                    xrefDBMSType.genExecuteCommit(codeSegment, xrefTable, "");
                }
                codeSegment.newLine();
                xrefDBMSType.genDisconnect(codeSegment, xrefTable);
            } else {
                codeSegment.addSourceCode(";\n");
            }
            codeSegment.unIndent().addSourceCode("quit;\n\n").genRCSetCall("&sqlrc");
            if (bUsePassThru) {
                String delTable = "";
                delTable = visualUploadLibrary == null ? "etlstmp." + sasTempTable : uploadLibref + "." + sasTempTable;
                codeSegment.addCommentLine("Delete the uploaded temporary table").genTableDelete(delTable);
                if (visualUploadLibrary == null && this.useTempLibrary(codeSegment)) {
                    codeSegment.addCommentLine("Clear the temporary upload library").addSourceCode("libname ").addSourceCode(DBMSTEMPLIBREF).addSourceCode(" clear;\n\n");
                } else if (visualUploadLibrary != null && visualUploadLibrary != library) {
                    codeSegment.addCommentLine("Clear the temporary upload library").addSourceCode("libname ").addSourceCode(uploadLibref).addSourceCode(" clear;\n\n");
                }
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug lt 2 %then\n").addSourceCode("%do;\n\n").indent();
            codeSegment.genTableDelete(WORKTEMPXREF);
            codeSegment.unIndent().addSourceCode("%end;\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICodeSegment genDBMSTempTableLibname(IPhysicalTable targetTable, ICodeSegment codeSegment) throws RemoteException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        MdObjectStore store = factory.createObjectStore(null, "AbstractSCDTransform: Store");
        try {
            String engine = library.getEngine();
            String libRef = library.getLibref();
            String code = "";
            IDBMSType dbmsType = targetTable.getDBMSType();
            if (dbmsType.getDBMSTypeName().equals("SAS SPDS")) {
                code = library.getLibnameStatement();
            } else {
                SASLibrary sasLibrary = this.addTempProperties(factory, store, library);
                code = this.getLibnameStatement(sasLibrary);
            }
            if (dbmsType instanceof DB2OS390Type || dbmsType instanceof DB2UNXPCType) {
                String schemaName = targetTable.getDBMSType().getSchemaName(codeSegment.getCurrentServer(), targetTable, false);
                String schemaOld = "SCHEMA=" + schemaName;
                String schemaNew = "SCHEMA=SESSION";
                code = code.replaceAll(schemaOld, schemaNew);
            }
            codeSegment.addCommentLine("Generate the temporary table libname statement");
            code = code.replaceFirst(libRef, DBMSTEMPLIBREF);
            int lastSemiColon = code.lastIndexOf(";");
            StringBuffer sbCode = new StringBuffer();
            sbCode.append(code);
            if (dbmsType.getDBMSTypeName().equals("SAS SPDS")) {
                sbCode.replace(lastSemiColon, lastSemiColon, " TEMP=YES");
            } else {
                sbCode.replace(lastSemiColon, lastSemiColon, " DBMSTEMP=YES");
            }
            codeSegment.addSourceCode(sbCode.toString());
            codeSegment.newLine();
        }
        finally {
            store.dispose();
        }
        return codeSegment;
    }

    private SASLibrary addTempProperties(MdFactory factory, MdObjectStore store, ILibrary library) throws MdException, RemoteException {
        String connPropName = CONNECTION_PROPERTY_NAME;
        String connGrpPropName = CONNECTION_GROUP_PROPERTY_NAME;
        List existingProps = library.getOptionsList();
        boolean hasConnection = false;
        boolean hasConnectionGroup = false;
        for (int i = 0; i < existingProps.size(); ++i) {
            IProperty prop = (IProperty)existingProps.get(i);
            if (CONNECTION_PROPERTY_NAME.equalsIgnoreCase(prop.getPropertyName())) {
                hasConnection = true;
            }
            if (!CONNECTION_GROUP_PROPERTY_NAME.equalsIgnoreCase(prop.getPropertyName())) continue;
            hasConnectionGroup = true;
        }
        ISASClientConnection connection = library.getLibraryConnection();
        String engine = library.getEngine();
        SASLibrary sasLibrary = (SASLibrary)factory.createComplexMetadataObject(store, library.getName(), library.getOMRType(), library.getID());
        sasLibrary = (SASLibrary)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)sasLibrary, null, null, "", 8);
        SASClientConnection sasConnection = (SASClientConnection)factory.createComplexMetadataObject(store, connection.getName(), connection.getOMRType(), connection.getID());
        sasConnection = (SASClientConnection)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)sasConnection, null, null, "", 8);
        String fqid = sasConnection.getRepositoryID();
        if (!hasConnection) {
            Property connProp = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, "Type of connection", "Property", fqid);
            PropertyType propType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(store, "Srring", "PropertyType", fqid);
            propType.setSQLType(12);
            connProp.setOwningType(propType);
            connProp.setPropertyName(connPropName);
            connProp.setDelimiter("=");
            connProp.setDefaultValue(CONNECTION_PROPERTY_DEFAULT);
            connProp.setSQLType(12);
            connProp.setAssociatedObject((Root)sasConnection);
        }
        if ("INFORMIX".equalsIgnoreCase(engine) && !hasConnectionGroup) {
            Property connGrpProp = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, "Connection group name", "Property", fqid);
            PropertyType propGrpType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(store, "Srring", "PropertyType", fqid);
            propGrpType.setSQLType(12);
            connGrpProp.setOwningType(propGrpType);
            connGrpProp.setPropertyName(connGrpPropName);
            connGrpProp.setDelimiter("=");
            connGrpProp.setDefaultValue(INFORMIX_CONNECTION_GROUP_DEFAULT);
            connGrpProp.setAssociatedObject((Root)sasConnection);
        }
        return sasLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICodeSegment genConnectStatement(ICodeSegment codeSegment, IPhysicalTable targetTable) throws RemoteException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        MdObjectStore store = factory.createObjectStore(null, "AbstractSCDTransform: Store");
        try {
            boolean bUseConnectUsing;
            SASLibrary sasLibrary = this.addTempProperties(factory, store, library);
            String connectStmt = LibraryUtil.getConnectionOptions((SASLibrary)sasLibrary);
            String additional = library.getDBMSType().getAdditionalConnectionOptions(library, connectStmt);
            StringBuffer code = new StringBuffer();
            if (connectStmt != null && connectStmt.length() > 0) {
                code.append(connectStmt + "\n");
            }
            if (additional != null && additional.length() > 0) {
                code.append(additional + "\n");
            }
            if (bUseConnectUsing = this.isUseConnectUsingEnabled()) {
                codeSegment.addSourceCode("connect using " + library.getLibref() + " as " + library.getEngine() + ";\n");
            } else if (code != null) {
                codeSegment.addSourceCode("connect to " + library.getEngine() + "\n").addSourceCode("( \n").indent();
                codeSegment.addSourceCode(code);
                codeSegment.unIndent().addSourceCode("); \n\n");
            }
        }
        finally {
            store.dispose();
        }
        return codeSegment;
    }

    private String getLibnameStatement(SASLibrary mdoLibrary) throws RemoteException, MdException {
        return LibraryUtil.getAccessPath((SASLibrary)mdoLibrary);
    }

    protected void genDBMSTempMatchOrNewRecordsTable(String sWorkTableName, boolean isMatchTable, ILibrary uploadLibrary, ICodeSegment codeSegment) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException {
        ITransformTableOptions targetOptions;
        if (codeSegment.isQuoting()) {
            sWorkTableName = DBMSNamesUtil.getQuotedString(sWorkTableName, false);
        }
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        IColumn[] lCols = targetTable.getColumns();
        StringBuffer sbAllColumns = new StringBuffer();
        StringBuffer sbIsNullColumns = new StringBuffer();
        sbIsNullColumns.append(" (DBNULL=(");
        boolean hasNullColumns = false;
        boolean bGenerateFormatsInformats = true;
        bGenerateFormatsInformats = this.isFormatGenerationEnabled();
        for (int i = 0; i < lCols.length; ++i) {
            IColumn column = lCols[i];
            boolean isNull = column.isNullable();
            if (!isNull) {
                hasNullColumns = true;
                String columnName = column.getColumnName(codeSegment, false);
                sbIsNullColumns.append(columnName).append(" = NO \n    ");
            }
            sbAllColumns.append("   ").append(column.getAttribStatement(codeSegment.isQuoting(), true, bGenerateFormatsInformats, bGenerateFormatsInformats, true));
        }
        sbIsNullColumns.append("))");
        StringBuffer sbDBMSTemp = new StringBuffer();
        if (uploadLibrary == null) {
            sbDBMSTemp.append(DBMSTEMPLIBREF);
        } else {
            sbDBMSTemp.append(uploadLibrary.getLibref());
        }
        sbDBMSTemp.append(".").append(sWorkTableName);
        String workTable = "";
        if (isMatchTable) {
            workTable = WORKETLSMATCH;
            codeSegment.addSourceCode("%if &etls_matchcnt gt 0 %then\n%do;\n\n").indent();
        } else {
            workTable = WORKETLSNEWRCD;
            codeSegment.addSourceCode("%if &etls_newcnt gt 0 %then\n%do;\n\n").indent();
        }
        ArrayList<String> delWorkTableList = new ArrayList<String>();
        String dbmsTempTable = sbDBMSTemp.toString();
        delWorkTableList.add(dbmsTempTable);
        codeSegment.addCommentLine("Delete the work table").genTableDelete(delWorkTableList);
        codeSegment.addSourceCode("data ").addSourceCode(sbDBMSTemp);
        ILibrary targetLibrary = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        boolean usePassThru = this.isSQLPassThruEnabled(targetLibrary);
        String workTableOptions = "";
        if (isMatchTable && usePassThru) {
            workTableOptions = this.getMatchRecordsWorkTableOptions();
        } else if (!isMatchTable && usePassThru) {
            workTableOptions = this.getNewRecordsWorkTableOptions();
        }
        if (StringUtils.isEmpty((String)workTableOptions)) {
            if (hasNullColumns) {
                codeSegment.addSourceCode(sbIsNullColumns);
            }
        } else if (!StringUtils.isEmpty((String)workTableOptions)) {
            if (hasNullColumns) {
                String sIsNullColumns = sbIsNullColumns.toString();
                sIsNullColumns = sIsNullColumns.replaceFirst("\\(", "");
                sIsNullColumns = sIsNullColumns.substring(0, sIsNullColumns.length() - 1);
                codeSegment.addSourceCode("(" + sIsNullColumns + " " + workTableOptions + ")");
            } else {
                codeSegment.addSourceCode("(" + workTableOptions + ")");
            }
        }
        codeSegment.addSourceCode(";\n").indent().addSourceCode(sbAllColumns).addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        codeSegment.addSectionComment("Append the records into the temporary table").addSourceCode("proc append base = ").addSourceCode(sbDBMSTemp).addSourceCode("\n");
        if (uploadLibrary != null && this.isUseBulkload()) {
            codeSegment.addSourceCode("(").addSourceCode(BULKLOAD_OPTION);
            if (uploadLibrary.getDBMSType() instanceof DB2UNXPCType) {
                codeSegment.addSourceCode(" ").addSourceCode(DB2_BULKLOAD_OPTION);
            }
            if (this.m_bUseSCDChanges) {
                targetOptions = this.getTableOptionObject(targetTable, false);
                codeSegment.addSourceCode(" ").addSourceCode(targetOptions.getTableOptions(false, codeSegment.getCurrentServer()));
            }
            codeSegment.addSourceCode(")\n");
        } else if (this.m_bUseSCDChanges) {
            targetOptions = this.getTableOptionObject(targetTable, false);
            codeSegment.addSourceCode(" ").addSourceCode(targetOptions.getTableOptions(true, codeSegment.getCurrentServer()));
            codeSegment.addSourceCode("\n");
        }
        codeSegment.indent().addSourceCode("data = ").addSourceCode(workTable).addSourceCode(" force;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr", true).unIndent().addSourceCode("%end;\n\n");
    }

    protected void genDBMSTempCloseTable(String sWorkCloseTableName, List lBusKeyColumns, ILibrary uploadLibrary, boolean bHasGeneratedKey, boolean bIsRetainedKey, ICodeSegment codeSegment) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (uploadLibrary != null) {
            IWorkTable table = this.createTempUpdateWorklTable(TEMPCLOSETBLNAME, lBusKeyColumns, bHasGeneratedKey, bIsRetainedKey, new ArrayList());
            boolean usePassThru = this.isSQLPassThruEnabled(uploadLibrary);
            boolean useTempLibrary = this.useTempLibrary(codeSegment);
            IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
            IDBMSType targetTableDBMSType = target.getDBMSType();
            String tempTableName = this.getTempTableName(usePassThru, useTempLibrary, targetTableDBMSType, sWorkCloseTableName);
            target.getFullNameQuotedAsNeeded(codeSegment);
            ArrayList<String> bulkloadOptions = new ArrayList<String>();
            if (this.isUseBulkload()) {
                bulkloadOptions.add(BULKLOAD_OPTION);
                if (uploadLibrary.getDBMSType() instanceof DB2UNXPCType) {
                    bulkloadOptions.add(DB2_BULKLOAD_OPTION);
                }
                if (this.m_bUseSCDChanges) {
                    ITransformTableOptions targetOptions = this.getTableOptionObject(target, false);
                    bulkloadOptions.add(targetOptions.getTableOptions(false, codeSegment.getCurrentServer()));
                }
            }
            String closeWorkTableOptions = "";
            if (usePassThru) {
                closeWorkTableOptions = this.getCloseRecordsWorkTableOptions();
            }
            if (usePassThru && !StringUtils.isEmpty((String)closeWorkTableOptions)) {
                table.moveTableToLibrary(codeSegment, uploadLibrary, true, bulkloadOptions, target.isCaseSensitive(), target.isSpecialCharacters(), sWorkCloseTableName, useTempLibrary, usePassThru, tempTableName, closeWorkTableOptions);
            } else {
                table.moveTableToLibrary(codeSegment, uploadLibrary, true, bulkloadOptions, target.isCaseSensitive(), target.isSpecialCharacters(), sWorkCloseTableName, useTempLibrary, usePassThru, tempTableName);
            }
            this.addToDeletedObjects(table);
        } else {
            if (codeSegment.isQuoting()) {
                sWorkCloseTableName = DBMSNamesUtil.getQuotedString(sWorkCloseTableName, false);
            }
            String tempGenKey = "";
            String tempCloseDate = "";
            String tempFromDate = "";
            String tempLoadTime = "";
            if (codeSegment.isQuoting()) {
                tempGenKey = DBMSNamesUtil.getQuotedString(TEMPGENKEY, false);
                tempCloseDate = DBMSNamesUtil.getQuotedString(TEMPCLOSEDATE, false);
                tempFromDate = DBMSNamesUtil.getQuotedString(TEMPFROMDATE, false);
                tempLoadTime = DBMSNamesUtil.getQuotedString(TEMPLOADTIME, false);
            } else {
                tempGenKey = TEMPGENKEY;
                tempCloseDate = TEMPCLOSEDATE;
                tempFromDate = TEMPFROMDATE;
                tempLoadTime = TEMPLOADTIME;
            }
            String wrkClose = "etlstmp." + sWorkCloseTableName;
            StringBuffer sbTempLoadTime = new StringBuffer();
            if (this.getLoadTimeColumn() != null) {
                String sLoadtimeInformat;
                sbTempLoadTime.append("attrib ").append(tempLoadTime).append(" length=8");
                String sLoadtimeFormat = this.getLoadTimeColumn().getFormat();
                if (sLoadtimeFormat.length() > 0) {
                    sbTempLoadTime.append(" format = ").append(sLoadtimeFormat);
                }
                if ((sLoadtimeInformat = this.getLoadTimeColumn().getInformat()).length() > 0) {
                    sbTempLoadTime.append(" informat = ").append(sLoadtimeInformat);
                }
                sbTempLoadTime.append(";\n");
            }
            StringBuffer sbTempCloseDate = new StringBuffer();
            if (this.m_toDateColumn != null) {
                String sToDateInformat;
                String sToDateFormat = this.m_toDateColumn.getFormat();
                if (sToDateFormat.length() > 0) {
                    sbTempCloseDate.append(" format = ").append(sToDateFormat);
                }
                if ((sToDateInformat = this.m_toDateColumn.getInformat()).length() > 0) {
                    sbTempCloseDate.append(" informat = ").append(sToDateInformat);
                }
            }
            sbTempCloseDate.append(";\n");
            StringBuffer sbTempFromDate = new StringBuffer();
            if (this.m_fromDateColumn != null && this.isTrackChangesByDates()) {
                String sFromDateInformat;
                sbTempFromDate.append("attrib ").append(tempFromDate);
                sbTempFromDate.append(" length=8");
                String sFromDateFormat = this.m_fromDateColumn.getFormat();
                if (sFromDateFormat.length() > 0) {
                    sbTempFromDate.append(" format = ").append(sFromDateFormat);
                }
                if ((sFromDateInformat = this.m_fromDateColumn.getInformat()).length() > 0) {
                    sbTempFromDate.append(" informat = ").append(sFromDateInformat);
                }
                sbTempFromDate.append(";\n");
            }
            codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent();
            codeSegment.addSourceCode("data ").addSourceCode(wrkClose).addSourceCode(";\n").indent();
            if (bHasGeneratedKey) {
                codeSegment.addSourceCode("attrib ").addSourceCode(tempGenKey).addSourceCode(" length=8;\n");
                if (bIsRetainedKey) {
                    codeSegment.addSourceCode(sbTempFromDate);
                }
            } else {
                boolean bGenerateFormatsInformats = true;
                bGenerateFormatsInformats = this.isFormatGenerationEnabled();
                for (int i = 0; i < lBusKeyColumns.size(); ++i) {
                    IColumn keyColumn = (IColumn)lBusKeyColumns.get(i);
                    codeSegment.addSourceCode(keyColumn.getAttribStatement(codeSegment.isQuoting(), true, bGenerateFormatsInformats, bGenerateFormatsInformats, true));
                }
                codeSegment.addSourceCode(sbTempFromDate);
            }
            if (this.m_toDateColumn != null) {
                codeSegment.addSourceCode("attrib ").addSourceCode(tempCloseDate).addSourceCode(" length=8").addSourceCode(sbTempCloseDate);
            }
            codeSegment.addSourceCode(sbTempLoadTime);
            codeSegment.addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
            codeSegment.addSectionComment("Append the records into the temporary table").addSourceCode("proc append base = ").addSourceCode(wrkClose).addSourceCode("\n").indent().addSourceCode("data = ").addSourceCode(WORKETLSCLOSE).addSourceCode(" force;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr", true).unIndent().addSourceCode("%end;\n\n");
        }
    }

    protected void genDBMSTempType1Table(String sWorkType1TableName, List lBusKeyColumns, ILibrary uploadLibrary, boolean bHasGeneratedKey, boolean bIsRetainedKey, List lType1Columns, ICodeSegment codeSegment) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        boolean bGenerateFormatsInformats = true;
        bGenerateFormatsInformats = this.isFormatGenerationEnabled();
        if (uploadLibrary != null) {
            IWorkTable table = this.createTempUpdateWorklTable(TEMPTYPE1TBLNAME, lBusKeyColumns, bHasGeneratedKey, bIsRetainedKey, lType1Columns);
            boolean usePassThru = this.isSQLPassThruEnabled(uploadLibrary);
            boolean useTempLibrary = this.useTempLibrary(codeSegment);
            IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
            IDBMSType targetTableDBMSType = target.getDBMSType();
            String tempTableName = this.getTempTableName(usePassThru, useTempLibrary, targetTableDBMSType, sWorkType1TableName);
            ArrayList<String> bulkloadOptions = new ArrayList<String>();
            if (this.isUseBulkload()) {
                bulkloadOptions.add(BULKLOAD_OPTION);
                if (uploadLibrary.getDBMSType() instanceof DB2UNXPCType) {
                    bulkloadOptions.add(DB2_BULKLOAD_OPTION);
                }
            }
            String type1WorkTableOptions = "";
            if (usePassThru) {
                type1WorkTableOptions = this.getType1RecordsWorkTableOptions();
            }
            if (usePassThru && !StringUtils.isEmpty((String)type1WorkTableOptions)) {
                table.moveTableToLibrary(codeSegment, uploadLibrary, true, bulkloadOptions, target.isCaseSensitive(), target.isSpecialCharacters(), sWorkType1TableName, useTempLibrary, usePassThru, tempTableName, type1WorkTableOptions);
            } else {
                table.moveTableToLibrary(codeSegment, uploadLibrary, true, bulkloadOptions, target.isCaseSensitive(), target.isSpecialCharacters(), sWorkType1TableName, useTempLibrary, usePassThru, tempTableName);
            }
            this.addToDeletedObjects(table);
        } else {
            if (codeSegment.isQuoting()) {
                sWorkType1TableName = DBMSNamesUtil.getQuotedString(sWorkType1TableName, false);
            }
            String tempGenKey = "";
            String tempFromDate = "";
            String tempLoadTime = "";
            if (codeSegment.isQuoting()) {
                tempGenKey = DBMSNamesUtil.getQuotedString(TEMPGENKEY, false);
                tempFromDate = DBMSNamesUtil.getQuotedString(TEMPFROMDATE, false);
                tempLoadTime = DBMSNamesUtil.getQuotedString(TEMPLOADTIME, false);
            } else {
                tempGenKey = TEMPGENKEY;
                tempFromDate = TEMPFROMDATE;
                tempLoadTime = TEMPLOADTIME;
            }
            String wrkType1 = "";
            wrkType1 = uploadLibrary == null ? "etlstmp." + sWorkType1TableName : uploadLibrary.getLibref() + "." + sWorkType1TableName;
            StringBuffer sbTempLoadTime = new StringBuffer();
            if (this.getLoadTimeColumn() != null) {
                String sLoadtimeInformat;
                sbTempLoadTime.append("attrib ").append(tempLoadTime).append(" length=8");
                String sLoadtimeFormat = this.getLoadTimeColumn().getFormat();
                if (sLoadtimeFormat.length() > 0) {
                    sbTempLoadTime.append(" format = ").append(sLoadtimeFormat);
                }
                if ((sLoadtimeInformat = this.getLoadTimeColumn().getInformat()).length() > 0) {
                    sbTempLoadTime.append(" informat = ").append(sLoadtimeInformat);
                }
                sbTempLoadTime.append(";\n");
            }
            StringBuffer sbTempFromDate = new StringBuffer();
            if (this.m_fromDateColumn != null && this.isTrackChangesByDates()) {
                String sFromDateInformat;
                sbTempFromDate.append("attrib ").append(tempFromDate);
                sbTempFromDate.append(" length=8");
                String sFromDateFormat = this.m_fromDateColumn.getFormat();
                if (sFromDateFormat.length() > 0) {
                    sbTempFromDate.append(" format = ").append(sFromDateFormat);
                }
                if ((sFromDateInformat = this.m_fromDateColumn.getInformat()).length() > 0) {
                    sbTempFromDate.append(" informat = ").append(sFromDateInformat);
                }
                sbTempFromDate.append(";\n");
            }
            codeSegment.addSourceCode("%if &etls_type1cnt gt 0 %then\n%do;\n\n").indent();
            codeSegment.addSourceCode("data ").addSourceCode(wrkType1).addSourceCode(";\n").indent();
            if (bHasGeneratedKey) {
                codeSegment.addSourceCode("attrib ").addSourceCode(tempGenKey).addSourceCode(" length=8;\n");
                if (bIsRetainedKey) {
                    codeSegment.addSourceCode(sbTempFromDate);
                }
            } else {
                for (int i = 0; i < lBusKeyColumns.size(); ++i) {
                    IColumn keyColumn = (IColumn)lBusKeyColumns.get(i);
                    codeSegment.addSourceCode(keyColumn.getAttribStatement(codeSegment.isQuoting(), true, bGenerateFormatsInformats, bGenerateFormatsInformats, true));
                }
                codeSegment.addSourceCode(sbTempFromDate);
            }
            for (int index = 0; index < lType1Columns.size(); ++index) {
                IColumn column = (IColumn)lType1Columns.get(index);
                codeSegment.addSourceCode(column.getAttribStatement(codeSegment.isQuoting(), true, bGenerateFormatsInformats, bGenerateFormatsInformats, true));
            }
            codeSegment.addSourceCode(sbTempLoadTime);
            codeSegment.addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
            codeSegment.addSectionComment("Append the records into the temporary table").addSourceCode("proc append base = ").addSourceCode(wrkType1).addSourceCode("\n").indent().addSourceCode("data = ").addSourceCode(WORKETLSTYPE1).addSourceCode(" force;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr", true).unIndent().addSourceCode("%end;\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IWorkTable createTempUpdateWorklTable(String sTableName, List lBusKeyColumns, boolean bHasGeneratedKey, boolean bIsRetainedKey, List lAdditionalColumns) {
        boolean bEventsEnabled = this.getModel().isModelEventsEnabled();
        boolean bUndoSupported = this.getModel().isUndoSupported();
        this.getModel().setModelEventsEnabled(false);
        this.getModel().setUndoSupported(false);
        try {
            IColumn column;
            IWorkTable table = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            table.setCompressed(false);
            table.setEncrypted(false);
            table.setSASTableName(sTableName);
            IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
            table.setCaseSensitive(targetTable.isCaseSensitive());
            table.setSpecialCharacters(targetTable.isSpecialCharacters());
            IIndex tableIndex = null;
            if (this.m_bTempUpdateTblIndex) {
                tableIndex = this.getModel().getObjectFactory().createNewIndex(this.getID());
                table.getIndexesList().add(tableIndex);
            }
            if (bHasGeneratedKey) {
                IColumn column2 = this.getModel().getObjectFactory().createNewColumn(this.getID());
                column2.setName(TEMPGENKEY);
                column2.setLength(8);
                column2.setType(1);
                column2.setNullable(false);
                table.addColumn(column2);
                if (tableIndex != null) {
                    tableIndex.getColumnsList().add(column2);
                }
                if (bIsRetainedKey) {
                    IColumn fromColumn = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    this.m_fromDateColumn.deepCopy(fromColumn);
                    fromColumn.setName(TEMPFROMDATE);
                    table.addColumn(fromColumn);
                    if (tableIndex != null) {
                        tableIndex.getColumnsList().add(fromColumn);
                    }
                }
            } else {
                for (int index = 0; index < lBusKeyColumns.size(); ++index) {
                    IColumn keyColumn = (IColumn)lBusKeyColumns.get(index);
                    column = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    keyColumn.deepCopy(column);
                    table.addColumn(column);
                    if (tableIndex == null) continue;
                    tableIndex.getColumnsList().add(column);
                }
                IColumn fromColumn = this.getModel().getObjectFactory().createNewColumn(this.getID());
                this.m_fromDateColumn.deepCopy(fromColumn);
                fromColumn.setName(TEMPFROMDATE);
                table.addColumn(fromColumn);
                if (tableIndex != null) {
                    tableIndex.getColumnsList().add(fromColumn);
                }
            }
            if (tableIndex != null) {
                if (targetTable.getDBMSType() instanceof SASType) {
                    if (tableIndex.getColumnsList().size() == 1) {
                        tableIndex.setName(tableIndex.getColumns()[0].getName());
                    } else {
                        tableIndex.setName("SCDIndex");
                    }
                } else {
                    StringBuffer newName = new StringBuffer();
                    int uniqueSuffix = rand.nextInt(99999) + 1;
                    newName.append(SCD_INDEX_PREFIX);
                    newName.append("_");
                    newName.append(uniqueSuffix);
                    tableIndex.setName(newName.toString());
                }
            }
            if (this.m_toDateColumn != null && this.isTrackChangesByDates() && !sTableName.equalsIgnoreCase(TEMPTYPE1TBLNAME)) {
                IColumn toColumn = this.getModel().getObjectFactory().createNewColumn(this.getID());
                this.m_toDateColumn.deepCopy(toColumn);
                if (sTableName.equalsIgnoreCase(TEMPCLOSETBLNAME)) {
                    toColumn.setName(TEMPCLOSEDATE);
                } else {
                    toColumn.setName(TEMPTODATE);
                }
                table.addColumn(toColumn);
            }
            for (int index = 0; index < lAdditionalColumns.size(); ++index) {
                IColumn addColumn = (IColumn)lAdditionalColumns.get(index);
                column = this.getModel().getObjectFactory().createNewColumn(this.getID());
                addColumn.deepCopy(column);
                table.addColumn(column);
            }
            if (this.getLoadTimeColumn() != null) {
                IColumn loadColumn = this.getLoadTimeColumn();
                IColumn column3 = this.getModel().getObjectFactory().createNewColumn(this.getID());
                loadColumn.deepCopy(column3);
                column3.setName(TEMPLOADTIME);
                table.addColumn(column3);
            }
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.getModel().setModelEventsEnabled(bEventsEnabled);
            this.getModel().setUndoSupported(bUndoSupported);
        }
    }

    protected void cleanupMappings() {
        if (!this.isTrackChangesByDates()) {
            IMapping toMapping;
            IMapping fromMapping = this.findTargetMapping(FROM_DATE_TRANSFORMROLE);
            if (fromMapping != null) {
                this.removeMapping(fromMapping);
            }
            if ((toMapping = this.findTargetMapping(TO_DATE_TRANSFORMROLE)) != null) {
                this.removeMapping(toMapping);
            }
        }
    }

    public String getTempTableName(boolean bUsePassThru, boolean bUseTempLibrary, IDBMSType dbmsType, String tableName) throws BadLibraryDefinitionException {
        if (tableName != null && tableName.length() > 0) {
            String tempTableName = "";
            String tempTablePrefix = "";
            if (bUsePassThru && bUseTempLibrary) {
                if (dbmsType.getDBMSTypeName().equals("SQL Server")) {
                    tempTablePrefix = "##";
                } else if (dbmsType.getDBMSTypeName().equals("SAS SPDS")) {
                    tempTablePrefix = "etlstmp.";
                } else if (dbmsType.getDBMSTypeName().equals("SAP HANA")) {
                    tempTablePrefix = "#";
                }
            }
            tempTableName = tempTablePrefix + tableName;
            return tempTableName;
        }
        return tableName;
    }

    public ILibrary getRunTimeUploadLibrary(boolean bUsePassThru, ICodeSegment codeSegment, ILibrary targetLibrary) throws BadLibraryDefinitionException {
        if (this.getUploadLibrary() == null) {
            if (this.useTempLibrary(codeSegment) && bUsePassThru) {
                return new cTempLibrary(codeSegment, targetLibrary);
            }
            return targetLibrary;
        }
        return this.getUploadLibrary();
    }

    protected String genCreateTempXrefTable(String targetDSName, List busKeyList, List primaryKeyList, IColumn currentIndColumn, IColumn versNumColumn, boolean isRetainedKey, boolean hasDigestValue, String digestValues, String sXrefDSName, ICodeSegment codeSegment, String sTargetEngine, String digestValuesType1, List type1Columns, List type2Columns, String currentIndicatorYesValue, String currentIndicatorNoValue) throws MdException, RemoteException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        boolean preSortTargetTable = this.isSortTempXref();
        boolean useByStmtProcessing = true;
        if (sTargetEngine.equalsIgnoreCase("BASE") && !this.isUseIndexIfReadingSasds() && currentIndColumn != null && !preSortTargetTable) {
            useByStmtProcessing = false;
        }
        if (sXrefDSName == null || sXrefDSName.length() == 0) {
            sXrefDSName = WORKTEMPXREF;
        }
        codeSegment.addCommentLine("Delete any existing temporary cross-reference table");
        codeSegment.genTableDelete(sXrefDSName);
        String sByBusKey = codeSegment.makeColumnList(busKeyList, " ", codeSegment.isQuoting()).trim();
        IPhysicalTable target = this.getTargetTable();
        String sTargetReadOnlyOptions = target.getReadTableOptions(true);
        StringBuffer sbKeepList = new StringBuffer();
        if (primaryKeyList != null) {
            sbKeepList.append(codeSegment.makeColumnList(primaryKeyList, " ", codeSegment.isQuoting()));
        }
        if (sbKeepList.length() > 0) {
            sbKeepList.append(" ");
        }
        sbKeepList.append(codeSegment.makeColumnList(busKeyList, " ", codeSegment.isQuoting()));
        if (this.getFromDateColumn() != null && this.isTrackChangesByDates()) {
            sbKeepList.append(" ");
            sbKeepList.append(this.getFromDateColumn().getColumnName(codeSegment));
        }
        if (this.getToDateColumn() != null && this.isTrackChangesByDates()) {
            sbKeepList.append(" ");
            sbKeepList.append(this.getToDateColumn().getColumnName(codeSegment));
        }
        if (versNumColumn != null) {
            sbKeepList.append(" ");
            sbKeepList.append(versNumColumn.getColumnName(codeSegment));
        }
        if (currentIndColumn != null) {
            sbKeepList.append(" ");
            sbKeepList.append(currentIndColumn.getColumnName(codeSegment));
        }
        if (type1Columns != null) {
            sbKeepList.append(" ");
            sbKeepList.append(codeSegment.makeColumnList(type1Columns, " ", codeSegment.isQuoting()));
        }
        if (type2Columns != null) {
            sbKeepList.append(" ");
            sbKeepList.append(codeSegment.makeColumnList(type2Columns, " ", codeSegment.isQuoting()));
        }
        String sKeepList = sbKeepList.toString();
        String[] sDataKeepColumns = sKeepList.split(" ");
        List<String> lDataKeepColumns = Arrays.asList(sDataKeepColumns);
        String dataKeepColumns = codeSegment.makeColumnList(lDataKeepColumns, " ", false);
        if (hasDigestValue) {
            String extraByColumnName = "";
            if (versNumColumn != null) {
                extraByColumnName = versNumColumn.getColumnName(codeSegment);
            } else if (this.isTrackChangesByDates() && this.m_toDateColumn != null) {
                extraByColumnName = this.getToDateColumn().getColumnName(codeSegment);
            }
            String sourceTableForMD5DataStep = targetDSName + " " + sTargetReadOnlyOptions;
            if (preSortTargetTable) {
                codeSegment.addCommentLine("Sort target table records before creating the temporary cross reference table:");
                String targetTableReadOnlyOptions = this.getTargetTable().getReadTableOptions(false);
                if (currentIndColumn != null) {
                    codeSegment.addSourceCode("proc sort data = " + targetDSName + "(where = (" + currentIndColumn.getColumnName(codeSegment) + " = " + currentIndicatorYesValue + ")");
                    if (targetTableReadOnlyOptions != null && targetTableReadOnlyOptions.trim().length() > 0) {
                        codeSegment.newLine();
                        codeSegment.addSourceCode(targetTableReadOnlyOptions);
                    }
                    codeSegment.addSourceCode(")");
                } else {
                    codeSegment.addSourceCode("proc sort data = " + targetDSName);
                    if (targetTableReadOnlyOptions != null && targetTableReadOnlyOptions.trim().length() > 0) {
                        codeSegment.addSourceCode("(" + targetTableReadOnlyOptions + ")");
                    }
                }
                codeSegment.newLine();
                codeSegment.indent();
                codeSegment.addSourceCode("out = " + sXrefDSName);
                if (type2Columns != null && type2Columns.size() > 0) {
                    codeSegment.addSourceCode("(keep=" + dataKeepColumns + ");");
                } else {
                    codeSegment.addSourceCode("; ");
                }
                codeSegment.newLine();
                if (currentIndColumn != null) {
                    codeSegment.addSourceCode("by " + sByBusKey + ";");
                } else {
                    codeSegment.addSourceCode("by " + sByBusKey + " " + extraByColumnName + ";");
                }
                codeSegment.unIndent();
                codeSegment.newLine();
                codeSegment.addSourceCode("run;");
                codeSegment.newLine(2);
                codeSegment.genRCSetCall("&syscc");
                sourceTableForMD5DataStep = sXrefDSName;
            }
            String keyList = "";
            if (primaryKeyList != null && primaryKeyList.size() > 0) {
                keyList = codeSegment.makeColumnList(primaryKeyList, " ", codeSegment.isQuoting());
            }
            boolean bGenType1Digest = false;
            if (!digestValuesType1.equals("") && digestValuesType1.length() > 0) {
                bGenType1Digest = true;
            }
            this.genDigestValue(digestValues, sourceTableForMD5DataStep, sXrefDSName, keyList, busKeyList, currentIndColumn, versNumColumn, this.getFromDateColumn(), this.getToDateColumn(), true, codeSegment, bGenType1Digest, digestValuesType1, useByStmtProcessing, true, sKeepList, currentIndicatorYesValue, currentIndicatorNoValue, preSortTargetTable, type2Columns);
            if (!useByStmtProcessing) {
                codeSegment.addCommentLine("Sort temporary cross reference table");
                codeSegment.addSourceCode("proc sort data = " + sXrefDSName + ";");
                codeSegment.indent();
                codeSegment.newLine();
                codeSegment.addSourceCode("by " + sByBusKey + ";");
                codeSegment.newLine();
                codeSegment.unIndent();
                codeSegment.addSourceCode("run;");
                codeSegment.newLine(2);
                codeSegment.genRCSetCall("&syscc");
            }
            return sXrefDSName;
        }
        if (currentIndColumn != null) {
            codeSegment.addSourceCode("data ").addSourceCode(sXrefDSName).addSourceCode(";\n").indent().addSourceCode("set ").addSourceCode(targetDSName);
            if (sTargetReadOnlyOptions.length() > 0) {
                codeSegment.addSourceCode("\n").addSourceCode(sTargetReadOnlyOptions).addSourceCode("\n");
            }
            codeSegment.addSourceCode(";\n").addSourceCode("where ").addSourceCode(currentIndColumn.getColumnName(codeSegment)).addSourceCode(" eq " + currentIndicatorYesValue + ";\n").unIndent().addSourceCode("run;\n\n");
        } else {
            if (sTargetEngine.equals("BASE") && !this.isUseIndexIfReadingSasds()) {
                codeSegment.addCommentLine("Sort target table").addSourceCode("proc sort data = ").addSourceCode(targetDSName);
                if (sTargetReadOnlyOptions.length() > 0) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetReadOnlyOptions).addSourceCode("\n");
                }
                codeSegment.indent().addSourceCode("\nout = ").addSourceCode(sXrefDSName).addSourceCode(";\n").addSourceCode("by ").addSourceCode(sByBusKey).addSourceCode(" ");
                String savedColumnName = "";
                if (versNumColumn != null) {
                    savedColumnName = versNumColumn.getColumnName(codeSegment);
                } else if (this.m_toDateColumn != null) {
                    savedColumnName = this.getToDateColumn().getColumnName(codeSegment);
                }
                codeSegment.addSourceCode(savedColumnName).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
            }
            IColumn lastBKColumn = (IColumn)busKeyList.get(busKeyList.size() - 1);
            String keyList = "";
            if (primaryKeyList != null && primaryKeyList.size() > 0) {
                keyList = codeSegment.makeColumnList(primaryKeyList, "   ", codeSegment.isQuoting());
            }
            codeSegment.addCommentLine("Get the last key variable in each set of keys").addSourceCode("data ").addSourceCode(sXrefDSName).addSourceCode("; \n").indent();
            if (sTargetEngine.equals("BASE") && !this.isUseIndexIfReadingSasds()) {
                codeSegment.addSourceCode("set ").addSourceCode(sXrefDSName);
            } else {
                codeSegment.addSourceCode("set ").addSourceCode(targetDSName);
                if (sTargetReadOnlyOptions.length() > 0) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetReadOnlyOptions).addSourceCode("\n");
                }
            }
            codeSegment.addSourceCode("(KEEP = ").addSourceCode(keyList);
            codeSegment.addSourceCode(" ").addSourceCode(sByBusKey).addSourceCode("\n");
            if (this.m_fromDateColumn != null) {
                String fromDateName = this.getFromDateColumn().getColumnName(codeSegment);
                if (!isRetainedKey) {
                    codeSegment.addSourceCode(" ").addSourceCode(fromDateName).addSourceCode("\n");
                }
            }
            if (this.m_toDateColumn != null) {
                String toDateName = this.getToDateColumn().getColumnName(codeSegment);
                codeSegment.addSourceCode(toDateName);
            }
            codeSegment.addSourceCode(");\n");
            codeSegment.addSourceCode("by ").addSourceCode(sByBusKey);
            if (this.m_toDateColumn != null) {
                codeSegment.addSourceCode(" ").addSourceCode(this.getToDateColumn().getColumnName(codeSegment));
            }
            codeSegment.addSourceCode(";\n");
            if (!codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if last.").addSourceCode(lastBKColumn.getColumnName(codeSegment)).addSourceCode(";\n");
            } else {
                codeSegment.addSourceCode("if \"last.").addSourceCode(lastBKColumn.getColumnName(false)).addSourceCode("\"n;\n");
            }
            codeSegment.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        }
        return sXrefDSName;
    }

    protected void genDigestValue(String digestValues, String inputTableDSName, String outputTableDSName, String primaryKeys, List busKeyList, IColumn currIndColumn, IColumn versNumColumn, IColumn fromDateColumn, IColumn toDateColumn, boolean keepEndDate, ICodeSegment codeSegment, boolean genType1Digest, String digestValuesType1, boolean useByStmtProcessing, boolean isTempXREF, String keepTargetColumnList, String currentIndicatorYesValue, String currentIndicatorNoValue, boolean preSortTargetTable) throws MdException, RemoteException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        this.genDigestValue(digestValues, inputTableDSName, outputTableDSName, primaryKeys, busKeyList, currIndColumn, versNumColumn, fromDateColumn, toDateColumn, keepEndDate, codeSegment, genType1Digest, digestValuesType1, useByStmtProcessing, isTempXREF, keepTargetColumnList, currentIndicatorYesValue, currentIndicatorNoValue, preSortTargetTable, null);
    }

    protected void genDigestValue(String digestValues, String inputTableDSName, String outputTableDSName, String primaryKeys, List busKeyList, IColumn currIndColumn, IColumn versNumColumn, IColumn fromDateColumn, IColumn toDateColumn, boolean keepEndDate, ICodeSegment codeSegment, boolean genType1Digest, String digestValuesType1, boolean useByStmtProcessing, boolean isTempXREF, String keepTargetColumnList, String currentIndicatorYesValue, String currentIndicatorNoValue, boolean preSortTargetTable, List type2Columns) throws MdException, RemoteException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String sBusKey = codeSegment.makeColumnList(busKeyList, " ", codeSegment.isQuoting());
        IColumn lastBKColumn = (IColumn)busKeyList.get(busKeyList.size() - 1);
        String sByCols = sBusKey;
        String sKeepCols = primaryKeys + " " + sBusKey;
        String sFromDateName = "";
        String sToDateName = "";
        if (versNumColumn != null) {
            String sVersColumnName = versNumColumn.getColumnName(codeSegment);
            if (currIndColumn == null) {
                sByCols = sByCols + " " + sVersColumnName;
            }
            sKeepCols = sKeepCols + " " + sVersColumnName;
        } else if (toDateColumn != null && this.isTrackChangesByDates() && currIndColumn == null) {
            sToDateName = toDateColumn.getColumnName(codeSegment);
            sByCols = sByCols + " " + sToDateName;
        }
        if (fromDateColumn != null && this.isTrackChangesByDates()) {
            sFromDateName = fromDateColumn.getColumnName(codeSegment);
            sKeepCols = sKeepCols + " " + sFromDateName;
        }
        if (toDateColumn != null && this.isTrackChangesByDates() && keepEndDate) {
            sToDateName = toDateColumn.getColumnName(codeSegment);
            sKeepCols = sKeepCols + " " + sToDateName;
        }
        String[] sDataKeepColumns = sKeepCols.split(" ");
        List<String> lDataKeepColumns = Arrays.asList(sDataKeepColumns);
        String dataKeepColumns = codeSegment.makeColumnList(lDataKeepColumns, " ", false);
        String[] sSetKeepColumns = keepTargetColumnList.split(" ");
        List<String> lSetKeepColumns = Arrays.asList(sSetKeepColumns);
        String setKeepColumns = codeSegment.makeColumnList(lSetKeepColumns, " ", false);
        if (this.getChangeDigestVersion().equalsIgnoreCase(DEFAULT_CHANGE_DIGEST_VERSION)) {
            codeSegment.addCommentLine("Generate change digest (v1.1)");
            codeSegment.addSourceCode("data ");
            codeSegment.addSourceCode(outputTableDSName.trim());
            codeSegment.addSourceCode("(keep = ");
            codeSegment.addSourceCode(dataKeepColumns);
            codeSegment.addSourceCode(" DIGEST_VALUE");
            if (genType1Digest) {
                codeSegment.addSourceCode(" DIGEST_VALUE_TYPE1");
            }
            codeSegment.addSourceCode(");");
            codeSegment.newLine(2);
            codeSegment.indent();
            codeSegment.addSourceCode("length etls_md5 $16.;");
            codeSegment.newLine();
            codeSegment.addSourceCode("length DIGEST_VALUE $32.;");
            codeSegment.newLine();
            if (genType1Digest) {
                codeSegment.addSourceCode("length DIGEST_VALUE_TYPE1 $32.;");
                codeSegment.newLine();
            }
            codeSegment.newLine();
            codeSegment.addSourceCode("set ");
            if (!preSortTargetTable && type2Columns != null && type2Columns.size() > 0) {
                String targetTableName = this.getTargetTable().getFullNameQuotedAsNeeded(codeSegment);
                codeSegment.addSourceCode(targetTableName);
                codeSegment.addSourceCode("(keep = " + setKeepColumns);
                String targetTableReadOnlyOptions = this.getTargetTable().getReadTableOptions(false);
                if (targetTableReadOnlyOptions != null && targetTableReadOnlyOptions.trim().length() > 0) {
                    codeSegment.newLine();
                    codeSegment.addSourceCode(targetTableReadOnlyOptions);
                }
                codeSegment.addSourceCode(")");
            } else {
                codeSegment.addSourceCode(inputTableDSName.trim());
            }
            codeSegment.addSourceCode(";");
            if (useByStmtProcessing) {
                codeSegment.newLine(2);
                codeSegment.addSourceCode("by " + sByCols + ";");
                codeSegment.newLine();
            }
            if (currIndColumn != null && !this.isSortTempXref()) {
                codeSegment.newLine();
                codeSegment.addSourceCode("where " + currIndColumn.getColumnName(codeSegment));
                codeSegment.addSourceCode(" = " + currentIndicatorYesValue + ";");
                codeSegment.newLine();
            }
            if (useByStmtProcessing && currIndColumn == null) {
                codeSegment.newLine();
                if (codeSegment.isQuoting()) {
                    codeSegment.addSourceCode("if \"last.");
                    codeSegment.addSourceCode(lastBKColumn.getColumnName(false));
                    codeSegment.addSourceCode("\"n");
                } else {
                    codeSegment.addSourceCode("if last.");
                    codeSegment.addSourceCode(lastBKColumn.getColumnName(false));
                }
                codeSegment.addSourceCode(";");
                codeSegment.newLine();
            }
            codeSegment.newLine();
            codeSegment.addSourceCode("etls_str = '\"' ||");
            codeSegment.addSourceCode(digestValues);
            codeSegment.addSourceCode("|| '\"';");
            codeSegment.newLine();
            codeSegment.addSourceCode("etls_md5 = md5(etls_str);");
            codeSegment.newLine();
            codeSegment.addSourceCode("DIGEST_VALUE = put(etls_md5, hex32.);");
            codeSegment.newLine();
            if (genType1Digest) {
                codeSegment.addSourceCode("etls_str_type1 = '\"' ||");
                codeSegment.addSourceCode(digestValuesType1);
                codeSegment.addSourceCode("|| '\"';");
                codeSegment.newLine();
                codeSegment.addSourceCode("etls_md5 = md5(etls_str_type1);");
                codeSegment.newLine();
                codeSegment.addSourceCode("DIGEST_VALUE_TYPE1 = put(etls_md5, $hex32.);");
                codeSegment.newLine();
            }
        } else if (this.getChangeDigestVersion().equalsIgnoreCase("V2_1") || this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) {
            if (this.getChangeDigestVersion().equalsIgnoreCase("V2_1")) {
                codeSegment.addCommentLine("Generate change digest (v2.1) ");
            } else if (this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) {
                codeSegment.addCommentLine("Generate change digest (v2.2) ");
            }
            codeSegment.addSourceCode("data ");
            codeSegment.addSourceCode(outputTableDSName.trim());
            codeSegment.addSourceCode("(keep = ");
            codeSegment.addSourceCode(dataKeepColumns);
            codeSegment.addSourceCode(" DIGEST_VALUE");
            if (genType1Digest) {
                codeSegment.addSourceCode(" DIGEST_VALUE_TYPE1");
            }
            codeSegment.addSourceCode(");");
            codeSegment.newLine(2);
            codeSegment.indent();
            codeSegment.addSourceCode("length DIGEST_VALUE $32.");
            if (genType1Digest) {
                codeSegment.addSourceCode(" DIGEST_VALUE_TYPE1 $32.");
            }
            codeSegment.addSourceCode(";").newLine(2);
            codeSegment.addSourceCode("set ");
            if (!preSortTargetTable && type2Columns != null && type2Columns.size() > 0) {
                String targetTableName = this.getTargetTable().getFullNameQuotedAsNeeded(codeSegment);
                codeSegment.addSourceCode(targetTableName);
                codeSegment.addSourceCode("(keep = " + setKeepColumns);
                String targetTableReadOnlyOptions = this.getTargetTable().getReadTableOptions(false);
                if (targetTableReadOnlyOptions != null && targetTableReadOnlyOptions.trim().length() > 0) {
                    codeSegment.newLine();
                    codeSegment.addSourceCode(targetTableReadOnlyOptions);
                }
                codeSegment.addSourceCode(")");
            } else {
                codeSegment.addSourceCode(inputTableDSName.trim());
            }
            codeSegment.addSourceCode(";");
            if (useByStmtProcessing) {
                codeSegment.newLine(2);
                codeSegment.addSourceCode("by " + sByCols + ";");
                codeSegment.newLine();
            }
            if (currIndColumn != null && !this.isSortTempXref()) {
                codeSegment.newLine();
                codeSegment.addSourceCode("where " + currIndColumn.getColumnName(codeSegment));
                codeSegment.addSourceCode(" = " + currentIndicatorYesValue + ";");
                codeSegment.newLine();
            }
            if (useByStmtProcessing && currIndColumn == null) {
                codeSegment.newLine();
                if (codeSegment.isQuoting()) {
                    codeSegment.addSourceCode("if \"last.");
                    codeSegment.addSourceCode(lastBKColumn.getColumnName(false));
                    codeSegment.addSourceCode("\"n");
                } else {
                    codeSegment.addSourceCode("if last.");
                    codeSegment.addSourceCode(lastBKColumn.getColumnName(false));
                }
                codeSegment.addSourceCode(";");
                codeSegment.newLine();
            }
            codeSegment.newLine();
            codeSegment.addSourceCode("DIGEST_VALUE = ").addSourceCode(digestValues).newLine();
            if (genType1Digest) {
                codeSegment.addSourceCode("DIGEST_VALUE_TYPE1 = ").addSourceCode(digestValuesType1).newLine();
            }
        }
        codeSegment.unIndent();
        codeSegment.newLine();
        codeSegment.addSourceCode("run;");
        codeSegment.newLine(2);
        codeSegment.genRCSetCall("&syscc");
    }

    protected ICodeSegment cgUpdateDateNetezza(ICodeSegment codeSegment, boolean usePassThru, IColumn currentIndColumn, String currentIndicatorNoValue, String strWorkClose, String strWorkType1, String strWorkMatch, String strWorkNew, IColumn generatedKeyCol, boolean isRetainedKey, List keyColumns, List lType1Columns) throws CodegenException, MdException, RemoteException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException {
        boolean bUseConnectUsing;
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        String sTargetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment, usePassThru);
        IDBMSType targetDBMSType = targetTable.getDBMSType();
        ITransformTableOptions targetOptions = this.getTableOptionObject(targetTable, false);
        String sTargetOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
        String tgtTableAlias = targetTable.getTableName(codeSegment.isQuoting(), usePassThru);
        boolean needsQuotes = codeSegment.isQuoting();
        ILibrary visualUploadLibrary = this.getUploadLibrary();
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        ILibrary uploadLibrary = this.getRunTimeUploadLibrary(usePassThru, codeSegment, library);
        String uploadSchema = "";
        String sToDateColumnName = this.m_toDateColumn.getColumnName(codeSegment, usePassThru);
        String sFromDateColumnName = this.m_fromDateColumn.getColumnName(codeSegment, usePassThru);
        String srcTableAlias = strWorkClose;
        String tempCloseDate = "";
        String tempFromDate = "";
        String tempGenKey = "";
        String tempLoadTime = "";
        if (codeSegment.isQuoting()) {
            tempGenKey = DBMSNamesUtil.getQuotedString(TEMPGENKEY, usePassThru);
            tempCloseDate = DBMSNamesUtil.getQuotedString(TEMPCLOSEDATE, usePassThru);
            tempFromDate = DBMSNamesUtil.getQuotedString(TEMPFROMDATE, usePassThru);
            tempLoadTime = DBMSNamesUtil.getQuotedString(TEMPLOADTIME, usePassThru);
        } else {
            tempGenKey = TEMPGENKEY;
            tempCloseDate = TEMPCLOSEDATE;
            tempFromDate = TEMPFROMDATE;
            tempLoadTime = TEMPLOADTIME;
        }
        String sLoadTimeColumnName = "";
        if (this.getLoadTimeColumn() != null) {
            sLoadTimeColumnName = this.getLoadTimeColumn().getColumnName(codeSegment, usePassThru);
        }
        String sGeneratedKeyColumnName = "";
        boolean hasGeneratedKey = false;
        if (generatedKeyCol != null) {
            hasGeneratedKey = true;
            sGeneratedKeyColumnName = generatedKeyCol.getColumnName(codeSegment, usePassThru);
        }
        StringBuffer sbWhereClause = new StringBuffer();
        if (hasGeneratedKey) {
            sbWhereClause.append(srcTableAlias).append(".").append(tempGenKey).append(" = ");
            sbWhereClause.append(tgtTableAlias).append(".").append(sGeneratedKeyColumnName);
            if (isRetainedKey) {
                sbWhereClause.append("\nand ").append(srcTableAlias).append(".").append(tempFromDate).append(" = ");
                sbWhereClause.append(tgtTableAlias).append(".").append(sFromDateColumnName);
            }
        } else {
            sbWhereClause.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", tgtTableAlias, codeSegment, false));
            sbWhereClause.append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("and ").append(tempFromDate).append(" = ").append(tgtTableAlias).append(sFromDateColumnName);
        }
        codeSegment.addSourceCode("proc sql").space(1).addSourceCode(this.m_sSQLOptions).addSourceCode(";");
        codeSegment.newLine(1);
        codeSegment.indent(1).addCommentLine("Close out existing records");
        if (visualUploadLibrary != null) {
            uploadSchema = uploadLibrary.getDatabaseSchema().getSchemaName();
            uploadSchema = DBMSNamesUtil.getQuotedName(uploadSchema, needsQuotes, needsQuotes, usePassThru);
        }
        if (bUseConnectUsing = this.isUseConnectUsingEnabled()) {
            codeSegment.addSourceCode("connect using " + uploadLibrary.getLibref() + " as " + uploadLibrary.getEngine() + ";\n");
        } else {
            codeSegment.addSourceCode("connect to").space(1).addSourceCode(uploadLibrary.getEngine());
            codeSegment.newLine(1);
            codeSegment.addSourceCode("(");
            codeSegment.newLine(1).indent(1);
            codeSegment.addSourceCode(uploadLibrary.getConnectionOptions());
            codeSegment.newLine(1).unIndent(1).addSourceCode(");");
            codeSegment.newLine(1);
        }
        codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent(1);
        targetTable.getDBMSType().genExecuteBegin(codeSegment, targetTable, "");
        codeSegment.indent(1).addSourceCode("update").space(1).addSourceCode(sTargetDSName).space(1).addSourceCode(tgtTableAlias);
        codeSegment.newLine(1).indent(1);
        codeSegment.addSourceCode("set").space(1);
        if (currentIndColumn != null) {
            codeSegment.addSourceCode(currentIndColumn.getColumnName(needsQuotes, usePassThru)).addSourceCode(" = " + currentIndicatorNoValue + ",\n");
            codeSegment.space(4).addSourceCode(tgtTableAlias).addSourceCode(".").addSourceCode(sToDateColumnName);
        } else {
            codeSegment.addSourceCode(tgtTableAlias).addSourceCode(".").addSourceCode(sToDateColumnName);
        }
        codeSegment.space(1).addSourceCode("=").space(1);
        codeSegment.addSourceCode(srcTableAlias).addSourceCode(".").addSourceCode(tempCloseDate);
        codeSegment.newLine(1);
        codeSegment.addSourceCode("from").space(1);
        if (visualUploadLibrary != null && uploadSchema.length() > 0) {
            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
        }
        codeSegment.addSourceCode(strWorkClose).space(1).addSourceCode(srcTableAlias);
        codeSegment.newLine(1);
        codeSegment.addSourceCode("where").space(1).addSourceCode(sbWhereClause);
        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        if (sLoadTimeColumnName.length() > 0) {
            codeSegment.addCommentLine("Update the load time column");
            targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
            codeSegment.indent(1).addSourceCode("update").space(1).addSourceCode(sTargetDSName).space(1).addSourceCode(tgtTableAlias);
            codeSegment.newLine(1).indent(1);
            codeSegment.addSourceCode("set").space(1);
            codeSegment.addSourceCode(tgtTableAlias).addSourceCode(".").addSourceCode(sLoadTimeColumnName);
            codeSegment.space(1).addSourceCode("=").space(1);
            codeSegment.addSourceCode(srcTableAlias).addSourceCode(".").addSourceCode(tempLoadTime);
            codeSegment.newLine(1);
            codeSegment.addSourceCode("from").space(1);
            if (visualUploadLibrary != null && uploadSchema.length() > 0) {
                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
            }
            codeSegment.addSourceCode(strWorkClose).space(1).addSourceCode(srcTableAlias);
            codeSegment.newLine(1);
            codeSegment.addSourceCode("where").space(1).addSourceCode(sbWhereClause);
            targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        }
        codeSegment.unIndent(3).addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No records on target table were closed.").newLine(1).unIndent().addSourceCode("%end;\n");
        srcTableAlias = strWorkType1;
        StringBuffer whereClauseType1 = new StringBuffer();
        if (hasGeneratedKey) {
            whereClauseType1.append(srcTableAlias).append(".").append(tempGenKey).append(" = ");
            whereClauseType1.append(tgtTableAlias).append(".").append(sGeneratedKeyColumnName);
            if (isRetainedKey) {
                whereClauseType1.append("\nand ").append(srcTableAlias).append(".").append(tempFromDate).append(" = ");
                whereClauseType1.append(tgtTableAlias).append(".").append(sFromDateColumnName);
            }
        }
        if (lType1Columns != null && lType1Columns.size() > 0) {
            codeSegment.addCommentLine("Update type 1 columns");
            codeSegment.addSourceCode("%if &etls_type1cnt gt 0 %then");
            codeSegment.newLine(1);
            codeSegment.addSourceCode("%do;").newLine(2).indent();
            for (int index = 0; index < lType1Columns.size(); ++index) {
                IColumn column = (IColumn)lType1Columns.get(index);
                String sColumnName = "";
                targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                sColumnName = column.getColumnName(needsQuotes, true);
                codeSegment.indent(1).addSourceCode("update").space(1).addSourceCode(sTargetDSName).space(1).addSourceCode(tgtTableAlias);
                codeSegment.newLine(1).indent(1);
                codeSegment.addSourceCode("set").space(1);
                codeSegment.addSourceCode(tgtTableAlias).addSourceCode(".").addSourceCode(sColumnName);
                codeSegment.space(1).addSourceCode("=").space(1);
                codeSegment.addSourceCode(srcTableAlias).addSourceCode(".").addSourceCode(sColumnName);
                codeSegment.newLine(1);
                codeSegment.addSourceCode("from").space(1);
                if (visualUploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkType1).space(1).addSourceCode(srcTableAlias);
                codeSegment.newLine(1);
                codeSegment.addSourceCode("where").space(1).addSourceCode(whereClauseType1);
                targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
            }
            codeSegment.unIndent(3).addSourceCode("%end;");
            codeSegment.newLine(1).addSourceCode("%else %do;");
            codeSegment.newLine(2).indent();
            codeSegment.genPercentPutStatement("No type 1 updates were made to target table.");
            codeSegment.newLine(1).unIndent(1);
            codeSegment.addSourceCode("%end;");
            codeSegment.newLine(1);
        }
        String selectList = codeSegment.makeColumnList(targetTable, true, "      ", usePassThru, ",", "", needsQuotes, "");
        String colList = codeSegment.makeColumnList(targetTable, false, "      ", usePassThru, ",", "", needsQuotes, "");
        codeSegment.addCommentLine("Insert new matching records");
        codeSegment.addSourceCode("%if &etls_matchcnt gt 0 %then");
        codeSegment.newLine(1);
        codeSegment.addSourceCode("%do;");
        codeSegment.newLine(2).indent();
        targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
        codeSegment.addSourceCode("insert into").space(1).addSourceCode(sTargetDSName);
        codeSegment.newLine(1).indent();
        codeSegment.addSourceCode("( ");
        codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("select ").addSourceCode(selectList).addSourceCode("\n").addSourceCode("from ");
        if (visualUploadLibrary != null && uploadSchema.length() > 0) {
            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
        }
        codeSegment.addSourceCode(strWorkMatch).unIndent();
        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        codeSegment.unIndent().addSourceCode("%end;");
        codeSegment.newLine(2);
        codeSegment.addCommentLine("Insert new dimension records");
        codeSegment.addSourceCode("%if &etls_newcnt gt 0 %then");
        codeSegment.newLine(1);
        codeSegment.addSourceCode("%do;");
        codeSegment.newLine(2).indent();
        targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
        codeSegment.addSourceCode("insert into").space(1).addSourceCode(sTargetDSName);
        codeSegment.newLine(1).indent();
        codeSegment.addSourceCode("( ");
        codeSegment.addSourceCode(colList).space(1).addSourceCode(")");
        codeSegment.newLine(2);
        codeSegment.addSourceCode("select").space(1).addSourceCode(selectList);
        codeSegment.newLine(1);
        codeSegment.addSourceCode("from").space(1);
        if (visualUploadLibrary != null && uploadSchema.length() > 0) {
            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
        }
        codeSegment.addSourceCode(strWorkNew).unIndent();
        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        codeSegment.unIndent().addSourceCode("%end;");
        codeSegment.newLine(1);
        codeSegment.addSourceCode("%else %do;");
        codeSegment.newLine(2).indent();
        codeSegment.genPercentPutStatement("No new dimension records were added to target table.");
        codeSegment.newLine(1).unIndent();
        codeSegment.addSourceCode("%end;");
        codeSegment.newLine(2);
        targetDBMSType.genExecuteCommit(codeSegment, targetTable, "");
        codeSegment.newLine(1);
        targetDBMSType.genDisconnect(codeSegment, targetTable);
        codeSegment.unIndent(1).addSourceCode("quit;");
        codeSegment.newLine(2);
        return codeSegment;
    }

    protected class cSCDOptionModel
    extends BaseLoaderPromptModel
    implements IPromptModel {
        public cSCDOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(AbstractSCDTransformModel.this.getModel(), AbstractSCDTransformModel.this);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cSCDOptionModel.class.getResource("res/Options_SCD2Loader_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            AbstractSCDTransformModel transform = (AbstractSCDTransformModel)this.getOwner();
            this.setPromptDefinitionHidden(this.getPromptDefinitionValue(AbstractSCDTransformModel.OPTION_NAME_SPDS_UPDATE_TECHNIQUE), !AbstractSCDTransformModel.this.isSPDS());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_XREF_TABLE_NAME, (Object)transform.getXrefTableName());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_DATE_FORMAT_TYPE, (Object)transform.getDateFormatType());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_TEMP_TABLE_LIBREF, (Object)transform.getTempTableLibref());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_CLOSE_RECS_NOT_IN_SOURCE, (Object)(transform.isCloseRecsNotInSource() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_SQL_OPTIONS, (Object)transform.getSQLOptions());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_USE_SQL_PASSTHRU, (Object)(transform.isSQLPassthru() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_UPLOAD_LIBRARY, (Object)transform.getUploadLibrary());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_ALLOW_MULTI_UPDATES_PER_DAY, (Object)(transform.isMultiUpdatesPerDayAllowed() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_TEMP_TABLE_INDEX_ADD, (Object)(transform.isIndexAddedToUpdateTempTable() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_USE_PERM_XREF_INDEX_IF_SASDS, (Object)(transform.isUseIndexIfReadingSasds() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_USE_BULKLOAD, (Object)(transform.isUseBulkload() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_SORT_TEMP_XREF, (Object)(transform.isSortTempXref() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_TARGET_TABLE_INDEX_ADD, (Object)(transform.isTargetTblIndexAdd() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_XREF_TABLE_INDEX_ADD, (Object)(transform.isXrefTblIndexAdd() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_SPDS_UPDATE_TECHNIQUE, (Object)transform.getSPDSUpdateTechnique());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_CHANGE_DIGEST_VERSION, (Object)transform.getChangeDigestVersion());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_CLOSE_RECORDS_WORK_TABLE_OPTIONS, (Object)transform.getCloseRecordsWorkTableOptions());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_MATCH_RECORDS_WORK_TABLE_OPTIONS, (Object)transform.getMatchRecordsWorkTableOptions());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_NEW_RECORDS_WORK_TABLE_OPTIONS, (Object)transform.getNewRecordsWorkTableOptions());
            this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_TYPE1_RECORDS_WORK_TABLE_OPTIONS, (Object)transform.getType1RecordsWorkTableOptions());
            if (AbstractSCDTransformModel.this.isNew() && AbstractSCDTransformModel.this.isSASTable()) {
                AbstractSCDTransformModel.this.m_bSortTempXref = true;
            }
        }

        @Override
        protected IModelListener createModelListener() {
            return new cSCDModelChangeListener();
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new SCDTransformValueChangedListener((AbstractSCDTransformModel)this.getOwner(), this);
        }

        private class cSCDModelChangeListener
        extends BaseLoaderModelListener {
            public cSCDModelChangeListener() {
                super((ILoaderTransform)cSCDOptionModel.this.getOwner(), (IPromptModel)cSCDOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals("SCDTransform:XrefTableChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_XREF_TABLE_NAME, (Object)AbstractSCDTransformModel.this.getXrefTableName());
                    } else if (type.equals("SCDTransform:DateFormatTypeChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_DATE_FORMAT_TYPE, (Object)AbstractSCDTransformModel.this.getDateFormatType());
                    } else if (type.equals("SCDTransform:SQLOptionsChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_SQL_OPTIONS, (Object)AbstractSCDTransformModel.this.getSQLOptions());
                    } else if (type.equals("SCDTransform:UseSQLPassthruChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_USE_SQL_PASSTHRU, (Object)(AbstractSCDTransformModel.this.isSQLPassthru() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
                    } else if (type.equals("SCDTransform:TempTableLibrefChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_TEMP_TABLE_LIBREF, (Object)AbstractSCDTransformModel.this.getTempTableLibref());
                    } else if (type.equals("SCDTransform:CloseRecsNotInSourceChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_CLOSE_RECS_NOT_IN_SOURCE, (Object)(AbstractSCDTransformModel.this.isCloseRecsNotInSource() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
                    } else if (type.equals("SCDTransformModel.UploadLibraryChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_UPLOAD_LIBRARY, (Object)AbstractSCDTransformModel.this.getUploadLibrary());
                    } else if (type.equals("SCDTransform:TempUpdateTableIndexChnaged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_TEMP_TABLE_INDEX_ADD, (Object)(AbstractSCDTransformModel.this.isIndexAddedToUpdateTempTable() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
                    } else if (type.equals("SCDTransform:MultiUpdatesPerDayAllowedChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_ALLOW_MULTI_UPDATES_PER_DAY, (Object)(AbstractSCDTransformModel.this.isMultiUpdatesPerDayAllowed() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
                    } else if (type.equals("SCDTransformModel.UsePermXrefIndexIfSasdsChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_USE_PERM_XREF_INDEX_IF_SASDS, (Object)(AbstractSCDTransformModel.this.isUseIndexIfReadingSasds() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
                    } else if (type.equals("SCDTransformModel.UsePermXrefIndexIfSasdsChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_USE_BULKLOAD, (Object)(AbstractSCDTransformModel.this.isUseBulkload() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
                    } else if (type.equals("SCDTransform:SortTempXrefChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_SORT_TEMP_XREF, (Object)(AbstractSCDTransformModel.this.isSortTempXref() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
                    } else if (type.equals("SCDTransform:TargetTblIndexAddChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_TARGET_TABLE_INDEX_ADD, (Object)(AbstractSCDTransformModel.this.isTargetTblIndexAdd() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
                    } else if (type.equals("SCDTransform:XrefTblIndexAddChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_XREF_TABLE_INDEX_ADD, (Object)(AbstractSCDTransformModel.this.isXrefTblIndexAdd() ? AbstractSCDTransformModel.SCD_OPTION_TRUE : AbstractSCDTransformModel.SCD_OPTION_FALSE));
                    } else if (type.equals("SCDTransform:SPDSUpdateTechniqueChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_SPDS_UPDATE_TECHNIQUE, (Object)AbstractSCDTransformModel.this.getSPDSUpdateTechnique());
                    } else if (type.equals("SCDTransform:ChangeDigestVersionChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_CHANGE_DIGEST_VERSION, (Object)AbstractSCDTransformModel.this.getChangeDigestVersion());
                    } else if (type.equals("SCDTransform:CloseRecordsWorkTableOptionsChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_CLOSE_RECORDS_WORK_TABLE_OPTIONS, (Object)AbstractSCDTransformModel.this.getCloseRecordsWorkTableOptions());
                    } else if (type.equals("SCDTransform:MatchRecordsWorkTableOptionsChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_MATCH_RECORDS_WORK_TABLE_OPTIONS, (Object)AbstractSCDTransformModel.this.getMatchRecordsWorkTableOptions());
                    } else if (type.equals("SCDTransform:NewRecordsWorkTableOptionsChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_NEW_RECORDS_WORK_TABLE_OPTIONS, (Object)AbstractSCDTransformModel.this.getNewRecordsWorkTableOptions());
                    } else if (type.equals("SCDTransform:Type1RecordsWorkTableOptionsChanged")) {
                        cSCDOptionModel.this.setOptionValue(AbstractSCDTransformModel.OPTION_NAME_TYPE1_RECORDS_WORK_TABLE_OPTIONS, (Object)AbstractSCDTransformModel.this.getType1RecordsWorkTableOptions());
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class SCDTransformValueChangedListener
        extends BaseLoaderTransformValueChangedListener {
            public SCDTransformValueChangedListener(ILoaderTransform transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_XREF_TABLE_NAME)) {
                        AbstractSCDTransformModel.this.setXrefTableName(value.toString());
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_DATE_FORMAT_TYPE)) {
                        AbstractSCDTransformModel.this.setDateFormatType(value.toString());
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_SQL_OPTIONS)) {
                        AbstractSCDTransformModel.this.setSQLOptions(value.toString());
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_CLOSE_RECORDS_WORK_TABLE_OPTIONS)) {
                        AbstractSCDTransformModel.this.setCloseRecordsWorkTableOptions(value.toString());
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_MATCH_RECORDS_WORK_TABLE_OPTIONS)) {
                        AbstractSCDTransformModel.this.setMatchRecordsWorkTableOptions(value.toString());
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_NEW_RECORDS_WORK_TABLE_OPTIONS)) {
                        AbstractSCDTransformModel.this.setNewRecordsWorkTableOptions(value.toString());
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_TYPE1_RECORDS_WORK_TABLE_OPTIONS)) {
                        AbstractSCDTransformModel.this.setType1RecordsWorkTableOptions(value.toString());
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_USE_SQL_PASSTHRU)) {
                        AbstractSCDTransformModel.this.setUseSQLPassthru(value.equals(AbstractSCDTransformModel.SCD_OPTION_TRUE));
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_TEMP_TABLE_LIBREF)) {
                        AbstractSCDTransformModel.this.setTempTableLibref(value.toString());
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_CLOSE_RECS_NOT_IN_SOURCE)) {
                        AbstractSCDTransformModel.this.setCloseRecsNotInSource(value.equals(AbstractSCDTransformModel.SCD_OPTION_TRUE));
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_UPLOAD_LIBRARY)) {
                        if (value instanceof ILibrary) {
                            AbstractSCDTransformModel.this.setUploadLibrary((ILibrary)value);
                        } else {
                            AbstractSCDTransformModel.this.setUploadLibrary(null);
                        }
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_ALLOW_MULTI_UPDATES_PER_DAY)) {
                        AbstractSCDTransformModel.this.setMultiUpdatesPerDayAllowed(value.equals(AbstractSCDTransformModel.SCD_OPTION_TRUE));
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_TEMP_TABLE_INDEX_ADD)) {
                        AbstractSCDTransformModel.this.setIndexAddedToUpdateTempTable(value.equals(AbstractSCDTransformModel.SCD_OPTION_TRUE));
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_USE_PERM_XREF_INDEX_IF_SASDS)) {
                        AbstractSCDTransformModel.this.setUseIndexIfReadingSasds(value.equals(AbstractSCDTransformModel.SCD_OPTION_TRUE));
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_USE_BULKLOAD)) {
                        AbstractSCDTransformModel.this.setUseBulkload(value.equals(AbstractSCDTransformModel.SCD_OPTION_TRUE));
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_SORT_TEMP_XREF)) {
                        AbstractSCDTransformModel.this.setSortTempXref(value.equals(AbstractSCDTransformModel.SCD_OPTION_TRUE));
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_TARGET_TABLE_INDEX_ADD)) {
                        AbstractSCDTransformModel.this.setTargetTblIndexAdd(value.equals(AbstractSCDTransformModel.SCD_OPTION_TRUE));
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_XREF_TABLE_INDEX_ADD)) {
                        AbstractSCDTransformModel.this.setXrefTblIndexAdd(value.equals(AbstractSCDTransformModel.SCD_OPTION_TRUE));
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_SPDS_UPDATE_TECHNIQUE)) {
                        AbstractSCDTransformModel.this.setSPDSUpdateTechnique(value.toString());
                    } else if (optionName.equals(AbstractSCDTransformModel.OPTION_NAME_CHANGE_DIGEST_VERSION)) {
                        AbstractSCDTransformModel.this.setChangeDigestVersion(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class SetXrefTableNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldXrefTableName;
        private String m_newXrefTableName;

        public SetXrefTableNameUndoable(String oldXrefTableName, String newXrefTableName) {
            this.m_oldXrefTableName = oldXrefTableName;
            this.m_newXrefTableName = newXrefTableName;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setXrefTableName(this.m_oldXrefTableName);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setXrefTableName(this.m_newXrefTableName);
        }
    }

    private class SetDateFormatTypeUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetDateFormatTypeUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setDateFormatType(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setDateFormatType(this.m_sNewOption);
        }
    }

    private class SetSQLOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetSQLOptionsUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setSQLOptions(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setSQLOptions(this.m_sNewOption);
        }
    }

    private class SetCloseRecordsWorkTableOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetCloseRecordsWorkTableOptionsUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setCloseRecordsWorkTableOptions(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setCloseRecordsWorkTableOptions(this.m_sNewOption);
        }
    }

    private class SetMatchRecordsWorkTableOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetMatchRecordsWorkTableOptionsUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setMatchRecordsWorkTableOptions(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setMatchRecordsWorkTableOptions(this.m_sNewOption);
        }
    }

    private class SetNewRecordsWorkTableOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetNewRecordsWorkTableOptionsUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setNewRecordsWorkTableOptions(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setNewRecordsWorkTableOptions(this.m_sNewOption);
        }
    }

    private class SetType1RecordsWorkTableOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetType1RecordsWorkTableOptionsUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setType1RecordsWorkTableOptions(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setType1RecordsWorkTableOptions(this.m_sNewOption);
        }
    }

    private class SetUseSQLPassthruUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetUseSQLPassthruUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setUseSQLPassthru(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setUseSQLPassthru(this.m_bNewOption);
        }
    }

    private class SetUseBulkloadUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetUseBulkloadUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setUseBulkload(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setUseBulkload(this.m_bNewOption);
        }
    }

    private class SetSortTempXrefUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetSortTempXrefUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setSortTempXref(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setSortTempXref(this.m_bNewOption);
        }
    }

    private class SetTargetTblIndexAddUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetTargetTblIndexAddUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setTargetTblIndexAdd(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setTargetTblIndexAdd(this.m_bNewOption);
        }
    }

    private class SetXrefTblIndexAddUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetXrefTblIndexAddUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setXrefTblIndexAdd(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setXrefTblIndexAdd(this.m_bNewOption);
        }
    }

    private class SetSPDSUpdateTechniqueUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetSPDSUpdateTechniqueUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setSPDSUpdateTechnique(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setSPDSUpdateTechnique(this.m_sNewOption);
        }
    }

    private class SetChangeDigestVersionUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetChangeDigestVersionUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setChangeDigestVersion(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setChangeDigestVersion(this.m_sNewOption);
        }
    }

    private class SetTempTableLibrefUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetTempTableLibrefUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setTempTableLibref(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setTempTableLibref(this.m_sNewOption);
        }
    }

    private class SetCloseRecsNotInSourceUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetCloseRecsNotInSourceUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setCloseRecsNotInSource(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setCloseRecsNotInSource(this.m_bNewOption);
        }
    }

    private class SetUploadLibraryUndoable
    extends AbstractUndoableEdit {
        private ILibrary m_oldUploadLibrary;
        private ILibrary m_newUploadLibrary;

        public SetUploadLibraryUndoable(ILibrary oldUploadLibrary, ILibrary newUploadLibrary) {
            this.m_oldUploadLibrary = oldUploadLibrary;
            this.m_newUploadLibrary = newUploadLibrary;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setUploadLibrary(this.m_oldUploadLibrary);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setUploadLibrary(this.m_newUploadLibrary);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldUploadLibrary = null;
            this.m_newUploadLibrary = null;
        }
    }

    private class SetMultiUpdatesPerDayAllowedUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetMultiUpdatesPerDayAllowedUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setMultiUpdatesPerDayAllowed(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setMultiUpdatesPerDayAllowed(this.m_bNewOption);
        }
    }

    private class SetIndexAddedToUpdateTempTableUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetIndexAddedToUpdateTempTableUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setIndexAddedToUpdateTempTable(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setIndexAddedToUpdateTempTable(this.m_bNewOption);
        }
    }

    private class SetUseIndexIfReadingSasdsUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetUseIndexIfReadingSasdsUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setUseIndexIfReadingSasds(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setUseIndexIfReadingSasds(this.m_bNewOption);
        }
    }

    private class SetTrackChangesByDatesUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOption;
        private boolean m_bNewOption;

        public SetTrackChangesByDatesUndoable(boolean oldOption, boolean newOption) {
            this.m_bOldOption = oldOption;
            this.m_bNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setTrackChangesByDates(this.m_bOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setTrackChangesByDates(this.m_bNewOption);
        }
    }

    private class SetFromDateColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldValue;
        private IColumn m_newValue;

        public SetFromDateColumnUndoable(IColumn oldValue, IColumn newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setFromDateColumn(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setFromDateColumn(this.m_newValue);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldValue = null;
            this.m_newValue = null;
        }
    }

    private class SetToDateColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldValue;
        private IColumn m_newValue;

        public SetToDateColumnUndoable(IColumn oldValue, IColumn newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setToDateColumn(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setToDateColumn(this.m_newValue);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldValue = null;
            this.m_newValue = null;
        }
    }

    private class SetFromDateExpressionUndoable
    extends AbstractUndoableEdit {
        private ITextExpression m_oldValue;
        private ITextExpression m_newValue;

        public SetFromDateExpressionUndoable(ITextExpression oldValue, ITextExpression newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setFromDateExpression(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setFromDateExpression(this.m_newValue);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldValue = null;
            this.m_newValue = null;
        }
    }

    private class SetToDateExpressionUndoable
    extends AbstractUndoableEdit {
        private ITextExpression m_oldValue;
        private ITextExpression m_newValue;

        public SetToDateExpressionUndoable(ITextExpression oldValue, ITextExpression newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSCDTransformModel.this.setToDateExpression(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSCDTransformModel.this.setToDateExpression(this.m_newValue);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldValue = null;
            this.m_newValue = null;
        }
    }

    private class cTempLibrary
    extends BaseLibrary {
        public cTempLibrary(ICodeSegment codeSegment, ILibrary original) {
            super(original.getID(), original.getModel());
            this.getModel().putObject(original);
            IDatabaseSchema originalSchema = original.getDatabaseSchema();
            BaseDatabaseSchema schema = null;
            if (originalSchema != null) {
                schema = new BaseDatabaseSchema(originalSchema.getID(), originalSchema.getModel());
                this.getModel().putObject(originalSchema);
                schema.setName(originalSchema.getName());
                IDBMSType dbmsType = original.getDBMSType();
                if (dbmsType instanceof DB2UNXPCType || dbmsType instanceof DB2OS390Type) {
                    String schemaName = "SESSION";
                    schema.setSchemaName(schemaName);
                } else {
                    String schemaName = "";
                    schema.setSchemaName(schemaName);
                }
                schema.setServer(originalSchema.getServer());
            }
            this.setEngine(original.getEngine());
            this.setLibref(AbstractSCDTransformModel.DBMSTEMPLIBREF);
            this.setDatabaseSchema(schema);
            this.setIsDBMSLibname(original.isDBMSLibname());
            this.setIsPreAssigned(original.isPreAssigned());
            this.setLibraryConnection(original.getLibraryConnection());
            this.setName(original.getName());
            this.setServerLibrary(original.getServerLibrary());
            codeSegment.getCodeGenerationEnvironment().addLibraryToContextList(this);
        }

        @Override
        public String getConnectionOptions() throws MdException, RemoteException {
            String opts = super.getConnectionOptions();
            if (opts == null) {
                opts = "";
            }
            List existingProps = this.getOptionsList();
            boolean hasConnection = false;
            boolean hasConnectionGroup = false;
            for (int i = 0; i < existingProps.size(); ++i) {
                IProperty prop = (IProperty)existingProps.get(i);
                if (AbstractSCDTransformModel.CONNECTION_PROPERTY_NAME.equalsIgnoreCase(prop.getPropertyName())) {
                    hasConnection = true;
                }
                if (!AbstractSCDTransformModel.CONNECTION_GROUP_PROPERTY_NAME.equalsIgnoreCase(prop.getPropertyName())) continue;
                hasConnectionGroup = true;
            }
            if (!hasConnection && !"SASSPDS".equalsIgnoreCase(this.getEngine())) {
                opts = opts + " CONNECTION = GLOBAL";
            }
            if ("INFORMIX".equalsIgnoreCase(this.getEngine()) && !hasConnectionGroup) {
                opts = opts + " CONNECTION_GROUP = ETLSGRP";
            }
            return opts;
        }
    }
}

