/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.queues.impl.MSMQQueueCodegen;
import com.sas.etl.models.job.transforms.queues.impl.MSMQReaderTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MSMQQueueReaderCodegen
extends MSMQQueueCodegen {
    public static final String MSMQQReaderCodegen_GlobalDefinitions_notrans = "Global definitions";
    public static final String MSMQQReaderCodegen_DataType_notrans = "Set up message queue data types";
    public static final String MSMQQReaderCodegen_ReceiveAttachment_notrans = "Receive the attachment";
    public static final String MSMQQReaderCodegen_ReceiveText_notrans = "Receive the text";
    public static final String MSMQQReaderCodegen_ReceiveTable_notrans = "Receive the table messages";
    public static final String MSMQQReaderCodegen_ReceiveFile_notrans = "Receive the file messages";
    public static final String MSMQQReaderCodegen_ReceiveFailed_notrans = "Receive failed";
    public static final String MSMQQReaderCodegen_BuildMap_notrans = "Build the map";
    public static final String MSMQQReaderCodegen_BuildMapFailed_notrans = "The map failed";
    public static final String MSMQQReaderCodegen_BuildTargetColumns_notrans = "Build definition for target table columns";
    public static final String MSMQQReaderCodegen_LetStatements_notrans = "initialize the queue option values";
    public static final String MSMQQReaderCodegen_DebugTurnedOn_notrans = "Debug mode turned on";
    public static final String MSMQQReaderCodegen_NoColumns_exception_txt = "The table has no columns defined";
    public static final String MSMQQReaderCodegen_EndLoop_notrans = "if number of rows equals message depth then set event to NO_MESSAGE and exit the do loop";
    public static final String MSMQQReaderCodegen_Attachment_notrans = "Attachment";
    public static final String MSMQQReaderCodegen_AttachmentFailed_notrans = "Get attachment failed";
    public static final String MSMQQReaderCodegen_AttachmentAccept_notrans = "Accept external attachment";
    public static final String MSMQQReaderCodegen_AttachmentAcceptFailed_notrans = "Accept external file failed";
    public static final String MSMQQReaderCodegen_AttachmentAcceptSuccess_notrans = "Accept external file succeeded";
    public static final String MSMQQReaderCodegen_AttachmentType_notrans = "type";
    public static final String MSMQQReaderCodegen_AttachmentLibFile_notrans = "library / file name";
    public static final String MSMQQReaderCodegen_AttachmentMember_notrans = "member name";
    public static final String MSMQQReaderCodegen_AttachmentSenderDesc_notrans = "sender description";
    public static final String MSMQQReaderCodegen_AttachmentLastFlag_notrans = "last flag";
    public static final String MSMQQReaderCodegen_LengthStatements_notrans = "Build length statements for queue api definitions";
    public static final String MSMQQReaderCodegen_Receive_notrans = "Receive attributes";
    public static final String MSMQQReaderCodegen_NoSourceQueue_msg_txt = "This transformation must have a Queue object as source.";
    private static SASCodeGeneration m_attrib;
    private static SASCodeGeneration m_attribVal;

    public MSMQQueueReaderCodegen() {
        Workspace.getDefaultLogger().debug((Object)"This is a Queue Reader..");
    }

    protected ICodeSegment getGeneratedCode(ICodeSegment oICodeSegment, MSMQReaderTransformModel oMSMQReaderTransformModel) throws CodegenException, RemoteException, MdException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException {
        if (oMSMQReaderTransformModel.isFileMessage()) {
            MSMQQueueReaderCodegen.buildFileReceive(oICodeSegment, oMSMQReaderTransformModel);
        } else if (oMSMQReaderTransformModel.isTableMessage()) {
            MSMQQueueReaderCodegen.buildTableReceive(oICodeSegment, oMSMQReaderTransformModel);
        } else {
            MSMQQueueReaderCodegen.buildTextMsgReceive(oICodeSegment, oMSMQReaderTransformModel);
        }
        oICodeSegment.genCodeConditionCheck(oICodeSegment, "DIS_CSUCCESSFUL", oMSMQReaderTransformModel, null);
        oICodeSegment.genCodeConditionCheck(oICodeSegment, "DIS_CWARNINGS", oMSMQReaderTransformModel, null);
        oICodeSegment.genCodeConditionCheck(oICodeSegment, "DIS_CERRORS", oMSMQReaderTransformModel, null);
        return oICodeSegment;
    }

    public static void buildTextMsgReceive(ICodeSegment cgReq, MSMQReaderTransformModel readerModel) throws MdException, RemoteException {
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        MSMQQueueReaderCodegen.buildDeclarations(cgReq, readerModel);
        MSMQQueueReaderCodegen.buildInit(cgReq);
        MSMQQueueReaderCodegen.buildOpen(cgReq, "FETCH", "poll(timeout=2)", readerModel);
        if (readerModel.isQueuePropertiesTurnedOn()) {
            MSMQQueueReaderCodegen.buildVerifyQueueProperties(cgReq, readerModel);
        }
        cgReq.addSectionComment(MSMQQReaderCodegen_LetStatements_notrans);
        ArrayList parameterList = new ArrayList();
        MSMQQueueReaderCodegen.buildMacroValues(readerModel, parameterList, cgReq);
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        if (readerModel.isTransaction()) {
            MSMQQueueReaderCodegen.buildBeginTransaction(cgReq);
            m_attrib.addSourceCode("TRANSACTION").addSourceCode(",").addSourceCode(" ");
            m_attribVal.addSourceCode("etls_transid").addSourceCode(",").addSourceCode(" ");
        }
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueReaderCodegen.buildTextMap(cgReq, readerModel, mapName);
        MSMQQueueReaderCodegen.buildAttributeList(parameterList, true, m_attrib, m_attribVal);
        cgReq.addSectionComment(MSMQQReaderCodegen_ReceiveText_notrans);
        cgReq.addSourceCode("length etls $ ").addSourceCode(String.valueOf(readerModel.getMessageLength())).addSourceCode(";\n");
        cgReq.addSourceCode("call receivemessage( etls_qid, etls_rc,\n");
        cgReq.indent().addSourceCode("etls_event, etls_attachflg,\n");
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource()).addSourceCode(", etls );\n");
        cgReq.addSourceCode("call symput( \"");
        cgReq.addSourceCode(readerModel.getMacroVariable());
        cgReq.addSourceCode("\", etls );\n");
        cgReq.unIndent();
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, MSMQQReaderCodegen_ReceiveFailed_notrans, true, "receive message");
        cgReq.addSourceCode("\n");
        if (readerModel.isTransaction()) {
            MSMQQueueReaderCodegen.buildCommitTransaction(cgReq);
        }
        MSMQQueueReaderCodegen.buildTerm(cgReq, readerModel.isDebug());
        cgReq.unIndent().addSourceCode("run;\n");
    }

    public static void buildFileMap(ICodeSegment cgReq, MSMQReaderTransformModel readerModel, String mapName) throws MdException, RemoteException {
        cgReq.addSectionComment(MSMQQReaderCodegen_BuildMap_notrans);
        String storage = "REGISTRY";
        if (readerModel.isMapStoreDefined()) {
            storage = readerModel.getMapStore();
        }
        cgReq.addSourceCode("call setmap( '");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("', '");
        cgReq.addSourceCode(storage);
        cgReq.addSourceCode("', etls_rc, ");
        cgReq.addSourceCode("'CHAR'");
        cgReq.addSourceCode(" );\n");
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, MSMQQReaderCodegen_BuildMapFailed_notrans, "map ");
        cgReq.addSourceCode("\n");
    }

    public static void buildTextMap(ICodeSegment cgReq, MSMQReaderTransformModel readerModel, String mapName) throws MdException, RemoteException {
        cgReq.addSectionComment(MSMQQReaderCodegen_BuildMap_notrans);
        String storage = "REGISTRY";
        if (readerModel.isMapStoreDefined()) {
            storage = readerModel.getMapStore();
        }
        cgReq.addSourceCode("call setmap( '");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("', '");
        cgReq.addSourceCode(storage);
        cgReq.addSourceCode("', etls_rc, ");
        cgReq.addSourceCode("'CHAR,,");
        cgReq.addSourceCode(String.valueOf(readerModel.getMessageLength()));
        cgReq.addSourceCode("'");
        cgReq.addSourceCode(" );\n");
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, MSMQQReaderCodegen_BuildMapFailed_notrans, "map ");
        cgReq.addSourceCode("\n");
    }

    public static void buildTableMap(ICodeSegment cgReq, MSMQReaderTransformModel readerModel, List cList, String mapName) throws MdException, RemoteException {
        cgReq.addSectionComment(MSMQQReaderCodegen_BuildMap_notrans);
        String storage = "REGISTRY";
        if (readerModel.isMapStoreDefined()) {
            storage = readerModel.getMapStore();
        }
        cgReq.addSourceCode("call setmap( '");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("', '");
        cgReq.addSourceCode(storage);
        cgReq.addSourceCode("', etls_rc, ");
        cgReq.addSourceCode("\n");
        cgReq.indent();
        MSMQQueueReaderCodegen.buildColumnFormats(cgReq, cList);
        cgReq.addSourceCode(" );\n");
        cgReq.unIndent();
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, MSMQQReaderCodegen_BuildMapFailed_notrans, "map ");
        cgReq.addSourceCode("\n");
    }

    public static void buildTableReceive(ICodeSegment cgReq, MSMQReaderTransformModel readerModel) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        boolean bNeedQuotes = cgReq.isQuoting();
        IPhysicalTable targetTable = readerModel.getTargetTable();
        String targetTableName = targetTable.getFullNameQuotedAsNeeded(cgReq);
        IColumn[] targetColumnList = readerModel.getTargetTable().getColumns();
        cgReq.genTableDelete(targetTable);
        cgReq.addSourceCode("data ");
        cgReq.addSourceCode(targetTableName);
        cgReq.addSourceCode("(");
        cgReq.addSourceCode(readerModel.getTableOptionObject(targetTable, false).getTableOptions(cgReq.getCurrentServer()));
        cgReq.addSourceCode(" keep =\n ");
        cgReq.indent();
        cgReq.addSourceCode(cgReq.makeColumnList(readerModel.getTargetTable().getColumns(), "", bNeedQuotes, ""));
        cgReq.addSourceCode(");\n");
        cgReq.addCommentLine(MSMQQReaderCodegen_BuildTargetColumns_notrans);
        for (int i = 0; i < targetColumnList.length; ++i) {
            cgReq.addSourceCode(targetColumnList[i].getAttribStatement(bNeedQuotes, true, true, false));
        }
        MSMQQueueReaderCodegen.buildDeclarations(cgReq, readerModel);
        MSMQQueueReaderCodegen.buildInit(cgReq);
        MSMQQueueReaderCodegen.buildOpen(cgReq, "FETCH", "poll(timeout=2)", readerModel);
        if (readerModel.isQueuePropertiesTurnedOn()) {
            MSMQQueueReaderCodegen.buildVerifyQueueProperties(cgReq, readerModel);
        }
        ArrayList parameterList = new ArrayList();
        cgReq.addCommentLine(MSMQQReaderCodegen_LetStatements_notrans);
        MSMQQueueReaderCodegen.buildMacroValues(readerModel, parameterList, cgReq);
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        if (readerModel.isTransaction()) {
            MSMQQueueReaderCodegen.buildBeginTransaction(cgReq);
            m_attrib.addSourceCode("TRANSACTION").addSourceCode(",").addSourceCode(" ");
            m_attribVal.addSourceCode("etls_transid").addSourceCode(",").addSourceCode(" ");
        }
        List columnList = readerModel.buildMessageColumnsList(readerModel.getTargetTable().getColumns());
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueReaderCodegen.buildTableMap(cgReq, readerModel, columnList, mapName);
        MSMQQueueReaderCodegen.buildAttributeList(parameterList, true, m_attrib, m_attribVal);
        cgReq.addSourceCode("\n");
        cgReq.addCommentLine(MSMQQReaderCodegen_Receive_notrans);
        cgReq.addSourceCode("length etls_reccount 8;\n");
        cgReq.addSourceCode("etls_reccount = 0;\n");
        cgReq.addSourceCode("length etls_limit_read 8;\n");
        if (readerModel.isDepth()) {
            cgReq.addSourceCode("etls_limit_read = ").addSourceCode(readerModel.getDepth()).addSourceCode(";\n");
        } else {
            cgReq.addSourceCode("etls_limit_read = 999999").addSourceCode(";\n");
        }
        cgReq.addSourceCode("length etls_attachflag 8;\n");
        cgReq.addSourceCode("do until (etls_event = 'NO_MESSAGE');\n");
        cgReq.indent();
        cgReq.addSectionComment(MSMQQReaderCodegen_ReceiveTable_notrans);
        cgReq.addSourceCode("call receivemessage( etls_qid, etls_rc,\n");
        cgReq.indent().addSourceCode("etls_event, etls_attachflg,\n");
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource());
        cgReq.addSourceCode(", \n");
        int sz = columnList.size();
        int j = 0;
        for (int i = 0; i < sz; ++i) {
            String[] sArrayQueueFormat = (String[])columnList.get(i);
            String sName = sArrayQueueFormat[0];
            if (bNeedQuotes) {
                cgReq.addSourceCode(DBMSNamesUtil.getQuotedString((String)sName, (boolean)false));
            } else {
                cgReq.addSourceCode(sName);
            }
            if (i < sz - 1) {
                cgReq.addSourceCode(", ");
            }
            if (++j != 2) continue;
            cgReq.addSourceCode("\n");
            j = 0;
        }
        cgReq.addSourceCode(" );\n");
        cgReq.unIndent();
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, MSMQQReaderCodegen_ReceiveFailed_notrans, true, "receive message");
        cgReq.addSourceCode("if (etls_event ^= 'NO_MESSAGE') then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_current_reccount + 1;\n");
        cgReq.addCommentLine(MSMQQReaderCodegen_EndLoop_notrans);
        cgReq.addSourceCode("if etls_limit_read = etls_current_reccount then\n");
        cgReq.indent().addSourceCode("etls_event = 'NO_MESSAGE';\n");
        cgReq.unIndent();
        cgReq.addSourceCode("output;\n");
        cgReq.unIndent().addSourceCode("end; /* if etls_event ^= 'NO_MESSAGE' */ \n");
        cgReq.unIndent();
        cgReq.addSourceCode("end; /* do until (etls_event = 'NO_MESSAGE') */\n");
        cgReq.addSourceCode("\n");
        if (readerModel.isTransaction()) {
            MSMQQueueReaderCodegen.buildCommitTransaction(cgReq);
        }
        cgReq.unIndent();
        cgReq.addSourceCode("return;\n");
        cgReq.addSourceCode("term:\n");
        cgReq.indent();
        MSMQQueueReaderCodegen.buildTerm(cgReq, readerModel.isDebug());
        cgReq.unIndent();
        cgReq.addSourceCode("return;\n");
        cgReq.addSourceCode("run;\n");
    }

    public static void buildFileReceive(ICodeSegment cgReq, MSMQReaderTransformModel readerModel) throws MdException, RemoteException {
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        MSMQQueueReaderCodegen.buildDeclarations(cgReq, readerModel);
        MSMQQueueReaderCodegen.buildInit(cgReq);
        MSMQQueueReaderCodegen.buildOpen(cgReq, "FETCH", "poll(timeout=2)", readerModel);
        if (readerModel.isQueuePropertiesTurnedOn()) {
            MSMQQueueReaderCodegen.buildVerifyQueueProperties(cgReq, readerModel);
        }
        cgReq.addSectionComment(MSMQQReaderCodegen_LetStatements_notrans);
        ArrayList parameterList = new ArrayList();
        MSMQQueueReaderCodegen.buildMacroValues(readerModel, parameterList, cgReq);
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueReaderCodegen.buildFileMap(cgReq, readerModel, mapName);
        MSMQQueueReaderCodegen.buildAttributeList(parameterList, true, m_attrib, m_attribVal);
        cgReq.addCommentLine(MSMQQReaderCodegen_Receive_notrans);
        cgReq.addSourceCode("length etls_attachid 8;\n");
        cgReq.addSourceCode("length etls_lastflag 8;\n");
        cgReq.addSourceCode("length etls_type $ 20;\n");
        cgReq.addSourceCode("length etls_qual1 $ 80;\n");
        cgReq.addSourceCode("length etls_qual2 $ 80;\n");
        cgReq.addSourceCode("length etls_desc $ 80;\n");
        cgReq.addSourceCode("length etls_minor 8;\n");
        cgReq.addSourceCode("length etls_major 8;\n");
        cgReq.addSourceCode("length etls_attachflag 8;\n");
        cgReq.addSourceCode("do until (etls_event = 'NO_MESSAGE');\n");
        cgReq.indent();
        cgReq.addSectionComment(MSMQQReaderCodegen_ReceiveFile_notrans);
        cgReq.addSourceCode("call receivemessage( etls_qid, etls_rc,\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_event, etls_attachflg,\n");
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource());
        cgReq.addSourceCode(" );\n");
        cgReq.unIndent();
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, MSMQQReaderCodegen_ReceiveFailed_notrans, true, "receive message");
        MSMQQueueReaderCodegen.buildAttachmentReceive(cgReq, readerModel);
        cgReq.unIndent();
        cgReq.addSourceCode("end; /* do until (etls_event = 'NO_MESSAGE') */\n");
        cgReq.addSourceCode("\n");
        MSMQQueueReaderCodegen.buildTerm(cgReq, readerModel.isDebug());
        cgReq.unIndent().addSourceCode("run;\n");
    }

    public static void buildDeclarations(ICodeSegment cgReq, MSMQReaderTransformModel readerModel) throws MdException, RemoteException {
        cgReq.addCommentLine(MSMQQReaderCodegen_LengthStatements_notrans);
        cgReq.addSourceCode("length etls_queue  $ 200;\n");
        if (readerModel.isDebug()) {
            cgReq.addSourceCode("length etls_msg $ 200;\n");
        }
        cgReq.addSourceCode("length etls_qid 8;\n");
        cgReq.addSourceCode("length etls_rc 8;\n");
        cgReq.addSourceCode("length etls_tid 8;\n");
        if (readerModel.isTransaction()) {
            cgReq.addSourceCode("length etls_transid 8;\n");
        }
        cgReq.addSourceCode("length etls_map $ 80;\n");
        cgReq.addSourceCode("length etls_msgtype 8;\n");
        cgReq.addSourceCode("length etls_event $ 10;\n");
        cgReq.addSourceCode("length etls_msg $ 200;\n");
        cgReq.addSourceCode("length etls_mqdebug $ 10;\n");
        if (readerModel.isDebug()) {
            cgReq.addSourceCode("etls_mqdebug=\"YES\";\n");
        } else {
            cgReq.addSourceCode("etls_mqdebug=\"NO\";\n");
        }
        cgReq.addSourceCode("etls_queue = '").addSourceCode(readerModel.getMessageQueue().getMessageQueueName()).addSourceCode("';\n");
        cgReq.addSourceCode("\n");
    }

    public static void buildAttachmentReceive(ICodeSegment cgReq, MSMQReaderTransformModel readerModel) throws MdException, RemoteException {
        cgReq.addSourceCode("if (etls_event ^= 'NO_MESSAGE') then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_lastflag = 0;\n");
        cgReq.addSourceCode("etls_minor = 0;\n");
        cgReq.addSourceCode("etls_major = 0;\n");
        cgReq.addSourceCode("if (etls_attachflg eq 1) then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("do while (etls_lastflag eq 0);\n");
        cgReq.indent().genPutStatement(MSMQQReaderCodegen_Attachment_notrans);
        cgReq.addSourceCode("call GETATTACHMENT( etls_qid, etls_lastflag,\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_attachid, etls_type,\n");
        cgReq.addSourceCode("etls_qual1, etls_qual2,\n");
        cgReq.addSourceCode("etls_rc, etls_desc );\n");
        cgReq.unIndent();
        cgReq.addSourceCode("if (etls_rc ^= 0) then do;\n");
        cgReq.indent().addSourceCode("etls_msg = sysmsg();\n");
        cgReq.genPutStatement(MSMQQReaderCodegen_AttachmentFailed_notrans, "ERROR%QUOTE(:)", "msg", false);
        cgReq.addSourceCode("etls_lastflag = 1;\n");
        cgReq.unIndent().addSourceCode("end; /* if (etls_rc ^= 0) */\n");
        cgReq.addSourceCode("else do;\n");
        cgReq.indent().genPutStatement(MSMQQReaderCodegen_AttachmentAccept_notrans);
        cgReq.addSourceCode("FILENAME etlref ");
        cgReq.addSourceCode("\"");
        cgReq.addSourceCode(readerModel.getFileName());
        cgReq.addSourceCode("\"");
        cgReq.addSourceCode(";\n");
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("call acceptattachment(etls_qid, etls_attachid, 'fileref',\n");
        cgReq.indent();
        cgReq.addSourceCode("'etlref', etls_rc);\n");
        cgReq.unIndent();
        cgReq.addSourceCode("if etls_rc ^= 0 then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("etls_msg=sysmsg();\n");
        cgReq.genPutStatement(MSMQQReaderCodegen_AttachmentAcceptFailed_notrans, "ERROR%QUOTE(:)", "etls_msg", false);
        cgReq.unIndent().addSourceCode("end; /* else (etls_rc = 0) */\n");
        cgReq.addSourceCode("else ");
        cgReq.genPutStatement(MSMQQReaderCodegen_AttachmentAcceptSuccess_notrans);
        cgReq.genPutStatement(MSMQQReaderCodegen_AttachmentType_notrans, "NOTE:", "etls_type", false);
        cgReq.genPutStatement(MSMQQReaderCodegen_AttachmentLibFile_notrans, "NOTE:", "etls_qual1", false);
        cgReq.genPutStatement(MSMQQReaderCodegen_AttachmentMember_notrans, "NOTE:", "etls_qual2", false);
        cgReq.genPutStatement(MSMQQReaderCodegen_AttachmentSenderDesc_notrans, "NOTE:", "etls_desc", false);
        cgReq.genPutStatement(MSMQQReaderCodegen_AttachmentLastFlag_notrans, "NOTE:", "etls_lastflag", false);
        cgReq.unIndent().addSourceCode("end; /* if etls_attachflg eq 1 */\n");
        cgReq.unIndent().addSourceCode("end; /* do while (etls_lastflag eq 0) */\n");
        cgReq.unIndent().addSourceCode("end; /* if (etls_attachflg eq 1) */\n");
        cgReq.unIndent().addSourceCode("end; /* if (event ^= 'NO_MESSAGE') */\n");
    }
}

