/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.transforms.queues.impl.CommonQueueTransformModel;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.SASCodeGeneration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MSMQQueueCodegen {
    public static final String MSMQQueueCodegen_Initialize_notrans = "Initialize the common MSMQ interface";
    public static final String MSMQQueueCodegen_InitializeFailed_notrans = "Initialize failed";
    public static final String MSMQQueueCodegen_OpenSend_notrans = "Open the queue for sending";
    public static final String MSMQQueueCodegen_OpenFailed_notrans = "Open failed";
    public static final String MSMQQueueCodegen_CloseQueue_notrans = "Close the queue";
    public static final String MSMQQueueCodegen_CloseFailed_notrans = "Close failed";
    public static final String MSMQQueueCodegen_OpenReceive_notrans = "Open the queue for receiving";
    public static final String MSMQQueueCodegen_Term_notrans = "Terminate the interface";
    public static final String MSMQQueueCodegen_TermFailed_notrans = "Term failed";
    public static final String MSMQQueueCodegen_CommitTransFailed_notrans = "Commit transaction failed";
    public static final String MSMQQueueCodegen_BeginTransFailed_notrans = "Begin transaction failed";
    public static final String MSMQQueueCodegen_FreeTransFailed_notrans = "Free transaction failed";
    public static final String MSMQQueueCodegen_QueueProperties_notrans = "Queue Properties";
    public static final String MSMQQueueCodegen_QueuePropertiesFailed_notrans = "Queue properties failed";
    public static final String MSMQQueueCodegen_AuthMsg_notrans = "Authenticated messages are required";
    public static final String MSMQQueueCodegen_PrivMsg_notrans = "Private messages are required";
    public static final String MSMQQueueCodegen_PrivOptMsg_notrans = "Privacy is optional";
    public static final String MSMQQueueCodegen_PubMsg_notrans = "Public messages are required";
    public static final String MSMQQueueCodegen_TransMsgRequired_notrans = "Transactional messages are required to write to this queue";
    public static final String MSMQQueueCodegen_TransMsgNotPermitted_notrans = "Transactional messages are not permitted";
    public static final String MSMQQueueCodegen_QueuePropertiesDepth_notrans = "Depth =";
    public static final String MSMQQueueCodegen_QueuePropertiesMaxDepth_notrans = "Maximum depth =";
    public static final String MSMQQueueCodegen_QueuePropertiesMaxMsgL_notrans = "Maximum Message Length =";
    public static final String MSMQQueueCodegen_QueuePropertiesCreateTime_notrans = "Creation time =";
    public static final String MSMQQueueCodegen_QueuePropertiesDesc_notrans = "Description =";
    public static final String MSMQQueueCodegen_QueueTypeFailed_notrans = "Encountered queue type";
    public static final String MSMQQueueCodegen_QueueTypeRequired_notrans = "Microsoft Message Queue required";
    public static final String MSMQQueueCodegen_TransactionRequired_notrans = "This transformation requires a transactional queue to send messages properly.";
    public static final String MSMQQueueCodegen_BeginTransaction_notrans = "Begin transaction";
    public static final String MSMQQueueCodegen_CommitTransaction_notrans = "Commit transaction";
    public static final String MSMQQueueCodegen_FreeTransaction_notrans = "Free transaction";
    public static final String MSMQQueueCodegen_RCCheck_msg_notrans = "Return code check for Microsoft Message Queue";
    public static final String MSMQQueueCodegen_DebugTurnedOn_notrans = "Debug mode turned on";
    public static final String MSMQQueueCodegen_TermRoutine_notrans = "Terminate routine";
    public static final String MSMQQueueCodegen_TermRoutineEnd_notrans = "End of terminate routine";
    protected static final String DELIVERY = "DELIVERY";
    protected static final String PREFIX = "etls_";
    protected static final String SPACE = " ";
    protected static final String LENGTH = "length ";
    protected static final String DEF_CHAR = " $ 20;\n";
    protected static final String DEF_INT = " 8;\n";
    protected static final String DEF_ID = " $ 48;\n";
    protected static final String DEF_DESC = " $ 200;\n";
    protected static final String QUOTE = "\"";
    protected static final String SUCCESS = " successful";
    protected static final String OPENATTR = "OPENATTR";
    protected static final String DEBUG = "MQDEBUG";
    protected static final String ATTACHLIST = "ATTACHLIST";
    protected static final String ALLOWREADPROTECT = "ALLOWREADPROTECT";
    protected static final String HASHALG = "HASHALG";
    protected static final String SENDERCERT = "SENDERCERT";
    protected static final String ENCRYPT = "ENCRYPT";
    protected static final String ENCRYPTALG = "ENCRYPTALG";
    protected static final String DESCRIPTION = "DESCRIPTION";
    protected static final String AUTHENTICATE = "AUTHENTICATE";
    protected static final String PERSIST = "PERSIST";
    protected static final String TIMEOUT = "TIMEOUT";
    protected static final String MSGTYPE = "MSGTYPE";
    protected static final String ADMINQUEUE = "ADMINQUEUE";
    protected static final String RESPQUEUE = "RESPQUEUE";
    protected static final String TRANSACTION = "TRANSACTION";
    protected static final String ACKNOWLEDGE = "ACKNOWLEDGE";
    protected static final String CORRELATIONID = "CORRELATIONID";
    protected static final String JOURNAL = "JOURNAL";
    protected static final String PRIORITY = "PRIORITY";
    protected static final String MSGID = "MSGID";
    protected static final String OPTIONS = "OPTIONS";
    protected static final String OPENMODE = "OPENMODE";
    protected static final String DEPTH = "LIMIT_READ";
    protected static final String INIT = "initialize queue";
    protected static final String OPEN = "open queue";
    protected static final String SENDMESSAGE = "send message";
    protected static final String RECEIVEMESSAGE = "receive message";
    protected static final String CLOSE = "close queue";
    protected static final String TERM = "terminate queue";
    protected static final String BEGINTRANS = "begin transaction";
    protected static final String FREETRANS = "free transaction";
    protected static final String COMMITTRANS = "commit transaction";
    protected static final String QUEUEPROPS = "queue properties";
    protected static final String MAP = "map ";
    protected static final String QUEUEPROP = "QUEUEPROP";
    protected static final String MAPSTORE = "MAPSTORE";
    protected static final String USERMAP = "USERMAP";
    protected static final String[] ignoreString = new String[]{"USERMAP", "MAPSTORE", "TRANSACTION", "XFILE", "LIMIT_READ", "OPENMODE", "OPENATTR", "MQDEBUG", "QUEUEPROP"};

    protected static void BuildErrorHandling(ICodeSegment cgReq, String errorMessage, String mode) {
        MSMQQueueCodegen.BuildErrorHandling(cgReq, errorMessage, false, mode, false);
    }

    protected static void BuildErrorHandling(ICodeSegment cgReq, String errorMessage, String mode, boolean terminate) {
        MSMQQueueCodegen.BuildErrorHandling(cgReq, errorMessage, false, mode, terminate);
    }

    protected static void BuildErrorHandling(ICodeSegment cgReq, String errorMessage, boolean isEvent, String mode) {
        MSMQQueueCodegen.BuildErrorHandling(cgReq, errorMessage, isEvent, mode, false);
    }

    protected static void BuildErrorHandling(ICodeSegment cgReq, String errorMessage, boolean isEvent, String mode, boolean isTerminate) {
        cgReq.addSourceCode("if etls_rc ^= 0 then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("etls_msg = sysmsg();\n");
        cgReq.genPutStatement(errorMessage, "ERROR%QUOTE(:)", "etls_msg", false);
        cgReq.addSourceCode("%rcSetDS( 8000 );\n");
        if (isEvent) {
            cgReq.addSourceCode("etls_event = 'NO_MESSAGE';\n");
        }
        if (isTerminate) {
            cgReq.addSourceCode("link term;\n");
            cgReq.addSourceCode("stop;\n");
        }
        cgReq.unIndent().addSourceCode("end; /* if etls_rc ^= 0 */\n");
        cgReq.addSourceCode("else;\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("%rcSetDS( etls_rc );\n");
        cgReq.addSourceCode("if etls_mqdebug = \"YES\" then\n");
        StringBuffer succMsg = new StringBuffer(mode);
        succMsg.append(SUCCESS);
        cgReq.indent().genPutStatement(succMsg.toString());
        cgReq.unIndent();
        cgReq.unIndent();
        cgReq.addSourceCode("end;/* else do */\n");
    }

    protected static void buildInit(ICodeSegment cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(MSMQQueueCodegen_Initialize_notrans);
        cgReq.addSourceCode("call init( etls_tid, 'MSMQ', etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, MSMQQueueCodegen_InitializeFailed_notrans, INIT);
        cgReq.addSourceCode("\n");
    }

    protected static void buildOpen(ICodeSegment cgReq, String mode, CommonQueueTransformModel model) throws MdException, RemoteException {
        MSMQQueueCodegen.buildOpen(cgReq, mode, "", model);
    }

    protected static void buildOpen(ICodeSegment cgReq, String mode, String addOptions, CommonQueueTransformModel model) throws MdException, RemoteException {
        String modeActivity = model.getOpenMode();
        if (modeActivity == null) {
            modeActivity = mode;
        } else if (mode.length() == 0) {
            modeActivity = mode;
        }
        String addAttrs = model.getOpenAttr();
        if (addAttrs == null) {
            addAttrs = addOptions;
        } else if (addAttrs.length() == 0) {
            addAttrs = addOptions;
        }
        if (modeActivity.equalsIgnoreCase(DELIVERY)) {
            cgReq.addSectionComment(MSMQQueueCodegen_OpenSend_notrans);
        } else {
            cgReq.addSectionComment(MSMQQueueCodegen_OpenReceive_notrans);
        }
        cgReq.addSourceCode("call openqueue( etls_qid, etls_tid, etls_queue,\n");
        cgReq.indent();
        cgReq.addSourceCode(QUOTE);
        cgReq.addSourceCode(modeActivity);
        cgReq.addSourceCode(QUOTE);
        cgReq.addSourceCode(", etls_rc");
        if (addAttrs.length() > 0) {
            cgReq.addSourceCode(", ");
            cgReq.addSourceCode(QUOTE);
            cgReq.addSourceCode(addAttrs);
            cgReq.addSourceCode(QUOTE);
            cgReq.addSourceCode(" );\n");
        } else {
            cgReq.addSourceCode(");\n");
        }
        cgReq.unIndent();
        MSMQQueueCodegen.BuildErrorHandling(cgReq, MSMQQueueCodegen_OpenFailed_notrans, OPEN);
        cgReq.addSourceCode("\n");
    }

    protected static void buildTerm(ICodeSegment cgReq, boolean debug) throws MdException, RemoteException {
        cgReq.addSectionComment(MSMQQueueCodegen_CloseQueue_notrans);
        cgReq.addSourceCode("call closequeue( etls_qid, etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, MSMQQueueCodegen_CloseFailed_notrans, CLOSE);
        cgReq.addSourceCode("\n");
        cgReq.addSectionComment(MSMQQueueCodegen_Term_notrans);
        cgReq.addSourceCode("call term( etls_tid, etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, MSMQQueueCodegen_TermFailed_notrans, TERM);
        cgReq.addSourceCode("\n");
    }

    protected static void buildColumnFormats(ICodeSegment cgReq, List cList) {
        int sz = cList.size();
        int j = 0;
        for (int i = 0; i < sz; ++i) {
            String[] sArrayQueueFormat = (String[])cList.get(i);
            String sFormat = sArrayQueueFormat[1];
            if (i == 0) {
                cgReq.addSourceCode("'");
            }
            cgReq.addSourceCode(sFormat);
            if (i < sz - 1) {
                cgReq.addSourceCode("; ");
            } else {
                cgReq.addSourceCode("'");
            }
            if (++j != 3) continue;
            cgReq.addSourceCode("\n");
            j = 0;
        }
    }

    public static void buildBeginTransaction(ICodeSegment cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(MSMQQueueCodegen_BeginTransaction_notrans);
        cgReq.addSourceCode("etls_transid=0;\n");
        cgReq.addSourceCode("call begintransaction( etls_transid, etls_tid, etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, MSMQQueueCodegen_BeginTransFailed_notrans, BEGINTRANS);
        cgReq.addSourceCode("\n");
    }

    public static void buildCommitTransaction(ICodeSegment cgReq) throws MdException, RemoteException {
        MSMQQueueCodegen.buildCommitTransaction(cgReq, true);
    }

    public static void buildCommitTransaction(ICodeSegment cgReq, boolean freeTransaction) throws MdException, RemoteException {
        cgReq.addSectionComment(MSMQQueueCodegen_CommitTransaction_notrans);
        cgReq.addSourceCode("if etls_rc = 0 then call commit( etls_transid, etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, MSMQQueueCodegen_CommitTransFailed_notrans, COMMITTRANS);
        cgReq.addSourceCode("\n");
        if (freeTransaction) {
            MSMQQueueCodegen.buildFreeTransaction(cgReq);
        }
    }

    public static void buildFreeTransaction(ICodeSegment cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(MSMQQueueCodegen_FreeTransaction_notrans);
        cgReq.addSourceCode("call freetransaction( etls_transid, rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, MSMQQueueCodegen_FreeTransFailed_notrans, FREETRANS);
        cgReq.addSourceCode("\n");
    }

    public static void buildVerifyQueueProperties(ICodeSegment cgReq, CommonQueueTransformModel oCommonQueueTransformModel) throws MdException, RemoteException {
        cgReq.addSectionComment(MSMQQueueCodegen_QueueProperties_notrans);
        cgReq.addSourceCode("length etls_ttype $ 10;\n");
        cgReq.addSourceCode("length etls_pmask 8;\n");
        cgReq.addSourceCode("length etls_depth 8;\n");
        cgReq.addSourceCode("length etls_maxdepth 8;\n");
        cgReq.addSourceCode("length etls_maxmsgl 8;\n");
        cgReq.addSourceCode("length etls_ctime $ 80;\n");
        cgReq.addSourceCode("length etls_desc $ 80;\n");
        cgReq.addSourceCode("etls_rc=0;\n");
        cgReq.addSourceCode("etls_ttype='';\n");
        cgReq.addSourceCode("etls_pmask=0;\n");
        cgReq.addSourceCode("etls_depth=0;\n");
        cgReq.addSourceCode("etls_maxdepth=0;\n");
        cgReq.addSourceCode("etls_maxmsgl=0;\n");
        cgReq.addSourceCode("etls_ctime='';\n");
        cgReq.addSourceCode("call getqueueprops(etls_qid, etls_rc,\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_ttype, etls_pmask,\n");
        cgReq.addSourceCode("etls_depth, etls_maxdepth,\n");
        cgReq.addSourceCode("etls_maxmsgl, etls_ctime,\n");
        cgReq.addSourceCode("etls_desc);\n");
        cgReq.unIndent();
        MSMQQueueCodegen.BuildErrorHandling(cgReq, MSMQQueueCodegen_QueuePropertiesFailed_notrans, QUEUEPROPS);
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("if etls_ttype ne 'MSMQ' then \n");
        cgReq.indent();
        cgReq.genPutStatement(MSMQQueueCodegen_QueueTypeFailed_notrans, "NOTE:", "etls_ttype", false);
        cgReq.unIndent();
        cgReq.addSourceCode("else\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("if etls_pmask='1'b then \n");
        cgReq.indent().genPutStatement(MSMQQueueCodegen_AuthMsg_notrans);
        cgReq.unIndent();
        cgReq.addSourceCode("else if etls_pmask='1.'b then \n");
        cgReq.indent().genPutStatement(MSMQQueueCodegen_PrivMsg_notrans);
        cgReq.unIndent();
        cgReq.addSourceCode("else if etls_pmask='1..'b then\n");
        cgReq.indent().genPutStatement(MSMQQueueCodegen_PubMsg_notrans);
        cgReq.unIndent();
        cgReq.addSourceCode("else ");
        cgReq.genPutStatement(MSMQQueueCodegen_PrivOptMsg_notrans);
        cgReq.addSourceCode("if etls_pmask='1...'b then\n");
        cgReq.addSourceCode("do; \n");
        cgReq.indent().genPutStatement(MSMQQueueCodegen_TransMsgRequired_notrans);
        if (oCommonQueueTransformModel.isFileMessage() || oCommonQueueTransformModel.isTransaction()) {
            cgReq.genPutStatement(MSMQQueueCodegen_TransactionRequired_notrans);
        }
        cgReq.unIndent().addSourceCode("end; /* if etls_pmask='1...'b */\n");
        cgReq.addSourceCode("else ");
        cgReq.genPutStatement(MSMQQueueCodegen_TransMsgNotPermitted_notrans);
        cgReq.genPutStatement(MSMQQueueCodegen_QueuePropertiesDepth_notrans, "NOTE:", "etls_depth", false);
        cgReq.genPutStatement(MSMQQueueCodegen_QueuePropertiesMaxDepth_notrans, "NOTE:", "etls_maxdepth", false);
        cgReq.genPutStatement(MSMQQueueCodegen_QueuePropertiesMaxMsgL_notrans, "NOTE:", "etls_maxmsgl", false);
        cgReq.genPutStatement(MSMQQueueCodegen_QueuePropertiesCreateTime_notrans, "NOTE:", "etls_ctime", false);
        cgReq.genPutStatement(MSMQQueueCodegen_QueuePropertiesDesc_notrans, "NOTE:", "etls_desc", false);
        cgReq.unIndent().addSourceCode("end; /* etls_ttype eq 'MSMQ' */\n\n");
    }

    public static ICodeSegment buildMacroValues(CommonQueueTransformModel model, List parameterList, ICodeSegment codeSegment) throws MdException, RemoteException {
        try {
            IPromptDefinitionValue[] promptValues = model.getPromptDefinitionValues();
            for (int iPrompts = 0; iPrompts < promptValues.length; ++iPrompts) {
                Object val;
                String sDefaultValue = "";
                boolean isString = false;
                if (!MSMQQueueCodegen.validMacroValue(promptValues[iPrompts].getName())) continue;
                if (promptValues[iPrompts].isDefaultValueSet()) {
                    sDefaultValue = promptValues[iPrompts].getDefaultValue().toString();
                }
                if (sDefaultValue != null) {
                    boolean bl = isString = promptValues[iPrompts].getDefinition().getPromptDataType().getSQLType() == 12;
                }
                if (promptValues[iPrompts].getValue() == null || promptValues[iPrompts].getValue().toString().compareToIgnoreCase(sDefaultValue) == 0) continue;
                String propName = promptValues[iPrompts].getName();
                String propNameLower = propName.toLowerCase();
                codeSegment.addSourceCode(LENGTH).addSourceCode(PREFIX).addSourceCode(propNameLower);
                parameterList.add(propName);
                if (isString) {
                    if (propName.equals(CORRELATIONID) || propName.equals(MSGID)) {
                        codeSegment.addSourceCode(DEF_ID);
                    } else if (propName.equals(DESCRIPTION)) {
                        codeSegment.addSourceCode(DEF_DESC);
                    } else if (propName.equals(ADMINQUEUE)) {
                        codeSegment.addSourceCode(DEF_DESC);
                    } else if (propName.equals(RESPQUEUE)) {
                        codeSegment.addSourceCode(DEF_DESC);
                    } else {
                        codeSegment.addSourceCode(DEF_CHAR);
                    }
                } else {
                    codeSegment.addSourceCode(DEF_INT);
                }
                codeSegment.addSourceCode(PREFIX).addSourceCode(propNameLower);
                codeSegment.addSourceCode(promptValues[iPrompts].getDelimiter());
                if (isString) {
                    codeSegment.addSourceCode(QUOTE);
                }
                if ((val = promptValues[iPrompts].getValue()) != null) {
                    codeSegment.addSourceCode(val.toString());
                }
                if (isString) {
                    codeSegment.addSourceCode(QUOTE);
                }
                codeSegment.addSourceCode(";\n");
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (ServerConnectionException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return codeSegment;
    }

    private static boolean validMacroValue(String propName) {
        int len = ignoreString.length;
        for (int i = 0; i < len; ++i) {
            if (!propName.equals(ignoreString[i])) continue;
            return false;
        }
        return true;
    }

    protected static void buildAttributeList(List parameterList, boolean isReader, SASCodeGeneration attrib, SASCodeGeneration attribVal) {
        int j = 0;
        for (int i = 0; i < parameterList.size(); ++i) {
            String nm = (String)parameterList.get(i);
            attrib.addSourceCode(nm).addSourceCode(",").addSourceCode(SPACE);
            attribVal.addSourceCode(PREFIX).addSourceCode(nm.toLowerCase()).addSourceCode(",").addSourceCode(SPACE);
            if (++j != 2) continue;
            attrib.addSourceCode("\n");
            attribVal.addSourceCode("\n");
            j = 0;
        }
        if (isReader) {
            attrib.addSourceCode(MSGTYPE).addSourceCode(",");
            attrib.addSourceCode(" MAP");
            attribVal.addSourceCode("etls_msgtype").addSourceCode(",");
            attribVal.addSourceCode(" etls_map");
        }
    }
}

