/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.transforms.queues.impl.MQROOT;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MQGET
extends MQROOT {
    public static final String MQGET_RetrieveMessage_Comment_notrans = "MQGET: Retrieves a message from a local MQSeries queue that has been previously opened";
    public static final String MQGET_Failed_Comment_notrans = "MQGET failed";
    public static final String MQGET_ReachedEndOfQueue_put_notrans = "MQGET: Reached end of queue";
    public static final String MQGET_Failedwithreasoncode_put_notrans = "MQGET failed with reason code:";

    public MQGET(ICodeSegment cgReq, boolean bQueueWriter, HashMap hmUserInput) throws MdException, RemoteException {
        super(cgReq, bQueueWriter, hmUserInput);
    }

    public void generateLengthStatements() {
        this.addBlankLine();
        this.addLengthStatement("etls_rcv_msg_len", true, "8");
        this.assignVariable("etls_rcv_msg_len", "0", false);
    }

    public void generateAssignmentStatements() {
    }

    public void generateFunctionCall() {
        this.addBlankLine();
        this.addBlankLine();
        this.m_cg.addCommentLine(MQGET_RetrieveMessage_Comment_notrans);
        this.buildFunctionCall(this.getFunctionParms());
        this.addFailConditions();
    }

    public List getFunctionParms() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("etls_hconn");
        list.add(this.getObjectHandle());
        list.add("etls_hmd");
        list.add("etls_hgmo");
        list.add("etls_rcv_msg_len");
        list.add("etls_compcode");
        list.add("etls_qrc");
        return list;
    }

    private void addFailConditions() {
        this.m_cg.addCommentLine(MQGET_Failed_Comment_notrans);
        this.addString("if ");
        this.addString("etls_compcode");
        this.addString(" ^= 0 then \ndo;\n");
        this.m_cg.indent();
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2033 then \ndo; \n");
        this.m_cg.indent();
        this.addString("\nrc=0;\n");
        this.m_cg.genRCSetDSCall("0", true);
        this.m_cg.genPutStatement(MQGET_ReachedEndOfQueue_put_notrans, "NOTE:");
        this.addExitLine();
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \ndo;\n");
        this.m_cg.indent();
        this.m_cg.genRCSetDSCall("8000", true);
        this.m_cg.genPutStatement(MQGET_Failedwithreasoncode_put_notrans, "ERROR%QUOTE(:)", "etls_qrc", false);
        this.addString("etls_msg = sysmsg();\n");
        this.m_cg.genPutStatement("System Message", "ERROR%QUOTE(:)", "etls_msg", false);
        this.addExitLine();
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.m_cg.unIndent();
        this.addString("end;\n");
    }
}

