/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.job.transforms.queues.impl.CommonQueueTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.IBMWSQReaderCodegen;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BasePromptModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class IBMWSQReaderTransformModel
extends CommonQueueTransformModel {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.queues.IBMWSQReader";
    private static final String TRANSFORMATION_ROLE = "IBMWSQReader:HIDE";
    private static final String ARM_DISPLAY_NAME = "IBMWSQReader";

    public IBMWSQReaderTransformModel(String sID, IModel model) {
        super(sID, model);
        super.setCollectSourceTableRowCounts(false);
        super.setCollectTargetTableRowCounts(false);
        this.setMQSystem("IBMWSMQ");
        this.setReader(true);
        this.createConditionActionSetTemplates();
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("IBMWSQReaderTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("IBMWSQReaderTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
    }

    @Override
    protected IPromptModel createMessageOptionModel() throws RemoteException, MdException, ServiceException, ServerConnectionException, ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        BasePromptModel p = new BasePromptModel(this.getModel(), this);
        p.setPromptGroup(p.createPromptGroup(this.getClass().getResource("res/Options_WSQReader_Template.xml")));
        return p;
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.addNewWorkTable();
        this.loadConditionActionSetTemplatesFromOMR();
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IBMWSQReaderCodegen cg = new IBMWSQReaderCodegen();
        try {
            codeSegment = cg.getGeneratedCode(codeSegment, this);
            if (codeSegment.isRunTableStatisticsEnabled() && this.isTableMessage()) {
                codeSegment.genRowsProcessedCount(this.getTargetTable(), null);
            }
        }
        catch (RemoteException e) {
            throw new CodegenException(e, (IObject)this);
        }
        catch (MdException e) {
            throw new CodegenException((Exception)((Object)e), (IObject)this);
        }
        catch (BadLibraryDefinitionException e) {
            throw new CodegenException(e, (IObject)this);
        }
        return codeSegment;
    }
}

