/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.queues.impl.CommonQueueTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.IBMWSQReaderTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.MQCLOSE;
import com.sas.etl.models.job.transforms.queues.impl.MQCONN;
import com.sas.etl.models.job.transforms.queues.impl.MQGET;
import com.sas.etl.models.job.transforms.queues.impl.MQGETPARMS;
import com.sas.etl.models.job.transforms.queues.impl.MQGMO;
import com.sas.etl.models.job.transforms.queues.impl.MQINQ;
import com.sas.etl.models.job.transforms.queues.impl.MQLog;
import com.sas.etl.models.job.transforms.queues.impl.MQMAP;
import com.sas.etl.models.job.transforms.queues.impl.MQMD;
import com.sas.etl.models.job.transforms.queues.impl.MQOD;
import com.sas.etl.models.job.transforms.queues.impl.MQOPEN;
import com.sas.etl.models.job.transforms.queues.impl.MQROOT;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public class IBMWSQReaderCodegen {
    public static final String IBMWSQReaderCodegen_MsgToMacro_Comment_notrans = "Store message to a macro variable";
    public static final String IBMWSQReaderCodegen_MsgInMacroVariable_put_fmt_notrans = "Text message in macro variable {0} is :&{0}";
    public static final String IBMWSQReaderCodegen_Keep_Comment_notrans = "Keep these fields";
    public static final String IBMWSQReaderCodegen_Attributes_Comment_notrans = "Field attributes";
    public static final String IBMWSQReaderCodegen_ReadFile_Comment_notrans = "Read file from queue";
    public static final String IBMWSQReaderCodegen_ErrorOpeningFile_put_fmt_notrans = "Error opening output file...{0}";
    public static final String IBMWSQReaderCodegen_FileProcessing_Comment_notrans = "File processing...";
    public static final String IBMWSQReaderCodegen_FileBegins_Comment_notrans = "File begins at this message";
    public static final String IBMWSQReaderCodegen_CorrelatingMsg_Comment_notrans = "Write all correlating messages to this file";
    public static final String IBMWSQReaderCodegen_MsgBelongsTo_Comment_notrans = "Make sure message belongs to this file";
    public static final String IBMWSQReaderCodegen_MsgOutOfSequence_Comment_notrans = "This message is out of sequence so search for it";
    public static final String IBMWSQReaderCodegen_IncrementSequence_Comment_notrans = "Increment sequence number for next expected message";
    public static final String IBMWSQReaderCodegen_RetrieveRecord_Comment_notrans = "Retrieve record from internal buffer";
    public static final String IBMWSQReaderCodegen_LenFirstByte_Comment_notrans = "Length of this stream is embedded as 1st byte in msg";
    public static final String IBMWSQReaderCodegen_LenStream_Comment_notrans = "Length of etls_stream is : ";
    public static final String IBMWSQReaderCodegen_WriteStream_Comment_notrans = "Write stream to file";
    public static final String IBMWSQReaderCodegen_ErrorWriting_Comment_put_notrans = "Error writing to output file buffer...";
    public static final String IBMWSQReaderCodegen_FlushToDisk_Comment_put_notrans = "Flush it to disk";
    public static final String IBMWSQReaderCodegen_ErrorWritingToFile_Comment_put_notrans = "Error writing to output file...";
    public static final String IBMWSQReaderCodegen_ReceiveUntilLast_Comment_put_notrans = "Receive until last in group";
    public static final String IBMWSQReaderCodegen_RemoveMessageFromQueue_Comment_notrans = "Now remove message from the queue...";
    public static final String IBMWSQReaderCodegen_RereadPreviousMsg_Comment_notrans = "Re-read previous message";
    public static final String IBMWSQReaderCodegen_BrowseNextMsg_Comment_notrans = "Browse next message";
    public static final String IBMWSQReaderCodegen_FinishedRetrieving_Comment_notrans = "Finished retrieving all messages belonging to this file";
    public static final String IBMWSQReaderCodegen_ResetMsgDescriptor_Comment_notrans = "Reset message descriptor";
    public static final String IBMWSQReaderCodegen_CloseFile_Comment_notrans = "Close file";
    public static final String IBMWSQReaderCodegen_ErrorClosingFile_Comment_put_notrans = "Error closing output file";
    public static final String IBMWSQReaderCodegen_MsgLengthInput_put_notrans = "Message length input by user is:";
    public static final String IBMWSQReaderCodegen_MsgLengthMinimum_put_notrans = "Message length on message being received from queue is:";
    public static final String IBMWSQReaderCodegen_MsgTypeFilter1_put_notrans = "Message did not satisfy message type filter entered by user";
    public static final String IBMWSQReaderCodegen_MsgTypeFilter2_put_notrans = "Message type entered by user is :";
    public static final String IBMWSQReaderCodegen_MsgTypeFilter3_put_notrans = "Message type on message read from queue is :";
    public static final String IBMWSQReaderCodegen_NoSourceQueue_msg_txt = "This transformation must have a Queue object as source.";
    public static final String IBMWSQReaderCodegen_QueueOptionsNotSet_txt = "Queue Options have not been set.  Please edit queue transform to set queue options.";
    public static final String IBMWSQReader_ToolTip_txt = "Writes to an IBM message system";
    public static final String IBMWSQReader_Category_txt = "Access";
    public static final String IBMWSQReader_Name_txt = "Websphere Queue Reader";
    public static final String IBMWSQReader_description_txt = "Websphere Queue Reader Transform, Copyright (C) 2006 by SAS Institute Inc.";
    public static final String IBMWSQReader_Insert_image = "MessageQueueIBMWebsphere.gif";
    public static final String IBMWSQReader_TSName_txt = "Websphere Queue Reader";
    public static final String IBMWSQReader_CMName_txt = "Websphere Queue Reader";
    public static final String IBMWSQReader_OutputTemplateDesc_txt = "Queue";
    public static final String IBMWSQReader_InputTemplateName_txt = "Place Queue here";
    public static final String IBMWSQReader_OutputTemplateName_txt = "Place table or transform here";
    public static final String IBMWSQReader_TemplateDesc_txt = "PhysicalTable,ExternalTable,Cube,Report,Transformation";
    public static final String IBMWSQReader_TableWithNoColumns_exception_fmt_txt = "The table {0} has no columns";
    public static final String IBMWSQReader_QueueColumnsTable_txt = "Message Queue Columns";
    protected static String ETLS_WSMQ_READER_WORKTABLE = "work.etls_wsmq_tblfromq";

    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment, IBMWSQReaderTransformModel oIBMWSQReaderTransformModel) throws BadLibraryDefinitionException, CodegenException, RemoteException, BadServerDefinitionException, ServerException, MdException {
        oIBMWSQReaderTransformModel.loadOptions();
        HashMap hmUserInput = oIBMWSQReaderTransformModel.getOptions();
        MQROOT.setMQGlobalVariables(codeSegment, hmUserInput);
        if (oIBMWSQReaderTransformModel.isTextMessage()) {
            IBMWSQReaderCodegen.readTextFromQueue(codeSegment, oIBMWSQReaderTransformModel, hmUserInput);
        } else if (oIBMWSQReaderTransformModel.isTableMessage()) {
            IBMWSQReaderCodegen.readTableFromQueue(codeSegment, oIBMWSQReaderTransformModel, hmUserInput);
        } else if (oIBMWSQReaderTransformModel.isFileMessage()) {
            IBMWSQReaderCodegen.readFileFromQueue(codeSegment, oIBMWSQReaderTransformModel, hmUserInput);
        } else {
            oIBMWSQReaderTransformModel.loadOptions();
            hmUserInput = oIBMWSQReaderTransformModel.getOptions();
            IBMWSQReaderCodegen.readTextFromQueue(codeSegment, oIBMWSQReaderTransformModel, hmUserInput);
        }
        codeSegment.genRCSetCall("&syserr");
        codeSegment.genCodeConditionCheck(codeSegment, "DIS_CSUCCESSFUL", oIBMWSQReaderTransformModel, null);
        codeSegment.genCodeConditionCheck(codeSegment, "DIS_CWARNINGS", oIBMWSQReaderTransformModel, null);
        codeSegment.genCodeConditionCheck(codeSegment, "DIS_CERRORS", oIBMWSQReaderTransformModel, null);
        return codeSegment;
    }

    private static void readTextFromQueue(ICodeSegment codeSegment, CommonQueueTransformModel oCommonQModel, HashMap hmUserInput) throws MdException, RemoteException {
        CommonQueueTransformModel.textMessageToMacroVariable(oCommonQModel, codeSegment);
        String sMacroVar = "etls_qms";
        if (hmUserInput.containsKey("etls_macroname")) {
            sMacroVar = (String)hmUserInput.get("etls_macroname");
        }
        if (sMacroVar == null || sMacroVar.length() == 0) {
            sMacroVar = "etls_qms";
        }
        codeSegment.addSourceCode("%let ");
        codeSegment.addSourceCode(sMacroVar);
        codeSegment.addSourceCode("=;\n");
        codeSegment.addSourceCode("data _null_;\n").indent();
        MQROOT mqROOT = new MQROOT(codeSegment, false, hmUserInput);
        MQCONN mqconn = new MQCONN(codeSegment, false, hmUserInput);
        mqROOT.addLengthForParametersAndOptions();
        MQOD mqod = new MQOD(codeSegment, false, hmUserInput);
        MQOPEN mqopen = new MQOPEN(codeSegment, false, hmUserInput);
        mqopen.setOption(MQOPEN.INPUT_SHARED);
        MQINQ mqinq = new MQINQ(codeSegment, false, hmUserInput);
        if (mqinq.isOn()) {
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQGMO mqgmo = new MQGMO(codeSegment, false, hmUserInput);
        MQMD mqmd = new MQMD(codeSegment, false, hmUserInput);
        mqmd.readFromTransformationInput();
        MQMAP mqmap = new MQMAP(codeSegment, false, hmUserInput);
        mqmap.setDescriptors();
        MQGET mqget = new MQGET(codeSegment, false, hmUserInput);
        MQGETPARMS mqgetParms = new MQGETPARMS(codeSegment, false, hmUserInput);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqgmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqget.generateLengthStatements();
        mqgetParms.generateLengthStatements();
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqgmo.generateAssignmentStatements();
        mqgmo.generateFunctionCall();
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        mqget.generateAssignmentStatements();
        mqget.generateFunctionCall();
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("etls_desc=\"CHAR,,\" || kcompress(put(etls_rcv_msg_len, 6.));\n");
        codeSegment.addSourceCode("call mqmap(etls_hmap, etls_qrc, etls_desc);\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("if ");
        codeSegment.addSourceCode("etls_rcv_msg_len");
        codeSegment.addSourceCode(" > ");
        codeSegment.addSourceCode((String)hmUserInput.get("etls_message_length"));
        codeSegment.addSourceCode(" then \ndo;\n");
        codeSegment.indent();
        codeSegment.genPutStatement(IBMWSQReaderCodegen_MsgLengthInput_put_notrans + (String)hmUserInput.get("etls_message_length"), "NOTE:");
        codeSegment.genPutStatement(IBMWSQReaderCodegen_MsgLengthMinimum_put_notrans, "NOTE:", "etls_rcv_msg_len", false);
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.beginDebug();
            codeSegment.addSourceCode("if ");
            codeSegment.addSourceCode("etls_rcv_msg_len");
            codeSegment.addSourceCode(" <> ");
            codeSegment.addSourceCode((String)hmUserInput.get("etls_message_length"));
            codeSegment.addSourceCode(" then \ndo;\n");
            codeSegment.indent();
            codeSegment.genPutStatement(IBMWSQReaderCodegen_MsgLengthInput_put_notrans + (String)hmUserInput.get("etls_message_length"), "NOTE:");
            codeSegment.genPutStatement(IBMWSQReaderCodegen_MsgLengthMinimum_put_notrans, "NOTE:", "etls_rcv_msg_len", false);
            codeSegment.unIndent();
            codeSegment.addSourceCode("end;\n");
            mqROOT.endDebug();
        }
        codeSegment.addSourceCode("if ");
        codeSegment.addSourceCode("etls_rcv_msg_len");
        codeSegment.addSourceCode(" > 0  then \ndo;\n");
        codeSegment.indent();
        mqgetParms.generateAssignmentStatements();
        mqgetParms.generateFunctionCall();
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addCommentLine(IBMWSQReaderCodegen_MsgToMacro_Comment_notrans);
        codeSegment.addSourceCode("CALL SYMPUT('");
        codeSegment.addSourceCode(sMacroVar);
        codeSegment.addSourceCode("',");
        codeSegment.addSourceCode("etls_read");
        codeSegment.addSourceCode(");\n");
        codeSegment.addSourceCode("etls_mqexit");
        codeSegment.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    private static void readTableFromQueue(ICodeSegment codeSegment, CommonQueueTransformModel oCommonQModel, HashMap hmUserInput) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String sValue;
        String sValue2;
        IPhysicalTable oIPhysicalTable = oCommonQModel.getTargetTable();
        MQROOT mqROOT = new MQROOT(codeSegment, false, hmUserInput);
        codeSegment.genTableDelete(oIPhysicalTable);
        boolean bNeedQuotes = codeSegment.isQuoting();
        String targetTableName = oIPhysicalTable.getFullNameQuotedAsNeeded(codeSegment);
        IColumn[] targetColumnList = oIPhysicalTable.getColumns();
        if (targetColumnList.length == 0) {
            String msgString = MQLog.formatString(IBMWSQReader_TableWithNoColumns_exception_fmt_txt, targetTableName);
            throw new MdException(msgString);
        }
        List listMessageColumns = oCommonQModel.buildMessageColumnsList(targetColumnList);
        codeSegment.addSourceCode("data ");
        codeSegment.addSourceCode(targetTableName).addSourceCode(" ");
        oCommonQModel.getTableOptionObject(oIPhysicalTable, false);
        codeSegment.addSourceCode(oCommonQModel.getTableOptionObject(oIPhysicalTable, false).getTableOptions(true, codeSegment.getCurrentServer()));
        codeSegment.addSourceCode(";\n");
        codeSegment.indent();
        mqROOT.addLengthForParametersAndOptions();
        IBMWSQReaderCodegen.readUserInput(codeSegment, hmUserInput);
        mqROOT.addBlankLine();
        codeSegment.addCommentLine(IBMWSQReaderCodegen_Keep_Comment_notrans);
        codeSegment.addSourceCode("keep ");
        codeSegment.addSourceCode(codeSegment.makeColumnList(targetColumnList, "", bNeedQuotes, " "));
        codeSegment.addSourceCode(";\n");
        mqROOT.addBlankLine();
        codeSegment.addCommentLine(IBMWSQReaderCodegen_Attributes_Comment_notrans);
        for (int i = 0; i < targetColumnList.length; ++i) {
            codeSegment.addSourceCode(targetColumnList[i].getAttribStatement(bNeedQuotes, true, true, false));
        }
        mqROOT.addBlankLine();
        MQCONN mqconn = new MQCONN(codeSegment, false, hmUserInput);
        MQOD mqod = new MQOD(codeSegment, false, hmUserInput);
        MQOPEN mqopen = new MQOPEN(codeSegment, false, hmUserInput);
        mqopen.setOption(MQOPEN.INPUT_SHARED);
        mqopen.setOption(MQOPEN.INQUIRE);
        MQGMO mqgmo = new MQGMO(codeSegment, false, hmUserInput);
        MQMD mqmd = new MQMD(codeSegment, false, hmUserInput);
        MQMAP mqmap = new MQMAP(codeSegment, false, hmUserInput);
        mqmap.setDescriptors(listMessageColumns);
        MQMD mqmd2 = new MQMD(codeSegment, false, hmUserInput);
        mqmd2.readFromTransformationInput();
        MQGET mqget = new MQGET(codeSegment, false, hmUserInput);
        MQGETPARMS mqgetParms = new MQGETPARMS(codeSegment, false, hmUserInput);
        mqgetParms.addDescriptor(listMessageColumns);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqgmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqmd2.generateLengthStatements();
        MQINQ mqinq = new MQINQ(codeSegment, false, hmUserInput);
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqget.generateLengthStatements();
        mqgetParms.generateLengthStatements();
        mqROOT.generateRetainStatement();
        codeSegment.addSourceCode("if _N_=1 then \ndo;\n");
        codeSegment.indent();
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqgmo.generateAssignmentStatements();
        mqgmo.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        boolean bVarLengthRead = false;
        if (hmUserInput.containsKey("MQVARLENREAD") && (sValue2 = (String)hmUserInput.get("MQVARLENREAD")).compareToIgnoreCase("YES") == 0) {
            bVarLengthRead = true;
        }
        boolean bFreeData = true;
        if (hmUserInput.containsKey("MQFREEDATA") && (sValue = (String)hmUserInput.get("MQFREEDATA")).compareToIgnoreCase("NO") == 0) {
            bFreeData = false;
        }
        if (!bFreeData) {
            mqmap.generateAssignmentStatements();
            mqmap.generateFunctionCall();
        }
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        String sLimit = "99999999";
        if (hmUserInput.containsKey("LIMIT_READ")) {
            sLimit = (String)hmUserInput.get("LIMIT_READ");
        }
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        codeSegment.addSourceCode("do i=1 to ");
        codeSegment.addSourceCode(sLimit.trim());
        codeSegment.addSourceCode(";\n");
        codeSegment.indent();
        if (bVarLengthRead) {
            mqmd2.generateAssignmentStatements();
            mqmd2.generateFunctionCall();
            mqget.generateAssignmentStatements();
            mqget.generateFunctionCall();
            if (bFreeData) {
                mqmap.generateAssignmentStatements();
                mqmap.generateFunctionCall();
            }
        } else {
            if (bFreeData) {
                mqmap.generateAssignmentStatements();
                mqmap.generateFunctionCall();
            }
            mqmd2.generateAssignmentStatements();
            mqmd2.generateFunctionCall();
            mqget.generateAssignmentStatements();
            mqget.generateFunctionCall();
        }
        mqgetParms.setQuoteCols(bNeedQuotes);
        mqgetParms.generateAssignmentStatements();
        mqgetParms.generateFunctionCall();
        mqgetParms.moveVarsToColumns();
        codeSegment.addSourceCode("output;\n");
        mqROOT.freeDataHandles(hmUserInput);
        codeSegment.addSourceCode("\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("etls_mqexit");
        codeSegment.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    private static void readFileFromQueue(ICodeSegment codeSegment, CommonQueueTransformModel oCommonQModel, HashMap hmUserInput) throws MdException, RemoteException {
        String sGroupMessages = (String)hmUserInput.get("GROUP_MESSAGES");
        boolean bGroupMessages = true;
        if (sGroupMessages != null && sGroupMessages.compareToIgnoreCase("NO") == 0) {
            bGroupMessages = false;
        }
        MQROOT mqROOT = new MQROOT(codeSegment, true, hmUserInput);
        if (bGroupMessages) {
            MQROOT.setV51ReceiveMacroVars(codeSegment, hmUserInput);
        }
        mqROOT.addBlankLine();
        codeSegment.addCommentLine(IBMWSQReaderCodegen_ReadFile_Comment_notrans);
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("length etls_streamlen 8;\n");
        mqROOT.addLengthForParametersAndOptions();
        codeSegment.addSourceCode("length etls_msgbuf $ ");
        codeSegment.addSourceCode((String)hmUserInput.get("etls_message_length"));
        codeSegment.addSourceCode(";\n");
        codeSegment.addSourceCode("length etls_stream $ ");
        codeSegment.addSourceCode((String)hmUserInput.get("etls_message_length"));
        codeSegment.addSourceCode(";\n");
        IBMWSQReaderCodegen.readUserInput(codeSegment, hmUserInput);
        if (!bGroupMessages) {
            codeSegment.addSourceCode("length etls_lencorrid 3.;\n");
            codeSegment.addSourceCode("if etls_ui_correlid eq '' then\n");
            codeSegment.addSourceCode("   etls_ui_correlid='0' ;\n");
            codeSegment.addSourceCode("etls_lencorrid =length(etls_ui_correlid) * (etls_ui_correlid ne '');;\n");
        }
        mqROOT.addBlankLine();
        codeSegment.addCommentLine(IBMWSQReaderCodegen_ReadFile_Comment_notrans);
        codeSegment.addSourceCode("filename etls_fn1 \"");
        codeSegment.addSourceCode((String)hmUserInput.get("etls_filename"));
        String messageLength = (String)hmUserInput.get("etls_message_length");
        if (messageLength != null && !messageLength.equals("256")) {
            codeSegment.addSourceCode("\" lrecl=").addSourceCode(messageLength).addSourceCode(";\n");
        } else {
            codeSegment.addSourceCode("\";\n");
        }
        mqROOT.addBlankLine();
        codeSegment.addSourceCode("fileid = fopen('etls_fn1', 'o', 0, 'b');\n");
        codeSegment.addSourceCode("if( fileid = 0 ) then \ndo;\n");
        codeSegment.indent();
        String msgString = MQLog.formatString(IBMWSQReaderCodegen_ErrorOpeningFile_put_fmt_notrans, hmUserInput.get("etls_filename"));
        codeSegment.genPutStatement(msgString, "ERROR%QUOTE(:)");
        mqROOT.addExitLine();
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        MQCONN mqconn = new MQCONN(codeSegment, false, hmUserInput);
        MQOD mqod = new MQOD(codeSegment, false, hmUserInput);
        MQOPEN mqopen = new MQOPEN(codeSegment, false, hmUserInput);
        mqopen.setOption(MQOPEN.INPUT_SHARED);
        if (bGroupMessages) {
            mqopen.setOption(MQOPEN.BROWSE);
            mqopen.setOption(MQOPEN.INQUIRE);
        } else {
            mqopen.setOption(MQOPEN.BROWSE);
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQGMO mqgmo = new MQGMO(codeSegment, false, hmUserInput);
        mqgmo.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_NEXT);
        if (bGroupMessages) {
            mqgmo.setValue(MQGMO.MATCHOPTIONS, "seqnumber");
        }
        mqgmo.setAction("GEN");
        mqgmo.removeOption(MQGMO.SYNCPOINT);
        MQMD mqmd = new MQMD(codeSegment, false, hmUserInput);
        if (bGroupMessages) {
            mqmd.setValue(MQMD.MSGSEQNUMBER, "1");
        }
        MQGET mqget = new MQGET(codeSegment, false, hmUserInput);
        MQMD mqmd2 = new MQMD(codeSegment, false, hmUserInput);
        mqmd2.setAction("INQ");
        if (bGroupMessages) {
            mqmd2.setMQMDVersion("");
            mqmd2.setParameter(MQMD.MSGTYPE);
            mqmd2.setParameter(MQMD.GROUPID);
            mqmd2.setParameter(MQMD.MSGSEQNUMBER);
            mqmd2.setParameter(MQMD.MSGFLAGS);
        } else {
            mqmd2.setMQMDVersion("2");
            mqmd2.setParameter(MQMD.CORRELID);
            mqmd2.setParameter(MQMD.MSGTYPE);
        }
        MQGMO mqgmo2 = new MQGMO(codeSegment, false, hmUserInput);
        if (!bGroupMessages) {
            mqgmo2.setAction("SET");
            mqgmo2.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_NEXT);
            mqgmo2.removeOption(MQGMO.SYNCPOINT);
        }
        MQMAP mqmap = new MQMAP(codeSegment, false, hmUserInput);
        mqmap.setDescriptors();
        MQOPEN mqopen2 = new MQOPEN(codeSegment, false, hmUserInput);
        if (bGroupMessages) {
            mqopen2.setOption(MQOPEN.INPUT_SHARED);
        } else {
            mqopen2.setOption(MQOPEN.INPUT_SHARED);
            mqopen2.setOption(MQOPEN.BROWSE);
            mqopen2.setObjectHandleVersion("2");
        }
        MQMD mqmd3 = new MQMD(codeSegment, false, hmUserInput);
        mqmd3.setMQMDVersion("3");
        mqmd3.setAction("SET");
        if (bGroupMessages) {
            mqmd3.setParameter(MQMD.GROUPID);
            mqmd3.setValue(MQMD.GROUPID, "etls_groupid");
            mqmd3.setCharacterQuoting(MQMD.GROUPID, false);
        } else {
            mqmd3.setParameter(MQMD.MSGID);
            mqmd3.setParameter(MQMD.CORRELID);
            mqmd3.setValue(MQMD.MSGID, "");
            mqmd3.setValue(MQMD.CORRELID, "etls_correlid2");
            mqmd3.setCharacterQuoting(MQMD.CORRELID, false);
        }
        MQGMO mqgmo3 = new MQGMO(codeSegment, false, hmUserInput);
        if (bGroupMessages) {
            mqgmo3.setValue(MQGMO.MATCHOPTIONS, "groupid");
            mqgmo3.setValue(MQGMO.OPTIONS, MQGMO.LOGICAL_ORDER + "," + MQGMO.COMPLETE_MSG + "," + MQGMO.ALL_MSGS_AVAILABLE);
        } else {
            mqgmo3.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_FIRST);
            mqgmo3.removeOption(MQGMO.SYNCPOINT);
        }
        mqgmo3.setAction("SET");
        MQGET mqget2 = new MQGET(codeSegment, false, hmUserInput);
        if (!bGroupMessages) {
            mqget2.setObjectHandleVersion("2");
        }
        MQGETPARMS mqgetParms = new MQGETPARMS(codeSegment, false, hmUserInput);
        mqgetParms.addDescriptorForFileRead();
        MQGMO mqgmo4 = new MQGMO(codeSegment, false, hmUserInput);
        mqgmo4.setValue(MQGMO.OPTIONS, MQGMO.MSG_UNDER_CURSOR);
        mqgmo4.setAction("SET");
        MQGET mqget3 = new MQGET(codeSegment, false, hmUserInput);
        mqget3.setObjectHandleVersion("2");
        MQGMO mqgmo5 = new MQGMO(codeSegment, false, hmUserInput);
        mqgmo5.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_MSG_UNDER_CURSOR);
        mqgmo5.setAction("SET");
        mqgmo5.removeOption(MQGMO.SYNCPOINT);
        MQGET mqget4 = new MQGET(codeSegment, false, hmUserInput);
        MQGMO mqgmo6 = new MQGMO(codeSegment, false, hmUserInput);
        mqgmo6.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_NEXT);
        mqgmo6.setAction("SET");
        mqgmo6.removeOption(MQGMO.SYNCPOINT);
        MQMD mqmd4 = new MQMD(codeSegment, false, hmUserInput);
        mqmd4.setMQMDVersion("4");
        mqmd4.setAction("SET");
        mqmd4.setParameter(MQMD.MSGID);
        mqmd4.setParameter(MQMD.CORRELID);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqgmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqget.generateLengthStatements();
        mqmd2.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqmd3.generateLengthStatements();
        mqgetParms.generateLengthStatements();
        mqmd4.generateLengthStatements();
        codeSegment.addSourceCode("etls_CORRELID4=\"\";\n");
        codeSegment.addSourceCode("etls_MSGID4=\"\";\n");
        codeSegment.addSourceCode("etls_correlid2=\"\";\n");
        MQINQ mqinq = new MQINQ(codeSegment, false, hmUserInput);
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqgmo.generateAssignmentStatements();
        mqgmo.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        if (!bGroupMessages) {
            codeSegment.addSourceCode("etls_seqno=0;\n\n");
            codeSegment.addSourceCode("etls_recv:\n\n");
        }
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        mqget.generateAssignmentStatements();
        mqget.generateFunctionCall();
        mqmd2.generateAssignmentStatements();
        mqmd2.generateFunctionCall();
        codeSegment.addSourceCode("etls_correlid3=etls_correlid2;\n");
        if (!bGroupMessages) {
            mqgmo2.generateAssignmentStatements();
            mqgmo2.generateFunctionCall();
        }
        codeSegment.addSourceCode("\n");
        if (bGroupMessages) {
            codeSegment.addSourceCode("if ((etls_msgtype=etls_ui_msgtype) or (etls_ui_msgtype = 0)) then \ndo;\n");
        } else {
            codeSegment.addSourceCode("if ((etls_msgtype2=etls_ui_msgtype) or (etls_ui_msgtype = 0)) then \ndo;\n");
        }
        codeSegment.indent();
        codeSegment.addCommentLine(IBMWSQReaderCodegen_FileProcessing_Comment_notrans);
        if (!bGroupMessages) {
            codeSegment.addSourceCode("etls_outofseq=0;\n");
            codeSegment.addSourceCode("\n");
            codeSegment.addSourceCode("if( upcase(substr(etls_ui_correlid,1,etls_lencorrid)) = upcase(substr(etls_correlid2,1,etls_lencorrid)) ) then \ndo;\n").indent();
            codeSegment.addCommentLine(IBMWSQReaderCodegen_FileBegins_Comment_notrans);
            codeSegment.addSourceCode("\n");
            codeSegment.addCommentLine(IBMWSQReaderCodegen_CorrelatingMsg_Comment_notrans);
            codeSegment.addSourceCode("etls_ui_correlid = upcase(substr(etls_correlid2,1,etls_lencorrid));\n");
            codeSegment.addSourceCode("\n");
        }
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        if (bGroupMessages) {
            MQCLOSE mqclose = new MQCLOSE(codeSegment, false, hmUserInput);
            mqclose.generateSASCode();
        } else {
            codeSegment.unIndent();
            codeSegment.addSourceCode("end;\n");
            codeSegment.addSourceCode("\n");
            codeSegment.addCommentLine(IBMWSQReaderCodegen_MsgBelongsTo_Comment_notrans);
            codeSegment.addSourceCode("if( upcase(substr(etls_correlid2,1,etls_lencorrid)) = upcase(etls_ui_correlid) ) then \ndo;\n").indent();
            codeSegment.addSourceCode("if( etls_seqno ^= input(substr(etls_correlid2,etls_lencorrid+1,4), hex4.) ) ");
            codeSegment.addSourceCode("then \ndo;\n");
            codeSegment.indent();
            codeSegment.addCommentLine(IBMWSQReaderCodegen_MsgOutOfSequence_Comment_notrans);
            codeSegment.addSourceCode("etls_outofseq=1;\n");
        }
        codeSegment.addSourceCode("\n");
        mqopen2.generateAssignmentStatements();
        mqopen2.generateFunctionCall();
        if (!bGroupMessages) {
            codeSegment.addSourceCode("etls_correlid2 = upcase(etls_ui_correlid);\n");
            codeSegment.addSourceCode("substr(etls_correlid2,etls_lencorrid+1,4) = put(etls_seqno, hex4.);\n");
        }
        if (bGroupMessages) {
            mqgmo3.generateAssignmentStatements();
            mqgmo3.generateFunctionCall();
            mqmd3.generateAssignmentStatements();
            mqmd3.generateFunctionCall();
        } else {
            mqmd3.generateAssignmentStatements();
            mqmd3.generateFunctionCall();
            mqgmo3.generateAssignmentStatements();
            mqgmo3.generateFunctionCall();
        }
        if (bGroupMessages) {
            codeSegment.addSourceCode("etls_next:;\n");
        }
        mqget2.generateAssignmentStatements();
        mqget2.generateFunctionCall();
        if (bGroupMessages) {
            mqmd2.generateAssignmentStatements();
            mqmd2.generateFunctionCall();
        } else {
            codeSegment.unIndent();
            codeSegment.addSourceCode("end;\n");
            codeSegment.addCommentLine(IBMWSQReaderCodegen_IncrementSequence_Comment_notrans);
            codeSegment.addSourceCode("etls_seqno+1;\n");
            codeSegment.addSourceCode("\n");
        }
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("etls_desc=\"CHAR,,\" || kcompress(put(etls_rcv_msg_len, 6.));\n");
        codeSegment.addSourceCode("call mqmap(etls_hmap, etls_qrc, etls_desc);\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addCommentLine(IBMWSQReaderCodegen_RetrieveRecord_Comment_notrans);
        mqgetParms.generateAssignmentStatements();
        mqgetParms.generateFunctionCall();
        mqgetParms = null;
        codeSegment.addSourceCode("etls_streamlen = etls_rcv_msg_len;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.beginDebug();
            codeSegment.genPutStatement(IBMWSQReaderCodegen_LenStream_Comment_notrans, "NOTE:", "etls_rcv_msg_len", false);
            mqROOT.endDebug();
        }
        codeSegment.addSourceCode("etls_stream = substr(etls_msgbuf,1);\n");
        codeSegment.addCommentLine(IBMWSQReaderCodegen_WriteStream_Comment_notrans);
        codeSegment.addSourceCode("rc = fput(fileid, substr(etls_stream,1,etls_streamlen));\n");
        codeSegment.addSourceCode("if( rc ) then \ndo;\n");
        codeSegment.indent();
        codeSegment.genPutStatement(IBMWSQReaderCodegen_ErrorWriting_Comment_put_notrans, "ERROR%QUOTE(:)");
        mqROOT.addExitLine();
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addCommentLine(IBMWSQReaderCodegen_FlushToDisk_Comment_put_notrans);
        codeSegment.addSourceCode("rc = fwrite(fileid);\n");
        codeSegment.addSourceCode("if( rc ) then \ndo;\n");
        codeSegment.indent();
        codeSegment.genPutStatement(IBMWSQReaderCodegen_ErrorWritingToFile_Comment_put_notrans, "ERROR%QUOTE(:)");
        mqROOT.addExitLine();
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("\n");
        if (bGroupMessages) {
            codeSegment.addCommentLine(IBMWSQReaderCodegen_ReceiveUntilLast_Comment_put_notrans);
            codeSegment.addSourceCode("if( (etls_msgflags=&group_mask) AND ");
            codeSegment.addSourceCode(" (NOT(etls_msgflags=&last_group_mask)) )");
            codeSegment.addSourceCode(" then \ngoto etls_next;\n");
            codeSegment.addSourceCode("else \n");
            codeSegment.indent();
            mqROOT.addExitLine();
            codeSegment.unIndent();
            codeSegment.unIndent();
            codeSegment.addSourceCode("end;\n");
        } else {
            codeSegment.addCommentLine(IBMWSQReaderCodegen_RemoveMessageFromQueue_Comment_notrans);
            mqgmo4.generateAssignmentStatements();
            mqgmo4.generateFunctionCall();
            codeSegment.addSourceCode("if( etls_outofseq ) then \ndo;\n").indent();
            mqget3.generateAssignmentStatements();
            mqget3.generateFunctionCall();
            MQCLOSE mqclose2 = new MQCLOSE(codeSegment, false, hmUserInput);
            mqclose2.setObjectHandleVersion("2");
            mqclose2.generateSASCode();
            mqclose2 = null;
            codeSegment.addCommentLine(IBMWSQReaderCodegen_RereadPreviousMsg_Comment_notrans);
            mqgmo5.generateAssignmentStatements();
            mqgmo5.generateFunctionCall();
            codeSegment.addSourceCode("end;\n");
            codeSegment.addSourceCode("else \ndo;\n").indent();
            mqget4.generateAssignmentStatements();
            mqget4.generateFunctionCall();
            codeSegment.addCommentLine(IBMWSQReaderCodegen_BrowseNextMsg_Comment_notrans);
            mqgmo6.generateAssignmentStatements();
            mqgmo6.generateFunctionCall();
            codeSegment.unIndent();
            codeSegment.addSourceCode("end;\n").unIndent();
            codeSegment.addSourceCode("end;\n").unIndent();
            codeSegment.addSourceCode("end;\n").unIndent();
            codeSegment.addSourceCode("\n");
            codeSegment.addCommentLine(IBMWSQReaderCodegen_FinishedRetrieving_Comment_notrans);
            codeSegment.addSourceCode("\n");
            codeSegment.addCommentLine(IBMWSQReaderCodegen_ResetMsgDescriptor_Comment_notrans);
            codeSegment.addSourceCode("etls_s_msgid=\"\";\n");
            codeSegment.addSourceCode("etls_s_correlid=\"\";\n");
            mqmd4.generateAssignmentStatements();
            mqmd4.generateFunctionCall();
            codeSegment.addSourceCode("goto etls_recv;\n");
        }
        codeSegment.addSourceCode("etls_mqexit");
        codeSegment.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        codeSegment.addCommentLine(IBMWSQReaderCodegen_CloseFile_Comment_notrans);
        codeSegment.addSourceCode("rc = fclose(fileid);\n");
        codeSegment.addSourceCode("if (rc) then ");
        codeSegment.indent();
        codeSegment.genPutStatement(IBMWSQReaderCodegen_ErrorClosingFile_Comment_put_notrans, "ERROR%QUOTE(:)");
        codeSegment.unIndent();
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n").unIndent();
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    public static void readUserInput(ICodeSegment codeSegment, HashMap hmUserInput) {
        codeSegment.addSourceCode("length etls_ui_msgtype 8;\n");
        if (hmUserInput.containsKey(MQMD.MSGTYPE)) {
            codeSegment.addSourceCode("etls_ui_msgtype=");
            codeSegment.addSourceCode((String)hmUserInput.get(MQMD.MSGTYPE));
            codeSegment.addSourceCode(";\n");
        } else {
            codeSegment.addSourceCode("etls_ui_msgtype=8;\n");
        }
        codeSegment.addSourceCode("length etls_ui_correlid $48;\n");
        if (hmUserInput.containsKey(MQMD.CORRELID)) {
            codeSegment.addSourceCode("etls_ui_correlid=upcase('");
            codeSegment.addSourceCode((String)hmUserInput.get(MQMD.CORRELID));
            codeSegment.addSourceCode("');\n");
        } else {
            codeSegment.addSourceCode("etls_ui_correlid=\"\";\n");
        }
    }

    public static boolean isWriteToLog() {
        return true;
    }
}

