/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.miningresults.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IRelationalTable;
import com.sas.etl.models.impl.AbstractComplexPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.miningresults.IMiningResult;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.RelationalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.util.UsageVersion;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.Map;

public class BaseMiningResult
extends AbstractComplexPersistableObject
implements IMiningResult,
SimpleObject {
    private static final String SYSTEM_OPTIONS = "SystemOptions";
    private static final String DEVELOPER = "Developer";
    private static final String EMVERSION = "EMVersion";
    private String m_sKey;
    private String m_sModelKey;
    private String m_sProjectKey;
    private String m_sSourceCode;
    private String m_sSourceCodeType;
    private String m_sMiningFunction;
    private String m_sMiningAlgorithm;
    private String m_sDeveloper;
    private String m_sEMVersion;
    private String m_sSubject;
    private IRelationalTable m_oInputTable;
    private IRelationalTable m_oOutputTable;
    private UsageVersion m_usageVersion = new UsageVersion(1, 0);

    public BaseMiningResult(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getOMRType() {
        return "MiningResult";
    }

    public String getPublicType() {
        return "MiningResults";
    }

    @Override
    public boolean isPublicObject() {
        return true;
    }

    @Override
    public String getMetadataType() {
        return this.getOMRType();
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        TextStore code;
        AssociationList alRequiredOutputs;
        super.loadFromOMR(omr);
        MiningResult mdoMiningResult = (MiningResult)omr.acquireOMRObject(this);
        this.setDescription(mdoMiningResult.getDesc());
        this.setName(mdoMiningResult.getName());
        this.m_usageVersion = UsageVersion.decode((double)mdoMiningResult.getUsageVersion());
        if (mdoMiningResult.getModelKey() != null && mdoMiningResult.getModelKey().length() > 0) {
            this.setKey(mdoMiningResult.getModelKey());
        } else {
            AssociationList extList = mdoMiningResult.getExtensions();
            for (int x = 0; x < extList.size(); ++x) {
                Extension e = (Extension)extList.get(x);
                if (!e.getName().equalsIgnoreCase("Key")) continue;
                this.setKey(e.getValue());
            }
        }
        AssociationList alRequiredInputs = mdoMiningResult.getTransformationSources();
        if (!alRequiredInputs.isEmpty()) {
            RelationalTable inputTable = (RelationalTable)alRequiredInputs.get(0);
            IRelationalTable table = (IRelationalTable)omr.acquireObject((Root)inputTable);
            table.loadFromOMR(omr);
            this.setInputTable(table);
        }
        if (!(alRequiredOutputs = mdoMiningResult.getTransformationTargets()).isEmpty()) {
            RelationalTable outputTable = (RelationalTable)alRequiredOutputs.get(0);
            IRelationalTable oTable = (IRelationalTable)omr.acquireObject((Root)outputTable);
            oTable.loadFromOMR(omr);
            this.setOutputTable(oTable);
        }
        if ((code = (TextStore)mdoMiningResult.getSourceCode()) != null) {
            this.setSourceCode(code.getStoredText());
        }
        this.setSourceCodeType(mdoMiningResult.getSourceCodeType());
        this.setMiningFunction(mdoMiningResult.getMiningFunction());
        this.setMiningAlgorithm(mdoMiningResult.getMiningAlgorithm());
        this.setSubject(mdoMiningResult.getSubject());
        AssociationList extList = mdoMiningResult.getExtensions();
        for (int x = 0; x < extList.size(); ++x) {
            Extension e = (Extension)extList.get(x);
            if (e.getName().equalsIgnoreCase(DEVELOPER)) {
                this.setDeveloper(e.getValue());
            }
            if (e.getName().equalsIgnoreCase(EMVERSION)) {
                this.setEMVersion(e.getValue());
            }
            if (e.getName().equalsIgnoreCase("ModelUUID")) {
                this.setModelKey(e.getValue());
            }
            if (!e.getName().equalsIgnoreCase("ProjectUUID")) continue;
            this.setProjectKey(e.getValue());
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.saveToOMR(omr);
        if (this.m_oInputTable != null) {
            this.m_oInputTable.saveToOMR(omr);
        }
    }

    private void setOutputTable(IRelationalTable output) {
        this.m_oOutputTable = output;
    }

    private void setInputTable(IRelationalTable input) {
        this.m_oInputTable = input;
    }

    private void setKey(String sKey) {
        this.m_sKey = sKey;
    }

    private void setModelKey(String sModelKey) {
        this.m_sModelKey = sModelKey;
    }

    private void setProjectKey(String sProjectKey) {
        this.m_sProjectKey = sProjectKey;
    }

    private void setSourceCode(String sSourceCode) {
        this.m_sSourceCode = sSourceCode;
    }

    private void setSourceCodeType(String sSourceCodeType) {
        this.m_sSourceCodeType = sSourceCodeType;
    }

    private void setSubject(String sSubject) {
        this.m_sSubject = sSubject;
    }

    private void setEMVersion(String sEMVersion) {
        this.m_sEMVersion = sEMVersion;
    }

    private void setDeveloper(String sDeveloper) {
        this.m_sDeveloper = sDeveloper;
    }

    private void setMiningAlgorithm(String miningAlgorithm) {
        this.m_sMiningAlgorithm = miningAlgorithm;
    }

    private void setMiningFunction(String function) {
        this.m_sMiningFunction = function;
    }

    @Override
    public IRelationalTable getOutputTable() {
        return this.m_oOutputTable;
    }

    @Override
    public IRelationalTable getInputTable() {
        return this.m_oInputTable;
    }

    @Override
    public String getKey() {
        return this.m_sKey;
    }

    @Override
    public String getModelKey() {
        return this.m_sModelKey;
    }

    @Override
    public String getProjectKey() {
        return this.m_sProjectKey;
    }

    @Override
    public String getSourceCode() {
        return this.m_sSourceCode;
    }

    @Override
    public String getSourceCodeType() {
        return this.m_sSourceCodeType;
    }

    @Override
    public String getSubject() {
        return this.m_sSubject;
    }

    @Override
    public String getEMVersion() {
        return this.m_sEMVersion;
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IRelationalTable output;
        if (this.isNew()) {
            return;
        }
        IRelationalTable input = this.getInputTable();
        if (input != null) {
            input.deleteFromOMR(omr);
        }
        if ((output = this.getOutputTable()) != null) {
            output.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public String getDeveloper() {
        return this.m_sDeveloper;
    }

    @Override
    public String getMiningAlgorithm() {
        return this.m_sMiningAlgorithm;
    }

    @Override
    public String getMiningFunction() {
        return this.m_sMiningFunction;
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return this.m_usageVersion;
    }
}

