/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.hpf;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IDocument;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IRole;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ISortingTransform;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.common.ISorting;
import com.sas.etl.models.job.transforms.hpf.HPFCodegen2;
import com.sas.etl.models.job.transforms.hpf.HPFMapping;
import com.sas.etl.models.job.transforms.hpf.HPFPortDescriptionModel;
import com.sas.etl.models.job.transforms.hpf.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class HPFTransformModel
extends AbstractDataTransform
implements ISortingTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.hpf.HPF";
    private static final String TRANSFORMATION_ROLE = "HPF";
    private static final String ARM_DISPLAY_NAME = "Forecasting";
    private static final String DEFAULT_VALUE_YES = "YES";
    private static final String DEFAULT_VALUE_NO = "NO";
    private static String PROPERTY_SET_NAME_HPF = "HPFOptions";
    private static String PROPERTY_SET_NAME_ID = "IDOptions";
    private static String PROPERTY_SET_NAME_FORECAST = "FORECASTOptions";
    private static String PROPERTY_SET_NAME_PRINT = "PRINTOptions";
    private static String PROPERTY_SET_NAME_PLOT = "PLOTOptions";
    public static String PROPERTY_NAME_SORTNAMES = "sortnames";
    public static String PROPERTY_NAME_LEAD = "lead";
    public static String PROPERTY_NAME_BACK = "back";
    public static String PROPERTY_NAME_SEASONALITY = "seasonality";
    public static String PROPERTY_NAME_PRINTDETAILS = "printdetails";
    public static String PROPERTY_NAME_USEOUTPUTWINDOW = "useoutputwindow";
    public static String PROPERTY_NAME_ACCUMULATE = "accumulate";
    public static String PROPERTY_NAME_NOTSORTED = "notsorted";
    public static String PROPERTY_NAME_INTERVAL = "interval";
    public static String PROPERTY_NAME_SETMISSING = "setmissing";
    public static String PROPERTY_NAME_ZEROMISS = "zeromiss";
    public static String PROPERTY_NAME_START = "start";
    public static String PROPERTY_NAME_END = "end";
    public static String PROPERTY_NAME_INTERVALFORMAT = "intervalformat";
    public static String PROPERTY_NAME_ALPHA = "alpha";
    public static String PROPERTY_NAME_MODEL = "model";
    public static String PROPERTY_NAME_HOLDOUT = "holdout";
    public static String PROPERTY_NAME_HOLDOUTPCT = "holdoutpct";
    public static String PROPERTY_NAME_MEDIAN = "median";
    public static String PROPERTY_NAME_REPLACEMISSING = "replacemissing";
    public static String PROPERTY_NAME_USE = "use";
    public static String PROPERTY_NAME_SELECT = "select";
    public static String PROPERTY_NAME_TRANSFORM = "transform";
    public static String PROPERTY_NAME_INTERMITTENT = "intermittent";
    public static String ID_VARIABLE_PROPERTY_NAME = "IDVARIABLE";
    public static String FORECAST_VARIABLE_PROPERTY_NAME = "FORECASTVARIABLES";
    public static final String LEAD_CHANGED = "HPFTransform:LeadChanged";
    public static final String BACK_CHANGED = "HPFTransform:BackChanged";
    public static final String SEASONALITY_CHANGED = "HPFTransform:SeasonalityChanged";
    public static final String SORTED_VARIABLES_CHANGED = "HPFTransform:SortedVariablesChanged";
    public static final String GREATER_DETAILS_CHANGED = "HPFTransform:GreaterDetailsChanged";
    public static final String OUTPUT_WINDOW_CHANGED = "HPFTransform:OutputWindowChanged";
    public static final String ID_COLUMN_CHANGED = "HPFTransform:IdColumnChanged";
    public static final String NOT_SORTED_CHANGED = "HPFTransform:NotSortedChanged";
    public static final String INTERVAL_CHANGED = "HPFTransform:IntervalChanged";
    public static final String ACCUMULATE_CHANGED = "HPFTransform:AccumulateChanged";
    public static final String SET_MISSING_CHANGED = "HPFTransform:SetMissingChanged";
    public static final String ZERO_MISSING_CHANGED = "HPFTransform:ZeroMissingChanged";
    public static final String START_DATE_CHANGED = "HPFTransform:StartDateChanged";
    public static final String END_DATE_CHANGED = "HPFTransform:EndDateChanged";
    public static final String INTERVAL_FORMAT_CHANGED = "HPFTransform:IntervalFormatChanged";
    public static final String USE_CHANGED = "HPFTransform:UseChanged";
    public static final String MODEL_OPTION_CHANGED = "HPFTransform:ModelOptionChanged";
    public static final String MODEL_SELECTION_CHANGED = "HPFTransform:ModelSelectionChanged";
    public static final String TRANSFORM_CHANGED = "HPFTransform:TransformChanged";
    public static final String REPLACE_MISSING_CHANGED = "HPFTransform:ReplaceMissingChanged";
    public static final String ESTIMATE_MEDIAN_CHANGED = "HPFTransform:EstimateMedianChanged";
    public static final String ALPHA_CHANGED = "HPFTransform:AlphaChanged";
    public static final String HOLDOUT_PERCENT_CHANGED = "HPFTransform:HoldoutPercentChanged";
    public static final String INTERMITTENT_CHANGED = "HPFTransform:IntermittentChanged";
    public static final String HOLDOUT_CHANGED = "HPFTransform:HoldoutChanged";
    public static final String PRINTOPTION_ADDED = "HPFTransform:PrintOptionAdded";
    public static final String PRINTOPTION_REMOVED = "HPFTransform:PrintOptionRemoved";
    public static final String PLOTOPTION_ADDED = "HPFTransform:PlotOptionAdded";
    public static final String PLOTOPTION_REMOVED = "HPFTransform:PlotOptionRemoved";
    public static final String FORECAST_COLUMN_ADDED = "HPFTransform:ForecastColumnAdded";
    public static final String FORECAST_COLUMN_REMOVED = "HPFTransform:ForecastColumnRemoved";
    public static final String HPFDOCUMENT_CHANGED = "HPFTransform:HPFDocumentChanged";
    public static final String PRINTOPTION_STATES = "STATES";
    public static final String PRINTOPTION_FORECASTS = "FORECASTS";
    public static final String PRINTOPTION_ESTIMATES = "ESTIMATES";
    public static final String PRINTOPTION_PERFORMANCE = "PERFORMANCE";
    public static final String PRINTOPTION_PERFORMANCEOVERALL = "PERFORMANCEOVERALL";
    public static final String PRINTOPTION_PERFORMANCESUMMARY = "PERFORMANCESUMMARY";
    public static final String PRINTOPTION_SEASONS = "SEASONS";
    public static final String PRINTOPTION_STATISTICS = "STATISTICS";
    public static final String PRINTOPTION_SUMMARY = "SUMMARY";
    public static final String PRINTOPTION_TRENDS = "TRENDS";
    public static final String[] PRINTOPTIONS = new String[]{"STATES", "FORECASTS", "ESTIMATES", "PERFORMANCE", "PERFORMANCEOVERALL", "PERFORMANCESUMMARY", "SEASONS", "STATISTICS", "SUMMARY", "TRENDS"};
    public static final String PLOTOPTION_FORECASTS = "FORECASTS";
    public static final String PLOTOPTION_FORECASTSONLY = "FORECASTSONLY";
    public static final String PLOTOPTION_MODELFORECASTS = "MODELFORECASTS";
    public static final String PLOTOPTION_MODELS = "MODELS";
    public static final String PLOTOPTION_ACF = "ACF";
    public static final String PLOTOPTION_IACF = "IACF";
    public static final String PLOTOPTION_PACF = "PACF";
    public static final String PLOTOPTION_ERRORS = "ERRORS";
    public static final String PLOTOPTION_LEVELS = "LEVELS";
    public static final String PLOTOPTION_SEASONS = "SEASONS";
    public static final String PLOTOPTION_TRENDS = "TRENDS";
    public static final String PLOTOPTION_WN = "WN";
    public static final String[] PLOTOPTIONS = new String[]{"FORECASTS", "FORECASTSONLY", "MODELFORECASTS", "MODELS", "ACF", "IACF", "PACF", "ERRORS", "LEVELS", "SEASONS", "TRENDS", "WN"};
    public static final String IDOPTION_INTERVAL_DAY = "DAY";
    public static final String IDOPTION_INTERVAL_HOUR = "HOUR";
    public static final String IDOPTION_INTERVAL_MINUTE = "MINUTE";
    public static final String IDOPTION_INTERVAL_MONTH = "MONTH";
    public static final String IDOPTION_INTERVAL_QTR = "QTR";
    public static final String IDOPTION_INTERVAL_SECOND = "SECOND";
    public static final String IDOPTION_INTERVAL_SEMIMONTH = "SEMIMONTH";
    public static final String IDOPTION_INTERVAL_SEMIYEAR = "SEMIYEAR";
    public static final String IDOPTION_INTERVAL_TENDAY = "TENDAY";
    public static final String IDOPTION_INTERVAL_WEEK = "WEEK";
    public static final String IDOPTION_INTERVAL_WEEKDAY = "WEEKDAY";
    public static final String IDOPTION_INTERVAL_YEAR = "YEAR";
    public static final String[] IDOPTION_INTERVALS = new String[]{"DAY", "HOUR", "MINUTE", "MONTH", "QTR", "SECOND", "SEMIMONTH", "SEMIYEAR", "TENDAY", "WEEK", "WEEKDAY", "YEAR"};
    public static final String IDOPTION_ACCUMULATE_AVERAGE = "AVERAGE";
    public static final String IDOPTION_ACCUMULATE_CSS = "CSS";
    public static final String IDOPTION_ACCUMULATE_FIRST = "FIRST";
    public static final String IDOPTION_ACCUMULATE_LAST = "LAST";
    public static final String IDOPTION_ACCUMULATE_MAXIMUM = "MAXIMUM";
    public static final String IDOPTION_ACCUMULATE_MEDIAN = "MEDIAN";
    public static final String IDOPTION_ACCUMULATE_MINIMUM = "MINIMUM";
    public static final String IDOPTION_ACCUMULATE_NONE = "NONE";
    public static final String IDOPTION_ACCUMULATE_NMISS = "NMISS";
    public static final String IDOPTION_ACCUMULATE_N = "N";
    public static final String IDOPTION_ACCUMULATE_NOBS = "NOBS";
    public static final String IDOPTION_ACCUMULATE_STDDEV = "STDDEV";
    public static final String IDOPTION_ACCUMULATE_TOTAL = "TOTAL";
    public static final String IDOPTION_ACCUMULATE_USS = "USS";
    public static final String[] IDOPTION_ACCUMULATES = new String[]{"AVERAGE", "CSS", "FIRST", "LAST", "MAXIMUM", "MEDIAN", "MINIMUM", "NONE", "NMISS", "N", "NOBS", "STDDEV", "TOTAL", "USS"};
    public static final String IDOPTION_SETMISSING_AVERAGE = "AVERAGE";
    public static final String IDOPTION_SETMISSING_FIRST = "FIRST";
    public static final String IDOPTION_SETMISSING_LAST = "LAST";
    public static final String IDOPTION_SETMISSING_MAXIMUM = "MAXIMUM";
    public static final String IDOPTION_SETMISSING_MEDIAN = "MEDIAN";
    public static final String IDOPTION_SETMISSING_MINIMUM = "MINIMUM";
    public static final String IDOPTION_SETMISSING_MISSING = "MISSING";
    public static final String IDOPTION_SETMISSING_NEXT = "NEXT";
    public static final String IDOPTION_SETMISSING_PREVIOUS = "PREVIOUS";
    public static final String[] IDOPTION_SETMISSINGS = new String[]{"AVERAGE", "FIRST", "LAST", "MAXIMUM", "MEDIAN", "MINIMUM", "MISSING", "NEXT", "PREVIOUS"};
    public static final String IDOPTION_ZEROMISSING_NONE = "NONE";
    public static final String IDOPTION_ZEROMISSING_LEFT = "LEFT";
    public static final String IDOPTION_ZEROMISSING_BOTH = "BOTH";
    public static final String IDOPTION_ZEROMISSING_RIGHT = "RIGHT";
    public static final String[] IDOPTION_ZEROMISSINGS = new String[]{"NONE", "LEFT", "BOTH", "RIGHT"};
    public static final String FORECASTOPTION_USE_LOWER = "LOWER";
    public static final String FORECASTOPTION_USE_PREDICT = "PREDICT";
    public static final String FORECASTOPTION_USE_UPPER = "UPPER";
    public static final String[] FORECASTOPTION_USES = new String[]{"LOWER", "PREDICT", "UPPER"};
    public static final String FORECASTOPTION_MODEL_BESTALL = "BESTALL";
    public static final String FORECASTOPTION_MODEL_BESTN = "BESTN";
    public static final String FORECASTOPTION_MODEL_BESTS = "BESTS";
    public static final String FORECASTOPTION_MODEL_BEST = "BEST";
    public static final String FORECASTOPTION_MODEL_DAMPTREND = "DAMPTREND";
    public static final String FORECASTOPTION_MODEL_DOUBLE = "DOUBLE";
    public static final String FORECASTOPTION_MODEL_IDM = "IDM";
    public static final String FORECASTOPTION_MODEL_LINEAR = "LINEAR";
    public static final String FORECASTOPTION_MODEL_NONE = "NONE";
    public static final String FORECASTOPTION_MODEL_SEASONAL = "SEASONAL";
    public static final String FORECASTOPTION_MODEL_SIMPLE = "SIMPLE";
    public static final String FORECASTOPTION_MODEL_ADDWINTERS = "ADDWINTERS";
    public static final String FORECASTOPTION_MODEL_WINTERS = "WINTERS";
    public static final String[] FORECASTOPTION_MODELS = new String[]{"BESTALL", "BESTN", "BESTS", "BEST", "DAMPTREND", "DOUBLE", "IDM", "LINEAR", "NONE", "SEASONAL", "SIMPLE", "ADDWINTERS", "WINTERS"};
    public static final String FORECASTOPTION_MODELSELECTION_ADJRSQ = "ADJRSQ";
    public static final String FORECASTOPTION_MODELSELECTION_AIC = "AIC";
    public static final String FORECASTOPTION_MODELSELECTION_AADJRSQ = "AADJRSQ";
    public static final String FORECASTOPTION_MODELSELECTION_APC = "APC";
    public static final String FORECASTOPTION_MODELSELECTION_GMAPE = "GMAPE";
    public static final String FORECASTOPTION_MODELSELECTION_GMAPPE = "GMAPPE";
    public static final String FORECASTOPTION_MODELSELECTION_GMRAE = "GMRAE";
    public static final String FORECASTOPTION_MODELSELECTION_GMASPE = "GMASPE";
    public static final String FORECASTOPTION_MODELSELECTION_MAXERR = "MAXERR";
    public static final String FORECASTOPTION_MODELSELECTION_MAXPE = "MAXPE";
    public static final String FORECASTOPTION_MODELSELECTION_MAXPPE = "MAXPPE";
    public static final String FORECASTOPTION_MODELSELECTION_MAXRE = "MAXRE";
    public static final String FORECASTOPTION_MODELSELECTION_MAXSPE = "MAXSPE";
    public static final String FORECASTOPTION_MODELSELECTION_MAE = "MAE";
    public static final String FORECASTOPTION_MODELSELECTION_MAPE = "MAPE";
    public static final String FORECASTOPTION_MODELSELECTION_ME = "ME";
    public static final String FORECASTOPTION_MODELSELECTION_MPE = "MPE";
    public static final String FORECASTOPTION_MODELSELECTION_MSPPE = "MSPPE";
    public static final String FORECASTOPTION_MODELSELECTION_MRAE = "MRAE";
    public static final String FORECASTOPTION_MODELSELECTION_MRE = "MRE";
    public static final String FORECASTOPTION_MODELSELECTION_MSE = "MSE";
    public static final String FORECASTOPTION_MODELSELECTION_MSPE = "MSPE";
    public static final String FORECASTOPTION_MODELSELECTION_MDAPE = "MDAPE";
    public static final String FORECASTOPTION_MODELSELECTION_MDAPPE = "MDAPPE";
    public static final String FORECASTOPTION_MODELSELECTION_MDRAE = "MDRAE";
    public static final String FORECASTOPTION_MODELSELECTION_MDASPE = "MDASPE";
    public static final String FORECASTOPTION_MODELSELECTION_MINERR = "MINERR";
    public static final String FORECASTOPTION_MODELSELECTION_MINPE = "MINPE";
    public static final String FORECASTOPTION_MODELSELECTION_MINPPE = "MINPPE";
    public static final String FORECASTOPTION_MODELSELECTION_MINRE = "MINRE";
    public static final String FORECASTOPTION_MODELSELECTION_MINSPE = "MINSPE";
    public static final String FORECASTOPTION_MODELSELECTION_RSQUARE = "RSQUARE";
    public static final String FORECASTOPTION_MODELSELECTION_RWRSQ = "RWRSQ";
    public static final String FORECASTOPTION_MODELSELECTION_RMSE = "RMSE";
    public static final String FORECASTOPTION_MODELSELECTION_SBC = "SBC";
    public static final String FORECASTOPTION_MODELSELECTION_SSE = "SSE";
    public static final String FORECASTOPTION_MODELSELECTION_SMAPE = "SMAPE";
    public static final String FORECASTOPTION_MODELSELECTION_MAPPE = "MAPPE";
    public static final String FORECASTOPTION_MODELSELECTION_UMSE = "UMSE";
    public static final String FORECASTOPTION_MODELSELECTION_URMSE = "URMSE";
    public static final String[] FORECASTOPTION_MODELSELECTIONS = new String[]{"ADJRSQ", "AIC", "AADJRSQ", "APC", "GMAPE", "GMAPPE", "GMRAE", "GMASPE", "MAXERR", "MAXPE", "MAXPPE", "MAXRE", "MAXSPE", "MAE", "MAPE", "ME", "MPE", "MSPPE", "MRAE", "MRE", "MSE", "MSPE", "MDAPE", "MDAPPE", "MDRAE", "MDASPE", "MINERR", "MINPE", "MINPPE", "MINRE", "MINSPE", "RSQUARE", "RWRSQ", "RMSE", "SBC", "SSE", "SMAPE", "MAPPE", "UMSE", "URMSE"};
    public static final String FORECASTOPTION_TRANSFORM_AUTO = "AUTO";
    public static final String FORECASTOPTION_TRANSFORM_BOXCOXN = "BOXCOX(n)";
    public static final String FORECASTOPTION_TRANSFORM_LOG = "LOG";
    public static final String FORECASTOPTION_TRANSFORM_LOGISTIC = "LOGISTIC";
    public static final String FORECASTOPTION_TRANSFORM_NONE = "NONE";
    public static final String FORECASTOPTION_TRANSFORM_SQRT = "SQRT";
    public static final String[] FORECASTOPTION_TRANSFORMS = new String[]{"AUTO", "BOXCOX(n)", "LOG", "LOGISTIC", "NONE", "SQRT"};
    public static final String TARGET_TABLE_OUT = "OUT";
    public static final String TARGET_TABLE_OUTEST = "OUTEST";
    public static final String TARGET_TABLE_OUTFOR = "OUTFOR";
    public static final String TARGET_TABLE_OUTSEASON = "OUTSEASON";
    public static final String TARGET_TABLE_OUTSTAT = "OUTSTAT";
    public static final String TARGET_TABLE_OUTSUM = "OUTSUM";
    public static final String TARGET_TABLE_OUTTREND = "OUTTREND";
    public static final String[] TARGET_TABLE_ROLES = new String[]{"OUT", "OUTEST", "OUTFOR", "OUTSEASON", "OUTSTAT", "OUTSUM", "OUTTREND"};
    public static final String TARGET_HPFDOCUMENT_TEXTROLE = "HPFOUTPUT";
    public static final String TARGET_HPFDOCUMENT_TEXTTYPE = "HTML";
    public static final String TARGET_HPFDOCUMENT_URITYPE = "File";
    public static final int LEAD_DEFAULT = 12;
    public static final int BACK_DEFAULT = 0;
    public static final String INTERVAL_DEFAULT = "";
    public static final String ACCUMULATE_DEFAULT = "NONE";
    public static final String SETMISSING_DEFAULT = "MISSING";
    public static final String ZEROMISS_DEFAULT = "NONE";
    public static final double ALPHA_DEFAULT = 0.05;
    public static final String USE_DEFAULT = "PREDICT";
    public static final String MODEL_DEFAULT = "BEST";
    public static final String SELECT_DEFAULT = "RMSE";
    public static final int HOLDOUT_DEFAULT = 0;
    public static final double HOLDOUTPCT_DEFAULT = 100.0;
    public static final double INTERMITTENT_DEFAULT = 1.25;
    public static final String TRANSFORM_DEFAULT = "NONE";
    public static final boolean REPLACEMISSING_DEFAULT = false;
    public static final boolean MEDIAN_DEFAULT = false;
    public static final boolean SORTNAMES_DEFAULT = false;
    public static final String SEASONALITY_DEFAULT = "";
    public static final boolean NOTSORTED_DEFAULT = false;
    public static final boolean PRINTDETAILS_DEFAULT = false;
    public static final boolean USEOUTPUTWINDOW_DEFAULT = false;
    public static final String START_DEFAULT = "";
    public static final String END_DEFAULT = "";
    public static final String INTERVALFORMAT_DEFAULT = "";
    public static final String[] COLUMNS_OUT_NAMES = new String[]{"TIME"};
    public static final int[] COLUMNS_OUT_TYPES = new int[]{1};
    public static final String[] COLUMNS_OUTEST_NAMES = new String[]{"_NAME_", "_TRANSFORM_", "_MODEL_", "_PARM_", "_EST_", "_STDERR_", "_TVALUE_", "_PVALUE_"};
    public static final int[] COLUMNS_OUTEST_TYPES = new int[]{0, 0, 0, 0, 1, 1, 1, 1};
    public static final String[] COLUMNS_OUTFOR_NAMES = new String[]{"_NAME_", "ACTUAL", "PREDICT", "LOWER", "UPPER", "ERROR", "STD"};
    public static final int[] COLUMNS_OUTFOR_TYPES = new int[]{0, 1, 1, 1, 1, 1, 1};
    public static final String[] COLUMNS_OUTSEASON_NAMES = new String[]{"_NAME_", "_SEASON_", "NOBS", "N", "NMISS", "MIN", "MAX", "RANGE", "SUM", "MEAN", "STDDEV", "CSS", "USS", "MEDIAN"};
    public static final int[] COLUMNS_OUTSEASON_TYPES = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    public static final String[] COLUMNS_OUTSTAT_NAMES = new String[]{"_NAME_", "_REGION_", "DFE", "N", "NOBS", "NMISSA", "NMISSP", "NPARMS", "TSS", "SST", "SSE", "MSE", "UMSE", "RMSE", "URMSE", "MAPE", "MAE", "RSQUARE", "ADJRSQ", "AADJRSQ", "RWRSQ", "AIC", "SBC", "APC", "MAXERR", "MINERR", "MINPE", "MAXPE", "ME", "MPE"};
    public static final int[] COLUMNS_OUTSTAT_TYPES = new int[]{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    public static final String[] COLUMNS_OUTSUM_NAMES = new String[]{"_NAME_", "_STATUS_", "NOBS", "N", "NMISS", "MIN", "MAX", "MEAN", "STDDEV", "PREDICT", "STD", "LOWER", "UPPER"};
    public static final int[] COLUMNS_OUTSUM_TYPES = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    public static final String COLUMNS_OUTSUM_LEAD_NAME = "_LEAD";
    public static final int COLUMNS_OUTSUM_LEAD_TYPE = 1;
    public static final String[] COLUMNS_OUTTREND_NAMES = new String[]{"_NAME_", "_SEASON_", "NOBS", "N", "NMISS", "MIN", "MAX", "RANGE", "SUM", "MEAN", "STDDEV", "CSS", "USS", "MEDIAN"};
    public static final int[] COLUMNS_OUTTREND_TYPES = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    public static final int FORECASTS_OF_VARIABLES_PORT = 0;
    public static final int MODEL_PARAMETER_ESTIMATES_PORT = 1;
    public static final int FORECAST_TIME_SERIES_COMPONENTS_PORT = 2;
    public static final int SEASONAL_STATISTICS_PORT = 3;
    public static final int STATISTICS_OF_FIT_PORT = 4;
    public static final int SUMMARY_STATISTICS_PORT = 5;
    public static final int TREND_STATISTICS_PORT = 6;
    public static final int DOCUMENT_PORT = 7;
    public static final String MAPPING_OUT = "newmap";
    public static final String MAPPING_OUTEST = "OUTEST";
    public static final String MAPPING_OUTFOR = "OUTFOR";
    public static final String MAPPING_OUTSEASON = "OUTSEASON";
    public static final String MAPPING_OUTSTAT = "OUTSTAT";
    public static final String MAPPING_OUTSUM = "OUTSUM";
    public static final String MAPPING_OUTTREND = "OUTTREND";
    private int m_iLead;
    private int m_iBack;
    private String m_sSeasonality;
    private boolean m_bSortedVariables;
    private boolean m_bGreaterDetails;
    private boolean m_bOutputWindow;
    private List m_lSelectedPrintOpts = new ArrayList();
    private List m_lSelectedPlotOpts = new ArrayList();
    private ISorting m_order;
    private IColumn m_oIdColumn;
    private boolean m_bNotSorted;
    private String m_sInterval;
    private String m_sAccumulate;
    private String m_sSetMissing;
    private String m_sZeroMissing;
    private String m_sStartDate;
    private String m_sEndDate;
    private String m_sIntervalFormat;
    private List m_lForecastColumns;
    private String m_sUse;
    private String m_sModel;
    private String m_sModelSelection;
    private String m_sTransform;
    private boolean m_bReplaceMissing;
    private boolean m_bEstimateMedian;
    private double m_dAlpha;
    private double m_dHoldoutPercent;
    private double m_dIntermittent;
    private int m_iHoldout;
    private List m_lOutputPortDescriptions;

    public HPFTransformModel(String sID, IModel mdl) {
        super(sID, mdl);
        if (this.isNew()) {
            this.m_order = this.getModel().getObjectFactory().createNewSorting(this.getID());
            this.m_order.addNotifyListener(this);
        }
        this.m_iLead = 12;
        this.m_iBack = 0;
        this.m_sSeasonality = "";
        this.m_bSortedVariables = false;
        this.m_bGreaterDetails = false;
        this.m_bOutputWindow = false;
        this.m_bNotSorted = false;
        this.m_sInterval = "";
        this.m_sAccumulate = "NONE";
        this.m_sSetMissing = "MISSING";
        this.m_sZeroMissing = "NONE";
        this.m_sStartDate = "";
        this.m_sEndDate = "";
        this.m_sIntervalFormat = "";
        this.m_sUse = "PREDICT";
        this.m_sModel = "BEST";
        this.m_sModelSelection = "RMSE";
        this.m_sTransform = "NONE";
        this.m_bReplaceMissing = false;
        this.m_bEstimateMedian = false;
        this.m_dAlpha = 0.05;
        this.m_dHoldoutPercent = 100.0;
        this.m_dIntermittent = 1.25;
        this.m_iHoldout = 0;
        this.m_lForecastColumns = new ModelList(this, new String[]{FORECAST_COLUMN_ADDED, FORECAST_COLUMN_REMOVED}, 0, IColumn.class);
        this.m_lOutputPortDescriptions = new ArrayList();
        this.addDefaultOutputPorts();
        this.setIncludedInMapping(false);
        this.setIncludedInPropagation(false);
    }

    private void addDefaultOutputPorts() {
        HPFPortDescriptionModel portDescription = new HPFPortDescriptionModel();
        portDescription.setName(RB.getStringResource("HPFTransformModel.OutputPort.ForecastsOfVariables.Name.txt"));
        portDescription.setTooltipText(RB.getStringResource("HPFTransformModel.OutputPort.ForecastsOfVariables.Tooltip.txt"));
        this.m_lOutputPortDescriptions.add(portDescription);
        portDescription = new HPFPortDescriptionModel();
        portDescription.setName(RB.getStringResource("HPFTransformModel.OutputPort.ModelParameterEstimates.Name.txt"));
        portDescription.setTooltipText(RB.getStringResource("HPFTransformModel.OutputPort.ModelParameterEstimates.Tooltip.txt"));
        this.m_lOutputPortDescriptions.add(portDescription);
        portDescription = new HPFPortDescriptionModel();
        portDescription.setName(RB.getStringResource("HPFTransformModel.OutputPort.ForecastTimeSeriesComponents.Name.txt"));
        portDescription.setTooltipText(RB.getStringResource("HPFTransformModel.OutputPort.ForecastTimeSeriesComponents.Tooltip.txt"));
        this.m_lOutputPortDescriptions.add(portDescription);
        portDescription = new HPFPortDescriptionModel();
        portDescription.setName(RB.getStringResource("HPFTransformModel.OutputPort.SeasonalStatistics.Name.txt"));
        portDescription.setTooltipText(RB.getStringResource("HPFTransformModel.OutputPort.SeasonalStatistics.Tooltip.txt"));
        this.m_lOutputPortDescriptions.add(portDescription);
        portDescription = new HPFPortDescriptionModel();
        portDescription.setName(RB.getStringResource("HPFTransformModel.OutputPort.StatisticsOfFit.Name.txt"));
        portDescription.setTooltipText(RB.getStringResource("HPFTransformModel.OutputPort.StatisticsOfFit.Tooltip.txt"));
        this.m_lOutputPortDescriptions.add(portDescription);
        portDescription = new HPFPortDescriptionModel();
        portDescription.setName(RB.getStringResource("HPFTransformModel.OutputPort.SummaryStatistics.Name.txt"));
        portDescription.setTooltipText(RB.getStringResource("HPFTransformModel.OutputPort.SummaryStatistics.Tooltip.txt"));
        this.m_lOutputPortDescriptions.add(portDescription);
        portDescription = new HPFPortDescriptionModel();
        portDescription.setName(RB.getStringResource("HPFTransformModel.OutputPort.TrendStatistics.Name.txt"));
        portDescription.setTooltipText(RB.getStringResource("HPFTransformModel.OutputPort.TrendStatistics.Tooltip.txt"));
        this.m_lOutputPortDescriptions.add(portDescription);
        portDescription = new HPFPortDescriptionModel();
        portDescription.setName(RB.getStringResource("HPFTransformModel.OutputPort.Document.Name.txt"));
        portDescription.setTooltipText(RB.getStringResource("HPFTransformModel.OutputPort.Document.Tooltip.txt"));
        this.m_lOutputPortDescriptions.add(portDescription);
    }

    public HPFPortDescriptionModel[] getOutputPortDescriptions() {
        return this.m_lOutputPortDescriptions.toArray(new HPFPortDescriptionModel[this.m_lOutputPortDescriptions.size()]);
    }

    public List getOutputPortDescriptionList() {
        return this.m_lOutputPortDescriptions;
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("HPFTransformModel.TransformationName.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getClassifierMapType() {
        return "Select";
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("HPFTransformModel.DisplayType.txt");
    }

    @Override
    protected int getMaximumDataTargetCount() {
        return 8;
    }

    @Override
    protected boolean doesNoTargetsMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_order != null && this.m_order.isChanged();
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() instanceof IColumn) {
            IColumn col = (IColumn)ev.getSource();
            if (col.equals(this.getIdColumn())) {
                if (ev.getType() == 0) {
                    this.setIdColumn(null);
                }
                this.updateForecastOfVariablesColumns();
                this.updateForecastTimeSeriesColumns();
                this.updateTrendStatisticsColumns();
            } else if (this.getForecastColumns().contains(col)) {
                if (ev.getType() == 0) {
                    this.getForecastColumns().remove(col);
                }
                this.updateForecastOfVariablesColumns();
            } else if (this.m_order.containsColumn(col)) {
                if (ev.getType() == 0) {
                    this.m_order.removeSortColumn(this.m_order.getSortColumnContainingColumn(col));
                }
                this.updateForecastOfVariablesColumns();
                this.updateModelParameterEstimateColumns();
                this.updateForecastTimeSeriesColumns();
                this.updateSeasonalStatisticsColumns();
                this.updateStatisticsOfFitColumns();
                this.updateSummaryStatisticsColumns();
                this.updateTrendStatisticsColumns();
            }
        } else {
            super.notify(ev);
        }
    }

    @Override
    public IWorkTable addNewWorkTable() {
        throw new UnsupportedOperationException("Use addTargetTable(String) instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataTarget(IDataObject target) {
        if (target instanceof IPhysicalTable) {
            IPhysicalTable table = (IPhysicalTable)target;
            String sRole = this.getHPFRole(table);
            this.setTargetTableInPortDescription(sRole, null);
            super.removeDataTarget(target);
        } else if (target instanceof IDocument && target.equals(this.getHPFDocument())) {
            try {
                this.getModel().startCompoundUndoable();
                this.setHPFDocumentInPortDescription(null);
                super.removeDataTarget(target);
                this.clearPrintOptions();
                this.clearPlotOptions();
                this.getDocumentsList().remove((IDocument)target);
            }
            finally {
                this.getModel().endCompoundUndoable();
            }
        }
    }

    @Override
    public void addDataTarget(int iTarget, IDataObject target) {
        if (target instanceof IPhysicalTable) {
            IPhysicalTable table = (IPhysicalTable)target;
            String sRole = this.getHPFRole(table);
            if (sRole == null) {
                throw new IllegalArgumentException("Data target table does not have valid HPF role");
            }
            super.addDataTarget(iTarget, target);
            this.setTargetTableInPortDescription(sRole, table);
        } else if (target instanceof IDocument) {
            if (this.getJob() != null && this.getJob().getDataObjectsList() != null && !this.getJob().getDataObjectsList().contains(target)) {
                this.getJob().getDataObjectsList().add(target);
            }
            super.addDataTarget(0, target);
            this.setHPFDocumentInPortDescription((IDocument)target);
        } else {
            throw new IllegalArgumentException("Data targets must be tables or documents");
        }
    }

    private void setTargetTableInPortDescription(String tableRole, IPhysicalTable table) {
        int iTableNum = -1;
        if (tableRole.equals(TARGET_TABLE_OUT)) {
            iTableNum = 0;
        } else if (tableRole.equals("OUTEST")) {
            iTableNum = 1;
        } else if (tableRole.equals("OUTFOR")) {
            iTableNum = 2;
        } else if (tableRole.equals("OUTSEASON")) {
            iTableNum = 3;
        } else if (tableRole.equals("OUTSTAT")) {
            iTableNum = 4;
        } else if (tableRole.equals("OUTSUM")) {
            iTableNum = 5;
        } else if (tableRole.equals("OUTTREND")) {
            iTableNum = 6;
        }
        if (iTableNum == -1) {
            return;
        }
        HPFPortDescriptionModel portDesc = (HPFPortDescriptionModel)this.m_lOutputPortDescriptions.get(iTableNum);
        portDesc.setObject(table);
    }

    public void addTargetTable(String tableRole) {
        if (!this.isValid(tableRole, TARGET_TABLE_ROLES)) {
            throw new IllegalArgumentException("Not a valid HPF role");
        }
        if (tableRole.equals(TARGET_TABLE_OUT)) {
            this.createForecastsOfVariablesTable();
        } else if (tableRole.equals("OUTEST")) {
            this.createModelParameterEstimatesTable();
        } else if (tableRole.equals("OUTFOR")) {
            this.createForecastOfTimeSeriesComponentsTable();
        } else if (tableRole.equals("OUTSEASON")) {
            this.createSeasonalStatisticsTable();
        } else if (tableRole.equals("OUTSTAT")) {
            this.createStatisticsOfFitTable();
        } else if (tableRole.equals("OUTSUM")) {
            this.createSummaryStatisticsTable();
        } else if (tableRole.equals("OUTTREND")) {
            this.createTrendStatisticsTable();
        }
    }

    public void removeTargetTable(String tableName) {
        IPhysicalTable table = this.getOutputTable(tableName);
        this.removeDataTarget(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPhysicalTable createForecastsOfVariablesTable() {
        if (this.getForecastsOfVariablesTable() != null) {
            throw new IllegalArgumentException("Forecast of Variables table already exists");
        }
        try {
            this.startCompoundUndoable();
            IWorkTable table = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            table.setName(RB.getStringResource("HPFTransformModel.ForecastsOfVariables.TableName.txt"));
            IRole role = this.getModel().getObjectFactory().createNewRole(this.getID());
            role.setName(TARGET_TABLE_OUT);
            role.setContext(TARGET_TABLE_OUT);
            role.setObjectRole(TARGET_TABLE_OUT);
            table.addRole(role);
            this.addDataTarget(table);
            this.updateForecastOfVariablesColumns();
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getForecastsOfVariablesTable() {
        return this.getOutputTable(TARGET_TABLE_OUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPhysicalTable createModelParameterEstimatesTable() {
        if (this.getModelParameterEstimatesTable() != null) {
            throw new IllegalArgumentException("Model Paramter Estimates table already exists");
        }
        try {
            this.startCompoundUndoable();
            IWorkTable table = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            table.setName(RB.getStringResource("HPFTransformModel.ModelParameterEstimates.TableName.txt"));
            IRole role = this.getModel().getObjectFactory().createNewRole(this.getID());
            role.setName("OUTEST");
            role.setContext("OUTEST");
            role.setObjectRole("OUTEST");
            table.addRole(role);
            for (int iCol = 0; iCol < COLUMNS_OUTEST_NAMES.length; ++iCol) {
                table.addColumn(this.createColumn(COLUMNS_OUTEST_NAMES[iCol], "OUTEST", table.getID(), COLUMNS_OUTEST_TYPES[iCol]));
            }
            this.addDataTarget(table);
            this.updateModelParameterEstimateColumns();
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getModelParameterEstimatesTable() {
        return this.getOutputTable("OUTEST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPhysicalTable createForecastOfTimeSeriesComponentsTable() {
        if (this.getForecastTimeSeriesComponentsTable() != null) {
            throw new IllegalArgumentException("Forecast Time Series Components table already exists");
        }
        try {
            this.startCompoundUndoable();
            IWorkTable table = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            table.setName(RB.getStringResource("HPFTransformModel.ForecastTimeSeriesComponents.TableName.txt"));
            IRole role = this.getModel().getObjectFactory().createNewRole(this.getID());
            role.setName("OUTFOR");
            role.setContext("OUTFOR");
            role.setObjectRole("OUTFOR");
            table.addRole(role);
            for (int iCol = 0; iCol < COLUMNS_OUTFOR_NAMES.length; ++iCol) {
                table.addColumn(this.createColumn(COLUMNS_OUTFOR_NAMES[iCol], "OUTFOR", table.getID(), COLUMNS_OUTFOR_TYPES[iCol]));
            }
            this.addDataTarget(table);
            this.updateForecastTimeSeriesColumns();
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getForecastTimeSeriesComponentsTable() {
        return this.getOutputTable("OUTFOR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPhysicalTable createSeasonalStatisticsTable() {
        if (this.getSeasonalStatisticsTable() != null) {
            throw new IllegalArgumentException("Seasonal Statistics table already exists");
        }
        try {
            this.startCompoundUndoable();
            IWorkTable table = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            table.setName(RB.getStringResource("HPFTransformModel.SeasonalStatistics.TableName.txt"));
            IRole role = this.getModel().getObjectFactory().createNewRole(this.getID());
            role.setName("OUTSEASON");
            role.setContext("OUTSEASON");
            role.setObjectRole("OUTSEASON");
            table.addRole(role);
            for (int iCol = 0; iCol < COLUMNS_OUTSEASON_NAMES.length; ++iCol) {
                table.addColumn(this.createColumn(COLUMNS_OUTSEASON_NAMES[iCol], "OUTSEASON", table.getID(), COLUMNS_OUTSEASON_TYPES[iCol]));
            }
            this.addDataTarget(table);
            this.updateSeasonalStatisticsColumns();
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getSeasonalStatisticsTable() {
        return this.getOutputTable("OUTSEASON");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPhysicalTable createStatisticsOfFitTable() {
        if (this.getStatisticsOfFitTable() != null) {
            throw new IllegalArgumentException("Statistics of Fit table already exists");
        }
        try {
            this.startCompoundUndoable();
            IWorkTable table = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            table.setName(RB.getStringResource("HPFTransformModel.StatisticsOfFit.TableName.txt"));
            IRole role = this.getModel().getObjectFactory().createNewRole(this.getID());
            role.setName("OUTSTAT");
            role.setContext("OUTSTAT");
            role.setObjectRole("OUTSTAT");
            table.addRole(role);
            for (int iCol = 0; iCol < COLUMNS_OUTSTAT_NAMES.length; ++iCol) {
                table.addColumn(this.createColumn(COLUMNS_OUTSTAT_NAMES[iCol], "OUTSTAT", table.getID(), COLUMNS_OUTSTAT_TYPES[iCol]));
            }
            this.addDataTarget(table);
            this.updateStatisticsOfFitColumns();
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getStatisticsOfFitTable() {
        return this.getOutputTable("OUTSTAT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPhysicalTable createSummaryStatisticsTable() {
        if (this.getSummaryStatisticsTable() != null) {
            throw new IllegalArgumentException("Summary Statistics table already exists");
        }
        try {
            this.startCompoundUndoable();
            IWorkTable table = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            table.setName(RB.getStringResource("HPFTransformModel.SummaryStatistics.TableName.txt"));
            IRole role = this.getModel().getObjectFactory().createNewRole(this.getID());
            role.setName("OUTSUM");
            role.setContext("OUTSUM");
            role.setObjectRole("OUTSUM");
            table.addRole(role);
            for (int iCol = 0; iCol < COLUMNS_OUTSUM_NAMES.length; ++iCol) {
                table.addColumn(this.createColumn(COLUMNS_OUTSUM_NAMES[iCol], "OUTSUM", table.getID(), COLUMNS_OUTSUM_TYPES[iCol]));
            }
            this.addDataTarget(table);
            this.updateSummaryStatisticsColumns();
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getSummaryStatisticsTable() {
        return this.getOutputTable("OUTSUM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPhysicalTable createTrendStatisticsTable() {
        if (this.getTrendStatisticsTable() != null) {
            throw new IllegalArgumentException("Trend Statistics table already exists");
        }
        try {
            this.startCompoundUndoable();
            IWorkTable table = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            table.setName(RB.getStringResource("HPFTransformModel.TrendStatistics.TableName.txt"));
            IRole role = this.getModel().getObjectFactory().createNewRole(this.getID());
            role.setName("OUTTREND");
            role.setContext("OUTTREND");
            role.setObjectRole("OUTTREND");
            table.addRole(role);
            for (int iCol = 0; iCol < COLUMNS_OUTTREND_NAMES.length; ++iCol) {
                table.addColumn(this.createColumn(COLUMNS_OUTTREND_NAMES[iCol], "OUTTREND", table.getID(), COLUMNS_OUTTREND_TYPES[iCol]));
            }
            this.addDataTarget(table);
            this.updateTrendStatisticsColumns();
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getTrendStatisticsTable() {
        return this.getOutputTable("OUTTREND");
    }

    public IPhysicalTable getOutputTable(String sTableRole) {
        if (sTableRole == null) {
            return null;
        }
        IDataObject[] aTables = this.getDataTargets();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            IPhysicalTable oTable;
            IRole[] aRoles;
            if (!(aTables[iTable] instanceof ITable) || (aRoles = (oTable = (IPhysicalTable)aTables[iTable]).getRoles()) == null || aRoles.length == 0) continue;
            for (int iRole = 0; iRole < aRoles.length; ++iRole) {
                if (!sTableRole.equals(aRoles[iRole].getObjectRole())) continue;
                return oTable;
            }
        }
        return null;
    }

    public IPhysicalTable getSourceTable() {
        if (this.getSourceTables().length > 0) {
            return (IPhysicalTable)this.getDataSources()[0];
        }
        return null;
    }

    private IColumn createColumn(String sName, String sRole, String tableID, int iType) {
        return this.createColumn(sName, sRole, tableID, iType, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IColumn createColumn(String sName, String sRole, String tableID, int iType, int iLead) {
        IColumn oColumn = null;
        try {
            this.getModel().startCompoundUndoable();
            oColumn = this.getModel().getObjectFactory().createNewColumn(tableID);
            oColumn.setName(sName);
            oColumn.setType(iType);
            String sDesc = iLead == -1 ? RB.getStringResource("HPF.TargetTable." + sRole + "." + sName + ".label.txt") : MessageFormat.format(RB.getStringResource("HPF.TargetTable.OUTSUM._LEAD_.label.fmt"), iLead);
            oColumn.setDescription(sDesc);
        }
        finally {
            this.getModel().endCompoundUndoable();
        }
        return oColumn;
    }

    private IColumn createColumn(String tableID, IColumn sourceColumn) {
        IColumn oCol = this.getModel().getObjectFactory().createNewColumn(tableID);
        sourceColumn.deepCopy(oCol);
        return oCol;
    }

    private void updateColumnsFromList(ITable table, List lCols) {
        for (int i = 0; i < lCols.size(); ++i) {
            IColumn sourceCol = (IColumn)lCols.get(i);
            IColumn targetCol = table.getColumnWithMatchingName(sourceCol.getName());
            if (targetCol == null) {
                targetCol = this.createColumn(table.getID(), sourceCol);
                table.addColumn(targetCol);
                continue;
            }
            sourceCol.copy(targetCol);
        }
    }

    public void updateForecastOfVariablesColumns() {
        IPhysicalTable table = this.getForecastsOfVariablesTable();
        if (table == null) {
            return;
        }
        IColumn[] aCols = table.getColumns();
        List lForecastCols = this.getForecastColumns().isEmpty() ? this.getPossibleForecastColumns() : this.getForecastColumns();
        HashSet<String> sForecastNames = new HashSet<String>();
        for (int i = 0; i < lForecastCols.size(); ++i) {
            sForecastNames.add(((IColumn)lForecastCols.get(i)).getName());
        }
        IColumn[] aByCols = this.getSortOrder().getColumnObjects();
        HashSet<String> sByNames = new HashSet<String>();
        for (int i = 0; i < aByCols.length; ++i) {
            sByNames.add(aByCols[i].getName());
        }
        for (int iCol = 0; iCol < aCols.length; ++iCol) {
            IColumn oCol = aCols[iCol];
            String sName = oCol.getName();
            if (this.getIdColumn() == null && sName.equals("TIME") || this.getIdColumn() != null && sName.equals(this.getIdColumn().getName()) || sForecastNames.contains(sName) || sByNames.contains(sName)) continue;
            table.removeColumn(oCol);
        }
        if (this.getIdColumn() == null) {
            if (table.getColumnWithMatchingName("TIME") == null) {
                table.addColumn(this.createColumn("TIME", TARGET_TABLE_OUT, table.getID(), 1));
            }
        } else {
            IColumn col = table.getColumnWithMatchingName(this.getIdColumn().getName());
            if (col == null) {
                col = this.createColumn(table.getID(), this.getIdColumn());
                col.setFormat(this.getIntervalFormat());
                table.addColumn(col);
            } else {
                this.getIdColumn().copy(col);
                col.setFormat(this.getIntervalFormat());
            }
        }
        this.updateColumnsFromList(table, lForecastCols);
        this.updateColumnsFromList(table, Arrays.asList(aByCols));
        this.updateForecastsOfVariablesMappings();
    }

    public void updateModelParameterEstimateColumns() {
        IPhysicalTable table = this.getModelParameterEstimatesTable();
        if (table == null) {
            return;
        }
        IColumn[] aCols = table.getColumns();
        IColumn[] aByCols = this.getSortOrder().getColumnObjects();
        HashSet<String> sByNames = new HashSet<String>();
        for (int i = 0; i < aByCols.length; ++i) {
            sByNames.add(aByCols[i].getName());
        }
        HashSet<String> sColNames = new HashSet<String>();
        for (int i = 0; i < COLUMNS_OUTEST_NAMES.length; ++i) {
            sColNames.add(COLUMNS_OUTEST_NAMES[i]);
        }
        for (int iCol = 0; iCol < aCols.length; ++iCol) {
            IColumn oCol = aCols[iCol];
            String sName = oCol.getName();
            if (sColNames.contains(sName) || sByNames.contains(sName)) continue;
            table.removeColumn(oCol);
        }
        this.updateColumnsFromList(table, Arrays.asList(aByCols));
        this.updateModelParameterEstimatesMappings();
    }

    public void updateForecastTimeSeriesColumns() {
        IPhysicalTable table = this.getForecastTimeSeriesComponentsTable();
        if (table == null) {
            return;
        }
        IColumn[] aCols = table.getColumns();
        IColumn[] aByCols = this.getSortOrder().getColumnObjects();
        HashSet<String> sByNames = new HashSet<String>();
        for (int i = 0; i < aByCols.length; ++i) {
            sByNames.add(aByCols[i].getName());
        }
        HashSet<String> sColNames = new HashSet<String>();
        for (int i = 0; i < COLUMNS_OUTFOR_NAMES.length; ++i) {
            sColNames.add(COLUMNS_OUTFOR_NAMES[i]);
        }
        for (int iCol = 0; iCol < aCols.length; ++iCol) {
            IColumn oCol = aCols[iCol];
            String sName = oCol.getName();
            if (sColNames.contains(sName) || this.getIdColumn() == null && sName.equals("_TIMEID") || this.getIdColumn() != null && sName.equals(this.getIdColumn().getName()) || sByNames.contains(sName)) continue;
            table.removeColumn(oCol);
        }
        if (this.getIdColumn() == null) {
            if (table.getColumnWithMatchingName("_TIMEID") == null) {
                table.addColumn(1, this.createColumn("_TIMEID", "OUTFOR", table.getID(), 1));
            }
        } else {
            IColumn col = table.getColumnWithMatchingName(this.getIdColumn().getName());
            if (col == null) {
                col = this.createColumn(table.getID(), this.getIdColumn());
                col.setFormat(this.getIntervalFormat());
                table.addColumn(col);
            } else {
                this.getIdColumn().copy(col);
                col.setFormat(this.getIntervalFormat());
            }
        }
        this.updateColumnsFromList(table, Arrays.asList(aByCols));
        this.updateForecastTimeSeriesMappings();
    }

    public void updateSeasonalStatisticsColumns() {
        IPhysicalTable table = this.getSeasonalStatisticsTable();
        if (table == null) {
            return;
        }
        IColumn[] aCols = table.getColumns();
        IColumn[] aByCols = this.getSortOrder().getColumnObjects();
        HashSet<String> sByNames = new HashSet<String>();
        for (int i = 0; i < aByCols.length; ++i) {
            sByNames.add(aByCols[i].getName());
        }
        HashSet<String> sColNames = new HashSet<String>();
        for (int i = 0; i < COLUMNS_OUTSEASON_NAMES.length; ++i) {
            sColNames.add(COLUMNS_OUTSEASON_NAMES[i]);
        }
        for (int iCol = 0; iCol < aCols.length; ++iCol) {
            IColumn oCol = aCols[iCol];
            String sName = oCol.getName();
            if (sColNames.contains(sName) || sByNames.contains(sName)) continue;
            table.removeColumn(oCol);
        }
        this.updateColumnsFromList(table, Arrays.asList(aByCols));
        this.updateSeasonalStatisticsMappings();
    }

    public void updateStatisticsOfFitColumns() {
        IPhysicalTable table = this.getStatisticsOfFitTable();
        if (table == null) {
            return;
        }
        IColumn[] aCols = table.getColumns();
        IColumn[] aByCols = this.getSortOrder().getColumnObjects();
        HashSet<String> sByNames = new HashSet<String>();
        for (int i = 0; i < aByCols.length; ++i) {
            sByNames.add(aByCols[i].getName());
        }
        HashSet<String> sColNames = new HashSet<String>();
        for (int i = 0; i < COLUMNS_OUTSTAT_NAMES.length; ++i) {
            sColNames.add(COLUMNS_OUTSTAT_NAMES[i]);
        }
        for (int iCol = 0; iCol < aCols.length; ++iCol) {
            IColumn oCol = aCols[iCol];
            String sName = oCol.getName();
            if (sColNames.contains(sName) || sByNames.contains(sName)) continue;
            table.removeColumn(oCol);
        }
        this.updateColumnsFromList(table, Arrays.asList(aByCols));
        this.updateStatisticsOfFitMappings();
    }

    public void updateSummaryStatisticsColumns() {
        IPhysicalTable table = this.getSummaryStatisticsTable();
        if (table == null) {
            return;
        }
        IColumn[] aCols = table.getColumns();
        IColumn[] aByCols = this.getSortOrder().getColumnObjects();
        HashSet<String> sByNames = new HashSet<String>();
        for (int i = 0; i < aByCols.length; ++i) {
            sByNames.add(aByCols[i].getName());
        }
        HashSet<String> sColNames = new HashSet<String>();
        for (int i = 0; i < COLUMNS_OUTSUM_NAMES.length; ++i) {
            sColNames.add(COLUMNS_OUTSUM_NAMES[i]);
        }
        for (int iCol = 0; iCol < aCols.length; ++iCol) {
            String sLead;
            int iLead;
            IColumn oCol = aCols[iCol];
            String sName = oCol.getName();
            if (sColNames.contains(sName) || sByNames.contains(sName) || sName.startsWith(COLUMNS_OUTSUM_LEAD_NAME) && (iLead = Integer.parseInt(sLead = sName.substring(5, sName.length() - 1))) <= this.getLead()) continue;
            table.removeColumn(oCol);
        }
        int iLead = this.getLead();
        for (int i = 1; i <= iLead; ++i) {
            String sColName = COLUMNS_OUTSUM_LEAD_NAME + Integer.toString(i) + "_";
            if (table.getColumnWithMatchingName(sColName) != null) continue;
            table.addColumn(this.createColumn(sColName, "OUTSUM", table.getID(), 1, i));
        }
        this.updateColumnsFromList(table, Arrays.asList(aByCols));
        this.updateSummaryStatisticsMappings();
    }

    public void updateTrendStatisticsColumns() {
        IPhysicalTable table = this.getTrendStatisticsTable();
        if (table == null) {
            return;
        }
        IColumn[] aCols = table.getColumns();
        IColumn[] aByCols = this.getSortOrder().getColumnObjects();
        HashSet<String> sByNames = new HashSet<String>();
        for (int i = 0; i < aByCols.length; ++i) {
            sByNames.add(aByCols[i].getName());
        }
        HashSet<String> sColNames = new HashSet<String>();
        for (int i = 0; i < COLUMNS_OUTTREND_NAMES.length; ++i) {
            sColNames.add(COLUMNS_OUTTREND_NAMES[i]);
        }
        for (int iCol = 0; iCol < aCols.length; ++iCol) {
            IColumn oCol = aCols[iCol];
            String sName = oCol.getName();
            if (sColNames.contains(sName) || this.getIdColumn() != null && sName.equals(this.getIdColumn().getName()) || sByNames.contains(sName)) continue;
            table.removeColumn(oCol);
        }
        if (this.getIdColumn() != null) {
            IColumn col = table.getColumnWithMatchingName(this.getIdColumn().getName());
            if (col == null) {
                col = this.createColumn(table.getID(), this.getIdColumn());
                table.addColumn(col);
                col.setFormat(this.getIntervalFormat());
            } else {
                this.getIdColumn().copy(col);
                col.setFormat(this.getIntervalFormat());
            }
        }
        this.updateColumnsFromList(table, Arrays.asList(aByCols));
        this.updateTrendStatisticsMappings();
    }

    public List getNumericSourceColumns() {
        ArrayList<IColumn> lNumCols = new ArrayList<IColumn>();
        if (this.getSourceTable() == null) {
            return lNumCols;
        }
        IColumn[] aCols = this.getSourceTable().getColumns();
        for (int iCol = 0; iCol < aCols.length; ++iCol) {
            if (aCols[iCol].getType() != 1) continue;
            lNumCols.add(aCols[iCol]);
        }
        return lNumCols;
    }

    public List getPossibleForecastColumns() {
        List lCols = this.getNumericSourceColumns();
        if (this.getIdColumn() != null) {
            lCols.remove(this.getIdColumn());
        }
        lCols.removeAll(Arrays.asList(this.getSortOrder().getColumnObjects()));
        return lCols;
    }

    public IDocument getHPFDocument() {
        IDataObject[] aTargets = this.getDataTargets();
        for (int i = 0; i < aTargets.length; ++i) {
            if (!(aTargets[i] instanceof IDocument)) continue;
            return (IDocument)aTargets[i];
        }
        return null;
    }

    public IDocument createHPFDocument(String docName) {
        IDocument oDocument = this.getModel().getObjectFactory().createNewDocument(this.getID());
        oDocument.setName(docName);
        oDocument.setURI(oDocument.getName().replaceAll(" ", "") + ".html");
        oDocument.setFolder(this.getJob().getFolder());
        oDocument.setTextRole(TARGET_HPFDOCUMENT_TEXTROLE);
        return oDocument;
    }

    private void setHPFDocumentInPortDescription(IDocument oDocument) {
        HPFPortDescriptionModel portDesc = (HPFPortDescriptionModel)this.m_lOutputPortDescriptions.get(7);
        portDesc.setObject(oDocument);
    }

    private boolean isValid(String sOption, String[] sChoices) {
        return Arrays.asList(sChoices).contains(sOption);
    }

    private String getHPFRole(ITable table) {
        if (table == null || table.getRoles() == null) {
            return null;
        }
        IRole[] aRoles = table.getRoles();
        for (int i = 0; i < aRoles.length; ++i) {
            if (!this.isValid(aRoles[i].getObjectRole(), TARGET_TABLE_ROLES)) continue;
            return aRoles[i].getObjectRole();
        }
        return null;
    }

    public int getLead() {
        return this.m_iLead;
    }

    public void setLead(int iLead) {
        if (iLead == this.m_iLead) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLeadUndoable(this.m_iLead, iLead));
        }
        this.m_iLead = iLead;
        this.fireModelChangedEvent(LEAD_CHANGED, null);
    }

    public int getBack() {
        return this.m_iBack;
    }

    public void setBack(int iBack) {
        if (iBack == this.m_iBack) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBackUndoable(this.m_iBack, iBack));
        }
        this.m_iBack = iBack;
        this.fireModelChangedEvent(BACK_CHANGED, null);
    }

    public String getSeasonality() {
        return this.m_sSeasonality;
    }

    public void setSeasonality(String sSeasonality) {
        if (sSeasonality != null ? sSeasonality.equals(this.m_sSeasonality) : this.m_sSeasonality == null) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSeasonalityUndoable(this.m_sSeasonality, sSeasonality));
        }
        this.m_sSeasonality = sSeasonality;
        this.fireModelChangedEvent(SEASONALITY_CHANGED, null);
    }

    public boolean isSortedVariables() {
        return this.m_bSortedVariables;
    }

    public void setSortedVariables(boolean bSortedVariables) {
        if (bSortedVariables == this.m_bSortedVariables) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSortedVariablesUndoable(this.m_bSortedVariables, bSortedVariables));
        }
        this.m_bSortedVariables = bSortedVariables;
        this.fireModelChangedEvent(SORTED_VARIABLES_CHANGED, null);
    }

    public boolean isGreaterDetails() {
        return this.m_bGreaterDetails;
    }

    public void setGreaterDetails(boolean bGreaterDetails) {
        if (bGreaterDetails == this.m_bGreaterDetails) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGreaterDetailsUndoable(this.m_bGreaterDetails, bGreaterDetails));
        }
        this.m_bGreaterDetails = bGreaterDetails;
        this.fireModelChangedEvent(GREATER_DETAILS_CHANGED, null);
    }

    public boolean isOutputWindow() {
        return this.m_bOutputWindow;
    }

    public void setOutputWindow(boolean bOutputWindow) {
        if (bOutputWindow == this.m_bOutputWindow) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOutputWindowUndoable(this.m_bOutputWindow, bOutputWindow));
        }
        this.m_bOutputWindow = bOutputWindow;
        this.fireModelChangedEvent(OUTPUT_WINDOW_CHANGED, null);
    }

    public IColumn getIdColumn() {
        return this.m_oIdColumn;
    }

    public List getForecastColumns() {
        return this.m_lForecastColumns;
    }

    public void setIdColumn(IColumn oIdColumn) {
        if (oIdColumn != null ? oIdColumn.equals(this.m_oIdColumn) : this.m_oIdColumn == null) {
            return;
        }
        if (!(oIdColumn == null || this.getSourceTable() != null && this.getSourceTable().containsColumn(oIdColumn))) {
            throw new IllegalArgumentException("IDColumn must belong to the source table");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIdColumnUndoable(this.m_oIdColumn, oIdColumn));
        }
        this.m_oIdColumn = oIdColumn;
        this.fireModelChangedEvent(ID_COLUMN_CHANGED, null);
    }

    public boolean isNotSorted() {
        return this.m_bNotSorted;
    }

    public void setNotSorted(boolean bNotSorted) {
        if (bNotSorted == this.m_bNotSorted) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNotSortedUndoable(this.m_bNotSorted, bNotSorted));
        }
        this.m_bNotSorted = bNotSorted;
        this.fireModelChangedEvent(NOT_SORTED_CHANGED, null);
    }

    public String getInterval() {
        return this.m_sInterval;
    }

    public void setInterval(String sInterval) {
        if (sInterval != null ? sInterval.equals(this.m_sInterval) : this.m_sInterval == null) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIntervalUndoable(this.m_sInterval, sInterval));
        }
        this.m_sInterval = sInterval;
        this.fireModelChangedEvent(INTERVAL_CHANGED, null);
    }

    public String getAccumulate() {
        return this.m_sAccumulate;
    }

    public void setAccumulate(String sAccumulate) {
        if (!this.isValid(sAccumulate, IDOPTION_ACCUMULATES)) {
            throw new IllegalArgumentException("Invalid option for Accumulate");
        }
        if (sAccumulate.equals(this.m_sAccumulate)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAccumulateUndoable(this.m_sAccumulate, sAccumulate));
        }
        this.m_sAccumulate = sAccumulate;
        this.fireModelChangedEvent(ACCUMULATE_CHANGED, null);
    }

    public String getSetMissing() {
        return this.m_sSetMissing;
    }

    public void setSetMissing(String sSetMissing) {
        if (sSetMissing != null ? sSetMissing.equals(this.m_sSetMissing) : this.m_sSetMissing == null) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSetMissingUndoable(this.m_sSetMissing, sSetMissing));
        }
        this.m_sSetMissing = sSetMissing;
        this.fireModelChangedEvent(SET_MISSING_CHANGED, null);
    }

    public String getZeroMissing() {
        return this.m_sZeroMissing;
    }

    public void setZeroMissing(String sZeroMissing) {
        if (!this.isValid(sZeroMissing, IDOPTION_ZEROMISSINGS)) {
            throw new IllegalArgumentException("Invalid option for ZeroMissing");
        }
        if (sZeroMissing.equals(this.m_sZeroMissing)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetZeroMissingUndoable(this.m_sZeroMissing, sZeroMissing));
        }
        this.m_sZeroMissing = sZeroMissing;
        this.fireModelChangedEvent(ZERO_MISSING_CHANGED, null);
    }

    public String getStartDate() {
        return this.m_sStartDate;
    }

    public void setStartDate(String sStartDate) {
        if (sStartDate != null ? sStartDate.equals(this.m_sStartDate) : this.m_sStartDate == null) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetStartDateUndoable(this.m_sStartDate, sStartDate));
        }
        this.m_sStartDate = sStartDate;
        this.fireModelChangedEvent(START_DATE_CHANGED, null);
    }

    public String getEndDate() {
        return this.m_sEndDate;
    }

    public void setEndDate(String sEndDate) {
        if (sEndDate != null ? sEndDate.equals(this.m_sEndDate) : this.m_sEndDate == null) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetEndDateUndoable(this.m_sEndDate, sEndDate));
        }
        this.m_sEndDate = sEndDate;
        this.fireModelChangedEvent(END_DATE_CHANGED, null);
    }

    public String getIntervalFormat() {
        return this.m_sIntervalFormat;
    }

    public void setIntervalFormat(String sIntervalFormat) {
        if (sIntervalFormat != null ? sIntervalFormat.equals(this.m_sIntervalFormat) : this.m_sIntervalFormat == null) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIntervalFormatUndoable(this.m_sIntervalFormat, sIntervalFormat));
        }
        this.m_sIntervalFormat = sIntervalFormat;
        this.fireModelChangedEvent(INTERVAL_FORMAT_CHANGED, null);
    }

    public String getUse() {
        return this.m_sUse;
    }

    public void setUse(String sUse) {
        if (!this.isValid(sUse, FORECASTOPTION_USES)) {
            throw new IllegalArgumentException("Invalid option for Use");
        }
        if (sUse.equals(this.m_sUse)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseUndoable(this.m_sUse, sUse));
        }
        this.m_sUse = sUse;
        this.fireModelChangedEvent(USE_CHANGED, null);
    }

    public String getModelOption() {
        return this.m_sModel;
    }

    public void setModelOption(String sModel) {
        if (!this.isValid(sModel, FORECASTOPTION_MODELS)) {
            throw new IllegalArgumentException("Invalid option for Model");
        }
        if (sModel.equals(this.m_sModel)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetModelUndoable(this.m_sModel, sModel));
        }
        this.m_sModel = sModel;
        this.fireModelChangedEvent(MODEL_OPTION_CHANGED, null);
    }

    public String getModelSelection() {
        return this.m_sModelSelection;
    }

    public void setModelSelection(String sModelSelection) {
        if (!this.isValid(sModelSelection, FORECASTOPTION_MODELSELECTIONS)) {
            throw new IllegalArgumentException("Invalid option for ModelSelection");
        }
        if (sModelSelection.equals(this.m_sModelSelection)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetModelSelectionUndoable(this.m_sModelSelection, sModelSelection));
        }
        this.m_sModelSelection = sModelSelection;
        this.fireModelChangedEvent(MODEL_SELECTION_CHANGED, null);
    }

    public String getTransform() {
        return this.m_sTransform;
    }

    public void setTransform(String sTransform) {
        if (sTransform == null) {
            throw new IllegalArgumentException("Transform should not be null");
        }
        if (sTransform.equals(this.m_sTransform)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTransformUndoable(this.m_sTransform, sTransform));
        }
        this.m_sTransform = sTransform;
        this.fireModelChangedEvent(TRANSFORM_CHANGED, null);
    }

    public boolean isReplaceMissing() {
        return this.m_bReplaceMissing;
    }

    public void setReplaceMissing(boolean bReplaceMissing) {
        if (bReplaceMissing == this.m_bReplaceMissing) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetReplaceMissingUndoable(this.m_bReplaceMissing, bReplaceMissing));
        }
        this.m_bReplaceMissing = bReplaceMissing;
        this.fireModelChangedEvent(REPLACE_MISSING_CHANGED, null);
    }

    public boolean isEstimateMedian() {
        return this.m_bEstimateMedian;
    }

    public void setEstimateMedian(boolean bEstimateMedian) {
        if (bEstimateMedian == this.m_bEstimateMedian) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetEstimateMedianUndoable(this.m_bEstimateMedian, bEstimateMedian));
        }
        this.m_bEstimateMedian = bEstimateMedian;
        this.fireModelChangedEvent(ESTIMATE_MEDIAN_CHANGED, null);
    }

    public double getAlpha() {
        return this.m_dAlpha;
    }

    public void setAlpha(double dAlpha) {
        if (dAlpha == this.m_dAlpha) {
            return;
        }
        if (dAlpha < 0.0 || dAlpha > 1.0) {
            throw new IllegalArgumentException("Alpha must be between 0 and 1");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAlphaUndoable(this.m_dAlpha, dAlpha));
        }
        this.m_dAlpha = dAlpha;
        this.fireModelChangedEvent(ALPHA_CHANGED, null);
    }

    public double getHoldoutPercent() {
        return this.m_dHoldoutPercent;
    }

    public void setHoldoutPercent(double dHoldoutPercent) {
        if (dHoldoutPercent == this.m_dHoldoutPercent) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetHoldoutPercentUndoable(this.m_dHoldoutPercent, dHoldoutPercent));
        }
        this.m_dHoldoutPercent = dHoldoutPercent;
        this.fireModelChangedEvent(HOLDOUT_PERCENT_CHANGED, null);
    }

    public double getIntermittent() {
        return this.m_dIntermittent;
    }

    public void setIntermittent(double dIntermittent) {
        if (dIntermittent == this.m_dIntermittent) {
            return;
        }
        if (dIntermittent <= 1.0) {
            throw new IllegalArgumentException("Intermittent must be greater than 1");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIntermittentUndoable(this.m_dIntermittent, dIntermittent));
        }
        this.m_dIntermittent = dIntermittent;
        this.fireModelChangedEvent(INTERMITTENT_CHANGED, null);
    }

    public int getHoldout() {
        return this.m_iHoldout;
    }

    public void setHoldout(int iHoldout) {
        if (iHoldout == this.m_iHoldout) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetHoldoutUndoable(this.m_iHoldout, iHoldout));
        }
        this.m_iHoldout = iHoldout;
        this.fireModelChangedEvent(HOLDOUT_CHANGED, null);
    }

    public String[] getSelectedPrintOptions() {
        return this.m_lSelectedPrintOpts.toArray(new String[this.m_lSelectedPrintOpts.size()]);
    }

    public String[] getSelectedPlotOptions() {
        return this.m_lSelectedPlotOpts.toArray(new String[this.m_lSelectedPlotOpts.size()]);
    }

    public void addPrintOption(String sOption) {
        if (!this.isValid(sOption, PRINTOPTIONS)) {
            throw new IllegalArgumentException("Invalid print option");
        }
        if (this.m_lSelectedPrintOpts.contains(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddPrintOptionUndoable(sOption));
        }
        this.m_lSelectedPrintOpts.add(sOption);
        this.fireModelChangedEvent(PRINTOPTION_ADDED, sOption);
    }

    public void addPlotOption(String sOption) {
        if (!this.isValid(sOption, PLOTOPTIONS)) {
            throw new IllegalArgumentException("Invalid plot option");
        }
        if (this.m_lSelectedPlotOpts.contains(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddPlotOptionUndoable(sOption));
        }
        this.m_lSelectedPlotOpts.add(sOption);
        this.fireModelChangedEvent(PLOTOPTION_ADDED, sOption);
    }

    public void removePrintOption(String sOption) {
        if (!this.m_lSelectedPrintOpts.contains(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemovePrintOptionUndoable(sOption));
        }
        this.m_lSelectedPrintOpts.remove(sOption);
        this.fireModelChangedEvent(PRINTOPTION_REMOVED, sOption);
    }

    public void removePlotOption(String sOption) {
        if (!this.m_lSelectedPlotOpts.contains(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemovePlotOptionUndoable(sOption));
        }
        this.m_lSelectedPlotOpts.remove(sOption);
        this.fireModelChangedEvent(PLOTOPTION_REMOVED, sOption);
    }

    private void clearPrintOptions() {
        try {
            this.getModel().startCompoundUndoable();
            for (int i = this.m_lSelectedPrintOpts.size() - 1; i >= 0; --i) {
                this.removePrintOption((String)this.m_lSelectedPrintOpts.get(i));
            }
        }
        finally {
            this.getModel().endCompoundUndoable();
        }
    }

    private void clearPlotOptions() {
        try {
            this.getModel().startCompoundUndoable();
            for (int i = this.m_lSelectedPlotOpts.size() - 1; i >= 0; --i) {
                this.removePlotOption((String)this.m_lSelectedPlotOpts.get(i));
            }
        }
        finally {
            this.getModel().endCompoundUndoable();
        }
    }

    @Override
    public ISorting getSortOrder() {
        return this.m_order;
    }

    public void setSortOrder(ISorting sort) {
        if (sort == null) {
            throw new IllegalArgumentException("sort order cannot be null");
        }
        if (sort.equals(this.m_order)) {
            return;
        }
        if (this.m_order != null) {
            this.m_order.removeNotifyListener(this);
            this.addToDeletedObjects(this.m_order);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSortOrderChangedUndoable(this.m_order, sort));
        }
        this.m_order = sort;
        if (this.m_order != null) {
            this.m_order.addNotifyListener(this);
            this.removeFromDeletedObjects(this.m_order);
        }
        this.fireModelChangedEvent("ISortingTransform:SortOrderChanged", this.m_order);
    }

    @Override
    public boolean isIncludedInPropagation() {
        return false;
    }

    @Override
    public boolean isIncludedInMapping() {
        return false;
    }

    private void updateForecastsOfVariablesMappings() {
        IPhysicalTable table = this.getForecastsOfVariablesTable();
        if (table == null) {
            IMapping[] maps = this.getMappings();
            for (int i = 0; i < maps.length; ++i) {
                if (!maps[i].getType().equals("ONETOONE")) continue;
                this.removeMapping(maps[i]);
            }
        } else {
            IMapping map;
            int i;
            List lMaps = this.getForecastOfVariablesMappings();
            List lColsToAdd = this.getSourceColumnsForMapping();
            for (i = 0; i < lMaps.size(); ++i) {
                map = (IMapping)lMaps.get(i);
                IColumn[] aSources = map.getSources();
                if (map.getSourceCount() == 1 && lColsToAdd.contains(aSources[0])) {
                    lColsToAdd.remove(aSources[0]);
                    continue;
                }
                this.removeMapping(map);
            }
            for (i = 0; i < lColsToAdd.size(); ++i) {
                map = this.getModel().getObjectFactory().createNewHPFMapping(this.getID());
                map.setName(MAPPING_OUT);
                map.setType("ONETOONE");
                IColumn col = (IColumn)lColsToAdd.get(i);
                map.addSource(col);
                map.addTarget(table.getColumnWithMatchingName(col.getName()));
                if (this.containsMapping(map)) continue;
                this.addMapping(map);
            }
        }
    }

    private void updateModelParameterEstimatesMappings() {
        IMapping map = this.getMappingWithName("OUTEST");
        if (this.getModelParameterEstimatesTable() != null) {
            if (map == null) {
                map = this.getModel().getObjectFactory().createNewHPFMapping(this.getID());
                map.setName("OUTEST");
                map.setType("DERIVED");
            }
            this.updateMappingColumns(map, this.getSourceColumnsForMapping(), Arrays.asList(this.getModelParameterEstimatesTable().getColumns()));
            if (!this.containsMapping(map)) {
                this.addMapping(map);
            }
        } else if (map != null) {
            this.removeMapping(map);
        }
    }

    private void updateForecastTimeSeriesMappings() {
        IMapping map = this.getMappingWithName("OUTFOR");
        if (this.getModelParameterEstimatesTable() != null) {
            if (map == null) {
                map = this.getModel().getObjectFactory().createNewHPFMapping(this.getID());
                map.setName("OUTFOR");
                map.setType("DERIVED");
            }
            this.updateMappingColumns(map, this.getSourceColumnsForMapping(), Arrays.asList(this.getForecastTimeSeriesComponentsTable().getColumns()));
            if (!this.containsMapping(map)) {
                this.addMapping(map);
            }
        } else if (map != null) {
            this.removeMapping(map);
        }
    }

    private void updateSeasonalStatisticsMappings() {
        IMapping map = this.getMappingWithName("OUTSEASON");
        if (this.getModelParameterEstimatesTable() != null) {
            if (map == null) {
                map = this.getModel().getObjectFactory().createNewHPFMapping(this.getID());
                map.setName("OUTSEASON");
                map.setType("DERIVED");
            }
            this.updateMappingColumns(map, this.getSourceColumnsForMapping(), Arrays.asList(this.getSeasonalStatisticsTable().getColumns()));
            if (!this.containsMapping(map)) {
                this.addMapping(map);
            }
        } else if (map != null) {
            this.removeMapping(map);
        }
    }

    private void updateStatisticsOfFitMappings() {
        IMapping map = this.getMappingWithName("OUTSTAT");
        if (this.getModelParameterEstimatesTable() != null) {
            if (map == null) {
                map = this.getModel().getObjectFactory().createNewHPFMapping(this.getID());
                map.setName("OUTSTAT");
                map.setType("DERIVED");
            }
            this.updateMappingColumns(map, this.getSourceColumnsForMapping(), Arrays.asList(this.getStatisticsOfFitTable().getColumns()));
            if (!this.containsMapping(map)) {
                this.addMapping(map);
            }
        } else if (map != null) {
            this.removeMapping(map);
        }
    }

    private void updateSummaryStatisticsMappings() {
        IMapping map = this.getMappingWithName("OUTSUM");
        if (this.getModelParameterEstimatesTable() != null) {
            if (map == null) {
                map = this.getModel().getObjectFactory().createNewHPFMapping(this.getID());
                map.setName("OUTSUM");
                map.setType("DERIVED");
            }
            this.updateMappingColumns(map, this.getSourceColumnsForMapping(), Arrays.asList(this.getSummaryStatisticsTable().getColumns()));
            if (!this.containsMapping(map)) {
                this.addMapping(map);
            }
        } else if (map != null) {
            this.removeMapping(map);
        }
    }

    private void updateTrendStatisticsMappings() {
        IMapping map = this.getMappingWithName("OUTTREND");
        if (this.getModelParameterEstimatesTable() != null) {
            if (map == null) {
                map = this.getModel().getObjectFactory().createNewHPFMapping(this.getID());
                map.setName("OUTTREND");
                map.setType("DERIVED");
            }
            this.updateMappingColumns(map, this.getSourceColumnsForMapping(), Arrays.asList(this.getTrendStatisticsTable().getColumns()));
            if (!this.containsMapping(map)) {
                this.addMapping(map);
            }
        } else if (map != null) {
            this.removeMapping(map);
        }
    }

    private IMapping getMappingWithName(String sName) {
        IMapping[] aMaps = this.getMappings();
        if (aMaps == null || aMaps.length == 0) {
            return null;
        }
        for (int iMap = 0; iMap < aMaps.length; ++iMap) {
            if (!aMaps[iMap].getName().equals(sName)) continue;
            return aMaps[iMap];
        }
        return null;
    }

    private List getSourceColumnsForMapping() {
        IColumn oIDCol = this.getIdColumn();
        List lForecastCols = this.getForecastColumns();
        List<IColumn> lByCols = Arrays.asList(this.getSortOrder().getColumnObjects());
        ArrayList<IColumn> lSourceCols = new ArrayList<IColumn>();
        if (oIDCol != null) {
            lSourceCols.add(oIDCol);
        }
        if (lForecastCols != null && !lForecastCols.isEmpty()) {
            lSourceCols.addAll(lForecastCols);
        }
        if (lByCols != null && !lByCols.isEmpty()) {
            lSourceCols.addAll(lByCols);
        }
        return lSourceCols;
    }

    private List getForecastOfVariablesMappings() {
        ArrayList<IMapping> lMaps = new ArrayList<IMapping>();
        IMapping[] aMaps = this.getMappings();
        for (int i = 0; i < aMaps.length; ++i) {
            if (!aMaps[i].getType().equals("ONETOONE")) continue;
            lMaps.add(aMaps[i]);
        }
        return lMaps;
    }

    private void updateMappingColumns(IMapping map, List lSources, List lTargets) {
        int i;
        IColumn[] colsCurrent = map.getSources();
        for (i = colsCurrent.length - 1; i >= 0; --i) {
            if (lSources.contains(colsCurrent[i])) continue;
            map.removeSource(colsCurrent[i]);
        }
        for (i = 0; i < lSources.size(); ++i) {
            if (map.containsInSources((IColumn)lSources.get(i))) continue;
            map.addSource((IColumn)lSources.get(i));
        }
        colsCurrent = map.getTargets();
        for (i = colsCurrent.length - 1; i >= 0; --i) {
            if (lTargets.contains(colsCurrent[i])) continue;
            map.removeTarget(colsCurrent[i]);
        }
        for (i = 0; i < lTargets.size(); ++i) {
            if (map.containsInTargets((IColumn)lTargets.get(i))) continue;
            map.addTarget((IColumn)lTargets.get(i));
        }
    }

    public static boolean isHPFMapping(String sName) {
        if (sName == null) {
            return false;
        }
        return sName.contains("OUTEST") || sName.contains("OUTFOR") || sName.contains("OUTSEASON") || sName.contains("OUTSTAT") || sName.contains("OUTSUM") || sName.contains("OUTTREND");
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        Select mdoSelect = (Select)this.getClassifierMapObject(omr);
        this.saveHPFPropertyOptionsToOMR(omr, mdoSelect);
        this.saveIDPropertyOptionsToOMR(omr, mdoSelect);
        this.saveForecastPropertyOptionsToOMR(omr, mdoSelect);
        this.savePrintPropertyOptionsToOMR(omr, mdoSelect);
        this.savePlotPropertyOptionsToOMR(omr, mdoSelect);
        ISorting sortOrder = this.getSortOrder();
        if (sortOrder != null) {
            sortOrder.saveToOMR(omr);
            OrderByClause mdoOrder = (OrderByClause)omr.acquireOMRObject(sortOrder);
            mdoSelect.setOrderByForSelect(mdoOrder);
        }
        this.saveHPFDocumentToOMR(omr, mdoStep);
        IDataObject[] aTables = this.getDataTargets();
        for (int i = 0; i <= aTables.length; ++i) {
            for (int iTable = 0; iTable < aTables.length; ++iTable) {
                ITable oTable;
                IRole[] aRoles;
                if (!(aTables[iTable] instanceof ITable) || (aRoles = (oTable = (ITable)aTables[iTable]).getRoles()) == null || aRoles.length == 0) continue;
                for (int iRole = 0; iRole < aRoles.length; ++iRole) {
                    if (!this.isValid(aRoles[iRole].getObjectRole(), TARGET_TABLE_ROLES)) continue;
                    aRoles[iRole].saveToOMR(omr);
                }
            }
        }
        this.setChanged(false);
    }

    private void saveHPFPropertyOptionsToOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_LEAD, PROPERTY_NAME_LEAD, PROPERTY_NAME_LEAD, Integer.toString(this.getLead()), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_BACK, PROPERTY_NAME_BACK, PROPERTY_NAME_BACK, Integer.toString(this.getBack()), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_SEASONALITY, PROPERTY_NAME_SEASONALITY, PROPERTY_NAME_SEASONALITY, this.getSeasonality(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_SORTNAMES, PROPERTY_NAME_SORTNAMES, PROPERTY_NAME_SORTNAMES, this.isSortedVariables() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_PRINTDETAILS, PROPERTY_NAME_PRINTDETAILS, PROPERTY_NAME_PRINTDETAILS, this.isGreaterDetails() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_USEOUTPUTWINDOW, PROPERTY_NAME_USEOUTPUTWINDOW, PROPERTY_NAME_USEOUTPUTWINDOW, this.isOutputWindow() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
    }

    private void saveIDPropertyOptionsToOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_NOTSORTED, PROPERTY_NAME_NOTSORTED, PROPERTY_NAME_NOTSORTED, this.isNotSorted() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_INTERVAL, PROPERTY_NAME_INTERVAL, PROPERTY_NAME_INTERVAL, this.getInterval(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_ACCUMULATE, PROPERTY_NAME_ACCUMULATE, PROPERTY_NAME_ACCUMULATE, this.getAccumulate(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_SETMISSING, PROPERTY_NAME_SETMISSING, PROPERTY_NAME_SETMISSING, this.getSetMissing(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_ZEROMISS, PROPERTY_NAME_ZEROMISS, PROPERTY_NAME_ZEROMISS, this.getZeroMissing(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_START, PROPERTY_NAME_START, PROPERTY_NAME_START, this.getStartDate(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_END, PROPERTY_NAME_END, PROPERTY_NAME_END, this.getEndDate(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_INTERVALFORMAT, PROPERTY_NAME_INTERVALFORMAT, PROPERTY_NAME_INTERVALFORMAT, this.getIntervalFormat(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, ID_VARIABLE_PROPERTY_NAME, ID_VARIABLE_PROPERTY_NAME, ID_VARIABLE_PROPERTY_NAME, "", 12, 16);
        IPersistableObject[] cols = null;
        cols = this.m_oIdColumn != null ? new IColumn[]{this.m_oIdColumn} : new IColumn[]{};
        this.saveObjectListPropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, ID_VARIABLE_PROPERTY_NAME, ID_VARIABLE_PROPERTY_NAME, ID_VARIABLE_PROPERTY_NAME, cols, 12, 16);
    }

    private void saveForecastPropertyOptionsToOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_REPLACEMISSING, PROPERTY_NAME_REPLACEMISSING, PROPERTY_NAME_REPLACEMISSING, this.isReplaceMissing() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_MEDIAN, PROPERTY_NAME_MEDIAN, PROPERTY_NAME_MEDIAN, this.isEstimateMedian() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_USE, PROPERTY_NAME_USE, PROPERTY_NAME_USE, this.getUse(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_MODEL, PROPERTY_NAME_MODEL, PROPERTY_NAME_MODEL, this.getModelOption(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_SELECT, PROPERTY_NAME_SELECT, PROPERTY_NAME_SELECT, this.getModelSelection(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_TRANSFORM, PROPERTY_NAME_TRANSFORM, PROPERTY_NAME_TRANSFORM, this.getTransform(), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_ALPHA, PROPERTY_NAME_ALPHA, PROPERTY_NAME_ALPHA, Double.toString(this.getAlpha()), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_HOLDOUTPCT, PROPERTY_NAME_HOLDOUTPCT, PROPERTY_NAME_HOLDOUTPCT, Double.toString(this.getHoldoutPercent()), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_INTERMITTENT, PROPERTY_NAME_INTERMITTENT, PROPERTY_NAME_INTERMITTENT, Double.toString(this.getIntermittent()), 12, 16);
        this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_HOLDOUT, PROPERTY_NAME_HOLDOUT, PROPERTY_NAME_HOLDOUT, Integer.toString(this.getHoldout()), 12, 16);
        IPersistableObject[] cols = null;
        cols = !this.getForecastColumns().isEmpty() ? this.getForecastColumns().toArray(new IColumn[this.getForecastColumns().size()]) : new IColumn[]{};
        this.saveObjectListPropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, FORECAST_VARIABLE_PROPERTY_NAME, FORECAST_VARIABLE_PROPERTY_NAME, FORECAST_VARIABLE_PROPERTY_NAME, cols, 12, 16);
    }

    private void savePrintPropertyOptionsToOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        HashSet setOpts = new HashSet(this.m_lSelectedPrintOpts);
        for (int iOption = 0; iOption < PRINTOPTIONS.length; ++iOption) {
            String sOption;
            boolean bYes = setOpts.contains(sOption = PRINTOPTIONS[iOption]);
            this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_PRINT, sOption, sOption, sOption, bYes ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        }
    }

    private void savePlotPropertyOptionsToOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        HashSet setOpts = new HashSet(this.m_lSelectedPlotOpts);
        for (int iOption = 0; iOption < PLOTOPTIONS.length; ++iOption) {
            String sOption;
            boolean bYes = setOpts.contains(sOption = PLOTOPTIONS[iOption]);
            this.savePropertyToOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_PLOT, sOption, sOption, sOption, bYes ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        }
    }

    private void saveHPFDocumentToOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        IDocument oHPFDocument;
        AssociationList docs = mdoStep.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            Document metaDoc = (Document)docs.get(i);
            if (!metaDoc.getTextRole().equals(TARGET_HPFDOCUMENT_TEXTROLE)) continue;
            docs.remove(i);
            break;
        }
        if ((oHPFDocument = this.getHPFDocument()) == null) {
            return;
        }
        oHPFDocument.saveToOMR(omr);
        Document doc = (Document)omr.acquireOMRObject(oHPFDocument);
        doc.setTextRole(TARGET_HPFDOCUMENT_TEXTROLE);
        doc.setTextType(TARGET_HPFDOCUMENT_TEXTTYPE);
        doc.setURIType(TARGET_HPFDOCUMENT_URITYPE);
        if (!docs.contains(doc)) {
            docs.add(doc);
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_order != null) {
            this.m_order.updateIDs(mapIDs);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        Select mdoSelect = (Select)this.getClassifierMapObject(omr);
        this.loadHPFPropertyOptionsFromOMR(omr, mdoSelect);
        this.loadIDPropertyOptionsFromOMR(omr, mdoSelect);
        this.loadForecastPropertyOptionsFromOMR(omr, mdoSelect);
        this.loadPrintPropertyOptionsFromOMR(omr, mdoSelect);
        this.loadPlotPropertyOptionsFromOMR(omr, mdoSelect);
        OrderByClause mdoOrder = mdoSelect.getOrderByForSelect();
        if (mdoOrder != null) {
            this.setSortOrder((ISorting)omr.acquireObject((Root)mdoOrder));
        }
        this.loadHPFDocumentFromOMR(omr, mdoStep);
        boolean bNeedCleanup = false;
        IWorkTable[] aTables = this.getWorkTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            IWorkTable table = aTables[iTable];
            if (table.getColumnCount() != 0) continue;
            bNeedCleanup = true;
        }
        if (bNeedCleanup) {
            this.doCleanUpRecovery();
        }
        this.setChanged(bNeedCleanup);
    }

    @Override
    protected boolean doCleanUpRecovery() {
        IWorkTable[] aTables = this.getWorkTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            IWorkTable table = aTables[iTable];
            if (table.getColumnCount() != 0) continue;
            this.removeDataTarget(table);
        }
        return true;
    }

    private int getInteger(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    private void loadHPFPropertyOptionsFromOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        this.setLead(this.getInteger(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_LEAD, Integer.toString(12), 0)));
        this.setBack(this.getInteger(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_BACK, Integer.toString(0), 0)));
        this.setSeasonality(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_SEASONALITY, "", 0));
        this.setSortedVariables(!this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_SORTNAMES, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_NO));
        this.setGreaterDetails(!this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_PRINTDETAILS, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_NO));
        this.setOutputWindow(!this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_HPF, PROPERTY_NAME_USEOUTPUTWINDOW, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_NO));
    }

    private void loadIDPropertyOptionsFromOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        this.setInterval(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_INTERVAL, "", 0));
        this.setAccumulate(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_ACCUMULATE, "NONE", 0));
        this.setSetMissing(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_SETMISSING, "MISSING", 0));
        this.setZeroMissing(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_ZEROMISS, "NONE", 0));
        this.setStartDate(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_START, "", 0));
        this.setEndDate(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_END, "", 0));
        this.setIntervalFormat(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_INTERVALFORMAT, "", 0));
        this.setNotSorted(!this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, PROPERTY_NAME_NOTSORTED, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_NO));
        IPersistableObject[] aObjects = this.loadObjectListPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_ID, ID_VARIABLE_PROPERTY_NAME, 0);
        IColumn idColumn = null;
        for (int i = aObjects.length - 1; i >= 0; --i) {
            if (!(aObjects[i] instanceof IColumn)) continue;
            idColumn = (IColumn)aObjects[i];
            break;
        }
        this.setIdColumn(idColumn);
    }

    private void loadForecastPropertyOptionsFromOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        this.setUse(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_USE, "PREDICT", 0));
        this.setModelOption(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_MODEL, "BEST", 0));
        this.setModelSelection(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_SELECT, "RMSE", 0));
        this.setTransform(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_TRANSFORM, "NONE", 0));
        this.setAlpha(Double.parseDouble(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_ALPHA, Double.toString(0.05), 0)));
        this.setHoldoutPercent(Double.parseDouble(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_HOLDOUTPCT, Double.toString(100.0), 0)));
        this.setIntermittent(Double.parseDouble(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_INTERMITTENT, Double.toString(1.25), 0)));
        this.setHoldout(this.getInteger(this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_HOLDOUT, Integer.toString(0), 0)));
        this.setReplaceMissing(!this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_REPLACEMISSING, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_NO));
        this.setEstimateMedian(!this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, PROPERTY_NAME_MEDIAN, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_NO));
        this.m_lForecastColumns.clear();
        IPersistableObject[] aObjects = this.loadObjectListPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_FORECAST, FORECAST_VARIABLE_PROPERTY_NAME, 0);
        for (int i = 0; i < aObjects.length; ++i) {
            if (!(aObjects[i] instanceof IColumn)) continue;
            this.getForecastColumns().add(aObjects[i]);
        }
    }

    private void loadPrintPropertyOptionsFromOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        this.m_lSelectedPrintOpts.clear();
        for (int iOption = 0; iOption < PRINTOPTIONS.length; ++iOption) {
            String sOption = PRINTOPTIONS[iOption];
            String sValue = this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_PRINT, sOption, DEFAULT_VALUE_NO, 0);
            if (sValue.equals(DEFAULT_VALUE_NO)) continue;
            this.m_lSelectedPrintOpts.add(sOption);
        }
    }

    private void loadPlotPropertyOptionsFromOMR(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        this.m_lSelectedPlotOpts.clear();
        for (int iOption = 0; iOption < PLOTOPTIONS.length; ++iOption) {
            String sOption = PLOTOPTIONS[iOption];
            String sValue = this.loadPropertyFromOMR(omr, (Root)mdoSelect, PROPERTY_SET_NAME_PLOT, sOption, DEFAULT_VALUE_NO, 0);
            if (sValue.equals(DEFAULT_VALUE_NO)) continue;
            this.m_lSelectedPlotOpts.add(sOption);
        }
    }

    private void loadHPFDocumentFromOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        mdoStep.getDocuments();
        AssociationList docs = mdoStep.getDocuments(false).getState() == 0 ? mdoStep.getDocuments(true) : mdoStep.getDocuments(false);
        if (mdoStep != null) {
            for (int i = 0; i < docs.size(); ++i) {
                if (!((Document)docs.get(i)).getTextRole().equals(TARGET_HPFDOCUMENT_TEXTROLE)) continue;
                Document doc = (Document)docs.get(i);
                this.addDataTarget((IDocument)omr.acquireObject((Root)doc));
            }
        }
    }

    @Override
    protected IMapping createMapping(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        IPersistableObject obj = (IPersistableObject)this.getModel().getObject(mdoFM.getFQID());
        if (obj != null && obj instanceof IMapping) {
            return (IMapping)obj;
        }
        HPFMapping mapping = this.getModel().getObjectFactory().createHPFMapping(mdoFM.getFQID());
        mapping.loadFromOMR(omr);
        return mapping;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_order != null) {
            this.m_order.dispose();
        }
    }

    @Override
    public void delete() {
        super.delete();
        if (this.m_order != null) {
            this.m_order.delete();
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.m_order != null) {
            this.m_order.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        HPFCodegen2 cg = new HPFCodegen2(this);
        cg.getGeneratedCode(codeSegment);
        return codeSegment;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.areForecastColumnsAvailable();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.areForecastColumnsAvailable()) {
            lReasons.add(RB.getStringResource("HPFTransformModel.ReasonIncomplete.NoForecastColumns.txt"));
        }
        return lReasons;
    }

    private boolean areForecastColumnsAvailable() {
        List forecastVarsList1 = this.getForecastColumns();
        List forecastVarsList = new ArrayList(forecastVarsList1);
        List possibleForecastColumns = this.getPossibleForecastColumns();
        if (forecastVarsList == null || forecastVarsList.isEmpty() && possibleForecastColumns != null) {
            forecastVarsList = possibleForecastColumns;
        } else {
            if (possibleForecastColumns != null) {
                forecastVarsList.retainAll(possibleForecastColumns);
            }
            if (forecastVarsList.isEmpty()) {
                forecastVarsList = possibleForecastColumns;
            }
        }
        return forecastVarsList != null && !forecastVarsList.isEmpty();
    }

    @Override
    public List<IObject> pasteAction() throws MdException, RemoteException {
        ArrayList<IObject> lst = new ArrayList<IObject>(super.pasteAction());
        IDocument oDocument = this.getHPFDocument();
        if (oDocument != null) {
            this.removeDataTarget(oDocument);
            String sDocumentName = WsMetadataNameUtil.getUniqueNameForType((String)"Document", (String)MessageFormat.format(RB.getStringResource("HPFTransformModel.DocumentNameCopy.txt"), oDocument.getName()));
            oDocument = this.createHPFDocument(sDocumentName);
            this.addDataTarget(oDocument);
            lst.add(oDocument);
        }
        return lst;
    }

    private class SetLeadUndoable
    extends AbstractUndoableEdit {
        private int m_iOldLead;
        private int m_iNewLead;

        public SetLeadUndoable(int iOldLead, int iNewLead) {
            this.m_iOldLead = iOldLead;
            this.m_iNewLead = iNewLead;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setLead(this.m_iOldLead);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setLead(this.m_iNewLead);
        }
    }

    private class SetBackUndoable
    extends AbstractUndoableEdit {
        private int m_iOldBack;
        private int m_iNewBack;

        public SetBackUndoable(int iOldBack, int iNewBack) {
            this.m_iOldBack = iOldBack;
            this.m_iNewBack = iNewBack;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setBack(this.m_iOldBack);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setBack(this.m_iNewBack);
        }
    }

    private class SetSeasonalityUndoable
    extends AbstractUndoableEdit {
        private String m_sOldSeasonality;
        private String m_sNewSeasonality;

        public SetSeasonalityUndoable(String sOldSeasonality, String sNewSeasonality) {
            this.m_sOldSeasonality = sOldSeasonality;
            this.m_sNewSeasonality = sNewSeasonality;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setSeasonality(this.m_sOldSeasonality);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setSeasonality(this.m_sNewSeasonality);
        }
    }

    private class SetSortedVariablesUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldSortedVariables;
        private boolean m_bNewSortedVariables;

        public SetSortedVariablesUndoable(boolean bOldSortedVariables, boolean bNewSortedVariables) {
            this.m_bOldSortedVariables = bOldSortedVariables;
            this.m_bNewSortedVariables = bNewSortedVariables;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setSortedVariables(this.m_bOldSortedVariables);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setSortedVariables(this.m_bNewSortedVariables);
        }
    }

    private class SetGreaterDetailsUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldGreaterDetails;
        private boolean m_bNewGreaterDetails;

        public SetGreaterDetailsUndoable(boolean bOldGreaterDetails, boolean bNewGreaterDetails) {
            this.m_bOldGreaterDetails = bOldGreaterDetails;
            this.m_bNewGreaterDetails = bNewGreaterDetails;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setGreaterDetails(this.m_bOldGreaterDetails);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setGreaterDetails(this.m_bNewGreaterDetails);
        }
    }

    private class SetOutputWindowUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldOutputWindow;
        private boolean m_bNewOutputWindow;

        public SetOutputWindowUndoable(boolean bOldOutputWindow, boolean bNewOutputWindow) {
            this.m_bOldOutputWindow = bOldOutputWindow;
            this.m_bNewOutputWindow = bNewOutputWindow;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setOutputWindow(this.m_bOldOutputWindow);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setOutputWindow(this.m_bNewOutputWindow);
        }
    }

    private class SetIdColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oOldIdColumn;
        private IColumn m_oNewIdColumn;

        public SetIdColumnUndoable(IColumn oOldIdColumn, IColumn oNewIdColumn) {
            this.m_oOldIdColumn = oOldIdColumn;
            this.m_oNewIdColumn = oNewIdColumn;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setIdColumn(this.m_oOldIdColumn);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setIdColumn(this.m_oNewIdColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_oNewIdColumn = null;
            this.m_oOldIdColumn = null;
        }
    }

    private class SetNotSortedUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldNotSorted;
        private boolean m_bNewNotSorted;

        public SetNotSortedUndoable(boolean bOldNotSorted, boolean bNewNotSorted) {
            this.m_bOldNotSorted = bOldNotSorted;
            this.m_bNewNotSorted = bNewNotSorted;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setNotSorted(this.m_bOldNotSorted);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setNotSorted(this.m_bNewNotSorted);
        }
    }

    private class SetIntervalUndoable
    extends AbstractUndoableEdit {
        private String m_sOldInterval;
        private String m_sNewInterval;

        public SetIntervalUndoable(String sOldInterval, String sNewInterval) {
            this.m_sOldInterval = sOldInterval;
            this.m_sNewInterval = sNewInterval;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setInterval(this.m_sOldInterval);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setInterval(this.m_sNewInterval);
        }
    }

    private class SetAccumulateUndoable
    extends AbstractUndoableEdit {
        private String m_sOldAccumulate;
        private String m_sNewAccumulate;

        public SetAccumulateUndoable(String sOldAccumulate, String sNewAccumulate) {
            this.m_sOldAccumulate = sOldAccumulate;
            this.m_sNewAccumulate = sNewAccumulate;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setAccumulate(this.m_sOldAccumulate);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setAccumulate(this.m_sNewAccumulate);
        }
    }

    private class SetSetMissingUndoable
    extends AbstractUndoableEdit {
        private String m_sOldSetMissing;
        private String m_sNewSetMissing;

        public SetSetMissingUndoable(String sOldSetMissing, String sNewSetMissing) {
            this.m_sOldSetMissing = sOldSetMissing;
            this.m_sNewSetMissing = sNewSetMissing;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setSetMissing(this.m_sOldSetMissing);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setSetMissing(this.m_sNewSetMissing);
        }
    }

    private class SetZeroMissingUndoable
    extends AbstractUndoableEdit {
        private String m_sOldZeroMissing;
        private String m_sNewZeroMissing;

        public SetZeroMissingUndoable(String sOldZeroMissing, String sNewZeroMissing) {
            this.m_sOldZeroMissing = sOldZeroMissing;
            this.m_sNewZeroMissing = sNewZeroMissing;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setZeroMissing(this.m_sOldZeroMissing);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setZeroMissing(this.m_sNewZeroMissing);
        }
    }

    private class SetStartDateUndoable
    extends AbstractUndoableEdit {
        private String m_sOldStartDate;
        private String m_sNewStartDate;

        public SetStartDateUndoable(String sOldStartDate, String sNewStartDate) {
            this.m_sOldStartDate = sOldStartDate;
            this.m_sNewStartDate = sNewStartDate;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setStartDate(this.m_sOldStartDate);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setStartDate(this.m_sNewStartDate);
        }
    }

    private class SetEndDateUndoable
    extends AbstractUndoableEdit {
        private String m_sOldEndDate;
        private String m_sNewEndDate;

        public SetEndDateUndoable(String sOldEndDate, String sNewEndDate) {
            this.m_sOldEndDate = sOldEndDate;
            this.m_sNewEndDate = sNewEndDate;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setEndDate(this.m_sOldEndDate);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setEndDate(this.m_sNewEndDate);
        }
    }

    private class SetIntervalFormatUndoable
    extends AbstractUndoableEdit {
        private String m_sOldIntervalFormat;
        private String m_sNewIntervalFormat;

        public SetIntervalFormatUndoable(String sOldIntervalFormat, String sNewIntervalFormat) {
            this.m_sOldIntervalFormat = sOldIntervalFormat;
            this.m_sNewIntervalFormat = sNewIntervalFormat;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setIntervalFormat(this.m_sOldIntervalFormat);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setIntervalFormat(this.m_sNewIntervalFormat);
        }
    }

    private class SetUseUndoable
    extends AbstractUndoableEdit {
        private String m_sOldUse;
        private String m_sNewUse;

        public SetUseUndoable(String sOldUse, String sNewUse) {
            this.m_sOldUse = sOldUse;
            this.m_sNewUse = sNewUse;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setUse(this.m_sOldUse);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setUse(this.m_sNewUse);
        }
    }

    private class SetModelUndoable
    extends AbstractUndoableEdit {
        private String m_sOldModel;
        private String m_sNewModel;

        public SetModelUndoable(String sOldModel, String sNewModel) {
            this.m_sOldModel = sOldModel;
            this.m_sNewModel = sNewModel;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setModelOption(this.m_sOldModel);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setModelOption(this.m_sNewModel);
        }
    }

    private class SetModelSelectionUndoable
    extends AbstractUndoableEdit {
        private String m_sOldModelSelection;
        private String m_sNewModelSelection;

        public SetModelSelectionUndoable(String sOldModelSelection, String sNewModelSelection) {
            this.m_sOldModelSelection = sOldModelSelection;
            this.m_sNewModelSelection = sNewModelSelection;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setModelSelection(this.m_sOldModelSelection);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setModelSelection(this.m_sNewModelSelection);
        }
    }

    private class SetTransformUndoable
    extends AbstractUndoableEdit {
        private String m_sOldTransform;
        private String m_sNewTransform;

        public SetTransformUndoable(String sOldTransform, String sNewTransform) {
            this.m_sOldTransform = sOldTransform;
            this.m_sNewTransform = sNewTransform;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setTransform(this.m_sOldTransform);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setTransform(this.m_sNewTransform);
        }
    }

    private class SetReplaceMissingUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldReplaceMissing;
        private boolean m_bNewReplaceMissing;

        public SetReplaceMissingUndoable(boolean bOldReplaceMissing, boolean bNewReplaceMissing) {
            this.m_bOldReplaceMissing = bOldReplaceMissing;
            this.m_bNewReplaceMissing = bNewReplaceMissing;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setReplaceMissing(this.m_bOldReplaceMissing);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setReplaceMissing(this.m_bNewReplaceMissing);
        }
    }

    private class SetEstimateMedianUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldEstimateMedian;
        private boolean m_bNewEstimateMedian;

        public SetEstimateMedianUndoable(boolean bOldEstimateMedian, boolean bNewEstimateMedian) {
            this.m_bOldEstimateMedian = bOldEstimateMedian;
            this.m_bNewEstimateMedian = bNewEstimateMedian;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setEstimateMedian(this.m_bOldEstimateMedian);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setEstimateMedian(this.m_bNewEstimateMedian);
        }
    }

    private class SetAlphaUndoable
    extends AbstractUndoableEdit {
        private double m_dOldAlpha;
        private double m_dNewAlpha;

        public SetAlphaUndoable(double dOldAlpha, double dNewAlpha) {
            this.m_dOldAlpha = dOldAlpha;
            this.m_dNewAlpha = dNewAlpha;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setAlpha(this.m_dOldAlpha);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setAlpha(this.m_dNewAlpha);
        }
    }

    private class SetHoldoutPercentUndoable
    extends AbstractUndoableEdit {
        private double m_dOldHoldoutPercent;
        private double m_dNewHoldoutPercent;

        public SetHoldoutPercentUndoable(double dOldHoldoutPercent, double dNewHoldoutPercent) {
            this.m_dOldHoldoutPercent = dOldHoldoutPercent;
            this.m_dNewHoldoutPercent = dNewHoldoutPercent;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setHoldoutPercent(this.m_dOldHoldoutPercent);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setHoldoutPercent(this.m_dNewHoldoutPercent);
        }
    }

    private class SetIntermittentUndoable
    extends AbstractUndoableEdit {
        private double m_dOldIntermittent;
        private double m_dNewIntermittent;

        public SetIntermittentUndoable(double dOldIntermittent, double dNewIntermittent) {
            this.m_dOldIntermittent = dOldIntermittent;
            this.m_dNewIntermittent = dNewIntermittent;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setIntermittent(this.m_dOldIntermittent);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setIntermittent(this.m_dNewIntermittent);
        }
    }

    private class SetHoldoutUndoable
    extends AbstractUndoableEdit {
        private int m_iOldHoldout;
        private int m_iNewHoldout;

        public SetHoldoutUndoable(int iOldHoldout, int iNewHoldout) {
            this.m_iOldHoldout = iOldHoldout;
            this.m_iNewHoldout = iNewHoldout;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setHoldout(this.m_iOldHoldout);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setHoldout(this.m_iNewHoldout);
        }
    }

    private class AddPrintOptionUndoable
    extends AbstractUndoableEdit {
        private String m_sOption;

        public AddPrintOptionUndoable(String sOption) {
            this.m_sOption = sOption;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.removePrintOption(this.m_sOption);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.addPrintOption(this.m_sOption);
        }
    }

    private class AddPlotOptionUndoable
    extends AbstractUndoableEdit {
        private String m_sOption;

        public AddPlotOptionUndoable(String sOption) {
            this.m_sOption = sOption;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.removePlotOption(this.m_sOption);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.addPlotOption(this.m_sOption);
        }
    }

    private class RemovePrintOptionUndoable
    extends AbstractUndoableEdit {
        private String m_sOption;

        public RemovePrintOptionUndoable(String sOption) {
            this.m_sOption = sOption;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.addPrintOption(this.m_sOption);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.removePrintOption(this.m_sOption);
        }
    }

    private class RemovePlotOptionUndoable
    extends AbstractUndoableEdit {
        private String m_sOption;

        public RemovePlotOptionUndoable(String sOption) {
            this.m_sOption = sOption;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.addPlotOption(this.m_sOption);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.removePlotOption(this.m_sOption);
        }
    }

    private class SetSortOrderChangedUndoable
    extends AbstractUndoableEdit {
        private ISorting m_oldSortOrder;
        private ISorting m_newSortOrder;

        public SetSortOrderChangedUndoable(ISorting oldSortOrder, ISorting newSortOrder) {
            this.m_oldSortOrder = oldSortOrder;
            this.m_newSortOrder = newSortOrder;
        }

        @Override
        public void undo() {
            super.undo();
            HPFTransformModel.this.setSortOrder(this.m_oldSortOrder);
        }

        @Override
        public void redo() {
            super.redo();
            HPFTransformModel.this.setSortOrder(this.m_newSortOrder);
        }

        @Override
        public void die() {
            this.m_newSortOrder = null;
            this.m_oldSortOrder = null;
        }
    }
}

