/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.hpf;

import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDocument;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.hpf.HPFTransformModel;
import com.sas.etl.models.job.transforms.hpf.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HPFCodegen2 {
    private static HPFTransformModel m_oHPFTModel;

    public HPFCodegen2(HPFTransformModel model) {
        m_oHPFTModel = model;
    }

    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws BadLibraryDefinitionException, CodegenException, RemoteException, BadServerDefinitionException, ServerException, MdException {
        IColumn idColumn;
        int i;
        String tableOptions;
        ITransformTableOptions sourceOptions;
        boolean enablePrint;
        IDocument iDoc = m_oHPFTModel.getHPFDocument();
        List<String> l_selectedPrintOptions = Arrays.asList(m_oHPFTModel.getSelectedPrintOptions());
        List<String> l_selectedPlotOptions = Arrays.asList(m_oHPFTModel.getSelectedPlotOptions());
        boolean bl = enablePrint = iDoc != null && (!l_selectedPrintOptions.isEmpty() || !l_selectedPlotOptions.isEmpty());
        if (enablePrint) {
            String docPath = iDoc.getURI();
            String directory = "";
            String frameFile = "";
            if (docPath.indexOf(47) > -1) {
                directory = docPath.substring(0, docPath.lastIndexOf(47) + 1);
                frameFile = docPath.substring(docPath.lastIndexOf(47) + 1);
            } else if (docPath.indexOf(92) > -1) {
                directory = docPath.substring(0, docPath.lastIndexOf(92) + 1);
                frameFile = docPath.substring(docPath.lastIndexOf(92) + 1);
            } else {
                directory = "";
                frameFile = docPath;
            }
            String contentFile = "";
            String bodyFile = "";
            int dot = frameFile.lastIndexOf(46);
            if (dot <= -1 || dot == frameFile.length() - 1) {
                throw new CodegenException(RB.getStringResource("HPFCodegen2.DocumentExtensionInvalid.msg.txt"), (IObject)iDoc);
            }
            String baseName = frameFile.substring(0, dot);
            String extension = frameFile.substring(dot);
            contentFile = baseName + "_c" + extension;
            bodyFile = baseName + "_b" + extension;
            if (!m_oHPFTModel.isOutputWindow()) {
                codeSegment.addSourceCode("ods listing close;\n");
            }
            if (!l_selectedPlotOptions.isEmpty()) {
                codeSegment.addSourceCode("ods graphics on / imagefmt = static;\n");
            }
            codeSegment.addSourceCode("ods html path = \"" + directory + "\" (url = none)\n");
            codeSegment.indent(3).addSourceCode("frame = \"" + frameFile + "\"\n");
            codeSegment.addSourceCode("contents = \"" + contentFile + "\"\n");
            codeSegment.addSourceCode("body = \"" + bodyFile + "\"\n").unIndent(3);
            codeSegment.addSourceCode(";\n\n");
        }
        codeSegment.addSourceCode("proc hpf data = &SYSLAST\n");
        IPhysicalTable sourceTable = m_oHPFTModel.getSourceTable();
        if (sourceTable != null && (sourceOptions = m_oHPFTModel.getTableOptionObject(sourceTable, true)) != null && (tableOptions = sourceOptions.getTableOptions(codeSegment.getCurrentServer())).length() > 0) {
            codeSegment.indent().addSourceCode("(" + tableOptions + ") \n").unIndent();
        }
        IPhysicalTable outTable = m_oHPFTModel.getForecastsOfVariablesTable();
        IPhysicalTable outestTable = m_oHPFTModel.getModelParameterEstimatesTable();
        IPhysicalTable outforTable = m_oHPFTModel.getForecastTimeSeriesComponentsTable();
        IPhysicalTable outseasonTable = m_oHPFTModel.getSeasonalStatisticsTable();
        IPhysicalTable outstatTable = m_oHPFTModel.getStatisticsOfFitTable();
        IPhysicalTable outsumTable = m_oHPFTModel.getSummaryStatisticsTable();
        IPhysicalTable outtrendTable = m_oHPFTModel.getTrendStatisticsTable();
        codeSegment.indent(3);
        if (outTable != null) {
            this.generateOutStatement(codeSegment, outTable, "OUT");
        }
        if (outestTable != null) {
            this.generateOutStatement(codeSegment, outestTable, "OUTEST");
        }
        if (outforTable != null) {
            this.generateOutStatement(codeSegment, outforTable, "OUTFOR");
        }
        if (outseasonTable != null) {
            this.generateOutStatement(codeSegment, outseasonTable, "OUTSEASON");
        }
        if (outstatTable != null) {
            this.generateOutStatement(codeSegment, outstatTable, "OUTSTAT");
        }
        if (outsumTable != null) {
            this.generateOutStatement(codeSegment, outsumTable, "OUTSUM");
        }
        if (outtrendTable != null) {
            this.generateOutStatement(codeSegment, outtrendTable, "OUTTREND");
        }
        if (m_oHPFTModel.getBack() != 0) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_BACK, Integer.toString(m_oHPFTModel.getBack()));
        }
        if (m_oHPFTModel.getLead() != 12) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_LEAD, Integer.toString(m_oHPFTModel.getLead()));
        }
        if (!m_oHPFTModel.getSeasonality().equals("")) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_SEASONALITY, m_oHPFTModel.getSeasonality());
        }
        if (m_oHPFTModel.isSortedVariables()) {
            codeSegment.addSourceCode(HPFTransformModel.PROPERTY_NAME_SORTNAMES + "\n");
        }
        if (m_oHPFTModel.isGreaterDetails()) {
            codeSegment.addSourceCode(HPFTransformModel.PROPERTY_NAME_PRINTDETAILS + "\n");
        }
        if (!l_selectedPrintOptions.isEmpty() && (m_oHPFTModel.isOutputWindow() || iDoc != null)) {
            codeSegment.addSourceCode("print=(\n").indent(2);
            for (i = 0; i < l_selectedPrintOptions.size(); ++i) {
                codeSegment.addSourceCode(l_selectedPrintOptions.get(i) + "\n");
            }
            codeSegment.addSourceCode(")\n").unIndent(2);
        }
        if (enablePrint && !l_selectedPlotOptions.isEmpty()) {
            codeSegment.addSourceCode("plot=(\n").indent(2);
            for (i = 0; i < l_selectedPlotOptions.size(); ++i) {
                codeSegment.addSourceCode(l_selectedPlotOptions.get(i) + "\n");
            }
            codeSegment.addSourceCode(")\n").unIndent(2);
        }
        codeSegment.unIndent(3);
        codeSegment.addSourceCode("; \n");
        if (m_oHPFTModel.getSortOrder() != null) {
            codeSegment.indent();
            m_oHPFTModel.getSortOrder().getGeneratedCode(codeSegment, false);
            codeSegment.unIndent();
        }
        if ((idColumn = m_oHPFTModel.getIdColumn()) != null) {
            this.generateIDStatement(codeSegment, idColumn);
        }
        this.generateForecastStatement(codeSegment);
        codeSegment.addSourceCode("run; \n\n");
        if (enablePrint) {
            codeSegment.addSourceCode("ods html close;\n");
            if (!m_oHPFTModel.isOutputWindow()) {
                codeSegment.addSourceCode("ods listing;\n");
            }
            if (!l_selectedPlotOptions.isEmpty()) {
                codeSegment.addSourceCode("ods graphics off;\n\n");
            }
        }
        return codeSegment;
    }

    private ICodeSegment generateOutStatement(ICodeSegment codeSegment, IPhysicalTable table, String sTableRole) throws BadLibraryDefinitionException {
        String tableOptions;
        codeSegment.addSourceCode(sTableRole + " = " + table.getFullNameQuotedAsNeeded(codeSegment) + "\n");
        ITransformTableOptions sourceOptions = m_oHPFTModel.getTableOptionObject(table, false);
        if (sourceOptions != null && (tableOptions = sourceOptions.getTableOptions(codeSegment.getCurrentServer())).length() > 0) {
            codeSegment.indent().addSourceCode("(" + tableOptions + ") \n").unIndent();
        }
        return codeSegment;
    }

    private ICodeSegment generateNonDateOption(ICodeSegment codeSegment, String optionName, String optionValue) {
        codeSegment.addSourceCode(optionName + " = " + optionValue + "\n");
        return codeSegment;
    }

    private ICodeSegment generateDateOption(ICodeSegment codeSegment, String optionName, String optionValue) {
        codeSegment.addSourceCode(optionName + " = '" + optionValue + "'d\n");
        return codeSegment;
    }

    private ICodeSegment generateIDStatement(ICodeSegment codeSegment, IColumn idColumn) {
        List numericColumns = this.getNumericSourceColumns();
        if (idColumn != null && numericColumns != null && numericColumns.size() > 0 && numericColumns.contains(idColumn)) {
            codeSegment.indent(1).addSourceCode("id " + idColumn.getColumnName(codeSegment) + "\n");
            codeSegment.indent(1);
            if (!m_oHPFTModel.getInterval().equalsIgnoreCase("")) {
                this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_INTERVAL, m_oHPFTModel.getInterval());
            }
            if (!m_oHPFTModel.getAccumulate().equalsIgnoreCase("NONE")) {
                this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_ACCUMULATE, m_oHPFTModel.getAccumulate());
            }
            if (m_oHPFTModel.isNotSorted()) {
                codeSegment.addSourceCode(HPFTransformModel.PROPERTY_NAME_NOTSORTED + "\n");
            }
            if (!m_oHPFTModel.getStartDate().equalsIgnoreCase("")) {
                this.generateDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_START, m_oHPFTModel.getStartDate());
            }
            if (!m_oHPFTModel.getEndDate().equalsIgnoreCase("")) {
                this.generateDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_END, m_oHPFTModel.getEndDate());
            }
            if (!m_oHPFTModel.getSetMissing().equalsIgnoreCase("MISSING")) {
                this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_SETMISSING, m_oHPFTModel.getSetMissing());
            }
            if (!m_oHPFTModel.getZeroMissing().equalsIgnoreCase("NONE")) {
                this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_ZEROMISS, m_oHPFTModel.getZeroMissing());
            }
            codeSegment.unIndent(1).addSourceCode("; \n").unIndent(1);
        }
        return codeSegment;
    }

    private ICodeSegment generateForecastStatement(ICodeSegment codeSegment) throws CodegenException {
        String model;
        List forecastVarsList1 = m_oHPFTModel.getForecastColumns();
        List forecastVarsList = new ArrayList(forecastVarsList1);
        List possibleForecastColumns = this.getPossibleForecastColumns();
        if (forecastVarsList == null || forecastVarsList.isEmpty() && possibleForecastColumns != null) {
            forecastVarsList = possibleForecastColumns;
        } else {
            if (possibleForecastColumns != null) {
                forecastVarsList.retainAll(possibleForecastColumns);
            }
            if (forecastVarsList.isEmpty()) {
                forecastVarsList = possibleForecastColumns;
            }
        }
        if (forecastVarsList == null || forecastVarsList.isEmpty()) {
            throw new CodegenException(RB.getStringResource("HPFCodegen2.NoForecastColumns.Error.msg.txt"), null);
        }
        codeSegment.indent(1).addSourceCode("forecast ");
        String sForecastVars = codeSegment.makeColumnList(forecastVarsList, "      ", false);
        codeSegment.addSourceCode(sForecastVars);
        codeSegment.addSourceCode(" / \n").indent(3);
        if (m_oHPFTModel.getAlpha() != 0.05) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_ALPHA, Double.toString(m_oHPFTModel.getAlpha()));
        }
        if (m_oHPFTModel.getHoldout() != 0) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_HOLDOUT, Integer.toString(m_oHPFTModel.getHoldout()));
        }
        if (m_oHPFTModel.getHoldout() > 0 && m_oHPFTModel.getHoldoutPercent() != 100.0) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_HOLDOUTPCT, Double.toString(m_oHPFTModel.getHoldoutPercent()));
        }
        if ((model = m_oHPFTModel.getModelOption()).equalsIgnoreCase("BESTALL") && m_oHPFTModel.getIntermittent() != 1.25) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_INTERMITTENT, Double.toString(m_oHPFTModel.getIntermittent()));
        }
        if (m_oHPFTModel.isEstimateMedian()) {
            codeSegment.addSourceCode(HPFTransformModel.PROPERTY_NAME_MEDIAN + "\n");
        }
        if (!model.equals("BEST")) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_MODEL, m_oHPFTModel.getModelOption());
        }
        if (!m_oHPFTModel.getModelSelection().equalsIgnoreCase("RMSE")) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_SELECT, m_oHPFTModel.getModelSelection());
        }
        if (m_oHPFTModel.isReplaceMissing()) {
            codeSegment.addSourceCode(HPFTransformModel.PROPERTY_NAME_REPLACEMISSING + "\n");
        }
        if (!model.equalsIgnoreCase("IDM") && !m_oHPFTModel.getTransform().equalsIgnoreCase("NONE")) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_TRANSFORM, m_oHPFTModel.getTransform());
        }
        if (!m_oHPFTModel.getUse().equalsIgnoreCase("PREDICT")) {
            this.generateNonDateOption(codeSegment, HPFTransformModel.PROPERTY_NAME_USE, m_oHPFTModel.getUse());
        }
        codeSegment.unIndent(3).addSourceCode("; \n").unIndent(1);
        return codeSegment;
    }

    private List getNumericSourceColumns() {
        List<Object> trgColumns = new ArrayList();
        ArrayList<IColumn> numericColumns = new ArrayList<IColumn>();
        trgColumns = Arrays.asList(m_oHPFTModel.getSourceTable().getColumns());
        for (int j = 0; j < trgColumns.size(); ++j) {
            IColumn column = (IColumn)trgColumns.get(j);
            if (column.getType() != 1) continue;
            numericColumns.add(column);
        }
        return numericColumns;
    }

    private List getPossibleForecastColumns() {
        List columnList = null;
        columnList = this.getNumericSourceColumns();
        if (columnList != null) {
            List<IColumn> byVariables;
            IColumn idColumn = m_oHPFTModel.getIdColumn();
            if (idColumn != null) {
                columnList.remove(idColumn);
            }
            if ((byVariables = Arrays.asList(m_oHPFTModel.getSortOrder().getColumnObjects())) != null && !byVariables.isEmpty()) {
                columnList.removeAll(byVariables);
            }
        }
        return columnList;
    }
}

