/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.hpa;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.SASHDATType;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.hpa.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IHadoopServer;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SASHadoopDataUnloaderTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "SASHadoopDataUnloader";
    private static final String TRANSFORMATION_ROLE = "SASHadoopDataUnloader";
    private static final String ARM_DISPLAY_NAME = "SAS Data in HDFS Unloader";
    private static final String LIBRARY_PATH = "PATH";

    public SASHadoopDataUnloaderTransformModel(String sID, IModel model) {
        super(sID, model);
        this.setCollectSourceTableRowCounts(false);
    }

    @Override
    public String getDefaultName() {
        return RB.getStringResource("SASHadoopDataUnloaderTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("SASHadoopDataUnloaderTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getTransformRole() {
        return "SASHadoopDataUnloader";
    }

    @Override
    protected String getTransformClass() {
        return "SASHadoopDataUnloader";
    }

    public static String getTransformTypeID() {
        return "SASHadoopDataUnloader";
    }

    @Override
    public boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public boolean doesNoTargetsMeanIncomplete() {
        return false;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
    }

    @Override
    protected void postAddDataSource(IDataObject source) {
        super.postAddTransformTableOption(source, true);
        ITransformTableOptions sourceOptions = this.getTableOptionObject((IPhysicalTable)source, true);
        IPromptDefinitionValue def = sourceOptions.getOptionModel().findDefinition("DBSASLABEL");
        if (def != null) {
            def.setHidden(true);
            def.clearValue();
        }
        if ((def = sourceOptions.getOptionModel().findDefinition("DBCONDITION")) != null) {
            def.setHidden(true);
            def.clearValue();
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        if (this.getDataSourcesCount() > 0) {
            IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
            ITransformTableOptions sourceOptions = this.getTableOptionObject(source, true);
            IPromptDefinitionValue def = sourceOptions.getOptionModel().findDefinition("DBSASLABEL");
            try {
                if (def != null) {
                    def.setHidden(true);
                    def.clearValue();
                }
                if ((def = sourceOptions.getOptionModel().findDefinition("DBCONDITION")) != null) {
                    def.setHidden(true);
                    def.clearValue();
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        this.setChanged(false);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && ((IPhysicalTable)this.getDataSources()[0]).getDBMSType() instanceof SASHDATType;
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (this.getDataSourcesCount() > 0 && !(((IPhysicalTable)this.getDataSources()[0]).getDBMSType() instanceof SASHDATType)) {
            reasons.add(RB.getStringResource("SASHadoopDataUnloaderTransformModel.SourceTableError.txt"));
        }
        return reasons;
    }

    public IHadoopServer getHadoopServer() {
        IServer server;
        IPhysicalTable table;
        if (this.getDataSourcesCount() > 0 && (table = (IPhysicalTable)this.getDataSources()[0]).getDBMSType() instanceof SASHDATType && (server = table.getDatabaseServer()) instanceof IHadoopServer) {
            return (IHadoopServer)server;
        }
        return null;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IProperty path = source.getLibraryForUseInJob().findOption(LIBRARY_PATH);
        source.genTableDelete(codeSegment);
        return codeSegment;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new OptionModel();
    }

    protected class OptionModel
    extends BaseDataTransformPromptModel
    implements IPromptModel {
        public OptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(SASHadoopDataUnloaderTransformModel.this.getModel(), SASHadoopDataUnloaderTransformModel.this);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(SASHadoopDataUnloaderTransformModel.class.getResource("res/Options_OLIPHANT_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
        }

        @Override
        protected IModelListener createModelListener() {
            return new PromptModelListener();
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new PromptChangeListener();
        }

        private class PromptModelListener
        extends BaseDataTransformModelListener {
            public PromptModelListener() {
                super(SASHadoopDataUnloaderTransformModel.this, OptionModel.this);
            }

            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
            }
        }

        private class PromptChangeListener
        extends BaseDataTransformValueChangedListener {
            public PromptChangeListener() {
                super(SASHadoopDataUnloaderTransformModel.this, (IPromptModel)OptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        String string = "";
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }
}

