/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.fork.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICheckpointRestart;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CheckpointRestart;
import com.sas.etl.models.job.impl.CodeGenerationEnvironment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.fork.IParameterMapping;
import com.sas.etl.models.job.transforms.fork.impl.BaseParameterMapping;
import com.sas.etl.models.job.transforms.fork.impl.ForkEndTransformModel;
import com.sas.etl.models.job.transforms.fork.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.etl.models.prompts.impl.BaseTransformPromptModel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ForkTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.control.Fork";
    private static final String TRANSFORMATION_ROLE = "LOOP";
    private static final String ARM_DISPLAY_NAME = "Fork";
    private static final String RETURN_CODE_MACRO_CHECK = "etls_forkRCCheck";
    private static final String RETURN_CODE_MACRO_ERROR = "etls_forkRCError";
    private static final int STARTING_COLUMN_FOR_PARAMETER_TABLE = 1;
    private static final String HANDLE_PREFIX_OPTION_NAME = "HANDLE_PREFIX";
    public static final String CLIENT_SIDE_STATUS_MACRO_NAME = "etls_setClientSideStatus";
    public static final int UNKNOWN_STATUS_ERROR_RC = 99;
    public static final String PARAMETER_PROPERTY_SET = "PARAMETERPROPERTYSET";
    public static final String HANDLE_PREFIX_CHANGED = "ForkTranformModels:HandlePrefixChanged";
    public static final String EXECUTE_IN_PARALLEL_CHANGED = "ForkTransformModel:ExecuteinParallelChanged";
    public static final String LOCATION_OF_LOG_AND_OUTPUT_CHANGED = "ForkTransformModel:LogAndOutputLocationChanged";
    public static final String APPLICATION_CHANGED = "ForkTransformModel:ApplicationChanged";
    public static final String WORKLOAD_CHANGED = "ForkTransformModel:WorkloadChanged";
    public static final String WAIT_FOR_PROCESSES_CHANGED = "ForkTransformModel:WaitForProcessesChanged";
    public static final String MAXIMUM_CONCURRENT_PROCESSES_SETTING_CHANGED = "ForkTransformModel:ConcurrentProcessesChanged";
    public static final String NUMBER_OF_MAXIMUM_CONCURRENT_PROCESSES_CHANGED = "ForkTransformModel:NumberofMaximumConcurrentProcessesChanged";
    public static final String SIGNON_OPTIONS_CHANGED = "ForkTransformModel:SignonOptionsChanged";
    public static final String NUMBER_OF_SIGNON_RETRIES_CHANGED = "ForkTransformModel:SignonRetriesChanged";
    public static final String GRID_SUPP_JOB_OPTIONS_CHANGED = "ForkTransformModel:GridSuppJobOptionsChanged";
    public static final String ERROR_ON_UNKNOWN_STATUS_CHANGED = "ForkTransformModel:ErrorOnUnknownStatusChanged";
    public static final String PARAMETER_MAPPING_ADDED = "ForkTransformModel:ParameterMappingAdded";
    public static final String PARAMETER_MAPPING_REMOVED = "ForkTransformModel:ParameterMappingRemoved";
    private static final String ITERATION_PROPERTY_SET = "ITERATION_OPTIONS";
    private static final String EXECUTE_PROPERTY_NAME = "EXECUTEPARALLEL";
    private static final String WAITFOR_PROPERTY_NAME = "WAITFOR";
    private static final String LOG_OUTPUT_PROPERTY_NAME = "LOGOUTPUTLOCATION";
    private static final String APPLICATION_PROPERTY_NAME = "APPLICATION";
    private static final String WORKLOAD_PROPERTY_NAME = "WORKLOAD";
    private static final String MAX_CONCURRENT_PROPERTY_NAME = "MAXIMUMCONCURRENTPROCESSES";
    private static final String ADDITIONAL_SIGNON_OPTIONS_PROPERTY_NAME = "ADDITIONALSIGNONOPTIONS";
    private static final String SIGNON_RETRIES_PROPERTY_NAME = "SIGNONRETRIES";
    private static final String GRID_SUPP_JOB_OPTIONS_PROPERTY_NAME = "GRIDSUPPJOBOPTIONS";
    private static final String UNKNOWN_STATUS_ERROR_PROPERTY_NAME = "UNKNOWNSTATUSERROR";
    private static final String HANDLE_PREFIX_PROPERTY_NAME = "HANDLE_PREFIX";
    private static final int CONCURRENT_DEFAULT = 1;
    public static final String VALUE_NNODES = "NNODES";
    public static final String VALUE_ALL = "ALL";
    private static final String VALUE_NO = "NO";
    private static final String VALUE_YES = "YES";
    public static final int DEFAULT_SIGNON_RETRIES = 3;
    private String m_sHandlePrefix;
    private boolean m_bExecuteInParallel;
    private String m_strLocationLogOutputFiles;
    private String m_strApplication;
    private String m_strWorkload;
    private boolean m_bWaitForComplete;
    private String m_strMaxConcurrentSetting;
    private int m_intMaxConcurrentSetting;
    private String m_strSignonOptions;
    private int m_intSignonRetries;
    private String m_strGridSuppJobOptions;
    private boolean m_bErrorOnUnknownStatus;
    private List m_lstParameterMappings;
    private List m_lstForkColumns;
    private List m_lstForkNames;
    private static final String HANDLE = "etls_handleName";
    private static final String MACHINE = "etls_machineId";
    private static final String STARTTIME = "etls_startTime";
    private static final String ENDTIME = "etls_endTime";
    private static final String STATUS = "etls_status";
    private static final String JOBRC = "etls_jobRC";

    public ForkTransformModel(String sID, IModel model) {
        super(sID, model);
        this.createConditionActionSetTemplates();
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        this.m_sHandlePrefix = CodeGenerationEnvironment.getUniqueLoopHandleNamePrefix();
        this.m_bExecuteInParallel = true;
        this.m_strLocationLogOutputFiles = "";
        this.m_strApplication = file.getPropertyString("Workspace.DefaultApplication", "");
        this.m_strWorkload = file.getPropertyString("Workspace.DefaultWorkload", "");
        this.m_bWaitForComplete = true;
        this.m_strMaxConcurrentSetting = file.getPropertyString("Workspace.DefaultMaxConcurrentProcesses", VALUE_NNODES);
        this.m_intMaxConcurrentSetting = 1;
        this.m_strSignonOptions = "";
        this.m_intSignonRetries = 3;
        this.m_bErrorOnUnknownStatus = false;
        this.m_strGridSuppJobOptions = "";
        this.m_lstParameterMappings = new ArrayList();
        this.m_lstForkColumns = new ArrayList();
        this.m_lstForkNames = new ArrayList();
        this.m_lstForkNames.add(HANDLE.toUpperCase());
        this.m_lstForkNames.add(MACHINE.toUpperCase());
        this.m_lstForkNames.add(STARTTIME.toUpperCase());
        this.m_lstForkNames.add(ENDTIME.toUpperCase());
        this.m_lstForkNames.add(STATUS.toUpperCase());
        this.m_lstForkNames.add(JOBRC.toUpperCase());
        try {
            IPromptModel transformOptionModel = this.getOptionModel();
            IPromptDefinitionValue pdv = transformOptionModel.getPromptDefinitionValue("GENERATEFORMATSINFORMATS");
            if (pdv != null) {
                pdv.setHidden(true);
            }
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServIOExceptioniceException", (Throwable)e);
        }
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.replaceParameterMappings(oldTable, columnsMap, newTable.getColumns());
            super.replaceSourceTable(oldTable, newTable, columnsMap);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void removeDataSource(IDataObject source) {
        this.startCompoundUndoable();
        try {
            this.replaceParameterMappings((ITable)source, null, new IColumn[0]);
            super.removeDataSource(source);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void replaceParameterMappings(ITable oldTable, Map columnsMap, IColumn[] newColumns) {
        IParameterMapping[] mappings = this.getParameterMappings();
        for (int i = 0; i < mappings.length; ++i) {
            IParameterMapping map = mappings[i];
            IColumn col = map.getSourceColumn();
            if (col == null || col.getTable() != oldTable) continue;
            boolean found = false;
            if (columnsMap != null && (IColumn)columnsMap.get(col) != null) {
                map.setSourceColumn((IColumn)columnsMap.get(col));
                found = true;
                break;
            }
            for (int j = 0; j < newColumns.length; ++j) {
                if (!col.equalsName(newColumns[j], this.isQuotingNeeded())) continue;
                map.setSourceColumn(newColumns[j]);
                found = true;
                break;
            }
            if (found) continue;
            map.setSourceColumn(null);
        }
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("ForkTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("ForkTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.addNewWorkTable();
        this.loadConditionActionSetTemplatesFromOMR();
        if (this.getJob().getExecutionServer().getGridServer() == null) {
            this.m_strApplication = "";
        } else if (this.getJob().getExecutionServer().getGridServer().getGridOptionSets() == null) {
            this.m_strApplication = "";
        } else {
            ArrayList<String> gosL = new ArrayList<String>();
            gosL.addAll(this.getJob().getExecutionServer().getGridServer().getGridOptionSets());
            this.m_strApplication = "";
        }
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable table = super.addNewWorkTable();
            this.addNewWorkTableColumns(table);
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void addNewWorkTableColumns(IWorkTable table) {
        this.startCompoundUndoable();
        try {
            this.m_lstForkColumns.add(this.createColumn(table, HANDLE, 32, 0, ""));
            this.m_lstForkColumns.add(this.createColumn(table, MACHINE, 32, 0, ""));
            this.m_lstForkColumns.add(this.createColumn(table, STARTTIME, 8, 1, "nldatmap."));
            this.m_lstForkColumns.add(this.createColumn(table, ENDTIME, 8, 1, "nldatmap."));
            this.m_lstForkColumns.add(this.createColumn(table, STATUS, 32, 0, ""));
            this.m_lstForkColumns.add(this.createColumn(table, JOBRC, 8, 1, ""));
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private IColumn createColumn(IWorkTable table, String name, int length, int type, String format) {
        IObjectFactory factory = this.getModel().getObjectFactory();
        IColumn column = factory.createNewColumn(table.getID());
        column.setName(name);
        column.setDescription(RB.getStringResource("ForkTransformModel.Column." + name + ".desc.txt"));
        column.setLength(length);
        column.setType(type);
        column.setFormat(format);
        table.addColumn(column);
        return column;
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        IParameterMapping[] mappings = this.getParameterMappings();
        for (int i = 0; i < mappings.length; ++i) {
            if (!mappings[i].isChanged()) continue;
            return true;
        }
        return false;
    }

    protected ITable getTargetTable() {
        ITable target = null;
        ITable[] targetTables = this.getTargetTables();
        if (targetTables.length > 0) {
            target = targetTables[0];
        }
        return target;
    }

    @Override
    public void notify(NotifyEvent ev) {
        ModelEvent modelEv = ev.getModelEvent();
        if (modelEv != null) {
            IObject obj = modelEv.getModelObject();
            ITable[] sourceTables = this.getSourceTables();
            ITable[] targetTables = this.getTargetTables();
            if (sourceTables.length > 0 && targetTables.length > 0) {
                IMapping mapping;
                IColumn[] cols;
                IColumn column;
                IMapping[] mapps;
                ITable targetTable = targetTables[0];
                ITable sourceTable = sourceTables[0];
                if (Arrays.asList(sourceTable.getColumns()).contains(obj)) {
                    this.updateMappedColumnsToTargetTable(new IColumn[]{(IColumn)obj}, targetTable);
                } else if ("Table:ColumnRemoved".equals(modelEv.getType()) && obj == sourceTable && (mapps = this.getOrdinaryMappingsForSourceColumn(column = (IColumn)modelEv.getData())).length > 0 && (cols = (mapping = mapps[0]).getTargets()).length > 0) {
                    targetTable.removeColumn(cols[0]);
                }
            }
            if (obj == this.getJob() && ("Job:TransformAdded".equals(modelEv.getType()) || "Job:TransformRemoved".equals(modelEv.getType()) || "Job:TransformAddedToExecutionOrder".equals(modelEv.getType()) || "Job:TransformRemovedFromExecutionOrder".equals(modelEv.getType()))) {
                this.fireModelChangedEvent("ITransform:TransformChanged", this);
            }
        }
        super.notify(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preRemoveDataSource(IDataObject source) {
        if (this.isUndoSupported()) {
            this.startCompoundUndoable();
        }
        try {
            ITable[] targetTables = this.getTargetTables();
            if (source != null && targetTables.length > 0) {
                IColumn[] cols = ((ITable)source).getColumns();
                ITable targetTable = targetTables[0];
                for (int i = 0; i < cols.length; ++i) {
                    IMapping[] maps = this.getOrdinaryMappingsForSourceColumn(cols[i]);
                    for (int j = 0; j < maps.length; ++j) {
                        IColumn[] targets = maps[j].getTargets();
                        for (int k = 0; k < targets.length; ++k) {
                            targetTable.removeColumn(targets[k]);
                        }
                    }
                }
            }
        }
        finally {
            if (this.isUndoSupported()) {
                this.endCompoundUndoable();
            }
        }
        super.preRemoveDataSource(source);
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.hasForkEnd() && this.getHandlePrefix() != null && this.getHandlePrefix().length() > 0 && Character.isLetter(this.getHandlePrefix().charAt(0));
    }

    @Override
    public List getReasonsIncomplete() {
        String prefix;
        List lReasons = super.getReasonsIncomplete();
        if (!this.hasForkEnd()) {
            lReasons.add(RB.getStringResource("ForkCodegen.NoForkEndFound.txt"));
        }
        if ((prefix = this.getHandlePrefix()) == null || prefix.length() == 0) {
            lReasons.add(RB.getStringResource("ForkCodegen.HandlePrefixRequired.txt"));
        } else if (!Character.isLetter(prefix.charAt(0))) {
            lReasons.add(RB.getStringResource("ForkCodegen.HandlePrefixFirstLetterHasToBeNumber.txt"));
        }
        return lReasons;
    }

    @Override
    protected String getClassifierMapType() {
        return "ClassifierMap";
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        IParameterMapping[] mappings = this.getParameterMappings();
        for (int i = 0; i < mappings.length; ++i) {
            mappings[i].deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void delete() {
        IParameterMapping[] mappings = this.getParameterMappings();
        for (int i = 0; i < mappings.length; ++i) {
            mappings[i].delete();
        }
        super.delete();
    }

    @Override
    public void setJob(IJob job) {
        IJob oldJob = this.getJob();
        if (oldJob != null) {
            oldJob.removeNotifyListener(this);
        }
        super.setJob(job);
        if (job != null) {
            job.addNotifyListener(this);
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        IParameterMapping[] mappings = this.getParameterMappings();
        for (int i = 0; i < mappings.length; ++i) {
            mappings[i].updateIDs(mapIDs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParameterMapping createNewParameterMapping(IPromptDefinitionValue definition) {
        this.startCompoundUndoable();
        try {
            BaseParameterMapping mapping = new BaseParameterMapping(this.createIDForNewObject(), this.getModel());
            mapping.setName(definition.getName());
            this.addParameterMapping(mapping);
            BaseParameterMapping baseParameterMapping = mapping;
            return baseParameterMapping;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected ForkEndTransformModel getForkEnd() {
        IJob job = this.getJob();
        if (job != null) {
            List<ITransform> transforms = Arrays.asList(job.getControlOrderedTransformsAndOthers());
            int index = transforms.indexOf(this);
            int forksCnt = 0;
            for (int i = index + 1; i < transforms.size(); ++i) {
                ITransform trans = transforms.get(i);
                if (trans instanceof ForkTransformModel) {
                    ++forksCnt;
                }
                if (!(trans instanceof ForkEndTransformModel)) continue;
                if (forksCnt > 0) {
                    --forksCnt;
                    continue;
                }
                return (ForkEndTransformModel)trans;
            }
        }
        return null;
    }

    protected boolean hasForkEnd() {
        return this.getForkEnd() != null;
    }

    protected ITransform[] getInnerSteps() {
        ITransform trans;
        ArrayList<ITransform> steps = new ArrayList<ITransform>();
        IJob job = this.getJob();
        ITransform[] arrTransforms = job.getControlOrderedTransformsAndOthers();
        List<ITransform> transforms = Arrays.asList(arrTransforms);
        int index = transforms.indexOf(this);
        ForkEndTransformModel forkEnd = this.getForkEnd();
        for (int i = index + 1; i < arrTransforms.length && forkEnd != (trans = arrTransforms[i]); ++i) {
            steps.add(trans);
        }
        return steps.toArray(new ITransform[steps.size()]);
    }

    public IPromptDefinitionValue[] getInnerParameters() {
        ArrayList<IPromptDefinitionValue> parameters = new ArrayList<IPromptDefinitionValue>();
        ArrayList<String> parameterNames = new ArrayList<String>();
        ITransform[] transforms = this.getInnerSteps();
        for (int i = 0; i < transforms.length; ++i) {
            IPromptDefinitionValue[] inners = transforms[i].getParameters(true);
            for (int j = 0; j < inners.length; ++j) {
                if (parameterNames.contains(inners[j].getName().toUpperCase())) continue;
                parameters.add(inners[j]);
                parameterNames.add(inners[j].getName().toUpperCase());
            }
        }
        return parameters.toArray(new IPromptDefinitionValue[parameters.size()]);
    }

    public IParameterMapping[] getParameterMappings() {
        return this.m_lstParameterMappings.toArray(new IParameterMapping[this.m_lstParameterMappings.size()]);
    }

    public void addParameterMapping(IParameterMapping mapping) {
        if (this.m_lstParameterMappings.contains(mapping)) {
            return;
        }
        for (int i = 0; i < this.m_lstParameterMappings.size(); ++i) {
            IParameterMapping map = (IParameterMapping)this.m_lstParameterMappings.get(i);
            if (!map.getName().equalsIgnoreCase(mapping.getName())) continue;
            this.addToDeletedObjects(map);
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddParameterMappingUndoable(mapping));
        }
        this.removeFromDeletedObjects(mapping);
        this.m_lstParameterMappings.add(mapping);
        this.fireModelChangedEvent(PARAMETER_MAPPING_ADDED, mapping);
    }

    public void removeParameterMapping(IParameterMapping mapping) {
        if (!this.m_lstParameterMappings.contains(mapping)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveParameterMappingUndoable(mapping));
        }
        this.addToDeletedObjects(mapping);
        this.m_lstParameterMappings.remove(mapping);
        this.fireModelChangedEvent(PARAMETER_MAPPING_REMOVED, mapping);
    }

    public void setExecuteInParallel(boolean executeInParallel) {
        if (this.m_bExecuteInParallel == executeInParallel) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExecuteInParallelUndoable(this.m_bExecuteInParallel, executeInParallel));
        }
        this.m_bExecuteInParallel = executeInParallel;
        this.fireModelChangedEvent(EXECUTE_IN_PARALLEL_CHANGED, null);
    }

    public boolean isExecuteInParallel() {
        return this.m_bExecuteInParallel;
    }

    public void setHandlePrefix(String prefix) {
        if (ObjectComparator.isEqual(prefix, this.m_sHandlePrefix)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetHandlesPrefixUndoable(this.m_sHandlePrefix, prefix));
        }
        this.m_sHandlePrefix = prefix;
        this.fireModelChangedEvent(HANDLE_PREFIX_CHANGED, prefix);
    }

    public String getHandlePrefix() {
        return this.m_sHandlePrefix;
    }

    public void setLocationOfLogAndOutputDirectory(String directory) {
        if (this.m_strLocationLogOutputFiles.equals(directory)) {
            return;
        }
        if (directory == null) {
            throw new NullPointerException("directory value cannot be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLocationOfLogAndOutputDirectoryUndoable(this.m_strLocationLogOutputFiles, directory));
        }
        this.m_strLocationLogOutputFiles = directory;
        this.fireModelChangedEvent(LOCATION_OF_LOG_AND_OUTPUT_CHANGED, null);
    }

    public String getLocationOfLogAndOutputDirectory() {
        return this.m_strLocationLogOutputFiles;
    }

    public void setApplication(String application) {
        if (this.m_strApplication.equals(application)) {
            return;
        }
        if (application == null) {
            throw new NullPointerException("grid options set value cannot be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetApplicationUndoable(this.m_strApplication, application));
        }
        this.m_strApplication = application;
        this.fireModelChangedEvent(APPLICATION_CHANGED, this.m_strApplication);
    }

    public String getApplication() {
        return this.m_strApplication;
    }

    public void setWorkload(String workload) {
        if (this.m_strWorkload.equals(workload)) {
            return;
        }
        if (workload == null) {
            throw new NullPointerException("workload value cannot be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetWorkloadUndoable(this.m_strWorkload, workload));
        }
        this.m_strWorkload = workload;
        this.fireModelChangedEvent(WORKLOAD_CHANGED, this.m_strWorkload);
    }

    public String getWorkload() {
        return this.m_strWorkload;
    }

    public void setWaitForProcessesToCompleteToContinue(boolean wait) {
        if (this.m_bWaitForComplete == wait) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetWaitForProcessesToCompleteToContinueUndoable(this.m_bWaitForComplete, wait));
        }
        this.m_bWaitForComplete = wait;
        this.fireModelChangedEvent(WAIT_FOR_PROCESSES_CHANGED, null);
    }

    public boolean isWaitForProcessesToCompleteToContinue() {
        return this.m_bWaitForComplete;
    }

    public void setMaximumConcurrentProcessesSetting(String maxSetting) {
        if (this.m_strMaxConcurrentSetting.equals(maxSetting)) {
            return;
        }
        if (maxSetting == null || "".equals(maxSetting)) {
            maxSetting = VALUE_NNODES;
        }
        boolean isInt = true;
        int num = 1;
        try {
            num = Integer.parseInt(maxSetting);
        }
        catch (NumberFormatException e) {
            isInt = false;
        }
        if (!(isInt || VALUE_ALL.equals(maxSetting) || VALUE_NNODES.equals(maxSetting))) {
            throw new IllegalArgumentException("values should be ALL or NNODES or NUMBER");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMaximumConcurrentProcessesSettingUndoable(this.m_strMaxConcurrentSetting, maxSetting));
        }
        this.m_strMaxConcurrentSetting = maxSetting;
        if (isInt) {
            this.setNumberofMaximumConcurrentProcessing(num);
        }
        this.fireModelChangedEvent(MAXIMUM_CONCURRENT_PROCESSES_SETTING_CHANGED, this.m_strMaxConcurrentSetting);
    }

    public String getMaximumConcurrentProcessesSetting() {
        return this.m_strMaxConcurrentSetting;
    }

    protected void setNumberofMaximumConcurrentProcessing(int max) {
        if (this.m_intMaxConcurrentSetting == max) {
            return;
        }
        this.m_intMaxConcurrentSetting = max;
        this.fireModelChangedEvent(NUMBER_OF_MAXIMUM_CONCURRENT_PROCESSES_CHANGED, null);
    }

    public int getNumberofMaximumConcurrentProcessing() {
        return this.m_intMaxConcurrentSetting;
    }

    public void setSignonOptions(String signonOptions) {
        if (this.m_strSignonOptions.equals(signonOptions)) {
            return;
        }
        if (signonOptions == null) {
            throw new NullPointerException("signon options value cannot be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSignonOptionsUndoable(this.m_strSignonOptions, signonOptions));
        }
        this.m_strSignonOptions = signonOptions;
        this.fireModelChangedEvent(SIGNON_OPTIONS_CHANGED, this.m_strSignonOptions);
    }

    public String getSignonOptions() {
        return this.m_strSignonOptions;
    }

    public void setNumberOfSignonRetries(int retries) {
        if (this.m_intSignonRetries == retries) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNumberOfRetriesUndoable(this.m_intSignonRetries, retries));
        }
        this.m_intSignonRetries = retries;
        this.fireModelChangedEvent(NUMBER_OF_SIGNON_RETRIES_CHANGED, null);
    }

    public int getNumberOfSignonRetries() {
        return this.m_intSignonRetries;
    }

    public void setGridSuppJobOptions(String gridSuppJobOptions) {
        if (this.m_strGridSuppJobOptions.equals(gridSuppJobOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGridSuppJobOptionsUndoable(this.m_strGridSuppJobOptions, gridSuppJobOptions));
        }
        this.m_strGridSuppJobOptions = gridSuppJobOptions;
        this.fireModelChangedEvent(GRID_SUPP_JOB_OPTIONS_CHANGED, this.m_strGridSuppJobOptions);
    }

    public String getGridSuppJobOptions() {
        return this.m_strGridSuppJobOptions;
    }

    public void setErrorOnUnknownStatus(boolean errorOnUnknownStatus) {
        if (this.m_bErrorOnUnknownStatus == errorOnUnknownStatus) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetErrorOnUnknownStatusUndoable(this.m_bErrorOnUnknownStatus, errorOnUnknownStatus));
        }
        this.m_bErrorOnUnknownStatus = errorOnUnknownStatus;
        this.fireModelChangedEvent(ERROR_ON_UNKNOWN_STATUS_CHANGED, null);
    }

    public boolean isErrorOnUnknownStatus() {
        return this.m_bErrorOnUnknownStatus;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap map = this.getClassifierMapObject(omr);
        this.saveParameterMappings(omr);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, EXECUTE_PROPERTY_NAME, EXECUTE_PROPERTY_NAME, EXECUTE_PROPERTY_NAME, this.isExecuteInParallel() ? VALUE_YES : VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, WAITFOR_PROPERTY_NAME, WAITFOR_PROPERTY_NAME, WAITFOR_PROPERTY_NAME, this.isWaitForProcessesToCompleteToContinue() ? VALUE_YES : VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, LOG_OUTPUT_PROPERTY_NAME, LOG_OUTPUT_PROPERTY_NAME, LOG_OUTPUT_PROPERTY_NAME, this.getLocationOfLogAndOutputDirectory(), 12, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, APPLICATION_PROPERTY_NAME, APPLICATION_PROPERTY_NAME, APPLICATION_PROPERTY_NAME, this.getApplication(), 12, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, WORKLOAD_PROPERTY_NAME, WORKLOAD_PROPERTY_NAME, WORKLOAD_PROPERTY_NAME, this.getWorkload(), 12, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, MAX_CONCURRENT_PROPERTY_NAME, MAX_CONCURRENT_PROPERTY_NAME, MAX_CONCURRENT_PROPERTY_NAME, this.getMaximumConcurrentProcessesSetting(), 12, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, ADDITIONAL_SIGNON_OPTIONS_PROPERTY_NAME, ADDITIONAL_SIGNON_OPTIONS_PROPERTY_NAME, ADDITIONAL_SIGNON_OPTIONS_PROPERTY_NAME, this.getSignonOptions(), 12, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, SIGNON_RETRIES_PROPERTY_NAME, SIGNON_RETRIES_PROPERTY_NAME, SIGNON_RETRIES_PROPERTY_NAME, Integer.toString(this.getNumberOfSignonRetries()), 4, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, GRID_SUPP_JOB_OPTIONS_PROPERTY_NAME, GRID_SUPP_JOB_OPTIONS_PROPERTY_NAME, GRID_SUPP_JOB_OPTIONS_PROPERTY_NAME, this.getGridSuppJobOptions(), 12, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, UNKNOWN_STATUS_ERROR_PROPERTY_NAME, UNKNOWN_STATUS_ERROR_PROPERTY_NAME, UNKNOWN_STATUS_ERROR_PROPERTY_NAME, this.isErrorOnUnknownStatus() ? VALUE_YES : VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)map, ITERATION_PROPERTY_SET, "HANDLE_PREFIX", "HANDLE_PREFIX", "HANDLE_PREFIX", this.getHandlePrefix(), 12, 0);
        this.setChanged(false);
    }

    protected IPromptDefinitionValue getParameterForMapping(IParameterMapping mapping) {
        IPromptDefinitionValue[] definitions = this.getInnerParameters();
        for (int i = 0; i < definitions.length; ++i) {
            if (!definitions[i].getName().equalsIgnoreCase(mapping.getName())) continue;
            return definitions[i];
        }
        return null;
    }

    public IParameterMapping getMappingForParameter(IPromptDefinitionValue definition) {
        IParameterMapping[] mappings = this.getParameterMappings();
        for (int i = 0; i < mappings.length; ++i) {
            if (!mappings[i].getName().equalsIgnoreCase(definition.getName())) continue;
            return mappings[i];
        }
        return null;
    }

    public IPromptDefinitionValue getDefinitionForMapping(IParameterMapping mapping) {
        IPromptDefinitionValue[] definitions = this.getInnerParameters();
        for (int i = 0; i < definitions.length; ++i) {
            if (!definitions[i].getName().equalsIgnoreCase(mapping.getName())) continue;
            return definitions[i];
        }
        return null;
    }

    public void saveParameterMappings(OMRAdapter omr) throws MdException, RemoteException {
        ClassifierMap map = this.getClassifierMapObject(omr);
        PropertySet parameterSet = this.findPropertySet(omr, (Root)map, PARAMETER_PROPERTY_SET, 0);
        if (parameterSet == null) {
            parameterSet = (PropertySet)omr.acquireOMRObject(this.createIDForNewObject(), "PropertySet");
            parameterSet.setName(PARAMETER_PROPERTY_SET);
            parameterSet.setSetRole(PARAMETER_PROPERTY_SET);
            map.getPropertySets(false).add((Object)parameterSet);
        }
        AssociationList setProperties = parameterSet.getSetProperties(false);
        setProperties.clear();
        IParameterMapping[] parmMappings = this.getParameterMappings();
        for (int i = 0; i < parmMappings.length; ++i) {
            IParameterMapping mapping = parmMappings[i];
            mapping.saveToOMR(omr);
            Property property = (Property)omr.acquireOMRObject(mapping);
            setProperties.add(property);
        }
    }

    public void loadParameterMappings(OMRAdapter omr) throws MdException, RemoteException {
        ClassifierMap map = this.getClassifierMapObject(omr);
        PropertySet parameterSet = this.findPropertySet(omr, (Root)map, PARAMETER_PROPERTY_SET, 0);
        this.m_lstParameterMappings.clear();
        if (parameterSet != null) {
            AssociationList properties = parameterSet.getSetProperties();
            int pSize = properties.size();
            for (int i = 0; i < pSize; ++i) {
                Property prop = (Property)properties.get(i);
                BaseParameterMapping parmMapping = new BaseParameterMapping(prop.getFQID(), this.getModel());
                parmMapping.loadFromOMR(omr);
                this.addParameterMapping(parmMapping);
            }
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        boolean changed = false;
        ClassifierMap map = this.getClassifierMapObject(omr);
        this.loadParameterMappings(omr);
        this.setExecuteInParallel(VALUE_YES.equals(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, EXECUTE_PROPERTY_NAME, VALUE_NO, 0)));
        this.setWaitForProcessesToCompleteToContinue(VALUE_YES.equals(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, WAITFOR_PROPERTY_NAME, VALUE_YES, 0)));
        this.setLocationOfLogAndOutputDirectory(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, LOG_OUTPUT_PROPERTY_NAME, "", 0));
        this.setApplication(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, APPLICATION_PROPERTY_NAME, "", 0));
        this.setWorkload(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, WORKLOAD_PROPERTY_NAME, "", 0));
        this.setMaximumConcurrentProcessesSetting(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, MAX_CONCURRENT_PROPERTY_NAME, VALUE_NNODES, 0));
        this.setSignonOptions(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, ADDITIONAL_SIGNON_OPTIONS_PROPERTY_NAME, "", 0));
        this.setNumberOfSignonRetries(Integer.parseInt(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, SIGNON_RETRIES_PROPERTY_NAME, Integer.toString(3), 0)));
        this.setGridSuppJobOptions(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, GRID_SUPP_JOB_OPTIONS_PROPERTY_NAME, "", 0));
        this.setErrorOnUnknownStatus(VALUE_YES.equals(this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, UNKNOWN_STATUS_ERROR_PROPERTY_NAME, VALUE_NO, 0)));
        String hDefault = this.loadPropertyFromOMR(omr, (Root)map, ITERATION_PROPERTY_SET, "HANDLE_PREFIX", CodeGenerationEnvironment.getUniqueLoopHandleNamePrefix(), 0);
        try {
            IPromptModel model = this.getOptionModel();
            if (this.findProperty(omr, (Root)map, ITERATION_PROPERTY_SET, "HANDLE_PREFIX", 0) == null) {
                changed = true;
            }
            if (model != null) {
                model.setOptionDefaultValue("HANDLE_PREFIX", (Object)hDefault);
            }
        }
        catch (FileNotFoundException e) {
            throw new MdException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        catch (ServerConnectionException e) {
            throw new MdException((Throwable)e);
        }
        catch (IOException e) {
            throw new MdException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MdException((Throwable)e);
        }
        this.setHandlePrefix(hDefault);
        this.updateForkColumnList();
        this.setChanged(changed);
    }

    protected void updateForkColumnList() {
        this.m_lstForkColumns.clear();
        ITable[] tables = this.getTargetTables();
        if (tables.length > 0) {
            ITable table = tables[0];
            IColumn[] columns = table.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                if (!this.m_lstForkNames.contains(columns[i].getName().toUpperCase())) continue;
                this.m_lstForkColumns.add(columns[i]);
            }
        }
    }

    public int getNumberofForkColumns() {
        return this.m_lstForkNames.size();
    }

    public boolean isForkColumn(IColumn column) {
        return this.m_lstForkColumns.contains(column);
    }

    public boolean isGridOptionsSetSelected() {
        IJob Job2 = this.getJob();
        if (Job2 == null) {
            return true;
        }
        if (Job2.getExecutionServer() != null) {
            if (Job2.getExecutionServer().getGridServer() == null) {
                return true;
            }
            if (this.isExecuteInParallel() && Job2.getExecutionServer().getGridServer().getGridOptionSets() != null && !Job2.getExecutionServer().getGridServer().getGridOptionSets().contains(this.m_strApplication)) {
                return false;
            }
        }
        return true;
    }

    public void setupEventLists(List standardActions, List abortRemainingActions, List abortAfterForkActions) {
        List sets = this.getConditionActionSetsList();
        for (int i = 0; i < sets.size(); ++i) {
            IConditionActionSet set = (IConditionActionSet)sets.get(i);
            IConditionAction[] conditions = set.getActions();
            for (int j = 0; j < conditions.length; ++j) {
                String actionType = conditions[j].getUniqueIdentifier();
                if ("DIS_ABORTREMAIN".equals(actionType)) {
                    abortRemainingActions.add(conditions[j]);
                    continue;
                }
                if ("DIS_ABORTAFTERLOOP".equals(actionType)) {
                    abortAfterForkActions.add(conditions[j]);
                    continue;
                }
                standardActions.add(conditions[j]);
            }
        }
        ArrayList<IConditionAction> abortlist = new ArrayList<IConditionAction>();
        for (int i = standardActions.size() - 1; i >= 0; --i) {
            IConditionAction action = (IConditionAction)standardActions.get(i);
            if (!"DIS_ABORTALL".equals(action.getActionType())) continue;
            abortlist.add(0, action);
            standardActions.remove(action);
        }
        standardActions.addAll(abortlist);
    }

    private void genStandardActions(ICodeSegment codeSegment, List standardActions) {
        codeSegment.addCommentLine(RB.getStringResource("ForkCodegen.ForkReturnCodeCheck.msg.txt")).addSourceCode("%macro ").addSourceCode(RETURN_CODE_MACRO_CHECK).addSourceCode("(statusTable=, returnCodeVariable=,start=,end=); \n").indent();
        codeSegment.addSourceCode("%macro ").addSourceCode(RETURN_CODE_MACRO_ERROR).addSourceCode("(_iteration); \n").indent();
        for (int iAction = 0; iAction < standardActions.size(); ++iAction) {
            IConditionAction action = (IConditionAction)standardActions.get(iAction);
            codeSegment.addSourceCode(action.getActionMacroCall(this.getJob().isUsingNLSDateFormat(), codeSegment));
        }
        codeSegment.unIndent().addSourceCode("%mend ").addSourceCode(RETURN_CODE_MACRO_ERROR).addSourceCode("; \n\n");
        codeSegment.addSourceCode("%local etls_rows etls_dsid rc etls_varnum;\n\n");
        codeSegment.addSourceCode("%let etls_rows = 0; \n").addSourceCode("proc sql noprint; \n").indent().addSourceCode("select count(*) into :etls_rows from &statusTable; \n").unIndent().addSourceCode("quit; \n\n");
        codeSegment.addSourceCode("%if &start le &etls_rows %then \n").addSourceCode("%do; \n").indent().addSourceCode("%let etls_dsid = %sysfunc(open(&statusTable)); \n").addSourceCode("%if (&etls_dsid = 0) %then \n").indent().addSourceCode("%put %sysfunc(sysmsg()); \n").unIndent().addSourceCode("%else \n").addSourceCode("%do; \n").indent().addSourceCode("%do i=&start %to &end; \n").indent().addSourceCode("%let rc = %sysfunc(fetchobs(&etls_dsid, &i)); \n").addSourceCode("%if (&rc ne 0) %then \n").indent().addSourceCode("%put %sysfunc(sysmsg()); \n").unIndent().addSourceCode("%else \n").addSourceCode("%do; \n").indent().addSourceCode("%let etls_varnum = %sysfunc(varnum(&etls_dsid,&returnCodeVariable)); \n").addSourceCode("%if (&etls_varnum > 0) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%if ((%sysfunc(getvarn(&etls_dsid,&etls_varnum)) ge 5) and \n").addSourceCode("     (&&etls_statusReported&i eq 0)) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%etls_forkRCError(&i); \n").addSourceCode("%let etls_statusReported&i = 1; \n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%end; \n").addSourceCode("%else \n").indent().addSourceCode("%put %sysfunc(sysmsg()); \n").unIndent().unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%end; \n").addSourceCode("%let rc = %sysfunc(close(&etls_dsid)); \n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%end; \n");
        codeSegment.unIndent().addSourceCode("%mend ").addSourceCode(RETURN_CODE_MACRO_CHECK).addSourceCode("; \n\n");
    }

    @Override
    protected ICheckpointRestart createNewCheckpointRestart() {
        CheckpointRestart cs = new CheckpointRestart(this);
        cs.setCPRStepSuffix(CodeGenerationEnvironment.createWorkTableName(0));
        return cs;
    }

    @Override
    protected void addTransformTableOption(ITransformTableOptions optionSet) {
        if (optionSet == null || !optionSet.isAccessTypeInput()) {
            return;
        }
        super.addTransformTableOption(optionSet);
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        String maxProcs;
        boolean hasStandardEvents;
        ArrayList validGridOpts;
        ArrayList validWorkloads;
        super.getGeneratedCode(codeSegment);
        if (codeSegment.isRunTableStatisticsEnabled()) {
            codeSegment.addCommentLine(RB.getStringResource("ForkCodegen.PerfStatsSummary.comment.txt"));
            codeSegment.addSourceCode("%put \"DIS_SUMM\";\n");
        }
        ITransform[] innerSteps = this.getInnerSteps();
        if (!this.hasForkEnd()) {
            throw new CodegenException(RB.getStringResource("ForkCodegen.NoForkEndFound.txt"), (IObject)this);
        }
        int outerForkCount = codeSegment.getLoopCount();
        String itername = this.getHandlePrefix();
        codeSegment.setCurrentLoop(itername);
        IPhysicalTable sourceTable = null;
        ITable[] tables = this.getSourceTables();
        if (tables.length > 0) {
            sourceTable = (IPhysicalTable)tables[0];
        }
        IPhysicalTable targetTable = (IPhysicalTable)this.getTargetTables()[0];
        boolean parallelIteration = this.isExecuteInParallel();
        boolean signoff = true;
        String logOutputPath = this.getLocationOfLogAndOutputDirectory();
        String application = this.getApplication();
        String workload = this.getWorkload();
        IServer defaultServer = codeSegment.getDefaultServer();
        List<Object> list = validWorkloads = defaultServer != null && defaultServer.getGridServer() != null ? defaultServer.getGridServer().getWorkloads() : new ArrayList();
        if (!validWorkloads.contains(workload)) {
            workload = "";
        }
        List<Object> list2 = validGridOpts = defaultServer != null && defaultServer.getGridServer() != null ? defaultServer.getGridServer().getGridOptionSets() : new ArrayList();
        if (!validGridOpts.contains(application)) {
            application = "";
        }
        String additionalSignonOptions = this.getSignonOptions();
        String gridSuppJobOptions = this.getGridSuppJobOptions();
        String unknownStatusSetting = this.isErrorOnUnknownStatus() ? Integer.toString(99) : ".";
        IServer server = this.getServerForStep(codeSegment.getCurrentServer());
        if (parallelIteration) {
            codeSegment.genParallelMacros(server, false, this.getJob().isRCSetSYSCCEnabled());
        } else if (!codeSegment.getParallelMacroStatus(server)) {
            codeSegment.setGenerateCommentHeaderOnParallelMacros(false);
            codeSegment.genParallelGetHandleMacro().genParallelFreeHandleMacro().genParallelCreateHandleMacro();
        }
        codeSegment.setInRemoteSubmit(parallelIteration);
        codeSegment.genGetParameterNamesMacro().genGetParametersMacro();
        ArrayList standardActions = new ArrayList();
        ArrayList abortRemainingActions = new ArrayList();
        ArrayList abortAfterForkActions = new ArrayList();
        this.setupEventLists(standardActions, abortRemainingActions, abortAfterForkActions);
        boolean bl = hasStandardEvents = !standardActions.isEmpty();
        if (hasStandardEvents) {
            this.genStandardActions(codeSegment, standardActions);
        }
        boolean hasAbortRemainingProcessActions = !abortRemainingActions.isEmpty();
        boolean hasAbortAfterForkActions = !abortAfterForkActions.isEmpty();
        String forkMacroName = "etls_fork" + codeSegment.getUniqueWorkTableName();
        String oneIterationMacroName = "etls_processToFork" + codeSegment.getUniqueWorkTableName();
        String jobMacroName = "etls_job" + codeSegment.getUniqueWorkTableName();
        codeSegment.addSourceCode("%macro ").addSourceCode(forkMacroName).addSourceCode("; \n");
        codeSegment.indent();
        codeSegment.addSourceCode("%local etls_filePrefix; \n");
        if (outerForkCount > 0) {
            codeSegment.addSourceCode("%let etls_filePrefix = &etls_filePrefix.&handleName.-; \n\n");
        } else {
            codeSegment.addSourceCode("%let etls_filePrefix = ; \n\n");
        }
        codeSegment.addRemoteMacroVariable("etls_filePrefix");
        codeSegment.addSourceCode("%macro ").addSourceCode(oneIterationMacroName).addSourceCode("(parameterTable=, row=").addSourceCode(", handleName=rmt").addSourceCode(");\n");
        codeSegment.indent();
        if (!parallelIteration) {
            codeSegment.addSourceCode("%local etls_parmvars; \n").addSourceCode("%etls_getParameterNames(parameterTable=&parameterTable, \n").indent().addSourceCode("parameterVariableMacro=etls_parmvars, \n").addSourceCode("startingColumnNumber=").addSourceCode(Integer.toString(1)).addSourceCode("); \n").unIndent().addSourceCode("%local &etls_parmvars; \n");
        }
        codeSegment.addSourceCode("%etls_getParameters(parameterTable=&parameterTable, row=&row, \n").indent().addSourceCode("startingColumnNumber=").addSourceCode(Integer.toString(1));
        if (parallelIteration) {
            codeSegment.addSourceCode(", handleName=&handleName");
        }
        codeSegment.addSourceCode("); \n").unIndent();
        codeSegment.addSourceCode("%let etls_previousFilePrefix = &etls_filePrefix;\n").addSourceCode("%local etls_filePrefix; \n").addSourceCode("%let etls_filePrefix = &etls_previousFilePrefix.&handleName; \n");
        if (parallelIteration) {
            codeSegment.addSourceCode("%syslput &etls_controlName = &row / remote = &handleName; \n").addSourceCode("%syslput handleName = &handleName / remote = &handleName; \n");
            this.getJob().getJobIdSyslputCode(codeSegment, "&handlename", true).addSourceCode("\n");
            codeSegment.addSourceCode("\n");
            codeSegment.genRemoteMacroVariablesSetup("&handleName", true);
            codeSegment.addSourceCode("rsubmit &handleName wait = no sysrputsync = yes persist = ");
            if (signoff) {
                codeSegment.addSourceCode("no");
            } else {
                codeSegment.addSourceCode("yes");
            }
            if (logOutputPath.length() > 0) {
                codeSegment.addSourceCode("\n").indent().addSourceCode("log = \"&etls_logOutputPath./").addSourceCode("&etls_filePrefix..log\" \n").addSourceCode("output = \"&etls_logOutputPath./").addSourceCode("&etls_filePrefix..lst\" \n").unIndent();
            }
            codeSegment.addSourceCode("; \n\n").indent();
        }
        codeSegment.addSourceCode("%macro ").addSourceCode(jobMacroName).addSourceCode("; \n\n").indent();
        ArrayList<IPromptDefinitionValue> parameterList = new ArrayList<IPromptDefinitionValue>(Arrays.asList(this.getInnerParameters()));
        ArrayList<IParameterMapping> parameterProperties = new ArrayList<IParameterMapping>(Arrays.asList(this.getParameterMappings()));
        HashMap outerMacroList = new HashMap(codeSegment.getRemoteMacroVariablesMap());
        for (int i = 0; i < parameterList.size(); ++i) {
            String macroName = ((IPromptDefinitionValue)parameterList.get(i)).getName();
            String macroKey = macroName + '.' + this.getID();
            codeSegment.addRemoteMacroVariable(macroKey, macroName);
        }
        ArrayList<StringBuffer> parameterSelectList = new ArrayList<StringBuffer>();
        if (parameterProperties != null) {
            IParameterMapping prop;
            int i;
            for (i = parameterProperties.size() - 1; i >= 0; --i) {
                prop = (IParameterMapping)parameterProperties.get(i);
                IColumn col = prop.getSourceColumn();
                if (col == null || sourceTable != null && Arrays.asList(sourceTable.getColumns()).contains(col)) continue;
                parameterProperties.remove(i);
            }
            for (i = parameterProperties.size() - 1; i >= 0; --i) {
                prop = (IParameterMapping)parameterProperties.get(i);
                boolean found = false;
                for (int j = 0; j < parameterList.size(); ++j) {
                    if (!((IPromptDefinitionValue)parameterList.get(j)).getName().equalsIgnoreCase(prop.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                parameterProperties.remove(i);
            }
            for (i = 0; i < parameterProperties.size(); ++i) {
                prop = (IParameterMapping)parameterProperties.get(i);
                IColumn col = prop.getSourceColumn();
                StringBuffer temp = new StringBuffer();
                if (col != null) {
                    String sourceColName = col.getColumnName(codeSegment);
                    parameterSelectList.add(temp.append(sourceColName).append(" as ").append(prop.getName()));
                    continue;
                }
                if (!prop.isRowNumber()) continue;
                parameterSelectList.add(temp.append("monotonic() as ").append(prop.getName()));
            }
            block11: for (i = 0; i < parameterProperties.size(); ++i) {
                for (int k = 0; k < parameterList.size(); ++k) {
                    if (!((IPromptDefinitionValue)parameterList.get(k)).getName().equalsIgnoreCase(((IParameterMapping)parameterProperties.get(i)).getName())) continue;
                    parameterList.remove(k);
                    continue block11;
                }
            }
        }
        if (parameterList != null && !parameterList.isEmpty()) {
            for (int i = 0; i < parameterList.size(); ++i) {
                IPromptDefinitionValue attr = (IPromptDefinitionValue)parameterList.get(i);
                String strDefaultValue = this.getDefaultForAttribute(attr, outerMacroList, this.getID());
                StringBuffer temp = new StringBuffer();
                parameterSelectList.add(temp.append(strDefaultValue).append(" as ").append(attr.getName()));
            }
        }
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        ICodeGenerationEnvironment newEnvironment = null;
        if (parallelIteration) {
            environment = newEnvironment = environment.copy();
            codeSegment.addSourceCode("%macro ").addSourceCode(CLIENT_SIDE_STATUS_MACRO_NAME).addSourceCode(";\n").indent().addSourceCode("%sysrput job_rc&handleName = &job_rc; \n").addSourceCode("%sysrput etls_endTime_&handleName = %sysfunc(datetime()); \n").unIndent().addSourceCode("%mend ").addSourceCode(CLIENT_SIDE_STATUS_MACRO_NAME).addSourceCode(";\n\n");
            codeSegment.addSourceCode("%sysrput etls_startTime_&handleName = %sysfunc(datetime()); \n\n");
        }
        ParameterHolder paramHolder = new ParameterHolder();
        Map ignoringLibraryMap = environment.getLibrariesGenerated();
        try {
            environment.addGeneratedParameters(paramHolder, codeSegment, Arrays.asList(this.getInnerParameters()));
            environment.clearLibraryContextList();
            for (int i = 0; i < innerSteps.length; ++i) {
                ICodeSegment newCodeSegment;
                ITransform transform = innerSteps[i];
                if (this.getJob().getTransformsToSkipList().contains(transform)) continue;
                ICodeSegment iCodeSegment = newCodeSegment = newEnvironment != null ? newEnvironment.createNewCodeSegment(transform) : codeSegment.createNewCodeSegment(transform);
                if (parallelIteration) {
                    newCodeSegment.setIndent(codeSegment.getIndents());
                }
                IJob job = this.getJob();
                newCodeSegment.genReturnCodeAndPerformanceSetup(job.isRCSetSYSCCEnabled(), job.getApplName());
                innerSteps[i].getCompleteCode(newCodeSegment);
                this.getJob().addTransformsToSkipCodeGeneration(transform);
            }
        }
        catch (ServiceException e) {
            throw new CodegenException((Exception)((Object)e), (IObject)this);
        }
        catch (ServerConnectionException e) {
            throw new CodegenException((Exception)((Object)e), (IObject)this);
        }
        finally {
            environment.removeGeneratedParameters(paramHolder);
            environment.setLibrariesGenerated(ignoringLibraryMap);
            environment = codeSegment.getCodeGenerationEnvironment();
        }
        if (parallelIteration && newEnvironment != null) {
            codeSegment.addSourceCode(newEnvironment);
        }
        if (parallelIteration) {
            codeSegment.addSourceCode("%").addSourceCode(CLIENT_SIDE_STATUS_MACRO_NAME).addSourceCode("; \n\n");
        }
        codeSegment.unIndent().addSourceCode("%mend ").addSourceCode(jobMacroName).addSourceCode("; \n\n").addSourceCode("%").addSourceCode(jobMacroName).addSourceCode("; \n\n");
        if (parallelIteration) {
            codeSegment.unIndent().addSourceCode("endrsubmit;\n\n");
        } else {
            codeSegment.addSourceCode("%let handleName = %etls_getHandle(statusTable=&etls_statusTable,\n").indent().addSourceCode("handleVariable=etls_handleName, row=&&&etls_controlName);\n\n").unIndent();
            codeSegment.addSourceCode("%let job_rc&handleName. = &job_rc; \n\n");
            codeSegment.addSourceCode("%etls_freeHandle(statusTable=&etls_statusTable, statusVariable=").addSourceCode(STATUS).addSourceCode(", \n").indent().addSourceCode("handleVariable=").addSourceCode(HANDLE).addSourceCode(", handleName=\"&handleName\", \n").addSourceCode("startTimeVariable=").addSourceCode(STARTTIME).addSourceCode(", endTimeVariable=").addSourceCode(ENDTIME).addSourceCode(", signoff=0, \n").addSourceCode("returnCodeVariable=").addSourceCode(JOBRC).addSourceCode(", returnCodeMacroVariable=job_rc&handleName., setMainJobRc=1); \n\n").unIndent();
        }
        codeSegment.unIndent().addSourceCode("%mend ").addSourceCode(oneIterationMacroName).addSourceCode(";\n\n");
        codeSegment.addSourceCode("%local etls_controlTable etls_statusTable etls_controlName \n").indent().addSourceCode("etls_processesRunning etls_maxProcesses etls_parameterTable \n").addSourceCode("etls_additionalSignonOptions etls_signonRetries;\n").unIndent();
        codeSegment.addSourceCode("%let etls_controlName = ").addSourceCode(itername).addSourceCode("; \n");
        codeSegment.addSourceCode("%let etls_statusTable = ").addSourceCode(targetTable.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode("; \n");
        String parameterTableName = codeSegment.getUniqueWorkTableName();
        codeSegment.addSourceCode("%let etls_parameterTable = ").addSourceCode("work").addSourceCode(".").addSourceCode(parameterTableName).addSourceCode("; \n");
        if (parallelIteration) {
            codeSegment.addSourceCode("%let etls_gridOptionSet = %nrstr(").addSourceCode(application).addSourceCode(");").newLine();
            codeSegment.addSourceCode("%let etls_workload = ").addSourceCode(workload).addSourceCode(";\n");
            codeSegment.addSourceCode("%let etls_additionalSignonOptions = ").addSourceCode(additionalSignonOptions).addSourceCode(";\n");
            codeSegment.addSourceCode("%let etls_signonRetries = ").addSourceCode(Integer.toString(this.getNumberOfSignonRetries())).addSourceCode(";\n");
            codeSegment.addSourceCode("%let etls_gridSuppJobOptions = %nrstr(").addSourceCode(gridSuppJobOptions).addSourceCode(");\n");
        }
        codeSegment.addSourceCode("%let &etls_controlName = 0;\n");
        if (sourceTable != null) {
            codeSegment.addSourceCode("%let etls_controlTable = ").addSourceCode(sourceTable.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(";\n");
        }
        IColumn[] targetColumns = targetTable.getColumns();
        String statusKeepList = codeSegment.makeColumnList(targetColumns, "        ", codeSegment.isQuoting(), " ");
        codeSegment.addSourceCode("\n");
        codeSegment.genPercentPutStatement(RB.getStringResource("ForkCodegen.CreateStatusTable.sasmacro.notrans"));
        codeSegment.addSourceCode("data &etls_statusTable \n");
        if (targetColumns.length > 0) {
            codeSegment.indent().addSourceCode("(keep = ").addSourceCode(statusKeepList).addSourceCode("\n)").unIndent();
        }
        codeSegment.addSourceCode(";\n").indent();
        for (int i = 0; i < targetColumns.length; ++i) {
            codeSegment.addSourceCode(targetColumns[i].getAttribStatement(codeSegment.isQuoting(), true, true, true));
        }
        if (sourceTable != null) {
            ITransformTableOptions sourceOptions = this.getTableOptionObject(sourceTable, true);
            String opts = sourceOptions.getTableOptions(true, codeSegment.getCurrentServer());
            codeSegment.addSourceCode("set &etls_controlTable");
            if (opts != null && opts.length() > 0) {
                codeSegment.addSourceCode(opts);
            }
            codeSegment.addSourceCode(";\n");
        }
        codeSegment.unIndent().addSourceCode("run;\n\n");
        codeSegment.genRCSetCall("&syserr", true);
        this.genParameterTable(codeSegment, sourceTable, parameterSelectList, parameterList, outerMacroList, this.getID());
        if (sourceTable != null) {
            codeSegment.addCommentLine(RB.getStringResource("ForkCodegen.GetNumberOfIterations.comment.txt"));
            codeSegment.addSourceCode("proc sql noprint; \n").indent().addSourceCode("select count(*) into :&etls_controlName._max from &etls_statusTable;\n").addSourceCode("%let &etls_controlName._max = &&&etls_controlName._max;\n").unIndent().addSourceCode("quit;\n\n");
            codeSegment.genRCSetCall("&sqlrc", true);
        } else {
            codeSegment.addSourceCode("%let &etls_controlName._max = 1; \n\n");
        }
        if (hasStandardEvents) {
            codeSegment.addCommentLine(RB.getStringResource("ForkCodegen.SetupStatusHandlingMacros.comment.txt"));
            codeSegment.addSourceCode("%do i=1 %to &&&etls_controlName._max; \n").indent().addSourceCode("%local etls_statusReported&i; \n").addSourceCode("%let etls_statusReported&i = 0; \n").unIndent().addSourceCode("%end; \n\n");
        }
        if ("".equals(maxProcs = this.getMaximumConcurrentProcessesSetting())) {
            maxProcs = VALUE_NNODES;
        }
        if (parallelIteration) {
            if (VALUE_NNODES.equals(maxProcs)) {
                codeSegment.addSourceCode("%let etls_gridInstalled =;\n").addSourceCode("%etls_tsLevel(macroName=etls_gridInstalled, featureName=uwugrdsv); \n\n").addSourceCode("%if (%str(&etls_gridInstalled) ne %str()) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%let etls_maxProcesses = %sysfunc(grdsvc_nnodes(\"").addSourceCode(codeSegment.getCurrentServer().getName()).addSourceCode("\")); \n").addSourceCode("%if (&etls_maxProcesses = 0) %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(RB.getStringResource("ForkCodegen.NoConfiguredGridNodes.sasmacro.notrans"), "NOTE:").addSourceCode("%let etls_maxProcesses = &SYSNCPU;\n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%end; \n").addSourceCode("%else \n").addSourceCode("%do; \n").indent().genPercentPutStatement(RB.getStringResource("ForkCodegen.GridServiceFunctionsNotInstalled.sasmacro.notrans")).addSourceCode("%let etls_maxProcesses = &SYSNCPU;\n").unIndent().addSourceCode("%end; \n").addSourceCode("\n");
            } else if (VALUE_ALL.equals(maxProcs)) {
                codeSegment.addSourceCode("%let etls_maxProcesses = &etls_controlName._max; \n\n");
            } else {
                if (maxProcs.length() == 0) {
                    maxProcs = "1";
                }
                codeSegment.addSourceCode("%let etls_maxProcesses = ").addSourceCode(maxProcs).addSourceCode("; \n\n");
            }
        } else {
            codeSegment.addSourceCode("%let etls_maxProcesses = 1; \n\n");
        }
        if (hasAbortRemainingProcessActions) {
            codeSegment.addSourceCode("%let etls_stopFork = 0; \n\n");
        }
        codeSegment.addSourceCode("%if (&etls_maxProcesses > 0) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%do %until (&&&etls_controlName ge &&&etls_controlName._max");
        if (hasAbortRemainingProcessActions) {
            codeSegment.addSourceCode("\n").indent().addSourceCode("or &etls_stopFork ne 0").unIndent();
        }
        codeSegment.addSourceCode("); \n\n").indent().addSourceCode("%let etls_lastForkPtr = &&&etls_controlName;\n\n");
        if (parallelIteration) {
            codeSegment.addSourceCode("%etls_getProcessesRunning(statusTable=&etls_statusTable, statusVariable=").addSourceCode(STATUS).addSourceCode(", \n").indent().addSourceCode("processCountMacro=etls_processesRunning, statusSetting=\"").addSourceCode(RB.getStringResource("ForkCodegen.Status.Running.txt")).addSourceCode("\");\n\n").unIndent();
        } else {
            codeSegment.addSourceCode("%let etls_processesRunning = 0; \n\n");
        }
        codeSegment.addSourceCode("%do %while(&etls_processesRunning lt &&&etls_controlName._max \n").indent().addSourceCode("and &etls_processesRunning lt &etls_maxProcesses \n").addSourceCode("and &&&etls_controlName lt &&&etls_controlName._max);\n\n").unIndent().indent();
        codeSegment.addSourceCode("%let &etls_controlName = %eval(&&&etls_controlName+1);\n\n");
        if (parallelIteration) {
            codeSegment.addSourceCode("%let etls_signonMacVar = etls_signonStatus&&&etls_controlName;\n").addSourceCode("%global &etls_signonMacVar;\n");
            if (logOutputPath.trim().length() > 0) {
                codeSegment.addSourceCode("%let etls_logOutputPath = " + logOutputPath + "; \n");
            }
        } else {
            codeSegment.addSourceCode("%let job_rcLast=&job_rc; \n");
        }
        codeSegment.newLine().addSourceCode("%etls_createHandle(statusTable=&etls_statusTable,").newLine().addSourceCode("                   statusVariable=").addSourceCode(STATUS).addSourceCode(",").newLine().addSourceCode("                   handleVariable=").addSourceCode(HANDLE).addSourceCode(",").newLine().addSourceCode("                   handlePrefix=&etls_controlName,").newLine().addSourceCode("                   statusSetting=\"").addSourceCode(RB.getStringResource("ForkCodegen.Status.Running.txt")).addSourceCode("\",").newLine();
        if (parallelIteration && application != null && !application.trim().isEmpty()) {
            codeSegment.addSourceCode("                   gridOptionSet=%nrstr(").addSourceCode(application).addSourceCode("),").newLine();
        }
        if (parallelIteration && workload.length() > 0) {
            codeSegment.addSourceCode("                   workloadMacroVariable=etls_workload,").newLine();
        }
        codeSegment.addSourceCode("                   row=&&&etls_controlName,").newLine().addSourceCode("                   machineVariable=").addSourceCode(MACHINE).addSourceCode(",").newLine().addSourceCode("                   startTimeVariable=").addSourceCode(STARTTIME);
        if (parallelIteration) {
            codeSegment.addSourceCode(",").newLine().addSourceCode("                   cmacvar=&etls_signonMacVar,").newLine().addSourceCode("                   signon=1,").newLine().addSourceCode("                   useGrid=1,").newLine().addSourceCode("                   additionalSignonOptions=&etls_additionalSignonOptions,").newLine().addSourceCode("                   signonRetries=&etls_signonRetries);").newLine(2);
        } else {
            codeSegment.addSourceCode(",").newLine().addSourceCode("                   signon=0,").newLine().addSourceCode("                   useGrid=0);").newLine(2);
        }
        codeSegment.unIndent();
        if (parallelIteration) {
            codeSegment.addSourceCode("%etls_getProcessesRunning(statusTable=&etls_statusTable, statusVariable=").addSourceCode(STATUS).addSourceCode(", \n").indent().addSourceCode("processCountMacro=etls_processesRunning, statusSetting=\"").addSourceCode(RB.getStringResource("ForkCodegen.Status.Running.txt")).addSourceCode("\");\n\n").unIndent();
        } else {
            codeSegment.addSourceCode("%let etls_processesRunning = 1; \n");
        }
        String rowMacroParameter = "&&&etls_controlName";
        if (parallelIteration) {
            codeSegment.addSourceCode("%if &etls_processesRunning > 0 and &&&etls_signonMacVar ne 1 %then \n").indent();
        }
        codeSegment.addSourceCode("%").addSourceCode(oneIterationMacroName).addSourceCode("(parameterTable=&etls_parameterTable, row=").addSourceCode(rowMacroParameter).addSourceCode(",").addSourceCode("\n").indent().addSourceCode("handleName=%etls_getHandle(statusTable=&etls_statusTable,\n").addSourceCode("handleVariable=").addSourceCode(HANDLE).addSourceCode(", row=").addSourceCode(rowMacroParameter).addSourceCode(")").unIndent().addSourceCode("); \n");
        if (parallelIteration) {
            codeSegment.unIndent().addSourceCode("%else \n").addSourceCode("%do; /* if signon error, set iterator to max to force fork to stop. */ \n").indent().addSourceCode("%let &etls_controlName = &&&etls_controlName._max; \n").genPercentPutStatement(RB.getStringResource("ForkCodegen.ParallelProcessStartupFailed.sasmacro.notrans"), "ERROR%QUOTE(:)").unIndent().addSourceCode("%end; \n");
        } else {
            codeSegment.addSourceCode("\n/* Reset main Job_RC and Trans_RC to max return code of all iterations */ \n").addSourceCode("%let job_rcThisIter=&job_rc; \n").addSourceCode("%let job_rc=&job_rcLast; \n").addSourceCode("%let trans_rc=&job_rcLast; \n").addSourceCode("%rcSet(&job_rcThisIter); \n");
        }
        if (!parallelIteration && hasStandardEvents) {
            codeSegment.addSourceCode("\n");
            this.genRCErrorCall(codeSegment, JOBRC, "&&&etls_controlName");
        }
        codeSegment.unIndent().addSourceCode("%end; \n\n");
        if (hasAbortRemainingProcessActions) {
            codeSegment.addSourceCode("%if (&job_rc ge 5) %then \n").indent().addSourceCode("%let etls_stopFork = 1; \n\n").unIndent();
        }
        codeSegment.unIndent().addSourceCode("%end; \n\n");
        codeSegment.unIndent().addSourceCode("%end;\n\n").genTableDelete(parameterTableName);
        codeSegment.unIndent().addSourceCode("%mend ").addSourceCode(forkMacroName).addSourceCode("; \n\n").addSourceCode("%").addSourceCode(forkMacroName).addSourceCode("; \n\n");
        if (hasAbortAfterForkActions) {
            String forkEndRcMacroName = "etls_forkEndRcChk";
            codeSegment.addSourceCode("%macro ").addSourceCode(forkEndRcMacroName).addSourceCode("; \n").indent().addSourceCode("%if (&job_rc ge 5) %then \n").addSourceCode("%do; \n").indent();
            for (int i = 0; i < abortAfterForkActions.size(); ++i) {
                IConditionAction action = (IConditionAction)abortAfterForkActions.get(i);
                codeSegment.addSourceCode(action.getActionMacroCall(this.getJob().isUsingNLSDateFormat(), codeSegment));
            }
            codeSegment.unIndent().addSourceCode("%end; \n\n").unIndent().addSourceCode("%mend ").addSourceCode(forkEndRcMacroName).addSourceCode("; \n\n").addSourceCode("%").addSourceCode(forkEndRcMacroName).addSourceCode("; \n\n");
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        Map cgReqMap = codeSegment.getRemoteMacroVariablesMap();
        Set keys = cgReqMap.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String nextMacro = iter.next().toString();
            String[] macro = nextMacro.split("\\.");
            String metaId = "";
            if (macro.length <= 1 || !(metaId = macro[1] + '.' + macro[2]).equalsIgnoreCase(this.getID())) continue;
            toRemove.add(nextMacro);
        }
        toRemove.add("ETLS_FILEPREFIX");
        for (int i = 0; i < toRemove.size(); ++i) {
            cgReqMap.remove(toRemove.get(i).toString());
        }
        codeSegment.endCurrentLoop();
        return codeSegment;
    }

    protected void genParameterTable(ICodeSegment codeSegment, IPhysicalTable sourceTable, List parameterSelectList, List attrList, Map outerMacros, String classifierId) throws MdException, RemoteException {
        codeSegment.genPercentPutStatement(RB.getStringResource("ForkCodegen.CreateParameterTable.sasmacro.notrans"));
        if (sourceTable != null && !parameterSelectList.isEmpty()) {
            codeSegment.addSourceCode("proc sql; \n").indent().addSourceCode("create table &etls_parameterTable as \n").indent();
            for (int i = 0; i < parameterSelectList.size(); ++i) {
                if (i == 0) {
                    codeSegment.addSourceCode("select ");
                } else {
                    codeSegment.addSourceCode("       ");
                }
                codeSegment.addSourceCode(parameterSelectList.get(i).toString());
                if (i != parameterSelectList.size() - 1) {
                    codeSegment.addSourceCode(", \n");
                    continue;
                }
                codeSegment.addSourceCode(" \n");
            }
            codeSegment.addSourceCode("from &etls_controlTable");
            ITransformTableOptions sourceOptions = this.getTableOptionObject(sourceTable, true);
            String opts = sourceOptions.getTableOptions(true, codeSegment.getCurrentServer());
            if (opts != null && opts.length() > 0) {
                codeSegment.addSourceCode(opts);
            }
            codeSegment.addSourceCode("; \n");
            codeSegment.unIndent().unIndent().addSourceCode("quit; \n\n");
            codeSegment.genRCSetCall("&sqlrc", true);
        } else {
            codeSegment.addSourceCode("data &etls_parameterTable; \n").indent();
            for (int i = 0; i < attrList.size(); ++i) {
                IPromptDefinitionValue attr = (IPromptDefinitionValue)attrList.get(i);
                String defaultValue = this.getDefaultForAttribute(attr, outerMacros, classifierId);
                codeSegment.addSourceCode(attr.getName()).addSourceCode(" = ").addSourceCode(defaultValue).addSourceCode("; \n");
            }
            codeSegment.unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr", true);
        }
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        ForkTransformPromptModel model = new ForkTransformPromptModel(this.getModel(), this);
        model.setOptionDefaultValue("HANDLE_PREFIX", (Object)this.m_sHandlePrefix);
        return model;
    }

    private void genRCErrorCall(ICodeSegment cgReq, String strRC) {
        this.genRCErrorCall(cgReq, strRC, "%eval(&etls_lastForkPtr+1)");
    }

    private void genRCErrorCall(ICodeSegment cgReq, String strRC, String start) {
        cgReq.addSourceCode("%").addSourceCode(RETURN_CODE_MACRO_CHECK).addSourceCode("(statusTable=&etls_statusTable, returnCodeVariable=").addSourceCode(strRC).addSourceCode(", \n").indent().addSourceCode("start=").addSourceCode(start).addSourceCode(",end=&&&etls_controlName); \n").unIndent();
    }

    private String getDefaultForAttribute(IPromptDefinitionValue attr, Map outerMacros, String currentClassifierId) {
        String strDefaultValue = "";
        String attrName = attr.getName();
        String macroKey = this.findMacro(outerMacros, currentClassifierId, attrName);
        if (macroKey != null) {
            strDefaultValue = "symget(\"" + outerMacros.get(macroKey) + "\")";
        } else {
            Object defaultValue = "";
            if (attr.isDefaultValueSet()) {
                defaultValue = attr.getDefaultValue();
            }
            strDefaultValue = "\"" + (defaultValue != null ? defaultValue.toString() : "") + "\"";
        }
        return strDefaultValue;
    }

    private String findMacro(Map outerMacros, String currentClassifierId, String attrName) {
        String key = null;
        Set keys = outerMacros.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String nextMacro = iter.next().toString();
            String[] macro = nextMacro.split("\\.");
            String metaId = "";
            if (macro.length > 1) {
                metaId = macro[1] + '.' + macro[2];
            }
            if (!macro[0].equalsIgnoreCase(attrName) || currentClassifierId.equalsIgnoreCase(metaId)) continue;
            key = nextMacro;
            break;
        }
        return key;
    }

    @Override
    public ICodeSegment getRuntimeStatistics(ICodeSegment codeSegment) throws CodegenException {
        return codeSegment;
    }

    @Override
    public ICodeSegment getRuntimeStatisticsComplete(ICodeSegment codeSegment) throws CodegenException {
        return codeSegment;
    }

    private class AddParameterMappingUndoable
    extends AbstractUndoableEdit {
        private IParameterMapping m_parametermapping;

        public AddParameterMappingUndoable(IParameterMapping parametermapping) {
            this.m_parametermapping = parametermapping;
        }

        @Override
        public void undo() {
            ForkTransformModel.this.removeParameterMapping(this.m_parametermapping);
        }

        @Override
        public void redo() {
            ForkTransformModel.this.addParameterMapping(this.m_parametermapping);
        }
    }

    private class RemoveParameterMappingUndoable
    extends AbstractUndoableEdit {
        private IParameterMapping m_parametermapping;

        public RemoveParameterMappingUndoable(IParameterMapping parametermapping) {
            this.m_parametermapping = parametermapping;
        }

        @Override
        public void undo() {
            ForkTransformModel.this.addParameterMapping(this.m_parametermapping);
        }

        @Override
        public void redo() {
            ForkTransformModel.this.removeParameterMapping(this.m_parametermapping);
        }
    }

    private class SetExecuteInParallelUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldExecuteInParallel;
        private boolean m_newExecuteInParallel;

        public SetExecuteInParallelUndoable(boolean oldExecuteInParallel, boolean newExecuteInParallel) {
            this.m_oldExecuteInParallel = oldExecuteInParallel;
            this.m_newExecuteInParallel = newExecuteInParallel;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setExecuteInParallel(this.m_oldExecuteInParallel);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setExecuteInParallel(this.m_newExecuteInParallel);
        }
    }

    private class SetHandlesPrefixUndoable
    extends AbstractUndoableEdit {
        private String m_old;
        private String m_new;

        public SetHandlesPrefixUndoable(String old, String newPrefix) {
            this.m_old = old;
            this.m_new = newPrefix;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setHandlePrefix(this.m_old);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setHandlePrefix(this.m_new);
        }
    }

    private class SetLocationOfLogAndOutputDirectoryUndoable
    extends AbstractUndoableEdit {
        private String m_oldLocationOfLogAndOutputDirectory;
        private String m_newLocationOfLogAndOutputDirectory;

        public SetLocationOfLogAndOutputDirectoryUndoable(String oldLocationOfLogAndOutputDirectory, String newLocationOfLogAndOutputDirectory) {
            this.m_oldLocationOfLogAndOutputDirectory = oldLocationOfLogAndOutputDirectory;
            this.m_newLocationOfLogAndOutputDirectory = newLocationOfLogAndOutputDirectory;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setLocationOfLogAndOutputDirectory(this.m_oldLocationOfLogAndOutputDirectory);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setLocationOfLogAndOutputDirectory(this.m_newLocationOfLogAndOutputDirectory);
        }
    }

    private class SetApplicationUndoable
    extends AbstractUndoableEdit {
        private String m_oldApplication;
        private String m_newApplication;

        public SetApplicationUndoable(String oldApplication, String newApplication) {
            this.m_oldApplication = oldApplication;
            this.m_newApplication = newApplication;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setApplication(this.m_oldApplication);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setApplication(this.m_newApplication);
        }
    }

    private class SetWorkloadUndoable
    extends AbstractUndoableEdit {
        private String m_oldWorkload;
        private String m_newWorkload;

        public SetWorkloadUndoable(String oldWorkload, String newWorkload) {
            this.m_oldWorkload = oldWorkload;
            this.m_newWorkload = newWorkload;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setWorkload(this.m_oldWorkload);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setWorkload(this.m_newWorkload);
        }
    }

    private class SetWaitForProcessesToCompleteToContinueUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldWaitForProcessesToCompleteToContinue;
        private boolean m_newWaitForProcessesToCompleteToContinue;

        public SetWaitForProcessesToCompleteToContinueUndoable(boolean oldWaitForProcessesToCompleteToContinue, boolean newWaitForProcessesToCompleteToContinue) {
            this.m_oldWaitForProcessesToCompleteToContinue = oldWaitForProcessesToCompleteToContinue;
            this.m_newWaitForProcessesToCompleteToContinue = newWaitForProcessesToCompleteToContinue;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setWaitForProcessesToCompleteToContinue(this.m_oldWaitForProcessesToCompleteToContinue);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setWaitForProcessesToCompleteToContinue(this.m_newWaitForProcessesToCompleteToContinue);
        }
    }

    private class SetMaximumConcurrentProcessesSettingUndoable
    extends AbstractUndoableEdit {
        private String m_oldMaximumConcurrentProcessSetting;
        private String m_newMaximumConcurrentProcessSetting;

        public SetMaximumConcurrentProcessesSettingUndoable(String oldMaximumConcurrentProcessSetting, String newMaximumConcurrentProcessSetting) {
            this.m_oldMaximumConcurrentProcessSetting = oldMaximumConcurrentProcessSetting;
            this.m_newMaximumConcurrentProcessSetting = newMaximumConcurrentProcessSetting;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setMaximumConcurrentProcessesSetting(this.m_oldMaximumConcurrentProcessSetting);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setMaximumConcurrentProcessesSetting(this.m_newMaximumConcurrentProcessSetting);
        }
    }

    private class SetSignonOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldSignonOptions;
        private String m_newSignonOptions;

        public SetSignonOptionsUndoable(String oldSignonOptions, String newSignonOptions) {
            this.m_oldSignonOptions = oldSignonOptions;
            this.m_newSignonOptions = newSignonOptions;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setSignonOptions(this.m_oldSignonOptions);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setSignonOptions(this.m_newSignonOptions);
        }
    }

    private class SetNumberOfRetriesUndoable
    extends AbstractUndoableEdit {
        private int m_oldNumberOfRetries;
        private int m_newNumberOfRetries;

        public SetNumberOfRetriesUndoable(int oldNumberOfRetries, int newNumberOfRetries) {
            this.m_oldNumberOfRetries = oldNumberOfRetries;
            this.m_newNumberOfRetries = newNumberOfRetries;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setNumberOfSignonRetries(this.m_oldNumberOfRetries);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setNumberOfSignonRetries(this.m_newNumberOfRetries);
        }
    }

    private class SetGridSuppJobOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldGridSuppJobOptions;
        private String m_newGridSuppJobOptions;

        public SetGridSuppJobOptionsUndoable(String oldGridSuppJobOptions, String newGridSuppJobOptions) {
            this.m_oldGridSuppJobOptions = oldGridSuppJobOptions;
            this.m_newGridSuppJobOptions = newGridSuppJobOptions;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setGridSuppJobOptions(this.m_oldGridSuppJobOptions);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setGridSuppJobOptions(this.m_newGridSuppJobOptions);
        }
    }

    private class SetErrorOnUnknownStatusUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldErrorOnUnknownStatus;
        private boolean m_newErrorOnUnknownStatus;

        public SetErrorOnUnknownStatusUndoable(boolean oldErrorOnUnknownStatus, boolean newErrorOnUnknownStatus) {
            this.m_oldErrorOnUnknownStatus = oldErrorOnUnknownStatus;
            this.m_newErrorOnUnknownStatus = newErrorOnUnknownStatus;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setErrorOnUnknownStatus(this.m_oldErrorOnUnknownStatus);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setErrorOnUnknownStatus(this.m_newErrorOnUnknownStatus);
        }
    }

    private class ParameterHolder {
    }

    public class ForkTransformPromptModel
    extends BaseTransformPromptModel
    implements IPromptModel {
        public ForkTransformPromptModel(IModel model, ForkTransformModel owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model, owner, owner.getDataSourceList() != null ? owner.getSourceTables() : null, owner.getDataTargetList() != null ? owner.getTargetTables() : null);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(ForkTransformModel.class.getResource("res/Options_AdvancedFork_Template.xml"));
            PromptGroupInterface combined = this.combinePromptGroups(grp1, grp);
            this.setTransformPromptGroup(combined);
            return combined;
        }

        @Override
        protected IModelListener createModelListener() {
            return new ForkTransformModelListener((ForkTransformModel)this.getOwner(), this);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            this.setOptionValue("HANDLE_PREFIX", (Object)((ForkTransformModel)this.getOwner()).getHandlePrefix());
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new ForkPromptValueChangedListener((ForkTransformModel)this.getOwner(), this);
        }

        private class ForkTransformModelListener
        extends BaseDataTransformModelListener {
            public ForkTransformModelListener(ForkTransformModel transform, IPromptModel prompt) {
                super(transform, prompt);
            }

            @Override
            public void modelChanged(ModelEvent ev) {
                block9: {
                    if (ev.getModelObject() != this.getModelObject()) {
                        return;
                    }
                    super.modelChanged(ev);
                    String type = ev.getType();
                    try {
                        if (!type.equals(ForkTransformModel.HANDLE_PREFIX_CHANGED)) break block9;
                        this.getPromptModel().setListeningForChanges(false);
                        try {
                            this.m_promptModel.setOptionValue("HANDLE_PREFIX", (Object)ForkTransformModel.this.getHandlePrefix());
                        }
                        finally {
                            this.getPromptModel().setListeningForChanges(true);
                        }
                    }
                    catch (ServerConnectionException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                    }
                    catch (ServiceException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                    }
                    catch (RemoteException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                    }
                    catch (MdException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                    }
                }
            }
        }

        private class ForkPromptValueChangedListener
        extends BaseDataTransformValueChangedListener {
            public ForkPromptValueChangedListener(ForkTransformModel transform, IPromptModel promptModel) {
                super(transform, promptModel);
            }

            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    if (def.getPromptName().equals("HANDLE_PREFIX")) {
                        ForkTransformModel.this.setHandlePrefix(event.getNewValue() != null ? event.getNewValue().toString() : null);
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class AddMappingUndoable
    extends AbstractUndoableEdit {
        private IMapping m_mapping;
        private IColumn m_targetColumn;

        public AddMappingUndoable(IMapping mapping, IColumn targetColumn) {
            this.m_mapping = mapping;
            this.m_targetColumn = targetColumn;
        }

        @Override
        public void undo() {
            ForkTransformModel.this.removeMapping(this.m_mapping);
            ITable targetTable = ForkTransformModel.this.getTargetTable();
            if (targetTable != null) {
                targetTable.removeColumn(this.m_targetColumn);
            }
        }

        @Override
        public void redo() {
            ForkTransformModel.this.addMapping(this.m_mapping);
            ITable targetTable = ForkTransformModel.this.getTargetTable();
            if (targetTable != null && !targetTable.containsColumn(this.m_targetColumn)) {
                targetTable.addColumn(this.m_targetColumn);
            }
            this.m_mapping.addTarget(this.m_targetColumn);
        }
    }

    private class RemoveMappingUndoable
    extends AbstractUndoableEdit {
        private IMapping m_mapping;
        private IColumn m_targetColumn;

        public RemoveMappingUndoable(IMapping mapping, IColumn targetColumn) {
            this.m_mapping = mapping;
            this.m_targetColumn = targetColumn;
        }

        @Override
        public void undo() {
            ForkTransformModel.this.addMapping(this.m_mapping);
            ITable targetTable = ForkTransformModel.this.getTargetTable();
            if (targetTable != null && !targetTable.containsColumn(this.m_targetColumn)) {
                targetTable.addColumn(this.m_targetColumn);
            }
            if (!Arrays.asList(this.m_mapping.getTargets()).contains(this.m_targetColumn)) {
                this.m_mapping.addTarget(this.m_targetColumn);
            }
        }

        @Override
        public void redo() {
            ForkTransformModel.this.removeMapping(this.m_mapping);
            ITable targetTable = ForkTransformModel.this.getTargetTable();
            if (targetTable != null) {
                targetTable.removeColumn(this.m_targetColumn);
            }
        }
    }

    private class SetNumberOfMaximumConcurrentProcessingUndoable
    extends AbstractUndoableEdit {
        private int m_oldNumberOfMaximumConcurrentProcessing;
        private int m_newNumberOfMaximumConcurrentProcessing;

        public SetNumberOfMaximumConcurrentProcessingUndoable(int oldNumberOfMaximumConcurrentProcessing, int newNumberOfMaximumConcurrentProcessing) {
            this.m_oldNumberOfMaximumConcurrentProcessing = oldNumberOfMaximumConcurrentProcessing;
            this.m_newNumberOfMaximumConcurrentProcessing = newNumberOfMaximumConcurrentProcessing;
        }

        @Override
        public void undo() {
            super.undo();
            ForkTransformModel.this.setNumberofMaximumConcurrentProcessing(this.m_oldNumberOfMaximumConcurrentProcessing);
        }

        @Override
        public void redo() {
            super.redo();
            ForkTransformModel.this.setNumberofMaximumConcurrentProcessing(this.m_newNumberOfMaximumConcurrentProcessing);
        }
    }
}

