/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.facttable;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.facttable.BaseFactTableMapping;
import com.sas.etl.models.job.transforms.facttable.FactTableCodegen;
import com.sas.etl.models.job.transforms.facttable.IFactTableMapping;
import com.sas.etl.models.job.transforms.facttable.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FactTableTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.scd.FactTable";
    private static final String TRANSFORMATION_ROLE = "FACTTABLE";
    private static final String ARM_DISPLAY_NAME = "FactTable";
    private IPhysicalTable m_sourceTable;
    private IPhysicalTable m_targetTable;
    private String m_errorTableName;
    public static final String ERROR_TABLE_NAME_CHANGED = "FactTableTransformModel:ErrorTableNameChanged";
    protected static final String PROPERTY_NAME_ERROR_TABLE_NAME = "ErrorTable";

    public FactTableTransformModel(String sID, IModel model) {
        super(sID, model);
        this.createConditionActionSetTemplates();
        this.m_errorTableName = "";
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.startCompoundUndoable();
        try {
            super.addDefaultSettings();
            this.loadConditionActionSetTemplatesFromOMR();
            this.addNewWorkTable();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETDATAEXCEPTION");
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("FactTableTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("FactTableTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    public IFactTableMapping[] getFactTableMappings() {
        IMapping[] mappings = this.getMappings();
        ArrayList<IMapping> factTableMaps = new ArrayList<IMapping>();
        for (int i = 0; i < mappings.length; ++i) {
            if (!(mappings[i] instanceof IFactTableMapping)) continue;
            factTableMaps.add(mappings[i]);
        }
        return factTableMaps.toArray(new IFactTableMapping[factTableMaps.size()]);
    }

    public IFactTableMapping createNewFactTableMapping() {
        this.startCompoundUndoable();
        try {
            BaseFactTableMapping factMap = new BaseFactTableMapping(this.createIDForNewObject(), this.getModel());
            factMap.setType(TRANSFORMATION_ROLE);
            BaseFactTableMapping baseFactTableMapping = factMap;
            return baseFactTableMapping;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        FactTableCodegen cg = new FactTableCodegen(this);
        cg.getGeneratedCode(codeSegment);
        return codeSegment;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setErrorTableName(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_ERROR_TABLE_NAME, "", 2));
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_ERROR_TABLE_NAME, PROPERTY_NAME_ERROR_TABLE_NAME, PROPERTY_NAME_ERROR_TABLE_NAME, this.getErrorTableName(), 12, 2);
        this.setChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTargetColumnFromMappings(IColumn column) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                if (!mapping.containsInTargets(column) || mapping.getType() != TRANSFORMATION_ROLE) continue;
                this.removeMapping(mapping);
            }
            super.removeTargetColumnFromMappings(column);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getSourceTable() {
        if (this.getSourceTables().length > 0) {
            return (IPhysicalTable)this.getDataSources()[0];
        }
        return null;
    }

    public IPhysicalTable getTargetTable() {
        if (this.getTargetTables().length > 0) {
            return (IPhysicalTable)this.getDataTargets()[0];
        }
        return null;
    }

    @Override
    public IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new FactTablePromptModel(this);
    }

    public String getErrorTableName() {
        return this.m_errorTableName;
    }

    public void setErrorTableName(String errorTableName) {
        if (errorTableName == null) {
            return;
        }
        if (this.m_errorTableName.equals(errorTableName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetErrorTableNameUndoable(this.m_errorTableName, errorTableName));
        }
        this.m_errorTableName = errorTableName;
        this.fireModelChangedEvent(ERROR_TABLE_NAME_CHANGED, this.m_errorTableName);
    }

    private class FactTablePromptModel
    extends BaseDataTransformPromptModel {
        public FactTablePromptModel(FactTableTransformModel model) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model.getModel(), model);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(FactTableTransformModel.class.getResource("res/Options_FactTable_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected IModelListener createModelListener() {
            return new FactTableModelListener(this.getOwner(), this);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            this.setOptionValue(FactTableTransformModel.PROPERTY_NAME_ERROR_TABLE_NAME, (Object)((FactTableTransformModel)this.getOwner()).getErrorTableName());
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new FactTableValueChangeListener((FactTableTransformModel)this.getOwner(), this);
        }

        private class FactTableModelListener
        extends BaseDataTransformModelListener {
            public FactTableModelListener(IObject object, IPromptModel promptModel) {
                super(object, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                String type = ev.getType();
                this.getPromptModel().setListeningForChanges(false);
                try {
                    if (FactTableTransformModel.ERROR_TABLE_NAME_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(FactTableTransformModel.PROPERTY_NAME_ERROR_TABLE_NAME, (Object)FactTableTransformModel.this.getErrorTableName());
                    }
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class FactTableValueChangeListener
        extends BaseDataTransformValueChangedListener {
            public FactTableValueChangeListener(FactTableTransformModel owner, IPromptModel promptModel) {
                super(owner, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    if (FactTableTransformModel.PROPERTY_NAME_ERROR_TABLE_NAME.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        FactTableTransformModel.this.setErrorTableName(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class SetErrorTableNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldErrorTableName;
        private String m_newErrorTableName;

        public SetErrorTableNameUndoable(String oldErrorTableName, String newErrorTableName) {
            this.m_oldErrorTableName = oldErrorTableName;
            this.m_newErrorTableName = newErrorTableName;
        }

        @Override
        public void undo() {
            super.undo();
            FactTableTransformModel.this.setErrorTableName(this.m_oldErrorTableName);
        }

        @Override
        public void redo() {
            super.redo();
            FactTableTransformModel.this.setErrorTableName(this.m_newErrorTableName);
        }
    }
}

