/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.facttable;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.transforms.facttable.IFactTableMapping;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseFactTableMapping
extends BaseMapping
implements IFactTableMapping {
    private static final String TRANSLATION_ROLE = "TRANSLATOR";
    private IMapping m_translationMapping;
    private String m_strAction;
    private static final String ACTION_PROPERTY_NAME = "UNAVAILABLEACTION";

    public BaseFactTableMapping(String sId, IModel model) {
        super(sId, model);
        this.setName("Fact Table Map");
        this.m_strAction = "Move row to error table";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMapping createNewTranslationMapping(IColumn sourceColumn, IColumn targetColumn) {
        if (sourceColumn == null || targetColumn == null) {
            throw new IllegalArgumentException("BaseFactTableMapping: both translation source and translation target column must be non-null");
        }
        this.startCompoundUndoable();
        try {
            BaseMapping mapping = new BaseMapping(this.createIDForNewObject(), this.getModel());
            mapping.setName("Translate Map");
            mapping.setType(TRANSLATION_ROLE);
            mapping.addSource(sourceColumn);
            mapping.addTarget(targetColumn);
            this.setTranslationMapping(mapping);
            BaseMapping baseMapping = mapping;
            return baseMapping;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void setAction(String action) {
        if (this.m_strAction.equals(action)) {
            return;
        }
        if (!("Move row to error table".equals(action) || "None".equals(action) || "Abort job".equals(action))) {
            throw new IllegalArgumentException(action + " not valid action");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetActionUndoable(this.m_strAction, action));
        }
        this.m_strAction = action;
        this.fireModelChangedEvent("IFactTableMapping:ActionChanged", action);
    }

    @Override
    public String getAction() {
        return this.m_strAction;
    }

    @Override
    public IColumn getSourceColumn() {
        IColumn[] srcs = this.getSources();
        if (srcs.length > 0) {
            return srcs[0];
        }
        return null;
    }

    @Override
    public void setSourceColumn(IColumn sourceColumn) {
        this.startCompoundUndoable();
        try {
            this.clearSources();
            this.addSource(sourceColumn);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IColumn getTargetColumn() {
        IColumn[] targets = this.getTargets();
        if (targets.length > 0) {
            return targets[0];
        }
        return null;
    }

    @Override
    public void setTargetColumn(IColumn targetColumn) {
        this.startCompoundUndoable();
        try {
            this.clearTargets();
            this.addTarget(targetColumn);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IColumn getTranslationSourceColumn() {
        IColumn[] srcs;
        IMapping map = this.getTranslationMapping();
        if (map != null && (srcs = map.getSources()).length > 0) {
            return srcs[0];
        }
        return null;
    }

    @Override
    public IColumn getTranslationTargetColumn() {
        IColumn[] targets;
        IMapping map = this.getTranslationMapping();
        if (map != null && (targets = map.getTargets()).length > 0) {
            return targets[0];
        }
        return null;
    }

    public void updateIds(Map mapIDs) {
        if (!this.isNew()) {
            return;
        }
        super.updateIDs(mapIDs);
        IMapping translation = this.getTranslationMapping();
        if (translation != null) {
            translation.updateIDs(mapIDs);
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        super.deleteFromOMR(omr);
        IMapping translation = this.getTranslationMapping();
        if (translation != null) {
            translation.deleteFromOMR(omr);
        }
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        IMapping translation = this.getTranslationMapping();
        return translation != null && translation.isChanged();
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        IMapping translation = this.getTranslationMapping();
        if (translation != null) {
            reasons.addAll(translation.getReasonsIncomplete());
        }
        return reasons;
    }

    @Override
    public String getType() {
        return "FACTTABLE";
    }

    public void setTranslationMapping(IMapping translation) {
        if (this.m_translationMapping == translation) {
            return;
        }
        if (this.m_translationMapping != null) {
            this.addToDeletedObjects(this.m_translationMapping);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTranslationMappingUndoable(this.m_translationMapping, translation));
        }
        this.m_translationMapping = translation;
        if (this.m_translationMapping != null) {
            this.removeFromDeletedObjects(this.m_translationMapping);
        }
        this.fireModelChangedEvent("IFactTableMapping:TranslationMappingChanged", this.m_translationMapping);
    }

    public IMapping getTranslationMapping() {
        return this.m_translationMapping;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Root omrObj;
        super.loadFromOMR(omr);
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        AssociationList transSources = mdoFM.getTransformationSources();
        IMapping translationMapping = null;
        if (!transSources.isEmpty() && (omrObj = (Root)transSources.get(0)) instanceof FeatureMap && TRANSLATION_ROLE.equals(((FeatureMap)omrObj).getTransformRole())) {
            AssociationList tarColumns;
            FeatureMap map = (FeatureMap)omrObj;
            AssociationList srcColumns = map.getFeatureSources();
            if (!srcColumns.isEmpty()) {
                Column column = (Column)srcColumns.get(0);
                omr.acquireObject((Root)column.getTable());
            }
            if (!(tarColumns = map.getFeatureTargets()).isEmpty()) {
                Column column = (Column)tarColumns.get(0);
                omr.acquireObject((Root)column.getTable());
            }
            translationMapping = (IMapping)omr.acquireObject(omrObj);
        }
        this.setTranslationMapping(translationMapping);
        this.setAction(this.loadPropertyFromOMR(omr, "", ACTION_PROPERTY_NAME, "None", 1));
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        AssociationList transSources = mdoFM.getTransformationSources(false);
        transSources.clear();
        IMapping translationMapping = this.getTranslationMapping();
        if (translationMapping != null) {
            translationMapping.saveToOMR(omr);
            transSources.add(omr.acquireOMRObject(translationMapping));
        }
        this.savePropertyToOMR(omr, "", ACTION_PROPERTY_NAME, ACTION_PROPERTY_NAME, ACTION_PROPERTY_NAME, this.getAction(), 12, 1);
        this.setChanged(false);
    }

    private class SetActionUndoable
    extends AbstractUndoableEdit {
        private String m_oldAction;
        private String m_newAction;

        public SetActionUndoable(String oldAction, String newAction) {
            this.m_oldAction = oldAction;
            this.m_newAction = newAction;
        }

        @Override
        public void undo() {
            super.undo();
            BaseFactTableMapping.this.setAction(this.m_oldAction);
        }

        @Override
        public void redo() {
            super.redo();
            BaseFactTableMapping.this.setAction(this.m_newAction);
        }
    }

    private class SetTranslationMappingUndoable
    extends AbstractUndoableEdit {
        private IMapping m_oldMapping;
        private IMapping m_newMapping;

        public SetTranslationMappingUndoable(IMapping oldMapping, IMapping newMapping) {
            this.m_oldMapping = oldMapping;
            this.m_newMapping = newMapping;
        }

        @Override
        public void undo() {
            super.undo();
            BaseFactTableMapping.this.setTranslationMapping(this.m_oldMapping);
        }

        @Override
        public void redo() {
            super.redo();
            BaseFactTableMapping.this.setTranslationMapping(this.m_newMapping);
        }
    }
}

