/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.edmflow;

import com.sas.etl.models.DISUsageVersion;
import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IGeneratedTable;
import com.sas.etl.models.data.IGeneratedTableColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.edmflow.IEDMFlow;
import com.sas.etl.models.data.edmflow.IEDMFlowColumn;
import com.sas.etl.models.data.edmflow.IEDMFlowTable;
import com.sas.etl.models.data.edmflow.IEDMFlowVersion;
import com.sas.etl.models.data.edmflow.impl.BaseEDMFlow;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformModel;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformOptionModel;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformOptionModelListener;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformOptionValueChangeListener;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.DefaultMappingRules;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.common.ITransformTemplate;
import com.sas.etl.models.job.transforms.common.impl.BaseTransformPort;
import com.sas.etl.models.job.transforms.edmflow.EDMFlowTargetTablePort;
import com.sas.etl.models.job.transforms.edmflow.RB;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMapping;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMappingsContainer;
import com.sas.etl.models.job.transforms.edmflow.mapping.impl.EDMFlowMapping;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class EDMFlowTransformModel
extends AbstractMultiplePortTransformModel
implements IEDMFlowMappingsContainer {
    private static final String PROPERTY_NAME_TYPE = "OUTPUT_TYPE";
    public static final String TRANSFORMATION_CLASS = "com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel";
    public static final String TRANSFORMATION_ROLE = "com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel";
    private static final String ARM_DISPLAY_NAME = "EDMFlow";
    public static final String EDM_FLOW_CHANGED = "EDMFlowTransformModel:EDMFlowChanged";
    private static final String CM_NAME = "EDMFlow";
    private static final String PROPERTY_NAME_EDM_VERSION = "EDMVersion";
    private IEDMFlowVersion _version;
    private IEDMFlow m_edm;
    public static final String PORT_NAME_STATS_TABLE = "STATS_TABLE";
    public static final String PORT_NAME_RESULTS_TABLE = "RESULTS_TABLE";
    private static final String INPUT_TABLE_MACRO_VAR = "ds_input_table";
    private static final String RESULTS_TABLE_MACRO_VAR = "ds_output_table";
    private static final String STATS_TABLE_MACRO_VAR = "ds_stats_table";
    private static final String SOURCE_TABLE_MACRO_VAR = "ds_source_table";
    private static final String EDM_INPUT_VIEW_NAME = "EDM_Flow_Input";
    private static final String SOURCETABLEOPTIONS = "SOURCETABLEOPTIONS";
    private static final String RESULTSTABLEOPTIONS = "RESULTSTABLEOPTIONS";
    private static final String STATSTABLEOPTIONS = "STATSTABLEOPTIONS";
    private static final String BATCH_JOB_ID = "ds_batch_job_id";
    private String m_sSourceTableName;
    private String m_sResultsTableName;
    private String m_sStatsTableName;
    private static final String ODBC_CONNECT_TYPE = "ODBC";
    private EDMFlowMappingList m_edmFlowMappings = new EDMFlowMappingList(this);

    public EDMFlowTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        ITransformTemplate t = this.createDefaultTemplate();
        ITransformPort<? extends IDataObject> inputPort = this.createNewPort(this.getModel(), this.getID(), "SOURCE_TABLE");
        inputPort.setName("INPUTTABLE");
        t.addSourcePort(inputPort);
        this.setTemplate(t);
    }

    @Override
    public ITransformPort<? extends IDataObject> createPort(IModel model, String id, String partnerName) {
        IEDMFlowTable table;
        EDMFlowTargetTablePort port = null;
        IEDMFlowVersion version = this.getEDMFlowVersion();
        if (version != null && partnerName != null && (table = version.findOutputTable(partnerName)) != null) {
            port = new EDMFlowTargetTablePort(id, model);
            this.updateGeneratedTable(partnerName, port);
            if (PORT_NAME_STATS_TABLE.equals(partnerName)) {
                port.setOptional(true);
            } else {
                port.setOptional(false);
            }
        }
        if (port == null) {
            port = new BaseTransformPort(id, this.getModel());
        }
        port.setPartnerName(partnerName);
        return port;
    }

    private void updateGeneratedTable(String partnerName, ITransformPort<?> port) {
        if (PORT_NAME_RESULTS_TABLE.equals(partnerName) || PORT_NAME_STATS_TABLE.equals(partnerName)) {
            IEDMFlowVersion version = this.getEDMFlowVersion();
            IEDMFlowTable table = version != null ? version.findOutputTable(partnerName) : null;
            port.setGeneratedTable(table);
        }
    }

    private ITransformTemplate updateTemplateForVersion(boolean createTemplate, IEDMFlowVersion version, IPhysicalTable sourceTable, String containerId, IModel model, ITransformTemplate template) {
        if (version == null) {
            return template;
        }
        if (template == null && createTemplate) {
            template = this.createTemplate(model.createIDForNewObject(containerId), model);
            this.setTemplate(template);
        } else if (template == null) {
            return template;
        }
        IEDMFlowTable input = version.getInput();
        ITransformPort<Object> inputPort = template.findSourcePort(input.getID());
        if (inputPort == null) {
            inputPort = this.createPort(this.getModel(), model.createIDForNewObject(containerId), input.getID());
            template.addSourcePort(inputPort);
        }
        inputPort.setName(input.getName());
        inputPort.setDescription(input.getDescription());
        inputPort.setGeneratedTable(input);
        for (IEDMFlowTable output : version.getOutputs()) {
            ITransformPort<Object> outPort = template.findTargetPort(output.getID());
            if (outPort == null) {
                outPort = this.createPort(this.getModel(), model.createIDForNewObject(containerId), output.getID());
                template.addTargetPort(outPort);
                IProperty type = model.getObjectFactory().createNewProperty(containerId);
                type.setPropertyName(PROPERTY_NAME_TYPE);
                type.setName(PROPERTY_NAME_TYPE);
                type.setDefaultValue(output.getType());
                type.setPropertyRole(PROPERTY_NAME_TYPE);
                outPort.addProperty(type);
            }
            outPort.setGeneratedTable(output);
            outPort.setName(output.getName());
            outPort.setDescription(output.getDescription());
            if (outPort.getObject() != null || !outPort.isNew() && outPort.isOptional()) continue;
            outPort.setObject(output.createNewTable(sourceTable, model, containerId));
        }
        return template;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("EDMFlowTransformModel.Name.txt");
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoTargetsMeanIncomplete() {
        return false;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("EDMFlowTransformModel.Name.txt");
    }

    @Override
    public String getAbsoluteName() {
        return "EDMFlow";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel";
    }

    public static String getTransformTypeID() {
        return "com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel";
    }

    @Override
    protected void addDefaultTemplate() throws MdException, RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataSource(ITransformPort port, IDataObject source) {
        this.startCompoundUndoable();
        try {
            super.addDataSource(port, source);
            if (source != null) {
                for (IColumn sourceColumn : ((IPhysicalTable)source).getColumns()) {
                    for (IPhysicalTable target : this.getTargetTables()) {
                        IColumn matchingTarget = target.getColumnWithMatchingName(sourceColumn.getName());
                        if (matchingTarget == null) continue;
                        matchingTarget.setType(sourceColumn.getType());
                        matchingTarget.setLength(sourceColumn.getLength());
                        matchingTarget.setDescription(sourceColumn.getDescription());
                        matchingTarget.setFormat(sourceColumn.getFormat());
                        matchingTarget.setInformat(sourceColumn.getInformat());
                    }
                }
                IEDMFlowTable edmSource = this.getSourceEDMFlowTable();
                if (edmSource != null) {
                    IPhysicalTable src = (IPhysicalTable)source;
                    for (IEDMFlowColumn c : edmSource.getColumns()) {
                        IColumn sourceColumn = src.getColumnWithMatchingName(c.getName());
                        if (sourceColumn == null) continue;
                        this.mapColumns(new IColumn[]{sourceColumn}, new IEDMFlowColumn[]{c});
                    }
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSource(IDataObject source) {
        this.startCompoundUndoable();
        try {
            for (IEDMFlowMapping m : this.getEDMFlowMappings()) {
                this.removeMapping(m);
            }
            super.removeDataSource(source);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected boolean canSetTemplate(ITransformTemplate newTemplate) {
        return this.getTemplate() == null;
    }

    @Override
    protected void templateChangedRequested(ITransformTemplate newTemplate) {
        if (newTemplate == null) {
            return;
        }
        ITransformTemplate oldTemplate = this.getTemplate();
        if (oldTemplate == null) {
            this.updateTemplateForVersion(false, this.getEDMFlowVersion(), this.getSourceTable(), this.getID(), this.getModel(), newTemplate);
            return;
        }
        for (ITransformPort<?> p : newTemplate.getTargetPorts()) {
            if (oldTemplate.findTargetPort(p.getPartnerName()) != null) continue;
            oldTemplate.addTargetPort(p);
        }
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public boolean isAddOutputAvailable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPortGeneratedTable(ITransformPort<IPhysicalTable> port) {
        IGeneratedTable<IGeneratedTableColumn> table;
        if (port != null && (table = port.getGeneratedTable()) != null) {
            this.startCompoundUndoable();
            try {
                IPhysicalTable pt = table.createNewTable(this.getSourceTable(), this.getModel(), this.getID());
                if (pt != null) {
                    port.setObject(pt);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        for (IEDMFlowMapping edmMapping : this.getEDMFlowMappingList()) {
            if (!edmMapping.hasWarnings()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getWarnings() {
        List warns = super.getWarnings();
        for (IEDMFlowMapping edmMapping : this.getEDMFlowMappingList()) {
            warns.addAll(edmMapping.getWarnings());
        }
        return warns;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.m_edm != null && this._version != null && this.isEDMFlowMappingsComplete();
    }

    public boolean isEDMFlowMappingsComplete() {
        IEDMFlowTable source = this.getSourceEDMFlowTable();
        if (source != null) {
            for (IEDMFlowColumn c : source.getColumns()) {
                if (this.findTargetMapping(c) != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.m_edm == null) {
            lReasons.add(RB.getStringResource("EDMFlowTransformModel.ReasonIncomplete.NoEDMFlowSelected.txt"));
        }
        if (!this.isEDMFlowMappingsComplete()) {
            lReasons.add(RB.getStringResource("EDMFlowTransformModel.ReasonIncomplete.MappingIncomplete.txt"));
        }
        return lReasons;
    }

    public List getReasonsEDMResultsIncomplete() {
        ArrayList<String> reasons = new ArrayList<String>();
        IEDMFlowTable source = this.getSourceEDMFlowTable();
        if (source != null) {
            for (IEDMFlowColumn c : source.getColumns()) {
                if (this.findTargetMapping(c) != null) continue;
                reasons.add(MessageFormat.format(RB.getStringResource("EDMFlowTransformModel.TermMissingMaping.txt"), c.getName()));
            }
        }
        return reasons;
    }

    public IEDMFlowVersion getEDMFlowVersion() {
        return this._version;
    }

    public void setEDMFlowVersion(IEDMFlowVersion version) {
        this.setEDMFlowVersion(version, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEDMFlowVersion(IEDMFlowVersion version, boolean setTemplate) {
        if (this._version == version) {
            return;
        }
        this.startCompoundUndoable();
        IEDMFlowVersion old = this._version;
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetEDMFlowVersionUndoable(this._version, old));
            }
            this._version = version;
            this.updateTemplateForVersion(setTemplate, this._version, this.getSourceTable(), this.getID(), this.getModel(), this.getTemplate());
            this.fireModelChangedEvent("EDMFlowTransformModel:EDMFlowVersionChanged", this._version, old);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IEDMFlow getEDMFlow() {
        return this.m_edm;
    }

    public void setEDMFlow(IEDMFlow edm) {
        this.setEDMFlow(edm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEDMFlow(IEDMFlow edm, boolean setDefaultVersion) {
        if (this.m_edm == edm) {
            return;
        }
        this.startCompoundUndoable();
        IEDMFlow old = this.m_edm;
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetEDMFlowUndoable(this.m_edm, edm));
            }
            this.m_edm = edm;
            this.fireModelChangedEvent(EDM_FLOW_CHANGED, this.m_edm, old);
            if (setDefaultVersion) {
                this.setEDMFlowVersion(this.m_edm != null ? this.m_edm.getDefaultVersion() : null);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected ICodeSegment createBatchJobIDMacro(ICodeSegment codeSegment) {
        codeSegment.addCommentLine(RB.getStringResource("EDMFlowTransformModel.BatchJobID.Created.comment.txt"));
        codeSegment.addSourceCode("%let ").addSourceCode(BATCH_JOB_ID).addSourceCode("=;\n").addSourceCode("data _null_;\n").addSourceCode("batch_job_ID=compress(put(datetime(),datetime32.),':');\n").addSourceCode("call symput('ds_batch_job_id',trim(left(put(batch_job_ID,$32.))));\n").addSourceCode("run;\n");
        return codeSegment;
    }

    protected String booleanToYesNo(boolean bool) {
        return bool ? "YES" : "NO";
    }

    protected boolean yesNoToBoolean(String YesNo) {
        return YesNo.equalsIgnoreCase("YES");
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cEDMFlowsOptionModel(this.getModel(), this);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IEDMFlowVersion version;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        mdoCM.setTransformRole("EDMFlow");
        AssociationList lSourceSpecifications = mdoCM.getSourceSpecifications();
        lSourceSpecifications.clear();
        IEDMFlow flow = this.getEDMFlow();
        if (flow != null) {
            Transformation mdoFlow = (Transformation)omr.acquireOMRObject(flow);
            lSourceSpecifications.add(mdoFlow);
        }
        String strVersion = (version = this.getEDMFlowVersion()) == null ? "" : version.getVersion().toString();
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_EDM_VERSION, strVersion);
        this.m_edmFlowMappings.saveToOMR(omr, (List)mdoCM.getFeatureMaps());
        this.setChanged(false);
    }

    @Override
    protected void clearListsBeforeLoad() {
    }

    public void clearMappingListAfterNewFlowSet(List mapList) {
        mapList.clear();
    }

    public EDMFlowMappingList getPriorMappings() {
        return this.m_edmFlowMappings;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        ClassifierMap mdoCM;
        super.clearListsBeforeLoad();
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList lTransformations = mdoStep.getTransformations();
        if (!lTransformations.isEmpty()) {
            mdoCM = (ClassifierMap)lTransformations.get(0);
            this.setClassifierMapId(mdoCM.getFQID());
        }
        mdoCM = this.getClassifierMapObject(omr);
        AssociationList lSourceSpecs = mdoCM.getSourceSpecifications();
        IEDMFlow flow = null;
        for (int iSource = 0; iSource < lSourceSpecs.size(); ++iSource) {
            Object mdObject = lSourceSpecs.get(iSource);
            if (!(mdObject instanceof Transformation) || !"DecisionLogic".equals(((Transformation)mdObject).getPublicType())) continue;
            try {
                flow = (IEDMFlow)omr.acquireObject((Root)mdObject);
                this.setEDMFlow(flow, false);
                continue;
            }
            catch (MdException e) {
                this.setEDMFlow(null, false);
            }
        }
        String v = this.loadStringOptionFromOMR(omr, PROPERTY_NAME_EDM_VERSION, new DISUsageVersion(0, 0).toString());
        if (v != null && flow != null) {
            IEDMFlowVersion version = flow.findVersion(BaseEDMFlow.convertToUsageVersion(v));
            try {
                if (version != null) {
                    version.loadFromOMR();
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
            this.setEDMFlowVersion(version, false);
        } else {
            this.setEDMFlowVersion(null);
        }
        super.loadFromOMR(omr);
        this.m_edmFlowMappings.loadFromOMR(omr, (List)mdoCM.getFeatureMaps());
        this.setChanged(false);
    }

    @Override
    protected void loadMappingsFromOMR(OMRAdapter omr, ClassifierMap mdoCM) throws MdException, RemoteException {
        AssociationList lFMs = mdoCM.getFeatureMaps();
        for (int iFM = 0; iFM < lFMs.size(); ++iFM) {
            FeatureMap mdoFM = (FeatureMap)lFMs.get(iFM);
            if ("EDMFlow".equals(mdoFM.getTransformRole())) continue;
            IMapping mapping = this.createMapping(omr, mdoFM);
            if (mapping.isDead()) {
                this.addToDeletedObjects(mapping);
                continue;
            }
            this.addMapping(mapping);
        }
    }

    @Override
    public ICodeSegment getAdditionalTransformationComment(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        IEDMFlowVersion version;
        IEDMFlow flow = this.getEDMFlow();
        codeSegment.genCommentLine("", "", "");
        codeSegment.addSourceCode(codeSegment.getCommentLine(RB.getStringResource("EDMFlowTransformModel.EDMFlowComment.label.txt"), "", ""));
        String flowValue = RB.getStringResource("EDMFlowTransformModel.EDMFlowCommentValue.None.txt");
        if (flow != null) {
            flowValue = flow.getName();
        }
        codeSegment.addSourceCode(codeSegment.getCommentLine("   ", flowValue, flow != null ? flow.getID() : ""));
        if (flow != null) {
            codeSegment.addSourceCode(codeSegment.getCommentLine("   " + "   " + flow.getFolder().getURLtoFolder(), "", ""));
        }
        String versionName = (version = this.getEDMFlowVersion()) != null ? version.getVersion().toString() : RB.getStringResource("EDMFlowTransformModel.EDMFlowCommentValue.None.txt");
        codeSegment.addSourceCode(codeSegment.getCommentLine("   " + RB.getStringResource("EDMFlowTransformModel.EDMFlowVersionComment.label.txt"), "   " + versionName, ""));
        if (flow != null) {
            codeSegment.addSourceCode(codeSegment.getCommentLine("   " + RB.getStringResource("EDMFlowTransformModel.EDMFlowCommentProperties.label.txt"), "", ""));
        }
        return codeSegment;
    }

    @Override
    protected ICodeSegment getCodeForTransform(ICodeSegment codeSegment, boolean validateCode) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ITransformPort<? extends IDataObject> statsPort;
        IPhysicalTable m_statsTable;
        this.genTableDelete(codeSegment, Arrays.asList(this.getTargetTables()));
        IEDMFlowVersion flowVersion = this.getEDMFlowVersion();
        codeSegment.addSourceCode("%macro etls_EDMFlow;\n\n").indent();
        this.createBatchJobIDMacro(codeSegment);
        ITransformPort<? extends IDataObject> sourcePort = this.getSourcePorts().get(0);
        IPhysicalTable m_sourceTable = (IPhysicalTable)sourcePort.getObject();
        codeSegment.addSourceCode("\n").addCommentLine(RB.getStringResource("EDMFlowTransformModel.Source.Table.Macro.Name.comment.txt"));
        IServer cServer = m_sourceTable.getServer(this.getExecutionServer());
        if (m_sourceTable.getDBMSType().getDBMSTypeID() == 9) {
            this.m_sSourceTableName = m_sourceTable.isQuoted() ? m_sourceTable.getLibref(cServer) + "." + m_sourceTable.getFullNameQuotedAsNeeded(cServer, true, true, true, "") : m_sourceTable.getLibref(cServer) + "." + m_sourceTable.getTableName(false);
        } else if (m_sourceTable.getDBMSType().getDBMSTypeID() == 1 || m_sourceTable.getDBMSType().getDBMSTypeID() == 7 || m_sourceTable.getDBMSType().getDBMSTypeID() == 10 || m_sourceTable.getDBMSType().getDBMSTypeID() == 20 || m_sourceTable.getDBMSType().getDBMSTypeID() == 26 || m_sourceTable.getDBMSType().getConnectionType() == ODBC_CONNECT_TYPE || m_sourceTable.getDBMSType().getDBMSTypeID() == 12 || m_sourceTable.getDBMSType().getDBMSTypeID() == 21) {
            this.m_sSourceTableName = m_sourceTable.isQuoted() ? m_sourceTable.getLibref(cServer) + "." + m_sourceTable.getFullNameQuotedAsNeeded(cServer, true, true, true, "") : m_sourceTable.getLibref(cServer) + "." + m_sourceTable.getFullNameQuotedAsNeeded(cServer, false, true, false, "");
        } else {
            codeSegment.addCommentLine(RB.getStringResource("EDMFlowTransformModel.NonSupported.DatabaseTable.txt"));
        }
        codeSegment.addSourceCode("%let ").addSourceCode(SOURCE_TABLE_MACRO_VAR).addSourceCode("= %nrquote(").addSourceCode(this.m_sSourceTableName).addSourceCode(");\n");
        if (m_sourceTable.getDBMSType().getDBMSTypeID() == 21) {
            this.m_sSourceTableName = m_sourceTable.getFullNameQuotedAsNeeded(codeSegment);
        }
        ITransformTableOptions sourceOpts = this.getTableOptionObject(m_sourceTable, true);
        String sourceTableOptions = "";
        if (sourceOpts != null) {
            sourceTableOptions = sourceOpts.getTableOptions(false, null);
        }
        codeSegment.addSourceCode("%let ").addSourceCode(SOURCETABLEOPTIONS).addSourceCode(" = %nrquote(").addSourceCode(codeSegment.getEscapedMacroValue(sourceTableOptions)).addSourceCode(");\n\n");
        codeSegment.addCommentLine(RB.getStringResource("EDMFlowTransformModel.Input.Table.Macro.Name.comment.txt"));
        boolean FedSQLViewNeeded = false;
        FedSQLViewNeeded = this.mappingsAreNecessary(m_sourceTable);
        if (!FedSQLViewNeeded) {
            codeSegment.addSourceCode("%let ").addSourceCode(INPUT_TABLE_MACRO_VAR).addSourceCode("= %nrquote(").addSourceCode(this.m_sSourceTableName).addSourceCode(");\n\n");
        } else {
            codeSegment.addSourceCode("%let ").addSourceCode(INPUT_TABLE_MACRO_VAR).addSourceCode("=%nrquote(").addSourceCode(EDM_INPUT_VIEW_NAME).addSourceCode(");\n\n");
            codeSegment.addSourceCode("proc datasets library=work nolist nowarn memtype=VIEW;\n").addSourceCode("  delete &").addSourceCode(INPUT_TABLE_MACRO_VAR).addSourceCode(";\n").addSourceCode("quit;\n\n");
            codeSegment.addSourceCode("proc FedSQL;\n").addSourceCode(" create view work.&ds_input_table as\n").indent().addSourceCode("select ");
            int count = 0;
            for (IEDMFlowMapping cMap : this.getEDMFlowMappings()) {
                IColumn sColumn = cMap.getSource();
                if (sColumn == null) continue;
                if (!sColumn.getName().equalsIgnoreCase(cMap.getName())) {
                    codeSegment.addSourceCode(sColumn != null ? sColumn.getColumnName(codeSegment.isQuoting(), true) : "").addSourceCode(" as ").addSourceCode(cMap.getTargetOfEDMFlowColumn().getName());
                    ++count;
                } else {
                    codeSegment.addSourceCode(sColumn.getName());
                    ++count;
                }
                if (count < this.getEDMFlowMappings().length) {
                    codeSegment.addSourceCode(", \n");
                    continue;
                }
                if (count != this.getEDMFlowMappings().length) continue;
                codeSegment.unIndent().addSourceCode("\n  from &").addSourceCode(SOURCE_TABLE_MACRO_VAR).addSourceCode("\n;\n quit;\n\n");
            }
        }
        ITransformPort<? extends IDataObject> resultsPort = this.getTargetPorts().get(0);
        IPhysicalTable m_resultsTable = (IPhysicalTable)resultsPort.getObject();
        if (m_resultsTable != null) {
            if (m_resultsTable.getDBMSType().getDBMSTypeID() == 9) {
                this.m_sResultsTableName = m_resultsTable.isQuoted() ? m_resultsTable.getLibref(cServer) + "." + m_resultsTable.getFullNameQuotedAsNeeded(cServer, true, true, true, "") : m_resultsTable.getLibref(cServer) + "." + m_resultsTable.getTableName(false);
            } else if (m_resultsTable.getDBMSType().getDBMSTypeID() == 1 || m_resultsTable.getDBMSType().getDBMSTypeID() == 7 || m_resultsTable.getDBMSType().getDBMSTypeID() == 10 || m_resultsTable.getDBMSType().getDBMSTypeID() == 20 || m_resultsTable.getDBMSType().getDBMSTypeID() == 26 || m_resultsTable.getDBMSType().getConnectionType() == ODBC_CONNECT_TYPE || m_resultsTable.getDBMSType().getDBMSTypeID() == 12) {
                this.m_sResultsTableName = m_resultsTable.isQuoted() ? m_resultsTable.getLibref(cServer) + "." + m_resultsTable.getFullNameQuotedAsNeeded(cServer, true, true, true, "") : m_resultsTable.getLibref(cServer) + "." + m_resultsTable.getFullNameQuotedAsNeeded(cServer, false, true, false, "");
            } else if (m_resultsTable.getDBMSType().getDBMSTypeID() == 21) {
                this.m_sResultsTableName = m_resultsTable.getFullNameQuotedAsNeeded(codeSegment);
            } else {
                codeSegment.addCommentLine(RB.getStringResource("EDMFlowTransformModel.NonSupported.DatabaseTable.txt"));
            }
            codeSegment.addCommentLine(RB.getStringResource("EDMFlowTransformModel.Results.Table.Macro.Name.comment.txt"));
            codeSegment.addSourceCode("%let ").addSourceCode(RESULTS_TABLE_MACRO_VAR).addSourceCode("=%nrquote(").addSourceCode(this.m_sResultsTableName).addSourceCode(");\n");
            ITransformTableOptions resultsOpts = this.getTableOptionObject(m_resultsTable, false);
            String resultsOptions = "";
            if (resultsOpts != null) {
                resultsOptions = resultsOpts.getTableOptions(false, null);
            }
            codeSegment.addSourceCode("%let ").addSourceCode(RESULTSTABLEOPTIONS).addSourceCode(" = %nrquote(").addSourceCode(codeSegment.getEscapedMacroValue(resultsOptions)).addSourceCode(");\n\n");
            m_resultsTable.getDBMSType().create(codeSegment, m_resultsTable, false, true, true, false, "", this);
        }
        if ((m_statsTable = (IPhysicalTable)(statsPort = this.getTargetPorts().get(1)).getObject()) != null) {
            if (m_statsTable.getDBMSType().getDBMSTypeID() == 9) {
                this.m_sStatsTableName = m_statsTable.isQuoted() ? m_statsTable.getLibref(cServer) + "." + m_statsTable.getFullNameQuotedAsNeeded(cServer, true, true, true, "") : m_statsTable.getLibref(cServer) + "." + m_statsTable.getTableName(false);
            } else if (m_statsTable.getDBMSType().getDBMSTypeID() == 1 || m_statsTable.getDBMSType().getDBMSTypeID() == 7 || m_statsTable.getDBMSType().getDBMSTypeID() == 10 || m_statsTable.getDBMSType().getDBMSTypeID() == 20 || m_statsTable.getDBMSType().getDBMSTypeID() == 26 || m_statsTable.getDBMSType().getConnectionType() == ODBC_CONNECT_TYPE || m_statsTable.getDBMSType().getDBMSTypeID() == 12) {
                this.m_sStatsTableName = m_statsTable.isQuoted() ? m_statsTable.getLibref(cServer) + "." + m_statsTable.getFullNameQuotedAsNeeded(cServer, true, true, true, "") : m_statsTable.getLibref(cServer) + "." + m_statsTable.getFullNameQuotedAsNeeded(cServer, false, true, false, "");
            } else if (m_statsTable.getDBMSType().getDBMSTypeID() == 21) {
                this.m_sStatsTableName = m_statsTable.getFullNameQuotedAsNeeded(codeSegment);
            } else {
                codeSegment.addCommentLine(RB.getStringResource("EDMFlowTransformModel.NonSupported.DatabaseTable.txt"));
            }
            codeSegment.addCommentLine(RB.getStringResource("EDMFlowTransformModel.Stats.Table.Macro.Name.comment.txt"));
            codeSegment.addSourceCode("%let ").addSourceCode(STATS_TABLE_MACRO_VAR).addSourceCode("=%nrquote(").addSourceCode(this.m_sStatsTableName).addSourceCode(");\n");
            ITransformTableOptions statsOpts = this.getTableOptionObject(m_statsTable, true);
            String statsOptions = "";
            if (statsOpts != null) {
                statsOptions = statsOpts.getTableOptions(false, null);
            }
            codeSegment.addSourceCode("%let ").addSourceCode(STATSTABLEOPTIONS).addSourceCode(" = %nrquote(").addSourceCode(codeSegment.getEscapedMacroValue(statsOptions)).addSourceCode(");\n\n");
            m_statsTable.getDBMSType().create(codeSegment, m_statsTable, false, true, true, false, "", this);
        } else {
            codeSegment.addSourceCode("%let ").addSourceCode(STATS_TABLE_MACRO_VAR).addSourceCode("=;\n\n");
        }
        codeSegment.addSourceCode(flowVersion.getEDMCode());
        if (FedSQLViewNeeded) {
            codeSegment.addSourceCode("  proc Fedsql;\n").addSourceCode("  drop view work.&").addSourceCode(INPUT_TABLE_MACRO_VAR).addSourceCode("\n").addSourceCode("  ;\n").addSourceCode("  quit;\n");
        }
        codeSegment.addSourceCode("%mend etls_EDMFlow;\n\n").addSourceCode("%etls_EDMFlow;\n\n");
        return codeSegment;
    }

    @Override
    public IEDMFlowMapping getOrdinaryMappingsForTargetColumn(IEDMFlowColumn target) {
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IEDMFlowMapping mapping = (IEDMFlowMapping)lMappings.get(iMapping);
            if (!mapping.isOrdinary() || !mapping.containsInTargets(target)) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public boolean isEDMFlowMappingAllowed(IColumn[] aSources, IEDMFlowColumn[] aTargets) {
        if (aTargets.length == 0) {
            return false;
        }
        return !this.isTargetColumnMapped(aTargets[0]);
    }

    @Override
    public String getReasonMappingIsNotAllowed(IColumn[] aSources, IEDMFlowColumn[] aTargets) {
        if (this.isTargetColumnMapped(aTargets[0])) {
            return RB.getStringResource("EDMFlowTransformModel.TargetAlreadyMapped.txt");
        }
        return "";
    }

    private boolean isTargetColumnMapped(IEDMFlowColumn target) {
        for (IEDMFlowMapping mapping : this.m_edmFlowMappings.getMappings()) {
            if (!target.equals(mapping.getTargetOfEDMFlowColumn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IEDMFlowMapping addMapping(IColumn[] aSourceColumns, IEDMFlowColumn[] aTargetColumns) {
        String sType = "ONETOONE";
        return this.addMapping(aSourceColumns, aTargetColumns, sType, null);
    }

    @Override
    public IEDMFlowMapping[] getEDMFlowMappings() {
        List<IEDMFlowMapping> lMappings = this.getEDMFlowMappingList();
        return lMappings.toArray(new IEDMFlowMapping[lMappings.size()]);
    }

    public List<IEDMFlowMapping> getEDMFlowMappingList() {
        return Arrays.asList(this.m_edmFlowMappings.getMappings());
    }

    @Override
    public int getSourceEDMFlowTableCount() {
        return this.getSourceEDMFlowTables().length;
    }

    @Override
    public IEDMFlowTable[] getSourceEDMFlowTables() {
        ArrayList<IEDMFlowTable> lst = new ArrayList<IEDMFlowTable>();
        IEDMFlowVersion version = this.getEDMFlowVersion();
        if (version != null && version.getInput() != null) {
            lst.add(version.getInput());
        }
        return lst.toArray(new IEDMFlowTable[lst.size()]);
    }

    public IEDMFlowTable getSourceEDMFlowTable() {
        return this.getSourceEDMFlowTableCount() > 0 ? this.getSourceEDMFlowTables()[0] : null;
    }

    protected IEDMFlowMapping createNewEDMFlowMapping() {
        return new EDMFlowMapping(this.createIDForNewObject(), this.getModel());
    }

    @Override
    public void addMapping(int iMapping, IMapping mapping) {
        if (!this.getModel().isUndoing()) {
            if (!this.m_edmFlowMappings.contains(mapping) && mapping instanceof IEDMFlowMapping) {
                this.m_edmFlowMappings.add(mapping);
                mapping.addNotifyListener(this);
            } else {
                super.addMapping(iMapping, mapping);
            }
        }
    }

    @Override
    protected boolean areExpressionsAllowed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEDMFlowMapping addMapping(IColumn[] aSourceColumns, IEDMFlowColumn[] aTargetColumns, String sType, IExpression oExpression) {
        this.startCompoundUndoable();
        try {
            IEDMFlowMapping mapping = this.createNewEDMFlowMapping();
            mapping.setName(aTargetColumns.length == 1 ? aTargetColumns[0].getName() : "EDMFlowMapping");
            mapping.setType(sType);
            mapping.setExpression(oExpression);
            for (int iSourceColumn = 0; iSourceColumn < aSourceColumns.length; ++iSourceColumn) {
                mapping.addSource(aSourceColumns[iSourceColumn]);
            }
            for (int iTargetColumn = 0; iTargetColumn < aTargetColumns.length; ++iTargetColumn) {
                mapping.addTargetEDMFlowColumn(aTargetColumns[iTargetColumn]);
            }
            if (mapping.isOrdinary() && mapping instanceof BaseMapping) {
                BaseMapping ordinary = (BaseMapping)((Object)mapping);
                ordinary.setAutoType(true);
                ordinary.setExpressionAllowed(this.areExpressionsAllowed());
            }
            this.addMapping(mapping);
            IEDMFlowMapping iEDMFlowMapping = mapping;
            return iEDMFlowMapping;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void removeMapping(IMapping mapping) {
        if (!this.getModel().isUndoing()) {
            if (this.m_edmFlowMappings.contains(mapping) && mapping instanceof IEDMFlowMapping) {
                this.m_edmFlowMappings.remove(mapping);
                mapping.removeNotifyListener(this);
            } else {
                super.removeMapping(mapping);
            }
        }
    }

    @Override
    public void mapAllEDMFlowColumnsByName(ITable sourceTable, IEDMFlowTable inputTable) {
        boolean caseSensitive = sourceTable.isCaseSensitive();
        for (IColumn column : sourceTable.getColumns()) {
            for (IEDMFlowColumn edmfColumn : inputTable.getColumns()) {
                boolean toMap = false;
                toMap = caseSensitive ? column.getName().equals(edmfColumn.getName()) : column.getName().equalsIgnoreCase(edmfColumn.getName());
                if (!toMap) continue;
                this.mapColumns(new IColumn[]{column}, new IEDMFlowColumn[]{edmfColumn});
            }
        }
    }

    public void mapColumns(IColumn[] aSources, IEDMFlowColumn[] aTargets) {
        this.mapColumns(aSources, aTargets, DefaultMappingRules.getRules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapColumns(IColumn[] aSources, IEDMFlowColumn[] aTargets, IMappingRule[] aRules) {
        this.startCompoundUndoable();
        try {
            IColumn[] aOneSource = new IColumn[1];
            IEDMFlowColumn[] aOneTarget = new IEDMFlowColumn[1];
            List lExcludedTargetColumns = this.getListOfColumnsExcludedFromMapping();
            ArrayList<IColumn> lSources = new ArrayList<IColumn>(Arrays.asList(aSources));
            lSources.removeAll(this.getSourceColumnsExcludedFromMapping());
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                IEDMFlowColumn tgt = aTargets[iTarget];
                if (lExcludedTargetColumns.contains(tgt)) continue;
                IEDMFlowMapping mapping = this.findTargetMapping(tgt);
                aOneTarget[0] = tgt;
                boolean bUnmapped = mapping == null;
                for (int iSource = 0; iSource < lSources.size() && bUnmapped; ++iSource) {
                    IColumn src;
                    aOneSource[0] = src = (IColumn)lSources.get(iSource);
                    if (!this.isEDMFlowMappingAllowed(aOneSource, aOneTarget)) continue;
                    this.addMapping(aOneSource, aOneTarget, "EDMFlow", null);
                    bUnmapped = false;
                    lSources.remove(src);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected void addSourceTable(int portIndex, IDataObject table) {
        super.addSourceTable(portIndex, table);
        IEDMFlowTable edmTable = this.getSourceEDMFlowTable();
        if (edmTable != null) {
            this.mapAllEDMFlowColumnsByName((ITable)table, edmTable);
        }
    }

    private IEDMFlowMapping findTargetMapping(IEDMFlowColumn colTarget) {
        for (IEDMFlowMapping edmMapping : this.getEDMFlowMappingList()) {
            IEDMFlowColumn[] aTargets = edmMapping.getTargetsOfEDMFlowColumn();
            if (aTargets.length != 1 || aTargets[0] != colTarget) continue;
            return edmMapping;
        }
        return null;
    }

    protected boolean validateEDMFlowMapping() {
        return false;
    }

    @Override
    protected boolean doesMappingExistOnAllTargetTables() {
        return true;
    }

    void parentAddMapping(int iMapping, IMapping mapping) {
        super.addMapping(iMapping, mapping);
    }

    void parentRemoveMapping(IMapping mapping) {
        super.removeMapping(mapping);
    }

    private boolean mappingsAreNecessary(IPhysicalTable sTable) {
        int equalCount = 0;
        for (IEDMFlowMapping cMap : this.getEDMFlowMappings()) {
            IColumn sColumn = cMap.getSource();
            if (sColumn == null) continue;
            if (sTable.getDBMSType().getDBMSTypeID() == 9) {
                if (!sColumn.getName().equalsIgnoreCase(cMap.getName())) continue;
                ++equalCount;
                continue;
            }
            if (!sColumn.getName().equals(cMap.getName())) continue;
            ++equalCount;
        }
        return equalCount != this.m_edmFlowMappings.size();
    }

    private class EDMFlowMappingList
    extends ModelList {
        private IFilter m_addFilter;

        public EDMFlowMappingList(AbstractPersistableObject owner) {
            super(owner, new String[]{"MappingsContainer:EDMFlowMappingAdded", "MappingsContainer:EDMFlowMappingRemoved", "MappingsContainer:EDMFlowMappingChanged"}, 2);
            this.m_addFilter = new ListFilter();
            this.setAssociationItemFilter(new LoadFilter());
        }

        private IDataTransform getTransform() {
            return (IDataTransform)((Object)this.getOwner());
        }

        @Override
        protected IPersistableObject createObjectFromOMRObject(OMRAdapter omr, Root mdoObject) throws MdException, RemoteException {
            return new EDMFlowMapping(mdoObject.getFQID(), EDMFlowTransformModel.this.getModel());
        }

        public IEDMFlowMapping[] getMappings() {
            ArrayList<IEDMFlowMapping> lst = new ArrayList<IEDMFlowMapping>();
            for (Object obj : this.toArray(new IEDMFlowMapping[this.size()])) {
                if (!(obj instanceof IEDMFlowMapping)) continue;
                lst.add((IEDMFlowMapping)obj);
            }
            return lst.toArray(new IEDMFlowMapping[lst.size()]);
        }

        @Override
        protected void preLoad(Object obj) {
            ((IEDMFlowMapping)obj).setEDMFlowTable(EDMFlowTransformModel.this.getSourceEDMFlowTable());
        }

        @Override
        protected void postAdd(int i, Object obj) {
            EDMFlowTransformModel.this.parentAddMapping(i, (IEDMFlowMapping)obj);
        }

        @Override
        protected void postRemove(Object obj) {
            EDMFlowTransformModel.this.parentRemoveMapping((IEDMFlowMapping)obj);
        }

        public void setSourceEDMFlowTable(IEDMFlowTable table) {
            for (IEDMFlowMapping mapping : this.getMappings()) {
                mapping.setEDMFlowTable(table);
            }
        }

        @Override
        public void add(int iObj, Object obj) {
            if (!this.m_addFilter.pass(obj)) {
                return;
            }
            super.add(iObj, obj);
        }

        private class ListFilter
        implements IFilter {
            private ListFilter() {
            }

            @Override
            public boolean pass(Object obj) {
                return obj instanceof EDMFlowMapping;
            }
        }

        private class LoadFilter
        implements IFilter {
            private LoadFilter() {
            }

            @Override
            public boolean pass(Object obj) {
                if (!(obj instanceof FeatureMap)) {
                    return false;
                }
                FeatureMap mapping = (FeatureMap)obj;
                try {
                    if ("EDMFlow".equals(mapping.getTransformRole())) {
                        return true;
                    }
                }
                catch (RemoteException e) {
                    ModelLogger.getDefaultLogger().debug((Object)e);
                }
                return false;
            }
        }
    }

    private class SetEDMFlowVersionUndoable
    extends AbstractUndoableEdit {
        private IEDMFlowVersion m_edmOld;
        private IEDMFlowVersion m_edmNew;

        public SetEDMFlowVersionUndoable(IEDMFlowVersion edmOld, IEDMFlowVersion edmNew) {
            this.m_edmOld = edmOld;
            this.m_edmNew = edmNew;
        }

        @Override
        public void undo() {
            super.undo();
            EDMFlowTransformModel.this.setEDMFlowVersion(this.m_edmOld);
        }

        @Override
        public void redo() {
            super.redo();
            EDMFlowTransformModel.this.setEDMFlowVersion(this.m_edmNew);
        }
    }

    private class SetEDMFlowUndoable
    extends AbstractUndoableEdit {
        private IEDMFlow m_edmOld;
        private IEDMFlow m_edmNew;

        public SetEDMFlowUndoable(IEDMFlow edmOld, IEDMFlow edmNew) {
            this.m_edmOld = edmOld;
            this.m_edmNew = edmNew;
        }

        @Override
        public void undo() {
            super.undo();
            EDMFlowTransformModel.this.setEDMFlow(this.m_edmOld);
        }

        @Override
        public void redo() {
            super.redo();
            EDMFlowTransformModel.this.setEDMFlow(this.m_edmNew);
        }
    }

    private class cEDMFlowsOptionModel
    extends AbstractMultiplePortTransformOptionModel {
        public cEDMFlowsOptionModel(IModel model, EDMFlowTransformModel owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model, owner);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            return super.getPromptGroup();
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
        }

        @Override
        protected IModelListener createModelListener() {
            return new cEDMFlowsModelListener((EDMFlowTransformModel)this.getOwner());
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new EDMFlowTransformValueChangedListener((EDMFlowTransformModel)this.getOwner(), this);
        }

        private class cEDMFlowsModelListener
        extends AbstractMultiplePortTransformOptionModelListener {
            public cEDMFlowsModelListener(EDMFlowTransformModel transform) {
                super(transform, (IPromptModel)cEDMFlowsOptionModel.this);
            }

            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                this.getPromptModel().setListeningForChanges(true);
            }
        }

        private class EDMFlowTransformValueChangedListener
        extends AbstractMultiplePortTransformOptionValueChangeListener {
            public EDMFlowTransformValueChangedListener(EDMFlowTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }
}

