/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.edmflow;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IGeneratedTable;
import com.sas.etl.models.data.IGeneratedTableColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.transforms.common.impl.BaseTransformPort;
import com.sas.etl.models.job.transforms.edmflow.RB;
import java.text.MessageFormat;
import java.util.List;

public class EDMFlowTargetTablePort
extends BaseTransformPort<IPhysicalTable> {
    private boolean m_bIsResultsColumnsComplete;
    public static final String RESULTS_TABLE = "EDM Results";
    public static final String STATS_TABLE = "EDM Stats";

    public EDMFlowTargetTablePort(String sID, IModel model) {
        super(sID, model);
        this.setOptional(false);
        this.setCanPropagateColumns(false);
        this.setCanIncludeSourceColumns(false);
    }

    @Override
    public boolean isComplete(IColumn[] columns) {
        IGeneratedTable<IGeneratedTableColumn> table = this.getGeneratedTable();
        IPhysicalTable pt = (IPhysicalTable)this.getObject();
        return super.isComplete(columns) && table != null && this.getIsResultsColumnsComplete() && (pt == null || table.isComplete(pt.getColumns()));
    }

    @Override
    public List getReasonsIncomplete(IColumn[] columns) {
        List lst = super.getReasonsIncomplete(columns);
        IGeneratedTable<IGeneratedTableColumn> table = this.getGeneratedTable();
        if (table == null) {
            lst.add(MessageFormat.format(RB.getStringResource("EDMFlowTargetTablePort.NoEDMFlowTable.fmt"), this.getName()));
        }
        IPhysicalTable pt = (IPhysicalTable)this.getObject();
        if (table != null && pt != null) {
            lst.addAll(table.getReasonsIncomplete(pt.getColumns()));
        }
        if (!this.getIsResultsColumnsComplete()) {
            lst.add(MessageFormat.format(RB.getStringResource("EDMFlowTargetTablePort.ResultColumnsIncomplete.fmt"), this.getName()));
        }
        return lst;
    }

    public boolean getIsResultsColumnsComplete() {
        if (this.getGeneratedTable() != null && this.getGeneratedTable().getID() == "STATS_TABLE") {
            return true;
        }
        if (this.getGeneratedTable() == null || this.getObject() == null) {
            return false;
        }
        this.m_bIsResultsColumnsComplete = this.getGeneratedTable().getColumns().size() == ((IPhysicalTable)this.getObject()).getColumnCount();
        return this.m_bIsResultsColumnsComplete;
    }

    public void setIsResultsColumnsComplete(boolean bColsComplete) {
        this.m_bIsResultsColumnsComplete = bColsComplete;
    }
}

