/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataValidation;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.transforms.dataValidation.RB;
import com.sas.etl.models.job.transforms.dataValidation.TempColumn;
import java.util.ArrayList;
import java.util.List;

public class ErrorTable {
    private static ErrorTable s_instance;
    public static final String ETL_RUNTIME = "ETL_Error_JobRunTime";
    private List<TempColumn> _columns = new ArrayList<TempColumn>();

    private ErrorTable() {
        this._columns.add(new TempColumn(ETL_RUNTIME, RB.getStringResource("ErrorTable.ETLErrorRunTimeDesc.txt"), 8, 1, "datetime20.", "datetime20."));
    }

    public List<TempColumn> getColumns() {
        return this._columns;
    }

    public static ErrorTable getInstance() {
        if (s_instance == null) {
            s_instance = new ErrorTable();
        }
        return s_instance;
    }

    public TempColumn findColumn(String name) {
        if (name == null) {
            return null;
        }
        for (TempColumn column : this.getColumns()) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public IColumn[] getMatchingColumnNames(IColumn[] sources) {
        ArrayList<IColumn> lst = new ArrayList<IColumn>();
        for (IColumn c : sources) {
            if (this.findColumn(c.getName()) == null) continue;
            lst.add(c);
        }
        return lst.toArray(new IColumn[lst.size()]);
    }

    public String getAttribStatement(IPhysicalTable errorTable) {
        StringBuffer attrib = new StringBuffer();
        for (TempColumn c : this.getColumns()) {
            IColumn column = errorTable.getColumnWithMatchingName(c.getName());
            if (column == null) {
                String labelStatement;
                String infmtStm;
                String fmtStm;
                attrib.append("attrib ");
                String columnName = c.getName();
                if (columnName == null || columnName.length() == 0) {
                    return "";
                }
                attrib.append(columnName);
                String lengthStm = c.getLengthStatement();
                if (lengthStm != null && lengthStm.length() > 0) {
                    attrib.append(" ");
                    attrib.append(lengthStm);
                }
                if ((fmtStm = c.getFormatStatement()) != null && fmtStm.length() > 0) {
                    attrib.append("\n").append(fmtStm);
                }
                if ((infmtStm = c.getInformatStatement()) != null && infmtStm.length() > 0) {
                    attrib.append("\n").append(infmtStm);
                }
                if ((labelStatement = c.getLabelStatement()) != null && labelStatement.length() > 0) {
                    attrib.append("\n").append(labelStatement);
                }
                attrib.append(";\n");
                continue;
            }
            attrib.append(column.getAttribStatement(false, true, true, true, true));
        }
        return attrib.toString();
    }
}

