/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataValidation;

import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationCustomConditionRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.etl.models.job.transforms.dataValidation.ExceptionTable;
import com.sas.etl.models.job.transforms.dataValidation.RB;
import com.sas.etl.models.job.transforms.dataValidation.ValidationUtil;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataValidationCodegen {
    private static DataValidationTransformModel m_oDVTModel;
    private static boolean m_validationSelected;
    public static final String EMAILREPORT = "EmailReport";
    public static final String SAVEREPORT = "SaveReport";
    public static final String SAVETABLE = "SaveTable";
    private static final String WORK_ERRORS_TABLE = "etls_Errors";
    private static final String WORK_EXCEPTIONS_TABLE = "etls_Exceptions";
    private static final String WORK_TARGET_TABLE = "etls_target";
    public static final String WORK_DUPS_TABLE = "work.etls_Dups";
    public static final String WORK_SOURCE_TABLE = "etls_Source";
    public static final String WORK_FMT_TABLE = "work.etls_fmtData";
    public static final String ERROR_TABLE_OPTION = "ErrorTable";
    public boolean needExceptionReport = false;
    public boolean needErrorTable = false;
    private static final String MACRO_NAME = "etls_Validate";
    private static final String NUMERIC = "N";
    private static final String CHARACTER = "C";
    private static final String INFORMAT = "I";
    private static final String NUM_FORMAT_TO_USE = "32.";
    private static final int MIN_FORMAT_LENGTH = 32;
    private static final int MAX_START_LENGTH = 32;
    private static String m_sSetColumn;
    private static String m_sTranslation;
    private static String m_sSetValueTo;
    private static String m_sCustomValidation;
    private static String m_sDuplicateValue;

    public DataValidationCodegen(DataValidationTransformModel model) {
        m_oDVTModel = model;
    }

    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        m_validationSelected = true;
        IPhysicalTable errorTable = m_oDVTModel.getErrorTable();
        IPhysicalTable exceptionTable = m_oDVTModel.getExceptionTable();
        IPhysicalTable targetTable = m_oDVTModel.getTargetTable();
        IPhysicalTable sourceTable = m_oDVTModel.getSourceTable();
        String errorTableFullName = "";
        String targetTableFullName = "";
        String targetWorkTable = WORK_TARGET_TABLE;
        String sourceTableFullName = "";
        String exceptionTableFullName = "";
        ITransformTableOptions targetTableOptions = null;
        ITransformTableOptions sourceTableOptions = null;
        ITransformTableOptions errorTableOptions = null;
        ITransformTableOptions excpTableOptions = null;
        boolean move = false;
        boolean dupMove = false;
        boolean abort = false;
        boolean dupAbort = false;
        boolean priorExcpTable = false;
        boolean priorErrorTable = false;
        if (sourceTable != null) {
            sourceTableFullName = sourceTable.getFullNameQuotedAsNeeded(codeSegment);
        }
        codeSegment.addSourceCode("proc datasets library=work nolist nowarn memtype=(data view);\n").addSourceCode(" delete etls_Errors etls_Exceptions etls_target etls_Source;\n").addSourceCode("quit;\n\n");
        if (errorTable != null) {
            errorTableFullName = errorTable.getFullNameQuotedAsNeeded(codeSegment);
        } else if (errorTable == null) {
            errorTableFullName = m_oDVTModel.getErrorTableName();
            if (errorTableFullName != null && errorTableFullName != "") {
                priorErrorTable = true;
                codeSegment.genTableExist(errorTableFullName, "priorErr_Exist");
            } else if ((errorTableFullName == "" || errorTableFullName == null) && this.isErrorTableNeeded()) {
                codeSegment.addCommentLine(RB.getStringResource("DataValidationRecord.ReqErrorTableNotDefined.txt"));
                return codeSegment;
            }
        }
        if (exceptionTable != null) {
            exceptionTableFullName = exceptionTable.getFullNameQuotedAsNeeded(codeSegment);
        } else if (exceptionTable == null && (exceptionTableFullName = ValidationUtil.getExceptionTableName(m_oDVTModel)) != "" && exceptionTableFullName != null) {
            priorExcpTable = true;
            codeSegment.genTableExist(exceptionTableFullName, "priorExcp_Exist");
        }
        if (targetTable != null) {
            targetTableFullName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
        }
        try {
            String selectedAction;
            String selectedActionText;
            DataValidationRecord validationRow;
            int i;
            List lMissingValues = m_oDVTModel.getDVRMissing();
            List lInvalidValues = m_oDVTModel.getDVRInvalid();
            List lDuplicateValues = m_oDVTModel.getDVRDuplicate();
            List lCustom = m_oDVTModel.getDVRCustom();
            for (i = 0; i < lMissingValues.size(); ++i) {
                validationRow = (DataValidationRecord)lMissingValues.get(i);
                selectedAction = validationRow.getMetaAction(selectedActionText = validationRow.getAction());
                if (selectedAction.equals("ABORT")) {
                    abort = true;
                } else if (selectedAction.equals("MOVE")) {
                    move = true;
                }
                if (abort && move) break;
            }
            for (i = 0; i < lInvalidValues.size(); ++i) {
                validationRow = (DataValidationRecord)lInvalidValues.get(i);
                selectedAction = validationRow.getMetaAction(selectedActionText = validationRow.getAction());
                if (selectedAction.equals("ABORT")) {
                    abort = true;
                } else if (selectedAction.equals("MOVE")) {
                    move = true;
                }
                if (abort && move) break;
            }
            for (i = 0; i < lCustom.size(); ++i) {
                DataValidationRecord customDVRecord_i = (DataValidationRecord)lCustom.get(i);
                String sActionText = customDVRecord_i.getPropertyTrue_PS1_DefVal();
                String sSelectedAction1 = customDVRecord_i.getMetaAction(sActionText);
                sActionText = customDVRecord_i.getPropertyFalse_PS1_DefVal();
                String sSelectedAction2 = customDVRecord_i.getMetaAction(sActionText);
                if (sSelectedAction1.equals("ABORT") || sSelectedAction2.equals("ABORT")) {
                    abort = true;
                } else if (sSelectedAction1.equals("MOVE") || sSelectedAction2.equals("MOVE")) {
                    move = true;
                }
                if (abort && move) break;
            }
            for (i = 0; i < lDuplicateValues.size(); ++i) {
                validationRow = (DataValidationRecord)lDuplicateValues.get(i);
                selectedAction = validationRow.getMetaAction(selectedActionText = validationRow.getAction());
                if (selectedAction.equals("ABORT")) {
                    dupAbort = true;
                } else if (selectedAction.equals("MOVE") || selectedAction.equals("MOVEALL")) {
                    dupMove = true;
                }
                if (dupAbort && dupMove) break;
            }
            this.needExceptionReport = DataValidationCodegen.isExceptionReportNeeded(lMissingValues, lInvalidValues, lDuplicateValues, lCustom);
            if (this.needExceptionReport && (exceptionTableFullName == null || exceptionTableFullName == "")) {
                exceptionTableFullName = WORK_EXCEPTIONS_TABLE;
            }
            if (exceptionTable != null && this.needExceptionReport && exceptionTable.isView()) {
                codeSegment.genPercentPutStatement(RB.getStringResource("DataValidationCodegen.NoExceptionReport.comment.sasmacro.notrans")).addSourceCode("\n");
            }
            if (lMissingValues.size() <= 0 && lInvalidValues.size() <= 0 && lCustom.size() <= 0 && lDuplicateValues.size() <= 0) {
                m_validationSelected = false;
                this.needExceptionReport = false;
                if (targetTableFullName.equals(sourceTableFullName)) {
                    codeSegment.genPercentPutStatement("Source and target names are identical.  No action will be performed.\n\n", "NOTE:");
                    return codeSegment;
                }
                codeSegment.genTableDelete(targetTableFullName);
                targetTableOptions = m_oDVTModel.getTableOptionObject(targetTable, false);
                String targetDSOptionsString = targetTableOptions.getTableOptions(true, codeSegment.getCurrentServer());
                codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.NoValidation.comment.txt")).addSourceCode("data ").addSourceCode(targetTableFullName).addSourceCode(targetDSOptionsString.length() > 0 ? targetDSOptionsString + "\n" : "").addSourceCode(targetTable.isView() ? " / view = " + targetTableFullName : "");
                codeSegment.addSourceCode(";\n").indent().addSourceCode("set " + sourceTableFullName + ";\n");
                sourceTableOptions = m_oDVTModel.getTableOptionObject(sourceTable, true);
                String sourceDSOptionsString = sourceTableOptions.getTableOptions(true, codeSegment.getCurrentServer());
                codeSegment.addSourceCode(sourceDSOptionsString.length() > 0 ? sourceDSOptionsString : "");
                codeSegment.addSourceCode("; \n").unIndent().addSourceCode("run; \n\n");
                codeSegment.genRCSetCall("&syserr");
                return codeSegment;
            }
            ArrayList ignoreColumnsList = new ArrayList();
            ICodeSegment customValidationTempCodeSegment = this.getCustomValidationCodeSegment(codeSegment, lCustom, this.needExceptionReport, ignoreColumnsList);
            codeSegment.addSourceCode("%macro ").addSourceCode(MACRO_NAME).addSourceCode("; \n\n").indent();
            boolean bIsMappingStepNeeded = m_oDVTModel.isMappingNeeded(codeSegment.isQuoting(), sourceTable, targetTable, ignoreColumnsList, true);
            if (bIsMappingStepNeeded) {
                if (!targetTable.isView()) {
                    codeSegment.genTableDelete(targetTableFullName);
                }
                IColumn[] defaultExceptionTableColumns = null;
                if (exceptionTable != null) {
                    defaultExceptionTableColumns = ExceptionTable.getInstance().getMatchingColumnNames(exceptionTable.getColumns());
                }
                ArrayList<IColumn> lSourceColumnsOnly = new ArrayList<IColumn>();
                for (IColumn sourceColumn : sourceTable.getColumns()) {
                    IColumn matchingTarget = targetTable.getColumnWithMatchingName(sourceColumn.getName());
                    if (matchingTarget != null) continue;
                    lSourceColumnsOnly.add(sourceColumn);
                }
                m_oDVTModel.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, WORK_SOURCE_TABLE, sourceTableFullName, m_oDVTModel.getTableOptionObject(sourceTable, true).getTableOptions(false, codeSegment.getCurrentServer()), "", false, true, true, lSourceColumnsOnly.toArray(new IColumn[lSourceColumnsOnly.size()]), defaultExceptionTableColumns, false, null, null, null, true, true, false);
            } else if (!bIsMappingStepNeeded) {
                String sourceDSOptionsString;
                codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.CreateWorkSourceTable.comment.txt"));
                codeSegment.addSourceCode("proc sql;").newLine().addSourceCode("create table etls_Source as").newLine().addSourceCode(" select *").newLine().addSourceCode(" from " + sourceTableFullName).addSourceCode("  ");
                if (sourceTable != null && (sourceDSOptionsString = (sourceTableOptions = m_oDVTModel.getTableOptionObject(sourceTable, true)).getTableOptions(true, codeSegment.getCurrentServer())) != null) {
                    codeSegment.addSourceCode(sourceDSOptionsString.length() > 0 ? sourceDSOptionsString : "");
                }
                codeSegment.addSourceCode(" ").newLine().addSourceCode(";").newLine().addSourceCode("quit;").newLine(2);
            }
            List<IColumn> lAllTargetColumns = null;
            lAllTargetColumns = Arrays.asList(targetTable.getColumns());
            List<IColumn> lAllErrorColumns = null;
            if (errorTable != null) {
                lAllErrorColumns = Arrays.asList(errorTable.getColumns());
            }
            List<IColumn> lAllSourceColumns = Arrays.asList(sourceTable.getColumns());
            String keepList = "keep = " + codeSegment.makeColumnList(lAllTargetColumns, false, "", false, "", "", codeSegment.isQuoting(), "", false);
            String selectList = "select " + codeSegment.makeColumnList(lAllTargetColumns, false, "", false, ",", "t", codeSegment.isQuoting(), "", false);
            String errorList = "";
            if (errorTable != null) {
                errorList = "keep = " + codeSegment.makeColumnList(lAllErrorColumns, false, "", false, "", "", codeSegment.isQuoting(), "", false);
            } else if (priorErrorTable) {
                errorList = "keep = " + codeSegment.makeColumnList(lAllSourceColumns, false, "", false, "", "", codeSegment.isQuoting(), "", false);
            }
            codeSegment.genDatetimeMacrovarAssignment("runTime", "");
            ValidationUtil.genMakeReportMacro(m_oDVTModel, codeSegment, sourceTable, m_oDVTModel.isExceptionTableReplace(), WORK_EXCEPTIONS_TABLE, this.needExceptionReport, priorExcpTable);
            if (errorTable != null) {
                ValidationUtil.setupErrorTable(codeSegment, WORK_ERRORS_TABLE, move || dupMove);
            }
            if (errorTable != null) {
                if (m_oDVTModel.isErrorTableReplace()) {
                    codeSegment.addCommentLine("Delete error tables prior to running data validation steps\n\n");
                    codeSegment.genTableDelete(m_oDVTModel.getErrorTable());
                }
            } else if (priorErrorTable && m_oDVTModel.getReplaceErrorTableOption().equalsIgnoreCase("YES")) {
                String errRef = DBMSNamesUtil.getLibrefPart(errorTableFullName);
                String errName = errorTableFullName.replace(errRef + ".", "");
                codeSegment.addSourceCode("%if &priorErr_Exist>0 %then\n").addSourceCode("%do;\n").addSourceCode("  proc datasets library=" + errRef + " nolist nowarn memtype=(data view);\n").addSourceCode("    delete " + errName + ";\n").addSourceCode("  quit;\n").addSourceCode("%end;\n\n");
            }
            if (exceptionTable != null) {
                if (m_oDVTModel.isExceptionTableReplace()) {
                    codeSegment.addCommentLine("Delete exception table prior to running data validation steps");
                    codeSegment.genTableDelete(m_oDVTModel.getExceptionTable());
                }
            } else if (priorExcpTable) {
                String excpRef = DBMSNamesUtil.getLibrefPart(exceptionTableFullName);
                String excpName = exceptionTableFullName.replace(excpRef + ".", "");
                codeSegment.addSourceCode("%if &priorExcp_Exist>0 %then\n").addSourceCode("%do;\n").addSourceCode("  proc datasets library=" + excpRef + " nolist nowarn memtype=(data view);\n").addSourceCode("    delete " + excpName + ";\n").addSourceCode("  quit;\n").addSourceCode("%end;\n\n");
            }
            if (targetTable != null) {
                codeSegment.genTableDelete(m_oDVTModel.getTargetTable());
            }
            codeSegment.addSourceCode("%let m_excp = 0;\n").addSourceCode("%let cust_exp=0; \n\n");
            if (abort || dupAbort) {
                codeSegment.addSourceCode("%let m_abort = 0; \n\n");
            }
            if (m_oDVTModel.isDuplicateValues()) {
                this.determineDuplicateValues(codeSegment, lDuplicateValues, WORK_SOURCE_TABLE);
            }
            if (lCustom.size() > 0) {
                this.genCustomFormats(codeSegment, lCustom);
            }
            if (lInvalidValues.size() > 0) {
                this.genInvalidValuesFormats(codeSegment, lInvalidValues);
            }
            if (lMissingValues.size() > 0 || lInvalidValues.size() > 0 || lDuplicateValues.size() > 0 || lCustom.size() > 0) {
                if (targetTable.isView() && move) {
                    codeSegment.genPercentPutStatement(RB.getStringResource("DataValidationCodegen.NoView.comment.sasmacro.notrans")).addSourceCode("\n");
                }
                sourceTableOptions = m_oDVTModel.getTableOptionObject(sourceTable, true);
                String sourceDSOptions = sourceTableOptions.getTableOptions(true, codeSegment.getCurrentServer());
                codeSegment.addSectionComment(RB.getStringResource("DataValidationCodegen.DoValidations.comment.txt")).newLine();
                codeSegment.addSourceCode("data etls_target").newLine().indent().addSourceCode("(");
                codeSegment.addSourceCode(keepList).addSourceCode(")").unIndent();
                if (move || dupMove || m_oDVTModel.getErrorTable() != null || m_oDVTModel.isErrorTableNameOptionUsed()) {
                    codeSegment.newLine().addSourceCode("  etls_Errors").newLine().indent().addSourceCode("(").addSourceCode(errorList);
                    if (priorErrorTable) {
                        codeSegment.addSourceCode(" ETL_ERROR_JobRunTime ");
                    }
                    codeSegment.addSourceCode(")").unIndent();
                }
                if (this.needExceptionReport) {
                    codeSegment.newLine().addSourceCode("  etls_Exceptions").newLine().indent();
                    if (exceptionTable == null) {
                        codeSegment.addSourceCode("(keep = x_row x_type x_column x_note x_custom_name x_custom_value x_custom_rule x_action x_datetime)");
                    } else {
                        String excpKeepList = "(keep = " + codeSegment.makeColumnList(exceptionTable, false, "", false, " ", "", codeSegment.isQuoting(), "") + ")";
                        codeSegment.addSourceCode(excpKeepList);
                    }
                }
                codeSegment.unIndent();
                if (targetTable.isView() && !move) {
                    codeSegment.addSourceCode("\n     / view = ").addSourceCode(WORK_TARGET_TABLE);
                }
                codeSegment.addSourceCode(";\n\n").indent();
                this.genNeededAttribs(codeSegment, lAllTargetColumns, sourceTable.getColumns());
                codeSegment.addSourceCode("set etls_Source").addSourceCode(" end=eof;\n\n");
                if (lCustom.size() == 0 && !this.needExceptionReport) {
                    codeSegment.addSourceCode("attrib x_custom_name length = $100 label = \"Custom Validation Name\"\n").addSourceCode("x_custom_value length = $250 label = \"Custom Value\"\n").addSourceCode("x_custom_rule length = $250 label = \"Custom Rule\"\n;\n");
                }
                if (this.needExceptionReport) {
                    DataValidationCodegen.genExcpColumns(codeSegment, exceptionTable);
                }
                codeSegment.addSourceCode("\n").addCommentLine(RB.getStringResource("DataValidationCodegen.InitializeMacroVars.txt"));
                codeSegment.addSourceCode("%let total_source_rows=0;\n").addSourceCode("%let total_valid_rows=0;\n").addSourceCode("%let total_error_rows=0;\n").addSourceCode("%let total_excp_rows=0;\n\n");
                if (abort || dupAbort) {
                    codeSegment.addSourceCode("\nretain i_abort 0;\n");
                }
                codeSegment.addSourceCode("i_move=0;\n").addSourceCode("retain i_excp error_rows excp_rows valid_rows cust_excp 0;\n\n").addSourceCode("x_datetime = \"&etls_stepStartTime\"dt;\n").addSourceCode("ETL_Error_JobRunTime = x_datetime;\n\n");
                if (!m_oDVTModel.isDuplicateValues()) {
                    codeSegment.addSourceCode("x_row = _n_;\n\n");
                }
                if (lCustom.size() > 0) {
                    codeSegment.addSourceCode(customValidationTempCodeSegment);
                }
                if (lMissingValues.size() > 0) {
                    this.genMissingValuesValidation(codeSegment, lMissingValues, this.needExceptionReport);
                }
                if (lInvalidValues.size() > 0) {
                    this.genInvalidValuesValidation(codeSegment, lInvalidValues, this.needExceptionReport);
                }
                if (lDuplicateValues.size() > 0) {
                    codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.OutputDupsToExceptionTable.comment.txt"));
                    DataValidationRecord duplicateHandler = null;
                    for (int i2 = 0; i2 < lDuplicateValues.size(); ++i2) {
                        int e = i2 + 1;
                        duplicateHandler = (DataValidationRecord)lDuplicateValues.get(i2);
                        String sSelectedActionText = duplicateHandler.getAction();
                        String sSelectedAction = duplicateHandler.getMetaAction(sSelectedActionText);
                        ArrayList lByColumns = duplicateHandler.getColumnList_FM1();
                        if (lByColumns.isEmpty()) {
                            throw new CodegenException(RB.getStringResource("DataValidationCodegen.Duplicates.NoByColumns.msg.txt"), (IObject)m_oDVTModel);
                        }
                        String colList = codeSegment.makeColumnList(lByColumns, "", false, "||");
                        String sByColumns = codeSegment.makeColumnList(lByColumns, false, "   ", false, " ", "", codeSegment.isQuoting(), "", false).trim();
                        if (i2 == 0) {
                            codeSegment.addSourceCode("\narray move(" + lDuplicateValues.size() + ") $7;\n").addSourceCode("array dup(" + lDuplicateValues.size() + ") 3;\n").addSourceCode("array dupCol(" + lDuplicateValues.size() + ") $32;\n").addSourceCode("array tDup(" + lDuplicateValues.size() + ") 3;\n\n");
                            codeSegment.addSourceCode("dupRecs=0;\n").addSourceCode("PassRec=0;\n").addSourceCode("do j=1 to " + lDuplicateValues.size() + ";\n").addSourceCode("  if (dup(j)>0 or tDup(j)>0) and move(j) = \"ABORT\" then\n").addSourceCode("  do;\n").addSourceCode("    i_abort=1;\n").addSourceCode("    move(j)=\"\";\n").addSourceCode("  end;\n").addSourceCode("  else\n").addSourceCode("   if dup(j)<=0 && tDup(j)<=0 then move(j)=\"\";\n").addSourceCode("  else\n").addSourceCode("   if tDup(j)>0 and move(j)=\"MOVE\" then move(j)=\"MOVEALL\";\n\n").addSourceCode("  if (dup(j)>0 or tDup(j)>0) then dupRecs+1;\n").addSourceCode("  if move(j) = \"MOVE\" then PassRec=1;\n").addSourceCode("end;\n\n");
                        }
                        if (this.needExceptionReport) {
                            codeSegment.addSourceCode("if dup" + e + ">0 then\n").addSourceCode("do;\n").indent().addSourceCode("x_column=\"" + colList + "\";\n").addSourceCode("x_note=" + colList + ";\n").addSourceCode("x_type=\"").addSourceCode(m_sDuplicateValue).addSourceCode("\";\n").addSourceCode("x_custom_name =\"\";\n").addSourceCode("x_custom_value = \"\";\n").addSourceCode("x_custom_rule = \"\";\n").addSourceCode("x_action = \"" + sSelectedActionText + "\";\n").addSourceCode("i_excp=1;\n").addSourceCode("excp_rows+1;\n\n").addSourceCode("output etls_Exceptions;\n").unIndent().addSourceCode("end;\n\n");
                            codeSegment.addSourceCode("if tDup" + e + ">0 and dup" + e + "<=0 then\n").addSourceCode("do;\n").indent().addSourceCode("x_column=\"" + colList + "\";\n").addSourceCode("x_note=" + colList + ";\n").addSourceCode("x_type=\"").addSourceCode(m_sDuplicateValue).addSourceCode("\";\n").addSourceCode("x_custom_name =\"\";\n").addSourceCode("x_custom_value = \"\";\n").addSourceCode("x_custom_rule = \"\";\n").addSourceCode("x_action = \"" + sSelectedActionText + "\";\n").addSourceCode("i_excp=1;\n").addSourceCode("excp_rows+1;\n\n").addSourceCode("output etls_Exceptions;\n").unIndent().addSourceCode("end;\n\n");
                        }
                        if (lDuplicateValues.size() > 1 && i2 == lDuplicateValues.size() - 1) {
                            codeSegment.addSourceCode("do d=2 to " + lDuplicateValues.size() + ";\n").addSourceCode("  e=d-1;\n").addSourceCode("  if move(e)=\"MOVEALL\" or move(d)=\"MOVEALL\" then move(d)=\"MOVEALL\"; else\n").addSourceCode("  if move(e)=\"MOVE\" or move(d)=\"MOVE\" then move(d)=\"MOVE\"; else\n").addSourceCode("  move(d)=\"\";\n").addSourceCode("  if dup(e)>0 and dup(d)<=0 then dup(d)=dup(e); else\n").addSourceCode("  if dup(e)>0 and dup(d)>0 and dup(d) ne dup(e) then\n").addSourceCode("   do;\n").addSourceCode("     if move(d)=\"MOVEALL\" and dup(d)=1 then dup(d)=2;\n").addSourceCode("   end;\n").addSourceCode("end;\n\n");
                        }
                        if (i2 + 1 != lDuplicateValues.size()) continue;
                        if (this.isErrorTableNeeded()) {
                            codeSegment.addSourceCode("if dupRecs > 0 then\n").addSourceCode("do;\n").addSourceCode("  if PassRec <= 0 then\n").addSourceCode("  do;\n").addSourceCode("    error_rows+1;\n").addSourceCode("    output etls_Errors;\n").addSourceCode("  end;\n").addSourceCode("  else\n").addSourceCode("  if PassRec > 0 then\n").addSourceCode("  do;\n").addSourceCode("    if dup" + lDuplicateValues.size() + " = 1 then\n").addSourceCode("    do;\n").addSourceCode("      if (i_move=0) then\n").addSourceCode("      do; \n").addSourceCode("         valid_rows+1;\n").addSourceCode("         output etls_target;\n").addSourceCode("      end; \n").addSourceCode("      else\n").addSourceCode("      do; \n").addSourceCode("        error_rows+1;\n").addSourceCode("        output etls_errors;\n").addSourceCode("      end; \n").addSourceCode("    end;\n").addSourceCode("    else\n").addSourceCode("    if dup" + lDuplicateValues.size() + ">1 then\n").addSourceCode("    do;\n").addSourceCode("      error_rows+1;\n").addSourceCode("      output etls_Errors;\n\n").addSourceCode("    end;\n").addSourceCode("   end; \n").addSourceCode("  end;\n").addSourceCode("else\n").addSourceCode("do;\n").addSourceCode("  if i_move=0 then\n").addSourceCode("  do;\n").addSourceCode("    valid_rows+1;\n").addSourceCode("    output etls_target;\n").addSourceCode("  end;\n").addSourceCode("  else\n").addSourceCode("  if i_move=1 then\n").addSourceCode("  do;\n").addSourceCode("    error_rows+1;\n").addSourceCode("    output etls_Errors;\n").addSourceCode("  end;\n").addSourceCode("end;\n\n");
                            continue;
                        }
                        for (int j = 1; j <= lDuplicateValues.size(); ++j) {
                            codeSegment.addSourceCode("if (dup" + j + " <=0 && tDup" + j + " <=0) then\n").addSourceCode("do;\n").addSourceCode("  valid_rows+1;\n").addSourceCode("  output etls_target;\n").addSourceCode("end;\n\n");
                        }
                    }
                } else if (move && lDuplicateValues.size() == 0) {
                    codeSegment.addSourceCode("\n").addSourceCode("if i_move = 0 then\n").addSourceCode("do;\n").addSourceCode("  valid_rows+1;\n").addSourceCode("  output etls_target;\n\n").addSourceCode("end;\n").addSourceCode("else\n").addSourceCode("if i_move = 1 then\n").addSourceCode("do;\n").addSourceCode("  error_rows+1;\n").addSourceCode("  output etls_Errors;\n\n").addSourceCode("end;\n");
                } else {
                    codeSegment.addSourceCode("if error_rows=0 then\n").addSourceCode("do;\n").addSourceCode(" valid_rows+1;\n").addSourceCode(" output etls_target;\n").addSourceCode("end;\n\n");
                }
            }
            boolean doAbort = abort || dupAbort;
            this.runEOFReport(codeSegment, doAbort, targetTable.isView(), move);
            codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.CreatePermanentTablesDeleteWork.comment.txt"));
            if (targetTable != null) {
                String targetDSOptionsString;
                codeSegment.addSourceCode("proc append base=").addSourceCode(targetTableFullName);
                targetTableOptions = m_oDVTModel.getTableOptionObject(targetTable, false);
                if (targetTableOptions != null && (targetDSOptionsString = targetTableOptions.getTableOptions(true, codeSegment.getCurrentServer())) != null) {
                    codeSegment.addSourceCode(targetDSOptionsString.length() > 0 ? targetDSOptionsString + "\n" : "");
                }
                codeSegment.addSourceCode(" data=etls_target force;\n").addSourceCode("run;\n\n");
                this.deleteWorkTable(codeSegment, WORK_TARGET_TABLE);
            }
            codeSegment.genTableExist(WORK_ERRORS_TABLE, "work_error_exist");
            if (errorTableFullName != "" && errorTableFullName != null) {
                String errorDSOptionsString;
                codeSegment.addSourceCode("%if &work_error_exist > 0 %then\n").addSourceCode("%do;\n");
                codeSegment.addSourceCode("  proc append base=").addSourceCode(errorTableFullName);
                errorTableOptions = m_oDVTModel.getTableOptionObject(errorTable, false);
                if (errorTableOptions != null && (errorDSOptionsString = errorTableOptions.getTableOptions(true, codeSegment.getCurrentServer())) != null) {
                    codeSegment.addSourceCode(errorDSOptionsString.length() > 0 ? errorDSOptionsString + "\n" : "");
                }
                codeSegment.addSourceCode("   data=etls_Errors force;\n").addSourceCode("  run;\n\n");
                codeSegment.indent();
                this.deleteWorkTable(codeSegment, WORK_ERRORS_TABLE);
                codeSegment.unIndent();
                codeSegment.addSourceCode("%end;\n\n");
            }
            if (!priorExcpTable && exceptionTableFullName != WORK_EXCEPTIONS_TABLE) {
                String excpDSOptionsString;
                codeSegment.addSourceCode("proc append base=").addSourceCode(exceptionTableFullName);
                excpTableOptions = m_oDVTModel.getTableOptionObject(exceptionTable, false);
                if (excpTableOptions != null && (excpDSOptionsString = excpTableOptions.getTableOptions(true, codeSegment.getCurrentServer())) != null) {
                    codeSegment.addSourceCode(excpDSOptionsString.length() > 0 ? excpDSOptionsString + "\n" : "");
                }
                codeSegment.addSourceCode(" data=etls_Exceptions(SORTEDBY=_NULL_) force;\n").addSourceCode("run; \n\n");
            }
            if (abort || dupAbort) {
                if (this.needExceptionReport) {
                    ValidationUtil.genAbortJob(codeSegment, abort || dupAbort, this.needExceptionReport);
                } else {
                    codeSegment.genPercentPutStatement(RB.getStringResource("ValidationUtil.Abort.comment.sasmacro.notrans"), "ERROR%QUOTE(:)");
                    codeSegment.addSourceCode(codeSegment.getAbortJobCode("8000")).addSourceCode("\n\n");
                }
            }
            if (ValidationUtil.isExceptionTableNeeded(m_oDVTModel)) {
                codeSegment.newLine();
                codeSegment.addSourceCode("%makeReport; \n\n");
            }
            if (this.needExceptionReport) {
                this.deleteWorkTable(codeSegment, WORK_EXCEPTIONS_TABLE);
                codeSegment.addSourceCode("\n\n");
            }
            codeSegment.genTableExist(WORK_SOURCE_TABLE, "work_source_exist");
            codeSegment.addSourceCode("%if &work_source_exist > 0 %then\n").addSourceCode("%do;\n\n");
            codeSegment.indent();
            this.deleteWorkTable(codeSegment, WORK_SOURCE_TABLE);
            codeSegment.unIndent();
            codeSegment.addSourceCode("\n%end;\n");
            codeSegment.genGOTOErrorRoutine("STEP", "").addSourceCode("%mend ").addSourceCode(MACRO_NAME).addSourceCode(";\n").addSourceCode("%").addSourceCode(MACRO_NAME).addSourceCode(";\n\n");
        }
        catch (IOException e) {
            throw new CodegenException(e, (IObject)m_oDVTModel);
        }
        return codeSegment;
    }

    private ICodeSegment genNeededAttribs(ICodeSegment codeSegment, List lTargetColumns, IColumn[] aSourceColumns) {
        IColumn targetColumn = null;
        String targetColumnName = "";
        int targetColumnLength = 0;
        boolean needAttrib = true;
        boolean didAtLeastOne = false;
        boolean bFormats = true;
        if (m_oDVTModel != null && m_oDVTModel instanceof AbstractDataTransform && !m_oDVTModel.isFormatGenerationEnabled()) {
            bFormats = false;
        }
        for (int i = 0; i < lTargetColumns.size(); ++i) {
            targetColumn = (IColumn)lTargetColumns.get(i);
            targetColumnLength = targetColumn.getLength();
            targetColumnName = targetColumn.getColumnName(false);
            needAttrib = true;
            IColumn sourceColumn = null;
            for (int j = 0; j < aSourceColumns.length; ++j) {
                sourceColumn = aSourceColumns[j];
                if (!sourceColumn.getColumnName(false).equalsIgnoreCase(targetColumnName)) continue;
                if (targetColumnLength > sourceColumn.getLength()) break;
                needAttrib = false;
                break;
            }
            if (!needAttrib) continue;
            if (!didAtLeastOne) {
                codeSegment.addCommentLine("Define lengths for columns with longer lengths in target");
            }
            didAtLeastOne = true;
            codeSegment.addSourceCode(targetColumn.getAttribStatement(codeSegment.isQuoting(), true, bFormats, true));
        }
        if (didAtLeastOne) {
            codeSegment.addSourceCode("\n");
        }
        return codeSegment;
    }

    protected static ICodeSegment genExcpColumns(ICodeSegment codeSegment, IPhysicalTable exceptionTable) {
        if (exceptionTable != null) {
            codeSegment.addSourceCode(ExceptionTable.getInstance().getAttribStatement(exceptionTable, m_oDVTModel));
            codeSegment.addSourceCode("\n");
        } else if (exceptionTable == null) {
            codeSegment.addSourceCode("attrib x_row length = 8 label = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.RowNumber.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_type   length = $50  label = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.TypeOfException.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_column length = $100 label = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.ColumnName.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_note length = $200 label = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.ColumnValue.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_custom_name length = $100 label = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.CustomName.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_custom_value length = $200 label = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.CustomValue.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_custom_rule length = $250 label = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.CustomRule.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_datetime length = 8 label = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.Runtime.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_action length = $50  label = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.ActionTaken.label.txt")).addSourceCode("\";\n");
        }
        return codeSegment;
    }

    protected ICodeSegment genCustomFormats(ICodeSegment codeSegment, List lCustom) throws BadLibraryDefinitionException, CodegenException, MdException, RemoteException, ServerException, BadServerDefinitionException {
        int fmtCount = 0;
        for (int i = 0; i < lCustom.size(); ++i) {
            ModelList lColumnsToAssign = null;
            DataValidationRecord customDVRecord_i = (DataValidationRecord)lCustom.get(i);
            for (int j = 0; j <= 1; ++j) {
                lColumnsToAssign = j == 0 ? customDVRecord_i.getCustomTrueTypeRecords() : customDVRecord_i.getCustomFalseTypeRecords();
                for (int k = 0; k < lColumnsToAssign.size(); ++k) {
                    DataValidationCustomConditionRecord oCustomRecord_k = (DataValidationCustomConditionRecord)lColumnsToAssign.get(k);
                    IColumn column = oCustomRecord_k.getSetColumn();
                    if (column == null) {
                        throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoCustomColumn.error.txt"), (IObject)m_oDVTModel);
                    }
                    if (oCustomRecord_k.getAssign_Type() != DataValidationRecord.TRANSLATION_INT) continue;
                    codeSegment.addSectionComment(MessageFormat.format(RB.getStringResource("DataValidationCodegen.CustomFormats.comment.txt"), column.getColumnName(false).replaceAll("\"", "\"\"")));
                    IPhysicalTable translationTable = (IPhysicalTable)oCustomRecord_k.getSourceColumn().getTable();
                    if (translationTable == null) {
                        throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoTransTable.error.txt"), (IObject)m_oDVTModel);
                    }
                    String unquotedTableName = translationTable.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), false, false, false, "").replaceAll("\"", "\"\"");
                    String transLibRef = DBMSNamesUtil.getLibrefPart(unquotedTableName);
                    String transTableName = DBMSNamesUtil.getTableNamePart(unquotedTableName);
                    try {
                        translationTable.genAccessPath(codeSegment, m_oDVTModel.getTableOptionObject(translationTable, true));
                    }
                    catch (MdException e) {
                        throw new CodegenException((Exception)((Object)e), (IObject)translationTable);
                    }
                    catch (BadLibraryDefinitionException e) {
                        throw new CodegenException(e, (IObject)translationTable);
                    }
                    catch (BadServerDefinitionException e) {
                        throw new CodegenException(e, (IObject)translationTable);
                    }
                    catch (RemoteException e) {
                        throw new CodegenException(e, (IObject)translationTable);
                    }
                    catch (ServerException e) {
                        throw new CodegenException(e, (IObject)translationTable);
                    }
                    IColumn fromColumn = oCustomRecord_k.getSourceColumn();
                    if (fromColumn == null) {
                        throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoTransFrom.error.txt"), (IObject)m_oDVTModel);
                    }
                    String fromName = fromColumn.getColumnName(false);
                    IColumn toColumn = oCustomRecord_k.getTargetColumn();
                    if (toColumn == null) {
                        throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoTransTo.error.txt"), (IObject)m_oDVTModel);
                    }
                    String toName = toColumn.getColumnName(false);
                    String fromType = fromColumn.getType() == 1 ? NUMERIC : CHARACTER;
                    String toType = toColumn.getType() == 1 ? NUMERIC : CHARACTER;
                    String formatType = toType.equals(NUMERIC) ? INFORMAT : fromType;
                    boolean bNeedValidVarnameReset = false;
                    if (translationTable.isQuoted()) {
                        fromName = DBMSNamesUtil.getQuotedString(fromName, false);
                        toName = DBMSNamesUtil.getQuotedString(toName, false);
                        transTableName = transLibRef + "." + DBMSNamesUtil.getQuotedString(transTableName, false);
                        if (!codeSegment.isQuoting()) {
                            codeSegment.genValidvarnameOptionAny(true);
                            bNeedValidVarnameReset = true;
                        }
                    } else {
                        transTableName = transLibRef + "." + transTableName;
                    }
                    codeSegment.genGetNumRows(transTableName, translationTable.getReadTableOptions(false), "etls_hasRows", true, "1");
                    codeSegment.addSourceCode("%if &etls_hasRows = 0 %then \n").addSourceCode("%do;  \n").indent().genPercentPutStatement(MessageFormat.format(RB.getStringResource("DataValidationCodegen.Custom.NoRecords.error.sasmacro.notrans"), transTableName), "ERROR%QUOTE(:)").genGOTOError("STEP").unIndent().addSourceCode("%end; \n\n");
                    boolean bSetValueTo = "Yes".equals(oCustomRecord_k.getProperty_SetValueToChkBox_DefVal());
                    String formatName = "_" + String.valueOf(fmtCount).trim() + "cFMT";
                    ++fmtCount;
                    if (formatType.equals(CHARACTER)) {
                        formatName = "$" + formatName;
                    }
                    IColumn sourceColumn = oCustomRecord_k.getSetColumn();
                    int toFmtLength = 32;
                    if (sourceColumn.getType() == 0) {
                        toFmtLength = sourceColumn.getLength();
                    }
                    codeSegment.addSourceCode("data work.etls_fmtData (keep = fmtName start label type hlo default); \n").indent().addSourceCode("length hlo $1 \n");
                    if (formatType.equals(INFORMAT)) {
                        codeSegment.addSourceCode("       label 8 \n");
                    } else {
                        codeSegment.addSourceCode("       label $").addSourceCode(String.valueOf(Math.max(32, toFmtLength))).addSourceCode("\n");
                    }
                    if (fromType.equals(NUMERIC) && !formatType.equals(INFORMAT)) {
                        codeSegment.addSourceCode("       start 8; \n");
                    } else {
                        codeSegment.addSourceCode("       start $32; \n");
                    }
                    codeSegment.addSourceCode("set " + transTableName + translationTable.getReadTableOptions(true) + " end=eof; \n");
                    if (fromType.equals(NUMERIC) && formatType.equals(INFORMAT)) {
                        codeSegment.addSourceCode("start = left(put(").addSourceCode(fromName).addSourceCode(",32.)); \n");
                    } else {
                        codeSegment.addSourceCode("start = ").addSourceCode(fromName).addSourceCode("; \n");
                    }
                    codeSegment.addSourceCode("label = ").addSourceCode(toName).addSourceCode("; \n").addSourceCode("fmtName = \"").addSourceCode(formatName).addSourceCode("\"; \n").addSourceCode("type = \"").addSourceCode(formatType).addSourceCode("\"; \n").addSourceCode("default = ").addSourceCode(String.valueOf(toFmtLength)).addSourceCode("; \n").addSourceCode("hlo = \"\"; \n");
                    if (bSetValueTo) {
                        codeSegment.addSourceCode("output; \n").addSourceCode("if eof then \n").addSourceCode("do; \n").indent().addSourceCode("hlo = \"O\"; \n");
                        if (fromType.equals(NUMERIC) && !formatType.equals(INFORMAT)) {
                            codeSegment.addSourceCode("start = -999999; \n");
                        } else {
                            codeSegment.addSourceCode("start = \"-999999\"; \n");
                        }
                        String setValueTo = oCustomRecord_k.getProperty_SetValueToTxtFld_DefVal();
                        if (setValueTo == null || setValueTo.equals("")) {
                            setValueTo = toType.equals(NUMERIC) ? "." : "\"\"";
                        }
                        codeSegment.addSourceCode("label = ").addSourceCode(setValueTo).addSourceCode("; \n").addSourceCode("output; \n").unIndent().addSourceCode("end; \n");
                    }
                    codeSegment.unIndent().addSourceCode("run; \n\n").addSourceCode("proc sort data = ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" nodupkey; \n").indent().addSourceCode("by start; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("proc format cntlin=").addSourceCode(WORK_FMT_TABLE).addSourceCode("; \n").addSourceCode("run; \n\n").genTableDelete(WORK_FMT_TABLE);
                    if (!bNeedValidVarnameReset) continue;
                    codeSegment.genValidvarnameOptionReset();
                }
            }
        }
        return codeSegment;
    }

    protected ICodeSegment genInvalidValuesFormats(ICodeSegment codeSegment, List lInvalidValues) throws BadLibraryDefinitionException, CodegenException, ServerException, RemoteException, BadServerDefinitionException, MdException {
        for (int i = 0; i < lInvalidValues.size(); ++i) {
            DataValidationRecord invalidHandler = (DataValidationRecord)lInvalidValues.get(i);
            IColumn column = invalidHandler.getColumn_FM1();
            if (column == null) {
                throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoInvalidColumn.error.txt"), (IObject)m_oDVTModel);
            }
            int colLength = 32;
            if (column.getType() == 0) {
                colLength = column.getLength();
            }
            codeSegment.addSectionComment(MessageFormat.format(RB.getStringResource("DataValidationCodegen.InvalidFormat.comment.txt"), column.getColumnName(false)));
            IColumn lookupColumn = invalidHandler.getLookupColumn_FM2();
            if (lookupColumn == null) {
                throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoLookupColumn.error.txt"), (IObject)m_oDVTModel);
            }
            IPhysicalTable lookupTable = (IPhysicalTable)lookupColumn.getTable();
            if (lookupTable == null) {
                throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoLookupTable.error.txt"), (IObject)m_oDVTModel);
            }
            String lkpTableName = lookupTable.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), false, false, false, "");
            String lkpUnquotedTableName = lkpTableName.replaceAll("\"", "\"\"");
            String lkpLibRef = DBMSNamesUtil.getLibrefPart(lkpTableName);
            lkpTableName = DBMSNamesUtil.getTableNamePart(lkpTableName);
            try {
                lookupTable.genAccessPath(codeSegment, m_oDVTModel.getTableOptionObject(lookupTable, true));
            }
            catch (MdException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)lookupTable);
            }
            catch (BadLibraryDefinitionException e) {
                throw new CodegenException(e, (IObject)lookupTable);
            }
            catch (BadServerDefinitionException e) {
                throw new CodegenException(e, (IObject)lookupTable);
            }
            catch (RemoteException e) {
                throw new CodegenException(e, (IObject)lookupTable);
            }
            catch (ServerException e) {
                throw new CodegenException(e, (IObject)lookupTable);
            }
            String columnName = lookupColumn.getColumnName(false);
            String unquotedColumnName = columnName.replaceAll("\"", "\"\"");
            String columnType = lookupColumn.getType() == 0 ? CHARACTER : NUMERIC;
            String formatName = "_" + String.valueOf(i).trim() + "iFMT";
            String blanksValue = invalidHandler.getProperty_FM1_DefVal();
            boolean bNeedValidvarnameReset = false;
            boolean bIsQuotingValue = codeSegment.isQuoting();
            if (lookupTable.isQuoted()) {
                columnName = DBMSNamesUtil.getQuotedString(columnName, false);
                lkpTableName = lkpLibRef + "." + DBMSNamesUtil.getQuotedString(lkpTableName, false);
                if (!codeSegment.isQuoting()) {
                    codeSegment.genValidvarnameOptionAny(true);
                    bNeedValidvarnameReset = true;
                    codeSegment.setQuoting(true);
                }
            } else {
                lkpTableName = lkpLibRef + "." + lkpTableName;
            }
            codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidCheckLookup.comment.txt")).genGetNumRows(lookupTable.getFullNameQuotedAsNeeded(codeSegment), lookupTable.getReadTableOptions(false), "etls_hasRows", true, "1").addSourceCode("\n").genGetColumnExists(lookupTable, lookupColumn, "etls_dsid", "etls_lookupVar").addSourceCode("%if &etls_dsid ne 0 %then \n").addSourceCode("%do; ").addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidLookupOpened.comment.txt")).addSourceCode(" \n").indent().addSourceCode("%if &etls_lookupVar eq 0 %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(MessageFormat.format(RB.getStringResource("DataValidationCodegen.InvalidNoColumn.sasmacro.notrans"), unquotedColumnName, lkpUnquotedTableName), "ERROR%QUOTE(:)").genGOTOError("STEP").unIndent().addSourceCode("%end; \n\n");
            if (!"Yes".equals(blanksValue)) {
                codeSegment.addSourceCode("%if &etls_hasRows = 0 %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(MessageFormat.format(RB.getStringResource("DataValidationCodegen.InvalidNoRecords.sasmacro.notrans"), lkpUnquotedTableName), "ERROR%QUOTE(:)").genGOTOError("STEP").unIndent().addSourceCode("%end; \n\n");
            }
            codeSegment.unIndent().addSourceCode("%end; ").addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidLookupOpened.comment.txt")).addSourceCode(" \n").addSourceCode("%else \n").addSourceCode("%do; \n").indent().genPercentPutStatement(MessageFormat.format(RB.getStringResource("DataValidationCodegen.InvalidOpenFailed.sasmacro.notrans"), lkpUnquotedTableName), "ERROR%QUOTE(:)").genGOTOError("STEP").unIndent().addSourceCode("%end; \n\n");
            codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidMakeFormat.comment.txt")).addSourceCode("data ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" (keep = fmtName start label type hlo default); \n\n").indent().addSourceCode("length label 4 \n").addSourceCode("       start ");
            if (columnType.equalsIgnoreCase(NUMERIC)) {
                codeSegment.addSourceCode("$32; \n");
            } else {
                codeSegment.addSourceCode("$").addSourceCode(String.valueOf(colLength)).addSourceCode("; \n");
            }
            codeSegment.addSourceCode("%if &etls_hasRows %then \n").addSourceCode("%do; ").addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidRecords.comment.txt")).indent().addSourceCode("set " + lkpTableName + " end = eof; \n");
            if (columnType.equals(NUMERIC)) {
                codeSegment.addSourceCode("start = left(put(").addSourceCode(columnName).addSourceCode(",32.)); \n");
            } else {
                codeSegment.addSourceCode("start = " + columnName + "; \n");
            }
            codeSegment.addSourceCode("label = 1; \n").addSourceCode("fmtName = \"").addSourceCode(formatName).addSourceCode("\"; \n").addSourceCode("type = \"I\"; \n").addSourceCode("default = ").addSourceCode(String.valueOf(colLength)).addSourceCode("; \n").addSourceCode("output; \n").addSourceCode("if eof then \n").unIndent().addSourceCode("%end; ").addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidRecords.comment.txt")).addSourceCode("%else \n").addSourceCode("%do; \n").indent().addSourceCode("fmtName = \"").addSourceCode(formatName).addSourceCode("\"; \n").addSourceCode("type = \"I\"; \n").addSourceCode("default = ").addSourceCode(String.valueOf(colLength)).addSourceCode("; \n").unIndent().addSourceCode("%end; \n\n").addSourceCode("do;  \n").indent();
            if ("Yes".equalsIgnoreCase(blanksValue)) {
                if (columnType.equalsIgnoreCase(NUMERIC)) {
                    codeSegment.addSourceCode("start = \".\"; \n");
                } else {
                    codeSegment.addSourceCode("start = \"\"; \n");
                }
                codeSegment.addSourceCode("label = 1; \n").addSourceCode("output; \n");
            }
            codeSegment.addSourceCode("start = \"-9999999\"; \n").addSourceCode("hlo = \"O\"; \n").addSourceCode("label = -1; \n").addSourceCode("output; \n").unIndent().addSourceCode("end; \n\n").unIndent().addSourceCode("run; \n\n").addSourceCode("%if (&syserr gt 4) %then \n").indent().genGOTOError("STEP").unIndent().addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidDeleteDups.comment.txt")).addSourceCode("proc sort data = ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" nodupkey; \n").indent().addSourceCode("by start; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("%if (&syserr gt 4) %then \n").indent().genGOTOError("STEP").unIndent().addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidCreateFormat.comment.txt")).addSourceCode("proc format cntlin = ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" library = work; \n").addSourceCode("run; \n\n").addSourceCode("%if (&syserr gt 4) %then \n").indent().genGOTOError("STEP").unIndent().genTableDelete(WORK_FMT_TABLE);
            if (!bNeedValidvarnameReset) continue;
            codeSegment.genValidvarnameOptionReset();
            if (bIsQuotingValue == codeSegment.isQuoting()) continue;
            codeSegment.setQuoting(bIsQuotingValue);
        }
        return codeSegment;
    }

    protected ICodeSegment getCustomValidationCodeSegment(ICodeSegment parentCodeSegment, List lCustom, boolean needExceptionReport, List ignoreColumnsList) throws CodegenException {
        CodeSegment codeSegment = new CodeSegment(parentCodeSegment.getCodeGenerationEnvironment(), m_oDVTModel, false);
        int fmtCount = 0;
        ModelList lColumnsToAssign = null;
        String sSelectedAction = "";
        String sSelectedActionText = "";
        boolean bAddConditionToExcpRpt = false;
        for (int i = 0; i < lCustom.size(); ++i) {
            String condition;
            DataValidationRecord customDVRecord_i = (DataValidationRecord)lCustom.get(i);
            String name = customDVRecord_i.getEvent_Name();
            String conditionNoQuote = condition = customDVRecord_i.getExpression();
            conditionNoQuote = conditionNoQuote.replace("\"", "");
            conditionNoQuote = conditionNoQuote.replace("'", "");
            for (int j = 0; j <= 1; ++j) {
                String ifType;
                if (j == 0) {
                    codeSegment.addSectionComment(MessageFormat.format(RB.getStringResource("DataValidationCodegen.CustomValues.comment.txt"), name));
                    codeSegment.addSourceCode("if (").addSourceCode(condition).addSourceCode(") then \n").addSourceCode("do; \n").indent();
                    ifType = RB.getStringResource("DataValidationCodegen.CustomTrue.comment.txt");
                    lColumnsToAssign = customDVRecord_i.getCustomTrueTypeRecords();
                    sSelectedAction = customDVRecord_i.getMetaAction(customDVRecord_i.getPropertyTrue_PS1_DefVal());
                    bAddConditionToExcpRpt = "Yes".equals(customDVRecord_i.get_Property_TrueExceptionChkBox_DefVal());
                } else {
                    codeSegment.addSourceCode("else \n").addSourceCode("do; \n").indent();
                    ifType = RB.getStringResource("DataValidationCodegen.CustomFalse.comment.txt");
                    lColumnsToAssign = customDVRecord_i.getCustomFalseTypeRecords();
                    sSelectedAction = customDVRecord_i.getMetaAction(customDVRecord_i.getPropertyFalse_PS1_DefVal());
                    bAddConditionToExcpRpt = "Yes".equals(customDVRecord_i.get_Property_FalseExceptionChkBox_DefVal());
                }
                sSelectedActionText = customDVRecord_i.getAction(sSelectedAction);
                if (lColumnsToAssign == null) continue;
                for (int k = 0; k < lColumnsToAssign.size(); ++k) {
                    String setValueTo;
                    String columnType;
                    DataValidationCustomConditionRecord oCustomRecord_k = (DataValidationCustomConditionRecord)lColumnsToAssign.get(k);
                    IColumn column = oCustomRecord_k.getSetColumn();
                    if (column == null) {
                        throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoCustomColumn.error.txt"), (IObject)m_oDVTModel);
                    }
                    String columnName = column.getColumnName(codeSegment);
                    String columnNameNoQuote = column.getColumnName(false);
                    if (!ignoreColumnsList.contains(column)) {
                        ignoreColumnsList.add(column);
                    }
                    if (oCustomRecord_k.getAssign_Type() == DataValidationRecord.EXPRESSION_INT) {
                        String expression = oCustomRecord_k.getExpression();
                        if (expression == null || expression.equals("")) {
                            expression = column.getType() == 1 ? "." : "' '";
                        }
                        codeSegment.addSourceCode(columnName).addSourceCode(" = ").addSourceCode(expression).addSourceCode("; \n\n");
                        continue;
                    }
                    boolean bAddTranslationNFToExcpRpt = "Yes".equals(oCustomRecord_k.getProperty_TranslateExceptionChkBox_DefVal());
                    boolean bSetValueToFlag = "Yes".equals(oCustomRecord_k.getProperty_SetValueToChkBox_DefVal());
                    IColumn fromColumn = oCustomRecord_k.getSourceColumn();
                    if (fromColumn == null) {
                        throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoTransFrom.error.txt"), (IObject)m_oDVTModel);
                    }
                    IColumn toColumn = oCustomRecord_k.getTargetColumn();
                    if (toColumn == null) {
                        throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoTransTo.error.txt"), (IObject)m_oDVTModel);
                    }
                    String fName = fromColumn.getColumnName(codeSegment);
                    String tName = toColumn.getColumnName(codeSegment);
                    String fromType = fromColumn.getType() == 0 ? CHARACTER : NUMERIC;
                    String toType = toColumn.getType() == 0 ? CHARACTER : NUMERIC;
                    String formatType = toType.equals(NUMERIC) ? INFORMAT : fromType;
                    String tempName = column.getType() == 0 ? "tempC" : "tempN";
                    if (bAddTranslationNFToExcpRpt) {
                        codeSegment.addSourceCode(tempName).addSourceCode(" = ").addSourceCode(columnName).addSourceCode(";\n");
                    }
                    String formatName = "_" + String.valueOf(fmtCount).trim() + "cFMT.";
                    ++fmtCount;
                    if (formatType.equals(CHARACTER)) {
                        formatName = "$" + formatName;
                    }
                    String string = columnType = column.getType() == 0 ? CHARACTER : NUMERIC;
                    if (formatType.equals(INFORMAT) && columnType.equals(CHARACTER)) {
                        codeSegment.addSourceCode(columnName).addSourceCode(" = left(put(input(").addSourceCode(columnName).addSourceCode(", ").addSourceCode(formatName).addSourceCode("),32.)); \n");
                    } else if (formatType.equals(INFORMAT)) {
                        codeSegment.addSourceCode(columnName).addSourceCode(" = input(").addSourceCode("left(put(").addSourceCode(columnName).addSourceCode(",32.)), ").addSourceCode(formatName).addSourceCode("); \n");
                    } else if (formatType.equals(CHARACTER) && columnType.equals(NUMERIC)) {
                        codeSegment.addSourceCode(columnName).addSourceCode(" = input(put(left(put(").addSourceCode(columnName).addSourceCode(",32.)), ").addSourceCode(formatName).addSourceCode("), 32.); \n");
                    } else if (formatType.equals(NUMERIC) && columnType.equals(CHARACTER)) {
                        codeSegment.addSourceCode(columnName).addSourceCode(" = put(input(").addSourceCode(columnName).addSourceCode(", 32.), ").addSourceCode(formatName).addSourceCode("); \n");
                    } else if (columnType.equals(NUMERIC)) {
                        codeSegment.addSourceCode(columnName).addSourceCode(" = input(put(").addSourceCode(columnName).addSourceCode(", ").addSourceCode(formatName).addSourceCode("), 32.); \n");
                    } else {
                        codeSegment.addSourceCode(columnName).addSourceCode(" = put(").addSourceCode(columnName).addSourceCode(", ").addSourceCode(formatName).addSourceCode("); \n");
                    }
                    if (!bAddTranslationNFToExcpRpt) continue;
                    if (bSetValueToFlag) {
                        setValueTo = oCustomRecord_k.getProperty_SetValueToTxtFld_DefVal();
                        if (setValueTo == null || setValueTo.equals("")) {
                            setValueTo = toType.equals(NUMERIC) ? "." : "\"\"";
                        }
                        codeSegment.addSourceCode("if ").addSourceCode(columnName).addSourceCode(" eq ").addSourceCode(setValueTo).addSourceCode(" then \n");
                    } else {
                        codeSegment.addSourceCode("if ").addSourceCode(columnName).addSourceCode(" eq ").addSourceCode(tempName).addSourceCode(" then \n");
                    }
                    codeSegment.addSourceCode("do; \n").indent();
                    if (needExceptionReport) {
                        codeSegment.addSourceCode("x_custom_name = \"").addSourceCode(name).addSourceCode(": ").addSourceCode(ifType).addSourceCode(": ").addSourceCode(m_sSetColumn).addSourceCode(": ").addSourceCode(columnNameNoQuote).addSourceCode("\";").newLine();
                        codeSegment.addSourceCode("x_custom_value = ").addSourceCode(tempName).addSourceCode(";").newLine();
                        codeSegment.addSourceCode("x_custom_rule = \"").addSourceCode(m_sTranslation);
                        if (bSetValueToFlag) {
                            setValueTo = oCustomRecord_k.getProperty_SetValueToTxtFld_DefVal();
                            setValueTo = setValueTo.replace("\"", "");
                            setValueTo = setValueTo.replace("'", "");
                            codeSegment.addSourceCode(": ").addSourceCode(m_sSetValueTo).addSourceCode(": ").addSourceCode(setValueTo);
                        }
                        codeSegment.addSourceCode("\";").newLine();
                        codeSegment.addSourceCode("x_type = \"").addSourceCode(m_sCustomValidation).addSourceCode(": ").addSourceCode(m_sSetColumn).addSourceCode("\";").newLine();
                        codeSegment.addSourceCode("x_action = \"\";").newLine(2);
                        codeSegment.addSourceCode("output etls_Exceptions;\n");
                    }
                    codeSegment.addSourceCode("i_excp = 1;\n").addSourceCode("cust_excp = 1;\n").newLine().addSourceCode("excp_rows + 1;").newLine().unIndent().addSourceCode("end;").newLine();
                }
                if (bAddConditionToExcpRpt) {
                    if (sSelectedAction.length() <= 0) {
                        sSelectedActionText = RB.getStringResource("DataValidationCodegen.NoAction.txt");
                    }
                    if (needExceptionReport) {
                        codeSegment.addSourceCode("x_custom_name = \"").addSourceCode(name).addSourceCode(": ").addSourceCode(ifType).addSourceCode("\";").newLine();
                    }
                    codeSegment.addSourceCode("x_custom_value = \"\";").newLine();
                    codeSegment.addSourceCode("x_custom_rule = \"").addSourceCode(conditionNoQuote).addSourceCode("\";").newLine();
                    codeSegment.addSourceCode("x_type = \"").addSourceCode(m_sCustomValidation).addSourceCode("\";").newLine();
                    codeSegment.addSourceCode("x_action = \"").addSourceCode(sSelectedActionText).addSourceCode("\";").newLine(2);
                    codeSegment.addSourceCode("output etls_Exceptions; \n\n");
                    codeSegment.addSourceCode("i_excp = 1; \n").addSourceCode("excp_rows + 1;\n\n");
                }
                if (sSelectedAction == null || sSelectedAction.equals("MOVE")) {
                    codeSegment.addSourceCode("i_move = 1; \n");
                } else if (sSelectedAction.equals("ABORT")) {
                    codeSegment.addSourceCode("i_abort = 1; \n");
                }
                if (j == 0) {
                    codeSegment.unIndent().addSourceCode("end;  /* if (").addSourceCode(condition).addSourceCode(") */\n");
                    continue;
                }
                codeSegment.unIndent().addSourceCode("end;  /* else */\n");
            }
            codeSegment.addSourceCode("\n");
        }
        return codeSegment;
    }

    protected ICodeSegment genMissingValuesValidation(ICodeSegment codeSegment, List lMissingValues, boolean needExceptionReport) throws CodegenException {
        DataValidationRecord missingHandler = null;
        for (int i = 0; i < lMissingValues.size(); ++i) {
            missingHandler = (DataValidationRecord)lMissingValues.get(i);
            String sSelectedActionText = missingHandler.getAction();
            String sSelectedAction = missingHandler.getMetaAction(sSelectedActionText);
            IColumn column = missingHandler.getColumn_FM1();
            if (column == null) {
                throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoMissingColumn.error.txt"), (IObject)m_oDVTModel);
            }
            String columnName = column.getColumnName(codeSegment);
            codeSegment.addSectionComment(MessageFormat.format(RB.getStringResource("DataValidationCodegen.MissingValue.comment.txt"), column.getColumnName(false)));
            codeSegment.addSourceCode("\n");
            if (column.getType() == 0) {
                codeSegment.addSourceCode("if (").addSourceCode(columnName).addSourceCode(" eq \"\") then \n").addSourceCode("do;\n");
            } else {
                codeSegment.addSourceCode("if (").addSourceCode(columnName).addSourceCode(" eq .) then \n").addSourceCode("do;\n");
            }
            codeSegment.indent();
            String expression = "";
            if (sSelectedAction.equals("CHANGE")) {
                expression = " " + missingHandler.getExpression();
            }
            if (needExceptionReport) {
                codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.ETLExceptionsSave.comment.txt")).addSourceCode("\n");
            }
            codeSegment.addSourceCode("x_column = \"").addSourceCode(column.getColumnName(false).replaceAll("\"", "\"\"")).addSourceCode("\";\n").addSourceCode("x_note = " + columnName + ";\n").addSourceCode("x_type = \"").addSourceCode(RB.getStringResource("DataValidationCodegen.MissingException.msg.txt")).addSourceCode("\";\n").addSourceCode("x_action = \"").addSourceCode(sSelectedActionText).addSourceCode(" ").addSourceCode(expression.replaceAll("\"", "\"\"")).addSourceCode("\";\n").addSourceCode("x_custom_name = \"\";\n").addSourceCode("x_custom_value = \"\";\n").addSourceCode("x_custom_rule = \"\";\n\n");
            if (needExceptionReport) {
                codeSegment.addSourceCode("output etls_Exceptions;\n\n");
            }
            codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.SetFlags.comment.txt")).addSourceCode("i_excp = 1;\n");
            if (sSelectedAction.equals("MOVE")) {
                codeSegment.addSourceCode("i_move = 1;\n");
            } else if (sSelectedAction.equals("ABORT")) {
                codeSegment.addSourceCode("i_abort =1;\n");
            } else if (sSelectedAction.equals("CHANGE") && !expression.trim().equals("")) {
                codeSegment.addCommentLine(MessageFormat.format(RB.getStringResource("DataValidationCodegen.ResetValue.comment.txt"), column.getColumnName(false))).addSourceCode(columnName).addSourceCode(" = ").addSourceCode(expression).addSourceCode(";\n");
            }
            codeSegment.addSourceCode("excp_rows+1;\n\n").unIndent().addSourceCode("end;  ").addCommentLine(MessageFormat.format(RB.getStringResource("DataValidationCodegen.ColumnIsMissing.comment.txt"), column.getColumnName(false))).addSourceCode("\n");
        }
        return codeSegment;
    }

    protected ICodeSegment genInvalidValuesValidation(ICodeSegment codeSegment, List lInvalidValues, boolean needExceptionReport) throws CodegenException {
        for (int i = 0; i < lInvalidValues.size(); ++i) {
            IColumn column;
            DataValidationRecord invalidHandler = (DataValidationRecord)lInvalidValues.get(i);
            String sSelectedActionText = invalidHandler.getAction();
            String sSelectedAction = invalidHandler.getMetaAction(sSelectedActionText);
            String sExpression = "";
            if (sSelectedAction.equals("CHANGE")) {
                sExpression = invalidHandler.getExpression();
                sSelectedActionText = sSelectedActionText + " ";
                sSelectedActionText = sSelectedActionText + sExpression;
                sSelectedActionText = sSelectedActionText.replaceAll("\"", "'");
            }
            if ((column = invalidHandler.getColumn_FM1()) == null) {
                throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoInvalidColumn.error.txt"), (IObject)m_oDVTModel);
            }
            String columnName = column.getColumnName(codeSegment);
            String unquotedColumnName = column.getColumnName(false).replaceAll("\"", "\"\"");
            String columnType = column.getType() == 0 ? CHARACTER : NUMERIC;
            String formatName = "_" + String.valueOf(i).trim() + "iFMT.";
            String exceptionType = RB.getStringResource("DataValidationCodegen.InvalidException.msg.txt");
            codeSegment.addSectionComment(MessageFormat.format(RB.getStringResource("DataValidationCodegen.InvalidColumn.comment.txt"), unquotedColumnName)).addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidApplyFormat.comment.txt")).addSourceCode("\n");
            codeSegment.addSourceCode("etls_valid_flg = input(");
            if (columnType.equals(NUMERIC)) {
                codeSegment.addSourceCode("left(put(").addSourceCode(columnName).addSourceCode(",32.))");
            } else {
                codeSegment.addSourceCode(columnName);
            }
            codeSegment.addSourceCode(", ").addSourceCode(formatName).addSourceCode("); \n\n").addSourceCode("if (etls_valid_flg ne 1) then \n").addSourceCode("do; ").addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidFoundInvalid.comment.txt"));
            codeSegment.addSourceCode("\n").indent().addCommentLine(RB.getStringResource("DataValidationCodegen.SetFlags.comment.txt")).addSourceCode("i_excp = 1; \n").addSourceCode("excp_rows+1;\n\n");
            if (needExceptionReport) {
                codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidUpdateExcp.comment.txt"));
            }
            codeSegment.addSourceCode("x_column = \"").addSourceCode(column.getColumnName(false).replaceAll("\"", "\"\"")).addSourceCode("\";\n").addSourceCode("x_note = " + columnName + ";\n").addSourceCode("x_type   = \"").addSourceCode(exceptionType).addSourceCode("\"; \n").addSourceCode("x_action = \"").addSourceCode(sSelectedActionText).addSourceCode("\"; \n").addSourceCode("x_custom_name = \"\";\n").addSourceCode("x_custom_value = \"\";\n").addSourceCode("x_custom_rule = \"\";\n\n");
            if (needExceptionReport) {
                codeSegment.addSourceCode("output etls_Exceptions;\n\n");
            }
            if (sSelectedAction.equals("MOVE")) {
                codeSegment.addSourceCode("i_move = 1; \n\n");
            } else if (sSelectedAction.equals("ABORT")) {
                codeSegment.addSourceCode("i_abort=1;\n");
            } else if (sSelectedAction.equals("CHANGE") && sExpression.length() > 0) {
                codeSegment.addSourceCode(columnName).addSourceCode(" = ").addSourceCode(sExpression).addSourceCode("; \n\n");
            }
            codeSegment.unIndent().addSourceCode("end; ").addCommentLine(RB.getStringResource("DataValidationCodegen.InvalidFoundInvalid.comment.txt")).addSourceCode("\n");
        }
        return codeSegment;
    }

    public ICodeSegment determineDuplicateValues(ICodeSegment codeSegment, List lDupValues, String sourceDSN) throws CodegenException {
        int iDupColLength = m_oDVTModel.getDupColumnNamesLength();
        codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.Duplicates.comment.txt")).addSourceCode("\n");
        codeSegment.addSourceCode("proc sql;\n").addSourceCode(" alter table " + sourceDSN + "\n").addSourceCode(" add x_row num(8) label='Row Number from Source Table'\n").addSourceCode(" ;\n").addSourceCode(" update " + sourceDSN + "\n").addSourceCode("  set x_row=monotonic()\n").addSourceCode(" ;\n").addSourceCode("quit;\n\n");
        DataValidationRecord dupHandler = null;
        for (int i = 0; i <= lDupValues.size() - 1; ++i) {
            int e = i + 1;
            dupHandler = (DataValidationRecord)lDupValues.get(i);
            String selectedActionText = dupHandler.getAction();
            String selectedAction = dupHandler.getMetaAction(selectedActionText);
            String selectedDupTablesToCheck = dupHandler.getPropertyTablesToCheck_MetaValue();
            ArrayList lOrderByCols = dupHandler.getColumnList_FM1();
            if (lOrderByCols.isEmpty()) {
                throw new CodegenException(RB.getStringResource("DataValidationCodegen.Duplicates.NoByColumns.msg.txt"), (IObject)m_oDVTModel);
            }
            String sByColumns = codeSegment.makeColumnList(lOrderByCols, false, "   ", false, " ", "", codeSegment.isQuoting(), "", false).trim();
            String sByColumnsNoQuote = codeSegment.makeColumnList(lOrderByCols, false, "   ", false, " ", "", false, "", false).trim();
            String lastColumn = null;
            IColumn column = (IColumn)lOrderByCols.get(lOrderByCols.size() - 1);
            if (column != null) {
                lastColumn = column.getColumnName(false);
            }
            if (!m_oDVTModel.isGenerateDataStepHash()) {
                codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.Duplicates.UseSortToCheck.txt")).addSourceCode("\n");
                codeSegment.addSourceCode("proc sort data=" + sourceDSN + "(keep=x_row " + sByColumns + ") out=dups(keep=" + sByColumns + " x_row) NOEQUALS NOUNIQUEKEY;\n").addSourceCode(" by " + sByColumns + ";\n").addSourceCode("run;\n\n");
            } else if (m_oDVTModel.isGenerateDataStepHash()) {
                codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.Duplicates.UseHashToCheck.txt")).addSourceCode("\n");
                int hSize = m_oDVTModel.getDataStepHashExpSize();
                String hashCols = codeSegment.makeColumnList(lOrderByCols, false, " ", false, ",", "", true, "", false).replace("\"n", "\"").trim();
                codeSegment.addSourceCode("data dups(keep=x_row " + sByColumns + ");\n").addSourceCode("length dup" + e + " 3 move" + e + " $7;\n\n").addSourceCode("if 0 then set " + sourceDSN + "(keep=x_row " + sByColumns + ");\n\n").addSourceCode("if _n_ eq 1 then\n").addSourceCode("do;\n").addSourceCode("  declare hash h" + e + "(dataset: '" + sourceDSN + "(keep= " + sByColumns + "', multidata: 'yes', hashexp: " + hSize + ");\n").addSourceCode("               h" + e + ".defineKey(" + hashCols + ");\n").addSourceCode("               h" + e + ".defineData(" + hashCols + ");\n").addSourceCode("               h" + e + ".defineDone();\n").addSourceCode("end;\n\n").addSourceCode("set " + sourceDSN + "(keep=x_row " + sByColumns + ");\n\n").addCommentLine(RB.getStringResource("DataValidationCodegen.Duplicates.comment.txt")).addSourceCode("\n").addSourceCode("move" + e + "=\"" + selectedAction + "\";\n").addSourceCode("dupCol" + e + "=0;\n").addSourceCode("rc = h" + e + ".find();\n\n").addSourceCode("if (rc = 0) then\n").addSourceCode("do;\n").addSourceCode("  h" + e + ".has_next(result: r);\n\n").addSourceCode("  do while(r>0);\n").addSourceCode("    dup" + e + " = 1;\n").addSourceCode("    rc = h" + e + ".find_next();\n").addSourceCode("    h" + e + ".has_next(result: r);\n").addSourceCode("  end;\n\n").addSourceCode("end;\n\n").addSourceCode("if dup" + e + "=1 then output;\n\n").addSourceCode("run;\n\n");
            }
            codeSegment.addSourceCode("%let obs=0;\n").addSourceCode("proc sql noprint;\n").addSourceCode(" select count(*) into :obs\n").addSourceCode(" from dups;\n").addSourceCode("quit;\n").addSourceCode("%let obs=&obs;\n").addSourceCode("%if &obs=0 %then\n").addSourceCode("%do;").addCommentLine(RB.getStringResource("DataValidationCodegen.NoDuplicatesFound.comment.txt")).addSourceCode("\n").indent().addSourceCode("proc sql;\n").addSourceCode("  alter table " + sourceDSN + "\n").addSourceCode("  add dup" + e + " num(3), move" + e + " char(7), dupCol" + e + " char(").addSourceCode(Integer.toString(iDupColLength)).addSourceCode(");\n\n").addSourceCode("  update " + sourceDSN + "\n").addSourceCode("  set dup" + e + "=0, move" + e + "=\"" + selectedAction + "\", dupCol" + e + "=\"" + sByColumnsNoQuote + "\"\n").addSourceCode("  ;\n").addSourceCode("quit;\n\n").unIndent().addSourceCode("%end;  %else\n").addSourceCode("%do;\n\n").indent().addSourceCode("proc sort data=dups;\n").addSourceCode(" by " + sByColumns + " x_row;\n").addSourceCode("run;\n\n").addSourceCode("data dups;\n").addSourceCode(" set dups;\n").addSourceCode(" by " + sByColumns + ";\n\n").addSourceCode(" length move" + e + " $7 dupCol" + e + " $").addSourceCode(Integer.toString(iDupColLength).trim()).addSourceCode(";\n").addSourceCode(" if first." + lastColumn + " then dup" + e + "=1; else\n").addSourceCode(" dup" + e + "=2;\n\n").addSourceCode(" move" + e + "=\"" + selectedAction + "\";\n").addSourceCode(" dupCol" + e + "=\"" + sByColumnsNoQuote + "\";\n").addSourceCode("run;\n\n").addSourceCode("proc sql;\n").addSourceCode(" create table t" + e + " as\n").addSourceCode("  select a.*, b.dup" + e + ", b.move" + e + ", b.dupCol" + e + "\n").addSourceCode("  from " + sourceDSN + " a left join dups b\n").addSourceCode("    on a.x_row=b.x_row\n").addSourceCode(" ;\n").addSourceCode("quit;\n\n").addSourceCode("proc datasets library=work nolist nowarn memtype=(data view);\n").addSourceCode(" delete dups " + sourceDSN + ";\n").addSourceCode(" change t" + e + "=" + sourceDSN + ";\n").addSourceCode("quit;\n\n").unIndent().addSourceCode("%end;\n\n");
            if (!selectedDupTablesToCheck.equals("TARGET")) continue;
            String loaderTableName = "";
            IPhysicalTable nextTableLoaderTargetTable = null;
            try {
                nextTableLoaderTargetTable = m_oDVTModel.getNextPhysicalTable(null);
                if (nextTableLoaderTargetTable == null) {
                    codeSegment.addCommentLine("NOTE: No Table Loader was found following the DataValidation transform. ").addCommentLine("Only the source table will be checked for duplicates.").addSourceCode("\n\n");
                    continue;
                }
                if (nextTableLoaderTargetTable == null) continue;
                loaderTableName = nextTableLoaderTargetTable.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), false, false);
                codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.Exist.comment.txt")).genTableExist(loaderTableName, "etls_exist");
                nextTableLoaderTargetTable.genAccessPath(codeSegment, true, -1, codeSegment.getRuntimeStatsConnectMacros(codeSegment, false), codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled(), null);
                codeSegment.addSourceCode("%if &etls_exist > 0 %then \n").addSourceCode("%do;  ").addCommentLine(RB.getStringResource("DataValidationCodegen.TargetExists.comment.txt")).addSourceCode("\n").indent();
                codeSegment.addCommentLine(RB.getStringResource("DataValidationCodegen.SQL.comment.txt")).addSourceCode("proc sql;\n").addSourceCode(" create table tgtDups as\n").addSourceCode("  select distinct x_row, 1 as tDup" + e + "\n").addSourceCode(" from " + sourceDSN + " t inner join " + loaderTableName + " s\n");
                StringBuffer onClause = new StringBuffer("on ");
                for (int j = 0; j < lOrderByCols.size(); ++j) {
                    IColumn col = (IColumn)lOrderByCols.get(j);
                    if (col == null) {
                        throw new CodegenException(RB.getStringResource("DataValidationCodegen.NoDuplicateColumn.error.txt"), (IObject)m_oDVTModel);
                    }
                    String colName = col.getColumnName(codeSegment).trim();
                    if (j > 0) {
                        onClause.append(" and \n   ");
                    }
                    onClause.append("t.").append(colName).append(" = s.").append(colName);
                }
                codeSegment.addSourceCode(onClause.toString()).addSourceCode("\n").addSourceCode("; \n").addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
                codeSegment.addSourceCode("%let tObs=0;\n").addSourceCode("proc sql noprint;\n").addSourceCode(" select count(*) into :tObs\n").addSourceCode(" from tgtDups\n").addSourceCode("quit;\n\n").addSourceCode("%let tObs=&tObs;\n").addSourceCode("%if &tObs=0 %then\n").addSourceCode("%do;\n").addSourceCode("  proc sql;\n").addSourceCode("   alter table " + sourceDSN + "\n").addSourceCode("   add tDup" + e + " num(3);\n\n").addSourceCode("   update " + sourceDSN + "\n").addSourceCode("   set tDup" + e + "=0\n").addSourceCode("  ;\n").addSourceCode("  quit;\n\n").addSourceCode("%end;  %else\n").addSourceCode("%do;\n\n").addSourceCode("  proc sql;\n").addSourceCode("   create table tD" + e + " as\n").addSourceCode("    select a.*, b.tDup" + e + "\n").addSourceCode("    from " + sourceDSN + " a left join tgtDups b\n").addSourceCode("     on a.x_row=b.x_row\n").addSourceCode("   ;\n").addSourceCode("  quit;\n\n").addSourceCode("  proc datasets library=work nolist nowarn memtype=(data view);\n").addSourceCode("   delete tgtDups " + sourceDSN + ";\n").addSourceCode("   change tD" + e + "=" + sourceDSN + ";\n").addSourceCode("  quit;\n\n").addSourceCode("%end;\n\n");
                codeSegment.unIndent().addSourceCode("%end; ").addCommentLine(RB.getStringResource("DataValidationCodegen.TargetExists.comment.txt")).addSourceCode("\n");
                continue;
            }
            catch (MdException ex) {
                throw new CodegenException((Exception)((Object)ex), (IObject)nextTableLoaderTargetTable);
            }
            catch (BadLibraryDefinitionException ex) {
                throw new CodegenException(ex, (IObject)nextTableLoaderTargetTable);
            }
            catch (BadServerDefinitionException ex) {
                throw new CodegenException(ex, (IObject)nextTableLoaderTargetTable);
            }
            catch (RemoteException ex) {
                throw new CodegenException(ex, (IObject)nextTableLoaderTargetTable);
            }
            catch (ServerException ex) {
                throw new CodegenException(ex, (IObject)nextTableLoaderTargetTable);
            }
        }
        return codeSegment;
    }

    public ICodeSegment runEOFReport(ICodeSegment codeSegment, boolean sAbort, boolean tIsView, boolean isMove) {
        if (tIsView && !isMove) {
            codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.Cannot.Create.Report.comment.txt")).addSourceCode("\n");
        } else {
            codeSegment.addSourceCode("if eof then \n").addSourceCode("do; \n").indent().addCommentLine(RB.getStringResource("ValidationUtil.CreateFlags.comment.txt")).addSourceCode("\n").addSourceCode("call symputx(\"m_excp\", put(i_excp, 1.));\n").addSourceCode("call symputx(\"cust_excp\", put(cust_excp,1.));\n");
            if (sAbort) {
                codeSegment.addSourceCode("call symputx(\"m_abort\", put(i_abort, 1.)); \n");
            }
            codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.TotalSourceRows.comment.txt")).addSourceCode("call symputx(\"total_source_rows\",trim(left(put(_N_,9.))));\n").addCommentLine(RB.getStringResource("ValidationUtil.TotalValidRows.comment.txt")).addSourceCode("call symputx(\"total_valid_rows\",valid_rows);\n").addCommentLine(RB.getStringResource("ValidationUtil.TotalErrorRows.comment.txt")).addSourceCode("call symputx(\"total_error_rows\",error_rows);\n").addCommentLine(RB.getStringResource("ValidationUtil.TotalExcptnRows.comment.txt")).addSourceCode("call symputx(\"total_excp_rows\",excp_rows);\n\n").unIndent().addSourceCode("end;\n\n").addSourceCode("run;\n\n").addSourceCode("data _null_;\n").indent().addSourceCode("putlog \"NOTE: DATA VALIDATION SUMMARY: Total rows - SOURCE = %trim(&total_source_rows)\";\n").addSourceCode("putlog \"NOTE: DATA VALIDATION SUMMARY: Total rows - VALID RECORDS = %trim(&total_valid_rows)\";\n").addSourceCode("putlog \"NOTE: DATA VALIDATION SUMMARY: Total rows - ERROR = %trim(&total_error_rows)\";\n").addSourceCode("putlog \"NOTE: DATA VALIDATION SUMMARY: Total rows - EXCEPTION = %trim(&total_excp_rows)\";\n").unIndent().addSourceCode("run;\n\n");
        }
        return codeSegment;
    }

    public ICodeSegment createPermanentTable(ICodeSegment codeSegment, String workTable, String outputTable) {
        codeSegment.addSourceCode("proc append base=" + outputTable + " data=" + workTable + " force;\n").addSourceCode("run;\n\n");
        return codeSegment;
    }

    public ICodeSegment deleteWorkTable(ICodeSegment codeSegment, String workTable) {
        codeSegment.addSourceCode("proc datasets library=work memtype=(data view) nolist nowarn;\n").addSourceCode("  delete " + workTable + ";\n").addSourceCode("quit;\n\n");
        return codeSegment;
    }

    public static boolean isExceptionReportNeeded(List lMissing, List lInvalidValues, List lDuplicateValues, List lCustom) {
        if (lMissing.size() == 0 && lInvalidValues.size() == 0 && lDuplicateValues.size() == 0 && lCustom.size() == 0) {
            m_validationSelected = false;
        }
        return m_validationSelected;
    }

    public boolean isErrorTableNeeded() {
        String selectedAction;
        String selectedActionText;
        DataValidationRecord validationRow;
        int i;
        List lMissingValues = m_oDVTModel.getDVRMissing();
        List lInvalidValues = m_oDVTModel.getDVRInvalid();
        List lDuplicateValues = m_oDVTModel.getDVRDuplicate();
        List lCustom = m_oDVTModel.getDVRCustom();
        for (i = 0; i < lMissingValues.size(); ++i) {
            validationRow = (DataValidationRecord)lMissingValues.get(i);
            selectedAction = validationRow.getMetaAction(selectedActionText = validationRow.getAction());
            if (!selectedAction.equals("MOVE")) continue;
            this.needErrorTable = true;
        }
        for (i = 0; i < lInvalidValues.size(); ++i) {
            validationRow = (DataValidationRecord)lInvalidValues.get(i);
            selectedAction = validationRow.getMetaAction(selectedActionText = validationRow.getAction());
            if (!selectedAction.equals("MOVE")) continue;
            this.needErrorTable = true;
        }
        for (i = 0; i < lCustom.size(); ++i) {
            DataValidationRecord customDVRecord_i = (DataValidationRecord)lCustom.get(i);
            String sActionText = customDVRecord_i.getPropertyTrue_PS1_DefVal();
            String sSelectedAction1 = customDVRecord_i.getMetaAction(sActionText);
            sActionText = customDVRecord_i.getPropertyFalse_PS1_DefVal();
            String sSelectedAction2 = customDVRecord_i.getMetaAction(sActionText);
            if (!sSelectedAction1.equals("MOVE") && !sSelectedAction2.equals("MOVE")) continue;
            this.needErrorTable = true;
        }
        for (i = 0; i < lDuplicateValues.size(); ++i) {
            validationRow = (DataValidationRecord)lDuplicateValues.get(i);
            selectedAction = validationRow.getMetaAction(selectedActionText = validationRow.getAction());
            if (!selectedAction.equals("MOVE") && !selectedAction.equals("MOVEALL")) continue;
            this.needErrorTable = true;
        }
        return this.needErrorTable;
    }

    static {
        m_validationSelected = true;
        m_sSetColumn = RB.getStringResource("DataValidationCodegen.SetColumn.txt");
        m_sTranslation = RB.getStringResource("DataValidationCodegen.Translation.txt");
        m_sSetValueTo = RB.getStringResource("DataValidationCodegen.SetValueTo.txt");
        m_sCustomValidation = RB.getStringResource("DataValidationCodegen.CustomValidation.txt");
        m_sDuplicateValue = RB.getStringResource("DataValidationCodegen.DuplicateValue.txt");
    }
}

