/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.conditional.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.AbstractTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.conditional.impl.ConditionalStartTransformModel;
import com.sas.etl.models.job.transforms.conditional.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;

public class ConditionalEndTransformModel
extends AbstractTransform {
    public static final String TRANSFORMATION_ROLE = "CONDITIONALEND";
    public static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.control.ConditionalEnd";
    private static final String ARM_DISPLAY_NAME = "ConditionalEnd";

    public ConditionalEndTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    public String getDefaultName() {
        return RB.getStringResource("ConditionalEndTransformModel.Name.txt");
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("ConditionalEndTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    protected ConditionalStartTransformModel getConditionStart() {
        IJob job = this.getJob();
        if (job != null) {
            List<ITransform> transforms = Arrays.asList(job.getControlOrderedTransformsAndOthers());
            int index = transforms.indexOf(this);
            int loopsCnt = 0;
            for (int i = index - 1; i < transforms.size(); --i) {
                ITransform trans = transforms.get(i);
                if (trans instanceof ConditionalEndTransformModel) {
                    ++loopsCnt;
                }
                if (!(trans instanceof ConditionalStartTransformModel)) continue;
                if (loopsCnt > 0) {
                    --loopsCnt;
                    continue;
                }
                return (ConditionalStartTransformModel)trans;
            }
        }
        return null;
    }

    @Override
    public ICodeSegment getRuntimeStatistics(ICodeSegment codeSegment) throws CodegenException {
        codeSegment.addCommentLine(RB.getStringResource("ConditionalEndTransformModel.RunTimeStatistics.Comment.txt"));
        codeSegment.addSourceCode("%etls_setPerfInit;\n");
        codeSegment.addSourceCode("%perfstrt(txnname=%BQUOTE(_DISARM|");
        codeSegment.addSourceCode("&transformID|&syshostname|SUMM");
        codeSegment.addSourceCode(")");
        if (codeSegment.isRunTableStatisticsEnabled()) {
            codeSegment.addSourceCode(", metrNam6=_DISROWCNT, metrDef6=Count32");
        }
        codeSegment.addSourceCode(")   ;\n\n");
        return codeSegment;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validateCode) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment, validateCode);
        return codeSegment;
    }

    @Override
    public final ICodeSegment getCompleteCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return codeSegment;
    }
}

