/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.common.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.BaseObject;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseSortColumn
extends BaseObject
implements ISortColumn {
    private IColumn m_column;
    private String m_sDirection = "ascending";

    public BaseSortColumn(String sID, IModel model) {
        super(sID, model);
    }

    public BaseSortColumn(String sID, IModel model, IColumn column) {
        this(sID, model);
        this.m_column = column;
    }

    @Override
    public void setColumn(IColumn column) {
        if (this.m_column == column) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetColumnUndoable(this.m_column, column));
        }
        this.m_column = column;
        this.fireModelChangedEvent("SortingColumn:ColumnChanged", null);
    }

    @Override
    public IColumn getColumn() {
        return this.m_column;
    }

    @Override
    public boolean containsColumn(IColumn column) {
        return this.m_column == column;
    }

    @Override
    public void setDirection(String sDirection) {
        if (this.m_sDirection.equals(sDirection)) {
            return;
        }
        if (!sDirection.equalsIgnoreCase("ascending") && !sDirection.equalsIgnoreCase("descending")) {
            ModelLogger.getDefaultLogger().warn((Object)("Attempt to set invalid sort order so ignoring for column Name: " + this.getName() + " sDirection specified: " + sDirection));
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDirectionUndoable(this.m_sDirection, sDirection));
        }
        this.m_sDirection = sDirection;
        this.fireModelChangedEvent("SortingColumn:DirectionChanged", null);
    }

    @Override
    public String getDirection() {
        return this.m_sDirection;
    }

    @Override
    public void dispose() {
        this.m_column = null;
    }

    private class SetColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;

        public SetColumnUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
        }

        @Override
        public void undo() {
            super.undo();
            BaseSortColumn.this.setColumn(this.m_oldColumn);
        }

        @Override
        public void redo() {
            super.redo();
            BaseSortColumn.this.setColumn(this.m_newColumn);
        }
    }

    private class SetDirectionUndoable
    extends AbstractUndoableEdit {
        private String m_oldDirection;
        private String m_newDirection;

        public SetDirectionUndoable(String oldDirection, String newDirection) {
            this.m_oldDirection = oldDirection;
            this.m_newDirection = newDirection;
        }

        @Override
        public void undo() {
            super.undo();
            BaseSortColumn.this.setDirection(this.m_oldDirection);
        }

        @Override
        public void redo() {
            super.redo();
            BaseSortColumn.this.setDirection(this.m_newDirection);
        }
    }
}

