/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.common.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.common.IExtendedAttributesPropertySet;
import com.sas.etl.models.other.IExtendedAttribute;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertySet;
import java.rmi.RemoteException;
import java.util.List;

public class BaseExtendedAttributePropertySet
extends AbstractPersistableObject
implements IExtendedAttributesPropertySet {
    private ModelList m_lExtendedAttributes = new ModelList(this, new String[]{"Object:ExtendedAttributeAdded", "Object:ExtendedAttributeRemoved"}, 3, IExtendedAttribute.class);
    private String m_setRole;
    private String m_propertySetName;

    public BaseExtendedAttributePropertySet(String sId, IModel model) {
        super(sId, model);
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_lExtendedAttributes.isChanged();
    }

    @Override
    public String getOMRType() {
        return "PropertySet";
    }

    @Override
    public void setSetRole(String role) {
        this.m_setRole = role;
    }

    @Override
    public String getSetRole() {
        return this.m_setRole;
    }

    @Override
    public void setPropertySetName(String name) {
        this.m_propertySetName = name;
    }

    @Override
    public String getPropertySetName() {
        return this.m_propertySetName;
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        this.m_lExtendedAttributes.deleteFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        PropertySet set = (PropertySet)omr.acquireOMRObject(this);
        this.setPropertySetName(set.getPropertySetName());
        this.setSetRole(set.getSetRole());
        this.m_lExtendedAttributes.loadFromOMR(omr, (List)set.getExtensions());
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.saveToOMR(omr);
        PropertySet set = (PropertySet)omr.acquireOMRObject(this);
        set.setSetRole(this.getSetRole());
        set.setPropertySetName(this.getPropertySetName());
        this.m_lExtendedAttributes.saveToOMR(omr, (List)set.getExtensions(false));
    }

    @Override
    public IExtendedAttribute[] getExtendedAttributes() {
        return (IExtendedAttribute[])this.m_lExtendedAttributes.toArray(new IExtendedAttribute[this.m_lExtendedAttributes.size()]);
    }

    @Override
    public List getExtendedAttributesList() {
        return this.m_lExtendedAttributes;
    }
}

