/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.ORACLEType;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ILoaderTransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractBulkTableLoaderTransform;
import com.sas.etl.models.job.impl.BaseLoaderModelListener;
import com.sas.etl.models.job.impl.BaseLoaderPromptModel;
import com.sas.etl.models.job.impl.BaseLoaderTransformValueChangedListener;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class OracleBulkTableLoaderTransformModel
extends AbstractBulkTableLoaderTransform {
    public static final String UPDATETARGETMETADATA_CHANGED = "OracleBulkTableLoaderTransformModel:UpdateTargetMetadataChanged";
    public static final String RECREATEINDEXES_CHANGED = "OracleBulkTableLoaderTransformModel:RecreateIndexesChanged";
    public static final String DISABLECONSTRAINTS_CHANGED = "OracleBulkTableLoaderTransformModel:DisableConstraintsChanged";
    public static final String GATHERTABLESTATISTICS_CHANGED = "OracleBulkTableLoaderTransformModel:GatherTableStatisticsChanged";
    public static final String LOADMETHOD_CHANGED = "OracleBulkTableLoaderTransformModel:LoadMethodChanged";
    public static final String RECORD_PERCENT_CHANGED = "OracleBulkTableLoaderTransformModel:RecordPercentChanged";
    public static final String RECREATE_INDEXES_ALWAYS_CHANGED = "OracleBulkTableLoaderTransformModel:RecreateIndexesAlwaysChanged";
    protected static final String PROPERTY_NAME_UPDATE_TARGET_METADATA = "UpdateTargetMetadata";
    protected static final String PROPERTY_NAME_RECREATE_INDEXES = "RecreateIndexes";
    protected static final String PROPERTY_NAME_DISABLE_CONSTRAINTS = "DisableConstraints";
    protected static final String PROPERTY_NAME_GATHER_TABLE_STATISTICS = "GatherTableStatistics";
    protected static final String PROPERTY_NAME_LOAD_METHOD = "BL_LOAD_METHOD";
    protected static final String PROPERTY_NAME_RECORD_PERCENT = "RecordsPercent";
    protected static final String PROPERTY_NAME_RECREATE_INDEXES_ALWAYS = "RecreateIndexesAlways";
    public static final String SUPPORT_RESTART_CHANGED = "OracleBulkTableLoaderModel:SupportRestartChanged";
    public static final String CHECKPOINT_ENABLED_CHANGED = "ITransform:CheckpointEnabledChanged";
    public static final String DATA_TABLE_OPTIONS_CHANGED = "OracleBulkTableLoaderModel:DataTableOptionsChanged";
    private static final String ARM_DISPLAY_NAME = "Oracle Bulk Table Loader";
    private static final String TRANSFORMATION_CLASS = "OracleBulkTableLoader";
    private static final String TRANSFORMATION_ROLE = "OracleBulkTableLoader";
    private static final String VALUE_BULK_LOAD = "Bulkload";
    private static final String OPTION_NAME_BULKLOAD = "BULKLOAD";
    private static final String OPTION_NAME_ERRLIMIT = "ERRLIMIT";
    private static final String DATATABLE_OPTIONS = "DataTableOptions";
    public static final String LOADMETHOD_INSERT = "Insert";
    public static final String LOADMETHOD_APPEND = "Append";
    public static final String LOADMETHOD_REPLACE = "Replace";
    public static final String LOADMETHOD_TRUNCATE = "Truncate";
    private static final String sDisableCstx = "etls_disableCstx";
    private static final String sEnableCstx = "etls_enableCstx";
    private static final String sCreateIdx = "etls_createIdx";
    private static final String sDropIdx = "etls_dropIdx";
    private static final String sDrop = "etls_drop";
    private static final String sCreate = "etls_create";
    private static final String sDisable = "etls_disCstx";
    private static final String sEnable = "etls_enCstx";
    private boolean m_bIsDisableConstraintsChecked;
    private boolean m_bIsRecreateIndexesChecked;
    private boolean m_bIsGatherTableStatisticsChecked;
    private boolean m_bIsRecreateIndexesAlways;
    private String m_strLoadMethod;
    private int m_iRecordPercent;
    private boolean m_bDefaultIsDisableConstraintsChecked = false;
    private boolean m_bDefaultIsRecreateIndexesChecked = false;
    private boolean m_bDefaultIsGatherTableStatisticsChecked = false;
    private boolean m_bDefaultIsRecreateIndexesAlways = false;
    private boolean m_bUpdateTargetMetadata;
    private String m_strDefaultLoadMethod = "Insert";
    private String m_sDataTableOptions;

    public OracleBulkTableLoaderTransformModel(String sID, IModel model) {
        super(sID, model);
        this.setRecordPercent(40);
        this.setUpdateTargetMetadata(false);
        this.createConditionActionSetTemplates();
        super.setCollectSourceTableRowCounts(false);
        super.setCollectTargetTableRowCounts(true);
    }

    protected void fireOracleDatabaseProcessingIcon() {
        this.setDBMSExecutionTypeName("Oracle");
        this.setDBMSExecutionType(107);
        this.fireModelChangedEvent("ITransform:ExplicitOnChanged", null);
    }

    private boolean getDefaultDisableConstraints() {
        return this.m_bDefaultIsDisableConstraintsChecked;
    }

    private boolean getDefaultRecreateIndexes() {
        return this.m_bDefaultIsRecreateIndexesChecked;
    }

    private boolean getDefaultGatherTableStatistics() {
        return this.m_bDefaultIsGatherTableStatisticsChecked;
    }

    private String getDefaultLoadMethod() {
        return this.m_strDefaultLoadMethod;
    }

    @Override
    public void resetModelDefaults() {
        this.startCompoundUndoable();
        try {
            this.setLoadMethod(this.getDefaultLoadMethod());
            this.setGatherTableStatisticsChecked(this.getDefaultGatherTableStatistics());
            this.setRecreateIndexesChecked(this.getDefaultRecreateIndexes());
            this.setDisableConstraintsChecked(this.getDefaultDisableConstraints());
        }
        finally {
            this.endCompoundUndoable();
        }
        this.saveDBMSTypeForChangeCheck();
        this.updateLoadUtilities();
    }

    public void setUpdateTargetMetadata(boolean bValue) {
        if (bValue == this.m_bUpdateTargetMetadata) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUpdateTargetMetadataUndoable(this.m_bUpdateTargetMetadata, bValue));
        }
        this.m_bUpdateTargetMetadata = bValue;
        this.fireModelChangedEvent(UPDATETARGETMETADATA_CHANGED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            super.replaceTargetTable(oldTable, newTable, columnsMap, portIndexes);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public List getValidValuesIndexBefore() {
        return new ArrayList();
    }

    protected void updateLoadUtilities() {
        ITransformTableOptions targetOptions;
        IPhysicalTable target = this.getTargetTable();
        if (target != null && target.getDBMSType() instanceof ORACLEType && (targetOptions = this.getTableOptionObject(target, false)) != null) {
            IPromptDefinitionValue bulkOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_BULKLOAD);
            try {
                bulkOption.setFixed(false);
                bulkOption.setValue("YES");
                IPromptDefinitionValue errLimitOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_ERRLIMIT);
                if (errLimitOption != null) {
                    errLimitOption.setCodeGenerationEnabled(true);
                }
                bulkOption.setFixed(true);
                IPromptDefinitionValue loadMethodOption = targetOptions.getOptionModel().findDefinition(PROPERTY_NAME_LOAD_METHOD);
                if (loadMethodOption != null) {
                    loadMethodOption.setFixed(true);
                }
            }
            catch (RemoteException e) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
            }
            catch (ServiceException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
            }
            catch (ServerConnectionException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
            }
            catch (MdException e) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
            }
        }
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        boolean isMappingNeeded;
        super.getGeneratedCode(codeSegment, validate);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        this.genBeginningMacros(codeSegment);
        String dsOptions = this.getSourceTableOptions(codeSegment, source);
        IColumn loadTimeColumn = this.getAndGenerateSetOfLoadTimeColumn(codeSegment, dsOptions);
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.genJobStatusUpdateBefore(target);
        }
        String sMappingStepOutputName = this.genMappingStepCode(codeSegment, dsOptions, loadTimeColumn);
        codeSegment.addCommentLine(RB.getStringResource("TableLoaderTransformModel.Exist.msg.notrans"));
        codeSegment.genTableExist(target.getFullNameQuotedAsNeeded(codeSegment), "etls_tableExist");
        boolean createConstraints = false;
        boolean createIndexes = false;
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.indent();
        if (target.isCaseSensitive()) {
            codeSegment.addSourceCode("table_name = ");
            codeSegment.addSourceCode(target.getTableName(true, true));
            codeSegment.addSourceCode(";\n");
        } else {
            codeSegment.addSourceCode("table_name = \"");
            codeSegment.addSourceCode(target.getTableName(true, true));
            codeSegment.addSourceCode("\";\n");
        }
        codeSegment.addSourceCode("call symput('etls_tabnm',table_name);\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        codeSegment.addSourceCode("%let etls_tabq=%str(%'&etls_tabnm%');\n");
        IDBMSType tableDBMSType = target.getDBMSType();
        tableDBMSType.create(codeSegment, target, true, createConstraints, createIndexes, true, this.getDataTableOptions(), this);
        String disableConstraintsFileName = null;
        String enableConstraintsFileName = null;
        String dropIndexesFileName = null;
        String createIndexesFileName = null;
        String recreateIndexesFileName = null;
        if (this.isDisableConstraintsChecked() || this.isRecreateIndexesChecked()) {
            codeSegment.addSourceCode("%if (&etls_tableExist gt 0) %then\n");
            codeSegment.addSourceCode("%do;");
            codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.IfTableExist.txt"));
        }
        StringBuffer basicConnect = null;
        if (this.isDisableConstraintsChecked() || this.isRecreateIndexesChecked() || this.isGatherTableStatisticsChecked()) {
            basicConnect = tableDBMSType.getConnectUnformatted(codeSegment, target);
        }
        String baseFileName = null;
        if (this.isDisableConstraintsChecked() || this.isRecreateIndexesChecked()) {
            boolean assignWorkLibrary;
            boolean bl = assignWorkLibrary = this.isCollectingDiagnostics() || this.isRecreateIndexesAlways();
            if (assignWorkLibrary) {
                baseFileName = "etls_" + codeSegment.formatObjectIDForMacroVar(this.getJob());
                codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.WorkLocation.txt"));
                codeSegment.addSourceCode("data _null_;\n");
                codeSegment.indent();
                codeSegment.addSourceCode("etls_wloc = getOption('WORK');\n");
                codeSegment.addSourceCode("call symput('etls_wloc',trim(etls_wloc));\n");
                codeSegment.unIndent();
                codeSegment.addSourceCode("run;\n\n");
            }
        }
        if (this.isDisableConstraintsChecked() && this.isCollectingDiagnostics()) {
            disableConstraintsFileName = "&etls_wloc/" + baseFileName + "%bquote(&etls_tabnm)_dis.sas";
            enableConstraintsFileName = "&etls_wloc/" + baseFileName + "%bquote(&etls_tabnm)_en.sas";
        }
        if (this.isRecreateIndexesChecked() && this.isCollectingDiagnostics()) {
            dropIndexesFileName = "&etls_wloc/" + baseFileName + "%bquote(&etls_tabnm)_drop.sas";
            createIndexesFileName = "&etls_wloc/" + baseFileName + "%bquote(&etls_tabnm)_create.sas";
        }
        if (this.isRecreateIndexesChecked()) {
            recreateIndexesFileName = "&etls_wloc/" + baseFileName + "%bquote(&etls_tabnm)_recreate.sas";
        }
        if (this.isDisableConstraintsChecked()) {
            this.prepareConstraintsCode(codeSegment, target, basicConnect, disableConstraintsFileName, enableConstraintsFileName);
        }
        if (this.isRecreateIndexesChecked()) {
            if (this.isCollectingDiagnostics()) {
                codeSegment.addSourceCode("%let etls_create_Indexes=");
                codeSegment.addSourceCode(createIndexesFileName);
                codeSegment.addSourceCode(";\n");
            }
            if (this.isRecreateIndexesAlways()) {
                codeSegment.addSourceCode("%let etls_recreate_Indexes=");
                codeSegment.addSourceCode(recreateIndexesFileName);
                codeSegment.addSourceCode(";\n");
            }
            this.prepareIndexesCode(codeSegment, target, basicConnect, dropIndexesFileName, createIndexesFileName);
        }
        if (this.isDisableConstraintsChecked() || this.isRecreateIndexesChecked()) {
            codeSegment.unIndent();
            codeSegment.addSourceCode("%end;");
            codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.IfTableExist.txt"));
        }
        this.genLoadMethodCode(codeSegment, validate);
        if (this.isDisableConstraintsChecked() || this.isRecreateIndexesChecked()) {
            codeSegment.addSourceCode("%if (&etls_tableExist gt 0) %then\n");
            codeSegment.addSourceCode("%do;");
            codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.IfTableExist.txt"));
            codeSegment.indent();
        }
        if (this.isDisableConstraintsChecked()) {
            this.generateEnableConstraints(codeSegment, basicConnect.toString());
        }
        if (this.isRecreateIndexesChecked()) {
            this.generateRecreateIndexes(codeSegment, basicConnect.toString(), recreateIndexesFileName);
        }
        if (this.isDisableConstraintsChecked() || this.isRecreateIndexesChecked()) {
            codeSegment.unIndent();
            codeSegment.addSourceCode("%end;");
            codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.IfTableExist.txt"));
        }
        if (this.isGatherTableStatisticsChecked()) {
            this.generateGatherTableStatistics(codeSegment, basicConnect, target);
        }
        tableDBMSType.createIndexAndConstraintsConditionally(codeSegment, target);
        if (this.isUpdateTargetMetadata()) {
            codeSegment.addSourceCode("\n");
            codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.UpdateTargetMetadata.txt"));
            codeSegment.addSourceCode(target.getUpdateTableMetadataCode());
            codeSegment.addSourceCode("\n");
        }
        if ((isMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, target)) && !target.isView()) {
            codeSegment.genTableDelete(sMappingStepOutputName);
        }
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.genJobStatusUpdateAfter(target);
        }
        this.genMacroEnd(codeSegment);
        if (!validate) {
            this.genCodeConditionChecks(codeSegment);
        }
        return codeSegment;
    }

    @Override
    protected ICodeSegment genBeginningMacros(ICodeSegment codeSegment) {
        super.genBeginningMacros(codeSegment);
        codeSegment.addSourceCode("%global etls_oraconstx;\n");
        codeSegment.addSourceCode("%global etls_oraindx;\n");
        codeSegment.addSourceCode("%global etls_sql_pushDown;\n");
        codeSegment.addSourceCode("%global etls_enableConstx;\n");
        codeSegment.addSourceCode("%global etls_create_Indexes;\n");
        codeSegment.addSourceCode("%global etls_tabnm;\n");
        codeSegment.addSourceCode("%global etls_tabq;\n");
        codeSegment.addSourceCode("%let  etls_create_Indexes = \"\";\n");
        codeSegment.addSourceCode("%let  etls_oraindx = -1;\n");
        codeSegment.addSourceCode("%let  etls_oraconstx = -1;\n");
        return codeSegment;
    }

    private ICodeSegment genDeleteFile(ICodeSegment codeSegment, String fileName) {
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("filename etls_alt \"");
        codeSegment.addSourceCode(fileName);
        codeSegment.addSourceCode("\";\n");
        codeSegment.addSourceCode("rc=%sysfunc(fdelete(etls_alt));\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        return codeSegment;
    }

    private ICodeSegment prepareConstraintsCode(ICodeSegment codeSegment, IPhysicalTable target, StringBuffer basicConnect, String disableConstraintsFileName, String enableConstraintsFileName) throws BadLibraryDefinitionException {
        String schemaName = null;
        IDatabaseSchema schema = target.getDatabaseSchema();
        if (schema != null) {
            schemaName = schema.getSchemaName();
        }
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.DisableConstraintsSelected.txt"));
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.DDLDisableConstraints.txt"));
        codeSegment.addSourceCode("proc sql noprint;\n");
        codeSegment.indent();
        codeSegment.addSourceCode(basicConnect);
        codeSegment.indent();
        codeSegment.addSourceCode("\ncreate table work.");
        codeSegment.addSourceCode(sDisableCstx);
        codeSegment.addSourceCode("\nas\n");
        codeSegment.addSourceCode("SELECT 'Execute ( ALTER TABLE ' || '\"");
        codeSegment.addSourceCode(schemaName);
        codeSegment.addSourceCode("\".\"' || \"&etls_tabnm\" || '\" DISABLE CONSTRAINT ' ");
        codeSegment.addSourceCode(" || trim(constraint_name) || ') by Oracle;' as disable_stmt   \n");
        codeSegment.addSourceCode("from connection to Oracle\n");
        codeSegment.addSourceCode("(\n");
        codeSegment.addSourceCode("select constraint_name from user_constraints where table_name = &etls_tabq\n");
        codeSegment.addSourceCode(");\n");
        codeSegment.unIndent().unIndent();
        codeSegment.addSourceCode("disconnect from Oracle;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("quit;\n\n");
        codeSegment.addSourceCode("proc sql noprint;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("select count(*) into :etls_oraconstx from etls_disableCstx;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("quit;\n");
        codeSegment.addSourceCode("%if &etls_oraconstx gt 0 %then %do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("proc sql noprint;\n");
        codeSegment.indent();
        codeSegment.addSourceCode(basicConnect);
        codeSegment.indent();
        codeSegment.addSourceCode("\ncreate table work.");
        codeSegment.addSourceCode(sEnableCstx);
        codeSegment.addSourceCode("\nas\n");
        codeSegment.addSourceCode("SELECT 'Execute ( ALTER TABLE ' || '\"");
        codeSegment.addSourceCode(schemaName);
        codeSegment.addSourceCode("\".\"' || \"&etls_tabnm\" || '\" ENABLE CONSTRAINT ' ");
        codeSegment.addSourceCode(" || trim(constraint_name) || ') by Oracle;' as enable_stmt   \n");
        codeSegment.addSourceCode("from connection to Oracle\n");
        codeSegment.addSourceCode("(\n");
        codeSegment.addSourceCode("select constraint_name from user_constraints where table_name = &etls_tabq\n");
        codeSegment.addSourceCode(");\n");
        codeSegment.unIndent().unIndent();
        codeSegment.addSourceCode("disconnect from Oracle;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("quit;\n\n");
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("set work.");
        codeSegment.addSourceCode(sDisableCstx);
        codeSegment.addSourceCode(" end=done;\n");
        codeSegment.addSourceCode("if _n_ = 1 then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("call execute ('proc sql;');\n");
        codeSegment.addSourceCode("call execute ('");
        codeSegment.addSourceCode(basicConnect);
        codeSegment.addSourceCode("');\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("call execute (disable_stmt);\n");
        codeSegment.addSourceCode("if done then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("call execute ('disconnect from oracle;');\n");
        codeSegment.addSourceCode("call execute ('quit;');\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        if (this.isCollectingDiagnostics()) {
            this.generateDiagnosticsConstraints(codeSegment, basicConnect.toString(), disableConstraintsFileName, enableConstraintsFileName);
        }
        codeSegment.genTableDelete(sDisableCstx);
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;");
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.DisableConstraintsSelected.txt"));
        return codeSegment;
    }

    private ICodeSegment generateEnableConstraints(ICodeSegment codeSegment, String basicConnect) {
        codeSegment.addSourceCode("%if &etls_oraconstx gt 0 %then %do;\n");
        codeSegment.indent();
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.EnableConstraintsAfter.txt"));
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("set work.");
        codeSegment.addSourceCode(sEnableCstx);
        codeSegment.addSourceCode(" end=done;\n");
        codeSegment.addSourceCode("if _n_ = 1 then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("call execute ('proc sql;');\n");
        codeSegment.addSourceCode("call execute ('");
        codeSegment.addSourceCode(basicConnect);
        codeSegment.addSourceCode("');\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("call execute (enable_stmt);\n");
        codeSegment.addSourceCode("if done then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("call execute ('disconnect from oracle;');\n");
        codeSegment.addSourceCode("call execute ('quit;');\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("\nrun;\n\n");
        codeSegment.addSourceCode("%rcSet(&syserr);\n");
        codeSegment.genTableDelete(sEnableCstx);
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;\n");
        return codeSegment;
    }

    private ICodeSegment prepareIndexesCode(ICodeSegment codeSegment, IPhysicalTable target, StringBuffer basicConnect, String dropIndexesFileName, String createIndexesFileName) {
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.RecreateIndexes.txt"));
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.DDLCreateIndexes.txt"));
        codeSegment.addSourceCode("proc sql noprint;\n");
        codeSegment.indent();
        codeSegment.addSourceCode(basicConnect);
        codeSegment.indent();
        codeSegment.addSourceCode("\ncreate table ");
        codeSegment.addSourceCode("work.");
        codeSegment.addSourceCode(sCreateIdx);
        codeSegment.addSourceCode("\nas\n");
        codeSegment.indent();
        codeSegment.addSourceCode("select * from connection to Oracle \n");
        codeSegment.addSourceCode("(SELECT 'Execute ( ' || DBMS_METADATA.GET_DDL('INDEX',index_name) ||') by Oracle;' \n");
        codeSegment.addSourceCode(" as create_idx FROM USER_INDEXES where table_name = &etls_tabq");
        codeSegment.addSourceCode(") ;\n");
        codeSegment.unIndent().unIndent();
        codeSegment.addSourceCode("disconnect from Oracle;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("quit;\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("proc sql noprint;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("select count(*) into :etls_oraindx from ");
        codeSegment.addSourceCode("work.");
        codeSegment.addSourceCode(sCreateIdx);
        codeSegment.addSourceCode(";\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("quit;\n");
        codeSegment.addSourceCode("%if &etls_oraindx gt 0 %then %do;\n");
        codeSegment.indent();
        codeSegment.addCommentLine("DDL to drop Indexes..\n\n");
        codeSegment.addSourceCode("proc sql noprint;\n");
        codeSegment.indent();
        codeSegment.addSourceCode(basicConnect);
        codeSegment.indent();
        codeSegment.addSourceCode("\ncreate table work.");
        codeSegment.addSourceCode(sDropIdx);
        codeSegment.addSourceCode("\nas\n");
        codeSegment.indent();
        codeSegment.addSourceCode("select * from connection to Oracle \n");
        if (target.isCaseSensitive()) {
            codeSegment.addSourceCode("(select 'Execute ( DROP INDEX \"' || index_name ||'\") by Oracle;' \n");
        } else {
            codeSegment.addSourceCode("(select 'Execute ( DROP INDEX ' || index_name ||') by Oracle;' \n");
        }
        codeSegment.addSourceCode(" as drop_idx from user_indexes where table_name = &etls_tabq");
        codeSegment.addSourceCode(" );\n");
        codeSegment.unIndent().unIndent();
        codeSegment.addSourceCode("disconnect from Oracle;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("quit;\n");
        if (this.isCollectingDiagnostics()) {
            this.generateDiagnosticsIndexes(codeSegment, basicConnect.toString(), dropIndexesFileName, createIndexesFileName);
        }
        if (this.isRecreateIndexesAlways()) {
            this.generateCreateIndexesFile(codeSegment, basicConnect.toString(), false);
        }
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("set work.");
        codeSegment.addSourceCode(sDropIdx);
        codeSegment.addSourceCode(" end=done;\n");
        codeSegment.addSourceCode("if _n_ = 1 then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("call execute ('proc sql;');\n");
        codeSegment.addSourceCode("call execute (' ");
        codeSegment.addSourceCode(basicConnect);
        codeSegment.addSourceCode("');\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("call execute (drop_idx);\n");
        codeSegment.addSourceCode("if done then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("call execute ('disconnect from oracle;');\n");
        codeSegment.addSourceCode("call execute ('quit;');\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n\n");
        codeSegment.genTableDelete(sDropIdx);
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;\n");
        codeSegment.addSourceCode("%rcSet(&syserr);\n");
        return codeSegment;
    }

    private BaseDBMSType getBaseType(IPhysicalTable table) {
        BaseDBMSType baseType = new BaseDBMSType();
        return baseType;
    }

    private ICodeSegment generateRecreateIndexes(ICodeSegment codeSegment, String basicConnect, String recreateIndexesFileName) {
        codeSegment.addSourceCode("%if &etls_oraindx gt 0 %then \n%do;\n");
        codeSegment.indent();
        if (this.isRecreateIndexesAlways()) {
            codeSegment.addSourceCode("%if &syserr ne 0 %then %do;\n");
            codeSegment.indent();
            codeSegment.addSourceCode("%include \"&etls_recreate_Indexes\";\n");
            codeSegment.unIndent();
            codeSegment.addSourceCode("%end;\n");
            codeSegment.addSourceCode("%else %do;\n");
            codeSegment.indent();
        }
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.CreateIndexesAfter.txt"));
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("set ");
        codeSegment.addSourceCode("work.");
        codeSegment.addSourceCode(sCreateIdx);
        codeSegment.addSourceCode(" end=done;\n");
        codeSegment.addSourceCode("if _n_ = 1 then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("call execute (' proc sql;');\n");
        codeSegment.addSourceCode("call execute (' ");
        codeSegment.addSourceCode(basicConnect);
        codeSegment.addSourceCode("');\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("call execute (create_idx);\n");
        codeSegment.addSourceCode("if done then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("call execute ('disconnect from oracle;');\n");
        codeSegment.addSourceCode("call execute ('quit;');\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        codeSegment.addSourceCode("%rcSet(&syserr);\n");
        codeSegment.genTableDelete(sCreateIdx);
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;\n");
        if (this.isRecreateIndexesAlways()) {
            codeSegment.unIndent();
            codeSegment.addSourceCode("%end;\n");
            this.genDeleteFile(codeSegment, recreateIndexesFileName);
        }
        return codeSegment;
    }

    private ICodeSegment generateGatherTableStatistics(ICodeSegment codeSegment, StringBuffer basicConnect, IPhysicalTable table) throws BadLibraryDefinitionException {
        if (table.isCaseSensitive()) {
            codeSegment.addSourceCode("%let etls_tabq=%str(%'\"&etls_tabnm\"%');\n");
        }
        IDatabaseSchema schema = table.getDatabaseSchema();
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.GatherTableStatistics.txt"));
        codeSegment.addSourceCode("proc sql;\n");
        codeSegment.indent();
        codeSegment.addSourceCode(basicConnect);
        codeSegment.indent();
        codeSegment.addSourceCode("\nexecute ( execute \n");
        codeSegment.indent();
        codeSegment.addSourceCode("DBMS_STATS.GATHER_TABLE_STATS (\n");
        codeSegment.addSourceCode("ownname => '");
        codeSegment.addSourceCode(schema.getSchemaName());
        codeSegment.addSourceCode("',\n");
        if (table.isCaseSensitive()) {
            codeSegment.addSourceCode("tabname => &etls_tabq,\n");
        } else {
            codeSegment.addSourceCode("tabname => &etls_tabq,\n");
        }
        codeSegment.addSourceCode("estimate_percent => ");
        String percent = String.valueOf(this.getRecordPercent());
        codeSegment.addSourceCode(percent);
        codeSegment.addSourceCode(") ) by oracle;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("disconnect from oracle;\n");
        codeSegment.unIndent();
        codeSegment.unIndent();
        codeSegment.addSourceCode("quit;\n\n");
        codeSegment.addSourceCode("%rcSet(&syserr);\n");
        return codeSegment;
    }

    private ICodeSegment generateDiagnosticsIndexes(ICodeSegment codeSegment, String basicConnect, String dropIndexesFileName, String createIndexesFileName) {
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.IndexesDDL.txt"));
        codeSegment.addSourceCode("%let etls_dropIndexes=");
        codeSegment.addSourceCode(dropIndexesFileName);
        codeSegment.addSourceCode(";\n");
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.addSourceCode("FILE \"&etls_dropIndexes\" lrecl=80;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("set work.");
        codeSegment.addSourceCode(sDropIdx);
        codeSegment.addSourceCode(" end=done;\n");
        codeSegment.addSourceCode("if _n_ = 1 then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("put 'proc sql;';\n");
        codeSegment.addSourceCode("put ' ");
        codeSegment.addSourceCode(basicConnect);
        codeSegment.addSourceCode("';\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("put drop_idx;\n");
        codeSegment.addSourceCode("if done then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("put 'disconnect from oracle;';\n");
        codeSegment.addSourceCode("put 'quit;' ;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n\n");
        codeSegment.unIndent();
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.IndexesDDL.txt"));
        codeSegment.addSourceCode("%if %sysfunc(fileexist(\"");
        codeSegment.addSourceCode(dropIndexesFileName);
        codeSegment.addSourceCode("\")) %then \n%do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("data work.");
        codeSegment.addSourceCode(sDrop);
        codeSegment.addSourceCode(";\n");
        codeSegment.indent();
        codeSegment.addSourceCode("infile \"&etls_dropIndexes\" truncover;\n");
        codeSegment.addSourceCode("input DROP_INDEXES $1024.;\n");
        codeSegment.addSourceCode("put DROP_INDEXES;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n\n");
        codeSegment.addSourceCode("Title '");
        codeSegment.addSourceCode(RB.getStringResource("OracleBulkTableLoaderTransformModel.DropIndexesTitle.txt"));
        codeSegment.addSourceCode("';\n");
        codeSegment.addSourceCode("proc print data=work.");
        codeSegment.addSourceCode(sDrop);
        codeSegment.addSourceCode(" noobs;\n");
        codeSegment.addSourceCode("quit;\n");
        this.genDeleteFile(codeSegment, dropIndexesFileName);
        codeSegment.genTableDelete(sDrop);
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;\n\n");
        this.generateCreateIndexesFile(codeSegment, basicConnect.toString(), true);
        codeSegment.addSourceCode("%if %sysfunc(fileexist(\"");
        codeSegment.addSourceCode(createIndexesFileName);
        codeSegment.addSourceCode("\")) %then \n%do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("data work.");
        codeSegment.addSourceCode(sCreate);
        codeSegment.addSourceCode(";\n");
        codeSegment.indent();
        codeSegment.addSourceCode("infile \"&etls_create_Indexes\" truncover;\n");
        codeSegment.addSourceCode("input CREATE_INDEXES $1024.;\n");
        codeSegment.addSourceCode("put CREATE_INDEXES;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        codeSegment.addSourceCode("Title '");
        codeSegment.addSourceCode(RB.getStringResource("OracleBulkTableLoaderTransformModel.CreateIndexesTitle.txt"));
        codeSegment.addSourceCode("';\n");
        codeSegment.addSourceCode("proc print data=work.");
        codeSegment.addSourceCode(sCreate);
        codeSegment.addSourceCode(" noobs;\n");
        codeSegment.addSourceCode("quit;\n");
        this.genDeleteFile(codeSegment, createIndexesFileName);
        codeSegment.genTableDelete(sCreate);
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;\n\n");
        return codeSegment;
    }

    private ICodeSegment generateCreateIndexesFile(ICodeSegment codeSegment, String basicConnect, boolean isPrintFormat) {
        codeSegment.addSourceCode("data _null_;\n");
        if (isPrintFormat) {
            codeSegment.addSourceCode("FILE \"&etls_create_Indexes\" lrecl=80;\n");
        } else {
            codeSegment.addSourceCode("FILE \"&etls_recreate_Indexes\" lrecl=1024;\n");
        }
        codeSegment.indent();
        codeSegment.addSourceCode("set ");
        codeSegment.addSourceCode("work.");
        codeSegment.addSourceCode(sCreateIdx);
        codeSegment.addSourceCode(" end=done;\n");
        codeSegment.addSourceCode("if _n_ = 1 then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("put ' proc sql;';\n");
        codeSegment.addSourceCode("put ' ");
        codeSegment.addSourceCode(basicConnect);
        codeSegment.addSourceCode("';\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("put create_idx;\n");
        codeSegment.addSourceCode("if done then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("put 'disconnect from oracle;';\n");
        codeSegment.addSourceCode("put 'quit;' ;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        return codeSegment;
    }

    private ICodeSegment generateDiagnosticsConstraints(ICodeSegment codeSegment, String basicConnect, String disableConstraintsFileName, String enableConstraintsFileName) {
        codeSegment.addCommentLine(RB.getStringResource("OracleBulkTableLoaderTransformModel.ConstraintsDDL.txt"));
        codeSegment.addSourceCode("%let etls_enableConstx=");
        codeSegment.addSourceCode(enableConstraintsFileName);
        codeSegment.addSourceCode(";\n");
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.addSourceCode("FILE \"&etls_enableConstx\" lrecl=80;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("set work.");
        codeSegment.addSourceCode(sEnableCstx);
        codeSegment.addSourceCode(" end=done;\n");
        codeSegment.addSourceCode("if _n_ = 1 then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("put 'proc sql;';\n");
        codeSegment.addSourceCode("put '");
        codeSegment.addSourceCode(basicConnect);
        codeSegment.addSourceCode("';\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("put enable_stmt;\n");
        codeSegment.addSourceCode("if done then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("put 'disconnect from oracle;';\n");
        codeSegment.addSourceCode("put 'quit;';\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("\nrun;\n\n");
        codeSegment.addSourceCode("%let etls_disableConstx=");
        codeSegment.addSourceCode(disableConstraintsFileName);
        codeSegment.addSourceCode(";\n");
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.addSourceCode("FILE \"&etls_disableConstx\" lrecl=80;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("set work.");
        codeSegment.addSourceCode(sDisableCstx);
        codeSegment.addSourceCode(" end=done;\n");
        codeSegment.addSourceCode("if _n_ = 1 then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("put 'proc sql;';\n");
        codeSegment.addSourceCode("put '");
        codeSegment.addSourceCode(basicConnect);
        codeSegment.addSourceCode("';\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("put disable_stmt;\n");
        codeSegment.addSourceCode("if done then do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("put 'disconnect from oracle;';\n");
        codeSegment.addSourceCode("put 'quit;' ;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        codeSegment.addSourceCode("%if %sysfunc(fileexist(\"");
        codeSegment.addSourceCode(enableConstraintsFileName);
        codeSegment.addSourceCode("\")) %then \n%do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("data work.");
        codeSegment.addSourceCode(sEnable);
        codeSegment.addSourceCode(";\n");
        codeSegment.indent();
        codeSegment.addSourceCode("infile \"&etls_enableConstx\" truncover;\n");
        codeSegment.addSourceCode("input ENABLE_CONSTRAINTS $256.;\n");
        codeSegment.addSourceCode("put ENABLE_CONSTRAINTS;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n\n");
        codeSegment.addSourceCode("Title '");
        codeSegment.addSourceCode(RB.getStringResource("OracleBulkTableLoaderTransformModel.EnableConstraintsTitle.txt"));
        codeSegment.addSourceCode("';\n");
        codeSegment.addSourceCode("proc print data=work.");
        codeSegment.addSourceCode(sEnable);
        codeSegment.addSourceCode(" noobs;\n");
        codeSegment.addSourceCode("quit;\n");
        this.genDeleteFile(codeSegment, enableConstraintsFileName);
        codeSegment.genTableDelete(sEnable);
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;\n");
        codeSegment.addSourceCode("%if %sysfunc(fileexist(\"");
        codeSegment.addSourceCode(disableConstraintsFileName);
        codeSegment.addSourceCode("\")) %then \n%do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("data work.");
        codeSegment.addSourceCode(sDisable);
        codeSegment.addSourceCode(";\n");
        codeSegment.indent();
        codeSegment.addSourceCode("infile \"&etls_disableConstx\" truncover;\n");
        codeSegment.addSourceCode("input DISABLE_CONSTRAINTS $256.;\n");
        codeSegment.addSourceCode("put DISABLE_CONSTRAINTS;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n\n");
        codeSegment.addSourceCode("Title '");
        codeSegment.addSourceCode(RB.getStringResource("OracleBulkTableLoaderTransformModel.DisableConstraintsTitle.txt"));
        codeSegment.addSourceCode("';\n");
        codeSegment.addSourceCode("proc print data=work.");
        codeSegment.addSourceCode(sDisable);
        codeSegment.addSourceCode(" noobs;\n");
        codeSegment.addSourceCode("quit;\n");
        this.genDeleteFile(codeSegment, disableConstraintsFileName);
        codeSegment.genTableDelete(sDisable);
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;\n");
        return codeSegment;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("OracleBulkTableLoaderTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("OracleBulkTableLoaderTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    public static String getTransformTypeID() {
        return "OracleBulkTableLoader";
    }

    @Override
    protected String getTransformClass() {
        return "OracleBulkTableLoader";
    }

    @Override
    protected String getTransformRole() {
        return "OracleBulkTableLoader";
    }

    @Override
    public boolean isValidateAvailable() {
        return this.isComplete();
    }

    @Override
    public ICodeSegment getCompleteValidateCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeSegment code = super.getCompleteValidateCode(codeSegment);
        this.fireOracleDatabaseProcessingIcon();
        return code;
    }

    @Override
    public boolean isExplicitOn() {
        return this.isComplete();
    }

    public boolean isValidAsTargetTable(IDataObject target) {
        if (target == null) {
            return false;
        }
        String type = ((IPhysicalTable)target).getDBMSType().getConnectionType();
        boolean notOtherOracle = type != "ODBC" && type != "OLEDB";
        return target instanceof IPhysicalTable && ((IPhysicalTable)target).getDBMSType() instanceof ORACLEType && notOtherOracle;
    }

    @Override
    protected void postAddDataTarget(IDataObject target) {
        super.postAddDataTarget(target);
    }

    public boolean isLoadMethodValid(String value) {
        return this.getLoadMethods().contains(value);
    }

    public String getLoadMethod() {
        if (this.m_strLoadMethod == null) {
            return this.getDefaultLoadMethod();
        }
        return this.m_strLoadMethod;
    }

    public void setLoadMethod(String sValue) {
        if (this.getLoadMethod().equals(sValue)) {
            return;
        }
        if (!this.isLoadMethodValid(sValue)) {
            throw new IllegalArgumentException("LoadMethodType value passed in not one of the allowed types");
        }
        this.startCompoundUndoable();
        try {
            this.setLoadMethodImpl(sValue);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public int getRecordPercent() {
        return this.m_iRecordPercent;
    }

    public void setRecordPercent(int pct) {
        if (this.m_iRecordPercent == pct) {
            return;
        }
        this.m_iRecordPercent = pct;
        this.fireModelChangedEvent(RECORD_PERCENT_CHANGED, null);
    }

    public String getDataTableOptions() {
        if (this.m_sDataTableOptions == null) {
            this.m_sDataTableOptions = "";
        }
        return this.m_sDataTableOptions;
    }

    public void setDataTableOptions(String newDataTableOptions) {
        if (this.getDataTableOptions().equals(newDataTableOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDataTableOptionsUndoable(this.m_sDataTableOptions, newDataTableOptions));
        }
        this.m_sDataTableOptions = newDataTableOptions;
        this.fireModelChangedEvent(DATA_TABLE_OPTIONS_CHANGED, null);
    }

    protected void setLoadMethodImpl(String sValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLoadMethodUndoable(this.m_strLoadMethod, sValue));
        }
        this.m_strLoadMethod = sValue;
        this.setLoadMethodOption(sValue);
        this.fireModelChangedEvent(LOADMETHOD_CHANGED, null);
    }

    private void setLoadMethodOption(String value) {
        IDataObject[] dobj = this.getDataTargets();
        if (dobj.length == 0) {
            return;
        }
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        ITransformTableOptions targetOptions = this.getTableOptionObject(target, false);
        try {
            if (targetOptions != null) {
                IPromptDefinitionValue loadMethodOption = targetOptions.getOptionModel().findDefinition(PROPERTY_NAME_LOAD_METHOD);
                loadMethodOption.setFixed(false);
                loadMethodOption.setValue(value);
                loadMethodOption.setFixed(true);
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
    }

    public boolean isRecreateIndexesChecked() {
        return this.m_bIsRecreateIndexesChecked;
    }

    public void setRecreateIndexesChecked(boolean bValue) {
        if (this.isRecreateIndexesChecked() == bValue) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.setRecreateIndexesImpl(bValue);
            this.setRecreateIndexesOption(bValue);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void setRecreateIndexesOption(boolean isRecreateIndexesChecked) {
        IPromptDefinitionValue prValue = null;
        try {
            prValue = this.getOptionModel().getPromptDefinitionValue(PROPERTY_NAME_RECREATE_INDEXES_ALWAYS);
            if (isRecreateIndexesChecked) {
                prValue.setFixed(false);
                prValue.setValue("NO");
            } else {
                prValue.setFixed(true);
                prValue.setValue("NO");
            }
        }
        catch (ServerConnectionException ex) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
        }
        catch (IOException ex) {
            ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)ex);
        }
        catch (MdException ex) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
        }
        catch (ServiceException ex) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
        }
        catch (SAXException ex) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)ex);
        }
    }

    protected void setRecreateIndexesImpl(boolean bValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRecreateIndexesUndoable(this.m_bIsRecreateIndexesChecked, bValue));
        }
        this.m_bIsRecreateIndexesChecked = bValue;
        this.fireModelChangedEvent(RECREATEINDEXES_CHANGED, null);
    }

    public boolean isDisableConstraintsChecked() {
        return this.m_bIsDisableConstraintsChecked;
    }

    public void setDisableConstraintsChecked(boolean bValue) {
        if (this.isDisableConstraintsChecked() == bValue) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.setDisableConstraintsImpl(bValue);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setDisableConstraintsImpl(boolean bValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDisableConstraintsUndoable(this.m_bIsDisableConstraintsChecked, bValue));
        }
        this.m_bIsDisableConstraintsChecked = bValue;
        this.fireModelChangedEvent(DISABLECONSTRAINTS_CHANGED, null);
    }

    public boolean isGatherTableStatisticsChecked() {
        return this.m_bIsGatherTableStatisticsChecked;
    }

    public boolean isUpdateTargetMetadata() {
        return this.m_bUpdateTargetMetadata;
    }

    public void setGatherTableStatisticsChecked(boolean bValue) {
        if (this.isGatherTableStatisticsChecked() == bValue) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.setGatherTableStatisticsImpl(bValue);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setGatherTableStatisticsImpl(boolean bValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGatherTableStatisticsUndoable(this.m_bIsGatherTableStatisticsChecked, bValue));
        }
        this.m_bIsGatherTableStatisticsChecked = bValue;
        this.fireModelChangedEvent(GATHERTABLESTATISTICS_CHANGED, null);
    }

    public boolean isRecreateIndexesAlways() {
        return this.m_bIsRecreateIndexesAlways;
    }

    public void setRecreateIndexesAlways(boolean bValue) {
        if (this.isRecreateIndexesAlways() == bValue) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.setRecreateIndexesAlwaysImpl(bValue);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setRecreateIndexesAlwaysImpl(boolean bValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRecreateIndexesAlwaysUndoable(this.m_bIsRecreateIndexesAlways, bValue));
        }
        this.m_bIsRecreateIndexesAlways = bValue;
        this.fireModelChangedEvent(RECREATE_INDEXES_ALWAYS_CHANGED, null);
    }

    public List getLoadMethods() {
        ArrayList<String> loadMethods = new ArrayList<String>();
        loadMethods.add(LOADMETHOD_INSERT);
        loadMethods.add(LOADMETHOD_APPEND);
        loadMethods.add(LOADMETHOD_REPLACE);
        loadMethods.add(LOADMETHOD_TRUNCATE);
        return loadMethods;
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        IPhysicalTable target = this.getTargetTable();
        if (target != null && target.getDBMSType() instanceof ORACLEType) {
            return false;
        }
        return false;
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        IPhysicalTable target = this.getTargetTable();
        if (target == null) {
            warnings.add(RB.getStringResource("OracleBulkTableLoaderTransformModel.TargetNotNull.txt"));
        }
        if (target.getDBMSType() instanceof ORACLEType) {
            return warnings;
        }
        warnings.add(RB.getStringResource("OracleBulkTableLoaderTransformModel.TargetMustBeOracle.txt"));
        return warnings;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.isValidAsTargetTable(this.getTargetTable());
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (!this.isValidAsTargetTable(this.getTargetTable())) {
            reasons.add(RB.getStringResource("OracleBulkTableLoaderTransformModel.TargetNotOracle.txt"));
        }
        return reasons;
    }

    @Override
    public boolean isCustomRestartSupported() {
        return false;
    }

    public boolean isCustomRestartEnabled() {
        return false;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setRecreateIndexesChecked(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_RECREATE_INDEXES, this.m_bDefaultIsRecreateIndexesChecked));
        this.setDisableConstraintsChecked(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_DISABLE_CONSTRAINTS, this.m_bDefaultIsDisableConstraintsChecked));
        this.setGatherTableStatisticsChecked(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_GATHER_TABLE_STATISTICS, this.m_bDefaultIsGatherTableStatisticsChecked));
        this.setRecreateIndexesAlways(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_RECREATE_INDEXES_ALWAYS, this.m_bDefaultIsRecreateIndexesAlways));
        String loadmethod = this.loadOptionFromOMR(omr, PROPERTY_NAME_LOAD_METHOD, this.m_strDefaultLoadMethod);
        this.setLoadMethod(loadmethod);
        this.setDataTableOptions(this.loadPropertyFromOMR(omr, "OPTIONS", DATATABLE_OPTIONS, "", 2));
        this.setRecordPercent(this.loadIntOptionFromOMR(omr, PROPERTY_NAME_RECORD_PERCENT, 40));
        this.setUpdateTargetMetadata(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_UPDATE_TARGET_METADATA, false));
        this.saveDBMSTypeForChangeCheck();
        this.setChanged(false);
    }

    private String setBooleanValue(boolean boolValue) {
        if (boolValue) {
            return "YES";
        }
        return "NO";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_RECREATE_INDEXES, this.isRecreateIndexesChecked());
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_DISABLE_CONSTRAINTS, this.isDisableConstraintsChecked());
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_GATHER_TABLE_STATISTICS, this.isGatherTableStatisticsChecked());
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_RECREATE_INDEXES_ALWAYS, this.isRecreateIndexesAlways());
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_LOAD_METHOD, this.getLoadMethod());
        this.saveIntOptionToOMR(omr, PROPERTY_NAME_RECORD_PERCENT, this.getRecordPercent());
        this.savePropertyToOMR(omr, "OPTIONS", DATATABLE_OPTIONS, DATATABLE_OPTIONS, DATATABLE_OPTIONS, this.getDataTableOptions(), 12, 2);
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_UPDATE_TARGET_METADATA, this.isUpdateTargetMetadata());
        this.setChanged(false);
    }

    @Override
    protected IPhysicalTable[] getValidateTables() {
        ArrayList<IPhysicalTable> tables = new ArrayList<IPhysicalTable>(Arrays.asList(super.getValidateTables()));
        tables.add(this.getTargetTable());
        return tables.toArray(new IPhysicalTable[tables.size()]);
    }

    protected void genLoadMethodCode(ICodeSegment codeSegment, boolean bValidate) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IPhysicalTable target = this.getTargetTable();
        this.loadWithAppend(codeSegment, target);
    }

    protected ICodeSegment loadWithAppend(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        StringBuffer gen_options = new StringBuffer(this.getDataTableOptions());
        gen_options.append(" ");
        gen_options.append(this.getOptionValues(this.getBulkLoadOptions()));
        this.append(codeSegment, table, false, gen_options.toString());
        if (this.getLoadMethod().equalsIgnoreCase(LOADMETHOD_TRUNCATE)) {
            table.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CTABLETRUNCATED", this, table);
        }
        table.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, table);
        return codeSegment;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cOracleLoaderOptionModel(this.getModel(), this);
    }

    @Override
    public void addTransformTableOption(ITransformTableOptions optionSet) {
        if (this.isValidAsTargetTable(optionSet.getOptionTable()) && !optionSet.isAccessTypeInput()) {
            optionSet.setShowTransformSpecificOptions();
            optionSet.setGenerateTransformSpecificOptions(false);
        }
        super.addTransformTableOption(optionSet);
        this.updateLoadUtilities();
    }

    @Override
    public ITransformTableOptions[] getTableOptionObjects() {
        ITransformTableOptions[] opts = super.getTableOptionObjects();
        for (int i = 0; i < opts.length; ++i) {
            if (!this.isValidAsTargetTable(opts[i].getOptionTable()) || opts[i].isAccessTypeInput()) continue;
            opts[i].setShowTransformSpecificOptions();
            opts[i].setGenerateTransformSpecificOptions(false);
            PhysicalTablePromptModelCollection optCollection = opts[i].getOptionModel();
            List<String> helpIds = optCollection.getHelpTopicsList();
            if (helpIds.size() <= 1) continue;
            helpIds.set(1, "table_options_orablk");
        }
        return opts;
    }

    @Override
    public List getRefreshObjects() {
        if (!this.isUpdateTargetMetadata()) {
            return null;
        }
        ArrayList<IDataObject> lObjects = new ArrayList<IDataObject>();
        IDataObject[] aTargets = this.getDataTargets();
        for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
            lObjects.add(aTargets[iTarget]);
            List lSubObjects = aTargets[iTarget].getRefreshObjects();
            if (lSubObjects == null) continue;
            lObjects.addAll(lSubObjects);
        }
        return lObjects;
    }

    protected String getOptionValues(IPromptDefinitionValue[] definitions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        StringBuffer tpt = new StringBuffer();
        if (definitions != null && definitions.length > 0) {
            try {
                tpt.append(definitions[0].getModel().getOptionsString(null, null, false, false, false, false, definitions));
            }
            catch (ServerConnectionException e) {
                throw new ServerException(e);
            }
            catch (ServiceException e) {
                throw new ServerException(e);
            }
        }
        return tpt.toString();
    }

    protected IPromptDefinitionValue[] getBulkLoadOptions() {
        return this.getLoadTypeOptions(VALUE_BULK_LOAD);
    }

    protected ITransformTableOptions getTargetOptions() {
        return this.getTargetTable() != null ? this.getTableOptionObject(this.getTargetTable(), false) : null;
    }

    protected IPromptDefinitionValue[] getLoadTypeOptions(String type) {
        PhysicalTablePromptModelCollection model;
        IPromptDefinitionValue[] options = null;
        ITransformTableOptions targetOpts = this.getTargetOptions();
        if (targetOpts != null && (model = targetOpts.getOptionModel()) != null) {
            options = model.getPromptDefinitionsWithUserInfo("LoadType", type);
        }
        return options;
    }

    protected boolean yesNoToBoolean(String YesNo) {
        return YesNo.equalsIgnoreCase("YES");
    }

    protected boolean trueFalseToBoolean(String TrueFalse) {
        return TrueFalse.equalsIgnoreCase("TRUE");
    }

    protected String booleanToYesNo(boolean bool) {
        return bool ? "YES" : "NO";
    }

    private String getAltLibrary() {
        ILibrary altLib = this.getJob().getAlternateTemporaryLibrary();
        if (altLib == null) {
            return null;
        }
        return altLib.getFirstDirectory();
    }

    private class SetUpdateTargetMetadataUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetUpdateTargetMetadataUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            OracleBulkTableLoaderTransformModel.this.setUpdateTargetMetadata(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            OracleBulkTableLoaderTransformModel.this.setUpdateTargetMetadata(this.m_newValue);
        }
    }

    private class SetDataTableOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetDataTableOptionsUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            OracleBulkTableLoaderTransformModel.this.setDataTableOptions(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            OracleBulkTableLoaderTransformModel.this.setDataTableOptions(this.m_newValue);
        }
    }

    private class SetLoadMethodUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetLoadMethodUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            OracleBulkTableLoaderTransformModel.this.setLoadMethodImpl(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            OracleBulkTableLoaderTransformModel.this.setLoadMethodImpl(this.m_newValue);
        }
    }

    private class SetRecreateIndexesUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetRecreateIndexesUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            OracleBulkTableLoaderTransformModel.this.setRecreateIndexesImpl(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            OracleBulkTableLoaderTransformModel.this.setRecreateIndexesImpl(this.m_newValue);
        }
    }

    private class SetDisableConstraintsUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetDisableConstraintsUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            OracleBulkTableLoaderTransformModel.this.setDisableConstraintsImpl(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            OracleBulkTableLoaderTransformModel.this.setDisableConstraintsImpl(this.m_newValue);
        }
    }

    private class SetGatherTableStatisticsUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetGatherTableStatisticsUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            OracleBulkTableLoaderTransformModel.this.setGatherTableStatisticsImpl(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            OracleBulkTableLoaderTransformModel.this.setGatherTableStatisticsImpl(this.m_newValue);
        }
    }

    private class SetRecreateIndexesAlwaysUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetRecreateIndexesAlwaysUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            OracleBulkTableLoaderTransformModel.this.setRecreateIndexesAlwaysImpl(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            OracleBulkTableLoaderTransformModel.this.setRecreateIndexesAlwaysImpl(this.m_newValue);
        }
    }

    protected class cOracleLoaderOptionModel
    extends BaseLoaderPromptModel
    implements IPromptModel {
        public cOracleLoaderOptionModel(IModel model, ILoaderTransform owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model, owner);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cOracleLoaderOptionModel.class.getResource("res/Options_OracleTableLoader_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected IModelListener createModelListener() {
            return new cLoaderModelListener((OracleBulkTableLoaderTransformModel)this.getOwner());
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            OracleBulkTableLoaderTransformModel tl = (OracleBulkTableLoaderTransformModel)this.getOwner();
            this.setOptionValue(OracleBulkTableLoaderTransformModel.DATATABLE_OPTIONS, (Object)tl.getDataTableOptions());
            this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_UPDATE_TARGET_METADATA, (Object)tl.booleanToYesNo(OracleBulkTableLoaderTransformModel.this.isUpdateTargetMetadata()));
            this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_LOAD_METHOD, (Object)tl.getLoadMethod());
            this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_RECREATE_INDEXES, (Object)tl.isRecreateIndexesChecked());
            this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_DISABLE_CONSTRAINTS, (Object)tl.isDisableConstraintsChecked());
            this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_GATHER_TABLE_STATISTICS, (Object)tl.isGatherTableStatisticsChecked());
            this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_RECREATE_INDEXES_ALWAYS, (Object)tl.booleanToYesNo(OracleBulkTableLoaderTransformModel.this.isRecreateIndexesAlways()));
            this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_RECORD_PERCENT, (Object)tl.getRecordPercent());
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new OracleLoaderTransformValueChangedListener((OracleBulkTableLoaderTransformModel)this.getOwner(), this);
        }

        private class cLoaderModelListener
        extends BaseLoaderModelListener {
            public cLoaderModelListener(OracleBulkTableLoaderTransformModel transform) {
                super(transform, (IPromptModel)cOracleLoaderOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(OracleBulkTableLoaderTransformModel.UPDATETARGETMETADATA_CHANGED)) {
                        cOracleLoaderOptionModel.this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_UPDATE_TARGET_METADATA, (Object)OracleBulkTableLoaderTransformModel.this.booleanToYesNo(OracleBulkTableLoaderTransformModel.this.isUpdateTargetMetadata()));
                    } else if (type.equals(OracleBulkTableLoaderTransformModel.RECORD_PERCENT_CHANGED)) {
                        cOracleLoaderOptionModel.this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_RECORD_PERCENT, (Object)String.valueOf(OracleBulkTableLoaderTransformModel.this.getRecordPercent()));
                    } else if (type.equals(OracleBulkTableLoaderTransformModel.GATHERTABLESTATISTICS_CHANGED)) {
                        cOracleLoaderOptionModel.this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_GATHER_TABLE_STATISTICS, (Object)String.valueOf(OracleBulkTableLoaderTransformModel.this.isGatherTableStatisticsChecked()));
                    } else if (type.equals(OracleBulkTableLoaderTransformModel.RECREATE_INDEXES_ALWAYS_CHANGED)) {
                        cOracleLoaderOptionModel.this.setOptionValue(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_RECREATE_INDEXES_ALWAYS, (Object)OracleBulkTableLoaderTransformModel.this.booleanToYesNo(OracleBulkTableLoaderTransformModel.this.isRecreateIndexesAlways()));
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class OracleLoaderTransformValueChangedListener
        extends BaseLoaderTransformValueChangedListener {
            public OracleLoaderTransformValueChangedListener(OracleBulkTableLoaderTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_UPDATE_TARGET_METADATA)) {
                        ((OracleBulkTableLoaderTransformModel)this.getOwner()).setUpdateTargetMetadata(OracleBulkTableLoaderTransformModel.this.yesNoToBoolean(value.toString()));
                    } else if (optionName.equals(OracleBulkTableLoaderTransformModel.DATATABLE_OPTIONS)) {
                        ((OracleBulkTableLoaderTransformModel)this.getOwner()).setDataTableOptions(value.toString());
                    } else if (optionName.equals(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_RECORD_PERCENT)) {
                        ((OracleBulkTableLoaderTransformModel)this.getOwner()).setRecordPercent(Integer.valueOf(value.toString()));
                    }
                    if (optionName.equals(OracleBulkTableLoaderTransformModel.PROPERTY_NAME_RECREATE_INDEXES_ALWAYS)) {
                        ((OracleBulkTableLoaderTransformModel)this.getOwner()).setRecreateIndexesAlways(OracleBulkTableLoaderTransformModel.this.yesNoToBoolean(value.toString()));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class SetRecordPercentUndoable
    extends AbstractUndoableEdit {
        private int m_oldValue;
        private int m_newValue;

        public SetRecordPercentUndoable(int oldValue, int newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            OracleBulkTableLoaderTransformModel.this.setRecordPercent(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            OracleBulkTableLoaderTransformModel.this.setRecordPercent(this.m_newValue);
        }
    }
}

