/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Stack;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DataTransferTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.SASDataTransfer";
    private static final String TRANSFORMATION_ROLE = "DataTransfer:HIDE";
    private static final String ARM_DISPLAY_NAME = "SASDataTransfer";
    private static final String REMOTE_MACRO = "etls_remoteMacro";
    public static final String UPLOAD_DOWNLOAD_OPTIONS_CHANGED = "DataTransferTransformModel:UploadDownloadOptionsChanged";
    private static final String PROPERTY_NAME_UPLOAD_DOWNLOAD_OPTIONS = "TransferOptions";
    private String m_sUploadDownloadOptions = "";
    private ITransform m_nextStep;

    public DataTransferTransformModel(String sID, IModel model) {
        super(sID, model);
        this.setTargetDataAutomaticallyMoved(true);
        super.setCollectSourceTableRowCounts(false);
        super.setCollectTargetTableRowCounts(false);
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("DataTransferTransformModel.DisplayType.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("DataTransferTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public void addDefaultSettings() {
        this.addNewWorkTable();
    }

    public String getUploadDownloadOptions() {
        return this.m_sUploadDownloadOptions;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new DataTransferPromptModel(this);
    }

    public void setUploadDownloadOptions(String sOptions) {
        if (sOptions == null) {
            throw new IllegalArgumentException("null is not allowed for PROC UPLOAD/DOWNLOAD options");
        }
        if (this.m_sUploadDownloadOptions.equals(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUploadDownloadOptionsUndoable(this.m_sUploadDownloadOptions, sOptions));
        }
        this.m_sUploadDownloadOptions = sOptions;
        this.fireModelChangedEvent(UPLOAD_DOWNLOAD_OPTIONS_CHANGED, this.m_sUploadDownloadOptions);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setUploadDownloadOptions(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_UPLOAD_DOWNLOAD_OPTIONS, "", 2));
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_UPLOAD_DOWNLOAD_OPTIONS, PROPERTY_NAME_UPLOAD_DOWNLOAD_OPTIONS, PROPERTY_NAME_UPLOAD_DOWNLOAD_OPTIONS, this.getUploadDownloadOptions(), 12, 2);
    }

    @Override
    protected void postAddDataTarget(IDataObject target) {
        super.postAddDataTarget(target);
        target.addNotifyListener(this);
    }

    @Override
    protected void postRemoveDataTarget(IDataObject target) {
        super.postRemoveDataTarget(target);
        target.removeNotifyListener(this);
    }

    @Override
    public void notify(NotifyEvent ev) {
        super.notify(ev);
        ModelEvent modelEvent = ev.getModelEvent();
        if (modelEvent != null) {
            if (this.getDataTargetsCount() > 0) {
                IPhysicalTable target = (IPhysicalTable)this.getTargetTables()[0];
                if (target == modelEvent.getModelObject() && "PhysicalTable:LibraryChanged".equals(modelEvent.getType())) {
                    this.fireModelChangedEvent("ITransform:TransformChanged", null);
                }
                if (target == modelEvent.getModelObject() && ("IDataObject:ConsumerAdded".equals(modelEvent.getType()) || "IDataObject:ConsumerRemoved".equals(modelEvent.getType()))) {
                    if (this.m_nextStep != null) {
                        this.m_nextStep.removeNotifyListener(this);
                    }
                    this.m_nextStep = null;
                    if (target.getConsumerTransforms().length > 0) {
                        this.m_nextStep = target.getConsumerTransforms()[0];
                    }
                    if (this.m_nextStep != null) {
                        this.m_nextStep.addNotifyListener(this);
                    }
                }
            }
            if (this.m_nextStep == modelEvent.getModelObject() && "ITransform:ExecutionServerChanged".equals(modelEvent.getType())) {
                this.fireModelChangedEvent("ITransform:TransformChanged", null);
            }
        }
    }

    @Override
    public boolean isComplete() {
        boolean complete = super.isComplete();
        if (complete) {
            IPhysicalTable table = (IPhysicalTable)this.getTargetTables()[0];
            ILibrary lib = table.getLibrary();
            if (lib == null) {
                return false;
            }
            try {
                IServer defaultServer = this.getDefaultServer();
                IDataTransform[] transforms = table.getConsumerTransforms();
                for (int i = 0; i < transforms.length; ++i) {
                    IServer libraryServer;
                    IDataTransform transform = transforms[i];
                    if (transform instanceof DataTransferTransformModel) {
                        return false;
                    }
                    IServer stepServer = transform.getServerForStep(defaultServer);
                    if (ObjectComparator.isEqual(stepServer, libraryServer = lib.getBestServer(defaultServer))) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IServer getDefaultServer() throws RemoteException, MdException {
        String appServerId;
        IModel model = this.getModel();
        IServer server = (IServer)model.getObject(appServerId = WsAppServer.getDefaultAppServerFQID());
        if (server != null) {
            return server;
        }
        server = model.getObjectFactory().createServer(appServerId);
        OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "acquireServer");
        boolean bUndo = model.isUndoSupported();
        model.setUndoSupported(false);
        try {
            omr.populateFor(server);
            server.loadFromOMR(omr);
            IServer iServer = server;
            return iServer;
        }
        finally {
            model.setUndoSupported(bUndo);
            omr.dispose();
        }
    }

    @Override
    protected boolean areMappingsComplete() {
        return true;
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable table = (IPhysicalTable)this.getTargetTables()[0];
            ILibrary lib = table.getLibrary();
            if (lib == null) {
                lReasons.add(MessageFormat.format(RB.getStringResource("DataTransferTransformModel.TargetLibrary.Error.txt"), table.getName()));
            }
            try {
                IServer defaultServer = this.getDefaultServer();
                IDataTransform[] transforms = table.getConsumerTransforms();
                for (int i = 0; i < transforms.length; ++i) {
                    IServer libraryServer;
                    IDataTransform transform = transforms[i];
                    if (transform instanceof DataTransferTransformModel) {
                        lReasons.add(RB.getStringResource("DataTransferTransformModel.NextStepTransfer.Error.txt"));
                        break;
                    }
                    IServer stepServer = transform.getServerForStep(defaultServer);
                    if (ObjectComparator.isEqual(stepServer, libraryServer = lib.getBestServer(defaultServer))) continue;
                    lReasons.add(MessageFormat.format(RB.getStringResource("DataTransferTransformModel.LibraryServerNotNextStepServer.txt"), lib.getName(), table.getName(), transform.getName()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lReasons;
    }

    @Override
    public ICodeSegment getGeneratedLibnameCodeForSources(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return codeSegment;
    }

    @Override
    public ICodeSegment getGeneratedLibnameCodeForTargets(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return codeSegment;
    }

    @Override
    public IServer getServerForStep(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        return defaultServer;
    }

    @Override
    public ICodeSegment getGenerateTableIndexes(ICodeSegment codeSegment) {
        return codeSegment;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IServer currentServer = codeSegment.getCurrentServer();
        IPhysicalTable sourceTable = (IPhysicalTable)this.getSourceTables()[0];
        IPhysicalTable targetTable = (IPhysicalTable)this.getTargetTables()[0];
        IDataTransform previousStep = null;
        IDataTransform[] previousSteps = sourceTable.getProducerTransforms();
        if (previousSteps.length > 0) {
            previousStep = previousSteps[0];
        }
        ILibrary sourceLibrary = sourceTable.getCodeGenLibrary(currentServer);
        ILibrary targetLibrary = targetTable.getCodeGenLibrary(currentServer);
        IServer sourceServer = sourceLibrary != null ? sourceLibrary.getBestServer(currentServer) : currentServer;
        IServer prevServer = previousStep != null ? previousStep.getServerForStep(currentServer) : sourceServer;
        IServer nextServer = targetLibrary != null ? targetLibrary.getBestServer(currentServer) : currentServer;
        IServer localServer = null;
        ILibrary localLibrary = null;
        IServer remoteServer = null;
        ILibrary remoteLibrary = null;
        boolean noneAreLocal = false;
        boolean bothAreLocal = false;
        String proc = null;
        boolean fTargetIsLocal = true;
        if (ObjectComparator.isEqual(prevServer, nextServer)) {
            bothAreLocal = true;
            localServer = currentServer;
            remoteServer = nextServer;
            localLibrary = targetTable.getClientLibrary(localServer);
            remoteLibrary = sourceTable.getClientLibrary(remoteServer);
            fTargetIsLocal = true;
            codeSegment.addCommentLine(RB.getStringResource("DataTransferTransformModel.NoTransferPerformed.msg.txt"));
        } else if (ObjectComparator.isEqual(nextServer, currentServer)) {
            remoteServer = prevServer;
            localServer = nextServer;
            proc = "download";
            localLibrary = targetTable.getClientLibrary(localServer);
            remoteLibrary = sourceTable.getClientLibrary(remoteServer);
            fTargetIsLocal = true;
        } else if (ObjectComparator.isEqual(prevServer, currentServer)) {
            remoteServer = nextServer;
            localServer = prevServer;
            proc = "upload";
            localLibrary = sourceTable.getClientLibrary(localServer);
            remoteLibrary = targetTable.getClientLibrary(remoteServer);
            fTargetIsLocal = false;
        } else {
            remoteServer = nextServer;
            localServer = prevServer;
            proc = "upload";
            noneAreLocal = true;
            localLibrary = sourceTable.getClientLibrary(localServer);
            remoteLibrary = targetTable.getClientLibrary(remoteServer);
            fTargetIsLocal = false;
        }
        Stack rsubmitStack = new Stack();
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        if (noneAreLocal && this.genSignonAndRsubmit(codeSegment, localServer, rsubmitStack)) {
            environment.setCurrentServer(localServer);
        }
        if (!bothAreLocal) {
            if (localLibrary != null) {
                localLibrary.genAccessPath(codeSegment);
            }
            if (fTargetIsLocal) {
                codeSegment.genTableDelete(targetTable);
            }
        }
        if (!ObjectComparator.isEqual(localServer, remoteServer) && this.genSignonAndRsubmit(codeSegment, remoteServer, rsubmitStack)) {
            environment.setCurrentServer(remoteServer);
        }
        if (bothAreLocal) {
            if (localLibrary != null) {
                localLibrary.genAccessPath(codeSegment);
            }
            if (fTargetIsLocal) {
                codeSegment.genTableDelete(targetTable);
            }
        }
        if (remoteLibrary != null) {
            remoteLibrary.genAccessPath(codeSegment);
        }
        if (!fTargetIsLocal) {
            codeSegment.genTableDelete(targetTable);
        }
        codeSegment.genSyslast(sourceTable);
        String dsOptions = this.getUploadDownloadOptions();
        ITransformTableOptions sourceOptionModel = this.getTableOptionObject(sourceTable, true);
        String sourceOptions = sourceOptionModel.getTableOptions(true, null);
        ITransformTableOptions targetOptionObj = this.getTableOptionObject(targetTable, false);
        String targetOptions = targetOptionObj.getTableOptions(true, null);
        if (bothAreLocal) {
            String targetTableName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
            codeSegment.addSourceCode("data " + targetTableName);
            if (targetOptions != null && targetOptions.length() > 0) {
                codeSegment.addSourceCode(" ").addSourceCode(targetOptions);
            }
            if (targetTable instanceof IWorkTable && targetTable.isView()) {
                codeSegment.addSourceCode(" / view = " + targetTableName);
            }
            codeSegment.addSourceCode(";\n").indent().addSourceCode("set &SYSLAST " + sourceOptions + ";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
            environment.setCurrentServer(localServer);
        } else if (localServer != null) {
            String targetTableName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
            codeSegment.addSourceCode("proc " + proc + " data = &SYSLAST " + sourceOptions + " \n").addSourceCode("     out = " + targetTableName);
            if (targetOptions != null && targetOptions.length() > 0) {
                codeSegment.addSourceCode(" ").addSourceCode(targetOptions);
            }
            if (dsOptions != null && dsOptions.length() > 0) {
                codeSegment.addSourceCode("\n").addSourceCode("     ").addSourceCode(dsOptions);
            }
            codeSegment.addSourceCode(";\n");
            codeSegment.addSourceCode("run;\n");
            codeSegment.genRCSetCall("&syserr");
            if (this.isGenerateIndexesOnTargetTables() && "UPLOAD".equalsIgnoreCase(proc) && targetTable.hasIndexes()) {
                targetTable.getDBMSType().createIndexes2(codeSegment, targetTable, null, null);
            }
            this.genRemoteSubmitEnding(codeSegment, rsubmitStack);
            environment.setCurrentServer(localServer);
            if (this.isGenerateIndexesOnTargetTables() && "DOWNLOAD".equalsIgnoreCase(proc) && targetTable.hasIndexes()) {
                targetTable.getDBMSType().createIndexes2(codeSegment, targetTable, null, null);
            }
        }
        if (noneAreLocal) {
            this.genRemoteSubmitEnding(codeSegment, rsubmitStack);
            environment.setCurrentServer(currentServer);
        }
        if (!rsubmitStack.isEmpty()) {
            this.genRemoteSubmitEnding(codeSegment, rsubmitStack);
            environment.setCurrentServer(localServer);
        }
        return codeSegment;
    }

    private ICodeSegment genRemoteSubmitEnding(ICodeSegment codeSegment, Stack rsubmitStack) throws MdException, RemoteException {
        Object server = rsubmitStack.pop();
        if (server != null) {
            ISASClientConnection serverSupport = (ISASClientConnection)server;
            codeSegment.genReturnCodeRemoteEnding(false);
            codeSegment.unIndent();
            codeSegment.addSourceCode("%mend ").addSourceCode(REMOTE_MACRO).addSourceCode("; \n").addSourceCode("%").addSourceCode(REMOTE_MACRO).addSourceCode("; \n\n").unIndent();
            serverSupport.genEndSubmit(codeSegment, this.getJob().isRCSetSYSCCEnabled());
        }
        return codeSegment;
    }

    private boolean genSignonAndRsubmit(ICodeSegment codeSegment, IServer server, Stack rsubmitStack) throws BadServerDefinitionException {
        ISASClientConnection connectClient = server.getConnectClient();
        if (connectClient == null) {
            throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("DataTransferTransformModel.NoClientConnection.msg.txt"), server.getName()));
        }
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        boolean inRemoteSubmit = false;
        boolean alreadySignedOn = environment.isOnSignonCache(server);
        if (!alreadySignedOn) {
            if (codeSegment.isQuoting()) {
                codeSegment.genValidvarnameOptionAny(false);
            }
            connectClient.genAccessCode(codeSegment);
            environment.addToSignonCache(server);
        }
        codeSegment.genReturnCodeRemoteSetup(connectClient, codeSegment.getRuntimeStatsConnectMacros(codeSegment), false);
        codeSegment.genRemoteMacroVariablesSetup(connectClient.getHostName()).addSourceCode("\n");
        connectClient.genStartSubmit(SASCodeGeneration.SYSRPUTSYNC_YES, codeSegment, true, codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled());
        rsubmitStack.push(connectClient);
        codeSegment.addSourceCode("%macro ").addSourceCode(REMOTE_MACRO).addSourceCode("; \n").indent();
        if (!alreadySignedOn) {
            codeSegment.genSystemOptions(this.getSystemOptions());
        }
        inRemoteSubmit = true;
        if (codeSegment.isQuoting()) {
            codeSegment.genValidvarnameOptionAny(false);
        }
        return inRemoteSubmit;
    }

    protected class DataTransferPromptModel
    extends BaseDataTransformPromptModel {
        public DataTransferPromptModel(DataTransferTransformModel model) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model.getModel(), model);
        }

        protected String getTemplateName() {
            return "res/Options_DataTransfer_Template.xml";
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(DataTransferPromptModel.class.getResource(this.getTemplateName()));
            PromptGroupInterface result = this.combinePromptGroups(grp1, grp);
            this.removeOption("SYSLAST", result);
            return result;
        }

        @Override
        protected IModelListener createModelListener() {
            return new DataTransferModelListener(this.getOwner(), this);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            this.setOptionValue(DataTransferTransformModel.PROPERTY_NAME_UPLOAD_DOWNLOAD_OPTIONS, (Object)((DataTransferTransformModel)this.getOwner()).getUploadDownloadOptions());
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new DataTransferValueChangeListener((DataTransferTransformModel)this.getOwner(), this);
        }

        private class DataTransferModelListener
        extends BaseDataTransformModelListener {
            public DataTransferModelListener(IObject object, IPromptModel promptModel) {
                super(object, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                String type = ev.getType();
                this.getPromptModel().setListeningForChanges(false);
                try {
                    if (DataTransferTransformModel.UPLOAD_DOWNLOAD_OPTIONS_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(DataTransferTransformModel.PROPERTY_NAME_UPLOAD_DOWNLOAD_OPTIONS, (Object)DataTransferTransformModel.this.getUploadDownloadOptions());
                    }
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class DataTransferValueChangeListener
        extends BaseDataTransformValueChangedListener {
            public DataTransferValueChangeListener(DataTransferTransformModel owner, IPromptModel promptModel) {
                super(owner, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    if (DataTransferTransformModel.PROPERTY_NAME_UPLOAD_DOWNLOAD_OPTIONS.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        DataTransferTransformModel.this.setUploadDownloadOptions(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class SetUploadDownloadOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOptions;
        private String m_sNewOptions;

        public SetUploadDownloadOptionsUndoable(String oldOptions, String newOptions) {
            this.m_sOldOptions = oldOptions;
            this.m_sNewOptions = newOptions;
        }

        @Override
        public void undo() {
            super.undo();
            DataTransferTransformModel.this.setUploadDownloadOptions(this.m_sOldOptions);
        }

        @Override
        public void redo() {
            super.redo();
            DataTransferTransformModel.this.setUploadDownloadOptions(this.m_sNewOptions);
        }
    }
}

