/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.impl.FileMappingRule;
import com.sas.workspace.Workspace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class MappingFileParser {
    private static final String SIMPLE_RULE_PATTERN = "\\[SIMPLERULE\\].*";
    private static final String REGEX_RULE_PATTERN = "\\[REGEXRULE\\].*";
    private static final String COMMENT_PATTERN = "#.*";
    private static String[] defaultRules = new String[]{new String("[SIMPLERULE], [(SOURCE.NAME LIKE TARGET.NAME) AND (SOURCE.LENGTH LE TARGET.LENGTH) AND (SOURCE.TYPE EQ TARGET.TYPE)], [] , #name=name AND length <= length AND type=type makes a 1-1 mapping")};
    private static ArrayList m_mappingRules = new ArrayList();

    public static IMappingRule[] getMappingRules() {
        if (m_mappingRules.size() > 0) {
            return m_mappingRules.toArray(new IMappingRule[m_mappingRules.size()]);
        }
        String defaultFileLocation = Workspace.getAppDataFilePath((String)"defaultmappingrules.txt");
        if (!Workspace.copyAppDataFileToCurrentAppDataDirectory((String)"defaultmappingrules.txt")) {
            MappingFileParser.makeRulesFile(defaultFileLocation);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(defaultFileLocation)));){
            String currentLine = br.readLine();
            while (currentLine != null) {
                if (!currentLine.matches(COMMENT_PATTERN)) {
                    if (currentLine.matches(SIMPLE_RULE_PATTERN)) {
                        m_mappingRules.add(new FileMappingRule(currentLine, 0));
                    } else if (currentLine.matches(REGEX_RULE_PATTERN)) {
                        m_mappingRules.add(new FileMappingRule(currentLine, 1));
                    }
                }
                currentLine = br.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            ModelLogger.getDefaultLogger().debug((Object)"MappingFileParser: Mapping file not found");
        }
        catch (IOException ex2) {
            ModelLogger.getDefaultLogger().debug((Object)"MappingFileParser: Cant read mapping file");
        }
        if (m_mappingRules.size() == 0) {
            ModelLogger.getDefaultLogger().debug((Object)"NOTE: Using default rules");
            m_mappingRules.add(new FileMappingRule(defaultRules[0], 0));
        }
        return m_mappingRules.toArray(new IMappingRule[m_mappingRules.size()]);
    }

    private static File getRulesFile() {
        String[] versions;
        String defaultFileLocation = Workspace.getDataIntegrationStudioAppVersionDataPath((String)"4.3") + System.getProperty("file.separator") + "defaultmappingrules.txt";
        File file = new File(defaultFileLocation);
        if (file.exists()) {
            return file;
        }
        for (String version : versions = new String[]{"4.2"}) {
            String oldPath = Workspace.getDataIntegrationStudioAppVersionDataPath((String)version) + System.getProperty("file.separator") + "defaultmappingrules.txt";
            File oldFile = new File(oldPath);
            if (!oldFile.exists()) continue;
            try {
                FileUtils.copyFile((File)oldFile, (File)file);
                return file;
            }
            catch (IOException ex) {
                Workspace.getDefaultLogger().warn((Object)"Problem copying mapping rules file", (Throwable)ex);
                return null;
            }
        }
        MappingFileParser.makeRulesFile(defaultFileLocation);
        return null;
    }

    private static void makeRulesFile(String actualFileLocation) {
        FileOutputStream file = null;
        try {
            try {
                file = new FileOutputStream(actualFileLocation);
                PrintStream printStream = new PrintStream(file);
                printStream.println("# Mapping rules file;  Generated on : " + new Date());
                printStream.println("# These are the automatic mapping rules for Data Integration studio;  anything with a # after is considered a comment on that line.");
                printStream.println("# These are used when you choose the map columns action on the mapping panel and/or transformation.");
                printStream.println("# There are 2 default rules are in this file;  you can change them if you want to provided you follow the specified syntax.");
                printStream.println("#");
                printStream.println("# The fields in this file are delineated as follows:  [FIELD 1], [FIELD 2], # FIELD 3");
                printStream.println("#");
                printStream.println("#      [FIELD 1: Rules (can be chained together)]");
                printStream.println("#      [FIELD 2: expression (optional)]");
                printStream.println("#      #FIELD 3: comments (optional)");
                printStream.println("#");
                printStream.println("# Spaces are allowed anywhere, but you have to have a , between the fields, and you have to bracket the first two fields with [] square brackets.");
                printStream.println("# The contents of fields 2 and 3 are optional.  You have to have a [FIELD 1], [], and a #");
                printStream.println("#");
                printStream.println("# To write a rule:");
                printStream.println("#   - Specify rule type:  SIMPLERULE or REGEXRULE (uses regular expressions to compare text, usually for column name matching)");
                printStream.println("#   - Specify SOURCE. and/or TARGET. for the column to use");
                printStream.println("#   - Optionally specify a constant to compare to the SOURCE or TARGET:");
                printStream.println("#   -           CONSTANT=NOCASE(some value) for case insensitive compares OR CONSTANT=CASE(some value) for case sensitive compares");
                printStream.println("#   - Specify the attribute to compare.  Supported attributes are: NAME LENTH TYPE DESCRIPTION FORMAT INFORMAT SORTORDER Ex:  SOURCE.NAME");
                printStream.println("#   - For regular expression rules only:  Specify the optional regular expression:  Ex:  SOURCE.NAME=CASE(.*app.*)");
                printStream.println("#   - Specify the comparisons, one or more, strings or integer numbers supported only");
                printStream.println("#      - String comparisons supported are:  ");
                printStream.println("#           LIKE (case insensitive compare of strings or a regular expression) This is the only comparison supported for a regular expression compare");
                printStream.println("#           NOT_LIKE (case insensitive compare of strings NOT)");
                printStream.println("#           EQ (equal case sensitive compare) NE (not equal case sensitive compare)");
                printStream.println("#           CONTAINS_LIKE (source contains the target in some form, case insensitive), ");
                printStream.println("#           CONTAINS_EQ (source contains the target in some form, case sensitive)");
                printStream.println("#      - Numeric comparisons supported are:   EQ (equal) NE (not equal) LT (less than) GT (greater than) GE (greater than or equal) LE (less than or equal)");
                printStream.println("#   - Chain more than one comparison together with AND OR NOT NOT_AND NOT_OR ");
                printStream.println("#");
                printStream.println("# There are two default rules provided below.");
                printStream.println("#");
                printStream.println("# Default RULE 1:  (Name=Name (case insensitive compare) AND Length <= Length AND Type=Type (case insensitive compare)) #NOTE: this was the default rule in SAS Data Integration Studio Release 3.4");
                printStream.println("[SIMPLERULE],[(SOURCE.NAME LIKE TARGET.NAME) AND (SOURCE.LENGTH LE TARGET.LENGTH) AND (SOURCE.TYPE EQ TARGET.TYPE)], [] , #name=name AND length <= length AND type=type makes a 1-1 mapping");
                printStream.println("#");
                printStream.println("# Default RULE 2 & 3:  This is also really useful;  it creates a derived mapping for you to convert numeric to character or character to numeric columns");
                printStream.println("# Just change the format of these rule if you want a different format in the target");
                printStream.println("[SIMPLERULE],[(SOURCE.NAME LIKE TARGET.NAME) AND (SOURCE.TYPE NE TARGET.TYPE) AND (SOURCE.TYPE EQ CONSTANT=NOCASE(N) )],  [TRIM(LEFT(PUT(SOURCE.NAME,BEST32.)))], #this tells sas to do the conversion from numeric to character automatically");
                printStream.println("[SIMPLERULE],[(SOURCE.NAME LIKE TARGET.NAME) AND (SOURCE.TYPE NE TARGET.TYPE) AND (SOURCE.TYPE EQ CONSTANT=NOCASE(C) )],  [INPUT(SOURCE.NAME,BEST32.)], #this tells sas to do the conversion from character to numeric automatically");
                printStream.println("#");
                printStream.println("# Information about Regular expression rules. Following is information and examples of how to use a regular expression to do name matching on a column name.");
                printStream.println("#");
                printStream.println("# Some simple help on regular expressions:");
                printStream.println("#");
                printStream.println("#    .*  matches any character, ^ matches beginning at the start of a string, ABC matches exactly that string, [abc] matches a or b or c");
                printStream.println("#    CASE case sensitive matching, NOCASE case insensitive matching");
                printStream.println("#");
                printStream.println("# Here are a few examples to get started.");
                printStream.println("#");
                printStream.println("# Note:  the format of the rule must match EXACTLY the syntax as shown below, that is you must enclose the regular expression precisely as shown.");
                printStream.println("#        Any deviation and the rule will not be recognized");
                printStream.println("#");
                printStream.println("#        The rule format is:  ");
                printStream.println("#       ");
                printStream.println("#   [REGEXRULE],[(SOURCE.NAME=XXXX(YYYY)  LIKE TARGET.NAME=AAAA(BBBB)) ...],[some optional expression if the ma],some comment");
                printStream.println("#");
                printStream.println("#   where XXXX and AAAA are either the strings CASE or NOCASE and YYYY and BBBB are the regular expression");
                printStream.println("#");
                printStream.println("#  Example1: Source columns that start with InV followed by anything (case insensitive) will match any target column that contains the string INV (case insensitve) somewhere in the string");
                printStream.println("#[REGEXRULE],[(SOURCE.NAME=NOCASE(^INV.*) LIKE TARGET.NAME=NOCASE(.*INV.*)  ) AND (SOURCE.LENGTH LE TARGET.LENGTH) AND (SOURCE.TYPE EQ TARGET.TYPE)], [] , # match names using a regular expression");
                printStream.println("#");
                printStream.println("#  Example2: Source columns that contain Inv somewhere in the string (case sensitive) will match any target column that contains the string INV (case insensitve) somewhere in the string");
                printStream.println("#[REGEXRULE],[(SOURCE.NAME=CASE(.*Inv.*) LIKE TARGET.NAME=NOCASE(.*INV.*)) AND (SOURCE.LENGTH LE TARGET.LENGTH) AND (SOURCE.TYPE EQ TARGET.TYPE)], [] , # match names using a regular expression");
                printStream.close();
            }
            catch (FileNotFoundException ex) {
                ModelLogger.getDefaultLogger().debug((Object)("Unable to create mapping rules file: " + actualFileLocation));
                file = null;
            }
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException ex) {
                ModelLogger.getDefaultLogger().debug((Object)ex.getLocalizedMessage());
            }
        }
    }
}

