/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.job.impl.BaseValidationOperation;
import javax.swing.undo.AbstractUndoableEdit;

public class InvalidValuesValidationOperation
extends BaseValidationOperation {
    public static final String LOOKUP_COLUMN_CHANGED = "ValidationEvent:LookupColumnChanged";
    public static final String BLANKS_VALID_CHANGED = "ValidationEvent:BlanksValidChanged";
    private boolean m_bBlanksValid;
    private IColumn m_colLookup;

    public InvalidValuesValidationOperation(String sID, IModel model) {
        super(sID, model);
    }

    public static String getValidationType() {
        return "ValidationOperation:InvalidValues";
    }

    public IColumn getLookupColumn() {
        return this.m_colLookup;
    }

    public void setLookupColumn(IColumn lookupColumn) {
        if (lookupColumn == null) {
            throw new IllegalArgumentException("an invalid values validation operation requires a non-null lookup column");
        }
        if (lookupColumn.equals(this.m_colLookup)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLookupColumnUndoable(this.m_colLookup, lookupColumn));
        }
        this.m_colLookup = lookupColumn;
        this.fireModelChangedEvent(LOOKUP_COLUMN_CHANGED, this.m_colLookup);
    }

    public boolean isBlanksValid() {
        return this.m_bBlanksValid;
    }

    public void setBlanksValid(boolean blanksValid) {
        if (this.m_bBlanksValid == blanksValid) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBlanksValidUndoable(this.m_bBlanksValid, blanksValid));
        }
        this.m_bBlanksValid = blanksValid;
        this.fireModelChangedEvent(BLANKS_VALID_CHANGED, this.m_bBlanksValid);
    }

    private class SetLookupColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_colOldLookup;
        private IColumn m_colNewLookup;

        public SetLookupColumnUndoable(IColumn oldLookup, IColumn newLookup) {
            this.m_colOldLookup = oldLookup;
            this.m_colNewLookup = newLookup;
        }

        @Override
        public void undo() {
            super.undo();
            InvalidValuesValidationOperation.this.setLookupColumn(this.m_colOldLookup);
        }

        @Override
        public void redo() {
            super.redo();
            InvalidValuesValidationOperation.this.setLookupColumn(this.m_colNewLookup);
        }
    }

    private class SetBlanksValidUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldBlanksValid;
        private boolean m_bNewBlanksValid;

        public SetBlanksValidUndoable(boolean oldBlanksValid, boolean newBlanksValid) {
            this.m_bOldBlanksValid = oldBlanksValid;
            this.m_bNewBlanksValid = newBlanksValid;
        }

        @Override
        public void undo() {
            super.undo();
            InvalidValuesValidationOperation.this.setBlanksValid(this.m_bOldBlanksValid);
        }

        @Override
        public void redo() {
            super.redo();
            InvalidValuesValidationOperation.this.setBlanksValid(this.m_bNewBlanksValid);
        }
    }
}

