/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.impl.MappingFileParser;

public class DefaultMappingRules {
    private static IMappingRule[] s_aRules;

    private DefaultMappingRules() {
    }

    public static IMappingRule[] getRules() {
        if (s_aRules == null) {
            DefaultMappingRules.createRules();
        }
        return s_aRules;
    }

    private static void createRules() {
        s_aRules = MappingFileParser.getMappingRules();
        if (s_aRules == null) {
            s_aRules = new IMappingRule[]{new DefaultSimpleMappingRule()};
        }
    }

    private static class DefaultSimpleMappingRule
    implements IMappingRule {
        private DefaultSimpleMappingRule() {
        }

        @Override
        public boolean canMap(IColumn source, IColumn target) {
            return source.getName().equalsIgnoreCase(target.getName()) && source.getType() == target.getType() && source.getLength() <= target.getLength();
        }

        @Override
        public String getExpressionText() {
            return null;
        }
    }
}

