/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICheckpointRestart;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;

public class CheckpointRestart
implements ICheckpointRestart {
    private static final String CPRID_KEY_TABLE_SUFFIX = "rid";
    private static final String ENV_VARS_TABLE_SUFFIX = "mcv";
    private static final String STEP_FAIL_INFO_TABLE_SUFFIX = "stp";
    private static final String MACROVARS_TO_SKIP_IN_LOADENV = "'CPRID','JOB_RC','TRANS_RC','ETLS_STARTTIME','ETLS_ENDTIME','SQLRC','ETLS_RESETRESTART','ETLS_STEPSTARTTIME','ETLSCPR_PENDINGID',\n'ETLSCPR_RUNNINGID','ETLS_RUNNINGINTERACTIVE','_ARMEXEC','_PERFINIT','_ARMTXID','_PERFNEST','_ARMSHDL','_ARMAPID'";
    private static final String CONDITION_NORESTART_PENDING = "&etlsCPR_pendingID eq 0";
    private static final String IF_CONDITION_NO_ERROR = "%if (&job_rc < 5  AND %sysfunc(getoption(OBS)) NE 0 ) %then \n";
    private boolean m_bJobGenningCPRCode;
    private boolean m_bStepGenningCPRCode;
    private boolean m_bCustomRestartSupported;
    private boolean m_bRunStepAlways;
    private IJob m_oJob;
    private ITransform m_oTransform;
    private String m_sCPRMode = "JOB";
    private String cprStep = "etls_cprstep";
    private String cprStep_suffix = null;

    public CheckpointRestart(IJob job) {
        this.m_oJob = job;
        this.m_bJobGenningCPRCode = this.m_oJob.isCPRJobCodeNeeded(false);
        this.m_sCPRMode = "STEPS";
    }

    public CheckpointRestart(ITransform transform) {
        this.m_oTransform = transform;
        this.m_oJob = this.m_oTransform.getJob();
        this.m_bJobGenningCPRCode = this.m_oJob.isCPRJobCodeNeeded(transform.isCPRStepSetupComplete());
        this.m_bStepGenningCPRCode = this.m_bJobGenningCPRCode && transform.isCPRStepSetupComplete();
        this.m_bRunStepAlways = this.m_bJobGenningCPRCode && transform.isRunAlways();
        this.m_bCustomRestartSupported = transform.isCustomRestartSupported();
        this.m_sCPRMode = "STEPS";
    }

    @Override
    public ICodeSegment getCheckpointRestartPreJobCode(ICodeSegment codeSegment) throws CodegenException {
        boolean bWasLocal = this.genStateLibraryAccessPath(codeSegment, true);
        if (!bWasLocal) {
            codeSegment.addSourceCode("%macro etls_rptBadLib;\n").indent().addSourceCode("%if %sysfunc(libref(" + this.m_oJob.getCheckpointStateLibrary().getLibref() + ")) ne 0 %then \n").genPercentPutStatement(RB.getStringResource("CheckpointRestart.SaveStateLibMustBeLocal.sasmacro.txt"), "WARNING%QUOTE(:)").unIndent().addSourceCode("%mend;\n").addSourceCode("%etls_rptBadLib;\n\n");
        }
        String stateLib = this.m_oJob.getCheckpointStateLibrary().getLibref();
        String tablePrefix = this.getSaveStateTablePrefix(codeSegment);
        codeSegment.addSourceCode("%global etls_resetRestart;\n").addSourceCode("%macro etlsCPR_setNoSyntaxCheck();\n").indent().addSourceCode("%let etls_svOptions = %sysfunc(getoption(syntaxcheck)) %sysfunc(getoption(replace)) obs=%sysfunc(getoption(obs));\noptions nosyntaxcheck replace obs=max;\n").addSourceCode("%let etls_svSyslast=&syslast;\n").unIndent().addSourceCode("%mend;\n").addSourceCode("%macro etlsCPR_resetNoSyntaxCheck();\n").indent().addSourceCode("options &etls_svOptions;\n%let syslast=&etls_svSyslast;\n").unIndent().addSourceCode("%mend;\n\n");
        codeSegment.addSourceCode("*============== SAVE/LOAD/CLEAR CPRID; \n").addSourceCode("%macro etlsCPR_saveID(CPRID); \n").indent().addSourceCode("%etlsCPR_setNoSyntaxCheck;\n").addSourceCode("proc datasets lib=" + stateLib + " nolist nowarn; delete " + tablePrefix + CPRID_KEY_TABLE_SUFFIX + "; quit; \n").addSourceCode("data " + stateLib + "." + tablePrefix + CPRID_KEY_TABLE_SUFFIX + "; length rid $20; rid=\"&CPRID\"; run; \n").addSourceCode("%etlsCPR_resetNoSyntaxCheck;\n").unIndent().addSourceCode("%mend etlsCPR_saveID; \n");
        this.getLoadCPRIDMacroCode(codeSegment);
        codeSegment.addSourceCode("%macro etlsCPR_clearID(); \n").indent().addSourceCode("proc datasets lib=" + stateLib + " nolist nowarn; delete " + tablePrefix + CPRID_KEY_TABLE_SUFFIX + "; quit; \n").unIndent().addSourceCode("%mend etlsCPR_clearID; \n\n");
        codeSegment.addSourceCode("*============== SAVE/LOAD/CLEAR Environment; \n").addSourceCode("%macro etlsCPR_saveEnv(CPRID); \n").indent().addSourceCode("%etlsCPR_setNoSyntaxCheck;\n").addSourceCode("data " + stateLib + "." + tablePrefix + ENV_VARS_TABLE_SUFFIX + ";\n").indent().addSourceCode("set sashelp.vmacro(where=(scope ne 'AUTOMATIC'));\n").unIndent().addSourceCode("run; \n").addSourceCode("%etlsCPR_resetNoSyntaxCheck;\n").unIndent().addSourceCode("%mend etlsCPR_saveEnv; \n").addSourceCode("%macro etlsCPR_loadEnv(CPRID); \n").indent().genPercentPutStatement("Loading environment... &CPRID").addSourceCode("data _null_; \n").indent().addSourceCode("set " + stateLib + "." + tablePrefix + ENV_VARS_TABLE_SUFFIX + "; \n").addSourceCode("where not (name in ('CPRID','JOB_RC','TRANS_RC','ETLS_STARTTIME','ETLS_ENDTIME','SQLRC','ETLS_RESETRESTART','ETLS_STEPSTARTTIME','ETLSCPR_PENDINGID',\n'ETLSCPR_RUNNINGID','ETLS_RUNNINGINTERACTIVE','_ARMEXEC','_PERFINIT','_ARMTXID','_PERFNEST','_ARMSHDL','_ARMAPID')); \n").addSourceCode("call symput(name,value);\n").unIndent().addSourceCode("run; \n").unIndent().addSourceCode("%mend etlsCPR_loadEnv; \n");
        codeSegment.addSourceCode("%macro etlsCPR_clearEnv(); \n").indent().addSourceCode("proc datasets lib=" + stateLib + " nolist nowarn; delete " + tablePrefix + ENV_VARS_TABLE_SUFFIX + "; quit; \n").unIndent().addSourceCode("%mend etlsCPR_clearEnv;\n\n");
        codeSegment.addSourceCode("*============== SAVE/LOAD/CLEAR StepFailedInfo; \n").addSourceCode("%macro etlsCPR_saveStepFailInfo(CPRID, tableToCopy); \n").indent().addSourceCode("%etlsCPR_setNoSyntaxCheck;\n").addSourceCode("data " + stateLib + "." + tablePrefix + STEP_FAIL_INFO_TABLE_SUFFIX + "; set &tabletocopy; run; \n").addSourceCode("%etlsCPR_resetNoSyntaxCheck;\n").unIndent().addSourceCode("%mend etlsCPR_saveStepFailInfo; \n").addSourceCode("%macro etlsCPR_loadStepFailInfo(CPRID,tableToCopy); \n").indent().genPercentPutStatement("Loading failed step info... &CPRID").addSourceCode("%etlsCPR_setNoSyntaxCheck;\n").addSourceCode("%if %sysfunc(exist(" + stateLib + "." + tablePrefix + STEP_FAIL_INFO_TABLE_SUFFIX + ")) %then \n").addSourceCode("%do; data &tabletocopy; set " + stateLib + "." + tablePrefix + STEP_FAIL_INFO_TABLE_SUFFIX + "; run; %end; \n").addSourceCode("%else %do; proc datasets lib= %scan(&tabletocopy,1,.) nolist nowarn; delete %scan(&tabletocopy,2,.);quit; %end;\n").addSourceCode("%etlsCPR_resetNoSyntaxCheck;\n").unIndent().addSourceCode("%mend etlsCPR_loadStepFailInfo; \n").addSourceCode("%macro etlsCPR_clearStepFailInfo(CPRID); \n").indent().addSourceCode("proc datasets lib=" + stateLib + " nolist nowarn; delete " + tablePrefix + STEP_FAIL_INFO_TABLE_SUFFIX + "; quit; \n").unIndent().addSourceCode("%mend etlsCPR_clearStepFailInfo; \n\n");
        this.getInitialJobRestartCode(codeSegment);
        return codeSegment;
    }

    private ICodeSegment getInitialJobRestartCode(ICodeSegment codeSegment) throws CodegenException {
        codeSegment.addSourceCode("*====================== Init Restart code...; \n");
        codeSegment.addSourceCode((this.getCPRMode().equals("STEPS") ? "%global " : "%local ") + "etlsCPR_pendingID" + " " + "etlsCPR_runningID" + " etls_svOptions etls_svSyslast;\n").addSourceCode("%etlsCPR_loadID; \n").addSourceCode("%etlsCPR_saveID(-1); /* -1 signifies that the run started (init for next run) */ \n\n");
        return codeSegment;
    }

    public String getSaveStateTablePrefix(ICodeSegment codeSegment) {
        return "etlsCPR_" + codeSegment.formatObjectIDForMacroVar(this.m_oJob) + "_";
    }

    @Override
    public ICodeSegment getRestartPendingCode(ICodeSegment codeSegment, String macrovarName) throws CodegenException {
        codeSegment.addSourceCode("%let " + macrovarName + "=0;\n");
        if (this.m_oJob.getCheckpointStateLibrary() != null && this.genStateLibraryAccessPath(codeSegment, false)) {
            this.getReadCPRIDMacroCode(codeSegment).addSourceCode("%etlsCPR_readID(pendingMacrovarName=" + macrovarName + ");\n").genPercentPutStatement("Pending restart = &" + macrovarName);
        }
        return codeSegment;
    }

    private ICodeSegment getLoadCPRIDMacroCode(ICodeSegment codeSegment) {
        String stateLib = this.m_oJob.getCheckpointStateLibrary().getLibref();
        String tablePrefix = this.getSaveStateTablePrefix(codeSegment);
        codeSegment.addSourceCode("%macro etlsCPR_loadID(pendingMacrovarName=etlsCPR_pendingID); \n").indent().genPercentPutStatement("Loading CPRID... ").addSourceCode("%let &pendingMacrovarName=0; \n").addSourceCode("%if %sysfunc(exist(" + stateLib + "." + tablePrefix + CPRID_KEY_TABLE_SUFFIX + ")) %then \n").addSourceCode("%do; \n").indent().addSourceCode("data _null_; \n").indent().addSourceCode("set " + stateLib + "." + tablePrefix + CPRID_KEY_TABLE_SUFFIX + "; \n").addSourceCode("if rid=\"-1\" or \"%trim(&etls_resetRestart)\" = \"1\" or index(upcase(\"&sysparm\"),\"" + "etls_resetRestart".toUpperCase() + "\") > 0 then \n").addSourceCode("do; \n").indent().addSourceCode("if rid=\"-1\" then ").genPutStatement("Previous job run failed without reaching a checkpoint. Starting from beginning.").addSourceCode("else ").genPutStatement("User requested restart-reset. Starting from beginning.").addSourceCode("rid=\"0\"; \n").addSourceCode("call symput('etls_resetRestart','0');\n").addSourceCode("call execute('%etlsCPR_clearEnv( );'); \n").addSourceCode("call execute('%etlsCPR_clearStepFailInfo( );'); \n").unIndent().addSourceCode("end; \n").addSourceCode("call symput(\"&pendingMacrovarName\",rid); \n").addSourceCode("put 'NOTE: Pending CPRID = ' rid; \n").unIndent().addSourceCode("run; \n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%mend etlsCPR_loadID; \n");
        return codeSegment;
    }

    private ICodeSegment getReadCPRIDMacroCode(ICodeSegment codeSegment) {
        String stateLib = this.m_oJob.getCheckpointStateLibrary().getLibref();
        String tablePrefix = this.getSaveStateTablePrefix(codeSegment);
        codeSegment.addSourceCode("%macro etlsCPR_readID(pendingMacrovarName=etlsCPR_pendingID); \n").indent().addSourceCode("%let &pendingMacrovarName=0; \n").addSourceCode("%if %sysfunc(exist(" + stateLib + "." + tablePrefix + CPRID_KEY_TABLE_SUFFIX + ")) %then \n").addSourceCode("%do; \n").indent().addSourceCode("data _null_; \n").indent().addSourceCode("set " + stateLib + "." + tablePrefix + CPRID_KEY_TABLE_SUFFIX + "; \n").addSourceCode("if rid ne \"-1\" then \n").indent().addSourceCode("call symput(\"&pendingMacrovarName\",rid); \n").unIndent().addSourceCode("put 'NOTE: Pending CPRID = ' rid; \n").unIndent().addSourceCode("run; \n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%mend etlsCPR_readID; \n");
        return codeSegment;
    }

    private boolean genStateLibraryAccessPath(ICodeSegment codeSegment, boolean generateStatusMacros) throws CodegenException {
        ILibrary stateLibrary = this.m_oJob.getCheckpointStateLibrary();
        if (stateLibrary != null) {
            try {
                IServer server = codeSegment.getCurrentServer();
                IServer iServer = stateLibrary.getBestServer(server);
                boolean isLocal = false;
                isLocal = ObjectComparator.isEqual(iServer, server);
                if (!isLocal) {
                    return false;
                }
                codeSegment.addCommentLine("Assigning checkpoint/restart save-state library");
                stateLibrary.genAccessPath(codeSegment, generateStatusMacros);
            }
            catch (MdException ex) {
                throw new CodegenException((Exception)((Object)ex), (IObject)stateLibrary);
            }
            catch (RemoteException ex) {
                throw new CodegenException(ex, (IObject)stateLibrary);
            }
            catch (BadLibraryDefinitionException ex) {
                throw new CodegenException(ex, (IObject)stateLibrary);
            }
            catch (BadServerDefinitionException ex) {
                throw new CodegenException(ex, (IObject)stateLibrary);
            }
        }
        return true;
    }

    @Override
    public ICodeSegment getCheckpointRestartPostJobCode(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("%macro etlsCPR_JobEnd; \n").indent();
        codeSegment.addSourceCode(IF_CONDITION_NO_ERROR).addSourceCode("%do; \n").indent().addSourceCode("%etlsCPR_clearID(); \n").addSourceCode("%etlsCPR_clearEnv();\n").addSourceCode("%etlsCPR_clearStepFailInfo(); \n").unIndent().addSourceCode("%end; \n");
        codeSegment.unIndent().addSourceCode("%mend etlsCPR_JobEnd;\n").addSourceCode("%etlsCPR_JobEnd; \n\n");
        codeSegment.addSourceCode("/* end of CPR processing */ \n");
        return codeSegment;
    }

    @Override
    public ICodeSegment getCheckpointRestartPreStepCode(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        if (!this.m_bJobGenningCPRCode) {
            return codeSegment;
        }
        if (this.m_bRunStepAlways && !this.m_bStepGenningCPRCode) {
            return this.getRequiredForRestartInitCode(codeSegment);
        }
        codeSegment.addSourceCode("%macro ").addSourceCode(this.getCPRStepMacroName()).addSourceCode(";\n\n").indent();
        String cprID = "TEST";
        String cprName = "TEST";
        if (this.m_oTransform != null) {
            cprID = this.m_oTransform.getID();
            cprName = this.m_oTransform.getName();
        }
        String sSkipDueToPrevError = MessageFormat.format(RB.getStringResource("CheckpointRestart.SkipDueToPrevError.txt"), this.m_oTransform.getName());
        String sSkipDueToNotReachedRestartPoint = MessageFormat.format(RB.getStringResource("CheckpointRestart.SkipDueToNotReachedRestartPoint.txt"), this.m_oTransform.getName());
        if (!this.m_bStepGenningCPRCode) {
            codeSegment.addSourceCode("%if not (&etlsCPR_pendingID eq 0) %then \n").indent().genPercentPutStatement(sSkipDueToNotReachedRestartPoint, "CPR_SKIPPED%QUOTE(:)").unIndent().addSourceCode("%else\n").addSourceCode("%do;\n").indent();
        } else {
            codeSegment.addSourceCode("%if (&job_rc ge 5 OR %sysfunc(getoption(OBS)) EQ 0 ) %then \n").indent().genPercentPutStatement(sSkipDueToPrevError, "WARNING%QUOTE(:)").unIndent().addSourceCode("%else %if (&etlsCPR_pendingID ne 0 AND &etlsCPR_pendingID ne ").addSourceCode(cprID).addSourceCode(") %then\n").indent().genPercentPutStatement(sSkipDueToNotReachedRestartPoint, "CPR_SKIPPED%QUOTE(:)").unIndent().addSourceCode("%else \n").addSourceCode("%do; /* conditionally execute step for CPR */ \n\n").indent().addSourceCode("%if &etlsCPR_pendingID eq 0 %then \n").addSourceCode("%do; /* take checkpoint */ \n").indent();
            codeSegment.genPercentPutStatement("Taking checkpoint before " + cprName + " - SAVING ENV & CPRID").addSourceCode("%let etlsCPR_runningID=0;\n").addSourceCode("%etlsCPR_clearEnv(); \n").addSourceCode("%etlsCPR_saveEnv(").addSourceCode(cprID).addSourceCode(");  \n").addSourceCode("%etlsCPR_saveID(").addSourceCode(cprID).addSourceCode("); \n").unIndent().addSourceCode("%end; /* take checkpoint */ \n\n");
            codeSegment.addSourceCode("%else %if &etlsCPR_pendingID eq ").addSourceCode(cprID).addSourceCode(" %then \n").addSourceCode("%do; /* prepare for restart */ \n").indent().genPercentPutStatement(RB.getStringResource("CheckpointRestart.RestartedWithThisStep.txt"), "ETLS_DIAG%QUOTE(:)").genPercentPutStatement(MessageFormat.format(RB.getStringResource("CheckpointRestart.PickingUpFromCheckpoint.txt"), cprName)).addSourceCode("%let etlsCPR_runningID=&etlsCPR_pendingID; \n").addSourceCode("%let etlsCPR_pendingID=0; \n");
            this.getLibnamesForRestartStepCode(codeSegment, this.m_oTransform);
            codeSegment.addSourceCode("%etlsCPR_loadEnv(" + cprID + "); /* first, load the env saved from prev run */ \n").addSourceCode("%etlsCPR_saveID(").addSourceCode(cprID).addSourceCode("); \n");
            if (this.m_oTransform != null && this.m_oTransform.isCustomRestartSupported()) {
                this.getCustomPreStepCode(codeSegment, this.m_oTransform);
            }
            codeSegment.unIndent().addSourceCode("%end; /* prepare for restart */ \n\n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getCheckpointRestartPostStepCode(ICodeSegment codeSegment) {
        if (!this.m_bJobGenningCPRCode) {
            return codeSegment;
        }
        if (this.m_bRunStepAlways && !this.m_bStepGenningCPRCode) {
            return this.getRequiredForRestartTermCode(codeSegment);
        }
        if (this.m_bStepGenningCPRCode && this.m_bCustomRestartSupported) {
            this.getCustomPostStepCode(codeSegment);
        }
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end; /* conditionally execute step for CPR */ \n");
        codeSegment.unIndent().addSourceCode("%mend ").addSourceCode(this.getCPRStepMacroName()).addSourceCode("; \n%").addSourceCode(this.getCPRStepMacroName()).addSourceCode(";\n\n");
        return codeSegment;
    }

    private String getCPRStepMacroName() {
        return this.cprStep_suffix != null ? this.cprStep + this.cprStep_suffix : this.cprStep;
    }

    @Override
    public void setCPRStepSuffix(String value) {
        this.cprStep_suffix = value;
    }

    public ICodeSegment getLibnamesForRestartStepCode(ICodeSegment codeSegment, ITransform transform) throws CodegenException, BadLibraryDefinitionException {
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        ILibrary lib = null;
        List libList = environment.getLibrariesGeneratedList();
        if (libList != null && libList.size() > 0) {
            for (int i = 0; i < libList.size(); ++i) {
                lib = (ILibrary)libList.get(i);
                IJob job = transform.getJob();
                if (lib == null || lib == job.getCheckpointStateLibrary() || ObjectComparator.isEqual(job.getAlternateTemporaryLibrary(), lib)) continue;
                try {
                    StringBuffer libnameCode = lib.getAccessPath(environment, false);
                    if (libnameCode.length() <= 0) continue;
                    codeSegment.addSourceCode("%if %sysfunc(libref(").addSourceCode(lib.getLibref()).addSourceCode(")) ne 0 %then \n").addSourceCode("%do;\n").indent().addSourceCode(libnameCode).unIndent().addSourceCode("%end;\n");
                    continue;
                }
                catch (MdException ex) {
                    throw new CodegenException((Exception)((Object)ex), (IObject)lib);
                }
                catch (RemoteException ex) {
                    throw new CodegenException(ex, (IObject)lib);
                }
                catch (BadServerDefinitionException ex) {
                    throw new CodegenException(ex, (IObject)lib);
                }
            }
        }
        return codeSegment;
    }

    public ICodeSegment getCustomPostStepCode(ICodeSegment codeSegment) {
        if (this.m_oTransform != null && this.m_oTransform.isCPRStepCodeNeeded() && this.m_oTransform.isCustomRestartSupported()) {
            codeSegment.addSourceCode("\n\n/* Custom Save  */ \n\n");
            this.m_oTransform.getCPRCustomPostStepCode(codeSegment);
        }
        return codeSegment;
    }

    public ICodeSegment getCustomPreStepCode(ICodeSegment codeSegment, ITransform transform) {
        codeSegment.addSourceCode("\n/* Transform-specific checkpoint/restart code */ \n");
        if (transform.isCPRStepCodeNeeded() && transform.isCustomRestartSupported()) {
            transform.getCPRCustomPreStepCode(codeSegment);
        }
        return codeSegment;
    }

    private ICodeSegment getRequiredForRestartInitCode(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("data _null_;\n").indent().addSourceCode("if symget('etlsCPR_pendingID') ne 0 then ").genPutStatement(RB.getStringResource("CheckpointRestart.FlaggedAsRunAlways.txt"), "ETLS_DIAG%QUOTE(:)").unIndent().addSourceCode("run;\n");
        codeSegment.addSourceCode("/* Next step flagged Run Always */\n");
        return codeSegment;
    }

    private ICodeSegment getRequiredForRestartTermCode(ICodeSegment codeSegment) {
        return codeSegment.addSourceCode("/* Previous step is required for restart */\n\n");
    }

    public boolean isJobGenningCPRCode() {
        return this.m_bJobGenningCPRCode;
    }

    public boolean isStepGenningCPRCode() {
        return this.m_bStepGenningCPRCode;
    }

    public boolean isRunAlways() {
        return this.m_oTransform.isRunAlways();
    }

    public IJob getJob() {
        return this.m_oJob;
    }

    public ITransform getTransform() {
        return this.m_oTransform;
    }

    @Override
    public void setCPRMode(String mode) {
        this.m_sCPRMode = mode;
    }

    @Override
    public String getCPRMode() {
        return this.m_sCPRMode;
    }
}

