/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IValidationOperation;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class BaseValidationOperation
extends AbstractPersistableObject
implements IValidationOperation {
    private IDataTransform m_transform;
    private IColumn m_column;
    private IExpression m_expNewValue;
    private String m_sValidationAction;

    public BaseValidationOperation(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public IDataTransform getTransform() {
        return this.m_transform;
    }

    @Override
    public void setTransform(IDataTransform transform) {
        if (transform == null) {
            throw new IllegalArgumentException("a validation operation must have a non-null parent transform");
        }
        if (transform.equals(this.m_transform)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTransformUndoable(this.m_transform, transform));
        }
        this.m_transform = transform;
        this.fireModelChangedEvent("ValidationEvent:TransformChanged", this.m_transform);
    }

    @Override
    public IColumn getColumn() {
        return this.m_column;
    }

    @Override
    public void setColumn(IColumn column) {
        if (!this.isColumnAllowed(column)) {
            return;
        }
        if (column.equals(this.m_column)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetColumnUndoable(this.m_column, column));
        }
        this.m_column = column;
        this.fireModelChangedEvent("ValidationEvent:ColumnChanged", this.m_column);
    }

    @Override
    public IExpression getNewValueExpression() {
        return this.m_expNewValue;
    }

    @Override
    public void setNewValueExpression(IExpression newValue) {
        if (newValue == null && this.m_sValidationAction.equals("ValidationAction:ChangeValueTo")) {
            throw new IllegalArgumentException("the change value action requires a non-null new value");
        }
        if (newValue == null ? this.m_expNewValue == null : newValue.equals(this.m_expNewValue)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNewValueUndoable(this.m_expNewValue, newValue));
        }
        this.m_expNewValue = newValue;
        this.fireModelChangedEvent("ValidationEvent:NewValueChanged", this.m_expNewValue);
    }

    @Override
    public String getValidationAction() {
        return this.m_sValidationAction;
    }

    @Override
    public void setValidationAction(String action) {
        if (!this.isValidationActionSupported(action)) {
            throw new IllegalArgumentException("this operation does not support the action " + action);
        }
        if ("ValidationAction:ChangeValueTo".equals(action) || this.m_expNewValue == null) {
            throw new IllegalArgumentException("the change value action requires a non-null new value");
        }
        if (this.m_sValidationAction.equals(action)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetValidationActionUndoable(this.m_sValidationAction, action));
        }
        this.m_sValidationAction = action;
        this.fireModelChangedEvent("ValidationEvent:ActionChanged", this.m_sValidationAction);
    }

    @Override
    public boolean isColumnsFromSourceAllowed() {
        return true;
    }

    @Override
    public boolean isColumnsFromTargetAllowed() {
        return false;
    }

    @Override
    public boolean isColumnAllowed(IColumn column) {
        if (column == null) {
            throw new IllegalArgumentException("a validation operation must have a non-null column to operate on");
        }
        ITable table = column.getTable();
        if (!this.m_transform.containsInDataSources(table) && !this.m_transform.containsInDataTargets(table)) {
            throw new IllegalArgumentException("the validation column must be in the parent transform's source or target table");
        }
        if (!this.isColumnsFromSourceAllowed() && this.m_transform.containsInDataSources(table)) {
            throw new IllegalArgumentException("this operation cannot be applied to a source column");
        }
        if (!this.isColumnsFromTargetAllowed() && this.m_transform.containsInDataTargets(column.getTable())) {
            throw new IllegalArgumentException("this operation cannot be applied to a target column");
        }
        return true;
    }

    @Override
    public boolean isValidationActionSupported(String action) {
        return "ValidationAction:MoveToErrorTable".equals(action) || "ValidationAction:ChangeValueTo".equals(action) || "ValidationAction:AbortJob".equals(action);
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return null;
    }

    private class SetTransformUndoable
    extends AbstractUndoableEdit {
        private IDataTransform m_oldTransform;
        private IDataTransform m_newTransform;

        public SetTransformUndoable(IDataTransform oldTransform, IDataTransform newTransform) {
            this.m_oldTransform = oldTransform;
            this.m_newTransform = newTransform;
        }

        @Override
        public void undo() {
            super.undo();
            BaseValidationOperation.this.setTransform(this.m_oldTransform);
        }

        @Override
        public void redo() {
            super.redo();
            BaseValidationOperation.this.setTransform(this.m_newTransform);
        }
    }

    private class SetColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_colOld;
        private IColumn m_colNew;

        public SetColumnUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_colOld = oldColumn;
            this.m_colNew = newColumn;
        }

        @Override
        public void undo() {
            super.undo();
            BaseValidationOperation.this.setColumn(this.m_colOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseValidationOperation.this.setColumn(this.m_colNew);
        }
    }

    private class SetNewValueUndoable
    extends AbstractUndoableEdit {
        private IExpression m_expOld;
        private IExpression m_expNew;

        public SetNewValueUndoable(IExpression expOld, IExpression expNew) {
            this.m_expOld = expOld;
            this.m_expNew = expNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseValidationOperation.this.setNewValueExpression(this.m_expOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseValidationOperation.this.setNewValueExpression(this.m_expNew);
        }
    }

    private class SetValidationActionUndoable
    extends AbstractUndoableEdit {
        private String m_sOldAction;
        private String m_sNewAction;

        public SetValidationActionUndoable(String oldAction, String newAction) {
            this.m_sOldAction = oldAction;
            this.m_sNewAction = newAction;
        }

        @Override
        public void undo() {
            super.undo();
            BaseValidationOperation.this.setValidationAction(this.m_sOldAction);
        }

        @Override
        public void redo() {
            super.redo();
            BaseValidationOperation.this.setValidationAction(this.m_sNewAction);
        }
    }
}

