/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IFolder;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.AbstractPrimaryModelList;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IDataObjectPlacements;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.IUIPlacement;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.AbstractPrePostCodeContainer;
import com.sas.etl.models.job.impl.CheckpointRestart;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.DataObjectPlacements;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.impl.UIPlacement;
import com.sas.etl.models.job.impl.UIPlacementUtil;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BasePromptModel;
import com.sas.etl.models.prompts.impl.BasePromptModelListener;
import com.sas.etl.models.prompts.impl.BasePromptValueChangedListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class BaseJob
extends AbstractPrePostCodeContainer
implements IJob {
    private static final String CONTROL_ORDER_NAME = "ControlOrder";
    private static final String OPTIONS_PROPERTYSET = "OPTIONS";
    private static final String DATAOBJECT_PLACEMENT_PROPERTYSET = "DATAOBJECTPLACEMENT";
    private static final String PLACEMENT_PROPERTY_NAME = "PLACEMENT_";
    private static final String OPTION_USENLSDATEFORMAT = "USENLSDATEFORMAT";
    private static final String OPTION_SYSTEMOPTIONS = "SystemOptions";
    private static final String OPTION_METADATA_MACRO_VARIABLES = "MACROS";
    private static final String OPTION_PARALLEL_MACROS = "PARALLEL";
    private static final String OPTION_STATUS_HANDLINGLAST = "STATUSHANDLINGLAST";
    private static final String OPTION_MAPPING_WARNING = "GenerateMappingWarning";
    private static final String OPTION_CHECKPOINT_STATE_LIBRARY = "STATELIBRARY";
    private static final String OPTION_DISABLE_CHECKPOINTS = "DISABLECHECKPOINT";
    private static final String OPTION_ALTERNATE_TEMPORARY_LIBARY = "ALT_TEMP_LIBRARY";
    private static final String OPTION_DELETE_ALTERNATE_TEMPORARY_TABLES = "DELETE_ALT_TEMP_TABLES";
    private static final String OPTION_GENERATE_JOB_FORMATS_INFORMATS = "GENERATEJOBFORMATSINFORMATS";
    private static final String OPTION_GENERATE_JOB_USE_CONNECT_USING = "GENERATEJOBUSECONNECTUSING";
    private static final String OPTION_COMMENT_STPBEGIN_STPEND = "COMMENT_STPBEGIN_STPEND";
    private static final String OPTION_RCSET_SYSCC = "RCSETSYSCC";
    private static final String OPTION_CLEAR_LIBREF = "CLEARLIBREF";
    private static final String YES = "YES";
    private static final String NO = "NO";
    private static final String OPTION_STORED_PROCESS_PRE_CODE = "STP_PRECODE";
    private static final String COLLECT_DIAGNOSTICS = "CollectDiagnostics";
    private static final String COLLECT_STATISTICS = "CollectStatistics";
    private static final String COLLECT_TABLE_STATISTICS = "CollectTableStatistics";
    private static final String COLLECT_STATISTICS_APPLNAME = "APPLNAME";
    private static final String STATS_DEFAULT_APPLNAME = "SAS Data Integration Studio";
    private static final String MAP_AUTOMATICALLY = "MapAutomatically";
    private static final String PROPAGATE_AUTOMATICALLY = "PropagateAutomatically";
    private static final String AUTOMATIC_PROPAGATION_DIRECTION = "AutomaticPropagationDirection";
    private IPromptModel m_optionModel;
    private String m_sStoredProcessPreCode;
    private ModelList m_lTransforms;
    private ModelList m_lOrderedTransforms;
    private ModelList m_lDataObjects;
    private ModelList m_lInputJobPorts;
    private ModelList m_lOutputJobPorts;
    private List m_lCleanedUpObjects;
    private List m_lBadTransformationSteps;
    private List<String> m_lMissingDataObjects;
    private List<String> m_lErrorLoadingTransforms;
    private Map<IDataObject, IDataObjectPlacements> m_mDataObjectPlacement;
    private Map<IDataObject, IDataObjectPlacements> m_mDeletedDataObjectPlacements;
    private List<IDataObjectPlacements> m_lDataObjectsUIRemoved;
    private boolean m_bCodeGenerationEnabled;
    private boolean m_bCollectDiagnostics;
    private boolean m_bCollectStatistics;
    private boolean m_bCollectTableStatistics;
    private boolean m_bMapAutomatically;
    private boolean m_bPropagateAutomatically;
    private int m_eAutomaticPropagationDirection;
    private String m_sActivityID;
    private String m_sApplName;
    private IUserWrittenCodeContainer m_codeUserWritten;
    private String m_sSystemOptions;
    private boolean m_bGenerateMetadataMacroVariables;
    private boolean m_bGenerateParallelMacros;
    private boolean m_bGenerateStatusHandlingLast;
    private boolean m_bUseNLSDateFormat;
    private boolean m_bRCSetSYSCCEnabled;
    private ILibrary m_checkpointStateLibrary;
    private boolean m_bDisableCheckpoints;
    private ILibrary m_alternateTemporaryLibrary;
    private boolean m_bGenerateFormat;
    private boolean m_bUseConnectUsing;
    private IServer m_executionServer;
    private boolean m_bGenerateDISHeaderAndFooters;
    private List m_lTransformsToSkip;
    private boolean m_bWarningOnMapping;
    private boolean m_bDeleteAltTempTables;
    private boolean m_bRestartPending;
    private boolean m_bClearLibref;
    private boolean m_bCommentStpbeginStpendMacros;
    private Double m_dVersion;
    private List m_lSameNames = new ArrayList();
    private List m_lProps = new ArrayList();

    public BaseJob(String sID, IModel model) {
        super(sID, model);
        this.m_mDeletedDataObjectPlacements = new HashMap<IDataObject, IDataObjectPlacements>();
        this.m_lTransforms = new TransformsList();
        this.m_lOrderedTransforms = new ModelList(this, new String[]{"Job:TransformAddedToExecutionOrder", "Job:TransformRemovedFromExecutionOrder"}, 0, ITransform.class);
        this.m_lDataObjects = new ModelList(this, new String[]{"Job:DataObjectAdded", "Job:DataObjectRemoved"}, 2);
        this.m_lDataObjects.setAddFilter(new DataObjectsAddFilter());
        this.m_lInputJobPorts = new ModelList(this, new String[]{"Job:InputJobPortAdded", "Job:InputJobPortRemoved"}, 0, IDataObject.class);
        this.m_lOutputJobPorts = new ModelList(this, new String[]{"Job:OutputJobPortAdded", "Job:OutputJobPortRemoved"}, 0, IDataObject.class);
        this.m_bCodeGenerationEnabled = true;
        this.m_lDataObjectsUIRemoved = new ArrayList<IDataObjectPlacements>();
        this.m_mDataObjectPlacement = new HashMap<IDataObject, IDataObjectPlacements>();
        this.m_lMissingDataObjects = new ArrayList<String>();
        this.m_lErrorLoadingTransforms = new ArrayList<String>();
        this.m_lCleanedUpObjects = new ArrayList();
        this.m_lTransformsToSkip = new ArrayList();
        this.m_lBadTransformationSteps = new ArrayList();
        this.createConditionActionSetTemplates();
        this.m_bUseNLSDateFormat = true;
        this.m_sSystemOptions = "";
        this.m_bGenerateMetadataMacroVariables = true;
        this.m_bGenerateParallelMacros = false;
        this.m_bGenerateStatusHandlingLast = true;
        this.m_bDisableCheckpoints = false;
        this.m_bWarningOnMapping = true;
        this.m_eAutomaticPropagationDirection = 0;
        this.m_codeUserWritten = model.getObjectFactory().createUserWrittenHelper(this);
        this.m_codeUserWritten.setContainerId(sID);
        this.m_codeUserWritten.setContainerOMRType(this.getOMRType());
        this.m_codeUserWritten.setActiveFlagLocation(2);
        this.m_bGenerateDISHeaderAndFooters = true;
        this.m_bDeleteAltTempTables = true;
        this.m_bGenerateFormat = true;
        this.m_bUseConnectUsing = false;
        this.m_bClearLibref = false;
        this.m_bCommentStpbeginStpendMacros = false;
        this.m_bRCSetSYSCCEnabled = false;
        this.m_sApplName = STATS_DEFAULT_APPLNAME;
        try {
            this.getOptionModel();
        }
        catch (FileNotFoundException e) {
            ModelLogger.getDefaultLogger().debug((Object)"FileNotFoundException", (Throwable)e);
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().debug((Object)"RemoteException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().debug((Object)"ServiceException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().debug((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().debug((Object)"IOException", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().debug((Object)"ParserConfigurationException", (Throwable)e);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().debug((Object)"SAXException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().debug((Object)"MdException", (Throwable)e);
        }
    }

    @Override
    public List getCleanedUpObjects() {
        return this.m_lCleanedUpObjects;
    }

    @Override
    public ITransform[] getTransforms() {
        return (ITransform[])this.m_lTransforms.toArray(new ITransform[this.m_lTransforms.size()]);
    }

    @Override
    public List getTransformsList() {
        return this.m_lTransforms;
    }

    @Override
    public List getTransformsToSkipList() {
        return this.m_lTransformsToSkip;
    }

    @Override
    public ITransform[] getControlOrderedTransforms() {
        return (ITransform[])this.m_lOrderedTransforms.toArray(new ITransform[this.m_lOrderedTransforms.size()]);
    }

    @Override
    public ITransform[] getControlOrderedTransformsAndOthers() {
        Object[] aTransforms = new ITransform[this.m_lTransforms.size()];
        this.m_lOrderedTransforms.toArray(aTransforms);
        int iInsert = this.m_lOrderedTransforms.size();
        for (int iTransform = 0; iTransform < this.m_lTransforms.size(); ++iTransform) {
            ITransform xfm = (ITransform)this.m_lTransforms.get(iTransform);
            if (this.m_lOrderedTransforms.contains(xfm)) continue;
            aTransforms[iInsert++] = xfm;
        }
        return aTransforms;
    }

    @Override
    public List getControlOrderedTransformsList() {
        return this.m_lOrderedTransforms;
    }

    @Override
    public Double getDISVersion() {
        return this.m_dVersion == null ? Workspace.getWorkspace().getApplicationVersionNumber() : this.m_dVersion.doubleValue();
    }

    @Override
    public void setDISVersion(Double version) {
        this.m_dVersion = version;
    }

    @Override
    public List getInvalidTransformationStepsList() {
        return this.m_lBadTransformationSteps;
    }

    @Override
    public List<String> getMissingDataObject() {
        return this.m_lMissingDataObjects;
    }

    @Override
    public List<String> getTransformNamesCleanedUp() {
        return this.m_lErrorLoadingTransforms;
    }

    @Override
    public void addAllUnorderedTransformsToControlOrder() {
        this.startCompoundUndoable();
        try {
            for (int iTransform = 0; iTransform < this.m_lTransforms.size(); ++iTransform) {
                ITransform xfm = (ITransform)this.m_lTransforms.get(iTransform);
                if (this.m_lOrderedTransforms.contains(xfm)) continue;
                this.m_lOrderedTransforms.add(xfm);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void dispose() {
        if (this.m_optionModel != null) {
            this.m_optionModel.dispose();
        }
        super.dispose();
    }

    @Override
    public Map<IDataObject, IDataObjectPlacements> getDataObjectsPlacement() {
        return this.m_mDataObjectPlacement;
    }

    private void loadTablePlacement(OMRAdapter omr) throws MdException, RemoteException {
        PropertySet mdoSet = this.findPropertySet(omr, omr.acquireOMRObject(this), DATAOBJECT_PLACEMENT_PROPERTYSET, 0);
        if (mdoSet == null) {
            return;
        }
        AssociationList lProperties = mdoSet.getSetProperties();
        for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
            Property mdoProperty = (Property)lProperties.get(iProperty);
            this.loadOptionWithCustomListFromOMR(omr, DATAOBJECT_PLACEMENT_PROPERTYSET, mdoProperty.getName(), "");
            CustomAssociation assoc = (CustomAssociation)mdoProperty.getCustomAssociations().get(0);
            String value = mdoProperty.getDefaultValue();
            DataObjectPlacements placements = UIPlacementUtil.createDataObjectPlacementsFromXML(value);
            placements.setChanged(false);
            if (assoc != null && !assoc.getAssociatedObjects().isEmpty()) {
                if (assoc.getAssociatedObjects().get(0) == null) continue;
                IPersistableObject object = (IPersistableObject)omr.getObject((Root)assoc.getAssociatedObjects().get(0));
                if (object != null && this.getDataObjectsList().contains(object)) {
                    IDataObject data = (IDataObject)this.getDataObjectsList().get(this.getDataObjectsList().indexOf(object));
                    this.m_mDataObjectPlacement.put(data, placements);
                    continue;
                }
                this.getMissingDataObject().add(placements.getDataObjectName());
                this.m_lDataObjectsUIRemoved.add(placements);
                this.setCleanUpRequired();
                continue;
            }
            this.getMissingDataObject().add(placements.getDataObjectName());
            this.m_lDataObjectsUIRemoved.add(placements);
            this.setCleanUpRequired();
        }
        if (mdoSet != null) {
            List lSameNameObjects = this.findSameNamePropertySetsObjects(omr, omr.acquireOMRObject(this), DATAOBJECT_PLACEMENT_PROPERTYSET, 0);
            lSameNameObjects.remove(mdoSet);
            for (int iPropertySet = 0; iPropertySet < lSameNameObjects.size(); ++iPropertySet) {
                PropertySet ps = (PropertySet)lSameNameObjects.get(iPropertySet);
                this.m_lSameNames.add(ps.getFQID());
                AssociationList props = ps.getSetProperties();
                for (int iProperty = 0; iProperty < props.size(); ++iProperty) {
                    Property prop = (Property)props.get(iProperty);
                    this.m_lProps.add(prop.getFQID());
                }
            }
        }
    }

    protected IDataObject[] getTablePlacementKeys() {
        if (this.m_mDataObjectPlacement == null) {
            return new IDataObject[0];
        }
        Set<IDataObject> keys = this.m_mDataObjectPlacement.keySet();
        return keys.toArray(new IDataObject[keys.size()]);
    }

    public void saveTablePlacementToOMR(OMRAdapter omr) throws MdException, RemoteException {
        String sFQID;
        int iRemoved;
        IDataObjectPlacements placements;
        IDataObject[] aKeys = this.getTablePlacementKeys();
        for (int iKey = 0; iKey < aKeys.length; ++iKey) {
            IPersistableObject[] iPersistableObjectArray;
            IDataObject odata = aKeys[iKey];
            placements = this.m_mDataObjectPlacement.get(odata);
            if (placements == null) continue;
            String xml = UIPlacementUtil.createXMLFromDataObjectPlacements(placements);
            if (odata == null) {
                iPersistableObjectArray = new IPersistableObject[]{};
            } else {
                IPersistableObject[] iPersistableObjectArray2 = new IPersistableObject[1];
                iPersistableObjectArray = iPersistableObjectArray2;
                iPersistableObjectArray2[0] = odata;
            }
            IPersistableObject[] aObjects = iPersistableObjectArray;
            if (this.m_lDataObjectsUIRemoved.indexOf(placements) == -1) {
                this.saveOptionWithCustomListToOMR(omr, DATAOBJECT_PLACEMENT_PROPERTYSET, PLACEMENT_PROPERTY_NAME + placements.getDataObjectName(), xml, aObjects);
            }
            List<UIPlacement> places = placements.getUIPlacements();
            for (int iChanged = 0; iChanged < places.size(); ++iChanged) {
                places.get(iChanged).setChanged(false);
            }
        }
        for (IDataObject next : this.m_mDeletedDataObjectPlacements.keySet()) {
            placements = this.m_mDeletedDataObjectPlacements.get(next);
            this.deletePropertyFromOMR(omr, DATAOBJECT_PLACEMENT_PROPERTYSET, PLACEMENT_PROPERTY_NAME + placements.getDataObjectName());
        }
        this.m_mDeletedDataObjectPlacements.clear();
        for (iRemoved = 0; iRemoved < this.m_lDataObjectsUIRemoved.size(); ++iRemoved) {
            placements = this.m_lDataObjectsUIRemoved.get(iRemoved);
            this.deletePropertyFromOMR(omr, DATAOBJECT_PLACEMENT_PROPERTYSET, PLACEMENT_PROPERTY_NAME + placements.getDataObjectName());
        }
        this.m_lDataObjectsUIRemoved.clear();
        if (this.m_lProps != null && this.m_lProps.size() > 0) {
            for (iRemoved = 0; iRemoved < this.m_lProps.size(); ++iRemoved) {
                sFQID = (String)this.m_lProps.get(iRemoved);
                omr.deleteOMRObject(sFQID, "Property");
            }
            this.m_lProps.clear();
        }
        if (this.m_lSameNames != null && this.m_lSameNames.size() > 0) {
            for (iRemoved = 0; iRemoved < this.m_lSameNames.size(); ++iRemoved) {
                sFQID = (String)this.m_lSameNames.get(iRemoved);
                omr.deleteOMRObject(sFQID, "PropertySet");
            }
            this.m_lSameNames.clear();
        }
    }

    @Override
    public boolean removeDataObjectUIPlacement(IDataObject data, IUIPlacement placement) {
        boolean bRemoved = false;
        Map<IDataObject, IDataObjectPlacements> placements = this.getDataObjectsPlacement();
        IDataObjectPlacements places = placements.get(data);
        for (int iPlacement = 0; iPlacement < places.getUIPlacements().size(); ++iPlacement) {
            IUIPlacement UIPlace = places.getUIPlacements().get(iPlacement);
            if (UIPlace != placement) continue;
            places.getUIPlacements().remove(iPlacement);
            if (places.getUIPlacements().isEmpty()) {
                this.m_mDeletedDataObjectPlacements.put(data, places);
                placements.remove(data);
            }
            bRemoved = true;
        }
        return bRemoved;
    }

    @Override
    public boolean addUIPlacemnentToJob(IDataObject data, IUIPlacement placement) {
        Map<IDataObject, IDataObjectPlacements> placements;
        IDataObjectPlacements places;
        boolean bAdded = true;
        IDataObjectPlacements deletedPlacements = this.m_mDeletedDataObjectPlacements.get(data);
        if (deletedPlacements != null) {
            this.getDataObjectsPlacement().put(data, deletedPlacements);
            this.m_mDeletedDataObjectPlacements.remove(data);
        }
        if (placement == null) {
            placement = new UIPlacement();
        }
        if ((places = (placements = this.getDataObjectsPlacement()).get(data)) == null && !(data instanceof IWorkTable)) {
            places = new DataObjectPlacements();
            places.setDataObjectName(data.getID());
            this.getDataObjectsPlacement().put(data, places);
            places.getUIPlacements().add((UIPlacement)placement);
        } else if (places != null) {
            for (int iPlace = 0; iPlace < places.getUIPlacements().size(); ++iPlace) {
                IUIPlacement UIPlace = places.getUIPlacements().get(iPlace);
                if (!UIPlace.getNodeId().equals(placement.getNodeId())) continue;
                bAdded = false;
            }
            if (bAdded) {
                places.getUIPlacements().add((UIPlacement)placement);
            }
        }
        return bAdded;
    }

    @Override
    public final IPromptModel getOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServiceException, ServerConnectionException {
        if (this.m_optionModel == null) {
            this.m_optionModel = this.createOptionModel();
        }
        this.m_optionModel.updateModelValues();
        return this.m_optionModel;
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETJOBSTATUS");
    }

    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServiceException, ServerConnectionException {
        return new cJobOptionModel(this.getModel(), this);
    }

    @Override
    public boolean isGenerateDISHeaderAndFooters() {
        return this.m_bGenerateDISHeaderAndFooters;
    }

    @Override
    public void setGenerateDISHeaderAndFooters(boolean generateHeaderFooters) {
        if (this.m_bGenerateDISHeaderAndFooters == generateHeaderFooters) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGenerateDISHeaderAndFooters(this.m_bGenerateDISHeaderAndFooters, generateHeaderFooters));
        }
        this.m_bGenerateDISHeaderAndFooters = generateHeaderFooters;
        this.setPreProcessEnabled(this.m_bGenerateDISHeaderAndFooters);
        this.setPostProcessEnabled(this.m_bGenerateDISHeaderAndFooters);
        this.fireModelChangedEvent("ICodeGenerator:GenerateDISHeaderAndFootersChanged", null);
    }

    @Override
    public IDataObject[] getInputJobPorts() {
        return (IDataObject[])this.m_lInputJobPorts.toArray(new IDataObject[this.m_lInputJobPorts.size()]);
    }

    @Override
    public IDataObject[] getOutputJobPorts() {
        return (IDataObject[])this.m_lOutputJobPorts.toArray(new IDataObject[this.m_lOutputJobPorts.size()]);
    }

    @Override
    public List getInputJobPortsList() {
        return this.m_lInputJobPorts;
    }

    @Override
    public List getOutputJobPortsList() {
        return this.m_lOutputJobPorts;
    }

    @Override
    public void setMapAutomatically(boolean bMapAutomatically) {
        if (this.m_bMapAutomatically == bMapAutomatically) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMapAutomaticallyUndoable(this.m_bMapAutomatically, bMapAutomatically));
        }
        this.m_bMapAutomatically = bMapAutomatically;
        this.fireModelChangedEvent("IJob:MapAutomaticallyChanged", null);
    }

    @Override
    public boolean isMappingAutomatically() {
        return this.m_bMapAutomatically;
    }

    @Override
    public void setPropagateAutomatically(boolean bPropagateAutomatically) {
        if (this.m_bPropagateAutomatically == bPropagateAutomatically) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPropagateAutomaticallyUndoable(this.m_bPropagateAutomatically, bPropagateAutomatically));
        }
        this.m_bPropagateAutomatically = bPropagateAutomatically;
        this.fireModelChangedEvent("IJob:PropagateAutomaticallyChanged", null);
    }

    @Override
    public boolean isPropagatingAutomatically() {
        return this.m_bPropagateAutomatically;
    }

    @Override
    public void setAutomaticPropagationDirection(int eDirection) {
        if (this.m_eAutomaticPropagationDirection == eDirection) {
            return;
        }
        if (eDirection != 0 && eDirection != 1) {
            throw new IllegalArgumentException("Invalid value for automatic propagation direction");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAutomaticPropagationDirectionUndoable(this.m_eAutomaticPropagationDirection, eDirection));
        }
        this.m_eAutomaticPropagationDirection = eDirection;
        this.fireModelChangedEvent("IJob:AutomaticPropagationDirectionChanged", null);
    }

    @Override
    public int getAutomaticPropagationDirection() {
        return this.m_eAutomaticPropagationDirection;
    }

    @Override
    public void setCollectDiagnostics(boolean bCollectDiagnostics) {
        if (this.m_bCollectDiagnostics == bCollectDiagnostics) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCollectDiagnosticsUndoable(this.m_bCollectDiagnostics, bCollectDiagnostics));
        }
        this.m_bCollectDiagnostics = bCollectDiagnostics;
        this.fireModelChangedEvent("IJob:CollectDiagnosticsChanged", null);
    }

    @Override
    public boolean isCollectingDiagnostics() {
        return this.m_bCollectDiagnostics;
    }

    @Override
    public void setCollectStatistics(boolean bCollectStatistics) {
        if (this.m_bCollectStatistics == bCollectStatistics) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (!bCollectStatistics) {
                this.setCollectTableStatistics(false);
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetCollectStatisticsUndoable(this.m_bCollectStatistics, bCollectStatistics));
            }
            this.m_bCollectStatistics = bCollectStatistics;
            this.fireModelChangedEvent("IJob:CollectStatisticsChanged", null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isCollectingStatistics() {
        return this.m_bCollectStatistics;
    }

    @Override
    public void setCollectTableStatistics(boolean bCollectTableStatistics) {
        if (this.m_bCollectTableStatistics == bCollectTableStatistics) {
            return;
        }
        if (!this.m_bCollectStatistics && bCollectTableStatistics) {
            throw new IllegalStateException("Collecting statistics must be true before collect table statistics can be made true");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCollectTableStatisticsUndoable(this.m_bCollectTableStatistics, bCollectTableStatistics));
        }
        this.m_bCollectTableStatistics = bCollectTableStatistics;
        this.fireModelChangedEvent("IJob:CollectTableStatisticsChanged", null);
    }

    @Override
    public boolean isCollectingTableStatistics() {
        return this.m_bCollectTableStatistics;
    }

    @Override
    public boolean isSendJobStatusEnabled() {
        IConditionActionSet[] conditionActions = this.getConditionActionSets();
        for (int i = 0; i < conditionActions.length; ++i) {
            if (!"DIS_SETJOBSTATUS".equals(conditionActions[i].getUniqueIdentifier())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDataObject[] getDataObjects() {
        return (IDataObject[])this.m_lDataObjects.toArray(new IDataObject[this.m_lDataObjects.size()]);
    }

    @Override
    public List getDataObjectsList() {
        return this.m_lDataObjects;
    }

    @Override
    public IServer getExecutionServer() {
        return this.m_executionServer;
    }

    @Override
    public void setExecutionServer(IServer server) {
        if (this.m_executionServer == server) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExecutionServerUndoable(this.m_executionServer, server));
        }
        this.m_executionServer = server;
        this.fireModelChangedEvent("IJob:ExecutionServerChanged", this.m_executionServer);
    }

    @Override
    public String getSystemOptions() {
        return this.m_sSystemOptions;
    }

    @Override
    public void setSystemOptions(String systemOptions) {
        if (this.m_sSystemOptions.equals(systemOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SystemOptionsUndoable(this.m_sSystemOptions, systemOptions));
        }
        this.m_sSystemOptions = systemOptions;
        this.fireModelChangedEvent("IJob:SystemOptionsChanged", null);
    }

    @Override
    public boolean isGeneratingMetadataMacroVariables() {
        return this.m_bGenerateMetadataMacroVariables;
    }

    @Override
    public void setGenerateMetadataMacroVariables(boolean metadataMacroVariables) {
        if (this.m_bGenerateMetadataMacroVariables == metadataMacroVariables) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new GenerateJobMacrosUndoable(this.m_bGenerateMetadataMacroVariables, metadataMacroVariables));
        }
        this.m_bGenerateMetadataMacroVariables = metadataMacroVariables;
        this.fireModelChangedEvent("IJob:GenerateMetadataMacroVariablesChanged", null);
    }

    @Override
    public boolean isGeneratingParallelMacros() {
        return this.m_bGenerateParallelMacros;
    }

    @Override
    public void setGenerateParallelMacros(boolean bGenerateParallelMacros) {
        if (this.m_bGenerateParallelMacros == bGenerateParallelMacros) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new GenerateParallelMacrosUndoable(this.m_bGenerateParallelMacros, bGenerateParallelMacros));
        }
        this.m_bGenerateParallelMacros = bGenerateParallelMacros;
        this.fireModelChangedEvent("IJob:GenerateParallelMacrosChanged", null);
    }

    @Override
    public boolean isRCSetSYSCCEnabled() {
        return this.m_bRCSetSYSCCEnabled;
    }

    @Override
    public void setRCSetSYSCCEnabled(boolean bRCSetSYSCCEnabled) {
        if (this.m_bRCSetSYSCCEnabled == bRCSetSYSCCEnabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRCSetSYSCCEnabledUndoable(this.m_bRCSetSYSCCEnabled, bRCSetSYSCCEnabled));
        }
        this.m_bRCSetSYSCCEnabled = bRCSetSYSCCEnabled;
        this.fireModelChangedEvent("IJob:RCSetSYSCCChanged", null);
    }

    @Override
    public boolean isGeneratingStatusHandlingLast() {
        return this.m_bGenerateStatusHandlingLast;
    }

    @Override
    public void setGenerateStatusHandlingLast(boolean generateStatusHandlingLast) {
        if (this.m_bGenerateStatusHandlingLast == generateStatusHandlingLast) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new GenerateStatusHandlingLastUndoable(this.m_bGenerateStatusHandlingLast, generateStatusHandlingLast));
        }
        this.m_bGenerateStatusHandlingLast = generateStatusHandlingLast;
        this.fireModelChangedEvent("IJob:GenerateStatusHandlingLastChanged", null);
    }

    @Override
    public boolean isGenerateWarningOnMapping() {
        return this.m_bWarningOnMapping;
    }

    @Override
    public void setGenerateWarningOnMapping(boolean bWarningOnMapping) {
        if (this.m_bWarningOnMapping == bWarningOnMapping) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetWarningOnMappingTruncationUndoable(this.m_bWarningOnMapping, bWarningOnMapping));
        }
        this.m_bWarningOnMapping = bWarningOnMapping;
        this.fireModelChangedEvent("IJob:WarningOnMappingChanged", null);
    }

    @Override
    public boolean isDeletingAlternateTemporaryTables() {
        return this.m_bDeleteAltTempTables;
    }

    @Override
    public void setDeleteAlternateTemporaryTables(boolean bDeleteTempTables) {
        if (bDeleteTempTables == this.m_bDeleteAltTempTables) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDeleteAlternateTemporaryTablesUndoable(this.m_bDeleteAltTempTables, bDeleteTempTables));
        }
        this.m_bDeleteAltTempTables = bDeleteTempTables;
        this.fireModelChangedEvent("IJob:DeleteAlternateTempTablesChanged", null);
    }

    @Override
    public boolean isUsingNLSDateFormat() {
        return this.m_bUseNLSDateFormat;
    }

    @Override
    public void setUseNLSDateFormat(boolean bUseNLSDateFormat) {
        if (this.m_bUseNLSDateFormat == bUseNLSDateFormat) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseNLSDateUndoable(this.m_bUseNLSDateFormat, bUseNLSDateFormat));
        }
        this.m_bUseNLSDateFormat = bUseNLSDateFormat;
        this.fireModelChangedEvent("IJob:UseNLSDateChanged", null);
    }

    @Override
    public String getApplName() {
        return this.m_sApplName;
    }

    @Override
    public void setApplName(String sApplName) {
        if (this.m_sApplName == sApplName) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetApplNameUndoable(this.m_sApplName, sApplName));
        }
        this.m_sApplName = sApplName;
        if (this.m_sApplName == null) {
            this.m_sApplName = STATS_DEFAULT_APPLNAME;
        }
        this.fireModelChangedEvent("IJob:StatisticsApplNameChanged", null);
    }

    @Override
    public boolean isUsingUserWrittenCode() {
        return this.m_codeUserWritten.isActive();
    }

    @Override
    public void setUseUserWrittenCode(boolean bUseUserWrittenCode) {
        this.m_codeUserWritten.setIsActive(bUseUserWrittenCode);
    }

    @Override
    public ILibrary getAlternateTemporaryLibrary() {
        return this.m_alternateTemporaryLibrary;
    }

    @Override
    public void setAlternateTemporaryLibrary(ILibrary altLibrary) {
        this.setAlternateTemporaryLibrary(altLibrary, true);
    }

    public void setAlternateTemporaryLibrary(ILibrary altLibrary, boolean changeWorkTables) {
        if (this.m_alternateTemporaryLibrary == altLibrary) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAlternateTemporaryLibraryUndoable(this.m_alternateTemporaryLibrary, altLibrary));
        }
        this.m_alternateTemporaryLibrary = altLibrary;
        this.setAlternateWorkTableLibrary();
        this.fireModelChangedEvent("IJob:AlternateTempLibraryChanged", this.m_alternateTemporaryLibrary);
    }

    @Override
    public void setFormatInformatGenerationEnabled(boolean enabled) {
        if (enabled == this.m_bGenerateFormat) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFormatInformatGenerationEnabledUndoable(this.m_bGenerateFormat, enabled));
        }
        this.m_bGenerateFormat = enabled;
        this.fireModelChangedEvent("IJob:GenerateJOBFORMATINFORMATChanged", null);
    }

    @Override
    public boolean isFormatInformatGenerationEnabled() {
        return this.m_bGenerateFormat;
    }

    @Override
    public void setConnectUsingEnabled(boolean enabled) {
        if (enabled == this.m_bUseConnectUsing) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetConnectUsingEnabledUndoable(this.m_bUseConnectUsing, enabled));
        }
        this.m_bUseConnectUsing = enabled;
        this.fireModelChangedEvent("IJob:GenerateJOBUSECONNECTUSINGChanged", null);
    }

    @Override
    public boolean isConnectUsingEnabled() {
        return this.m_bUseConnectUsing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAlternateWorkTableLibrary() {
        this.startCompoundUndoable();
        try {
            ITransform[] trns = this.getControlOrderedTransformsAndOthers();
            for (int i = 0; i < trns.length; ++i) {
                if (!(trns[i] instanceof IDataTransform)) continue;
                IDataTransform dTransform = (IDataTransform)trns[i];
                IDataObject[] targets = dTransform.getDataTargets();
                for (int j = 0; j < targets.length; ++j) {
                    if (!(targets[j] instanceof IWorkTable)) continue;
                    ((IWorkTable)targets[j]).setAlternateJobLibrary(this.getAlternateTemporaryLibrary());
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isDisableCheckpoints() {
        return this.m_bDisableCheckpoints;
    }

    @Override
    public void setDisableCheckpoints(boolean enabled) {
        if (this.m_bDisableCheckpoints == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCheckpointEnabledUndoable(this.m_bDisableCheckpoints, enabled));
        }
        this.m_bDisableCheckpoints = enabled;
        this.fireModelChangedEvent("IJob:DisableCheckpointsChanged", null);
    }

    @Override
    public ILibrary getCheckpointStateLibrary() {
        return this.m_checkpointStateLibrary;
    }

    @Override
    public void setCheckpointStateLibrary(ILibrary stateLibrary) {
        if (this.m_checkpointStateLibrary == stateLibrary) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCheckpointStateLibraryUndoable(this.m_checkpointStateLibrary, stateLibrary));
        }
        this.m_checkpointStateLibrary = stateLibrary;
        this.fireModelChangedEvent("IJob:CheckpointStateLibraryChanged", this.m_checkpointStateLibrary);
    }

    private void setCleanUpRequired() {
        boolean bSupported = this.isUndoSupported();
        this.getModel().setUndoSupported(true);
        this.undoableEditHappened(new SetCleanUpRequiredUndoable());
        this.getModel().setUndoSupported(bSupported);
    }

    @Override
    public IUserWrittenCodeContainer getUserWrittenCode() {
        return this.m_codeUserWritten;
    }

    @Override
    public void setUserWrittenCode(ICodeSource code) {
        this.m_codeUserWritten.setUserWrittenSourceCode(code);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        for (int iTransform = 0; iTransform < this.m_lTransforms.size(); ++iTransform) {
            ((ITransform)this.m_lTransforms.get(iTransform)).deleteFromOMR(omr);
        }
        if (this.m_sActivityID != null) {
            omr.deleteOMRObject(this.m_sActivityID, "TransformationActivity");
        }
        this.m_codeUserWritten.deleteFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] iPersistableObjectArray;
        IPersistableObject[] iPersistableObjectArray2;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        if (this.m_sActivityID == null) {
            this.m_sActivityID = this.createIDForNewObject();
        }
        Job mdoJob = (Job)omr.acquireOMRObject(this);
        mdoJob.setIsActive(this.isCodeGenerationEnabled() ? 1 : 0);
        this.m_codeUserWritten.saveToOMR(omr);
        TransformationActivity mdoTA = (TransformationActivity)omr.acquireOMRObject(this.m_sActivityID, "TransformationActivity");
        mdoTA.setName("New Transformation Activity");
        AssociationList lActivities = mdoJob.getJobActivities(false);
        lActivities.clear();
        lActivities.add(mdoTA);
        AssociationList lSteps = mdoTA.getSteps(false);
        lSteps.clear();
        for (int iTransform = 0; iTransform < this.m_lTransforms.size(); ++iTransform) {
            ITransform transform = (ITransform)this.m_lTransforms.get(iTransform);
            transform.saveToOMR(omr);
            lSteps.add(omr.acquireOMRObject(transform));
        }
        this.m_lDataObjects.saveToOMR(omr, (List)mdoTA.getTransformationTargets(false));
        mdoJob.getCustomAssociations(false).clear();
        this.saveCustomListToOMR(omr, CONTROL_ORDER_NAME, this.getControlOrderedTransforms());
        this.saveBooleanOptionToOMR(omr, COLLECT_DIAGNOSTICS, this.m_bCollectDiagnostics);
        this.saveBooleanOptionToOMR(omr, COLLECT_STATISTICS, this.m_bCollectStatistics);
        this.saveBooleanOptionToOMR(omr, COLLECT_TABLE_STATISTICS, this.m_bCollectTableStatistics);
        this.saveBooleanOptionToOMR(omr, MAP_AUTOMATICALLY, this.m_bMapAutomatically);
        this.saveBooleanOptionToOMR(omr, PROPAGATE_AUTOMATICALLY, this.m_bPropagateAutomatically);
        this.saveBooleanOptionToOMR(omr, "GenerateDISHeaderFooter", this.m_bGenerateDISHeaderAndFooters);
        this.saveIntOptionToOMR(omr, AUTOMATIC_PROPAGATION_DIRECTION, this.m_eAutomaticPropagationDirection);
        this.saveBooleanOptionToOMR(omr, OPTION_DELETE_ALTERNATE_TEMPORARY_TABLES, this.isDeletingAlternateTemporaryTables());
        this.saveStringOptionToOMR(omr, OPTION_STORED_PROCESS_PRE_CODE, this.getStoredProcessPreCode());
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_SYSTEMOPTIONS, OPTION_SYSTEMOPTIONS, OPTION_SYSTEMOPTIONS, this.getSystemOptions(), 12, 2);
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_METADATA_MACRO_VARIABLES, OPTION_METADATA_MACRO_VARIABLES, OPTION_METADATA_MACRO_VARIABLES, this.isGeneratingMetadataMacroVariables() ? YES : NO, 12, 2);
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_PARALLEL_MACROS, OPTION_PARALLEL_MACROS, OPTION_PARALLEL_MACROS, this.isGeneratingParallelMacros() ? YES : NO, 12, 2);
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_STATUS_HANDLINGLAST, OPTION_STATUS_HANDLINGLAST, OPTION_STATUS_HANDLINGLAST, this.isGeneratingStatusHandlingLast() ? YES : NO, 12, 2);
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_USENLSDATEFORMAT, OPTION_USENLSDATEFORMAT, OPTION_USENLSDATEFORMAT, this.isUsingNLSDateFormat() ? YES : NO, 12, 2);
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_MAPPING_WARNING, OPTION_MAPPING_WARNING, OPTION_MAPPING_WARNING, this.isGenerateWarningOnMapping() ? YES : NO, 12, 2);
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_RCSET_SYSCC, OPTION_RCSET_SYSCC, OPTION_RCSET_SYSCC, this.isRCSetSYSCCEnabled() ? YES : NO, 12, 2);
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_COMMENT_STPBEGIN_STPEND, OPTION_COMMENT_STPBEGIN_STPEND, OPTION_COMMENT_STPBEGIN_STPEND, this.isCommentStpbeginStpendMacros() ? YES : NO, 12, 2);
        String sAppN = this.getApplName();
        this.saveStringOptionToOMR(omr, COLLECT_STATISTICS_APPLNAME, sAppN);
        this.saveBooleanOptionToOMR(omr, OPTIONS_PROPERTYSET, OPTION_DISABLE_CHECKPOINTS, this.isDisableCheckpoints());
        ILibrary lib = this.getCheckpointStateLibrary();
        if (lib != null) {
            IPersistableObject[] iPersistableObjectArray3 = new IPersistableObject[1];
            iPersistableObjectArray2 = iPersistableObjectArray3;
            iPersistableObjectArray3[0] = lib;
        } else {
            iPersistableObjectArray2 = new IPersistableObject[]{};
        }
        this.saveCustomListToOMR(omr, OPTION_CHECKPOINT_STATE_LIBRARY, iPersistableObjectArray2);
        ILibrary alternateLibrary = this.getAlternateTemporaryLibrary();
        if (alternateLibrary != null) {
            IPersistableObject[] iPersistableObjectArray4 = new IPersistableObject[1];
            iPersistableObjectArray = iPersistableObjectArray4;
            iPersistableObjectArray4[0] = alternateLibrary;
        } else {
            iPersistableObjectArray = new IPersistableObject[]{};
        }
        this.saveCustomListToOMR(omr, OPTION_ALTERNATE_TEMPORARY_LIBARY, iPersistableObjectArray);
        String sGenerateFormat = this.isFormatInformatGenerationEnabled() ? YES : NO;
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_GENERATE_JOB_FORMATS_INFORMATS, OPTION_GENERATE_JOB_FORMATS_INFORMATS, OPTION_GENERATE_JOB_FORMATS_INFORMATS, sGenerateFormat, 12, 2);
        String sUseConnectUsing = this.isConnectUsingEnabled() ? YES : NO;
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_GENERATE_JOB_USE_CONNECT_USING, OPTION_GENERATE_JOB_USE_CONNECT_USING, OPTION_GENERATE_JOB_USE_CONNECT_USING, sUseConnectUsing, 12, 2);
        String sClearLibref = this.isClearLibrefEnabled() ? YES : NO;
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, OPTION_CLEAR_LIBREF, OPTION_CLEAR_LIBREF, OPTION_CLEAR_LIBREF, sClearLibref, 12, 2);
        this.savePropertyToOMR(omr, "DISVersion", "DISVersion", "DISVersion", "DISVersion", Double.toString(Workspace.getWorkspace().getApplicationVersionNumber()), 8, 1);
        this.saveTablePlacementToOMR(omr);
        this.setChanged(false);
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        for (int iTransform = 0; iTransform < this.m_lTransforms.size(); ++iTransform) {
            ITransform transform = (ITransform)this.m_lTransforms.get(iTransform);
            if (!transform.isChanged()) continue;
            return true;
        }
        Map<IDataObject, IDataObjectPlacements> placements = this.getDataObjectsPlacement();
        for (Map.Entry<IDataObject, IDataObjectPlacements> entry : placements.entrySet()) {
            IDataObjectPlacements places = entry.getValue();
            if (places == null || !places.isChanged()) continue;
            return true;
        }
        return this.m_codeUserWritten.isChanged() || this.m_lDataObjects.isChanged() || this.m_lOrderedTransforms.isChanged() || this.m_lInputJobPorts.isChanged() || this.m_lOutputJobPorts.isChanged();
    }

    @Override
    public boolean isComplete() {
        if (!super.isComplete()) {
            return false;
        }
        return this.m_optionModel == null || this.m_optionModel.isComplete();
    }

    @Override
    public boolean isCompleteAndSubcomponents() {
        if (!this.isComplete()) {
            return false;
        }
        ITransform[] transforms = this.getControlOrderedTransformsAndOthers();
        for (int i = 0; i < transforms.length; ++i) {
            if (transforms[i].isCompleteWithUserWritten() || !transforms[i].isCodeGenerationEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.m_optionModel != null) {
            lReasons.addAll(this.m_optionModel.getReasonsIncomplete());
        }
        return lReasons;
    }

    @Override
    public List getReasonsIncompleteAndSubcomponents() {
        List lReasons = this.getReasonsIncomplete();
        ITransform[] transforms = this.getControlOrderedTransformsAndOthers();
        for (int i = 0; i < transforms.length; ++i) {
            if (transforms[i].isCompleteWithUserWritten() || !transforms[i].isCodeGenerationEnabled()) continue;
            List lTransReasons = transforms[i].getReasonsIncomplete();
            for (int j = 0; j < lTransReasons.size(); ++j) {
                String reason = (String)lTransReasons.get(j);
                reason = transforms[i].getName().concat(": ".concat(reason));
                lReasons.add(reason);
            }
        }
        return lReasons;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.m_sActivityID = this.updateSubordinateID(this.m_sActivityID, mapIDs);
        this.m_codeUserWritten.updateIds(mapIDs);
        for (int i = 0; i < this.m_lTransforms.size(); ++i) {
            ((ITransform)this.m_lTransforms.get(i)).updateIDs(mapIDs);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Job mdoJob = (Job)omr.acquireOMRObject(this);
        IPersistableObject[] altlibs = this.loadCustomListFromOMR(omr, OPTION_ALTERNATE_TEMPORARY_LIBARY);
        ILibrary alternatelib = altlibs.length > 0 ? (ILibrary)altlibs[0] : null;
        this.setAlternateTemporaryLibrary(alternatelib, false);
        this.setCodeGenerationEnabled(mdoJob.getIsActive() == 1);
        this.m_codeUserWritten.loadFromOMR(omr);
        try {
            String version = Double.toString(Workspace.getWorkspace().getApplicationVersionNumber());
            this.m_dVersion = Double.parseDouble(this.loadPropertyFromOMR(omr, "DISVersion", "DISVersion", version, 1));
            if (this.m_dVersion == 0.0) {
                Workspace.getDefaultLogger().warn((Object)("DISVersion for job: " + this.getName() + ":" + this.getID() + " was set to 0.0. Workspace's version number is: " + Workspace.getWorkspace().getApplicationVersionNumber()));
            }
        }
        catch (NumberFormatException exc) {
            Workspace.getDefaultLogger().error((Object)"An error occurred while retrieving the DISVersion:", (Throwable)exc);
        }
        AssociationList lActivities = mdoJob.getJobActivities();
        ArrayList<String> lTransformsFQIDs = new ArrayList<String>();
        for (int iActivity = 0; iActivity < lActivities.size(); ++iActivity) {
            TransformationActivity mdoActivity = (TransformationActivity)lActivities.get(iActivity);
            this.m_sActivityID = mdoActivity.getFQID();
            Object steps = mdoActivity.getSteps();
            steps = this.verifyEachStepHasClassProperty((List)steps);
            this.m_lTransforms.loadFromOMR(omr, (List)steps);
            for (int iTransform = 0; iTransform < this.m_lTransforms.size(); ++iTransform) {
                ITransform xfm = (ITransform)this.m_lTransforms.get(iTransform);
                if (xfm.isCleanUpRequired()) {
                    this.getCleanedUpObjects().add(xfm.getID());
                    this.setCleanUpRequired();
                    this.m_lTransforms.remove(xfm);
                    String name = xfm.getName();
                    this.getTransformNamesCleanedUp().add(name);
                    --iTransform;
                    continue;
                }
                lTransformsFQIDs.add(xfm.getID());
            }
            this.m_lDataObjects.loadFromOMR(omr, (List)mdoActivity.getTransformationTargets());
        }
        this.m_lOrderedTransforms.clear();
        List lControlOrderCustomAssociations = this.findAllCustomAssociations(omr, (Root)mdoJob, CONTROL_ORDER_NAME);
        CustomAssociation bestControlOrderCustomAssociation = null;
        List bestControlOrderTransforms = null;
        int bestControlOrderCount = -1;
        for (int i = 0; i < lControlOrderCustomAssociations.size(); ++i) {
            CustomAssociation controlOrderCustomAssociation = (CustomAssociation)lControlOrderCustomAssociations.get(i);
            AssociationList controlOrderTransformations = controlOrderCustomAssociation.getAssociatedObjects();
            int count = 0;
            for (int iControlOrderTransform = 0; iControlOrderTransform < controlOrderTransformations.size(); ++iControlOrderTransform) {
                Root controlOrderTransform = (Root)controlOrderTransformations.get(iControlOrderTransform);
                if (!lTransformsFQIDs.contains(controlOrderTransform.getFQID())) continue;
                ++count;
            }
            if (count > bestControlOrderCount) {
                if (bestControlOrderCustomAssociation != null) {
                    this.getCleanedUpObjects().add(bestControlOrderCustomAssociation.getFQID());
                    this.setCleanUpRequired();
                }
                bestControlOrderCustomAssociation = controlOrderCustomAssociation;
                bestControlOrderTransforms = controlOrderTransformations;
                bestControlOrderCount = count;
                continue;
            }
            this.getCleanedUpObjects().add(controlOrderCustomAssociation.getFQID());
            this.setCleanUpRequired();
        }
        if (bestControlOrderCustomAssociation != null) {
            this.getCustomAssocationMap().put(CONTROL_ORDER_NAME, bestControlOrderCustomAssociation.getFQID());
            bestControlOrderTransforms = this.verifyEachStepHasClassProperty(bestControlOrderTransforms);
            for (int iControlOrderTransform = 0; iControlOrderTransform < bestControlOrderTransforms.size(); ++iControlOrderTransform) {
                Root mdoControlOrderTransform = (Root)bestControlOrderTransforms.get(iControlOrderTransform);
                ITransform transform = (ITransform)omr.acquireObject(mdoControlOrderTransform);
                if (transform.isCleanUpRequired()) {
                    this.getCleanedUpObjects().add(transform.getID());
                    this.setCleanUpRequired();
                    continue;
                }
                if (!lTransformsFQIDs.contains(mdoControlOrderTransform.getFQID())) {
                    this.m_lTransforms.add(transform);
                }
                this.m_lOrderedTransforms.add(transform);
            }
        }
        this.setCollectDiagnostics(this.loadBooleanOptionFromOMR(omr, COLLECT_DIAGNOSTICS, false));
        this.setCollectStatistics(this.loadBooleanOptionFromOMR(omr, COLLECT_STATISTICS, true));
        this.setCollectTableStatistics(this.loadBooleanOptionFromOMR(omr, COLLECT_TABLE_STATISTICS, true));
        this.setMapAutomatically(this.loadBooleanOptionFromOMR(omr, MAP_AUTOMATICALLY, true));
        this.setPropagateAutomatically(this.loadBooleanOptionFromOMR(omr, PROPAGATE_AUTOMATICALLY, true));
        this.setApplName(this.loadStringOptionFromOMR(omr, COLLECT_STATISTICS_APPLNAME, STATS_DEFAULT_APPLNAME));
        this.setGenerateDISHeaderAndFooters(this.loadBooleanOptionFromOMR(omr, "GenerateDISHeaderFooter", true));
        this.setAutomaticPropagationDirection(this.loadIntOptionFromOMR(omr, AUTOMATIC_PROPAGATION_DIRECTION, this.m_eAutomaticPropagationDirection));
        this.setStoredProcessPreCode(this.loadStringOptionFromOMR(omr, OPTION_STORED_PROCESS_PRE_CODE, null));
        this.setSystemOptions(this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_SYSTEMOPTIONS, "", 2));
        String sGenerateJobMacros = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_METADATA_MACRO_VARIABLES, NO, 2);
        this.setGenerateMetadataMacroVariables(YES.equals(sGenerateJobMacros));
        String sGenerateParallelMacros = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_PARALLEL_MACROS, NO, 2);
        this.setGenerateParallelMacros(YES.equals(sGenerateParallelMacros));
        String sGenerateStatusHandlingLast = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_STATUS_HANDLINGLAST, YES, 2);
        this.setGenerateStatusHandlingLast(YES.equals(sGenerateStatusHandlingLast));
        String sUseNLSFormats = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_USENLSDATEFORMAT, YES, 2);
        this.setUseNLSDateFormat(YES.equals(sUseNLSFormats));
        this.setGenerateWarningOnMapping(YES.equals(this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_MAPPING_WARNING, YES, 2)));
        IPersistableObject[] libs = this.loadCustomListFromOMR(omr, OPTION_CHECKPOINT_STATE_LIBRARY);
        ILibrary lib = libs.length > 0 ? (ILibrary)libs[0] : null;
        this.setCheckpointStateLibrary(lib);
        this.setDisableCheckpoints(this.loadBooleanOptionFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_DISABLE_CHECKPOINTS, false));
        this.setAlternateWorkTableLibrary();
        this.setDeleteAlternateTemporaryTables(this.loadBooleanOptionFromOMR(omr, OPTION_DELETE_ALTERNATE_TEMPORARY_TABLES, true));
        String formats_value = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_GENERATE_JOB_FORMATS_INFORMATS, YES, 2);
        this.setFormatInformatGenerationEnabled(YES.equalsIgnoreCase(formats_value));
        String connectusing_value = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_GENERATE_JOB_USE_CONNECT_USING, NO, 2);
        this.setConnectUsingEnabled(YES.equalsIgnoreCase(connectusing_value));
        String sRCSetSYSCC = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_RCSET_SYSCC, NO, 2);
        this.setRCSetSYSCCEnabled(YES.equalsIgnoreCase(sRCSetSYSCC));
        String clearLibref_value = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_CLEAR_LIBREF, NO, 2);
        this.setClearLibrefEnabled(YES.equalsIgnoreCase(clearLibref_value));
        String commentStpbeginStpendMacros_value = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, OPTION_COMMENT_STPBEGIN_STPEND, NO, 2);
        this.setCommentStpbeginStpendMacros(YES.equalsIgnoreCase(commentStpbeginStpendMacros_value));
        this.loadTablePlacement(omr);
        this.setChanged(false);
    }

    private List verifyEachStepHasClassProperty(List steps) throws MdException, RemoteException {
        if (steps == null) {
            return null;
        }
        ArrayList<Root> goodSteps = new ArrayList<Root>();
        for (int i = 0; i < steps.size(); ++i) {
            Root mdo = (Root)steps.get(i);
            AssociationList lProperties = mdo.getProperties();
            boolean isFound = false;
            for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
                Property mdoProperty = (Property)lProperties.get(iProperty);
                if (!mdoProperty.getPropertyName().equals("Class")) continue;
                isFound = true;
                break;
            }
            if (!isFound) {
                this.m_lBadTransformationSteps.add(mdo.getName());
                this.setCleanUpRequired();
                continue;
            }
            goodSteps.add(mdo);
        }
        return goodSteps;
    }

    @Override
    public String getOMRType() {
        return "Job";
    }

    @Override
    public String getPublicType() {
        return "Job";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return new UsageVersion(1, 0);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        lAssociations.add("JobActivities");
        lAssociations = new ArrayList<String>();
        lAssociations.add("Steps");
        lAssociations.add("TransformationTargets");
        map.put("TransformationActivity", lAssociations);
        this.m_codeUserWritten.getOMRLoadTemplateMap(map);
        return map;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public void dump(PrintStream strm) {
        super.dump(strm);
        strm.println("<Transforms>");
        for (int iTransform = 0; iTransform < this.m_lTransforms.size(); ++iTransform) {
            ITransform xfm = (ITransform)this.m_lTransforms.get(iTransform);
            xfm.dump(strm);
        }
        strm.println("</Transforms>");
    }

    @Override
    public void dumpXML(PrintStream stream) {
        ITransform[] transforms = this.getControlOrderedTransformsAndOthers();
        int value = 1;
        for (int iTransform = 0; iTransform < transforms.length; ++iTransform) {
            ITransform xfm = transforms[iTransform];
            xfm.dumpObjectToXML(stream);
            ++value;
        }
    }

    @Override
    public final void addTransformsToSkipCodeGeneration(ITransform transform) {
        this.m_lTransformsToSkip.add(transform);
    }

    @Override
    public final void clearTransformsToSkipCodeGeneration() {
        this.m_lTransformsToSkip.clear();
    }

    @Override
    public IServer getServerForStep(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        IServer server = this.getExecutionServer();
        return server != null ? server : defaultServer;
    }

    @Override
    public final ICodeSegment getCompleteCode(ICodeGenerationEnvironment environment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getCompleteCode(environment.createNewCodeSegment(this));
    }

    @Override
    public final ICodeSegment getCompleteCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        try {
            if (this.isCodeGenerationEnabled()) {
                if (this.isComplete()) {
                    if (this.isGenerateDISHeaderAndFooters()) {
                        if (this.isCPRJobCodeNeeded(false)) {
                            this.getGeneratedCodeHeader(codeSegment, codeSegment.getCurrentServer(), false, false);
                        } else {
                            ICodeSegment header = codeSegment.createNewCodeSegment(this.getPreProcessCode());
                            this.getGeneratedCodeHeader(header, codeSegment.getCurrentServer(), false, false);
                        }
                    }
                    this.getBodyCode(codeSegment);
                    if (this.isGenerateDISHeaderAndFooters()) {
                        if (this.isCPRJobCodeNeeded(false)) {
                            this.getGeneratedCodeFooter(codeSegment, codeSegment.getCurrentServer(), false, false);
                        } else {
                            ICodeSegment footer = codeSegment.createNewCodeSegment(this.getPostProcessCode());
                            this.getGeneratedCodeFooter(footer, codeSegment.getCurrentServer(), false, false);
                        }
                    }
                } else {
                    this.getJobComment(codeSegment);
                    List inc = this.getReasonsIncomplete();
                    for (int i = 0; i < inc.size(); ++i) {
                        codeSegment.addCommentLine(inc.get(i).toString());
                    }
                    codeSegment.addSourceCode("\n");
                }
            }
        }
        catch (CodegenException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (MdException e) {
            codeSegment.handleException((Exception)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (BadServerDefinitionException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (BadLibraryDefinitionException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (ServerException e) {
            codeSegment.handleException(e);
            throw e;
        }
        return codeSegment;
    }

    @Override
    public final ICodeSegment getBodyCode(ICodeGenerationEnvironment environment) throws CodegenException, RemoteException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getBodyCode(environment.createNewCodeSegment(this));
    }

    @Override
    public ICodeSegment[] getTransformCodeSegments(ICodeGenerationEnvironment environment, ITransform[] transforms) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ArrayList<ICodeSegment> segments = new ArrayList<ICodeSegment>();
        this.m_lTransformsToSkip.clear();
        for (int i = 0; i < transforms.length; ++i) {
            if (this.m_lTransformsToSkip.contains(transforms[i])) continue;
            ICodeSegment seg = environment.createNewCodeSegment(transforms[i]);
            segments.add(transforms[i].getCompleteCode(seg));
        }
        return segments.toArray(new ICodeSegment[segments.size()]);
    }

    public final ICodeSegment getBodyCode(ICodeSegment codeSegment) throws CodegenException, RemoteException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        this.m_lTransformsToSkip.clear();
        codeSegment.setIsBody(true);
        try {
            if (this.isCodeGenerationEnabled()) {
                if (!this.isUsingUserWrittenCode()) {
                    if (this.isComplete()) {
                        ITransform[] transforms = this.getControlOrderedTransformsAndOthers();
                        for (int i = 0; i < transforms.length; ++i) {
                            if (this.m_lTransformsToSkip.contains(transforms[i])) continue;
                            ICodeSegment seg = codeSegment.createNewCodeSegment(transforms[i]);
                            transforms[i].getCompleteCode(seg);
                            seg.setIsBody(true);
                        }
                    } else {
                        List inc = this.getReasonsIncomplete();
                        for (int i = 0; i < inc.size(); ++i) {
                            codeSegment.addCommentLine(inc.get(i).toString());
                        }
                        codeSegment.addSourceCode("\n");
                    }
                } else {
                    codeSegment.addSourceCode(this.getUserWrittenCode().getCode());
                }
            }
        }
        catch (CodegenException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (MdException e) {
            codeSegment.handleException((Exception)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (BadServerDefinitionException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (BadLibraryDefinitionException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (ServerException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (Exception e) {
            codeSegment.handleException(e);
            throw new CodegenException(e, (IObject)this);
        }
        return codeSegment;
    }

    @Override
    public final boolean isCPRJobCodeNeeded() {
        return this.isCPRJobCodeNeeded(false);
    }

    @Override
    public final boolean isCPRJobSetupComplete() {
        return !this.isDisableCheckpoints() && this.getCheckpointStateLibrary() != null && this.isCodeGenerationEnabled();
    }

    @Override
    public final boolean isCPRJobCodeNeeded(boolean bIKnowOneTransformHasCheckpointOn) {
        if (this.isCPRJobSetupComplete()) {
            if (bIKnowOneTransformHasCheckpointOn) {
                return true;
            }
            this.m_lTransformsToSkip.clear();
            ITransform[] transforms = this.getControlOrderedTransformsAndOthers();
            for (int i = 0; i < transforms.length; ++i) {
                if (this.m_lTransformsToSkip.contains(transforms[i]) || !transforms[i].isCPRStepCodeNeeded(true)) continue;
                return true;
            }
        }
        return false;
    }

    public final List getAltLibTableNamesInJob(ICodeSegment codeSegment) {
        ArrayList lAltLibTableNames = new ArrayList();
        this.m_lTransformsToSkip.clear();
        ITransform[] transforms = this.getControlOrderedTransformsAndOthers();
        for (int i = 0; i < transforms.length; ++i) {
            if (this.m_lTransformsToSkip.contains(transforms[i]) || !(transforms[i] instanceof IDataTransform)) continue;
            List lPossibleAltLibTableNames = this.getAltLibTableNamesInTransform(codeSegment, (IDataTransform)transforms[i]);
            for (int j = 0; j < lPossibleAltLibTableNames.size(); ++j) {
                if (lAltLibTableNames.contains(lPossibleAltLibTableNames.get(j))) continue;
                lAltLibTableNames.add(lPossibleAltLibTableNames.get(j));
            }
        }
        return lAltLibTableNames;
    }

    public final List getAltLibTableNamesInTransform(ICodeSegment codeSegment, IDataTransform transform) {
        ArrayList<String> lAltTableNames = new ArrayList<String>();
        ITable[] targets = transform.getTargetTables();
        for (int i = 0; i < targets.length; ++i) {
            IWorkTable table;
            if (!(targets[i] instanceof IWorkTable) || !"JobAlternate".equals((table = (IWorkTable)targets[i]).getLocationType()) || table.getAlternateJobLibrary() == null) continue;
            lAltTableNames.add(table.getTableName(codeSegment.isQuoting()));
        }
        return lAltTableNames;
    }

    public final ICodeSegment getJobComment(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        String divider = codeSegment.repeat("*", 75);
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        codeSegment.addSourceCode("/*").addSourceCode(divider).addSourceCode(" \n");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForJob(), this);
        String description = this.getDescription();
        codeSegment.genCommentLine(codeSegment.getCommentLabelForDescription(), description, "");
        codeSegment.genCommentLine();
        WorkspaceFile file = Workspace.getWorkspace().getWorkspaceFile();
        codeSegment.genCommentLine(codeSegment.getCommentLabelForMetadataServer(), file.getPropertyString("host"), "");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForPort(), file.getPropertyString("port"), "");
        IFolder folder = this.getFolder();
        codeSegment.genCommentLine(codeSegment.getCommentLabelForLocation(), folder != null ? folder.getURLtoFolder() : "", "");
        codeSegment.genCommentLine();
        IServer server = environment.getCurrentServer();
        codeSegment.genCommentLine(codeSegment.getCommentLabelForServer(), server.getName() + server.getHost(), server.getID());
        codeSegment.genCommentUserWrittenLine(this, codeSegment.getCommentLabelForUserWritten());
        codeSegment.genCommentLine();
        IDataObject[] sources = this.getDataSources();
        IDataObject[] targets = this.getDataTargets();
        codeSegment.genCommentTableLine(sources, codeSegment.getCommentLabelForSource(), codeSegment.getCommentLabelForSources());
        codeSegment.genCommentTableLine(targets, codeSegment.getCommentLabelForTarget(), codeSegment.getCommentLabelForTargets());
        if (sources.length > 0 || targets.length > 0) {
            codeSegment.genCommentLine();
        }
        String date = DateFormat.getDateTimeInstance(0, 0).format(Calendar.getInstance().getTime());
        date = date.replace("\u202f", " ");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForGeneratedOn(), date, "");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForGeneratedBy(), environment.getUserName(), "");
        String version = environment.getApplicationVersion();
        if (version != null && version.length() > 0) {
            codeSegment.genCommentLine(codeSegment.getCommentLabelForVersion(), version, "");
        }
        codeSegment.genCommentNotesLine(this, divider);
        if (!this.isCodeGenerationEnabled()) {
            codeSegment.genCommentNotActive(divider);
        }
        codeSegment.addSourceCode(" *").addSourceCode(divider).addSourceCode("/ \n\n");
        return codeSegment;
    }

    protected IDataObject[] getDataSources() {
        ArrayList<IDataObject> sources = new ArrayList<IDataObject>();
        ITransform[] transforms = this.getTransforms();
        for (int i = 0; i < transforms.length; ++i) {
            if (!(transforms[i] instanceof IDataTransform)) continue;
            IDataTransform dt = (IDataTransform)transforms[i];
            IDataObject[] src = dt.getDataSources();
            for (int j = 0; j < src.length; ++j) {
                if (src[j].getOMRType().equals("WorkTable")) continue;
                sources.add(src[j]);
            }
        }
        return sources.toArray(new IDataObject[sources.size()]);
    }

    protected IDataObject[] getDataTargets() {
        ArrayList<IDataObject> targets = new ArrayList<IDataObject>();
        ITransform[] transforms = this.getTransforms();
        for (int i = 0; i < transforms.length; ++i) {
            if (!(transforms[i] instanceof IDataTransform)) continue;
            IDataTransform dt = (IDataTransform)transforms[i];
            IDataObject[] tar = dt.getDataTargets();
            for (int j = 0; j < tar.length; ++j) {
                if (tar[j].getOMRType().equals("WorkTable")) continue;
                targets.add(tar[j]);
            }
        }
        return targets.toArray(new IDataObject[targets.size()]);
    }

    @Override
    public ICodeSegment getGeneratedCodeFooter(ICodeSegment codeSegment, IServer defaultServer, boolean isRemote, boolean isValidate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeSource postprocess;
        if (this.isUsingUserWrittenCode()) {
            codeSegment.genRCSetCall("&syserr", false);
            codeSegment.genRCSetCall("&sqlrc");
        }
        if (this.isGeneratingStatusHandlingLast()) {
            postprocess = this.getPostProcessCode().getUserWrittenSourceCode();
            if (this.isUsingPostProcessCode() && postprocess != null) {
                codeSegment.genCodeSource(postprocess, ICodeSegment.POSTPROCESS_START_COMMENT, ICodeSegment.POSTPROCESS_END_COMMENT);
            }
            this.genConditionActionSet(codeSegment);
        } else {
            this.genConditionActionSet(codeSegment);
            postprocess = this.getPostProcessCode().getUserWrittenSourceCode();
            if (this.isUsingPostProcessCode() && postprocess != null) {
                codeSegment.genCodeSource(postprocess, ICodeSegment.POSTPROCESS_START_COMMENT, ICodeSegment.POSTPROCESS_END_COMMENT);
            }
        }
        if (this.isCPRJobCodeNeeded(false)) {
            CheckpointRestart cpr = new CheckpointRestart(this);
            cpr.getCheckpointRestartPostJobCode(codeSegment);
        }
        this.genDeleteAlternateTemporaryTables(codeSegment);
        if (codeSegment.isRunStatisticsEnabled()) {
            codeSegment.genEndPerformanceStatistics(codeSegment.getCurrentServer());
        }
        this.removeGeneratedDefaultParameters(codeSegment);
        return codeSegment;
    }

    private ICodeSegment genConditionActionSet(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("%let etls_endTime = %sysfunc(datetime(),datetime.);\n\n");
        List lConditionActionSets = this.getConditionActionSetsList();
        for (int i = 0; i < lConditionActionSets.size(); ++i) {
            IConditionActionSet caSet = (IConditionActionSet)lConditionActionSets.get(i);
            if (!caSet.getCondition().getUniqueIdentifier().equals("DIS_CJOBSTATUS")) {
                codeSegment.addCommentLine("Check return code for job").addSourceCode("%macro etls_jobRCChk; \n").indent();
                codeSegment.addSourceCode(caSet.getCondition().getConditionMacroCall("job_rc"));
                codeSegment.addSourceCode("\n").addSourceCode("%do; \n").indent();
                codeSegment.genActionCodeConditionCheck(this.isUsingNLSDateFormat(), codeSegment, caSet, null, null);
                codeSegment.unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%mend etls_jobRCChk; \n").addSourceCode("%etls_jobRCChk; \n\n");
                continue;
            }
            codeSegment.addSectionComment(RB.getStringResource("BaseJob.JobStatusCode.msg.txt"));
            codeSegment.genActionCodeConditionCheck(this.isUsingNLSDateFormat(), codeSegment, caSet, null, null);
        }
        return codeSegment;
    }

    protected void doJobStatusSetup(ICodeSegment codeSegment) {
        codeSegment.addCommentLine(RB.getStringResource("BaseJob.JobStatusSetup.msg.txt")).addSourceCode("%let etls_startTime = %sysfunc(datetime(),datetime.);\n").addSourceCode("%let etls_recordsBefore = 0;\n").addSourceCode("%let etls_recordsAfter = 0;\n").addSourceCode("%let etls_lib = 0;\n").addSourceCode("%let etls_table = 0;\n\n");
    }

    @Override
    public ICodeSegment getGeneratedCodeHeader(ICodeSegment codeSegment, IServer defaultSever, boolean isRemote, boolean isValidate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        String systemOptions;
        this.getJobComment(codeSegment);
        ICodeGenerationEnvironment env = codeSegment.getCodeGenerationEnvironment();
        codeSegment.addCommentLine(RB.getStringResource("BaseJob.ProcessId.comment.txt"));
        this.getProcessIdPrintCode(codeSegment);
        codeSegment.addCommentLine(RB.getStringResource("BaseJob.GeneralMacroVariables.comment.txt"));
        this.getJobIdMacrovarCode(codeSegment, true);
        codeSegment.addSourceCode("\n");
        codeSegment.genReturnCodeAndPerformanceSetup(this.isRCSetSYSCCEnabled(), this.getApplName()).addSourceCode("\n");
        this.getGeneratedDefaultParameterCode(codeSegment);
        if (this.isGeneratingMetadataMacroVariables()) {
            codeSegment.genMetadataMacrosAndOptions(this, env.getCurrentServer(), false, null, null);
        }
        this.doJobStatusSetup(codeSegment);
        codeSegment.addSourceCode("%global etls_debug; \n").addSourceCode("%macro etls_setDebug; \n").indent().addSourceCode("%if %str(&etls_debug) ne 0 %then \n").indent().addSourceCode("OPTIONS MPRINT%str(;); \n").unIndent().unIndent().addSourceCode("%mend; \n").addSourceCode("%etls_setDebug; \n\n");
        codeSegment.addRemoteMacroVariable("etls_debug");
        ICodeSource preprocess = this.getPreProcessCode().getUserWrittenSourceCode();
        if (this.isUsingPreProcessCode() && preprocess != null) {
            codeSegment.genCodeSource(preprocess, ICodeSegment.PREPROCESS_START_COMMENT, ICodeSegment.PREPROCESS_END_COMMENT);
        }
        if (this.getAlternateTemporaryLibrary() != null) {
            codeSegment.addSourceCode(this.getTemporaryLibraryCode(codeSegment));
        }
        if (this.isGeneratingParallelMacros()) {
            codeSegment.genParallelMacros(env.getCurrentServer(), true, this.isRCSetSYSCCEnabled());
        }
        if ((systemOptions = this.getSystemOptions()) != null && systemOptions.length() > 0) {
            codeSegment.genSystemOptions(systemOptions);
        }
        if (this.isCPRJobCodeNeeded(false)) {
            CheckpointRestart cpr = new CheckpointRestart(this);
            cpr.getCheckpointRestartPreJobCode(codeSegment);
        }
        return codeSegment;
    }

    private StringBuffer getTemporaryLibraryCode(ICodeSegment codeSegment) throws CodegenException {
        ILibrary altTempLib = this.getAlternateTemporaryLibrary();
        if (altTempLib == null) {
            return new StringBuffer("");
        }
        String sAltTempLibref = altTempLib.getLibref();
        String sTempPathCode = "";
        if (altTempLib != null) {
            String subDirName = codeSegment.formatObjectIDForMacroVar(this);
            try {
                sTempPathCode = altTempLib.getAccessPath(codeSegment.getCodeGenerationEnvironment(), codeSegment.getCodeGenerationEnvironment().isGenerateRCSetCalls(), codeSegment.getRuntimeStatsConnectMacros(codeSegment, true), this.isCollectingStatistics(), this.isCollectingTableStatistics(), false).toString();
                codeSegment.getCodeGenerationEnvironment().addLibraryToContextList(altTempLib);
            }
            catch (MdException ex) {
                throw new CodegenException((Exception)((Object)ex), (IObject)this);
            }
            catch (RemoteException ex) {
                throw new CodegenException(ex, (IObject)this);
            }
            catch (BadLibraryDefinitionException ex) {
                throw new CodegenException(ex, (IObject)this);
            }
            catch (BadServerDefinitionException ex) {
                throw new CodegenException(ex, (IObject)this);
            }
            String sDirectory = altTempLib.getFirstDirectory();
            if (sDirectory != null && sDirectory != "") {
                File fDirectory = new File(sDirectory);
                String sChildDirectory = fDirectory.getName();
                String sParentDirectory = fDirectory.getParent();
                CodeSegment subdirCodeSegment = new CodeSegment(codeSegment.getCodeGenerationEnvironment(), this);
                subdirCodeSegment.addSourceCode("/* Assign Alternate Temporary library. */ \n").indent().addSourceCode("%macro etls_createAltDir(fullpath, parentdir, childname);\n").indent().addSourceCode("%if %sysfunc(fileexist(&fullpath)) eq 0 %then\n").indent().addSourceCode("%let fullpath = %sysfunc(dcreate(&childname,&parentdir));\n").unIndent().addSourceCode("%if %sysfunc(fileexist(&fullpath)) eq 0 %then\n").indent().genPercentPutStatement("Alternate temporary library does not exist and could not be created.", "WARNING%QUOTE(:)").unIndent().unIndent().addSourceCode("%mend etls_createAltDir;\n").addSourceCode("%etls_createAltDir(" + sDirectory + "," + sParentDirectory + "," + sChildDirectory + ");\n\n");
                sTempPathCode = sTempPathCode.replace("LIBNAME " + sAltTempLibref, subdirCodeSegment.toString() + "   " + "LIBNAME " + sAltTempLibref);
                codeSegment.unIndent();
            }
        }
        return new StringBuffer(sTempPathCode);
    }

    private ICodeSegment genDeleteAlternateTemporaryTables(ICodeSegment codeSegment) throws CodegenException, BadServerDefinitionException {
        List lAltLibTableNames;
        ILibrary altTempLib = this.getAlternateTemporaryLibrary();
        if (altTempLib == null || !this.isDeletingAlternateTemporaryTables()) {
            return codeSegment;
        }
        String sAltTempLibRef = altTempLib.getLibref();
        if (sAltTempLibRef.length() > 0 && (lAltLibTableNames = this.getAltLibTableNamesInJob(codeSegment)).size() > 0) {
            IServer altLibServer;
            IServer defaultServer = codeSegment.getDefaultServer();
            boolean bIsRemote = !ObjectComparator.isEqual(defaultServer, altLibServer = altTempLib.getBestServer(defaultServer));
            codeSegment.indent().addSourceCode("%global etls_runningInteractive;\n").addCommentLine("Delete alt temp tables on successful run if run-interactive flag is not 1").addSourceCode("%macro etls_clearAltTempLib(); \n").indent().addSourceCode("%if (&job_rc < 5  AND %sysfunc(getoption(OBS)) NE 0 ) and &etls_runningInteractive ne 1 %then\n").addSourceCode("%do;\n").indent();
            boolean bResetQuoting = false;
            ISASClientConnection conn = altLibServer.getConnectClient();
            if (bIsRemote) {
                if (conn == null) {
                    throw new CodegenException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), defaultServer.getName()), (IObject)this);
                }
                conn.genStartSubmit("sysrputsync = yes", codeSegment, false, codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled());
                codeSegment.indent();
                if (codeSegment.isQuoting()) {
                    bResetQuoting = true;
                    codeSegment.genValidvarnameOptionAny(true);
                }
            }
            codeSegment.addSourceCode("proc datasets lib=" + sAltTempLibRef + " nolist nowarn memtype = (data view);\n").indent().addSourceCode("delete ");
            for (int i = 0; i < lAltLibTableNames.size(); ++i) {
                if (i > 0) {
                    codeSegment.addSourceCode("       ");
                }
                codeSegment.addSourceCode(lAltLibTableNames.get(i) + "\n");
            }
            codeSegment.addSourceCode(";\n").unIndent().addSourceCode("quit;\n");
            if (bIsRemote) {
                if (bResetQuoting) {
                    codeSegment.genValidvarnameOptionReset();
                }
                codeSegment.unIndent();
                conn.genEndSubmit(codeSegment, this.isRCSetSYSCCEnabled());
            }
            codeSegment.unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%mend;\n").addSourceCode("%etls_clearAltTempLib(); \n\n");
        }
        return codeSegment;
    }

    public ICodeSegment getProcessIdPrintCode(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("%put Process ID: &SYSJOBID;\n\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment getJobIdMacrovarCode(ICodeSegment codeSegment, boolean bIncludeUserid) {
        codeSegment.addSourceCode("%let jobID = %quote(").addSourceCode(this.getID()).addSourceCode(");\n").addSourceCode("%let etls_jobName = %nrquote(" + codeSegment.getEscapedMacroValue(this.getName()) + ");\n");
        if (bIncludeUserid) {
            codeSegment.addSourceCode("%let etls_userID = %nrquote(" + codeSegment.getCodeGenerationEnvironment().getUserName() + ");\n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getJobIdSyslputCode(ICodeSegment codeSegment, String remoteName, boolean bIncludeUserid) {
        codeSegment.addSourceCode("%syslput jobID = &jobID / remote = ").addSourceCode(remoteName).addSourceCode("; \n").addSourceCode("%syslput etls_jobName = &etls_jobName / remote = ").addSourceCode(remoteName).addSourceCode("; \n");
        if (bIncludeUserid) {
            codeSegment.addSourceCode("%syslput etls_userID = &etls_userID / remote = ").addSourceCode(remoteName).addSourceCode("; \n");
        }
        return codeSegment;
    }

    @Override
    public boolean isCodeGenerationEnabled() {
        return this.m_bCodeGenerationEnabled;
    }

    @Override
    public void setCodeGenerationEnabled(boolean bEnabled) {
        if (this.m_bCodeGenerationEnabled == bEnabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCodeGenerationEnabledUndoable(this.m_bCodeGenerationEnabled, bEnabled));
        }
        this.m_bCodeGenerationEnabled = bEnabled;
        this.fireModelChangedEvent("IJob:CodeGenerationEnabledChanged", null);
    }

    @Override
    public String getStoredProcessPreCode() {
        return this.m_sStoredProcessPreCode;
    }

    @Override
    public void setStoredProcessPreCode(String preCode) {
        if (ObjectComparator.isEqual(preCode, this.m_sStoredProcessPreCode)) {
            return;
        }
        String old = this.m_sStoredProcessPreCode;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetStoredProcessPreCodeUndoable(this.m_sStoredProcessPreCode, preCode));
        }
        this.m_sStoredProcessPreCode = preCode;
        this.fireModelChangedEvent("IJob:StoredProcessPreCodeChanged", this.m_sStoredProcessPreCode, old);
    }

    @Override
    public IJob getJob() {
        return this;
    }

    @Override
    public final ICodeSegment getPreJobCode(ICodeGenerationEnvironment environment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.isGenerateDISHeaderAndFooters()) {
            ICodeSegment segment = environment.createNewCodeSegment(this.getPreProcessCode());
            segment.setName(RB.getStringResource("BaseJob.PreCodeSegment.Name.txt"));
            return this.getGeneratedCodeHeader(segment, environment.getCurrentServer(), false, false);
        }
        return null;
    }

    @Override
    public final ICodeSegment getPostJobCode(ICodeGenerationEnvironment environment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.isGenerateDISHeaderAndFooters()) {
            ICodeSegment segment = environment.createNewCodeSegment(this.getPostProcessCode());
            segment.setName(RB.getStringResource("BaseJob.PostCodeSegment.Name.txt"));
            return this.getGeneratedCodeFooter(segment, environment.getCurrentServer(), false, false);
        }
        return null;
    }

    @Override
    public final ICodeSegment[] getCodeSegments(ICodeGenerationEnvironment environment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        this.m_lTransformsToSkip.clear();
        ArrayList<ICodeSegment> segments = new ArrayList<ICodeSegment>();
        boolean bRunCodeInOneSegment = this.isCPRJobCodeNeeded(false);
        bRunCodeInOneSegment = false;
        if (this.isComplete()) {
            ICodeSegment preCode;
            ICodeSegment chkpRestartSegment = null;
            if (bRunCodeInOneSegment) {
                chkpRestartSegment = this.getCheckpointRestartJobSegment(environment);
                segments.add(chkpRestartSegment);
            }
            if ((preCode = this.getPreJobCode(environment)) != null) {
                if (!bRunCodeInOneSegment) {
                    segments.add(preCode);
                } else {
                    ((ICodeSegment)segments.get(0)).addSourceCode(preCode);
                }
            }
            if (!this.isUsingUserWrittenCode() && this.isComplete()) {
                ITransform[] transforms = this.getControlOrderedTransforms();
                for (int i = 0; i < transforms.length; ++i) {
                    if (this.m_lTransformsToSkip.contains(transforms[i])) continue;
                    ICodeSegment nextSegment = transforms[i].getCompleteCode(environment);
                    if (!bRunCodeInOneSegment || segments.isEmpty()) {
                        segments.add(nextSegment);
                    } else {
                        ((ICodeSegment)segments.get(0)).addSourceCode(nextSegment);
                    }
                    nextSegment.setIsBody(true);
                }
            } else {
                ICodeSegment jobCode = environment.createNewCodeSegment(this);
                jobCode.addSourceCode(this.getBodyCode(environment));
                if (!bRunCodeInOneSegment || segments.isEmpty()) {
                    segments.add(jobCode);
                } else {
                    ((ICodeSegment)segments.get(0)).addSourceCode(jobCode);
                }
            }
            ICodeSegment postCode = this.getPostJobCode(environment);
            if (postCode != null) {
                if (!bRunCodeInOneSegment || segments.isEmpty()) {
                    segments.add(postCode);
                } else {
                    ((ICodeSegment)segments.get(0)).addSourceCode(postCode);
                }
            }
        } else {
            ICodeSegment codeSegment = environment.createNewCodeSegment(this);
            this.getJobComment(codeSegment);
            List inc = this.getReasonsIncomplete();
            for (int i = 0; i < inc.size(); ++i) {
                codeSegment.addCommentLine(inc.get(i).toString());
            }
            codeSegment.addSourceCode("\n");
            if (!bRunCodeInOneSegment || segments.isEmpty()) {
                segments.add(codeSegment);
            } else {
                ((ICodeSegment)segments.get(0)).addSourceCode(codeSegment);
            }
        }
        return segments.toArray(new ICodeSegment[segments.size()]);
    }

    public final ICodeSegment getCheckpointRestartJobSegment(ICodeGenerationEnvironment environment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        CodeSegment segment = new CodeSegment(environment, this);
        segment.setName(this.getName() + " Checkpoint enabled");
        return segment;
    }

    @Override
    public ICodeSegment getRestartPendingCode(ICodeGenerationEnvironment environment, String macrovarName) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return new CheckpointRestart(this).getRestartPendingCode(this.getCheckpointRestartJobSegment(environment), macrovarName);
    }

    @Override
    public void setClearLibrefEnabled(boolean enabled) {
        if (enabled == this.m_bClearLibref) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetClearLibrefEnabledUndoable(this.m_bClearLibref, enabled));
        }
        this.m_bClearLibref = enabled;
        this.fireModelChangedEvent("IJob:CLEARLIBREFChanged", null);
    }

    @Override
    public boolean isClearLibrefEnabled() {
        return this.m_bClearLibref;
    }

    @Override
    public void setCommentStpbeginStpendMacros(boolean bCommentStpbeginStpendMacros) {
        if (this.m_bCommentStpbeginStpendMacros == bCommentStpbeginStpendMacros) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCommentStpbeginStpendMacrosUndoable(this.m_bCommentStpbeginStpendMacros, bCommentStpbeginStpendMacros));
        }
        this.m_bCommentStpbeginStpendMacros = bCommentStpbeginStpendMacros;
        this.fireModelChangedEvent("IJob:COMMENTSTPBEGINSTPENDMACROSChanged", null);
    }

    @Override
    public boolean isCommentStpbeginStpendMacros() {
        return this.m_bCommentStpbeginStpendMacros;
    }

    private class TransformsList
    extends AbstractPrimaryModelList {
        public TransformsList() {
            super(BaseJob.this, new String[]{"Job:TransformAdded", "Job:TransformRemoved"}, 3, ITransform.class);
        }

        @Override
        protected void preLoad(Object obj) {
            super.preLoad(obj);
            ((ITransform)obj).setJob(BaseJob.this);
        }

        @Override
        protected void addTo(Object secondary) {
            ((ITransform)secondary).setJob(BaseJob.this);
        }

        @Override
        protected void removeFrom(Object secondary) {
            ((ITransform)secondary).setJob(null);
        }

        @Override
        protected void preRemove(Object obj) {
            if (BaseJob.this.getControlOrderedTransformsList().contains(obj)) {
                BaseJob.this.getControlOrderedTransformsList().remove(obj);
            }
        }
    }

    private static class DataObjectsAddFilter
    implements IFilter {
        private DataObjectsAddFilter() {
        }

        @Override
        public boolean pass(Object obj) {
            return obj instanceof IDataObject && !(obj instanceof IWorkTable);
        }
    }

    protected class cJobOptionModel
    extends BasePromptModel
    implements IPromptModel {
        public cJobOptionModel(IModel model, IObject owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServiceException, ServerConnectionException {
            super(model, owner);
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new JobValueChangedListener((IJob)this.getOwner(), this);
        }

        @Override
        protected IModelListener createModelListener() {
            return new JobModelChangeListener(this.getOwner(), this);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            IJob job = (IJob)this.getOwner();
            this.setOptionValue(BaseJob.OPTION_SYSTEMOPTIONS, (Object)job.getSystemOptions());
            this.setOptionValue(BaseJob.OPTION_METADATA_MACRO_VARIABLES, (Object)(job.isGeneratingMetadataMacroVariables() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_PARALLEL_MACROS, (Object)(job.isGeneratingParallelMacros() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_STATUS_HANDLINGLAST, (Object)(job.isGeneratingStatusHandlingLast() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_USENLSDATEFORMAT, (Object)(job.isUsingNLSDateFormat() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_MAPPING_WARNING, (Object)(job.isGenerateWarningOnMapping() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_CHECKPOINT_STATE_LIBRARY, (Object)job.getCheckpointStateLibrary());
            this.setOptionValue(BaseJob.OPTION_DISABLE_CHECKPOINTS, (Object)(job.isDisableCheckpoints() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.COLLECT_DIAGNOSTICS, (Object)(job.isCollectingDiagnostics() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.COLLECT_STATISTICS, (Object)(job.isCollectingStatistics() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.COLLECT_TABLE_STATISTICS, (Object)(job.isCollectingTableStatistics() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.COLLECT_STATISTICS_APPLNAME, (Object)job.getApplName());
            this.setOptionValue(BaseJob.OPTION_ALTERNATE_TEMPORARY_LIBARY, (Object)job.getAlternateTemporaryLibrary());
            this.setOptionValue(BaseJob.OPTION_DELETE_ALTERNATE_TEMPORARY_TABLES, (Object)(job.isDeletingAlternateTemporaryTables() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_GENERATE_JOB_FORMATS_INFORMATS, (Object)(job.isFormatInformatGenerationEnabled() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_GENERATE_JOB_USE_CONNECT_USING, (Object)(job.isConnectUsingEnabled() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_RCSET_SYSCC, (Object)(job.isRCSetSYSCCEnabled() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_CLEAR_LIBREF, (Object)(job.isClearLibrefEnabled() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_COMMENT_STPBEGIN_STPEND, (Object)(job.isCommentStpbeginStpendMacros() ? BaseJob.YES : BaseJob.NO));
            this.setOptionValue(BaseJob.OPTION_STORED_PROCESS_PRE_CODE, (Object)job.getStoredProcessPreCode());
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cJobOptionModel.class.getResource("res/Options_Job_Template.xml"));
            PromptGroupInterface newGrp = this.combinePromptGroups(grp1, grp);
            return newGrp;
        }

        private class JobValueChangedListener
        extends BasePromptValueChangedListener {
            public JobValueChangedListener(IJob job, IPromptModel promptModel) {
                super(job, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (BaseJob.OPTION_SYSTEMOPTIONS.equals(optionName)) {
                        BaseJob.this.setSystemOptions(value != null ? value.toString() : "");
                    } else if (BaseJob.OPTION_METADATA_MACRO_VARIABLES.equals(optionName)) {
                        BaseJob.this.setGenerateMetadataMacroVariables(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_PARALLEL_MACROS.equals(optionName)) {
                        BaseJob.this.setGenerateParallelMacros(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_RCSET_SYSCC.equals(optionName)) {
                        BaseJob.this.setRCSetSYSCCEnabled(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_STATUS_HANDLINGLAST.equals(optionName)) {
                        BaseJob.this.setGenerateStatusHandlingLast(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_USENLSDATEFORMAT.equals(optionName)) {
                        BaseJob.this.setUseNLSDateFormat(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_MAPPING_WARNING.equals(optionName)) {
                        BaseJob.this.setGenerateWarningOnMapping(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_CHECKPOINT_STATE_LIBRARY.equals(optionName)) {
                        BaseJob.this.setCheckpointStateLibrary((ILibrary)value);
                    } else if (BaseJob.OPTION_DISABLE_CHECKPOINTS.equals(optionName)) {
                        BaseJob.this.setDisableCheckpoints(BaseJob.YES.equalsIgnoreCase(value.toString()));
                    } else if (BaseJob.COLLECT_DIAGNOSTICS.equals(optionName)) {
                        BaseJob.this.setCollectDiagnostics(BaseJob.YES.equals(value));
                    } else if (BaseJob.COLLECT_STATISTICS.equals(optionName)) {
                        BaseJob.this.setCollectStatistics(BaseJob.YES.equals(value));
                    } else if (BaseJob.COLLECT_TABLE_STATISTICS.equals(optionName)) {
                        BaseJob.this.setCollectTableStatistics(BaseJob.YES.equals(value));
                    } else if (BaseJob.COLLECT_STATISTICS_APPLNAME.equals(optionName)) {
                        String sName = value.toString();
                        BaseJob.this.setApplName(sName);
                    } else if (BaseJob.OPTION_ALTERNATE_TEMPORARY_LIBARY.equals(optionName)) {
                        BaseJob.this.setAlternateTemporaryLibrary((ILibrary)value);
                    } else if (BaseJob.OPTION_DELETE_ALTERNATE_TEMPORARY_TABLES.equals(optionName)) {
                        BaseJob.this.setDeleteAlternateTemporaryTables(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_GENERATE_JOB_FORMATS_INFORMATS.equals(optionName)) {
                        BaseJob.this.setFormatInformatGenerationEnabled(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_GENERATE_JOB_USE_CONNECT_USING.equals(optionName)) {
                        BaseJob.this.setConnectUsingEnabled(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_CLEAR_LIBREF.equals(optionName)) {
                        BaseJob.this.setClearLibrefEnabled(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_COMMENT_STPBEGIN_STPEND.equals(optionName)) {
                        BaseJob.this.setCommentStpbeginStpendMacros(BaseJob.YES.equals(value));
                    } else if (BaseJob.OPTION_STORED_PROCESS_PRE_CODE.equals(optionName)) {
                        BaseJob.this.setStoredProcessPreCode(value != null ? value.toString() : null);
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }

        private class JobModelChangeListener
        extends BasePromptModelListener {
            public JobModelChangeListener(IObject modelObject, IPromptModel promptModel) {
                super(modelObject, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if ("IJob:SystemOptionsChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_SYSTEMOPTIONS, (Object)BaseJob.this.getSystemOptions());
                    } else if ("IJob:GenerateMetadataMacroVariablesChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_METADATA_MACRO_VARIABLES, (Object)(BaseJob.this.isGeneratingMetadataMacroVariables() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:GenerateParallelMacrosChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_PARALLEL_MACROS, (Object)(BaseJob.this.isGeneratingParallelMacros() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:GenerateStatusHandlingLastChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_STATUS_HANDLINGLAST, (Object)(BaseJob.this.isGeneratingStatusHandlingLast() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:UseNLSDateChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_USENLSDATEFORMAT, (Object)(BaseJob.this.isUsingNLSDateFormat() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:WarningOnMappingChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_MAPPING_WARNING, (Object)(BaseJob.this.isGenerateWarningOnMapping() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:CheckpointStateLibraryChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_CHECKPOINT_STATE_LIBRARY, ev.getData());
                    } else if ("IJob:DisableCheckpointsChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_DISABLE_CHECKPOINTS, (Object)(BaseJob.this.isDisableCheckpoints() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:CollectDiagnosticsChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.COLLECT_DIAGNOSTICS, (Object)(BaseJob.this.isCollectingDiagnostics() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:CollectStatisticsChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.COLLECT_STATISTICS, (Object)(BaseJob.this.isCollectingStatistics() ? BaseJob.YES : BaseJob.NO));
                        cJobOptionModel.this.setOptionDefaultValue(BaseJob.COLLECT_TABLE_STATISTICS, (Object)(BaseJob.this.isCollectingStatistics() ? BaseJob.YES : BaseJob.NO));
                        cJobOptionModel.this.setOptionValue(BaseJob.COLLECT_TABLE_STATISTICS, (Object)(BaseJob.this.isCollectingTableStatistics() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:CollectTableStatisticsChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.COLLECT_TABLE_STATISTICS, (Object)(BaseJob.this.isCollectingTableStatistics() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:StatisticsApplNameChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.COLLECT_STATISTICS_APPLNAME, (Object)BaseJob.this.getApplName());
                    } else if ("IJob:AlternateTempLibraryChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_ALTERNATE_TEMPORARY_LIBARY, ev.getData());
                    } else if ("IJob:DeleteAlternateTempTablesChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_DELETE_ALTERNATE_TEMPORARY_TABLES, (Object)(BaseJob.this.isDeletingAlternateTemporaryTables() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:GenerateJOBFORMATINFORMATChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_GENERATE_JOB_FORMATS_INFORMATS, (Object)(BaseJob.this.isFormatInformatGenerationEnabled() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:GenerateJOBUSECONNECTUSINGChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_GENERATE_JOB_USE_CONNECT_USING, (Object)(BaseJob.this.isConnectUsingEnabled() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:CLEARLIBREFChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_CLEAR_LIBREF, (Object)(BaseJob.this.isClearLibrefEnabled() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:COMMENTSTPBEGINSTPENDMACROSChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_COMMENT_STPBEGIN_STPEND, (Object)(BaseJob.this.isCommentStpbeginStpendMacros() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:RCSetSYSCCChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_RCSET_SYSCC, (Object)(BaseJob.this.isRCSetSYSCCEnabled() ? BaseJob.YES : BaseJob.NO));
                    } else if ("IJob:StoredProcessPreCodeChanged".equals(type)) {
                        cJobOptionModel.this.setOptionValue(BaseJob.OPTION_STORED_PROCESS_PRE_CODE, (Object)BaseJob.this.getStoredProcessPreCode());
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }

    private class SetGenerateDISHeaderAndFooters
    extends AbstractUndoableEdit {
        private boolean m_bOldGenerateDISHeaderAndFooters;
        private boolean m_bNewGenerateDISHeaderAndFooters;

        public SetGenerateDISHeaderAndFooters(boolean bOldGenerateDISHeaderAndFooters, boolean bNewGenerateDISHeaderAndFooters) {
            this.m_bOldGenerateDISHeaderAndFooters = bOldGenerateDISHeaderAndFooters;
            this.m_bNewGenerateDISHeaderAndFooters = bNewGenerateDISHeaderAndFooters;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setGenerateDISHeaderAndFooters(this.m_bOldGenerateDISHeaderAndFooters);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setGenerateDISHeaderAndFooters(this.m_bNewGenerateDISHeaderAndFooters);
        }
    }

    private class SetMapAutomaticallyUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldMapAutomatically;
        private boolean m_bNewMapAutomatically;

        public SetMapAutomaticallyUndoable(boolean bOldMapAutomatically, boolean bNewMapAutomatically) {
            this.m_bOldMapAutomatically = bOldMapAutomatically;
            this.m_bNewMapAutomatically = bNewMapAutomatically;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setMapAutomatically(this.m_bOldMapAutomatically);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setMapAutomatically(this.m_bNewMapAutomatically);
        }
    }

    private class SetPropagateAutomaticallyUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldPropagateAutomatically;
        private boolean m_bNewPropagateAutomatically;

        public SetPropagateAutomaticallyUndoable(boolean bOldPropagateAutomatically, boolean bNewPropagateAutomatically) {
            this.m_bOldPropagateAutomatically = bOldPropagateAutomatically;
            this.m_bNewPropagateAutomatically = bNewPropagateAutomatically;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setPropagateAutomatically(this.m_bOldPropagateAutomatically);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setPropagateAutomatically(this.m_bNewPropagateAutomatically);
        }
    }

    private class SetAutomaticPropagationDirectionUndoable
    extends AbstractUndoableEdit {
        private int m_eOldPropagationDirection;
        private int m_eNewPropagationDirection;

        public SetAutomaticPropagationDirectionUndoable(int eOldPropagationDirection, int eNewPropagationDirection) {
            this.m_eOldPropagationDirection = eOldPropagationDirection;
            this.m_eNewPropagationDirection = eNewPropagationDirection;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setAutomaticPropagationDirection(this.m_eOldPropagationDirection);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setAutomaticPropagationDirection(this.m_eNewPropagationDirection);
        }
    }

    private class SetCollectDiagnosticsUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldCollectDiagnostics;
        private boolean m_bNewCollectDiagnostics;

        public SetCollectDiagnosticsUndoable(boolean bOldCollectDiagnostics, boolean bNewCollectDiagnostics) {
            this.m_bOldCollectDiagnostics = bOldCollectDiagnostics;
            this.m_bNewCollectDiagnostics = bNewCollectDiagnostics;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setCollectDiagnostics(this.m_bOldCollectDiagnostics);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setCollectDiagnostics(this.m_bNewCollectDiagnostics);
        }
    }

    private class SetCollectStatisticsUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldCollectStatistics;
        private boolean m_bNewCollectStatistics;

        public SetCollectStatisticsUndoable(boolean bOldCollectStatistics, boolean bNewCollectStatistics) {
            this.m_bOldCollectStatistics = bOldCollectStatistics;
            this.m_bNewCollectStatistics = bNewCollectStatistics;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setCollectStatistics(this.m_bOldCollectStatistics);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setCollectStatistics(this.m_bNewCollectStatistics);
        }
    }

    private class SetCollectTableStatisticsUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldCollectTableStatistics;
        private boolean m_bNewCollectTableStatistics;

        public SetCollectTableStatisticsUndoable(boolean bOldCollectTableStatistics, boolean bNewCollectTableStatistics) {
            this.m_bOldCollectTableStatistics = bOldCollectTableStatistics;
            this.m_bNewCollectTableStatistics = bNewCollectTableStatistics;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setCollectTableStatistics(this.m_bOldCollectTableStatistics);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setCollectTableStatistics(this.m_bNewCollectTableStatistics);
        }
    }

    private class SetExecutionServerUndoable
    extends AbstractUndoableEdit {
        private IServer m_serverOld;
        private IServer m_serverNew;

        public SetExecutionServerUndoable(IServer serverOld, IServer serverNew) {
            this.m_serverOld = serverOld;
            this.m_serverNew = serverNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setExecutionServer(this.m_serverOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setExecutionServer(this.m_serverNew);
        }
    }

    private class SystemOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_bOldSystemOptions;
        private String m_bNewSystemOptions;

        public SystemOptionsUndoable(String bOldSystemOptions, String bNewSystemOptions) {
            this.m_bOldSystemOptions = bOldSystemOptions;
            this.m_bNewSystemOptions = bNewSystemOptions;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setSystemOptions(this.m_bOldSystemOptions);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setSystemOptions(this.m_bNewSystemOptions);
        }
    }

    private class GenerateJobMacrosUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldGenerateJobMacros;
        private boolean m_bNewGenerateJobMacros;

        public GenerateJobMacrosUndoable(boolean bOldGenerateJobMacros, boolean bNewGenerateJobMacros) {
            this.m_bOldGenerateJobMacros = bOldGenerateJobMacros;
            this.m_bNewGenerateJobMacros = bNewGenerateJobMacros;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setGenerateMetadataMacroVariables(this.m_bOldGenerateJobMacros);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setGenerateMetadataMacroVariables(this.m_bNewGenerateJobMacros);
        }
    }

    private class GenerateParallelMacrosUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldGenerateParallelMacros;
        private boolean m_bNewGenerateParallelMacros;

        public GenerateParallelMacrosUndoable(boolean bOldGenerateParallelMacros, boolean bNewGenerateParallelMacros) {
            this.m_bOldGenerateParallelMacros = bOldGenerateParallelMacros;
            this.m_bNewGenerateParallelMacros = bNewGenerateParallelMacros;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setGenerateParallelMacros(this.m_bOldGenerateParallelMacros);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setGenerateParallelMacros(this.m_bNewGenerateParallelMacros);
        }
    }

    private class SetRCSetSYSCCEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldRCSetSYSCC;
        private boolean m_bNewRCSetSYSCC;

        public SetRCSetSYSCCEnabledUndoable(boolean bOldRCSetSYSCC, boolean bNewRCSetSYSCC) {
            this.m_bOldRCSetSYSCC = bOldRCSetSYSCC;
            this.m_bNewRCSetSYSCC = bNewRCSetSYSCC;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setRCSetSYSCCEnabled(this.m_bOldRCSetSYSCC);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setRCSetSYSCCEnabled(this.m_bNewRCSetSYSCC);
        }
    }

    private class GenerateStatusHandlingLastUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldGenerateStatusHandlingLast;
        private boolean m_bNewGenerateStatusHandlingLast;

        public GenerateStatusHandlingLastUndoable(boolean bOldGenerateStatusHandlingLast, boolean bNewGenerateStatusHandlingLast) {
            this.m_bOldGenerateStatusHandlingLast = bOldGenerateStatusHandlingLast;
            this.m_bNewGenerateStatusHandlingLast = bNewGenerateStatusHandlingLast;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setGenerateStatusHandlingLast(this.m_bOldGenerateStatusHandlingLast);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setGenerateStatusHandlingLast(this.m_bNewGenerateStatusHandlingLast);
        }
    }

    private class SetWarningOnMappingTruncationUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldValue;
        private boolean m_bNewValue;

        public SetWarningOnMappingTruncationUndoable(boolean bOldValue, boolean bNewValue) {
            this.m_bOldValue = bOldValue;
            this.m_bNewValue = bNewValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setGenerateWarningOnMapping(this.m_bOldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setGenerateWarningOnMapping(this.m_bNewValue);
        }
    }

    private class SetDeleteAlternateTemporaryTablesUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldValue;
        private boolean m_bNewValue;

        public SetDeleteAlternateTemporaryTablesUndoable(boolean bOldValue, boolean bNewValue) {
            this.m_bOldValue = bOldValue;
            this.m_bNewValue = bNewValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setDeleteAlternateTemporaryTables(this.m_bOldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setDeleteAlternateTemporaryTables(this.m_bNewValue);
        }
    }

    private class SetUseNLSDateUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldUseNLSDateFormat;
        private boolean m_bNewUseNLSDateFormat;

        public SetUseNLSDateUndoable(boolean bOldUseNLSDateFormat, boolean bNewUseNLSDateFormat) {
            this.m_bOldUseNLSDateFormat = bOldUseNLSDateFormat;
            this.m_bNewUseNLSDateFormat = bNewUseNLSDateFormat;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setUseNLSDateFormat(this.m_bOldUseNLSDateFormat);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setUseNLSDateFormat(this.m_bNewUseNLSDateFormat);
        }
    }

    private class SetApplNameUndoable
    extends AbstractUndoableEdit {
        private String m_sOldApplName;
        private String m_sNewApplName;

        public SetApplNameUndoable(String sOldApplName, String sNewApplName) {
            this.m_sOldApplName = sOldApplName;
            this.m_sNewApplName = sNewApplName;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setApplName(this.m_sOldApplName);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setApplName(this.m_sNewApplName);
        }
    }

    private class SetAlternateTemporaryLibraryUndoable
    extends AbstractUndoableEdit {
        private ILibrary m_libraryOld;
        private ILibrary m_libraryNew;

        public SetAlternateTemporaryLibraryUndoable(ILibrary libraryOld, ILibrary libraryNew) {
            this.m_libraryOld = libraryOld;
            this.m_libraryNew = libraryNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setAlternateTemporaryLibrary(this.m_libraryOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setAlternateTemporaryLibrary(this.m_libraryNew);
        }

        @Override
        public void die() {
            super.die();
            this.m_libraryNew = null;
            this.m_libraryOld = null;
        }
    }

    private class SetFormatInformatGenerationEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetFormatInformatGenerationEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setFormatInformatGenerationEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setFormatInformatGenerationEnabled(this.m_newValue);
        }
    }

    private class SetConnectUsingEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetConnectUsingEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setConnectUsingEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setConnectUsingEnabled(this.m_newValue);
        }
    }

    private class SetCheckpointEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldDisableCheckpoints;
        private boolean m_bNewDisableCheckpoints;

        public SetCheckpointEnabledUndoable(boolean bOldDisableCheckpoints, boolean bNewDisableCheckpoints) {
            this.m_bOldDisableCheckpoints = bOldDisableCheckpoints;
            this.m_bNewDisableCheckpoints = bNewDisableCheckpoints;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setDisableCheckpoints(this.m_bOldDisableCheckpoints);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setDisableCheckpoints(this.m_bNewDisableCheckpoints);
        }
    }

    private class SetCheckpointStateLibraryUndoable
    extends AbstractUndoableEdit {
        private ILibrary m_libraryOld;
        private ILibrary m_libraryNew;

        public SetCheckpointStateLibraryUndoable(ILibrary libraryOld, ILibrary libraryNew) {
            this.m_libraryOld = libraryOld;
            this.m_libraryNew = libraryNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setCheckpointStateLibrary(this.m_libraryOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setCheckpointStateLibrary(this.m_libraryNew);
        }

        @Override
        public void die() {
            super.die();
            this.m_libraryNew = null;
            this.m_libraryOld = null;
        }
    }

    private class SetCleanUpRequiredUndoable
    extends AbstractUndoableEdit {
        @Override
        public void undo() {
            super.undo();
        }

        @Override
        public void redo() {
            super.redo();
        }
    }

    private class SetCodeGenerationEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldEnabled;
        private boolean m_bNewEnabled;

        public SetCodeGenerationEnabledUndoable(boolean bOldEnabled, boolean bNewEnabled) {
            this.m_bOldEnabled = bOldEnabled;
            this.m_bNewEnabled = bNewEnabled;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setCodeGenerationEnabled(this.m_bOldEnabled);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setCodeGenerationEnabled(this.m_bNewEnabled);
        }
    }

    private class SetStoredProcessPreCodeUndoable
    extends AbstractUndoableEdit {
        private String m_bOldStoredProcessPreCode;
        private String m_bNewStoredProcessPreCode;

        public SetStoredProcessPreCodeUndoable(String bOldStoredProcessPreCode, String bNewStoredProcessPreCode) {
            this.m_bOldStoredProcessPreCode = bOldStoredProcessPreCode;
            this.m_bNewStoredProcessPreCode = bNewStoredProcessPreCode;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setStoredProcessPreCode(this.m_bOldStoredProcessPreCode);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setStoredProcessPreCode(this.m_bNewStoredProcessPreCode);
        }
    }

    private class SetClearLibrefEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetClearLibrefEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setClearLibrefEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setClearLibrefEnabled(this.m_newValue);
        }
    }

    private class SetCommentStpbeginStpendMacrosUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetCommentStpbeginStpendMacrosUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseJob.this.setCommentStpbeginStpendMacros(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseJob.this.setCommentStpbeginStpendMacros(this.m_newValue);
        }
    }
}

