/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IGeneratedTransformPort;
import com.sas.etl.models.job.IGeneratedTransformTemplate;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.BaseTransformTableOptions;
import com.sas.etl.models.job.impl.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseGeneratedTransformPort
extends AbstractPersistableObject
implements IGeneratedTransformPort {
    private IPhysicalTable m_dataObject = null;
    private boolean m_bInput = true;
    private String m_strPartnerName = "DEFAULT";
    private int m_intMinimum = 1;
    private int m_intMaximum = 1;
    private boolean m_bOptional = false;
    private IGeneratedTransformTemplate m_owningTemplate;
    private boolean m_bInUndoOrRedo = false;
    private ITransformTableOptions m_tableOption;

    public BaseGeneratedTransformPort(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void setOwningTemplate(IGeneratedTransformTemplate template) {
        this.m_owningTemplate = template;
        ITransformTableOptions tableOptions = this.getTransformTableOption();
        if (tableOptions != null) {
            tableOptions.setDisplayName(this.getOptionDisplayName());
        }
    }

    @Override
    public String getDefaultName() {
        return RB.getStringResource("BaseGeneratedTransformPort.DefaultName.txt");
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociation = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociation == null) {
            lAssociation = new ArrayList<String>();
        }
        lAssociation.add("UsingPrototype");
        map.put(this.getOMRType(), lAssociation);
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "AssociationProperty";
    }

    @Override
    public boolean isOptional() {
        return this.m_bOptional;
    }

    @Override
    public void setOptional(boolean optional) {
        if (this.m_bOptional == optional) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOptionalUndoable(this.m_bOptional, optional));
        }
        this.m_bOptional = optional;
        this.fireModelChangedEvent("IGeneratedTransformPort:OptionalChanged", null);
    }

    @Override
    public boolean isInUndoOrRedo() {
        return this.m_bInUndoOrRedo;
    }

    @Override
    public IPhysicalTable getTable() {
        return this.m_dataObject;
    }

    @Override
    public void setTable(IPhysicalTable dataObject) {
        this.setTable(dataObject, true);
    }

    public void setTable(IPhysicalTable dataObject, boolean createOptions) {
        if (this.m_dataObject == dataObject) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTableUndoable(this.m_dataObject, dataObject));
        }
        IPhysicalTable oldObject = this.m_dataObject;
        this.m_dataObject = dataObject;
        if (createOptions) {
            this.setTransformTableOption(this.m_dataObject != null ? this.createTransformTableOption(this.m_dataObject) : null);
        }
        this.fireModelChangedEvent("IGeneratedTransformPort:TableChanged", dataObject, oldObject);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_tableOption != null) {
            this.m_tableOption.updateIDs(mapIDs);
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_tableOption != null) {
            this.m_tableOption.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void delete() {
        if (this.m_tableOption != null) {
            this.m_tableOption.delete();
        }
        super.delete();
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_tableOption != null && this.m_tableOption.isChanged();
    }

    @Override
    public void dispose() {
        if (this.m_tableOption != null) {
            this.m_tableOption.dispose();
        }
        super.dispose();
    }

    protected ITransformTableOptions createTransformTableOption(IPhysicalTable table) {
        BaseTransformTableOptions optionSet = new BaseTransformTableOptions(this.createIDForNewObject(), this.getModel());
        optionSet.setOptionTable(table);
        optionSet.setAccessTypeInput(this.isInputTemplate());
        optionSet.setOwner(this);
        optionSet.setDisplayName(this.getOptionDisplayName());
        return optionSet;
    }

    @Override
    public ITransformTableOptions getTransformTableOption() {
        return this.m_tableOption;
    }

    public void setTransformTableOption(ITransformTableOptions tableOptions) {
        if (tableOptions == this.m_tableOption) {
            return;
        }
        if (this.m_tableOption != null) {
            this.addToDeletedObjects(this.m_tableOption);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTransformTableOptionUndoable(this.m_tableOption, tableOptions));
        }
        this.m_tableOption = tableOptions;
        if (this.m_tableOption != null) {
            this.removeFromDeletedObjects(this.m_tableOption);
            this.m_tableOption.setOwner(this);
        }
        this.fireModelChangedEvent("DataTransform.TransformTableOptionAddded", this.m_tableOption);
    }

    @Override
    public boolean isDefaultTemplate() {
        String pName = this.getPartnerName();
        int index = pName.indexOf(":");
        if (index > -1) {
            pName = pName.substring(0, index);
        }
        return pName == null || pName.equals("DEFAULT");
    }

    @Override
    public String getMacro() {
        String partnerName = this.getPartnerName();
        if (!this.isDefaultTemplate()) {
            int iEnd = partnerName.indexOf(":");
            if (iEnd > -1) {
                partnerName = partnerName.substring(0, iEnd);
            }
        } else if (this.m_owningTemplate != null) {
            partnerName = this.isInputTemplate() ? "_INPUT" + this.m_owningTemplate.getPortIndex(this) : "_OUTPUT" + this.m_owningTemplate.getPortIndex(this);
        }
        return partnerName;
    }

    @Override
    public boolean isInputTemplate() {
        return this.m_bInput;
    }

    @Override
    public void setAsInputTemplate(boolean input) {
        if (this.m_bInput == input) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetInputUndoable(this.m_bInput, input));
        }
        this.m_bInput = input;
        this.fireModelChangedEvent("IGeneratedTransformPort:InputChanged", null);
    }

    @Override
    public int getMinimum() {
        return this.m_intMinimum;
    }

    @Override
    public void setMinimum(int min) {
        if (this.m_intMinimum == min) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMinimumUndoable(this.m_intMinimum, min));
        }
        this.m_intMinimum = min;
        this.fireModelChangedEvent("IGeneratedTransformPort:MinimumChanged", null);
    }

    @Override
    public int getMaximum() {
        return this.m_intMaximum;
    }

    @Override
    public void setMaximum(int max) {
        if (this.m_intMaximum == max) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMinimumUndoable(this.m_intMaximum, max));
        }
        this.m_intMaximum = max;
        this.fireModelChangedEvent("IGeneratedTransformPort:MaximumChanged", null);
    }

    @Override
    public void setPartnerName(String partnerName) {
        if (this.m_strPartnerName.equals(partnerName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPartnerNameUndoable(this.m_strPartnerName, partnerName));
        }
        this.m_strPartnerName = partnerName;
        this.fireModelChangedEvent("IGeneratedTransformPort:PartnerNameChanged", null);
    }

    @Override
    public String getPartnerName() {
        return this.m_strPartnerName;
    }

    public boolean equals(IGeneratedTransformPort port) {
        boolean equals = false;
        if (port != null) {
            return port.getMaximum() == this.getMaximum() && port.getMinimum() == this.getMinimum() && port.isOptional() == this.isOptional() && port.isInputTemplate() == this.isInputTemplate() && port.getName().equals(this.getName()) && port.getPartnerName() == this.getPartnerName() && port.getTable() == this.getTable();
        }
        return equals;
    }

    @Override
    public int hashcode() {
        return super.hashCode();
    }

    @Override
    public IGeneratedTransformPort copy(String containerId) {
        IGeneratedTransformPort port = this.getModel().getObjectFactory().createNewGeneratedTransformPort(containerId);
        port.setName(this.getName());
        port.setDescription(this.getDescription());
        port.setTable(this.getTable());
        port.setPartnerName(this.getPartnerName());
        port.setMinimum(this.getMinimum());
        port.setMaximum(this.getMaximum());
        port.setAsInputTemplate(this.isInputTemplate());
        port.setOptional(this.isOptional());
        return port;
    }

    @Override
    public IGeneratedTransformPort copySimpleAttributes(IGeneratedTransformPort portToCopy) {
        this.startCompoundUndoable();
        try {
            this.setName(portToCopy.getName());
            this.setDescription(portToCopy.getDescription());
            this.setPartnerName(portToCopy.getPartnerName());
            this.setMinimum(portToCopy.getMinimum());
            this.setMaximum(portToCopy.getMaximum());
            this.setAsInputTemplate(portToCopy.isInputTemplate());
            this.setOptional(portToCopy.isOptional());
        }
        finally {
            this.endCompoundUndoable();
        }
        return this;
    }

    private String getOptionDisplayName() {
        return this.getName() + " - " + this.getMacro();
    }

    protected boolean loadTransformTableOptionsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Root mdAnchor = omr.acquireOMRObject(this);
        boolean changed = false;
        AssociationList propertySets = mdAnchor.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            PropertySet pSet = (PropertySet)propertySets.get(i);
            if (!"TransformTableOptions".equals(pSet.getSetRole())) continue;
            BaseTransformTableOptions transformOpts = new BaseTransformTableOptions(pSet.getFQID(), this.getModel());
            if (this.getTable() == transformOpts.loadAssociatedObject(omr, pSet.getFQID())) {
                transformOpts.setOwner(this);
                transformOpts.loadFromOMR(omr);
                transformOpts.setDisplayName(this.getOptionDisplayName());
                this.setTransformTableOption(transformOpts);
                continue;
            }
            this.addToDeletedObjects(transformOpts);
            changed = true;
        }
        return changed;
    }

    protected ITransformTableOptions findTransformTableOptionsFromOMR(OMRAdapter omr, IPhysicalTable table) throws MdException, RemoteException {
        Root mdAnchor = omr.acquireOMRObject(this);
        AssociationList propertySets = mdAnchor.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            BaseTransformTableOptions transformOpts;
            IPhysicalTable associatedtable;
            PropertySet pSet = (PropertySet)propertySets.get(i);
            if (!"TransformTableOptions".equals(pSet.getSetRole()) || (associatedtable = (transformOpts = new BaseTransformTableOptions(pSet.getFQID(), this.getModel())).loadAssociatedObject(omr, pSet.getFQID())) != table) continue;
            transformOpts.setOwner(this);
            transformOpts.loadFromOMR(omr);
            return transformOpts;
        }
        return null;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        AssociationProperty associationProperty = (AssociationProperty)omr.acquireOMRObject(this);
        this.setPartnerName(associationProperty.getPartnerName());
        this.setAsInputTemplate(associationProperty.getMetadataType().equals("INPUT"));
        Root mdObj = associationProperty.getUsingPrototype();
        IPhysicalTable table = null;
        if (mdObj != null && mdObj instanceof PhysicalTable) {
            table = (IPhysicalTable)omr.acquireObject(mdObj);
        }
        this.setTable(table, false);
        this.setMinimum(associationProperty.getMinimum());
        this.setMaximum(associationProperty.getMaximum());
        boolean changed = this.loadTransformTableOptionsFromOMR(omr);
        if (table != null && this.getTransformTableOption() == null) {
            this.setTransformTableOption(this.createTransformTableOption(table));
        }
        this.setChanged(changed);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        AssociationProperty associationProperty = (AssociationProperty)omr.acquireOMRObject(this);
        associationProperty.setPartnerName(this.getPartnerName());
        associationProperty.setMetadataType(this.isInputTemplate() ? "INPUT" : "OUTPUT");
        associationProperty.setAssociationName("ClassifierSources");
        IPhysicalTable table = this.getTable();
        if (table != null) {
            associationProperty.setUsingPrototype(omr.acquireOMRObject(table));
        } else {
            associationProperty.getUsingPrototypes().clear();
        }
        associationProperty.setMinimum(this.getMinimum());
        associationProperty.setMaximum(this.getMaximum());
        associationProperty.setIsVisible(1);
        associationProperty.setIsRequired(1);
        this.saveTransformTableOptions(omr);
        this.setChanged(false);
    }

    protected void saveTransformTableOptions(OMRAdapter omr) throws MdException, RemoteException {
        ITransformTableOptions opts = this.getTransformTableOption();
        if (opts != null) {
            opts.saveToOMR(omr);
        }
    }

    private class SetOptionalUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldOptional;
        private boolean m_newOptional;

        public SetOptionalUndoable(boolean oldOptional, boolean newOptional) {
            this.m_oldOptional = oldOptional;
            this.m_newOptional = newOptional;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformPort.this.setOptional(this.m_oldOptional);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformPort.this.setOptional(this.m_newOptional);
        }
    }

    private class SetTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_oldTable;
        private IPhysicalTable m_newTable;

        public SetTableUndoable(IPhysicalTable oldTable, IPhysicalTable newTable) {
            this.m_oldTable = oldTable;
            this.m_newTable = newTable;
        }

        @Override
        public void undo() {
            BaseGeneratedTransformPort.this.m_bInUndoOrRedo = true;
            try {
                super.undo();
                BaseGeneratedTransformPort.this.setTable(this.m_oldTable);
            }
            finally {
                BaseGeneratedTransformPort.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void redo() {
            BaseGeneratedTransformPort.this.m_bInUndoOrRedo = true;
            try {
                super.redo();
                BaseGeneratedTransformPort.this.setTable(this.m_newTable);
            }
            finally {
                BaseGeneratedTransformPort.this.m_bInUndoOrRedo = false;
            }
        }
    }

    private class SetTransformTableOptionUndoable
    extends AbstractUndoableEdit {
        private ITransformTableOptions m_oldObject;
        private ITransformTableOptions m_newObject;

        public SetTransformTableOptionUndoable(ITransformTableOptions oldObject, ITransformTableOptions newObject) {
            this.m_oldObject = oldObject;
            this.m_newObject = newObject;
        }

        @Override
        public void undo() {
            BaseGeneratedTransformPort.this.m_bInUndoOrRedo = true;
            try {
                super.undo();
                BaseGeneratedTransformPort.this.setTransformTableOption(this.m_oldObject);
            }
            finally {
                BaseGeneratedTransformPort.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void redo() {
            BaseGeneratedTransformPort.this.m_bInUndoOrRedo = true;
            try {
                super.redo();
                BaseGeneratedTransformPort.this.setTransformTableOption(this.m_newObject);
            }
            finally {
                BaseGeneratedTransformPort.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void die() {
            this.m_newObject = null;
            this.m_oldObject = null;
            super.die();
        }
    }

    private class SetInputUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldInput;
        private boolean m_newInput;

        public SetInputUndoable(boolean oldInput, boolean newInput) {
            this.m_oldInput = oldInput;
            this.m_newInput = newInput;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformPort.this.setAsInputTemplate(this.m_oldInput);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformPort.this.setAsInputTemplate(this.m_newInput);
        }
    }

    private class SetMinimumUndoable
    extends AbstractUndoableEdit {
        private int m_oldMinimum;
        private int m_newMinimum;

        public SetMinimumUndoable(int oldMinimum, int newMinimum) {
            this.m_oldMinimum = oldMinimum;
            this.m_newMinimum = newMinimum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformPort.this.setMinimum(this.m_oldMinimum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformPort.this.setMinimum(this.m_newMinimum);
        }
    }

    private class SetPartnerNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldPartnerName;
        private String m_newPartnerName;

        public SetPartnerNameUndoable(String oldPartnerName, String newPartnerName) {
            this.m_oldPartnerName = oldPartnerName;
            this.m_newPartnerName = newPartnerName;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformPort.this.setPartnerName(this.m_oldPartnerName);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformPort.this.setPartnerName(this.m_newPartnerName);
        }
    }

    private class SetMaximumUndoable
    extends AbstractUndoableEdit {
        private int m_oldMaximum;
        private int m_newMaximum;

        public SetMaximumUndoable(int oldMaximum, int newMaximum) {
            this.m_oldMaximum = oldMaximum;
            this.m_newMaximum = newMaximum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformPort.this.setMaximum(this.m_oldMaximum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformPort.this.setMaximum(this.m_newMaximum);
        }
    }
}

