/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeFragment;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TextStore;
import java.rmi.RemoteException;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseCodeFragment
extends AbstractPersistableObject
implements ICodeFragment {
    private String m_sCode = "";
    private String m_sTextRole = "SAS code";
    private String m_sTextType = "SAS";

    public BaseCodeFragment(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getTextRole() {
        return this.m_sTextRole;
    }

    @Override
    public void setTextRole(String textRole) {
        this.m_sTextRole = textRole;
    }

    @Override
    public String getTextType() {
        return this.m_sTextType;
    }

    @Override
    public void setTextType(String textType) {
        this.m_sTextType = textType;
    }

    @Override
    public String getOMRType() {
        return "TextStore";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        TextStore mdoCode = (TextStore)omr.acquireOMRObject(this);
        mdoCode.setTextRole(this.getTextRole());
        mdoCode.setTextType(this.getTextType());
        mdoCode.setStoredText(this.m_sCode);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        TextStore mdoCode = (TextStore)omr.acquireOMRObject(this);
        this.setCode(mdoCode.getStoredText());
        this.setTextRole(mdoCode.getTextRole());
        this.setTextType(this.getTextType());
        this.setChanged(false);
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public void setCode(String sCode) {
        if (sCode == null) {
            sCode = "";
        }
        if (this.m_sCode.equals(sCode)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCodeUndoable(this.m_sCode, sCode));
        }
        this.m_sCode = sCode;
        this.fireModelChangedEvent("CodeSource:CodeChanged", null);
    }

    @Override
    public String getCode() {
        return this.m_sCode;
    }

    private class SetCodeUndoable
    extends AbstractUndoableEdit {
        private String m_oldCode;
        private String m_newCode;

        public SetCodeUndoable(String oldCode, String newCode) {
            this.m_oldCode = oldCode;
            this.m_newCode = newCode;
        }

        @Override
        public void undo() {
            super.undo();
            BaseCodeFragment.this.setCode(this.m_oldCode);
        }

        @Override
        public void redo() {
            super.redo();
            BaseCodeFragment.this.setCode(this.m_newCode);
        }
    }
}

