/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IBooleanExpression;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Variable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseBooleanExpression
extends AbstractPersistableObject
implements IBooleanExpression {
    protected static final String LEFT_VARIABLE_NAME = "LeftOperand";
    protected static final String LEFT_SUBSTITUTE_VARIABLE = "[1]";
    protected static final String RIGHT_VARIABLE_NAME = "RightOperand";
    protected static final String RIGHT_SUBSTITUTE_VARIABLE = "[2]";
    protected static final String OPEN_PARENTHESIS = "OpenParenthesis";
    protected static final String CLOSE_PARENTHESIS = "CloseParenthesis";
    protected static final String LOGICAL_OPERATOR = "LogicalOperator";
    private String m_sLogicalOperator = "";
    private IExpression m_leftOperand;
    private String m_sOperator = "=";
    private IExpression m_rightOperand;
    private int m_iOpenParenthesisCount = 0;
    private int m_iClosedParenthesisCount = 0;
    protected List m_lSubstituteVariablesIDs = new ArrayList();
    private String m_sSourceCodeID;
    private boolean m_bUseSQLSyntax = false;

    public BaseBooleanExpression(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    protected String getDefaultName() {
        return "SQLExpression";
    }

    @Override
    public void notify(NotifyEvent ev) {
        IObject object = (IObject)ev.getSource();
        if (ev.getType() == 1) {
            if (object == this.m_leftOperand) {
                this.fireModelChangedEvent("BooleanExpression:LeftOperandChanged", this.m_leftOperand);
            } else if (object == this.m_rightOperand) {
                this.fireModelChangedEvent("BooleanExpression:RightOperandChanged", this.m_rightOperand);
            }
        } else {
            super.notify(ev);
        }
    }

    @Override
    public void setLogicalOperator(String sLogicalOperator) {
        if (this.m_sLogicalOperator.equals(sLogicalOperator)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLogicalOperatorUndoable(this.m_sLogicalOperator, sLogicalOperator));
        }
        this.m_sLogicalOperator = sLogicalOperator;
        this.fireModelChangedEvent("BooleanExpression:LogicalOperatorChanged", null);
    }

    @Override
    public String getLogicalOperator() {
        return this.m_sLogicalOperator;
    }

    @Override
    public void setOpenParenthesisCount(int iCount) {
        if (this.m_iOpenParenthesisCount == iCount) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOpenParenthesisCountUndoable(this.m_iOpenParenthesisCount, iCount));
        }
        this.m_iOpenParenthesisCount = iCount;
        this.fireModelChangedEvent("BooleanExpression:OpenParenthesisChanged", null);
    }

    @Override
    public int getOpenParenthesisCount() {
        return this.m_iOpenParenthesisCount;
    }

    @Override
    public void setLeftOperand(IExpression operand) {
        if (this.m_leftOperand == null && operand == null) {
            return;
        }
        if (this.m_leftOperand != null && this.m_leftOperand.equals(operand)) {
            return;
        }
        this.setLeftOperandImpl(operand);
        if (this.m_leftOperand != null) {
            this.m_leftOperand.setUseSQLSyntax(this.isUseSQLSyntax());
        }
    }

    private void setLeftOperandImpl(IExpression operand) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLeftOperandUndoable(this.m_leftOperand, operand));
        }
        if (this.m_leftOperand != null) {
            this.addToDeletedObjects(this.m_leftOperand);
            this.m_leftOperand.removeNotifyListener(this);
        }
        if (operand != null) {
            this.removeFromDeletedObjects(operand);
        }
        this.m_leftOperand = operand;
        if (this.m_leftOperand != null) {
            this.m_leftOperand.addNotifyListener(this);
        }
        this.fireModelChangedEvent("BooleanExpression:LeftOperandChanged", null);
    }

    @Override
    public IExpression getLeftOperand() {
        return this.m_leftOperand;
    }

    @Override
    public boolean isUseSQLSyntax() {
        return this.m_bUseSQLSyntax;
    }

    @Override
    public void setUseSQLSyntax(boolean useSQLSyntax) {
        IExpression right;
        if (this.m_bUseSQLSyntax == useSQLSyntax) {
            return;
        }
        this.m_bUseSQLSyntax = useSQLSyntax;
        IExpression left = this.getLeftOperand();
        if (left != null) {
            left.setUseSQLSyntax(this.m_bUseSQLSyntax);
        }
        if ((right = this.getRightOperand()) != null) {
            right.setUseSQLSyntax(this.m_bUseSQLSyntax);
        }
    }

    @Override
    public void setOperator(String sOperator) {
        if (this.m_sOperator.equals(sOperator)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOperatorUndoable(this.m_sOperator, sOperator));
        }
        this.m_sOperator = sOperator;
        this.fireModelChangedEvent("BooleanExpression:OperatorChanged", null);
    }

    @Override
    public String getOperator() {
        return this.m_sOperator;
    }

    @Override
    public void setRightOperand(IExpression operand) {
        if (this.m_rightOperand == null && operand == null) {
            return;
        }
        if (this.m_rightOperand != null && this.m_rightOperand.equals(operand)) {
            return;
        }
        this.setRightOperandImpl(operand);
        if (this.m_rightOperand != null) {
            this.m_rightOperand.setUseSQLSyntax(this.isUseSQLSyntax());
        }
    }

    private void setRightOperandImpl(IExpression operand) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRightOperandUndoable(this.m_rightOperand, operand));
        }
        if (this.m_rightOperand != null) {
            this.addToDeletedObjects(this.m_rightOperand);
            this.m_rightOperand.removeNotifyListener(this);
        }
        if (operand != null) {
            this.removeFromDeletedObjects(operand);
        }
        this.m_rightOperand = operand;
        if (this.m_rightOperand != null) {
            this.m_rightOperand.addNotifyListener(this);
        }
        this.fireModelChangedEvent("BooleanExpression:RightOperandChanged", null);
    }

    @Override
    public IExpression getRightOperand() {
        return this.m_rightOperand;
    }

    @Override
    public void setClosedParenthesisCount(int iCount) {
        if (this.m_iClosedParenthesisCount == iCount) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetClosedParenthesisCountUndoable(this.m_iClosedParenthesisCount, iCount));
        }
        this.m_iClosedParenthesisCount = iCount;
        this.fireModelChangedEvent("BooleanExpression:ClosedParenthesisChanged", null);
    }

    @Override
    public int getClosedParenthesisCount() {
        return this.m_iClosedParenthesisCount;
    }

    @Override
    public boolean isComplete() {
        if (this.m_leftOperand != null && !this.m_leftOperand.isComplete()) {
            return false;
        }
        if (this.m_rightOperand != null && !this.m_rightOperand.isComplete()) {
            return false;
        }
        return this.m_leftOperand != null || this.m_rightOperand != null;
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (this.m_leftOperand != null && !this.m_leftOperand.isComplete()) {
            reasons.add(RB.getStringResource("BaseBooleanExpression.ReasonsIncomplete.LeftOperand.txt"));
            reasons.addAll(this.m_leftOperand.getReasonsIncomplete());
        }
        if (this.m_rightOperand != null && !this.m_rightOperand.isComplete()) {
            reasons.add(RB.getStringResource("BaseBooleanExpression.ReasonsIncomplete.RightOperand.txt"));
            reasons.addAll(this.m_rightOperand.getReasonsIncomplete());
        }
        if (this.m_leftOperand == null && this.m_rightOperand == null) {
            reasons.add(RB.getStringResource("BaseBooleanExpression.ReasonsIncomplete.NoOperands.txt"));
        }
        return reasons;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_leftOperand != null && this.m_leftOperand.isChanged() || this.m_rightOperand != null && this.m_rightOperand.isChanged();
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        int i;
        if (this.m_sLogicalOperator != null && this.m_sLogicalOperator.length() > 0) {
            codeSegment.addSourceCode(this.m_sLogicalOperator).addSourceCode(" ");
        }
        if (this.m_iOpenParenthesisCount > 0) {
            for (i = 0; i < this.m_iOpenParenthesisCount; ++i) {
                codeSegment.addSourceCode("(");
            }
        }
        if (this.m_leftOperand != null) {
            this.m_leftOperand.getGeneratedCode(codeSegment, passthru).addSourceCode(!(this.m_leftOperand instanceof ICaseStatement) ? " " : "\n");
        }
        if (this.m_sOperator != null && this.m_sOperator.length() > 0) {
            codeSegment.addSourceCode(this.m_sOperator).addSourceCode(!(this.m_rightOperand instanceof ICaseStatement) ? " " : "\n");
        }
        if (this.m_rightOperand != null) {
            this.m_rightOperand.getGeneratedCode(codeSegment, passthru);
        }
        if (this.m_iClosedParenthesisCount > 0) {
            for (i = 0; i < this.m_iClosedParenthesisCount; ++i) {
                codeSegment.addSourceCode(")");
            }
        }
        return codeSegment;
    }

    @Override
    public String getText(IServer currentServer, boolean quotes) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getText(currentServer, quotes, false);
    }

    @Override
    public String getText(IServer currentServer, boolean quotes, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        int i;
        StringBuffer text = new StringBuffer();
        if (this.m_sLogicalOperator != null && this.m_sLogicalOperator.length() > 0) {
            text.append(this.m_sLogicalOperator).append(" ");
        }
        if (this.m_iOpenParenthesisCount > 0) {
            for (i = 0; i < this.m_iOpenParenthesisCount; ++i) {
                text.append("(");
            }
        }
        if (this.m_leftOperand != null) {
            text.append(this.m_leftOperand.getText(currentServer, quotes, passthru)).append(!(this.m_leftOperand instanceof ICaseStatement) ? " " : "\n");
        }
        if (this.m_sOperator != null && this.m_sOperator.length() > 0) {
            text.append(this.m_sOperator).append(!(this.m_rightOperand instanceof ICaseStatement) ? " " : "\n");
        }
        if (this.m_rightOperand != null) {
            text.append(this.m_rightOperand.getText(currentServer, quotes, passthru));
        }
        if (this.m_iClosedParenthesisCount > 0) {
            for (i = 0; i < this.m_iClosedParenthesisCount; ++i) {
                text.append(")");
            }
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public boolean containsColumn(IColumn column) {
        if (this.m_leftOperand != null && this.m_leftOperand.containsColumn(column)) {
            return true;
        }
        return this.m_rightOperand != null && this.m_rightOperand.containsColumn(column);
    }

    @Override
    public boolean containsTable(ITable table) {
        if (this.m_leftOperand != null && this.m_leftOperand.containsTable(table)) {
            return true;
        }
        return this.m_rightOperand != null && this.m_rightOperand.containsTable(table);
    }

    @Override
    public void replaceColumn(IColumn oldColumn, IColumn newColumn) {
        this.startCompoundUndoable();
        try {
            if (this.m_leftOperand != null) {
                this.m_leftOperand.replaceColumn(oldColumn, newColumn);
            }
            if (this.m_rightOperand != null) {
                this.m_rightOperand.replaceColumn(oldColumn, newColumn);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        boolean bLeftContainsColumn = false;
        boolean bRightContainsColumn = false;
        if (this.m_leftOperand != null) {
            bLeftContainsColumn = this.m_leftOperand.containsRememberedColumn(column);
        }
        if (this.m_rightOperand != null) {
            bRightContainsColumn = this.m_rightOperand.containsRememberedColumn(column);
        }
        return bLeftContainsColumn || bRightContainsColumn;
    }

    public static String getRole() {
        return "BooleanExpression";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contentEquals(Object o) {
        IBooleanExpression expr = null;
        if (!(o instanceof IBooleanExpression)) return false;
        expr = (IBooleanExpression)o;
        if (this.m_sOperator == null) {
            this.m_sOperator = "";
        }
        boolean bLeftEquals = false;
        if (this.m_leftOperand == null) {
            IExpression left = expr.getLeftOperand();
            if (left != null) return false;
            bLeftEquals = true;
        } else {
            bLeftEquals = this.m_leftOperand.contentEquals(expr.getLeftOperand());
        }
        boolean bRightEquals = false;
        if (this.m_rightOperand == null) {
            IExpression right = expr.getRightOperand();
            if (right != null) return false;
            bRightEquals = true;
            return bLeftEquals && bRightEquals && this.m_sOperator.equals(expr.getOperator());
        } else {
            bRightEquals = this.m_rightOperand.contentEquals(expr.getRightOperand());
        }
        return bLeftEquals && bRightEquals && this.m_sOperator.equals(expr.getOperator());
    }

    @Override
    public String getOMRType() {
        return "FeatureMap";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        mdoFM.setTransformRole(BaseBooleanExpression.getRole());
        this.saveLeftAndRightOperandsToOMR(omr, mdoFM);
        this.saveOperatorToOMR(omr, mdoFM);
        this.savePropertyToOMR(omr, "", OPEN_PARENTHESIS, OPEN_PARENTHESIS, OPEN_PARENTHESIS, new Integer(this.m_iOpenParenthesisCount).toString(), 12, 1);
        this.savePropertyToOMR(omr, "", CLOSE_PARENTHESIS, CLOSE_PARENTHESIS, CLOSE_PARENTHESIS, new Integer(this.m_iClosedParenthesisCount).toString(), 12, 1);
        this.savePropertyToOMR(omr, "", LOGICAL_OPERATOR, LOGICAL_OPERATOR, LOGICAL_OPERATOR, this.m_sLogicalOperator, 12, 1);
        this.setChanged(false);
    }

    protected void saveLeftAndRightOperandsToOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        String sVariableID;
        Root mdoLeftOperand = null;
        Root mdoRightOperand = null;
        if (this.m_leftOperand != null) {
            this.m_leftOperand.saveToOMR(omr);
            mdoLeftOperand = omr.acquireOMRObject(this.m_leftOperand);
        }
        if (this.m_rightOperand != null) {
            this.m_rightOperand.saveToOMR(omr);
            mdoRightOperand = omr.acquireOMRObject(this.m_rightOperand);
        }
        List lOldSubstituteVariablesIDs = this.m_lSubstituteVariablesIDs;
        this.m_lSubstituteVariablesIDs = new ArrayList(2);
        AssociationList lSubVars = mdoFM.getSubstitutionVariables(false);
        lSubVars.clear();
        if (mdoLeftOperand != null) {
            sVariableID = lOldSubstituteVariablesIDs.isEmpty() ? this.createIDForNewObject() : (String)lOldSubstituteVariablesIDs.remove(0);
            this.m_lSubstituteVariablesIDs.add(sVariableID);
            Variable mdoLeftVar = (Variable)omr.acquireOMRObject(sVariableID, "Variable");
            mdoLeftVar.setName(LEFT_VARIABLE_NAME);
            mdoLeftVar.setMarker(LEFT_SUBSTITUTE_VARIABLE);
            mdoLeftVar.setAssociatedObject(mdoLeftOperand);
            mdoLeftVar.setValueType(this.m_leftOperand.getExpressionType());
            lSubVars.add(mdoLeftVar);
        }
        if (mdoRightOperand != null) {
            sVariableID = lOldSubstituteVariablesIDs.isEmpty() ? this.createIDForNewObject() : (String)lOldSubstituteVariablesIDs.remove(0);
            this.m_lSubstituteVariablesIDs.add(sVariableID);
            Variable mdoRightVar = (Variable)omr.acquireOMRObject(sVariableID, "Variable");
            mdoRightVar.setName(RIGHT_VARIABLE_NAME);
            mdoRightVar.setMarker(RIGHT_SUBSTITUTE_VARIABLE);
            mdoRightVar.setAssociatedObject(mdoRightOperand);
            mdoRightVar.setValueType(this.m_rightOperand.getExpressionType());
            lSubVars.add(mdoRightVar);
        }
        while (!lOldSubstituteVariablesIDs.isEmpty()) {
            omr.deleteOMRObject((String)lOldSubstituteVariablesIDs.remove(0), "Variable");
        }
    }

    protected void saveOperatorToOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        if (this.m_sSourceCodeID == null || this.m_sSourceCodeID.length() == 0) {
            this.m_sSourceCodeID = this.createIDForNewObject();
        }
        TextStore mdoTS = (TextStore)omr.acquireOMRObject(this.m_sSourceCodeID, "TextStore");
        mdoTS.setName(this.getName());
        mdoTS.setTextRole(this.getName());
        mdoTS.setStoredText(this.createTextStoredString());
        mdoFM.setSourceCode((Text)mdoTS);
    }

    protected String createTextStoredString() {
        StringBuffer source = new StringBuffer();
        if (this.m_leftOperand != null) {
            source.append(LEFT_SUBSTITUTE_VARIABLE);
        }
        source.append(this.m_sOperator);
        if (this.m_rightOperand != null) {
            source.append(RIGHT_SUBSTITUTE_VARIABLE);
        }
        return source.toString();
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        this.loadOperatorFromOMR(omr, mdoFM);
        this.loadLeftAndRightOperandsFromOMR(omr, mdoFM);
        String sOpenParen = this.loadPropertyFromOMR(omr, "", OPEN_PARENTHESIS, new Integer(0).toString(), 33);
        this.setOpenParenthesisCount(new Integer(sOpenParen));
        String sCloseParen = this.loadPropertyFromOMR(omr, "", CLOSE_PARENTHESIS, new Integer(0).toString(), 33);
        this.setClosedParenthesisCount(new Integer(sCloseParen));
        this.setLogicalOperator(this.loadPropertyFromOMR(omr, "", LOGICAL_OPERATOR, "", 33));
        this.setChanged(false);
    }

    protected void loadOperatorFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        TextStore mdoTS = (TextStore)mdoFM.getSourceCode();
        if (mdoTS == null) {
            return;
        }
        this.m_sSourceCodeID = mdoTS.getFQID();
        String text = mdoTS.getStoredText().trim();
        if (text.length() < 1) {
            return;
        }
        int beginIndex = -1;
        int leftBeginIndex = text.indexOf(LEFT_SUBSTITUTE_VARIABLE);
        beginIndex = leftBeginIndex != -1 ? leftBeginIndex + LEFT_SUBSTITUTE_VARIABLE.length() : 0;
        int endIndex = -1;
        int rightBeginIndex = text.indexOf(RIGHT_SUBSTITUTE_VARIABLE);
        endIndex = rightBeginIndex != -1 ? rightBeginIndex : text.length();
        this.setOperator(text.substring(beginIndex, endIndex));
    }

    protected void loadLeftAndRightOperandsFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        this.m_lSubstituteVariablesIDs.clear();
        AssociationList lVariables = mdoFM.getSubstitutionVariables();
        Root mdoLeftOperand = null;
        Root mdoRightOperand = null;
        for (int i = 0; i < lVariables.size(); ++i) {
            Variable mdoVariable = (Variable)lVariables.get(i);
            this.m_lSubstituteVariablesIDs.add(mdoVariable.getFQID());
            String marker = mdoVariable.getMarker();
            if (marker.equalsIgnoreCase(LEFT_SUBSTITUTE_VARIABLE)) {
                mdoLeftOperand = mdoVariable.getAssociatedObject();
                continue;
            }
            if (!marker.equalsIgnoreCase(RIGHT_SUBSTITUTE_VARIABLE)) continue;
            mdoRightOperand = mdoVariable.getAssociatedObject();
        }
        if (mdoLeftOperand != null) {
            IExpression operand = (IExpression)omr.acquireObject(mdoLeftOperand);
            this.setLeftOperand(operand);
        }
        if (mdoRightOperand != null) {
            IExpression operand = (IExpression)omr.acquireObject(mdoRightOperand);
            this.setRightOperand(operand);
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_leftOperand != null) {
            this.m_leftOperand.deleteFromOMR(omr);
        }
        if (this.m_rightOperand != null) {
            this.m_rightOperand.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_leftOperand != null) {
            this.m_leftOperand.updateIDs(mapIDs);
        }
        if (this.m_rightOperand != null) {
            this.m_rightOperand.updateIDs(mapIDs);
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("FeatureSources");
        lAssociations.add("FeatureTargets");
        lAssociations.add("SubstitutionVariables");
        lAssociations.add("SourceCode");
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    private class SetLogicalOperatorUndoable
    extends AbstractUndoableEdit {
        private String m_oldLogicalOperator;
        private String m_newLogicalOperator;

        public SetLogicalOperatorUndoable(String oldLogicalOperator, String newLogicalOperator) {
            this.m_oldLogicalOperator = oldLogicalOperator;
            this.m_newLogicalOperator = newLogicalOperator;
        }

        @Override
        public void undo() {
            super.undo();
            BaseBooleanExpression.this.setLogicalOperator(this.m_oldLogicalOperator);
        }

        @Override
        public void redo() {
            super.redo();
            BaseBooleanExpression.this.setLogicalOperator(this.m_newLogicalOperator);
        }
    }

    private class SetOpenParenthesisCountUndoable
    extends AbstractUndoableEdit {
        private int m_oldOpenParenthesisCount;
        private int m_newOpenParenthesisCount;

        public SetOpenParenthesisCountUndoable(int oldOpenParenthesisCount, int newOpenParenthesisCount) {
            this.m_oldOpenParenthesisCount = oldOpenParenthesisCount;
            this.m_newOpenParenthesisCount = newOpenParenthesisCount;
        }

        @Override
        public void undo() {
            super.undo();
            BaseBooleanExpression.this.setOpenParenthesisCount(this.m_oldOpenParenthesisCount);
        }

        @Override
        public void redo() {
            super.redo();
            BaseBooleanExpression.this.setOpenParenthesisCount(this.m_newOpenParenthesisCount);
        }
    }

    private class SetLeftOperandUndoable
    extends AbstractUndoableEdit {
        private IExpression m_oldLeftOperand;
        private IExpression m_newLeftOperand;

        public SetLeftOperandUndoable(IExpression oldLeftOperand, IExpression newLeftOperand) {
            this.m_oldLeftOperand = oldLeftOperand;
            this.m_newLeftOperand = newLeftOperand;
        }

        @Override
        public void undo() {
            super.undo();
            BaseBooleanExpression.this.setLeftOperandImpl(this.m_oldLeftOperand);
        }

        @Override
        public void redo() {
            super.redo();
            BaseBooleanExpression.this.setLeftOperandImpl(this.m_newLeftOperand);
        }

        @Override
        public void die() {
            super.die();
            this.m_newLeftOperand = null;
            this.m_oldLeftOperand = null;
        }
    }

    private class SetOperatorUndoable
    extends AbstractUndoableEdit {
        private String m_oldOperator;
        private String m_newOperator;

        public SetOperatorUndoable(String oldOperator, String newOperator) {
            this.m_oldOperator = oldOperator;
            this.m_newOperator = newOperator;
        }

        @Override
        public void undo() {
            super.undo();
            BaseBooleanExpression.this.setOperator(this.m_oldOperator);
        }

        @Override
        public void redo() {
            super.redo();
            BaseBooleanExpression.this.setOperator(this.m_newOperator);
        }
    }

    private class SetRightOperandUndoable
    extends AbstractUndoableEdit {
        private IExpression m_oldRightOperand;
        private IExpression m_newRightOperand;

        public SetRightOperandUndoable(IExpression oldRightOperand, IExpression newRightOperand) {
            this.m_oldRightOperand = oldRightOperand;
            this.m_newRightOperand = newRightOperand;
        }

        @Override
        public void undo() {
            super.undo();
            BaseBooleanExpression.this.setRightOperandImpl(this.m_oldRightOperand);
        }

        @Override
        public void redo() {
            super.redo();
            BaseBooleanExpression.this.setRightOperandImpl(this.m_newRightOperand);
        }

        @Override
        public void die() {
            super.die();
            this.m_newRightOperand = null;
            this.m_oldRightOperand = null;
        }
    }

    private class SetClosedParenthesisCountUndoable
    extends AbstractUndoableEdit {
        private int m_oldClosedParenthesisCount;
        private int m_newClosedParenthesisCount;

        public SetClosedParenthesisCountUndoable(int oldClosedParenthesisCount, int newClosedParenthesisCount) {
            this.m_oldClosedParenthesisCount = oldClosedParenthesisCount;
            this.m_newClosedParenthesisCount = newClosedParenthesisCount;
        }

        @Override
        public void undo() {
            super.undo();
            BaseBooleanExpression.this.setClosedParenthesisCount(this.m_oldClosedParenthesisCount);
        }

        @Override
        public void redo() {
            super.redo();
            BaseBooleanExpression.this.setClosedParenthesisCount(this.m_newClosedParenthesisCount);
        }
    }
}

