/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.entities.GUID;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPasteModify;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.impl.AbstractSecondaryAttributeHelper;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICheckpointRestart;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.IUIPlacement;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.AbstractPrePostCodeContainer;
import com.sas.etl.models.job.impl.CheckpointRestart;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.impl.UIPlacement;
import com.sas.etl.models.job.impl.UIPlacementUtil;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BaseTransformPromptModel;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class AbstractTransform
extends AbstractPrePostCodeContainer
implements ITransform {
    protected static final String OPTIONS_PROPERTYSET = "OPTIONS";
    protected static final String UI_PROPERTY = "UI_PLACEMENT";
    private IPromptModel m_optionModel;
    private boolean m_bCodeGenerationEnabled = true;
    private int m_iInstanceVersion = 1;
    private String m_sSystemOptions = null;
    private IUserWrittenCodeContainer m_codeUserWritten;
    private IServer m_executionServer;
    private boolean m_bCollectDiagnostics;
    private boolean m_bCleanUpRequired = false;
    private SetJobHelper m_helper = new SetJobHelper();
    private boolean m_bGenerateDISHeaderAndFooters = true;
    private boolean m_bCheckpointEnabled;
    private boolean m_bRunAlways;
    private boolean m_bExplicitOn;
    private String m_sClearLibrefs;
    private IUIPlacement m_UIPlacement;

    public AbstractTransform(String sID, IModel model) {
        super(sID, model);
        this.m_codeUserWritten = model.getObjectFactory().createUserWrittenHelper(this);
        this.m_codeUserWritten.setActiveFlagLocation(2);
        this.m_bCheckpointEnabled = false;
        this.m_bRunAlways = false;
        this.m_sClearLibrefs = "JOB";
        try {
            this.getOptionModel();
        }
        catch (FileNotFoundException e) {
            ModelLogger.getDefaultLogger().debug((Object)"FileNotFoundException", (Throwable)e);
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().debug((Object)"RemoteException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().debug((Object)"ServiceException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().debug((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().debug((Object)"IOException", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().debug((Object)"ParserConfigurationException", (Throwable)e);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().debug((Object)"SAXException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().debug((Object)"MdException", (Throwable)e);
        }
    }

    @Override
    public void setJob(IJob job) {
        this.m_helper.set(job);
    }

    protected boolean is91StyleTransform() {
        return false;
    }

    protected void setDisplayType(String sDisplayType) {
    }

    protected void setType(String sType) {
    }

    @Override
    public IJob getJob() {
        return (IJob)this.m_helper.get();
    }

    protected abstract String getTransformRole();

    protected abstract String getTransformClass();

    @Override
    public boolean isCorrect() {
        return true;
    }

    protected void setExplicitOn(boolean bExplicitOn) {
        if (this.m_bExplicitOn == bExplicitOn) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExplicitOnUndoable(this.m_bExplicitOn, bExplicitOn));
        }
        this.m_bExplicitOn = bExplicitOn;
        this.fireModelChangedEvent("ITransform:ExplicitOnChanged", null);
    }

    @Override
    public boolean isExplicitOn() {
        return this.m_bExplicitOn;
    }

    @Override
    public boolean isCleanUpRequired() {
        return this.m_bCleanUpRequired;
    }

    protected void setCleanUpRequired(boolean bRequired) {
        if (this.m_bCleanUpRequired == bRequired) {
            return;
        }
        this.m_bCleanUpRequired = bRequired;
    }

    protected boolean doCleanUpRecovery() {
        return true;
    }

    @Override
    public boolean isComplete() {
        if (!super.isComplete()) {
            return false;
        }
        if (!this.m_codeUserWritten.isComplete()) {
            return false;
        }
        return this.m_optionModel == null || this.isUsingUserWrittenCode() || this.m_optionModel.isComplete();
    }

    @Override
    public boolean isCompleteWithUserWritten() {
        if (this.isUsingUserWrittenCode() && this.m_codeUserWritten.isComplete()) {
            return true;
        }
        return this.isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        ArrayList lReasons = new ArrayList();
        lReasons.addAll(super.getReasonsIncomplete());
        lReasons.addAll(this.m_codeUserWritten.getReasonsIncomplete());
        if (this.m_optionModel != null) {
            lReasons.addAll(this.m_optionModel.getReasonsIncomplete());
        }
        return lReasons;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_codeUserWritten != null && this.m_codeUserWritten.isChanged() || this.getUIPlacement().isChanged();
    }

    @Override
    public boolean isPublicObject() {
        return false;
    }

    @Override
    public final IPromptModel getOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServiceException, MdException, ServerConnectionException {
        if (this.m_optionModel == null) {
            this.m_optionModel = this.createOptionModel();
        }
        if (this.m_optionModel != null) {
            this.m_optionModel.updateModelValues();
        }
        return this.m_optionModel;
    }

    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new BaseTransformPromptModel(this.getModel(), this);
    }

    @Override
    public void dispose() {
        if (this.m_optionModel != null) {
            this.m_optionModel.dispose();
        }
        super.dispose();
    }

    @Override
    public String getType() {
        return this.getTransformClass();
    }

    protected int getMaximumPredecessorCount() {
        return 1;
    }

    protected int getMaximumSuccessorCount() {
        return 1;
    }

    @Override
    public UsageVersion getModelVersion() {
        return DEFAULT_TRANSFORM_MODEL_VERSION;
    }

    @Override
    public int getInstanceVersion() {
        return this.m_iInstanceVersion;
    }

    @Override
    public boolean isRunAlways() {
        return this.m_bRunAlways;
    }

    @Override
    public void setRunAlways(boolean bRunAlways) {
        if (this.m_bRunAlways == bRunAlways) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRunAlwaysUndoable(this.m_bRunAlways, bRunAlways));
        }
        this.m_bRunAlways = bRunAlways;
        this.fireModelChangedEvent("ITransform:RunAlwaysChanged", null);
    }

    @Override
    public boolean isCollectingDiagnostics() {
        return this.m_bCollectDiagnostics;
    }

    @Override
    public void setCollectDiagnostics(boolean collectDiagnostics) {
        if (collectDiagnostics == this.m_bCollectDiagnostics) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCollectDiagnosticsUndoable(this.m_bCollectDiagnostics, collectDiagnostics));
        }
        this.m_bCollectDiagnostics = collectDiagnostics;
        this.fireModelChangedEvent("ITransform:CollectDiagnosticsChanged", null);
    }

    @Override
    public boolean isCPRStepSetupComplete() {
        return this.isCheckpointEnabled() && this.isCodeGenerationEnabled();
    }

    @Override
    public boolean isCPRStepCodeNeeded() {
        return this.isCPRStepCodeNeeded(false);
    }

    @Override
    public boolean isCPRStepCodeNeeded(boolean bIKnowJobHasCheckpointOn) {
        boolean neededByStep = this.isCPRStepSetupComplete();
        if (bIKnowJobHasCheckpointOn) {
            return neededByStep;
        }
        return neededByStep && this.getJob().isCPRJobCodeNeeded(neededByStep);
    }

    @Override
    public boolean isCheckpointEnabled() {
        return this.m_bCheckpointEnabled;
    }

    @Override
    public boolean isCustomRestartSupported() {
        return false;
    }

    @Override
    public ICodeSegment getCPRCustomPreStepCode(ICodeSegment codeSegment) {
        if (this.isCustomRestartSupported()) {
            codeSegment.addSourceCode("Subclass override should have code to load info from job's save-state library (from prior run).");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getCPRCustomPostStepCode(ICodeSegment codeSegment) {
        if (this.isCustomRestartSupported()) {
            codeSegment.addSourceCode("Subclass override should have code to save info to jobs's save-state library.");
        }
        return codeSegment;
    }

    @Override
    public void setCheckpointEnabled(boolean enabled) {
        if (this.m_bCheckpointEnabled == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCheckpointEnabledUndoable(this.m_bCheckpointEnabled, enabled));
        }
        this.m_bCheckpointEnabled = enabled;
        this.fireModelChangedEvent("ITransform:CheckpointEnabledChanged", null);
    }

    @Override
    public void setCodeGenerationEnabled(boolean bEnabled) {
        if (this.m_bCodeGenerationEnabled == bEnabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCodeGenerationEnabledUndoable(this.m_bCodeGenerationEnabled, bEnabled));
        }
        this.m_bCodeGenerationEnabled = bEnabled;
        this.fireModelChangedEvent("ITransform:CodeGenerationEnabledChanged", null);
    }

    @Override
    public boolean isCodeGenerationEnabled() {
        return this.m_bCodeGenerationEnabled;
    }

    @Override
    public IPromptDefinitionValue[] getParameters(boolean includeSubComponents) {
        return super.getParameters();
    }

    @Override
    public final ICodeSegment getCompleteCode(ICodeGenerationEnvironment environment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getCompleteCode(environment.createNewCodeSegment(this));
    }

    @Override
    public final ICodeSegment getGeneratedCodeHeader(ICodeSegment codeSegment, IServer defaultServer, boolean isRemote, boolean isValidate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        this.getStepComment(codeSegment);
        if (this.isCodeGenerationEnabled() && this.isCompleteWithUserWritten()) {
            this.getValidVarNameCode(codeSegment, false);
            this.getGeneratedCodeHeaderMacrovars(codeSegment);
            this.getGeneratedDefaultParameterCode(codeSegment);
            IServer stepServer = this.getServerForStep(codeSegment.getCurrentServer());
            if (isRemote) {
                this.getGeneratedRemoteCodeStart(stepServer, codeSegment, defaultServer, isValidate);
            }
            this.getTransformSetup(codeSegment, isRemote, isValidate);
        }
        return codeSegment;
    }

    @Override
    public final ICodeSegment getGeneratedCodeFooter(ICodeSegment codeSegment, IServer defaultServer, boolean isRemote, boolean isValidate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.isCodeGenerationEnabled() && this.isCompleteWithUserWritten()) {
            this.removeGeneratedDefaultParameters(codeSegment);
            this.getTransformCompletion(codeSegment);
            if (isRemote) {
                this.getGeneratedRemoteCodeEnd(codeSegment.getCurrentServer(), codeSegment, defaultServer, isValidate);
            }
            this.getGeneratedCodeEnd(codeSegment);
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getCompleteValidateCode(ICodeGenerationEnvironment environment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getCompleteValidateCode(environment.createNewCodeSegment(this));
    }

    protected ICodeSegment getPreValidateCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return codeSegment;
    }

    protected ICodeSegment getPostValidateCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return codeSegment;
    }

    @Override
    public ICodeSegment getCompleteValidateCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        IServer previousServer = environment.getCurrentServer();
        try {
            boolean isRemote;
            if (!this.isValidateAvailable()) {
                ICodeSegment iCodeSegment = this.getValidateUnsupportedComment(codeSegment);
                return iCodeSegment;
            }
            if (this.isExplicitOn()) {
                ICodeSegment iCodeSegment = this.getValidateExplicitOnComment(codeSegment);
                return iCodeSegment;
            }
            IServer stepServer = this.getServerForStep(previousServer);
            boolean bl = isRemote = !ObjectComparator.isEqual(previousServer, stepServer);
            if (!this.isUsingUserWrittenCode()) {
                if (this.isGenerateDISHeaderAndFooters()) {
                    ICodeSegment header = codeSegment.createNewCodeSegment(this.getPreProcessCode());
                    header.setIndent(codeSegment.getIndents());
                    this.getGeneratedCodeHeader(header, previousServer, isRemote, true);
                    codeSegment.setIndent(header.getIndents());
                }
                if (this.isCodeGenerationEnabled()) {
                    if (this.isCompleteWithUserWritten()) {
                        this.getPreValidateCode(codeSegment);
                        this.getGeneratedCode(codeSegment, true);
                        this.getPostValidateCode(codeSegment);
                    } else {
                        List inc = this.getReasonsIncomplete();
                        for (int i = 0; i < inc.size(); ++i) {
                            codeSegment.addCommentLine(inc.get(i).toString());
                        }
                        codeSegment.addSourceCode("\n");
                    }
                }
                if (this.isGenerateDISHeaderAndFooters()) {
                    ICodeSegment footer = codeSegment.createNewCodeSegment(this.getPostProcessCode());
                    footer.setIndent(codeSegment.getIndents());
                    this.getGeneratedCodeFooter(footer, previousServer, isRemote, true);
                }
            }
        }
        catch (CodegenException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (MdException e) {
            codeSegment.handleException((Exception)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (BadServerDefinitionException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (BadLibraryDefinitionException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (ServerException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (Exception e) {
            codeSegment.handleException(e);
            throw new CodegenException(e, (IObject)this);
        }
        finally {
            codeSegment.getCodeGenerationEnvironment().setCurrentServer(previousServer);
        }
        return codeSegment;
    }

    protected ICheckpointRestart createNewCheckpointRestart() {
        return new CheckpointRestart(this);
    }

    @Override
    public ICodeSegment getCompleteCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        IServer previousServer = environment.getCurrentServer();
        try {
            IServer stepServer = this.getServerForStep(previousServer);
            boolean isRemote = !ObjectComparator.isEqual(previousServer, stepServer);
            boolean bIsComplete = this.isCompleteWithUserWritten();
            ICheckpointRestart cpr = this.createNewCheckpointRestart();
            cpr.getCheckpointRestartPreStepCode(codeSegment);
            if (this.isGenerateDISHeaderAndFooters()) {
                ICodeSegment header = codeSegment.createNewCodeSegment(this.getPreProcessCode());
                header.setIndent(codeSegment.getIndents());
                this.getGeneratedCodeHeader(header, previousServer, isRemote, false);
                codeSegment.setIndent(header.getIndents());
            }
            if (this.isCodeGenerationEnabled()) {
                if (bIsComplete) {
                    if (!this.isUsingUserWrittenCode()) {
                        this.getGeneratedCode(codeSegment);
                    } else {
                        codeSegment.genUserWrittenCode(this, false);
                    }
                } else {
                    List inc = this.getReasonsIncomplete();
                    for (int i = 0; i < inc.size(); ++i) {
                        codeSegment.addCommentLine(inc.get(i).toString());
                    }
                    codeSegment.addSourceCode("\n");
                }
            }
            if (this.isGenerateDISHeaderAndFooters()) {
                ICodeSegment footer = codeSegment.createNewCodeSegment(this.getPostProcessCode());
                footer.setIndent(codeSegment.getIndents());
                this.getGeneratedCodeFooter(footer, previousServer, isRemote, false);
            }
            cpr.getCheckpointRestartPostStepCode(codeSegment);
        }
        catch (CodegenException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (MdException e) {
            codeSegment.handleException((Exception)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (BadServerDefinitionException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (BadLibraryDefinitionException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (ServerException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (Exception e) {
            codeSegment.handleException(e);
            throw new CodegenException(e, (IObject)this);
        }
        finally {
            codeSegment.getCodeGenerationEnvironment().setCurrentServer(previousServer);
        }
        return codeSegment;
    }

    public ICodeSegment getValidVarNameCode(ICodeSegment codeSegment, boolean isRemote) {
        return codeSegment;
    }

    public ICodeSegment getClearLibraryCode(ICodeSegment codeSegment) throws CodegenException {
        IJob currentJob = this.getJob();
        if (currentJob != null) {
            if (!this.isClearLibrefEnabled()) {
                return codeSegment;
            }
        } else {
            return codeSegment;
        }
        ILibrary altTempLib = currentJob.getAlternateTemporaryLibrary();
        List localLiblist = codeSegment.getCodeGenerationEnvironment().getLibrariesGeneratedList();
        if (localLiblist != null && localLiblist.size() > 0) {
            for (int i = localLiblist.size() - 1; i > -1; --i) {
                ILibrary lib = null;
                lib = (ILibrary)localLiblist.get(i);
                if (altTempLib != null && currentJob.isDeletingAlternateTemporaryTables() && altTempLib.getID().equals(lib.getID()) || lib.isPreAssigned()) continue;
                codeSegment.addSourceCode("libname " + lib.getLibref() + " clear;\n");
                if (codeSegment.getCodeGenerationEnvironment().isGenerateRCSetCalls()) {
                    codeSegment.genRCSetCall("&syslibrc");
                }
                localLiblist.remove(lib);
            }
        }
        return codeSegment;
    }

    @Override
    public String getClearLibrefGeneration() {
        return this.m_sClearLibrefs;
    }

    @Override
    public void setClearLibrefGeneration(String value) {
        if (value == this.m_sClearLibrefs) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetClearLibrefsGenerationUndoable(this.m_sClearLibrefs, value));
        }
        this.m_sClearLibrefs = value;
        this.fireModelChangedEvent("ITransform::ClearLibrefTransformChanged", null);
    }

    @Override
    public boolean isClearLibrefEnabled() {
        if (this.getClearLibrefGeneration().equalsIgnoreCase("JOB")) {
            return this.getJob().isClearLibrefEnabled();
        }
        return this.getClearLibrefGeneration().equalsIgnoreCase("YES");
    }

    @Override
    public ICodeSegment getBodyCode(ICodeGenerationEnvironment environment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeSegment codeSegment = environment.createNewCodeSegment(this);
        codeSegment.setIsBody(true);
        try {
            if (this.isCodeGenerationEnabled()) {
                if (!this.isUsingUserWrittenCode()) {
                    if (this.isCompleteWithUserWritten()) {
                        this.getGeneratedCode(codeSegment);
                    } else {
                        List inc = this.getReasonsIncomplete();
                        for (int i = 0; i < inc.size(); ++i) {
                            codeSegment.addCommentLine(inc.get(i).toString());
                        }
                        codeSegment.addSourceCode("\n");
                    }
                } else {
                    IUserWrittenCodeContainer uw = this.getUserWrittenCode();
                    if (uw != null) {
                        codeSegment.addSourceCode(uw.getCode());
                    }
                }
            }
        }
        catch (CodegenException e) {
            codeSegment.handleException(e);
            throw e;
        }
        catch (ServerException e) {
            codeSegment.handleException(e);
            throw e;
        }
        return codeSegment;
    }

    public ICodeSegment getPreDiagnostics(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        return codeSegment;
    }

    public ICodeSegment getPostDiagnostics(ICodeSegment codeSegment) throws CodegenException {
        return codeSegment;
    }

    public ICodeSegment getRuntimeStatistics(ICodeSegment codeSegment) throws CodegenException {
        codeSegment.addCommentLine(RB.getStringResource("AbstractTransform.RunTimeStatistics.Comment.txt"));
        codeSegment.addSourceCode("%etls_setPerfInit;\n");
        codeSegment.addSourceCode("%perfstrt(txnname=%BQUOTE(_DISARM|");
        codeSegment.addSourceCode("&transformID|");
        codeSegment.addSourceCode("&syshostname");
        codeSegment.addSourceCode("|");
        codeSegment.addSourceCode(this.getAbsoluteName());
        if (codeSegment.getLoopCount() > 0) {
            codeSegment.addSourceCode("_&etls_filePrefix");
        }
        codeSegment.addSourceCode(")");
        if (codeSegment.isRunTableStatisticsEnabled()) {
            codeSegment.addSourceCode(", metrNam6=_DISROWCNT, metrDef6=Count32");
        }
        codeSegment.addSourceCode(")   ;\n\n");
        return codeSegment;
    }

    public ICodeSegment getRuntimeStatisticsComplete(ICodeSegment codeSegment) throws CodegenException {
        boolean isCollectingTableCounts = codeSegment.isRunTableStatisticsEnabled();
        if (!isCollectingTableCounts) {
            codeSegment.addSourceCode("%perfstop;\n\n");
        } else {
            codeSegment.addSourceCode("%perfstop(metrVal6=%sysfunc(max(&etls_recnt,-1)));\n");
            codeSegment.addSourceCode("%let etls_recnt=-1;\n\n");
        }
        return codeSegment;
    }

    public ICodeSegment getTransformCompletion(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException {
        if (this.isUsingUserWrittenCode()) {
            codeSegment.genRCSetCall("&syserr", false);
            codeSegment.genRCSetCall("&sqlrc", false);
        }
        if (this.isUsingPostProcessCode() && this.getPostProcessCode() != null) {
            codeSegment.genCodeSource(this.getPostProcessCode().getUserWrittenSourceCode(), ICodeSegment.POSTPROCESS_START_COMMENT, ICodeSegment.POSTPROCESS_END_COMMENT);
        }
        if (this.isCollectingDiagnostics()) {
            this.getPostDiagnostics(codeSegment);
        }
        if (codeSegment.isRunStatisticsEnabled()) {
            this.getRuntimeStatisticsComplete(codeSegment);
        }
        if (this.getJob().isRCSetSYSCCEnabled()) {
            codeSegment.genRCSetCall("&syscc", false).addSourceCode("\n");
        }
        return codeSegment;
    }

    public ICodeSegment getTransformSetup(ICodeSegment codeSegment, boolean isRemote, boolean isValidate) throws MdException, RemoteException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (this.isCollectingDiagnostics()) {
            this.getPreDiagnostics(codeSegment);
        }
        if (codeSegment.isRunStatisticsEnabled()) {
            this.getRuntimeStatistics(codeSegment);
        }
        if (this.isUsingPreProcessCode() && this.getPreProcessCode() != null) {
            codeSegment.genSaveSyslast();
            codeSegment.genCodeSource(this.getPreProcessCode().getUserWrittenSourceCode(), ICodeSegment.PREPROCESS_START_COMMENT, ICodeSegment.PREPROCESS_END_COMMENT);
            codeSegment.genRestoreSyslast();
        }
        return codeSegment;
    }

    public ICodeSegment getGeneratedRemoteCodeStart(IServer stepServer, ICodeSegment codeSegment, IServer currentServer, boolean isValidate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        ISASClientConnection conn = stepServer.getConnectClient();
        if (conn == null) {
            throw new CodegenException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), stepServer.getName()), (IObject)this);
        }
        if (!environment.isOnSignonCache(stepServer)) {
            environment.addToSignonCache(stepServer);
            conn.genAccessCode(codeSegment);
            codeSegment.addSourceCode("\n");
        }
        IJob job = this.getJob();
        codeSegment.genReturnCodeRemoteSetup(conn, codeSegment.getRuntimeStatsConnectMacros(codeSegment), isValidate, job.isRCSetSYSCCEnabled());
        codeSegment.genRemoteMacroVariablesSetup(environment.getRemoteMacroVariables(), conn.getHostName(), true);
        conn.genStartSubmit("sysrputsync = yes", codeSegment, true, codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled());
        environment.setCurrentServer(stepServer);
        codeSegment.indent();
        codeSegment.addSourceCode("%macro ").addSourceCode("etls_transformationStep").addSourceCode("(); \n").indent();
        if (environment.isQuoting()) {
            codeSegment.genValidvarnameOptionAny(true);
        }
        codeSegment.addSourceCode("\n");
        codeSegment.getRCSetMacro();
        return codeSegment;
    }

    public ICodeSegment getGeneratedRemoteCodeEnd(IServer stepServer, ICodeSegment codeSegment, IServer currentServer, boolean isValidate) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        ISASClientConnection conn = stepServer.getConnectClient();
        if (conn == null) {
            throw new CodegenException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), stepServer.getName()), (IObject)this);
        }
        if (codeSegment.isQuoting()) {
            codeSegment.genValidvarnameOptionReset();
        }
        codeSegment.genReturnCodeRemoteEnding(isValidate, this.isValidateAvailable(), this.getJob().isRCSetSYSCCEnabled());
        codeSegment.unIndent();
        codeSegment.addSourceCode("\n%mend ").addSourceCode("etls_transformationStep").addSourceCode("; \n\n").addSourceCode("%").addSourceCode("etls_transformationStep").addSourceCode(";\n\n");
        codeSegment.unIndent();
        this.getClearLibraryCode(codeSegment);
        conn.genEndSubmit(codeSegment, this.getJob().isRCSetSYSCCEnabled());
        return codeSegment;
    }

    public final ICodeSegment getValidateExplicitOnComment(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        String divider = codeSegment.repeat("=", 74);
        codeSegment.addSourceCode("/*").addSourceCode(divider).addSourceCode("* \n");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForStep(), this.getName(), this.getID());
        StringBuffer transformName = new StringBuffer();
        transformName.append(this.getDefaultName());
        if (!DEFAULT_TRANSFORM_MODEL_VERSION.equals((Object)this.getModelVersion())) {
            transformName.append(" (").append(RB.getStringResource("AbstractTransform.Version.txt")).append(" ").append(this.getModelVersion()).append(")");
        }
        codeSegment.genCommentLine(codeSegment.getCommentLabelForTransform(), transformName.toString(), "");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForDescription(), this.getDescription(), "");
        this.getSourceTargetComment(codeSegment);
        codeSegment.genCommentValidateExplicitOn(divider + "*");
        codeSegment.addSourceCode(" *").addSourceCode(divider).addSourceCode("*/ \n\n");
        return codeSegment;
    }

    public final ICodeSegment getValidateUnsupportedComment(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        String divider = codeSegment.repeat("=", 74);
        codeSegment.addSourceCode("/*").addSourceCode(divider).addSourceCode("* \n");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForStep(), this.getName(), this.getID());
        StringBuffer transformName = new StringBuffer();
        transformName.append(this.getDefaultName());
        if (!DEFAULT_TRANSFORM_MODEL_VERSION.equals((Object)this.getModelVersion())) {
            transformName.append(" (").append(RB.getStringResource("AbstractTransform.Version.txt")).append(" ").append(this.getModelVersion()).append(")");
        }
        codeSegment.genCommentLine(codeSegment.getCommentLabelForTransform(), transformName.toString(), "");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForDescription(), this.getDescription(), "");
        this.getSourceTargetComment(codeSegment);
        if (!this.isValidateAvailable()) {
            codeSegment.genCommentValidateUnsupported(divider + "*");
        }
        codeSegment.addSourceCode(" *").addSourceCode(divider).addSourceCode("*/ \n\n");
        return codeSegment;
    }

    public final ICodeSegment getStepComment(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        String divider = codeSegment.repeat("=", 74);
        codeSegment.addSourceCode("/*").addSourceCode(divider).addSourceCode("* \n");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForStep(), this.getName(), this.getID());
        StringBuffer transformName = new StringBuffer();
        transformName.append(this.getDefaultName());
        if (!DEFAULT_TRANSFORM_MODEL_VERSION.equals((Object)this.getModelVersion())) {
            transformName.append(" (").append(RB.getStringResource("AbstractTransform.Version.txt")).append(" ").append(this.getModelVersion()).append(")");
        }
        codeSegment.genCommentLine(codeSegment.getCommentLabelForTransform(), transformName.toString(), "");
        codeSegment.genCommentLine(codeSegment.getCommentLabelForDescription(), this.getDescription(), "");
        this.getSourceTargetComment(codeSegment);
        this.getAdditionalTransformationComment(codeSegment);
        if (this.isUsingUserWrittenCode()) {
            codeSegment.genCommentUserWrittenLine(this, codeSegment.getCommentLabelForUserWritten());
        }
        codeSegment.genCommentNotesLine(this, divider + "*");
        if (!this.isCodeGenerationEnabled()) {
            codeSegment.genCommentNotActive(divider + "*");
        }
        if (this.hasWarnings()) {
            codeSegment.genCommentLine("", "", "");
            codeSegment.genCommentLine(RB.getStringResource("AbstractTransform.Warnings.txt"), "", "");
            List warnings = this.getWarnings();
            for (int i = 0; i < warnings.size(); ++i) {
                codeSegment.genCommentLine(codeSegment.splitString(warnings.get(i).toString(), 73, false));
            }
        }
        codeSegment.addSourceCode(" *").addSourceCode(divider).addSourceCode("*/ \n\n");
        return codeSegment;
    }

    public ICodeSegment getSourceTargetComment(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        return codeSegment;
    }

    public ICodeSegment getAdditionalTransformationComment(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        return codeSegment;
    }

    public final ICodeSegment getGeneratedCodeHeaderMacrovars(ICodeSegment codeSegment) throws CodegenException {
        codeSegment.addSourceCode("%let transformID = %quote(").addSourceCode(this.getID()).addSourceCode(");\n");
        if (this.isResetTransformationReturnCodeWhenGeneratingCode()) {
            codeSegment.addSourceCode("%let trans_rc = 0;\n");
        }
        codeSegment.genDatetimeMacrovarAssignment("etls_stepStartTime", "datetime20.");
        return codeSegment;
    }

    public ICodeSegment getGeneratedCodeEnd(ICodeSegment codeSegment) throws CodegenException {
        this.getClearLibraryCode(codeSegment);
        codeSegment.addSourceCode("\n\n/** ").addSourceCode(RB.getStringResource("AbstractTransform.StepEnd.txt")).addSourceCode(" ").addSourceCode(this.getName()).addSourceCode(" **/\n\n");
        return codeSegment;
    }

    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validateCode) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        String systemOptions = this.getSystemOptions();
        if (systemOptions != null && systemOptions.length() > 0) {
            codeSegment.genSystemOptions(systemOptions);
        }
        return codeSegment;
    }

    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getGeneratedCode(codeSegment, false);
    }

    @Override
    public void setSystemOptions(String sOptions) {
        if (ObjectComparator.isEqual(this.m_sSystemOptions, sOptions)) {
            return;
        }
        if (sOptions != null && sOptions.isEmpty()) {
            sOptions = null;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSystemOptionsUndoable(this.m_sSystemOptions, sOptions));
        }
        this.m_sSystemOptions = sOptions;
        this.fireModelChangedEvent("ITransform:SystemOptionsChanged", null);
    }

    @Override
    public void setUseUserWrittenCode(boolean bUseUserWrittenCode) {
        this.m_codeUserWritten.setIsActive(bUseUserWrittenCode);
    }

    @Override
    public String getSystemOptions() {
        return this.m_sSystemOptions;
    }

    @Override
    public IUIPlacement getUIPlacement() {
        if (this.m_UIPlacement == null) {
            this.m_UIPlacement = new UIPlacement();
        }
        return this.m_UIPlacement;
    }

    private void setUIPlacement(IUIPlacement placement) {
        this.m_UIPlacement = placement;
    }

    @Override
    public boolean isUsingUserWrittenCode() {
        return this.m_codeUserWritten.isActive();
    }

    @Override
    public void setUserWrittenCode(ICodeSource code) {
        this.m_codeUserWritten.setUserWrittenSourceCode(code);
    }

    @Override
    public IUserWrittenCodeContainer getUserWrittenCode() {
        return this.m_codeUserWritten;
    }

    @Override
    public void setExecutionServer(IServer server) {
        if (this.m_executionServer == server) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExecutionServerUndoable(this.m_executionServer, server));
        }
        this.m_executionServer = server;
        this.fireModelChangedEvent("ITransform:ExecutionServerChanged", this.m_executionServer);
    }

    @Override
    public IServer getExecutionServer() {
        return this.m_executionServer;
    }

    public boolean isResetTransformationReturnCodeWhenGeneratingCode() {
        return true;
    }

    @Override
    public boolean isGenerateDISHeaderAndFooters() {
        return this.m_bGenerateDISHeaderAndFooters;
    }

    @Override
    public void setGenerateDISHeaderAndFooters(boolean generateHeaderFooters) {
        if (this.m_bGenerateDISHeaderAndFooters == generateHeaderFooters) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGenerateDISHeaderAndFooters(this.m_bGenerateDISHeaderAndFooters, generateHeaderFooters));
        }
        this.m_bGenerateDISHeaderAndFooters = generateHeaderFooters;
        this.setPreProcessEnabled(this.m_bGenerateDISHeaderAndFooters);
        this.setPostProcessEnabled(this.m_bGenerateDISHeaderAndFooters);
        this.fireModelChangedEvent("ICodeGenerator:GenerateDISHeaderAndFootersChanged", null);
    }

    @Override
    public IServer getServerForStep(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        IServer server = this.getExecutionServer();
        if (server == null) {
            server = defaultServer;
        }
        return server;
    }

    @Override
    public boolean isValidateAvailable() {
        return false;
    }

    @Override
    public void saveXMLToStream(OutputStream strm) throws IOException {
    }

    @Override
    public void loadXMLFromStream(InputStream strm) throws IOException {
    }

    @Override
    public String getOMRType() {
        return "TransformationStep";
    }

    @Override
    public String getPublicType() {
        return "TransformInstance";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return new UsageVersion(1, 0);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ++this.m_iInstanceVersion;
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        mdoStep.setTransformRole(this.getTransformRole());
        mdoStep.setIsActive(this.isCodeGenerationEnabled() ? 1 : 0);
        mdoStep.setIsUserDefined(this.isUsingUserWrittenCode() ? 1 : 0);
        AbstractTransformation mdoAnchor = this.getUserWrittenCodeAnchor(omr);
        if (mdoAnchor != null) {
            this.m_codeUserWritten.setContainerId(mdoAnchor.getFQID());
            this.m_codeUserWritten.setContainerOMRType(mdoAnchor.getCMetadataType());
            this.m_codeUserWritten.saveToOMR(omr);
        }
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, "SystemOptions", "SystemOptions", "SYSTEM", this.getSystemOptions(), 12, 2);
        this.saveBooleanOptionToOMR(omr, "ETLS_DIAGNOSTICS", this.isCollectingDiagnostics());
        this.saveBooleanOptionToOMR(omr, "GenerateDISHeaderFooter", this.m_bGenerateDISHeaderAndFooters);
        this.saveBooleanOptionToOMR(omr, OPTIONS_PROPERTYSET, "ENABLECHECKPOINT", this.isCheckpointEnabled());
        this.saveBooleanOptionToOMR(omr, "RUN_ALWAYS", this.isRunAlways());
        this.savePropertyToOMR(omr, OPTIONS_PROPERTYSET, "CLEARLIBREFSTRANSFORM", "CLEARLIBREFSTRANSFORM", "CLEARLIBREFSTRANSFORM", this.m_sClearLibrefs, 12, 2);
        this.saveStringOptionToOMR(omr, UI_PROPERTY, UIPlacementUtil.createXMLFromUIPlacement(this.getUIPlacement()));
        AssociationList computeLocations = mdoStep.getComputeLocations();
        for (int i = computeLocations.size() - 1; i >= 0; --i) {
            Root s = (Root)computeLocations.get(i);
            if (!"ServerContext".equals(s.getCMetadataType())) continue;
            computeLocations.remove(i);
        }
        if (this.m_executionServer != null) {
            computeLocations.add(omr.acquireOMRObject(this.m_executionServer));
        }
        this.saveTransformClassToOMR(omr);
        this.getUIPlacement().setChanged(false);
        this.setChanged(false);
    }

    protected void saveTransformClassToOMR(OMRAdapter omr) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, null, "Class", "Class", "", this.getTransformClass(), 12, 1);
        Workspace.getDefaultLogger().debug((Object)("Saving:  The transformation class property.  Transform Name: " + this.getName() + " ID: " + this.getID()));
    }

    protected AbstractTransformation getUserWrittenCodeAnchor(OMRAdapter omr) throws MdException, RemoteException {
        return (AbstractTransformation)omr.acquireOMRObject(this);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.m_codeUserWritten.updateIds(mapIDs);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Root host;
        AssociationList lHost;
        super.loadFromOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.setSystemOptions(this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, "SystemOptions", "", 2));
        this.setCollectDiagnostics(this.loadBooleanOptionFromOMR(omr, "ETLS_DIAGNOSTICS", false));
        this.setCodeGenerationEnabled(mdoStep.getIsActive() == 1);
        AbstractTransformation mdoAnchor = this.getUserWrittenCodeAnchor(omr);
        if (mdoAnchor != null) {
            this.m_codeUserWritten.setContainerId(mdoAnchor.getFQID());
            this.m_codeUserWritten.setContainerOMRType(mdoAnchor.getCMetadataType());
            this.m_codeUserWritten.loadFromOMR(omr);
        }
        if (!(lHost = mdoStep.getComputeLocations()).isEmpty() && "ServerContext".equals((host = (Root)lHost.get(0)).getCMetadataType())) {
            IServer server = (IServer)omr.acquireObject(host);
            this.setExecutionServer(server);
        }
        Workspace.getDefaultLogger().debug((Object)("Loading: The transformation class property.  Transform Name: " + this.getName() + " ID: " + this.getID()));
        this.loadPropertyFromOMR(omr, null, "Class", this.getTransformClass(), 1);
        this.setGenerateDISHeaderAndFooters(this.loadBooleanOptionFromOMR(omr, "GenerateDISHeaderFooter", true));
        this.setCheckpointEnabled(this.loadBooleanOptionFromOMR(omr, OPTIONS_PROPERTYSET, "ENABLECHECKPOINT", false));
        this.setRunAlways(this.loadBooleanOptionFromOMR(omr, "RUN_ALWAYS", false));
        this.setUIPlacement(UIPlacementUtil.createUIPlacementFromXML(this.loadStringOptionFromOMR(omr, UI_PROPERTY, "")));
        String clearlibrefs_value = this.loadPropertyFromOMR(omr, OPTIONS_PROPERTYSET, "CLEARLIBREFSTRANSFORM", "JOB", 2);
        this.setClearLibrefGeneration(clearlibrefs_value);
        this.setChanged(false);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_codeUserWritten != null) {
            this.m_codeUserWritten.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        lAssociations.add("PredecessorDependencies");
        lAssociations.add("Properties");
        lAssociations.add("SourceCode");
        lAssociations.add("TransformationSources");
        lAssociations.add("TransformationTargets");
        lAssociations.add("ComputeLocations");
        lAssociations.add("ConditionActionSets");
        map.put("TransformationStep", lAssociations);
        lAssociations = new ArrayList<String>();
        lAssociations.add("SourceCode");
        map.put("Transformation", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("Successors");
        map.put("StepPrecedence", lAssociations);
        this.m_codeUserWritten.getOMRLoadTemplateMap(map);
        return map;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public List<IObject> pasteAction() throws MdException, RemoteException {
        this.getUIPlacement().setNodeId(GUID.newGUID());
        return new ArrayList<IObject>();
    }

    @Override
    public List<IPasteModify> getPasteChildObjects() {
        return null;
    }

    @Override
    public void dump(PrintStream strm) {
        super.dump(strm);
        strm.println("CodeGenerationEnabled=" + this.m_bCodeGenerationEnabled);
        strm.println("UseUserWrittenCode=" + this.m_codeUserWritten.isActive());
    }

    public void dumpObjectToXML(PrintStream stream, int order) {
        stream.println("<" + this.getPublicType());
        stream.println("order=\"" + Integer.toString(order) + "\" ");
        stream.println("name=\"" + this.getName() + "\" ");
        stream.println("description=\"" + this.getDescription() + "\" ");
        stream.println("enabled=\"" + this.isCodeGenerationEnabled() + "\" ");
        stream.println("userWritten=\"" + this.isUsingUserWrittenCode() + "\" >");
        this.dumpXML(stream);
        stream.println("</" + this.getPublicType() + ">");
    }

    @Override
    public void dumpXML(PrintStream stream) {
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
    }

    @Override
    public final ICodeSegment[] getCodeSegments(ICodeGenerationEnvironment environment) throws MdException, RemoteException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException, CodegenException {
        IServer stepServer;
        ArrayList<ICodeSegment> segments = new ArrayList<ICodeSegment>();
        IServer previousServer = environment.getDefaultServer();
        boolean isRemote = !ObjectComparator.isEqual(previousServer, stepServer = this.getServerForStep(previousServer));
        boolean bIsComplete = this.isCompleteWithUserWritten();
        ICodeSegment header = environment.createNewCodeSegment(this.getPreProcessCode());
        this.getGeneratedCodeHeader(header, previousServer, isRemote, false);
        segments.add(header);
        ICodeSegment body = environment.createNewCodeSegment(this);
        body.setIsBody(true);
        segments.add(body);
        if (this.isCodeGenerationEnabled()) {
            if (bIsComplete) {
                if (!this.isUsingUserWrittenCode()) {
                    this.getGeneratedCode(body);
                } else {
                    body.genUserWrittenCode(this, false);
                }
            } else {
                List inc = this.getReasonsIncomplete();
                for (int i = 0; i < inc.size(); ++i) {
                    body.addCommentLine(inc.get(i).toString());
                }
                body.addSourceCode("\n");
            }
        }
        ICodeSegment footer = environment.createNewCodeSegment(this.getPostProcessCode());
        this.getGeneratedCodeFooter(footer, previousServer, isRemote, false);
        segments.add(footer);
        return segments.toArray(new ICodeSegment[segments.size()]);
    }

    private class SetJobHelper
    extends AbstractSecondaryAttributeHelper {
        public SetJobHelper() {
            super(AbstractTransform.this);
        }

        @Override
        protected void addTo(IObject primary) {
            ((IJob)primary).getTransformsList().add(AbstractTransform.this);
        }

        @Override
        protected void removeFrom(IObject primary) {
            ((IJob)primary).getTransformsList().remove(AbstractTransform.this);
        }
    }

    private class SetExplicitOnUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldExplicitOn;
        private boolean m_newExplicitOn;

        public SetExplicitOnUndoable(boolean oldExplicitOn, boolean newExplicitOn) {
            this.m_oldExplicitOn = oldExplicitOn;
            this.m_newExplicitOn = newExplicitOn;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTransform.this.setExplicitOn(this.m_oldExplicitOn);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTransform.this.setExplicitOn(this.m_newExplicitOn);
        }
    }

    private class SetRunAlwaysUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldValue;
        private boolean m_bNewValue;

        public SetRunAlwaysUndoable(boolean bOldValue, boolean bNewValue) {
            this.m_bOldValue = bOldValue;
            this.m_bNewValue = bNewValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTransform.this.setRunAlways(this.m_bOldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTransform.this.setRunAlways(this.m_bNewValue);
        }
    }

    private class SetCollectDiagnosticsUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldUseDiagnostics;
        private boolean m_bNewUseDiagnostics;

        public SetCollectDiagnosticsUndoable(boolean bOldUseDiagnostics, boolean bNewUseDiagnostics) {
            this.m_bOldUseDiagnostics = bOldUseDiagnostics;
            this.m_bNewUseDiagnostics = bNewUseDiagnostics;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTransform.this.setCollectDiagnostics(this.m_bOldUseDiagnostics);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTransform.this.setCollectDiagnostics(this.m_bNewUseDiagnostics);
        }
    }

    private class SetCheckpointEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldCheckpointEnabled;
        private boolean m_bNewCheckpointEnabled;

        public SetCheckpointEnabledUndoable(boolean bOldCheckpointEnabled, boolean bNewCheckpointEnabled) {
            this.m_bOldCheckpointEnabled = bOldCheckpointEnabled;
            this.m_bNewCheckpointEnabled = bNewCheckpointEnabled;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTransform.this.setCheckpointEnabled(this.m_bOldCheckpointEnabled);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTransform.this.setCheckpointEnabled(this.m_bNewCheckpointEnabled);
        }
    }

    private class SetCodeGenerationEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOldEnabled;
        private boolean m_bNewEnabled;

        public SetCodeGenerationEnabledUndoable(boolean bOldEnabled, boolean bNewEnabled) {
            this.m_bOldEnabled = bOldEnabled;
            this.m_bNewEnabled = bNewEnabled;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTransform.this.setCodeGenerationEnabled(this.m_bOldEnabled);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTransform.this.setCodeGenerationEnabled(this.m_bNewEnabled);
        }
    }

    private class SetClearLibrefsGenerationUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetClearLibrefsGenerationUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTransform.this.setClearLibrefGeneration(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTransform.this.setClearLibrefGeneration(this.m_newValue);
        }
    }

    private class SetSystemOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldSystemOptions;
        private String m_newSystemOptions;

        public SetSystemOptionsUndoable(String oldSystemOptions, String newSystemOptions) {
            this.m_oldSystemOptions = oldSystemOptions;
            this.m_newSystemOptions = newSystemOptions;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTransform.this.setSystemOptions(this.m_oldSystemOptions);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTransform.this.setSystemOptions(this.m_newSystemOptions);
        }
    }

    private class SetExecutionServerUndoable
    extends AbstractUndoableEdit {
        private IServer m_serverOld;
        private IServer m_serverNew;

        public SetExecutionServerUndoable(IServer serverOld, IServer serverNew) {
            this.m_serverOld = serverOld;
            this.m_serverNew = serverNew;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTransform.this.setExecutionServer(this.m_serverOld);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTransform.this.setExecutionServer(this.m_serverNew);
        }
    }

    private class SetGenerateDISHeaderAndFooters
    extends AbstractUndoableEdit {
        private boolean m_bOldGenerateDISHeaderAndFooters;
        private boolean m_bNewGenerateDISHeaderAndFooters;

        public SetGenerateDISHeaderAndFooters(boolean bOldGenerateDISHeaderAndFooters, boolean bNewGenerateDISHeaderAndFooters) {
            this.m_bOldGenerateDISHeaderAndFooters = bOldGenerateDISHeaderAndFooters;
            this.m_bNewGenerateDISHeaderAndFooters = bNewGenerateDISHeaderAndFooters;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTransform.this.setGenerateDISHeaderAndFooters(this.m_bOldGenerateDISHeaderAndFooters);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTransform.this.setGenerateDISHeaderAndFooters(this.m_bNewGenerateDISHeaderAndFooters);
        }
    }
}

