/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractLoaderTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class AbstractBulkTableLoaderTransform
extends AbstractLoaderTransform {
    protected String m_sSaveDBMSType = "";

    public AbstractBulkTableLoaderTransform(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    protected String getTransformClass() {
        return null;
    }

    @Override
    protected String getTransformRole() {
        return null;
    }

    @Override
    public String getAbsoluteName() {
        return null;
    }

    @Override
    public String getDisplayType() {
        return null;
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.loadConditionActionSetTemplatesFromOMR();
    }

    public void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETDATAMODIFIED");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLECREATED");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLETRUNCATED");
    }

    protected void genMacroEnd(ICodeSegment codeSegment) {
        codeSegment.unIndent().addSourceCode("%mend etls_loader;\n").addSourceCode("%etls_loader;\n\n");
    }

    protected void genCodeConditionChecks(ICodeSegment codeSegment) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IPhysicalTable target = this.getTargetTable();
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CSUCCESSFUL", this, target);
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CWARNINGS", this, target);
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CERRORS", this, target);
    }

    protected String genMappingStepCode(ICodeSegment codeSegment, String sourceDataOptions, IColumn loadTimeColumn) throws RemoteException, CodegenException, BadLibraryDefinitionException, MdException, BadServerDefinitionException, ServerException {
        ArrayList<IColumn> columnsToExcludeFromMapping = new ArrayList<IColumn>();
        if (loadTimeColumn != null) {
            columnsToExcludeFromMapping.add(loadTimeColumn);
        }
        boolean assignUnmappedEqMissing = false;
        IColumn[] unmappedColumns = null;
        if (!assignUnmappedEqMissing) {
            unmappedColumns = this.getOrdinaryUnmappedTargetColumns(columnsToExcludeFromMapping);
        }
        IPhysicalTable source = this.getSourceTable();
        IPhysicalTable target = this.getTargetTable();
        boolean isMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, target);
        String mappingStepOutputName = "";
        if (isMappingNeeded) {
            mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
            this.getOrdinaryMappingCode(codeSegment, source, target, mappingStepOutputName, "&etls_lastTable", sourceDataOptions.length() > 0 ? "&etls_tableOptions" : "", null, true, true, false, columnsToExcludeFromMapping.toArray(new IColumn[columnsToExcludeFromMapping.size()]), unmappedColumns, false, null, null, null);
            codeSegment.addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            codeSegment.addSourceCode("%let etls_tableOptions = ; \n\n");
        }
        return mappingStepOutputName;
    }

    protected IColumn getAndGenerateSetOfLoadTimeColumn(ICodeSegment codeSegment, String sourceDataOptions) {
        IColumn loadTimeColumn = null;
        try {
            loadTimeColumn = (IColumn)this.getOptionModel().getOptionValue("LoadTime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loadTimeColumn != null) {
            codeSegment.addSectionComment(RB.getStringResource("TableLoaderTransformModel.SetLoadTime.msg.notrans"));
            String dsname = codeSegment.getUniqueWorkTableName();
            String dtFormat = this.getJob().isUsingNLSDateFormat() ? "nldatm." : "datetime.";
            String loadColName = loadTimeColumn.getColumnName(codeSegment.isQuoting());
            codeSegment.addSourceCode("%let etls_jobLoadTime = &SYSDATE9.:&SYSTIME;\n").addSourceCode("%let etls_loadTime = &etls_jobLoadTime; \n").addSourceCode("data _null_;\n").indent().addSourceCode("_loadtime = input(\"&etls_LoadTime\",DATETIME20.);\n").genPutStatement(RB.getStringResource("TableLoaderTransformModel.LoadtimeNote.msg.notrans"), "NOTE:", "_loadtime " + dtFormat, false).unIndent().addSourceCode("run;\n\n");
            codeSegment.genTableDelete(dsname).addSourceCode("data work.").addSourceCode(dsname).addSourceCode(" / view=work.").addSourceCode(dsname).addSourceCode(";\n").indent().addSourceCode("set ").addSourceCode("&SYSLAST (&etls_tableOptions)").addSourceCode(";\n").addSourceCode(loadColName).addSourceCode(" = \"&etls_LoadTime\"dt;\n").unIndent().addSourceCode("run;\n\n");
            codeSegment.genRCSetCall("&syserr").addSourceCode("%let SYSLAST = work.").addSourceCode(dsname).addSourceCode(";\n").addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            if (sourceDataOptions.length() > 0) {
                codeSegment.addSourceCode("%let etls_tableOptions = ;\n\n");
            } else {
                codeSegment.addSourceCode("\n");
            }
        }
        return loadTimeColumn;
    }

    protected String getSourceTableOptions(ICodeSegment codeSegment, IPhysicalTable source) {
        ITransformTableOptions sourceOptions = this.getTableOptionObject(source, true);
        String sourceTableOptions = sourceOptions.getTableOptions(codeSegment.getCurrentServer());
        if (sourceTableOptions != null && sourceTableOptions.length() > 0) {
            codeSegment.addSourceCode("%let etls_tableOptions = %nrquote(").addSourceCode(sourceTableOptions).addSourceCode(");\n\n");
        } else {
            codeSegment.addSourceCode("%let etls_tableOptions = ;\n\n");
        }
        return sourceTableOptions;
    }

    protected ICodeSegment genBeginningMacros(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("%global etls_tableExist;\n").addSourceCode("%global etls_numIndex;\n").addSourceCode("%global etls_lastTable;\n").addSourceCode("%let etls_tableExist = -1; \n").addSourceCode("%let etls_numIndex = -1; \n").addSourceCode("%let etls_lastTable = &SYSLAST; \n\n");
        codeSegment.addSectionComment(RB.getStringResource("TableLoaderTransformModel.DefineMacro.msg.notrans")).addSourceCode("\n");
        codeSegment.addSourceCode("%macro etls_loader;\n\n").indent();
        return codeSegment;
    }

    public void resetModelDefaults() {
    }

    protected void saveDBMSTypeForChangeCheck() {
        IPhysicalTable target;
        String sDBMSType = "";
        if (this.getDataTargetsCount() > 0 && (target = (IPhysicalTable)this.getDataTargets()[0]) != null) {
            sDBMSType = target.getDBMSType().getClass().getName();
        }
        this.m_sSaveDBMSType = sDBMSType;
    }

    protected boolean isDBMSTypeChanged() {
        IPhysicalTable target;
        String sDBMSType = "";
        if (this.getDataTargetsCount() > 0 && (target = (IPhysicalTable)this.getDataTargets()[0]) != null) {
            sDBMSType = target.getDBMSType().getClass().getName();
        }
        return !sDBMSType.equals(this.m_sSaveDBMSType);
    }

    @Override
    public void notify(NotifyEvent ev) {
        String sType;
        ModelEvent mdEv;
        super.notify(ev);
        IPhysicalTable target = null;
        if (this.getDataTargetsCount() == 1) {
            target = (IPhysicalTable)this.getDataTargets()[0];
        }
        if (ev.getType() == 1 && (mdEv = ev.getModelEvent()) != null && mdEv.getModelObject() == target && (sType = mdEv.getType()).equalsIgnoreCase("PhysicalTable:LibraryChanged") && this.isDBMSTypeChanged()) {
            this.resetModelDefaults();
        }
    }
}

