/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.impl.BaseJob;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;
import java.util.List;

public class GenerateSource {
    public static String genSource(boolean bOverrideAndDisableStatisticsForJobOnDeployment, DesignTimeJobModel model, ICodeGenerationEnvironment cg) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IJob oIJob = model.getJob();
        if (oIJob instanceof BaseJob) {
            BaseJob baseJob = (BaseJob)oIJob;
            if (bOverrideAndDisableStatisticsForJobOnDeployment) {
                cg.setRunStatisticsEnabled(false);
            }
            if (!baseJob.isCompleteAndSubcomponents()) {
                List lReasons = baseJob.getReasonsIncompleteAndSubcomponents();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < lReasons.size(); ++i) {
                    sb.append(lReasons.get(i).toString());
                }
                CodegenException ce = new CodegenException(sb.toString(), null);
                ce.initCause(null);
                throw ce;
            }
        }
        oIJob.getCompleteCode(cg);
        return cg.getGeneratedCode().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServer getServerForAppServer(IModel model, WsAppServer appServer) throws MdException, RemoteException {
        if (appServer == null) {
            return null;
        }
        String sID = appServer.getServerFQID();
        IServer server = (IServer)model.getObject(sID);
        if (server != null) {
            return server;
        }
        server = model.getObjectFactory().createServer(sID);
        OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "acquireServer");
        boolean bUndo = model.isUndoSupported();
        model.setUndoSupported(false);
        try {
            omr.populateFor(server);
            server.loadFromOMR(omr);
            IServer iServer = server;
            return iServer;
        }
        finally {
            model.setUndoSupported(bUndo);
            omr.dispose();
        }
    }
}

