/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectFactory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class BaseModel
implements IModel {
    public static final String EDITABLE_CHANGED = "BaseModel:EditableChanged";
    private IObjectFactory m_factoryObject;
    private IPersistableObject m_objMain;
    private Map m_mapObjects;
    private List m_lModelListeners;
    private boolean m_bModelEventsEnabled;
    private boolean m_bUndoSupported;
    private boolean m_bUndoing;
    private UndoManager m_mgrUndo;
    private CompoundEdit m_undoCompound;
    private int m_nCompoundNesting;
    private boolean m_bSaving;
    private boolean m_bEditable;
    private String m_sDebugName;
    private MdObjectStore m_store;
    private static final char NEW_ID_CHARACTER = '$';
    private static final int REPOSITORY_ID_LENGTH = 8;
    private List m_lstDeletedObjects;
    private boolean m_bUseWebStreams;
    private boolean m_isCopy;

    public BaseModel() {
        this(null);
    }

    public BaseModel(ObjectFactory factoryObject) {
        this.m_factoryObject = factoryObject == null ? ObjectFactory.createFactory(this) : factoryObject;
        this.m_bModelEventsEnabled = true;
        this.m_mapObjects = new HashMap();
        this.m_lstDeletedObjects = new ArrayList();
        this.m_bUseWebStreams = false;
    }

    @Override
    public IObjectFactory getObjectFactory() {
        return this.m_factoryObject;
    }

    @Override
    public boolean isUsingWebStreams() {
        return this.m_bUseWebStreams;
    }

    @Override
    public void setUseWebStreams(boolean useWebstreams) {
        this.m_bUseWebStreams = useWebstreams;
    }

    public void setMainObject(IPersistableObject objMain) {
        this.m_objMain = objMain;
    }

    public IPersistableObject getMainObject() {
        return this.m_objMain;
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this.m_bEditable == bEditable) {
            return;
        }
        this.m_bEditable = bEditable;
        this.fireModelEvent(null, EDITABLE_CHANGED, null);
    }

    @Override
    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void setDebugName(String sDebugName) {
        this.m_sDebugName = sDebugName;
    }

    public String getDebugName() {
        return this.m_sDebugName;
    }

    public String toString() {
        return this.m_sDebugName + " Model:MainObject=" + this.m_objMain + ",Editable=" + this.m_bEditable;
    }

    public Root getOMRObject(IPersistableObject obj, MdFactory factory) throws RemoteException {
        if (this.m_store == null) {
            this.m_store = factory.createObjectStore(null, this.getDebugName() + " Authorization Tab Hack Store");
        }
        return (Root)this.m_store.getFactory().createComplexMetadataObject(this.m_store, obj.getName(), obj.getOMRType(), obj.getID());
    }

    @Override
    public String createIDForNewObject(String sContainerID) {
        String sRepositoryID = sContainerID.startsWith("A0000001") ? sContainerID.substring(9) : sContainerID.substring(0, 8);
        try {
            return Workspace.getMdFactory().makeID(sRepositoryID);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isNewObjectID(String sID) {
        return sID.charAt(9) == '$';
    }

    @Override
    public void setModelEventsEnabled(boolean bEnabled) {
        if (this.m_bModelEventsEnabled == bEnabled) {
            return;
        }
        this.m_bModelEventsEnabled = bEnabled;
        if (bEnabled) {
            this.fireModelEvent(null, "ModelController:UnknownChanges", null);
        }
    }

    @Override
    public boolean isModelEventsEnabled() {
        return this.m_bModelEventsEnabled;
    }

    @Override
    public void addModelListener(IModelListener lsnr) {
        if (this.m_lModelListeners == null) {
            this.m_lModelListeners = new ArrayList();
        }
        this.m_lModelListeners.add(lsnr);
    }

    @Override
    public void removeModelListener(IModelListener lsnr) {
        if (this.m_lModelListeners != null) {
            this.m_lModelListeners.remove(lsnr);
        }
    }

    @Override
    public void fireModelEvent(ModelEvent ev) {
        if (!this.m_bModelEventsEnabled) {
            return;
        }
        if (this.m_lModelListeners == null) {
            return;
        }
        this.fireModelEventImpl(ev);
    }

    @Override
    public void fireModelEvent(IObject modelObject, String sType, Object data) {
        if (!this.m_bModelEventsEnabled) {
            return;
        }
        if (this.m_lModelListeners == null) {
            return;
        }
        this.fireModelEventImpl(new ModelEvent(this, modelObject, sType, data));
    }

    @Override
    public void fireModelEvent(IObject modelObject, String sType, Object data, Object additionalData) {
        if (!this.m_bModelEventsEnabled) {
            return;
        }
        if (this.m_lModelListeners == null) {
            return;
        }
        this.fireModelEventImpl(new ModelEvent(this, modelObject, sType, data, additionalData));
    }

    private void fireModelEventImpl(ModelEvent ev) {
        this.logModelEvent(ev);
        for (int iListener = 0; iListener < this.m_lModelListeners.size(); ++iListener) {
            ((IModelListener)this.m_lModelListeners.get(iListener)).modelChanged(ev);
        }
    }

    private void logModelEvent(ModelEvent ev) {
        String sObject = ev.getModelObject() != null ? ev.getModelObject().toString() : "model";
        String sData = ev.getData() != null ? ev.getData().toString() : null;
        String sExtra = sData != null ? " (" + sData + ")" : "";
        ModelLogger.getDefaultLogger().debug((Object)("ModelEvent:" + ev.getType() + " from " + sObject + sExtra));
    }

    @Override
    public void setUndoSupported(boolean bSupported) {
        this.m_bUndoSupported = bSupported;
    }

    @Override
    public boolean isUndoSupported() {
        return this.m_bUndoSupported;
    }

    @Override
    public boolean isUndoing() {
        return this.m_bUndoing;
    }

    @Override
    public void startCompoundUndoable() {
        if (!this.m_bUndoSupported) {
            return;
        }
        if (this.m_undoCompound == null) {
            this.m_undoCompound = new CompoundEdit();
        } else {
            ++this.m_nCompoundNesting;
        }
    }

    @Override
    public void endCompoundUndoable() {
        if (!this.m_bUndoSupported) {
            return;
        }
        if (this.m_nCompoundNesting == 0) {
            CompoundEdit edit = this.m_undoCompound;
            this.m_undoCompound = null;
            edit.end();
            if (edit.isSignificant()) {
                this.undoableEditHappened(edit);
            }
        } else {
            --this.m_nCompoundNesting;
        }
    }

    @Override
    public void discardCompoundUndoable() {
        if (!this.m_bUndoSupported) {
            return;
        }
        if (this.m_nCompoundNesting > 0) {
            --this.m_nCompoundNesting;
        } else {
            if (this.m_undoCompound == null) {
                throw new IllegalStateException("discardCompoundUndoable called while no compound undo is in progress");
            }
            this.m_undoCompound.end();
            this.m_undoCompound.die();
            this.m_undoCompound = null;
        }
    }

    @Override
    public void undoableEditHappened(UndoableEdit edit) {
        if (!this.m_bUndoSupported || this.m_mgrUndo == null) {
            return;
        }
        if (this.m_undoCompound == null) {
            this.m_mgrUndo.addEdit(new DisableUndoWrapper(edit));
        } else {
            this.m_undoCompound.addEdit(edit);
        }
    }

    @Override
    public void setUndoManager(UndoManager mgrUndo) {
        this.m_mgrUndo = mgrUndo;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.m_mgrUndo;
    }

    @Override
    public void putObject(IObject obj) {
        if (this.m_lstDeletedObjects != null && this.m_lstDeletedObjects.contains(obj)) {
            this.m_lstDeletedObjects.remove(obj);
        }
        this.m_mapObjects.put(obj.getID(), obj);
        this.fireModelEvent(obj, "ModelController:ObjectAdded", null);
    }

    @Override
    public void removeObject(IObject obj) {
        if (this.m_lstDeletedObjects != null && !this.m_lstDeletedObjects.contains(obj)) {
            this.m_lstDeletedObjects.add(obj);
        }
        this.m_mapObjects.remove(obj.getID());
        this.fireModelEvent(obj, "ModelController:ObjectRemoved", null);
    }

    @Override
    public IObject getObject(String sID) {
        return (IObject)this.m_mapObjects.get(sID);
    }

    public IObject[] getAllObjects() {
        Collection values = this.m_mapObjects.values();
        return values.toArray(new IObject[values.size()]);
    }

    protected List getDeletedObjects() {
        return this.m_lstDeletedObjects;
    }

    @Override
    public void clear() {
        this.disposeAllObjects();
        this.m_mapObjects.clear();
        this.m_lstDeletedObjects.clear();
    }

    @Override
    public void dispose() {
        try {
            if (this.m_store != null) {
                this.m_store.dispose();
                this.m_store = null;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.clear();
        this.m_mapObjects = null;
        this.m_objMain = null;
        this.m_factoryObject = null;
        this.m_mgrUndo = null;
    }

    private void disposeAllObjects() {
        ArrayList lObjects = new ArrayList(this.m_mapObjects.values());
        for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
            ((IObject)lObjects.get(iObject)).dispose();
        }
        List lDeleted = this.getDeletedObjects();
        if (lDeleted != null) {
            for (int iObject = 0; iObject < lDeleted.size(); ++iObject) {
                ((IObject)lDeleted.get(iObject)).dispose();
            }
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        Set setKeys = this.m_mapObjects.keySet();
        String[] aKeys = setKeys.toArray(new String[setKeys.size()]);
        for (int iKey = 0; iKey < aKeys.length; ++iKey) {
            String sKey = aKeys[iKey];
            Object obj = this.m_mapObjects.get(sKey);
            if (!(obj instanceof IPersistableObject)) continue;
            ((IPersistableObject)obj).updateIDs(mapIDs);
        }
    }

    @Override
    public void saveToOMR(MdFactory factory) throws MdException, RemoteException {
        this.saveToOMR(this.m_objMain, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToOMR(IOMRPersistable obj, MdFactory factory) throws MdException, RemoteException {
        this.setSaving(true);
        try {
            OMRAdapter omr = new OMRAdapter(this, factory, "save");
            try {
                obj.saveToOMR(omr);
                WsMetadataUtil.updateModifiedByFor((Root)omr.acquireOMRObject(obj));
                omr.save();
            }
            finally {
                omr.dispose();
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    @Override
    public void setIsCopyPaste(boolean isCopy) {
        this.m_isCopy = isCopy;
    }

    @Override
    public boolean isCopyPaste() {
        return this.m_isCopy;
    }

    protected void setSaving(boolean bSaving) {
        this.m_bSaving = bSaving;
    }

    @Override
    public boolean isSaving() {
        return this.m_bSaving;
    }

    @Override
    public void loadFromOMR(MdFactory factory) throws MdException, RemoteException {
        this.loadFromOMR(this.m_objMain, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromOMR(IOMRPersistable obj, MdFactory factory) throws MdException, RemoteException {
        boolean bUndo = this.isUndoSupported();
        this.setUndoSupported(false);
        OMRAdapter omr = new OMRAdapter(this, factory, "load");
        try {
            ModelLogger.getDefaultLogger().debug((Object)"load start");
            omr.populateFor(omr.acquireOMRObject(obj));
            Workspace.getDefaultLogger().debug((Object)"load store populated");
            obj.loadFromOMR(omr);
            Workspace.getDefaultLogger().debug((Object)"load complete");
        }
        finally {
            omr.dispose();
            this.setUndoSupported(bUndo);
        }
    }

    @Override
    public void deleteFromOMR(MdFactory factory) throws MdException, RemoteException {
        this.deleteFromOMR(this.m_objMain, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromOMR(IOMRPersistable obj, MdFactory factory) throws MdException, RemoteException {
        OMRAdapter omr = new OMRAdapter(this, factory, "delete");
        try {
            obj.deleteFromOMR(omr);
            omr.save();
        }
        finally {
            omr.dispose();
        }
    }

    private class DisableUndoWrapper
    extends AbstractUndoableEdit {
        private UndoableEdit m_undo;

        public DisableUndoWrapper(UndoableEdit undo) {
            this.m_undo = undo;
        }

        @Override
        public void undo() {
            super.undo();
            BaseModel.this.m_bUndoing = true;
            try {
                BaseModel.this.setUndoSupported(false);
                this.m_undo.undo();
            }
            finally {
                BaseModel.this.setUndoSupported(true);
                BaseModel.this.m_bUndoing = false;
            }
        }

        @Override
        public void redo() {
            super.redo();
            try {
                BaseModel.this.setUndoSupported(false);
                this.m_undo.redo();
            }
            finally {
                BaseModel.this.setUndoSupported(true);
            }
        }
    }
}

