/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractSecondaryModelList
extends ArrayList {
    private Class[] m_aAllowedTypes;
    private Class[] m_aDisallowedTypes;
    private boolean m_bInAdd;
    private boolean m_bAddDone;
    private boolean m_bInRemove;
    private boolean m_bRemoveDone;

    public void setAllowedTypes(Class[] aAllowedTypes) {
        this.m_aAllowedTypes = aAllowedTypes;
    }

    public Class[] getAllowedTypes() {
        return this.m_aAllowedTypes;
    }

    public void setDisallowedTypes(Class[] aDisallowedTypes) {
        this.m_aDisallowedTypes = aDisallowedTypes;
    }

    public Class[] getDisallowedTypes() {
        return this.m_aDisallowedTypes;
    }

    @Override
    public boolean add(Object object) {
        this.validateObject(object);
        if (!this.m_bInAdd) {
            this.m_bInAdd = true;
            try {
                this.m_bAddDone = false;
                this.addTo(object);
            }
            finally {
                this.m_bInAdd = false;
            }
        }
        if (this.m_bAddDone) {
            return true;
        }
        super.add(object);
        this.m_bAddDone = true;
        return true;
    }

    protected void validateObject(Object object) {
        if (object == null) {
            throw new NullPointerException("null can not be added to a model list");
        }
        if (this.contains(object)) {
            throw new IllegalArgumentException("object is already in model list: " + object);
        }
        this.validateObjectType(object);
    }

    private void validateObjectType(Object obj) {
        if (this.m_aDisallowedTypes != null) {
            for (int iDisallowedType = 0; iDisallowedType < this.m_aDisallowedTypes.length; ++iDisallowedType) {
                if (!this.m_aDisallowedTypes[iDisallowedType].isInstance(obj)) continue;
                throw new IllegalArgumentException("object is a disallowed type: " + obj.getClass());
            }
        }
        if (this.m_aAllowedTypes != null) {
            for (int iAllowedType = 0; iAllowedType < this.m_aAllowedTypes.length; ++iAllowedType) {
                if (!this.m_aAllowedTypes[iAllowedType].isInstance(obj)) continue;
                return;
            }
            throw new IllegalArgumentException("object is not the correct type: " + obj.getClass());
        }
    }

    @Override
    public boolean remove(Object object) {
        int iObject = this.indexOf(object);
        if (iObject == -1) {
            return false;
        }
        this.remove(iObject);
        return true;
    }

    @Override
    public Object remove(int iObject) {
        Object obj = this.get(iObject);
        if (!this.m_bInRemove) {
            this.m_bInRemove = true;
            try {
                this.m_bRemoveDone = false;
                this.removeFrom(obj);
            }
            finally {
                this.m_bInRemove = false;
            }
        }
        if (this.m_bRemoveDone) {
            return obj;
        }
        super.remove(iObject);
        this.m_bRemoveDone = true;
        return obj;
    }

    protected abstract void addTo(Object var1);

    protected abstract void removeFrom(Object var1);

    @Override
    public void add(int iObject, Object object) {
        throw new UnsupportedOperationException("add at index is not supported");
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("addAll is not supported");
    }

    @Override
    public boolean addAll(int iObject, Collection collection) {
        throw new UnsupportedOperationException("addAll is not supported");
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("removeAll is not supported");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear is not supported");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("retainAll is not supported");
    }

    @Override
    public Object set(int iObject, Object obj) {
        throw new UnsupportedOperationException("set is not supported");
    }

    @Override
    public int lastIndexOf(Object obj) {
        throw new UnsupportedOperationException("lastIndexOf is not supported");
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList is not supported");
    }
}

