/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.waitforcompletion.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.impl.AbstractDataObject;
import com.sas.etl.models.data.waitforcompletion.IWaitForCompletion;
import com.sas.etl.models.data.waitforcompletion.IWaitForCompletionVersion;
import com.sas.etl.models.data.waitforcompletion.impl.BaseWaitForCompletionVersion;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.MdException;
import com.sas.publicobjects.decisionlogic.DecisionLogic;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class BaseWaitForCompletion
extends AbstractDataObject
implements IWaitForCompletion {
    private UsageVersion m_usageVersion;
    private Map<UsageVersion, IWaitForCompletionVersion> _versions = new TreeMap<UsageVersion, IWaitForCompletionVersion>();
    private IWaitForCompletionVersion _defaultVersion;

    public BaseWaitForCompletion(String id, IModel model) {
        super(id, model);
        this.setArchitectureVersionNumber(DecisionLogic.CURRENT_VERSION);
    }

    public IWaitForCompletionVersion[] getVersions() {
        ArrayList<IWaitForCompletionVersion> versions = new ArrayList<IWaitForCompletionVersion>(this._versions.values());
        Collections.reverse(versions);
        return versions.toArray(new IWaitForCompletionVersion[versions.size()]);
    }

    private void addVersion(IWaitForCompletionVersion version) {
        if (this._versions.containsKey(version.getVersion())) {
            return;
        }
        this._versions.put(version.getVersion(), version);
    }

    @Override
    public IWaitForCompletionVersion findVersion(UsageVersion version) {
        return this._versions.get(version);
    }

    public static UsageVersion convertToUsageVersion(String strVersion) {
        String[] numbers = strVersion.split("\\.");
        UsageVersion version = null;
        version = numbers.length == 2 ? new UsageVersion(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1])) : (numbers.length == 3 ? new UsageVersion(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1]), Integer.parseInt(numbers[2])) : new UsageVersion(1, 0));
        return version;
    }

    @Override
    public String getPublicType() {
        return "DecisionLogic";
    }

    @Override
    public String getOMRType() {
        return "Transformation";
    }

    @Override
    public IWaitForCompletionVersion getDefaultVersion() {
        return this._defaultVersion;
    }

    protected void setDefaultVersion(IWaitForCompletionVersion version) {
        this._defaultVersion = version;
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return this.m_usageVersion;
    }

    @Override
    protected void setArchitectureVersionNumber(UsageVersion version) {
        this.m_usageVersion = version;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        super.loadFromOMR(omr);
        ChildServerInterface child = null;
        try {
            child = Workspace.getWorkspace().getUserContext().getAuthServer().newChild(true);
            BaseWaitForCompletionVersion edmv = new BaseWaitForCompletionVersion(this);
            edmv.loadFromOMR();
            this.addVersion(edmv);
            this.setDefaultVersion(edmv);
            DecisionLogic decisionLogic = new DecisionLogic();
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        finally {
            try {
                if (child != null) {
                    child.destroy();
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }
}

