/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.IDirectory;
import com.sas.etl.models.data.IFile;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.DBMSTypeFactory;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.impl.AbstractDataObject;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.data.impl.RB;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptModelCollection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.UsageVersion;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class BaseLibrary
extends AbstractDataObject
implements ILibrary {
    private String m_sLibref = "Unknown1";
    private String m_sEngine = "BASE";
    private boolean m_bPreAssigned;
    private IDatabaseSchema m_schema;
    private List m_servers = new ArrayList();
    private List m_usedPackages = new ArrayList();
    private List m_options = new ArrayList();
    private List m_lFiles;
    private List m_lDirectories = new ArrayList();
    private ILibrary m_serverLibrary;
    private ISASClientConnection m_libraryConnection;
    private PhysicalTablePromptModelCollection m_optionModel;
    private List m_lstDeletedModels;
    private boolean m_bIsDBMSLibname = false;
    protected static final String DBMSTEMPLIBREF = "etlstmp";

    public BaseLibrary(String sID, IModel model) {
        super(sID, model);
        this.m_lFiles = new ArrayList();
        this.m_lstDeletedModels = new ArrayList();
    }

    @Override
    public ISASClientConnection getLibraryConnection() {
        return this.m_libraryConnection;
    }

    @Override
    public void setLibraryConnection(ISASClientConnection libraryConnection) {
        if (this.m_libraryConnection == libraryConnection) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLibraryConnectionUndoable(this.m_libraryConnection, libraryConnection));
        }
        this.m_libraryConnection = libraryConnection;
        this.fireModelChangedEvent("ILibrary:LibraryConnectionChanged", this.m_libraryConnection);
    }

    @Override
    public boolean isDBMSLibname() {
        return this.m_bIsDBMSLibname;
    }

    @Override
    public void setIsDBMSLibname(boolean bIsDBMSLibname) {
        if (this.m_bIsDBMSLibname == bIsDBMSLibname) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIsDBMSLibnameUndoable(this.m_bIsDBMSLibname, bIsDBMSLibname));
        }
        this.m_bIsDBMSLibname = bIsDBMSLibname;
        this.fireModelChangedEvent("ILibrary:DBMSLibnameChanged", null);
    }

    @Override
    public void addDirectory(IDirectory directory) {
        this.addDirectory(this.m_lDirectories.size(), directory);
    }

    @Override
    public void addDirectory(int iDirectory, IDirectory directory) {
        if (this.m_lDirectories.contains(directory)) {
            return;
        }
        this.removeFromDeletedObjects(directory);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddDirectoryUndoable(iDirectory, directory));
        }
        directory.setDirectoryRole("LibraryPath");
        this.m_lDirectories.add(iDirectory, directory);
        this.fireModelChangedEvent("ILibrary.DirectoryAdded", directory);
    }

    @Override
    public void removeDirectory(IDirectory directory) {
        if (!this.m_lDirectories.contains(directory)) {
            return;
        }
        this.addToDeletedObjects(directory);
        int iDirectory = this.m_lDirectories.indexOf(directory);
        this.m_lDirectories.remove(iDirectory);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveDirectoryUndoable(iDirectory, directory));
        }
        this.fireModelChangedEvent("ILibrary.DirectoryRemoved", directory);
    }

    @Override
    public IDirectory[] getDirectories() {
        return this.m_lDirectories.toArray(new IDirectory[this.m_lDirectories.size()]);
    }

    @Override
    public void addFile(IFile file) {
        this.addFile(this.m_lFiles.size(), file);
    }

    @Override
    public void addFile(int iFile, IFile file) {
        if (this.m_lFiles.contains(file)) {
            return;
        }
        this.m_lFiles.add(iFile, file);
        this.fireModelChangedEvent("ILibrary.FileAdded", file);
        this.removeFromDeletedObjects(file);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddFileUndoable(iFile, file));
        }
    }

    @Override
    public void removeFile(IFile file) {
        if (!this.m_lFiles.contains(file)) {
            return;
        }
        int iFile = this.m_lFiles.indexOf(file);
        this.m_lFiles.remove(iFile);
        this.fireModelChangedEvent("ILibrary.FileRemoved", file);
        this.addToDeletedObjects(file);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveFileUndoable(iFile, file));
        }
    }

    @Override
    public IFile[] getFiles() {
        return this.m_lFiles.toArray(new IFile[this.m_lFiles.size()]);
    }

    @Override
    public ILibrary getServerLibrary() {
        return this.m_serverLibrary;
    }

    @Override
    public void setServerLibrary(ILibrary library) {
        if (this.m_serverLibrary == library) {
            return;
        }
        if (!"REMOTE".equals(this.getEngine())) {
            throw new IllegalArgumentException("the engine of the library must be remote to assign a server library");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetServerLibraryUndoable(this.m_serverLibrary, library));
        }
        this.m_serverLibrary = library;
        this.fireModelChangedEvent("ILibrary.ServerLibraryChanged", this.m_serverLibrary);
    }

    @Override
    public boolean isClientLibrary() {
        return this.m_serverLibrary != null;
    }

    @Override
    public String getLibnameStatement() throws MdException, RemoteException {
        return this.getLibnameStatement(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLibnameStatement(boolean generateFileNameForXML) throws MdException, RemoteException {
        OMRAdapter omr = new OMRAdapter(this.getModel(), Workspace.getMdFactory(), "BaseLibrary:getLibnameStatement");
        boolean undoSupport = this.getModel().isUndoSupported();
        this.getModel().setUndoSupported(false);
        try {
            SASLibrary mdoLibrary = (SASLibrary)omr.acquireOMRObject(this);
            omr.populateFor(this);
            for (int iDirectory = 0; iDirectory < this.m_lDirectories.size(); ++iDirectory) {
                IDirectory directory = (IDirectory)this.m_lDirectories.get(iDirectory);
                omr.populateFor(directory);
            }
            String string = LibraryUtil.getAccessPath((SASLibrary)mdoLibrary, (boolean)generateFileNameForXML);
            return string;
        }
        finally {
            omr.dispose();
            this.getModel().setUndoSupported(undoSupport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCredentialPromptRequired() throws RemoteException, MdException {
        OMRAdapter omr = new OMRAdapter(this.getModel(), Workspace.getMdFactory(), "BaseLibrary:getLibnameStatement");
        boolean undoSupport = this.getModel().isUndoSupported();
        this.getModel().setUndoSupported(false);
        try {
            SASLibrary mdoLibrary = (SASLibrary)omr.acquireOMRObject(this);
            omr.populateFor(this);
            boolean bl = LibraryUtil.isCredentialPromptRequired((SASLibrary)mdoLibrary);
            return bl;
        }
        finally {
            omr.dispose();
            this.getModel().setUndoSupported(undoSupport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PasswordAuthentication getPromptedCredentialsLibraryUserPass() throws RemoteException, MdException {
        OMRAdapter omr = new OMRAdapter(this.getModel(), Workspace.getMdFactory(), "BaseLibrary:getLibnameStatement");
        boolean undoSupport = this.getModel().isUndoSupported();
        this.getModel().setUndoSupported(false);
        try {
            SASLibrary mdoLibrary = (SASLibrary)omr.acquireOMRObject(this);
            omr.populateFor(this);
            PasswordAuthentication passwordAuthentication = LibraryUtil.getPromptedCredentialsLibraryUserPass((SASLibrary)mdoLibrary);
            return passwordAuthentication;
        }
        finally {
            omr.dispose();
            this.getModel().setUndoSupported(undoSupport);
        }
    }

    private String getLibnameStatement(SASLibrary mdoLibrary) throws RemoteException, MdException {
        return LibraryUtil.getAccessPath((SASLibrary)mdoLibrary);
    }

    @Override
    public String getLibref() {
        return this.m_sLibref;
    }

    @Override
    public void setLibref(String libref) {
        if (libref == null) {
            throw new IllegalArgumentException("Libref cannot be null.");
        }
        if (this.m_sLibref.equalsIgnoreCase(libref)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLibrefUndoable(this.m_sLibref, libref));
        }
        this.m_sLibref = libref;
        this.fireModelChangedEvent("ILibrary.LibrefChanged", null);
    }

    @Override
    public String getEngine() {
        return this.m_sEngine;
    }

    @Override
    public void setEngine(String engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Engine cannot be null.");
        }
        if (this.m_sEngine.equalsIgnoreCase(engine)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetEngineUndoable(this.m_sEngine, engine));
        }
        IDBMSType oldType = this.getDBMSType();
        this.m_sEngine = engine;
        try {
            this.loadOptionModel();
        }
        catch (FileNotFoundException e) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        this.fireModelChangedEvent("ILibrary.EngineChanged", null);
    }

    @Override
    public IDatabaseSchema getDatabaseSchema() {
        return this.m_schema;
    }

    @Override
    public void setDatabaseSchema(IDatabaseSchema schema) {
        if (this.m_schema == schema) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetDatabaseSchemaUndoable(this.m_schema, schema));
            }
            this.m_schema = schema;
            try {
                this.loadOptionModel();
            }
            catch (FileNotFoundException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (RemoteException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (ServerConnectionException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (ServiceException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (IOException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (SAXException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (MdException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            this.fireModelChangedEvent("ILibrary.DatabaseSchemaChanged", null);
            if (this.m_schema != null) {
                this.m_schema.setLibrary(this);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isPreAssigned() {
        return this.m_bPreAssigned;
    }

    @Override
    public void setIsPreAssigned(boolean isPreassigned) {
        if (this.m_bPreAssigned == isPreassigned) {
            return;
        }
        this.m_bPreAssigned = isPreassigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionOptions() throws MdException, RemoteException {
        OMRAdapter omr = new OMRAdapter(this.getModel(), Workspace.getMdFactory(), "getConnectionOptions");
        try {
            SASLibrary mdoLibrary = (SASLibrary)omr.acquireOMRObject(this);
            mdoLibrary = (SASLibrary)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdoLibrary, null, null, "", 8);
            String string = LibraryUtil.getConnectionOptions((SASLibrary)mdoLibrary);
            return string;
        }
        finally {
            omr.dispose();
        }
    }

    @Override
    public List getOptionsList() {
        return this.m_options;
    }

    public void clearOptions() {
        for (int i = this.m_options.size() - 1; i >= 0; --i) {
            ModelLogger.getDefaultLogger().debug((Object)("Remove option " + this.m_options.get(i) + " .. " + i));
            this.removeOption((IProperty)this.m_options.get(i));
        }
        ModelLogger.getDefaultLogger().debug((Object)("option size.................." + this.m_options.size()));
    }

    public void addOption(IProperty property) {
        if (this.m_options.contains(property)) {
            return;
        }
        if (property != null) {
            this.removeFromDeletedObjects(property);
            property.addNotifyListener(this);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new OptionAddedUndoable(property));
        }
        this.m_options.add(property);
        this.fireModelChangedEvent("ILibrary:PropertyAdded", property);
    }

    public void removeOption(IProperty property) {
        int index = this.m_options.indexOf(property);
        if (index == -1) {
            return;
        }
        if (property != null) {
            this.addToDeletedObjects(property);
            property.removeNotifyListener(this);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new OptionRemovedUndoable(property));
        }
        this.m_options.remove(index);
        this.fireModelChangedEvent("ILibrary:PropertyRemoved", property);
    }

    @Override
    public IProperty findOption(String name) {
        for (IProperty property : this.getOptions()) {
            if (!property.getPropertyName().equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public String getFirstDirectory() {
        IDirectory[] oDirectories = this.getDirectories();
        String sDirectory = "";
        if (oDirectories.length > 0) {
            sDirectory = oDirectories[0].getDirectoryName();
        }
        return sDirectory;
    }

    private ICodeSegment genAccessPathTemporaryDbmstemp(IPhysicalTable targetTable, ICodeSegment codeSegment) throws RemoteException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        this.genAccessPathTemporary(targetTable, codeSegment, "", true, true);
        return codeSegment;
    }

    @Override
    public ICodeSegment genAccessPathTemporary(IPhysicalTable targetTable, ICodeSegment codeSegment, String connectionValue, boolean overrideExisting) throws RemoteException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        this.genAccessPathTemporary(targetTable, codeSegment, connectionValue, overrideExisting, false);
        return codeSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICodeSegment genAccessPathTemporary(IPhysicalTable targetTable, ICodeSegment codeSegment, String connectionValue, boolean overrideExisting, boolean dbmstemp) throws RemoteException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        MdObjectStore store = factory.createObjectStore(null, "AbstractSCDTransform: Store");
        try {
            String engine = library.getEngine();
            SASLibrary sasLibrary = dbmstemp ? this.addTempProperties(factory, store, library, overrideExisting) : this.addConnectionOption(factory, store, library, connectionValue, overrideExisting);
            String libRef = library.getLibref();
            String code = this.getLibnameStatement(sasLibrary);
            if (dbmstemp) {
                if (engine.startsWith("DB2")) {
                    String schemaName = targetTable.getDBMSType().getSchemaName(codeSegment.getCurrentServer(), targetTable, false);
                    String schemaOld = "SCHEMA=" + schemaName;
                    String schemaNew = "SCHEMA=SESSION";
                    code = code.replaceAll(schemaOld, schemaNew);
                }
                codeSegment.addCommentLine("Generate the temporary table libname statement");
                code = code.replaceFirst(libRef, DBMSTEMPLIBREF);
                int lastSemiColon = code.lastIndexOf(";");
                StringBuffer sbCode = new StringBuffer();
                sbCode.append(code);
                if (targetTable.getDBMSType().getDBMSTypeName().equals("SAS SPDS")) {
                    sbCode.replace(lastSemiColon, lastSemiColon, " TEMP=YES");
                } else {
                    sbCode.replace(lastSemiColon, lastSemiColon, " DBMSTEMP=YES");
                }
                code = sbCode.toString();
            }
            codeSegment.addSourceCode(code + "\n");
        }
        finally {
            store.dispose();
        }
        return codeSegment;
    }

    private SASLibrary addConnectionOption(MdFactory factory, MdObjectStore store, ILibrary library, String connectionValue, boolean overrideExisting) throws MdException, RemoteException {
        String connPropName = "CONNECTION";
        String connGrpPropName = "CONNECTION_GROUP";
        List existingProps = library.getOptionsList();
        boolean hasConnection = false;
        boolean hasConnectionGroup = false;
        for (int i = 0; i < existingProps.size(); ++i) {
            IProperty prop = (IProperty)existingProps.get(i);
            if ("CONNECTION".equalsIgnoreCase(prop.getPropertyName())) {
                hasConnection = true;
            }
            if (!"CONNECTION_GROUP".equalsIgnoreCase(prop.getPropertyName())) continue;
            hasConnectionGroup = true;
        }
        ISASClientConnection connection = library.getLibraryConnection();
        String engine = library.getEngine();
        SASLibrary sasLibrary = (SASLibrary)factory.createComplexMetadataObject(store, library.getName(), library.getOMRType(), library.getID());
        sasLibrary = (SASLibrary)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)sasLibrary, null, null, "", 8);
        SASClientConnection sasConnection = (SASClientConnection)factory.createComplexMetadataObject(store, connection.getName(), connection.getOMRType(), connection.getID());
        sasConnection = (SASClientConnection)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)sasConnection, null, null, "", 8);
        String fqid = sasConnection.getRepositoryID();
        if (!hasConnection || overrideExisting) {
            Property connProp = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, "Type of connection", "Property", fqid);
            PropertyType propType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(store, "Srring", "PropertyType", fqid);
            propType.setSQLType(12);
            connProp.setOwningType(propType);
            connProp.setPropertyName(connPropName);
            connProp.setDelimiter("=");
            connProp.setDefaultValue(connectionValue);
            connProp.setSQLType(12);
            connProp.setAssociatedObject((Root)sasConnection);
        }
        if ("INFORMIX".equalsIgnoreCase(engine) && !hasConnectionGroup) {
            Property connGrpProp = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, "Connection group name", "Property", fqid);
            PropertyType propGrpType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(store, "Srring", "PropertyType", fqid);
            propGrpType.setSQLType(12);
            connGrpProp.setOwningType(propGrpType);
            connGrpProp.setPropertyName(connGrpPropName);
            connGrpProp.setDelimiter("=");
            connGrpProp.setDefaultValue("ETLSGRP");
            connGrpProp.setAssociatedObject((Root)sasConnection);
        }
        return sasLibrary;
    }

    private SASLibrary addTempProperties(MdFactory factory, MdObjectStore store, ILibrary library, boolean overrideExisting) throws MdException, RemoteException {
        String connPropName = "CONNECTION";
        String connGrpPropName = "CONNECTION_GROUP";
        List existingProps = library.getOptionsList();
        boolean hasConnection = false;
        boolean hasConnectionGroup = false;
        for (int i = 0; i < existingProps.size(); ++i) {
            IProperty prop = (IProperty)existingProps.get(i);
            if ("CONNECTION".equalsIgnoreCase(prop.getPropertyName())) {
                hasConnection = true;
            }
            if (!"CONNECTION_GROUP".equalsIgnoreCase(prop.getPropertyName())) continue;
            hasConnectionGroup = true;
        }
        ISASClientConnection connection = library.getLibraryConnection();
        String engine = library.getEngine();
        SASLibrary sasLibrary = (SASLibrary)factory.createComplexMetadataObject(store, library.getName(), library.getOMRType(), library.getID());
        sasLibrary = (SASLibrary)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)sasLibrary, null, null, "", 8);
        SASClientConnection sasConnection = (SASClientConnection)factory.createComplexMetadataObject(store, connection.getName(), connection.getOMRType(), connection.getID());
        sasConnection = (SASClientConnection)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)sasConnection, null, null, "", 8);
        String fqid = sasConnection.getRepositoryID();
        if (!hasConnection || overrideExisting) {
            Property connProp = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, "Type of connection", "Property", fqid);
            PropertyType propType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(store, "Srring", "PropertyType", fqid);
            propType.setSQLType(12);
            connProp.setOwningType(propType);
            connProp.setPropertyName(connPropName);
            connProp.setDelimiter("=");
            connProp.setDefaultValue("GLOBAL");
            connProp.setSQLType(12);
            connProp.setAssociatedObject((Root)sasConnection);
        }
        if ("INFORMIX".equalsIgnoreCase(engine) && !hasConnectionGroup) {
            Property connGrpProp = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, "Connection group name", "Property", fqid);
            PropertyType propGrpType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(store, "Srring", "PropertyType", fqid);
            propGrpType.setSQLType(12);
            connGrpProp.setOwningType(propGrpType);
            connGrpProp.setPropertyName(connGrpPropName);
            connGrpProp.setDelimiter("=");
            connGrpProp.setDefaultValue("ETLSGRP");
            connGrpProp.setAssociatedObject((Root)sasConnection);
        }
        return sasLibrary;
    }

    @Override
    public IProperty[] getOptions() {
        ArrayList opts = new ArrayList(this.getOptionsList());
        ISASClientConnection conn = this.getLibraryConnection();
        if (conn != null) {
            opts.addAll(conn.getOptionsList());
        }
        return opts.toArray(new IProperty[opts.size()]);
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IObject newOwner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        if (this.m_optionModel == null) {
            this.loadOptionModel();
        }
        return (PhysicalTablePromptModelCollection)this.m_optionModel.copy(newOwner);
    }

    protected void setTableOptionCollection(PhysicalTablePromptModelCollection modelCollection) {
        if (this.m_optionModel == modelCollection) {
            return;
        }
        if (this.m_optionModel != null && !this.m_lstDeletedModels.contains(this.m_optionModel)) {
            this.m_lstDeletedModels.add(this.m_optionModel);
        }
        this.m_optionModel = modelCollection;
        if (this.m_lstDeletedModels.contains(this.m_optionModel)) {
            this.m_lstDeletedModels.remove(this.m_optionModel);
        }
        this.fireModelChangedEvent("ILibrary:OptionModelChanged", this.m_optionModel);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_optionModel != null) {
            this.m_optionModel.dispose();
            this.m_optionModel = null;
        }
        IPromptModelCollection[] models = this.m_lstDeletedModels.toArray(new IPromptModelCollection[this.m_lstDeletedModels.size()]);
        for (int i = 0; i < models.length; ++i) {
            models[i].dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        boolean bChanged = this.isChanged();
        try {
            this.setTableOptionCollection(null);
            IDBMSType dbms = this.getDBMSType();
            if (dbms != null) {
                PhysicalTablePromptModelCollection model = dbms.getTableOptionCollectionInstance(this.getModel(), this);
                IProperty[] props = this.getOptions();
                for (int i = 0; i < props.length; ++i) {
                    model.setOptionValue(props[i].getPropertyName(), (Object)props[i].getDefaultValue());
                }
                this.setTableOptionCollection(model);
            }
        }
        finally {
            this.setChanged(bChanged);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        SASLibrary mdoLibrary = (SASLibrary)omr.acquireOMRObject(this);
        this.setLibref(mdoLibrary.getLibref());
        this.setEngine(mdoLibrary.getEngine());
        this.setIsPreAssigned(mdoLibrary.getIsPreassigned() == 1);
        SASClientConnection conn = mdoLibrary.getLibraryConnection();
        this.setLibraryConnection(conn != null ? (ISASClientConnection)omr.acquireObject((Root)conn) : null);
        this.setIsDBMSLibname(mdoLibrary.getIsDBMSLibname() == 1);
        this.m_servers.clear();
        AssociationList servers = mdoLibrary.getDeployedComponents();
        int size = servers.size();
        for (int i = 0; i < size; ++i) {
            DeployedComponent comp = (DeployedComponent)servers.get(i);
            IPersistableObject p = (IPersistableObject)this.getModel().getObject(comp.getFQID());
            if (p == null) {
                p = (IPersistableObject)omr.acquireObject((Root)comp);
            }
            this.m_servers.add(p);
        }
        this.m_usedPackages.clear();
        AssociationList packages = mdoLibrary.getUsedByPackages();
        int sizePkgs = packages.size();
        for (int i = 0; i < sizePkgs; ++i) {
            DeployedDataPackage comp = (DeployedDataPackage)packages.get(i);
            IPersistableObject p = (IPersistableObject)omr.acquireObject((Root)comp);
            this.m_usedPackages.add(p);
        }
        this.m_lDirectories.clear();
        this.m_lFiles.clear();
        IDatabaseSchema schema = null;
        AssociationList usingPackages = mdoLibrary.getUsingPackages();
        for (int i = 0; i < usingPackages.size(); ++i) {
            DeployedDataPackage comp = (DeployedDataPackage)usingPackages.get(i);
            if (comp instanceof DatabaseSchema) {
                IDatabaseSchema p = (IDatabaseSchema)omr.acquireObject((Root)comp);
                if (schema != null) continue;
                schema = p;
                continue;
            }
            if (comp instanceof Directory) {
                IDirectory d = (IDirectory)omr.acquireObject((Root)comp);
                this.addDirectory(d);
                continue;
            }
            if (comp instanceof File) {
                IFile f = (IFile)omr.acquireObject((Root)comp);
                this.addFile(f);
                continue;
            }
            if (!(comp instanceof SASLibrary) || !"REMOTE".equals(this.getEngine())) continue;
            ILibrary lib = (ILibrary)omr.acquireObject((Root)comp);
            this.setServerLibrary(lib);
        }
        this.setDatabaseSchema(schema);
        this.clearOptions();
        AssociationList props = mdoLibrary.getProperties();
        int pSize = props.size();
        for (int i = 0; i < pSize; ++i) {
            Property mdProperty = (Property)props.get(i);
            IProperty property = (IProperty)this.getModel().getObject(mdProperty.getFQID());
            if (property == null) {
                property = (IProperty)omr.acquireObject((Root)mdProperty);
            } else {
                property.loadFromOMR(omr);
            }
            this.addOption(property);
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        SASLibrary mdoLibrary = (SASLibrary)omr.acquireOMRObject(this);
        mdoLibrary.setIsPreassigned(this.m_bPreAssigned ? 1 : 0);
        mdoLibrary.setEngine(this.m_sEngine);
        mdoLibrary.setLibref(this.m_sLibref);
        mdoLibrary.setIsDBMSLibname(this.isDBMSLibname() ? 1 : 0);
        ISASClientConnection libraryConnection = this.getLibraryConnection();
        AssociationList libConnections = mdoLibrary.getLibraryConnections();
        libConnections.clear();
        if (libraryConnection != null) {
            libConnections.add(omr.acquireOMRObject(libraryConnection));
        }
        AssociationList usingPackages = mdoLibrary.getUsingPackages();
        usingPackages.clear();
        IFile[] files = this.getFiles();
        for (int i = 0; i < files.length; ++i) {
            usingPackages.add(omr.acquireOMRObject(files[i]));
        }
        ILibrary serverLibrary = this.getServerLibrary();
        if (serverLibrary != null) {
            usingPackages.add(omr.acquireOMRObject(serverLibrary));
        }
        IDirectory[] directory = this.getDirectories();
        for (int i = 0; i < directory.length; ++i) {
            directory[i].saveToOMR(omr);
            usingPackages.add(omr.acquireOMRObject(directory[i]));
        }
        AssociationList usedByPackages = mdoLibrary.getUsedByPackages();
        usedByPackages.clear();
        IPersistableObject[] usedPkgs = this.getUsedPackages();
        for (int i = 0; i < usedPkgs.length; ++i) {
            usedByPackages.add(omr.acquireOMRObject(usedPkgs[i]));
        }
        AssociationList servers = mdoLibrary.getDeployedComponents();
        servers.clear();
        IServer[] iServer = this.getServers();
        for (int i = 0; i < iServer.length; ++i) {
            servers.add(omr.acquireOMRObject(iServer[i]));
        }
        IDatabaseSchema schema = this.getDatabaseSchema();
        if (schema != null) {
            schema.saveToOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get("SASLibrary");
        lAssociations.add("LibraryConnection");
        lAssociations.add("DeployedComponents");
        lAssociations.add("UsedByPackages");
        lAssociations.add("UsingPackages");
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "SASLibrary";
    }

    @Override
    public String getPublicType() {
        return "Library";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return new UsageVersion(1, 0);
    }

    @Override
    public IDBMSType getDBMSType() {
        return DBMSTypeFactory.getInstance().getDBMSType(this);
    }

    @Override
    public String getDBMSProductName() throws BadLibraryDefinitionException {
        return DBMSTypeFactory.getInstance().getDBMSProductName(this);
    }

    @Override
    public IServer[] getServers() {
        return this.m_servers.toArray(new IServer[this.m_servers.size()]);
    }

    @Override
    public IPersistableObject[] getUsedPackages() {
        return this.m_usedPackages.toArray(new IPersistableObject[this.m_usedPackages.size()]);
    }

    @Override
    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        return this.getAccessPath(environment, true);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public IServer getDatabaseServer() {
        ISASClientConnection connection = this.getLibraryConnection();
        if (connection != null) {
            return connection.getServer();
        }
        return null;
    }

    @Override
    public List getReasonsIncomplete() {
        ArrayList<String> reasons = new ArrayList<String>();
        if (!this.isPreAssigned()) {
            IServer[] lServers = this.getServers();
            for (int i = 0; i < lServers.length; ++i) {
                IServer iSC = lServers[i];
                if (!iSC.getClassIdentifier().equals("SHARE")) continue;
                reasons.add(MessageFormat.format(RB.getStringResource("BaseLibrary.CannotAssignShare.msg.txt"), this.getName()));
            }
        }
        return reasons;
    }

    @Override
    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment, boolean generateStatusMacros) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        return this.getAccessPath(environment, generateStatusMacros, null);
    }

    @Override
    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment, boolean generateStatusMacros, Map additionalRemoteMacros) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        return this.getAccessPath(environment, generateStatusMacros, additionalRemoteMacros, false, false);
    }

    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment, boolean generateStatusMacros, Map additionalRemoteMacros, boolean generatePerformanceStatistics, boolean generateTablePerformanceStatistics) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        return this.getAccessPath(environment, generateStatusMacros, additionalRemoteMacros, generatePerformanceStatistics, generateTablePerformanceStatistics, true);
    }

    @Override
    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment, boolean generateStatusMacros, Map additionalRemoteMacros, boolean generatePerformanceStatistics, boolean generateTablePerformanceStatistics, boolean generateFileNameForXML) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        CodeSegment codeSegment = new CodeSegment(environment, this);
        if (!this.isPreAssigned()) {
            ISASClientConnection clientConnection;
            codeSegment.addCommentLine(MessageFormat.format(RB.getStringResource("BaseLibrary.LibnameComment.msg.txt"), this.getName()));
            IServer[] lServers = this.getServers();
            for (int i = 0; i < lServers.length; ++i) {
                IServer iSC = lServers[i];
                if (!iSC.getClassIdentifier().equals("SHARE")) continue;
                throw new BadLibraryDefinitionException(MessageFormat.format(RB.getStringResource("BaseLibrary.CannotAssignShare.msg.txt"), this.getName()));
            }
            IServer server = environment.getCurrentServer();
            IServer iServer = this.getBestServer(server);
            ModelLogger.getDefaultLogger().debug((Object)("Selected Library: " + this.getName()));
            boolean isLocal = ObjectComparator.isEqual(iServer, server);
            if (!isLocal) {
                clientConnection = iServer.getConnectClient();
                if (clientConnection == null) {
                    throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), iServer.getName()));
                }
                if (!environment.isOnSignonCache(iServer)) {
                    clientConnection.genAccessCode(codeSegment).addSourceCode("\n");
                    environment.addToSignonCache(iServer);
                }
                if (generateStatusMacros) {
                    codeSegment.addSourceCode(codeSegment.getReturnCodeRemoteSetup(clientConnection, additionalRemoteMacros, false)).addSourceCode("\n");
                }
                codeSegment.addSourceCode(codeSegment.getRemoteMacroVariablesSetup(environment.getRemoteMacroVariables(), clientConnection.getHostName())).addSourceCode("\n");
                clientConnection.genStartSubmit("sysrputsync = yes", codeSegment, generateStatusMacros, generatePerformanceStatistics, generateTablePerformanceStatistics).addSourceCode("\n").indent();
                codeSegment.addSourceCode("%macro etls_remoteMacro;").addSourceCode("\n").indent();
            }
            codeSegment.addSourceCode(this.getLibnameStatement(!this.getModel().isUsingWebStreams() || generateFileNameForXML));
            if (generateStatusMacros) {
                codeSegment.addSourceCode(codeSegment.getRCSetCall("&syslibrc", true));
            }
            if (!isLocal) {
                if (generateStatusMacros) {
                    codeSegment.addSourceCode(codeSegment.getReturnCodeRemoteEnding(false)).addSourceCode("\n");
                }
                clientConnection = iServer.getConnectClient();
                codeSegment.unIndent().addSourceCode("%mend etls_remoteMacro;").addSourceCode("\n\n").addSourceCode("%etls_remoteMacro;").addSourceCode("\n\n").unIndent();
                clientConnection.genEndSubmit(codeSegment);
            }
        }
        return codeSegment.getGeneratedCode();
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        return this.genAccessPath(codeSegment, true);
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment, boolean generateStatusMacros) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        return this.genAccessPath(codeSegment, generateStatusMacros, null);
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment, boolean generateStatusMacros, Map additionalRemoteMacros) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        return this.genAccessPath(codeSegment, generateStatusMacros, additionalRemoteMacros, false, false);
    }

    public ICodeSegment genAccessPath(ICodeSegment codeSegment, boolean generateStatusMacros, Map additionalRemoteMacros, boolean generatePerformanceStatistics, boolean generateTablePerformanceStatistics) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        return this.genAccessPath(codeSegment, generateStatusMacros, additionalRemoteMacros, false, false, true);
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment, boolean generateStatusMacros, Map additionalRemoteMacros, boolean generatePerformanceStatistics, boolean generateTablePerformanceStatistics, boolean generateFileNameForXML) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException {
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        if (!environment.isOnLibraryContextList(this)) {
            codeSegment.addSourceCode(this.getAccessPath(environment, generateStatusMacros, additionalRemoteMacros, generatePerformanceStatistics, generateTablePerformanceStatistics, generateFileNameForXML));
        }
        environment.addLibraryToContextList(this);
        return codeSegment;
    }

    @Override
    public IServer getBestServer(IServer iDefaultServer) throws BadServerDefinitionException {
        int i;
        IServer[] lDeps = this.getServers();
        if (lDeps.length == 0) {
            return iDefaultServer;
        }
        for (i = 0; i < lDeps.length; ++i) {
            if (!ObjectComparator.isEqual(lDeps[i], iDefaultServer)) continue;
            return lDeps[i];
        }
        for (i = 0; i < lDeps.length; ++i) {
            IServer[] lLogicals = lDeps[i].getSubComponents();
            for (int j = 0; j < lLogicals.length; ++j) {
                IServer iLS = lLogicals[j];
                if (!iLS.getClassIdentifier().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) continue;
                return lDeps[i];
            }
        }
        throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("BaseLibrary.BadServerDefinition.txt"), this.getName()));
    }

    @Override
    public ILibrary getClientLibrary(IServer iDefaultServer) throws BadLibraryDefinitionException {
        IServer[] lRemoteLibServers;
        ILibrary iRemoteLib;
        int i;
        IServer[] lServers = this.getServers();
        if (lServers.length == 0) {
            return this;
        }
        for (int i2 = 0; i2 < lServers.length; ++i2) {
            IServer iSC = lServers[i2];
            if ("SHARE".equals(iSC.getClassIdentifier())) continue;
            return this;
        }
        IPersistableObject[] iUsedPkgs = this.getUsedPackages();
        ArrayList<IPersistableObject> iRemoteLibs = new ArrayList<IPersistableObject>();
        for (i = 0; i < iUsedPkgs.length; ++i) {
            if (!(iUsedPkgs[i] instanceof ILibrary)) continue;
            iRemoteLibs.add(iUsedPkgs[i]);
        }
        if (iRemoteLibs.isEmpty()) {
            throw new BadLibraryDefinitionException(MessageFormat.format(RB.getStringResource("BaseLibrary.CannotAssignShare.msg.txt"), this.getName()));
        }
        for (i = 0; i < iRemoteLibs.size(); ++i) {
            iRemoteLib = (ILibrary)iRemoteLibs.get(i);
            lRemoteLibServers = iRemoteLib.getServers();
            for (int j = 0; j < lRemoteLibServers.length; ++j) {
                IServer iRemoteLibServer = lRemoteLibServers[j];
                if (!ObjectComparator.isEqual(iRemoteLibServer, iDefaultServer)) continue;
                return iRemoteLib;
            }
        }
        for (i = 0; i < iRemoteLibs.size(); ++i) {
            iRemoteLib = (ILibrary)iRemoteLibs.get(i);
            lRemoteLibServers = iRemoteLib.getServers();
            if (lRemoteLibServers.length != 0) continue;
            return iRemoteLib;
        }
        return (ILibrary)iRemoteLibs.get(0);
    }

    @Override
    public boolean isRemoteToServer(IServer server) throws BadServerDefinitionException, BadLibraryDefinitionException {
        IServer libServer;
        boolean remote = false;
        ILibrary clientLibrary = this.getClientLibrary(server);
        if (clientLibrary != null && !ObjectComparator.isEqual(libServer = clientLibrary.getBestServer(server), server)) {
            remote = true;
        }
        return remote;
    }

    @Override
    public StringBuffer getInteractiveAccessPath(ICodeGenerationEnvironment environment) throws BadServerDefinitionException, RemoteException, MdException, BadLibraryDefinitionException {
        CodeSegment codeSegment = new CodeSegment(environment, this);
        IServer defaultServer = environment.getCurrentServer();
        ILibrary lib = this.getClientLibrary(defaultServer);
        if (lib != null) {
            lib.genAccessPath(codeSegment, false);
            if (this.isRemoteToServer(defaultServer)) {
                IServer bestServer = this.getBestServer(defaultServer);
                codeSegment.addSourceCode("libname ").addSourceCode(lib.getLibref()).addSourceCode(" REMOTE server=").addSourceCode(bestServer.getConnectClient().getHostName()).addSourceCode(";\n");
            }
        }
        return codeSegment.getGeneratedCode();
    }

    @Override
    public boolean isDBMSTemp(ILibrary library) {
        IDBMSType dbms = this.getDBMSType();
        if (!dbms.isDBMSTempSupported()) {
            return false;
        }
        IProperty[] libraryOptions = library.getOptions();
        for (int i = 0; i < libraryOptions.length; ++i) {
            String option;
            String[] nameValue;
            String value;
            if ("DBMSTEMP".equalsIgnoreCase(libraryOptions[i].getPropertyName())) {
                return true;
            }
            if (!"OPTIONSTRING".equalsIgnoreCase(libraryOptions[i].getPropertyName())) continue;
            Matcher oMatcher = IDBMSType.DBMSTEMP_PATTERN.matcher(libraryOptions[i].getDefaultValue());
            if (!oMatcher.find() || !(value = (nameValue = (option = oMatcher.group(0)).split("\\="))[1].trim()).equalsIgnoreCase("YES")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSessref(ILibrary library) {
        IProperty[] libraryOptions = library.getOptions();
        for (int i = 0; i < libraryOptions.length; ++i) {
            String option;
            String[] nameValue;
            String value;
            Matcher oMatcher;
            if ("SESSREF".equalsIgnoreCase(libraryOptions[i].getPropertyName())) {
                return true;
            }
            if (!"OPTIONSTRING".equalsIgnoreCase(libraryOptions[i].getPropertyName()) || !(oMatcher = IDBMSType.SESSREF_PATTERN.matcher(libraryOptions[i].getDefaultValue())).find() || (value = (nameValue = (option = oMatcher.group(0)).split("\\="))[1].trim()) == null || value.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSessref(ILibrary library) {
        String sessref = "";
        IProperty[] libraryOptions = library.getOptions();
        for (int i = 0; i < libraryOptions.length; ++i) {
            Matcher oMatcher;
            if ("SESSREF".equalsIgnoreCase(libraryOptions[i].getPropertyName())) {
                sessref = libraryOptions[i].getDefaultValue();
                return sessref;
            }
            if (!"OPTIONSTRING".equalsIgnoreCase(libraryOptions[i].getPropertyName()) || !(oMatcher = IDBMSType.SESSREF_PATTERN.matcher(libraryOptions[i].getDefaultValue())).find()) continue;
            String option = oMatcher.group(0);
            String[] nameValue = option.split("\\=");
            sessref = nameValue[1].trim();
            return sessref;
        }
        return sessref;
    }

    private class SetLibraryConnectionUndoable
    extends AbstractUndoableEdit {
        private ISASClientConnection m_oldLibraryConnection;
        private ISASClientConnection m_newLibraryConnection;

        public SetLibraryConnectionUndoable(ISASClientConnection oldLibraryConnection, ISASClientConnection newLibraryConnection) {
            this.m_oldLibraryConnection = oldLibraryConnection;
            this.m_newLibraryConnection = newLibraryConnection;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.setLibraryConnection(this.m_oldLibraryConnection);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.setLibraryConnection(this.m_newLibraryConnection);
        }

        @Override
        public void die() {
            this.m_oldLibraryConnection = null;
            this.m_newLibraryConnection = null;
        }
    }

    private class SetIsDBMSLibnameUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetIsDBMSLibnameUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.setIsDBMSLibname(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.setIsDBMSLibname(this.m_newValue);
        }
    }

    private class AddDirectoryUndoable
    extends AbstractUndoableEdit {
        private int m_iDirectory;
        private IDirectory m_Directory;

        public AddDirectoryUndoable(int iDirectory, IDirectory Directory2) {
            this.m_iDirectory = iDirectory;
            this.m_Directory = Directory2;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.removeDirectory(this.m_Directory);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.addDirectory(this.m_iDirectory, this.m_Directory);
        }

        @Override
        public void die() {
            this.m_Directory = null;
        }
    }

    private class RemoveDirectoryUndoable
    extends AbstractUndoableEdit {
        private int m_iDirectory;
        private IDirectory m_Directory;

        public RemoveDirectoryUndoable(int iDirectory, IDirectory Directory2) {
            this.m_iDirectory = iDirectory;
            this.m_Directory = Directory2;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.addDirectory(this.m_iDirectory, this.m_Directory);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.removeDirectory(this.m_Directory);
        }

        @Override
        public void die() {
            this.m_Directory = null;
        }
    }

    private class AddFileUndoable
    extends AbstractUndoableEdit {
        private int m_iFile;
        private IFile m_File;

        public AddFileUndoable(int iFile, IFile File2) {
            this.m_iFile = iFile;
            this.m_File = File2;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.removeFile(this.m_File);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.addFile(this.m_iFile, this.m_File);
        }

        @Override
        public void die() {
            this.m_File = null;
        }
    }

    private class RemoveFileUndoable
    extends AbstractUndoableEdit {
        private int m_iFile;
        private IFile m_File;

        public RemoveFileUndoable(int iFile, IFile File2) {
            this.m_iFile = iFile;
            this.m_File = File2;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.addFile(this.m_iFile, this.m_File);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.removeFile(this.m_File);
        }

        @Override
        public void die() {
            this.m_File = null;
        }
    }

    private class SetServerLibraryUndoable
    extends AbstractUndoableEdit {
        private ILibrary m_libraryOld;
        private ILibrary m_libraryNew;

        public SetServerLibraryUndoable(ILibrary libraryOld, ILibrary libraryNew) {
            this.m_libraryOld = libraryOld;
            this.m_libraryNew = libraryNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.setServerLibrary(this.m_libraryOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.setServerLibrary(this.m_libraryNew);
        }
    }

    private class SetLibrefUndoable
    extends AbstractUndoableEdit {
        private String m_librefOld;
        private String m_librefNew;

        public SetLibrefUndoable(String librefOld, String librefNew) {
            this.m_librefOld = librefOld;
            this.m_librefNew = librefNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.setLibref(this.m_librefOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.setLibref(this.m_librefNew);
        }
    }

    private class SetEngineUndoable
    extends AbstractUndoableEdit {
        private String m_engineOld;
        private String m_engineNew;

        public SetEngineUndoable(String engineOld, String engineNew) {
            this.m_engineOld = engineOld;
            this.m_engineNew = engineNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.setEngine(this.m_engineOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.setEngine(this.m_engineNew);
        }
    }

    private class SetDatabaseSchemaUndoable
    extends AbstractUndoableEdit {
        private IDatabaseSchema m_schemaOld;
        private IDatabaseSchema m_schemaNew;

        public SetDatabaseSchemaUndoable(IDatabaseSchema schemaOld, IDatabaseSchema schemaNew) {
            this.m_schemaOld = schemaOld;
            this.m_schemaNew = schemaNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.setDatabaseSchema(this.m_schemaOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.setDatabaseSchema(this.m_schemaNew);
        }
    }

    private class OptionAddedUndoable
    extends AbstractUndoableEdit {
        private IProperty m_property;

        public OptionAddedUndoable(IProperty property) {
            this.m_property = property;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.removeOption(this.m_property);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.addOption(this.m_property);
        }

        @Override
        public void die() {
            this.m_property = null;
        }
    }

    private class OptionRemovedUndoable
    extends AbstractUndoableEdit {
        private IProperty m_property;

        public OptionRemovedUndoable(IProperty property) {
            this.m_property = property;
        }

        @Override
        public void undo() {
            super.undo();
            BaseLibrary.this.addOption(this.m_property);
        }

        @Override
        public void redo() {
            super.redo();
            BaseLibrary.this.removeOption(this.m_property);
        }

        @Override
        public void die() {
            this.m_property = null;
        }
    }
}

