/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.impl.RB;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.AbstractSecondaryAttributeHelper;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseIndex
extends AbstractPersistableObject
implements IIndex {
    private boolean m_bClustered;
    private boolean m_bNoMissingValues;
    private boolean m_bUnique;
    private boolean m_bPrimary;
    private ModelList m_lColumns = new ModelList(this, new String[]{"Index:ColumnAdded", "Index:ColumnRemoved"}, 1, IColumn.class);
    private List m_lProperties;
    private SetTableHelper m_helper = new SetTableHelper();

    public BaseIndex(String sID, IModel model) {
        super(sID, model);
        this.m_lProperties = new ArrayList();
    }

    @Override
    public void setTable(IPhysicalTable tbl) {
        this.m_helper.set(tbl);
    }

    @Override
    public IPhysicalTable getTable() {
        return (IPhysicalTable)this.m_helper.get();
    }

    @Override
    public void setClustered(boolean bClustered) {
        if (this.m_bClustered == bClustered) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetClusteredUndoable(this.m_bClustered, bClustered));
        }
        this.m_bClustered = bClustered;
        this.fireModelChangedEvent("Index:ClusterChanged", null);
    }

    @Override
    public boolean isClustered() {
        return this.m_bClustered;
    }

    @Override
    public void setNoMissingValues(boolean bNoMissingValues) {
        if (this.m_bNoMissingValues == bNoMissingValues) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNoMissingValuesUndoable(this.m_bNoMissingValues, bNoMissingValues));
        }
        this.m_bNoMissingValues = bNoMissingValues;
        this.fireModelChangedEvent("Index:NoMissingValuesChanged", null);
    }

    @Override
    public boolean isNoMissingValues() {
        return this.m_bNoMissingValues;
    }

    @Override
    public void setUnique(boolean bUnique) {
        if (this.m_bUnique == bUnique) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUniqueUndoable(this.m_bUnique, bUnique));
        }
        this.m_bUnique = bUnique;
        this.fireModelChangedEvent("Index:UniqueChanged", null);
    }

    @Override
    public boolean isUnique() {
        return this.m_bUnique;
    }

    @Override
    public void setPrimary(boolean bPrimary) {
        if (this.m_bPrimary == bPrimary) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPrimaryUndoable(this.m_bPrimary, bPrimary));
        }
        this.m_bPrimary = bPrimary;
        this.fireModelChangedEvent("Index:PrimaryChanged", null);
    }

    @Override
    public boolean isPrimary() {
        return this.m_bPrimary;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && !this.getColumnsList().isEmpty() && this.getTable() != null;
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        IPhysicalTable table = this.getTable();
        if (table == null) {
            reasons.add(MessageFormat.format(RB.getStringResource("BaseIndex.NoTableDefined.msg.txt"), this.getName()));
        }
        if (table != null && this.getColumnsList().isEmpty()) {
            reasons.add(MessageFormat.format(RB.getStringResource("BaseIndex.NoColumns.msg.txt"), this.getName(), table.getName()));
        }
        return reasons;
    }

    @Override
    public void copy(IIndex index) {
        this.startCompoundUndoable();
        try {
            index.setDescription(this.getDescription());
            index.setName(this.getName());
            index.setClustered(this.isClustered());
            index.setNoMissingValues(this.isNoMissingValues());
            index.setUnique(this.isUnique());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IColumn[] getColumns() {
        return (IColumn[])this.m_lColumns.toArray(new IColumn[this.m_lColumns.size()]);
    }

    @Override
    public List getColumnsList() {
        return this.m_lColumns;
    }

    @Override
    public IProperty[] getProperties() {
        return this.m_lProperties.toArray(new IProperty[this.m_lProperties.size()]);
    }

    @Override
    public List getPropertyList() {
        return this.m_lProperties;
    }

    @Override
    public String getOMRType() {
        return "Index";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Index mdoIndex = (Index)omr.acquireOMRObject(this);
        mdoIndex.setIndexName(this.getName());
        mdoIndex.setIsClustered(this.m_bClustered ? 1 : 0);
        mdoIndex.setIsNoMiss(this.m_bNoMissingValues ? 1 : 0);
        mdoIndex.setIsUnique(this.m_bUnique ? 1 : 0);
        this.saveBooleanOptionToOMR(omr, "Primary", this.isPrimary());
        this.m_lColumns.saveToOMR(omr, (List)mdoIndex.getColumns(false));
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Index mdoIndex = (Index)omr.acquireOMRObject(this);
        this.m_bClustered = mdoIndex.getIsClustered() == 1;
        this.m_bNoMissingValues = mdoIndex.getIsNoMiss() == 1;
        this.m_bUnique = mdoIndex.getIsUnique() == 1;
        this.setPrimary(this.loadBooleanOptionFromOMR(omr, "Primary", false));
        this.m_lColumns.loadFromOMR(omr, (List)mdoIndex.getColumns());
        AssociationList options = mdoIndex.getProperties();
        int sizeOptions = options.size();
        for (int i = 0; i < sizeOptions; ++i) {
            Property prop = (Property)options.get(i);
            IPersistableObject p = (IPersistableObject)omr.acquireObject((Root)prop);
            this.m_lProperties.add(p);
        }
        this.setChanged(false);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get("Index");
        lAssociations.add("Columns");
        return map;
    }

    private class SetTableHelper
    extends AbstractSecondaryAttributeHelper {
        public SetTableHelper() {
            super(BaseIndex.this);
        }

        @Override
        protected void addTo(IObject primary) {
            ((IPhysicalTable)primary).getIndexesList().add(BaseIndex.this);
        }

        @Override
        protected void removeFrom(IObject primary) {
            ((IPhysicalTable)primary).getIndexesList().remove(BaseIndex.this);
        }
    }

    private class SetClusteredUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldClustered;
        private boolean m_newClustered;

        public SetClusteredUndoable(boolean oldClustered, boolean newClustered) {
            this.m_oldClustered = oldClustered;
            this.m_newClustered = newClustered;
        }

        @Override
        public void undo() {
            super.undo();
            BaseIndex.this.setClustered(this.m_oldClustered);
        }

        @Override
        public void redo() {
            super.redo();
            BaseIndex.this.setClustered(this.m_newClustered);
        }
    }

    private class SetNoMissingValuesUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldNoMissingValues;
        private boolean m_newNoMissingValues;

        public SetNoMissingValuesUndoable(boolean oldNoMissingValues, boolean newNoMissingValues) {
            this.m_oldNoMissingValues = oldNoMissingValues;
            this.m_newNoMissingValues = newNoMissingValues;
        }

        @Override
        public void undo() {
            super.undo();
            BaseIndex.this.setNoMissingValues(this.m_oldNoMissingValues);
        }

        @Override
        public void redo() {
            super.redo();
            BaseIndex.this.setNoMissingValues(this.m_newNoMissingValues);
        }
    }

    private class SetUniqueUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldUnique;
        private boolean m_newUnique;

        public SetUniqueUndoable(boolean oldUnique, boolean newUnique) {
            this.m_oldUnique = oldUnique;
            this.m_newUnique = newUnique;
        }

        @Override
        public void undo() {
            super.undo();
            BaseIndex.this.setUnique(this.m_oldUnique);
        }

        @Override
        public void redo() {
            super.redo();
            BaseIndex.this.setUnique(this.m_newUnique);
        }
    }

    private class SetPrimaryUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldPrimary;
        private boolean m_newPrimary;

        public SetPrimaryUndoable(boolean oldPrimary, boolean newPrimary) {
            this.m_oldPrimary = oldPrimary;
            this.m_newPrimary = newPrimary;
        }

        @Override
        public void undo() {
            super.undo();
            BaseIndex.this.setPrimary(this.m_oldPrimary);
        }

        @Override
        public void redo() {
            super.redo();
            BaseIndex.this.setPrimary(this.m_newPrimary);
        }
    }
}

