/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IGeneratedTable;
import com.sas.etl.models.data.IGeneratedTableColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.impl.AbstractTable;
import com.sas.etl.models.data.impl.RB;
import com.sas.etl.models.data.impl.TableUtil;
import com.sas.etl.models.impl.ObjectComparator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class BaseGeneratedTable<T extends IGeneratedTableColumn>
implements IGeneratedTable<T> {
    private List<T> _columns;
    private String _name;
    private String _description;
    private String m_id;
    private boolean m_allRequired;
    private String _sasName;

    public BaseGeneratedTable(String id) {
        this.setID(id);
        this._columns = new ArrayList<T>();
        this.setName(RB.getStringResource("BaseGeneratedTable.Default.Name.txt"));
        this.setSASName(TableUtil.createUniqueTableName(0));
        this.m_allRequired = false;
    }

    @Override
    public List<T> getColumns() {
        return this._columns;
    }

    @Override
    public int getColumnCount() {
        return this._columns.size();
    }

    @Override
    public void addColumn(T column) {
        this._columns.add(column);
    }

    public void addColumn(int iColumn, T column) {
        this._columns.add(iColumn, column);
    }

    public void removeColumn(T column) {
        this._columns.remove(column);
    }

    @Override
    public int indexOfColumn(T column) {
        return this._columns.indexOf(column);
    }

    public boolean containsColumn(T column) {
        return this._columns.contains(column);
    }

    public boolean containsColumnOfType(int columnType) {
        return false;
    }

    @Override
    public String getID() {
        return this.m_id;
    }

    private void setID(String id) {
        this.m_id = id;
    }

    @Override
    public void setName(String sName) {
        if (sName == null || sName.length() == 0) {
            return;
        }
        this._name = sName;
    }

    @Override
    public void setSASName(String sName) {
        this._sasName = sName;
    }

    @Override
    public String getSASName() {
        return this._sasName;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setDescription(String sDescription) {
        this._description = sDescription;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setAllGeneratedColumnsRequired(boolean allRequired) {
        this.m_allRequired = allRequired;
    }

    @Override
    public boolean isAllGeneratedColumnsRequired() {
        return this.m_allRequired;
    }

    @Override
    public boolean isComplete(IColumn[] columns) {
        if (columns == null) {
            return false;
        }
        for (IColumn c : columns) {
            T br = this.findColumnByName(c);
            if (br == null) {
                return false;
            }
            if (br.isComplete(c)) continue;
            return false;
        }
        if (this.isAllGeneratedColumnsRequired()) {
            for (IGeneratedTableColumn c : this.getColumns()) {
                if (AbstractTable.getColumnWithMatchingName(columns, c.getName(), false) != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete(IColumn[] columns) {
        ArrayList<String> lst = new ArrayList<String>();
        if (columns == null) {
            return lst;
        }
        for (IColumn c : columns) {
            T br = this.findColumnByName(c);
            if (br == null) {
                lst.add(MessageFormat.format(RB.getStringResource("BaseGeneratedTable.ColumnNoMatch.fmt"), c.getName(), this.getName()));
                continue;
            }
            lst.addAll(br.getReasonsIncomplete(c));
        }
        if (this.isAllGeneratedColumnsRequired()) {
            for (IGeneratedTableColumn c : this.getColumns()) {
                if (AbstractTable.getColumnWithMatchingName(columns, c.getName(), false) != null) continue;
                lst.add(MessageFormat.format(RB.getStringResource("BaseGeneratedTable.RequiredColumnNotFound.fmt"), c.getName(), this.getName()));
            }
        }
        return lst;
    }

    public List getReasonsIncomplete(IColumn[] columns, String baseTableName) {
        ArrayList<String> lst = new ArrayList<String>();
        if (columns == null) {
            return lst;
        }
        for (IColumn c : columns) {
            T br = this.findColumnByName(c);
            if (br == null) {
                lst.add(MessageFormat.format(RB.getStringResource("BaseGeneratedTable.ColumnNoMatch.fmt"), c.getName(), baseTableName));
                continue;
            }
            lst.addAll(br.getReasonsIncomplete(c));
        }
        if (this.isAllGeneratedColumnsRequired()) {
            for (IGeneratedTableColumn c : this.getColumns()) {
                if (AbstractTable.getColumnWithMatchingName(columns, c.getName(), false) != null) continue;
                lst.add(MessageFormat.format(RB.getStringResource("BaseGeneratedTable.RequiredColumnNotFound.fmt"), c.getName(), baseTableName));
            }
        }
        return lst;
    }

    public T findColumnByName(IColumn column) {
        for (IGeneratedTableColumn br : this.getColumns()) {
            if (!ObjectComparator.isEqual(br.getName(), column.getColumnName(false), false)) continue;
            return (T)br;
        }
        return null;
    }

    public T findColumnMatch(IColumn column) {
        for (IGeneratedTableColumn br : this.getColumns()) {
            if (!br.equals(column)) continue;
            return (T)br;
        }
        return null;
    }

    @Override
    public IPhysicalTable createNewTable(IPhysicalTable sourceTable, IModel model, String containerId) {
        IWorkTable table = model.getObjectFactory().createNewWorkTable(containerId);
        String name = this.getName();
        table.setName(name);
        table.setDescription(this.getDescription());
        table.setSASTableName(this.getSASName());
        for (IGeneratedTableColumn column : this.getColumns()) {
            IColumn c = column.createNewColumn(model, containerId, sourceTable);
            table.addColumn(c);
        }
        return table;
    }

    public String toString() {
        return this.getName();
    }
}

