/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDocument;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.impl.AbstractComplexPersistableObject;
import com.sas.etl.models.impl.AbstractSecondaryAttributeHelper;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.etl.models.other.IExtendedAttribute;
import com.sas.etl.models.other.INote;
import com.sas.metadata.remote.AnalyticColumn;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.services.util.Names;
import com.sas.util.UsageVersion;
import com.sas.workspace.WsColumnMetadataUtil;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseColumn
extends AbstractComplexPersistableObject
implements IColumn {
    private int m_eType = 0;
    private int m_length = 8;
    private int m_BeginPosition = 0;
    private int m_EndPosition = 0;
    private String m_sFormat = "";
    private String m_sInformat = "";
    private String m_sSummaryRole = "";
    private String m_sSortOrder = "";
    private boolean m_bNullable = true;
    private String m_sLevel = "";
    private SetTableHelper m_setTableHelper = new SetTableHelper();

    public BaseColumn(String sID, IModel model) {
        super(sID, model);
    }

    public String getPublicType() {
        return this.getTable() instanceof IWorkTable || this.getTable() instanceof ISubqueryTargetTable ? "Embedded:Column" : "Column";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return OMRColumn.CURRENT_VERSION;
    }

    @Override
    public boolean isPublicObject() {
        return true;
    }

    @Override
    protected boolean shouldLoadEditable() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.getTable() != null;
    }

    @Override
    public void setTable(ITable tbl) {
        this.m_setTableHelper.set(tbl);
    }

    @Override
    public ITable getTable() {
        return (ITable)this.m_setTableHelper.get();
    }

    @Override
    public void setType(int eType) {
        if (eType == this.m_eType) {
            return;
        }
        if (eType != 0 && eType != 1) {
            throw new IllegalArgumentException("Invalid type specified for column");
        }
        this.startCompoundUndoable();
        try {
            if (eType == 1) {
                this.setLength(Math.min(Math.max(3, this.m_length), 8));
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new SetTypeUndoable(this.m_eType, eType));
                }
            } else if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetTypeUndoable(this.m_eType, eType));
            }
            this.m_eType = eType;
            this.fireModelChangedEvent("Column:TypeChanged", null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public int getType() {
        return this.m_eType;
    }

    @Override
    public void setLength(int length) {
        if (length == this.m_length) {
            return;
        }
        if (this.m_eType == 1) {
            if (length < 3) {
                ModelLogger.getDefaultLogger().error((Object)("Length of numeric column less than 3: " + length + ".  Length reset to " + 3));
                length = 3;
            } else if (length > 8) {
                ModelLogger.getDefaultLogger().error((Object)("Length of numeric column greater than 8: " + length + ".  Length reset to " + 8));
                length = 8;
            }
        } else if (length < 1) {
            throw new IllegalArgumentException("Length of character column must be larger than 0");
        }
        this.setLengthImpl(length);
    }

    private void setLengthImpl(int length) {
        if (length == this.m_length) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLengthUndoable(this.m_length, length));
        }
        this.m_length = length;
        this.fireModelChangedEvent("Column:LengthChanged", null);
    }

    @Override
    public int getLength() {
        return this.m_length;
    }

    @Override
    public void setBeginPosition(int BeginPosition) {
        if (BeginPosition == this.m_BeginPosition) {
            return;
        }
        if (BeginPosition < 0) {
            throw new IllegalArgumentException("BeginPosition of a column must be greater than or equal to 0");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBeginPositionUndoable(this.m_BeginPosition, BeginPosition));
        }
        this.m_BeginPosition = BeginPosition;
        this.fireModelChangedEvent("Column:BeginPositionChanged", null);
    }

    @Override
    public int getBeginPosition() {
        return this.m_BeginPosition;
    }

    @Override
    public void setEndPosition(int EndPosition) {
        if (EndPosition == this.m_EndPosition) {
            return;
        }
        if (EndPosition < 0) {
            throw new IllegalArgumentException("EndPosition of a column must be greater than or equal to 0");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetEndPositionUndoable(this.m_EndPosition, EndPosition));
        }
        this.m_EndPosition = EndPosition;
        this.fireModelChangedEvent("Column:EndPositionChanged", null);
    }

    @Override
    public int getEndPosition() {
        return this.m_EndPosition;
    }

    @Override
    public void setFormat(String sFormat) {
        if (ObjectComparator.isEqual(sFormat, this.m_sFormat, false)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFormatUndoable(this.m_sFormat, sFormat));
        }
        this.m_sFormat = sFormat;
        this.fireModelChangedEvent("Column:FormatChanged", this.m_sFormat);
    }

    @Override
    public void setSortOrder(String sSortOrder) {
        if (sSortOrder.equals(this.m_sSortOrder)) {
            return;
        }
        if (sSortOrder.equalsIgnoreCase("(None)")) {
            sSortOrder = "";
        }
        if (!("".equalsIgnoreCase(sSortOrder) || "ASCENDING".equalsIgnoreCase(sSortOrder) || "DESCENDING".equalsIgnoreCase(sSortOrder) || "ASCFORMATTED".equalsIgnoreCase(sSortOrder) || "DSCFORMATTED".equalsIgnoreCase(sSortOrder) || "DSORDER".equalsIgnoreCase(sSortOrder))) {
            ModelLogger.getDefaultLogger().warn((Object)("Attempt to set invalid sort order so ignoring for column Name: " + this.getName() + " sSortOrder specified: " + sSortOrder));
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSortOrderUndoable(this.m_sSortOrder, sSortOrder));
        }
        this.m_sSortOrder = sSortOrder;
        this.fireModelChangedEvent("Column:SortOrderChanged", null);
    }

    @Override
    public String getSortOrder() {
        return this.m_sSortOrder;
    }

    @Override
    public String getFormat() {
        return this.m_sFormat;
    }

    @Override
    public void setInformat(String sInformat) {
        if (ObjectComparator.isEqual(sInformat, this.m_sInformat, false)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetInformatUndoable(this.m_sInformat, sInformat));
        }
        this.m_sInformat = sInformat;
        this.fireModelChangedEvent("Column:InformatChanged", this.m_sInformat);
    }

    @Override
    public String getInformat() {
        return this.m_sInformat;
    }

    @Override
    public String getLevel() {
        return this.m_sLevel;
    }

    @Override
    public void setSummaryRole(String sSummaryRole) {
        if (sSummaryRole.equals(this.m_sSummaryRole)) {
            return;
        }
        if (!(sSummaryRole.equalsIgnoreCase("") || sSummaryRole.equalsIgnoreCase("CLASS") || sSummaryRole.equalsIgnoreCase("ID") || sSummaryRole.equalsIgnoreCase("_DEFAULT_") || sSummaryRole.equalsIgnoreCase("STATISTIC") || sSummaryRole.equalsIgnoreCase("_FREQ_") || sSummaryRole.equalsIgnoreCase("_TYPE_"))) {
            ModelLogger.getDefaultLogger().warn((Object)("Attempt to set invalid summary role so ignoring for column Name: " + this.getName() + " summaryrole specified: " + sSummaryRole));
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSummaryRoleUndoable(this.m_sSummaryRole, sSummaryRole));
        }
        this.m_sSummaryRole = sSummaryRole;
        this.fireModelChangedEvent("Column:SummaryRoleChanged", null);
    }

    @Override
    public String getSummaryRole() {
        return this.m_sSummaryRole;
    }

    @Override
    public void setNullable(boolean bNullable) {
        if (this.m_bNullable == bNullable) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNullableUndoable(this.m_bNullable, bNullable));
        }
        this.m_bNullable = bNullable;
        this.fireModelChangedEvent("Column:NullableChanged", null);
    }

    @Override
    public boolean isNullable() {
        return this.m_bNullable;
    }

    @Override
    public void copy(IColumn column) {
        this.startCompoundUndoable();
        try {
            column.setName(this.getName());
            column.setDescription(this.getDescription());
            column.setType(this.getType());
            column.setLength(this.getLength());
            column.setBeginPosition(this.getBeginPosition());
            column.setEndPosition(this.getEndPosition());
            column.setFormat(this.getFormat());
            column.setInformat(this.getInformat());
            column.setSummaryRole(this.getSummaryRole());
            column.setSortOrder(this.getSortOrder());
            column.setNullable(this.isNullable());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deepCopy(IColumn column) {
        this.startCompoundUndoable();
        try {
            this.copy(column);
            List lCopyExtAttrs = column.getExtendedAttributesList();
            while (!lCopyExtAttrs.isEmpty()) {
                lCopyExtAttrs.remove(0);
            }
            IExtendedAttribute[] aExtAttrs = this.getExtendedAttributes();
            for (int iExtAttr = 0; iExtAttr < aExtAttrs.length; ++iExtAttr) {
                IExtendedAttribute attr = this.getObjectFactory().createNewExtendedAttribute(column.getID());
                aExtAttrs[iExtAttr].copy(attr);
                lCopyExtAttrs.add(attr);
            }
            column.setPrivateNote(this.getPrivateNote());
            List lCopyNotes = column.getNotesList();
            while (!lCopyNotes.isEmpty()) {
                lCopyNotes.remove(0);
            }
            INote[] aNotes = this.getNotes();
            for (int iNote = 0; iNote < aNotes.length; ++iNote) {
                lCopyNotes.add(aNotes[iNote]);
            }
            List lCopyDocuments = column.getDocumentsList();
            while (!lCopyDocuments.isEmpty()) {
                lCopyDocuments.remove(0);
            }
            IDocument[] aDocuments = this.getDocuments();
            for (int iDocument = 0; iDocument < aDocuments.length; ++iDocument) {
                lCopyDocuments.add(aDocuments[iDocument]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public String getColumnName(boolean quoted, boolean passthru) {
        return DBMSNamesUtil.getQuotedColumnName(this, quoted, passthru);
    }

    @Override
    public String getColumnName(boolean quoted) {
        return this.getColumnName(quoted, false);
    }

    @Override
    public String getColumnName(ICodeSegment codeSegment, boolean passthru) {
        return this.getColumnName(codeSegment.isQuoting(), passthru);
    }

    @Override
    public String getColumnName(ICodeSegment codeSegment) {
        return this.getColumnName(codeSegment.isQuoting());
    }

    @Override
    public String getFullColumnName() {
        return this.getFullColumnName(this.getTable().isQuoted(), false);
    }

    @Override
    public String getFullColumnName(boolean quotes, boolean passthru) {
        return this.getTable().getTableName(quotes, passthru) + "." + this.getColumnName(quotes, passthru);
    }

    @Override
    public String getFullColumnName(boolean quotes) {
        return this.getFullColumnName(quotes, false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Column mdoColumn = (Column)omr.acquireOMRObject(this);
        mdoColumn.setColumnName(this.getName());
        mdoColumn.setSASColumnName(this.getName());
        mdoColumn.setSortOrder(this.getSortOrder());
        mdoColumn.setSASColumnType(this.getType() == 1 ? "N" : "C");
        mdoColumn.setColumnLength(this.getLength());
        mdoColumn.setSASColumnLength(this.getLength());
        mdoColumn.setBeginPosition(this.getBeginPosition());
        mdoColumn.setEndPosition(this.getEndPosition());
        mdoColumn.setSASFormat(this.getFormat());
        mdoColumn.setSASInformat(this.getInformat());
        mdoColumn.setSummaryRole(this.getSummaryRole());
        mdoColumn.setIsNullable(this.isNullable() ? 1 : 0);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Column mdoColumn = (Column)omr.acquireOMRObject(this);
        try {
            this.setName(mdoColumn.getSASColumnName());
        }
        catch (IllegalArgumentException iae) {
            String newName = this.generateValidSASColumnName(mdoColumn);
            mdoColumn.setSASColumnName(newName);
            this.setName(mdoColumn.getSASColumnName());
        }
        this.setType(mdoColumn.getSASColumnType().equals("N") ? 1 : 0);
        this.setLengthImpl(mdoColumn.getSASColumnLength());
        this.setBeginPosition(mdoColumn.getBeginPosition());
        this.setEndPosition(mdoColumn.getEndPosition());
        this.setSortOrder(mdoColumn.getSortOrder());
        this.setFormat(mdoColumn.getSASFormat());
        this.setInformat(mdoColumn.getSASInformat());
        this.setSummaryRole(mdoColumn.getSummaryRole());
        this.setNullable(mdoColumn.getIsNullable() == 1);
        AssociationList analyticList = mdoColumn.getAnalyticColumns();
        if (!analyticList.isEmpty()) {
            AnalyticColumn aColumn = (AnalyticColumn)analyticList.get(0);
            this.m_sLevel = aColumn.getLevel();
        }
        if (!mdoColumn.getName().equals(mdoColumn.getSASColumnName())) {
            ModelLogger.getDefaultLogger().warn((Object)("Name != SASColumnName " + this));
        }
        this.setChanged(false);
    }

    private String generateValidSASColumnName(Column mdoColumn) throws RemoteException, MdException {
        DataTable mdoTable = mdoColumn.getTable();
        AssociationList columns = mdoTable.getColumns();
        ArrayList<String> existingNames = new ArrayList<String>(columns.size());
        for (Column tableColumn : columns) {
            String existingSASColName = tableColumn.getSASColumnName().trim();
            if (existingSASColName.length() <= 0) continue;
            existingNames.add(existingSASColName);
        }
        String newName = Names.mapNameToSASVariableName((String)mdoColumn.getName(), existingNames);
        return newName;
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("AnalyticColumns");
        return map;
    }

    @Override
    public String getOMRType() {
        return "Column";
    }

    @Override
    public void dump(PrintStream strm) {
        String sType = this.m_eType == 0 ? "C" : (this.m_eType == 1 ? "N" : "?");
        String sNullable = this.m_bNullable ? "Y" : "N";
        strm.println(this.getName() + ":" + this.getID() + ":" + sType + "," + this.m_length + "," + this.m_BeginPosition + "," + this.m_EndPosition + "," + this.m_sFormat + "," + this.m_sInformat + "," + this.m_sSortOrder + "," + this.m_sSummaryRole + "," + sNullable);
    }

    @Override
    public String getAttribStatement(boolean needQuotes, boolean isDataStep, boolean needFormats, boolean needLabels) {
        return this.getAttribStatement(needQuotes, isDataStep, needFormats, needFormats, needLabels);
    }

    @Override
    public String getAttribStatement(boolean needQuotes, boolean isDataStep, boolean needFormats, boolean needInformats, boolean needLabels) {
        String labelStatement;
        String infmtStm;
        String fmtStm;
        StringBuffer attrib = new StringBuffer();
        String columnName = this.getName();
        if (columnName == null || columnName.length() == 0) {
            return "";
        }
        if (needQuotes) {
            columnName = this.getColumnName(needQuotes);
        }
        attrib.append(columnName);
        String lengthStm = this.getLengthStatement(isDataStep);
        if (lengthStm != null && lengthStm.length() > 0) {
            attrib.append(" ");
            attrib.append(lengthStm);
        }
        if (needFormats && (fmtStm = this.getFormatStatement()) != null && fmtStm.length() > 0) {
            attrib.append("\n").append(fmtStm);
        }
        if (needInformats && (infmtStm = this.getInformatStatement()) != null && infmtStm.length() > 0) {
            attrib.append("\n").append(infmtStm);
        }
        if (needLabels && (labelStatement = this.getLabelStatement()) != null && labelStatement.length() > 0) {
            attrib.append("\n").append(labelStatement);
        }
        String stmt = attrib.toString();
        stmt = isDataStep ? "attrib " + stmt.replaceAll("\n", "\n   ") + "; \n" : stmt.replaceAll("\n", "\n   ");
        return stmt;
    }

    @Override
    public boolean equalsName(IColumn compareColumn, boolean quotes) {
        return this.equalsName(compareColumn.getName(), quotes);
    }

    @Override
    public boolean equalsName(String compareName, boolean quotes) {
        if (quotes) {
            return this.getName().equals(compareName);
        }
        return this.getName().equalsIgnoreCase(compareName);
    }

    @Override
    public boolean equalsFormat(IColumn compareColumn) {
        return this.getFormat().equalsIgnoreCase(compareColumn.getFormat());
    }

    @Override
    public boolean equalsInformat(IColumn compareColumn) {
        return this.getInformat().equalsIgnoreCase(compareColumn.getInformat());
    }

    @Override
    public boolean equalsLabel(IColumn compareColumn) {
        return this.getDescription().equals(compareColumn.getDescription());
    }

    @Override
    public String getValidFormat() {
        return WsColumnMetadataUtil.makeValidFmtName((String)this.getFormat(), (boolean)true, (String)(this.m_eType == 0 ? "C" : "N"));
    }

    @Override
    public String getValidInformat() {
        return WsColumnMetadataUtil.makeValidFmtName((String)this.getInformat(), (boolean)false, (String)(this.m_eType == 0 ? "C" : "N"));
    }

    @Override
    public String getFormatStatement() {
        StringBuffer formatStatement = new StringBuffer();
        String format = this.getFormat();
        if (format != null && !"".equals(format)) {
            formatStatement.append("format = ").append(this.getValidFormat());
        }
        return formatStatement.toString();
    }

    @Override
    public String getInformatStatement() {
        StringBuffer informatStatement = new StringBuffer();
        String informat = this.getInformat();
        if (informat != null && !"".equals(informat)) {
            informatStatement.append("informat = ").append(this.getValidInformat());
        }
        return informatStatement.toString();
    }

    @Override
    public String getLengthStatement(boolean isDataStep) {
        return this.getLengthStatement(isDataStep, true);
    }

    @Override
    public String getLengthStatement(boolean isDataStep, boolean includeLabel) {
        StringBuffer lengthStatement = new StringBuffer();
        if (includeLabel) {
            lengthStatement.append("length = ");
        }
        if (this.m_eType == 0 && isDataStep) {
            lengthStatement.append("$");
        }
        lengthStatement.append(this.getLength());
        return lengthStatement.toString();
    }

    @Override
    public String getLabelStatement() {
        return CodeSegment.getLabelStatement(this.getDescription()).toString();
    }

    @Override
    public boolean isColumnNameValidSASV7() {
        return Names.validateSASVariableName((String)this.getColumnName(false, false), (boolean)false);
    }

    private class SetTableHelper
    extends AbstractSecondaryAttributeHelper {
        public SetTableHelper() {
            super(BaseColumn.this);
        }

        @Override
        protected void addTo(IObject primary) {
            ((ITable)primary).addColumn(BaseColumn.this);
        }

        @Override
        protected void removeFrom(IObject primary) {
            ((ITable)primary).removeColumn(BaseColumn.this);
        }
    }

    private class SetTypeUndoable
    extends AbstractUndoableEdit {
        private int m_eOldType;
        private int m_eNewType;

        public SetTypeUndoable(int eOldType, int eNewType) {
            this.m_eOldType = eOldType;
            this.m_eNewType = eNewType;
        }

        @Override
        public void undo() {
            super.undo();
            BaseColumn.this.setType(this.m_eOldType);
        }

        @Override
        public void redo() {
            super.redo();
            BaseColumn.this.setType(this.m_eNewType);
        }
    }

    private class SetLengthUndoable
    extends AbstractUndoableEdit {
        private int m_oldLength;
        private int m_newLength;

        public SetLengthUndoable(int oldLength, int newLength) {
            this.m_oldLength = oldLength;
            this.m_newLength = newLength;
        }

        @Override
        public void undo() {
            super.undo();
            BaseColumn.this.setLength(this.m_oldLength);
        }

        @Override
        public void redo() {
            super.redo();
            BaseColumn.this.setLength(this.m_newLength);
        }
    }

    private class SetBeginPositionUndoable
    extends AbstractUndoableEdit {
        private int m_oldBeginPosition;
        private int m_newBeginPosition;

        public SetBeginPositionUndoable(int oldBeginPosition, int newBeginPosition) {
            this.m_oldBeginPosition = oldBeginPosition;
            this.m_newBeginPosition = newBeginPosition;
        }

        @Override
        public void undo() {
            super.undo();
            BaseColumn.this.setBeginPosition(this.m_oldBeginPosition);
        }

        @Override
        public void redo() {
            super.redo();
            BaseColumn.this.setBeginPosition(this.m_newBeginPosition);
        }
    }

    private class SetEndPositionUndoable
    extends AbstractUndoableEdit {
        private int m_oldEndPosition;
        private int m_newEndPosition;

        public SetEndPositionUndoable(int oldEndPosition, int newEndPosition) {
            this.m_oldEndPosition = oldEndPosition;
            this.m_newEndPosition = newEndPosition;
        }

        @Override
        public void undo() {
            super.undo();
            BaseColumn.this.setEndPosition(this.m_oldEndPosition);
        }

        @Override
        public void redo() {
            super.redo();
            BaseColumn.this.setEndPosition(this.m_newEndPosition);
        }
    }

    private class SetFormatUndoable
    extends AbstractUndoableEdit {
        private String m_oldFormat;
        private String m_newFormat;

        public SetFormatUndoable(String oldFormat, String newFormat) {
            this.m_oldFormat = oldFormat;
            this.m_newFormat = newFormat;
        }

        @Override
        public void undo() {
            super.undo();
            BaseColumn.this.setFormat(this.m_oldFormat);
        }

        @Override
        public void redo() {
            super.redo();
            BaseColumn.this.setFormat(this.m_newFormat);
        }
    }

    private class SetSortOrderUndoable
    extends AbstractUndoableEdit {
        private String m_oldSortOrder;
        private String m_newSortOrder;

        public SetSortOrderUndoable(String oldSortOrder, String newSortOrder) {
            this.m_oldSortOrder = oldSortOrder;
            this.m_newSortOrder = newSortOrder;
        }

        @Override
        public void undo() {
            super.undo();
            BaseColumn.this.setSortOrder(this.m_oldSortOrder);
        }

        @Override
        public void redo() {
            super.redo();
            BaseColumn.this.setSortOrder(this.m_newSortOrder);
        }
    }

    private class SetInformatUndoable
    extends AbstractUndoableEdit {
        private String m_oldInformat;
        private String m_newInformat;

        public SetInformatUndoable(String oldInformat, String newInformat) {
            this.m_oldInformat = oldInformat;
            this.m_newInformat = newInformat;
        }

        @Override
        public void undo() {
            super.undo();
            BaseColumn.this.setInformat(this.m_oldInformat);
        }

        @Override
        public void redo() {
            super.redo();
            BaseColumn.this.setInformat(this.m_newInformat);
        }
    }

    private class SetSummaryRoleUndoable
    extends AbstractUndoableEdit {
        private String m_oldSummaryRole;
        private String m_newSummaryRole;

        public SetSummaryRoleUndoable(String oldSummaryRole, String newSummaryRole) {
            this.m_oldSummaryRole = oldSummaryRole;
            this.m_newSummaryRole = newSummaryRole;
        }

        @Override
        public void undo() {
            super.undo();
            BaseColumn.this.setSummaryRole(this.m_oldSummaryRole);
        }

        @Override
        public void redo() {
            super.redo();
            BaseColumn.this.setSummaryRole(this.m_newSummaryRole);
        }
    }

    private class SetNullableUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldNullable;
        private boolean m_newNullable;

        public SetNullableUndoable(boolean oldNullable, boolean newNullable) {
            this.m_oldNullable = oldNullable;
            this.m_newNullable = newNullable;
        }

        @Override
        public void undo() {
            super.undo();
            BaseColumn.this.setNullable(this.m_oldNullable);
        }

        @Override
        public void redo() {
            super.redo();
            BaseColumn.this.setNullable(this.m_newNullable);
        }
    }
}

