/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.impl.AbstractParametersContainer;
import com.sas.etl.models.impl.AbstractSecondaryModelList;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IDataTransform;
import java.io.PrintStream;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class AbstractDataObject
extends AbstractParametersContainer
implements IDataObject {
    private List m_lConsumerTransforms = new ConsumerTransformsList();
    private List m_lProducerTransforms = new ProducerTransformsList();
    private String m_sChangedNodeId;

    public AbstractDataObject(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public IDataTransform[] getProducerTransforms() {
        return this.m_lProducerTransforms.toArray(new IDataTransform[this.m_lProducerTransforms.size()]);
    }

    @Override
    public boolean containsInProducerTransforms(IDataTransform transform) {
        return this.m_lProducerTransforms.contains(transform);
    }

    @Override
    public void addProducerTransform(IDataTransform transform) {
        if (!this.m_lProducerTransforms.contains(transform)) {
            this.m_lProducerTransforms.add(transform);
            this.fireNotifyEvent(1, new ModelEvent(this.getModel(), this, "IDataObject:ProducerAdded", transform));
            this.postAddProducerTransform(transform);
        }
    }

    protected void postAddProducerTransform(IDataTransform transform) {
    }

    @Override
    public void removeProducerTransform(IDataTransform transform) {
        this.m_lProducerTransforms.remove(transform);
        this.fireNotifyEvent(1, new ModelEvent(this.getModel(), this, "IDataObject:ProducerRemoved", transform));
    }

    @Override
    public IDataTransform[] getConsumerTransforms() {
        return this.m_lConsumerTransforms.toArray(new IDataTransform[this.m_lConsumerTransforms.size()]);
    }

    @Override
    public boolean containsInConsumerTransforms(IDataTransform transform) {
        return this.m_lConsumerTransforms.contains(transform);
    }

    @Override
    public void addConsumerTransform(IDataTransform transform) {
        if (!this.m_lConsumerTransforms.contains(transform)) {
            this.m_lConsumerTransforms.add(transform);
            this.fireNotifyEvent(1, new ModelEvent(this.getModel(), this, "IDataObject:ConsumerAdded", transform));
            this.postAddConsumerTransform(transform);
        }
    }

    protected void postAddConsumerTransform(IDataTransform transform) {
    }

    @Override
    public void removeConsumerTransform(IDataTransform transform) {
        this.m_lConsumerTransforms.remove(transform);
        this.fireNotifyEvent(1, new ModelEvent(this.getModel(), this, "IDataObject:ConsumerRemoved", transform));
    }

    @Override
    public void dump(PrintStream strm) {
        super.dump(strm);
        strm.println("<Producers>");
        for (int iProducer = 0; iProducer < this.m_lProducerTransforms.size(); ++iProducer) {
            strm.println(this.m_lProducerTransforms.get(iProducer));
        }
        strm.println("</Producers>");
        strm.println("<Consumers>");
        for (int iConsumer = 0; iConsumer < this.m_lConsumerTransforms.size(); ++iConsumer) {
            strm.println(this.m_lConsumerTransforms.get(iConsumer));
        }
        strm.println("</Consumers>");
    }

    @Override
    public String getChangedNodeId() {
        return this.m_sChangedNodeId;
    }

    @Override
    public void setChangedNodeId(String sNodeId) {
        if (this.m_sChangedNodeId != null && this.m_sChangedNodeId.equals(sNodeId)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetChangedNodeIdUndoable(this.m_sChangedNodeId, sNodeId));
        }
        this.m_sChangedNodeId = sNodeId;
    }

    private class ConsumerTransformsList
    extends AbstractSecondaryModelList {
        private ConsumerTransformsList() {
        }

        @Override
        protected void addTo(Object primary) {
            ((IDataTransform)primary).addDataSource(AbstractDataObject.this);
        }

        @Override
        protected void removeFrom(Object primary) {
            ((IDataTransform)primary).removeDataSource(AbstractDataObject.this);
        }
    }

    private class ProducerTransformsList
    extends AbstractSecondaryModelList {
        private ProducerTransformsList() {
        }

        @Override
        protected void addTo(Object primary) {
            ((IDataTransform)primary).addDataTarget(AbstractDataObject.this);
        }

        @Override
        protected void removeFrom(Object primary) {
            ((IDataTransform)primary).removeDataTarget(AbstractDataObject.this);
        }
    }

    private class SetChangedNodeIdUndoable
    extends AbstractUndoableEdit {
        private String m_oldChangedNodeId;
        private String m_newChangedNodeId;

        public SetChangedNodeIdUndoable(String oldChangedNodeId, String newChangedNodeId) {
            this.m_oldChangedNodeId = oldChangedNodeId;
            this.m_newChangedNodeId = newChangedNodeId;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataObject.this.setChangedNodeId(this.m_oldChangedNodeId);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataObject.this.setChangedNodeId(this.m_newChangedNodeId);
        }
    }
}

