/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.externalfile.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.externalfile.IFixedWidthExternalFile;
import com.sas.etl.models.data.externalfile.impl.AbstractStructuredExternalFile;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import javax.swing.undo.AbstractUndoableEdit;

public class FixedWidthExternalFile
extends AbstractStructuredExternalFile
implements IFixedWidthExternalFile {
    private boolean m_bPadColumnValues;
    private boolean m_bTruncover;
    private boolean m_bOverlap;
    private String m_sPadColumnValuesID = "";
    private String m_sTruncoverID = "";
    private String m_sOverlapID = "";

    public FixedWidthExternalFile(String id, IModel model) {
        super(id, model);
    }

    @Override
    public void setPadColumnValuesEnabled(boolean enabled) {
        if (this.m_bPadColumnValues == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPadColumnValuesEnabledUndoable(this.m_bPadColumnValues, enabled));
        }
        this.m_bPadColumnValues = enabled;
        this.fireModelChangedEvent("ExternalTable:PadColumnValuesChanged", null);
    }

    @Override
    public boolean isPadColumnValuesEnabled() {
        return this.m_bPadColumnValues;
    }

    @Override
    public void setTruncoverEnabled(boolean enabled) {
        if (this.m_bTruncover == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTruncoverEnabledUndoable(this.m_bTruncover, enabled));
        }
        this.m_bTruncover = enabled;
        this.fireModelChangedEvent("ExternalTable:TruncoverChanged", null);
    }

    @Override
    public boolean isTruncoverEnabled() {
        return this.m_bTruncover;
    }

    @Override
    public void setOverlapEnabled(boolean enabled) {
        if (this.m_bOverlap == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOverlapEnabledUndoable(this.m_bOverlap, enabled));
        }
        this.m_bOverlap = enabled;
        this.fireModelChangedEvent("ExternalTable:OverlapChanged", null);
    }

    @Override
    public boolean isOverlapEnabled() {
        return this.m_bOverlap;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        File mdoFile = (File)omr.acquireOMRObject(this);
        Property mdoProperty = this.findProperty(omr, (Root)mdoFile, "EFI_FILE_STRUCTURE", "FIXEDWIDTH", 32);
        AssociationList mdoFixedWidthProperties = mdoProperty.getProperties();
        boolean bFoundPad = false;
        boolean bFoundTruncover = false;
        boolean bFoundOverlap = false;
        if (!mdoFixedWidthProperties.isEmpty()) {
            for (int i = 0; i < mdoFixedWidthProperties.size(); ++i) {
                String propVal;
                Property mdoFixedWidthProperty = (Property)mdoFixedWidthProperties.get(i);
                String mdoPropertyName = mdoFixedWidthProperty.getName();
                if (mdoPropertyName.equalsIgnoreCase("PAD")) {
                    bFoundPad = true;
                    propVal = mdoFixedWidthProperty.getDefaultValue();
                    if (propVal.length() == 0) {
                        this.setPadColumnValuesEnabled(true);
                    } else {
                        this.setPadColumnValuesEnabled(Boolean.valueOf(propVal));
                    }
                    this.m_sPadColumnValuesID = mdoFixedWidthProperty.getFQID();
                    continue;
                }
                if (mdoPropertyName.equalsIgnoreCase("TRUNCOVER")) {
                    bFoundTruncover = true;
                    propVal = mdoFixedWidthProperty.getDefaultValue();
                    if (propVal.length() == 0) {
                        this.setTruncoverEnabled(true);
                    } else {
                        this.setTruncoverEnabled(Boolean.valueOf(propVal));
                    }
                    this.m_sTruncoverID = mdoFixedWidthProperty.getFQID();
                    continue;
                }
                if (!mdoPropertyName.equalsIgnoreCase("OVERLAP")) continue;
                bFoundOverlap = true;
                propVal = mdoFixedWidthProperty.getDefaultValue();
                if (propVal.length() == 0) {
                    this.setOverlapEnabled(true);
                } else {
                    this.setOverlapEnabled(Boolean.valueOf(propVal));
                }
                this.m_sOverlapID = mdoFixedWidthProperty.getFQID();
            }
            if (!bFoundPad) {
                this.setPadColumnValuesEnabled(false);
            }
            if (!bFoundTruncover) {
                this.setTruncoverEnabled(false);
            }
            if (!bFoundOverlap) {
                this.setOverlapEnabled(false);
            }
        } else {
            this.setPadColumnValuesEnabled(false);
            this.setTruncoverEnabled(false);
            this.setOverlapEnabled(false);
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        File mdoFile = (File)omr.acquireOMRObject(this);
        this.saveStringOptionToOMR(omr, "EFI_FILE_STRUCTURE", "FIXEDWIDTH", "");
        Property mdoFixedWidthProp = this.findProperty(omr, (Root)mdoFile, "EFI_FILE_STRUCTURE", "FIXEDWIDTH", 0);
        String sPadColumnValuesID = this.m_sPadColumnValuesID.equals("") || this.m_sPadColumnValuesID.length() == 0 ? this.createIDForNewObject() : this.m_sPadColumnValuesID;
        Property mdoPadProperty = (Property)omr.acquireOMRObject(sPadColumnValuesID, "Property");
        mdoPadProperty.setName("PAD");
        if (this.isPadColumnValuesEnabled()) {
            mdoPadProperty.setDefaultValue("true");
        } else {
            mdoPadProperty.setDefaultValue("false");
        }
        AssociationList mdoAList = mdoFixedWidthProp.getProperties();
        mdoAList.clear();
        mdoAList.add((Object)mdoPadProperty);
        String sTruncoverID = this.m_sTruncoverID.equals("") || this.m_sTruncoverID.length() == 0 ? this.createIDForNewObject() : this.m_sTruncoverID;
        Property mdoTruncoverProperty = (Property)omr.acquireOMRObject(sTruncoverID, "Property");
        mdoTruncoverProperty.setName("TRUNCOVER");
        if (this.isTruncoverEnabled()) {
            mdoTruncoverProperty.setDefaultValue("true");
        } else {
            mdoTruncoverProperty.setDefaultValue("false");
        }
        mdoAList.add((Object)mdoTruncoverProperty);
        String sOverlapID = this.m_sOverlapID.equals("") || this.m_sOverlapID.length() == 0 ? this.createIDForNewObject() : this.m_sOverlapID;
        Property mdoOverlapProperty = (Property)omr.acquireOMRObject(sOverlapID, "Property");
        mdoOverlapProperty.setName("OVERLAP");
        if (this.isOverlapEnabled()) {
            mdoOverlapProperty.setDefaultValue("true");
        } else {
            mdoOverlapProperty.setDefaultValue("false");
        }
        mdoAList.add((Object)mdoOverlapProperty);
    }

    private class SetPadColumnValuesEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetPadColumnValuesEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            FixedWidthExternalFile.this.setPadColumnValuesEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            FixedWidthExternalFile.this.setPadColumnValuesEnabled(this.m_newValue);
        }
    }

    private class SetTruncoverEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetTruncoverEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            FixedWidthExternalFile.this.setTruncoverEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            FixedWidthExternalFile.this.setTruncoverEnabled(this.m_newValue);
        }
    }

    private class SetOverlapEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetOverlapEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            FixedWidthExternalFile.this.setOverlapEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            FixedWidthExternalFile.this.setOverlapEnabled(this.m_newValue);
        }
    }
}

