/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.externalfile.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.externalfile.IFormatFileColumnImport;
import com.sas.etl.models.data.impl.BaseExternalTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseFormatFileColumnImport
extends AbstractPersistableObject
implements IFormatFileColumnImport {
    private IPersistableObject m_source;
    private IPersistableObject m_target;

    public BaseFormatFileColumnImport(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public IPersistableObject getSource() {
        return this.m_source;
    }

    @Override
    public void setSource(IPersistableObject object) {
        if (this.m_source == null && object == null) {
            return;
        }
        if (this.m_source != null && this.m_source.equals(object)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSourceUndoable(this.m_source, object));
        }
        this.m_source = object;
        this.fireModelChangedEvent("FormatFileImport:FormatFileChanged", null);
    }

    @Override
    public IPersistableObject getTarget() {
        return this.m_target;
    }

    @Override
    public void setTarget(IPersistableObject object) {
        this.m_target = object;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        super.loadFromOMR(omr);
        ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this);
        AssociationList transformationSources = mdoCM.getTransformationSources();
        if (!transformationSources.isEmpty()) {
            Root mdoCMTransfTarget;
            Root mdoCMTransfSource = (Root)transformationSources.get(0);
            this.m_source = (IPersistableObject)omr.acquireObject(mdoCMTransfSource);
            AssociationList transformationTargets = mdoCM.getTransformationTargets();
            if (!transformationTargets.isEmpty() && (mdoCMTransfTarget = (Root)transformationTargets.get(0)) != null) {
                this.m_target = (IPersistableObject)omr.acquireObject(mdoCMTransfTarget);
            }
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this);
        if (this.m_target instanceof BaseExternalTable) {
            mdoCM.setTransformRole("FormatFile");
        } else {
            mdoCM.setTransformRole("CobolFormatFile");
        }
        AssociationList transformationSources = mdoCM.getTransformationSources();
        transformationSources.clear();
        this.m_source.saveToOMR(omr);
        File mdoFile = (File)omr.acquireOMRObject(this.m_source);
        transformationSources.add(mdoFile);
        AssociationList transformationTargets = mdoCM.getTransformationTargets();
        transformationTargets.clear();
        this.m_target.saveToOMR(omr);
        Root mdoCMTarget = omr.acquireOMRObject(this.m_target);
        transformationTargets.add(mdoCMTarget);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_source != null) {
            this.m_source.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_source != null) {
            this.m_source.updateIDs(mapIDs);
        }
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "ClassifierMap";
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("TransformationTargets");
            lAssociations.add("TransformationSources");
            map.put(this.getOMRType(), lAssociations);
        } else {
            lAssociations.add("TransformationTargets");
            lAssociations.add("TransformationSources");
        }
        return map;
    }

    private class SetSourceUndoable
    extends AbstractUndoableEdit {
        private IPersistableObject m_oldSource;
        private IPersistableObject m_newSource;

        public SetSourceUndoable(IPersistableObject oldSource, IPersistableObject newSource) {
            this.m_oldSource = oldSource;
            this.m_newSource = newSource;
        }

        @Override
        public void undo() {
            super.undo();
            BaseFormatFileColumnImport.this.setSource(this.m_oldSource);
        }

        @Override
        public void redo() {
            super.redo();
            BaseFormatFileColumnImport.this.setSource(this.m_newSource);
        }
    }
}

