/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.edmflow.impl;

import com.sas.etl.models.DISUsageVersion;
import com.sas.etl.models.data.edmflow.IEDMFlow;
import com.sas.etl.models.data.edmflow.IEDMFlowTable;
import com.sas.etl.models.data.edmflow.IEDMFlowVersion;
import com.sas.etl.models.data.edmflow.impl.BaseEDMFlowColumn;
import com.sas.etl.models.data.edmflow.impl.BaseEDMFlowTable;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.publicobjects.decisionlogic.DLTarget;
import com.sas.publicobjects.decisionlogic.DSVariable;
import com.sas.publicobjects.decisionlogic.DecisionLogicInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BaseEDMFlowVersion
implements IEDMFlowVersion {
    private IEDMFlow _flow;
    private DISUsageVersion _version;
    private String _edmCode;
    private List<IEDMFlowTable> m_outputTables;
    private IEDMFlowTable _inputTable;
    public boolean m_isLoaded;

    public BaseEDMFlowVersion(IEDMFlow flow) throws ServiceException, RemoteException {
        this._flow = flow;
        this.m_isLoaded = false;
        this._version = new DISUsageVersion(0, 0);
        this.m_outputTables = new ArrayList<IEDMFlowTable>();
    }

    private boolean isLoaded() {
        return this.m_isLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromOMR() throws RemoteException, ServiceException {
        if (this.isLoaded()) {
            return;
        }
        ChildServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer().newChild(true);
        try {
            Collection stats;
            String key = this._flow.getID() + "/" + "Transformation";
            DecisionLogicInterface flow = (DecisionLogicInterface)server.fetch(key, false);
            this.setEDMCode(flow.getCode(DLTarget.DI));
            Collection inputs = flow.getInputVariables();
            if (inputs != null) {
                BaseEDMFlowTable tab1 = new BaseEDMFlowTable(this, "SOURCE_TABLE", "INPUTTABLE");
                for (Object invar : inputs) {
                    BaseEDMFlowColumn column = new BaseEDMFlowColumn(tab1, invar.name());
                    column.setDataType(invar.type());
                    column.setDescription(invar.description());
                    column.setName(invar.name());
                    tab1.addColumn(column);
                }
                this._inputTable = tab1;
            }
            this.m_outputTables.clear();
            Collection outputs = flow.getOutputVariables();
            if (outputs != null) {
                BaseEDMFlowTable tab2 = new BaseEDMFlowTable(this, "RESULTS_TABLE", "EDM Results");
                for (DSVariable outvar : outputs) {
                    BaseEDMFlowColumn column = new BaseEDMFlowColumn(tab2, outvar.name());
                    column.setDataType(outvar.type());
                    column.setDescription(outvar.description());
                    column.setName(outvar.name());
                    tab2.addColumn(column);
                }
                this.m_outputTables.add(tab2);
            }
            if ((stats = flow.getStatsVariables()) != null) {
                BaseEDMFlowTable tab3 = new BaseEDMFlowTable(this, "STATS_TABLE", "EDM Stats");
                for (DSVariable statvar : stats) {
                    BaseEDMFlowColumn column = new BaseEDMFlowColumn(tab3, statvar.name());
                    column.setDataType(statvar.type());
                    column.setDescription(statvar.description());
                    column.setName(statvar.name());
                    column.setDisplayName(statvar.displayName());
                    tab3.addColumn(column);
                }
                this.m_outputTables.add(tab3);
            }
            this.m_isLoaded = true;
        }
        finally {
            if (server != null) {
                server.destroy();
            }
        }
    }

    @Override
    public DISUsageVersion getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(DISUsageVersion version) {
        this._version = version;
    }

    @Override
    public String getEDMCode() {
        return this._edmCode;
    }

    @Override
    public void setEDMCode(String edmCode) {
        this._edmCode = edmCode;
    }

    @Override
    public IEDMFlow getFlow() {
        return this._flow;
    }

    @Override
    public int compareTo(IEDMFlowVersion o) {
        return this.getVersion().compareTo(o.getVersion());
    }

    public String toString() {
        return this.getVersion().toString();
    }

    @Override
    public IEDMFlowTable findOutputTable(String id) {
        for (IEDMFlowTable output : this.getOutputs()) {
            if (!ObjectComparator.isEqual(output.getID(), id)) continue;
            return output;
        }
        return null;
    }

    public void clearOutputs() {
        this.m_outputTables.clear();
    }

    @Override
    public IEDMFlowTable[] getOutputs() {
        return this.m_outputTables.toArray(new IEDMFlowTable[this.m_outputTables.size()]);
    }

    @Override
    public IEDMFlowTable getInput() {
        return this._inputTable;
    }
}

