/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.edmflow.impl;

import com.sas.etl.models.DISUsageVersion;
import com.sas.etl.models.IModel;
import com.sas.etl.models.data.edmflow.IEDMFlow;
import com.sas.etl.models.data.edmflow.IEDMFlowVersion;
import com.sas.etl.models.data.edmflow.impl.BaseEDMFlowVersion;
import com.sas.etl.models.data.impl.AbstractDataObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.MdException;
import com.sas.publicobjects.decisionlogic.DecisionLogic;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class BaseEDMFlow
extends AbstractDataObject
implements IEDMFlow {
    private UsageVersion m_usageVersion;
    private Map<DISUsageVersion, IEDMFlowVersion> _versions = new TreeMap<DISUsageVersion, IEDMFlowVersion>();
    private IEDMFlowVersion _defaultVersion;

    public BaseEDMFlow(String id, IModel model) {
        super(id, model);
        this.setArchitectureVersionNumber(DecisionLogic.CURRENT_VERSION);
    }

    public IEDMFlowVersion[] getVersions() {
        ArrayList<IEDMFlowVersion> versions = new ArrayList<IEDMFlowVersion>(this._versions.values());
        Collections.reverse(versions);
        return versions.toArray(new IEDMFlowVersion[versions.size()]);
    }

    private void addVersion(IEDMFlowVersion version) {
        if (this._versions.containsKey(version.getVersion())) {
            return;
        }
        this._versions.put(version.getVersion(), version);
    }

    @Override
    public IEDMFlowVersion findVersion(DISUsageVersion version) {
        return this._versions.get(version);
    }

    public static DISUsageVersion convertToUsageVersion(String strVersion) {
        String[] numbers = strVersion.split("\\.");
        DISUsageVersion version = null;
        version = numbers.length == 2 ? new DISUsageVersion(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1])) : (numbers.length == 3 ? new DISUsageVersion(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1]), Integer.parseInt(numbers[2])) : new DISUsageVersion(1, 0));
        return version;
    }

    @Override
    public String getPublicType() {
        return "DecisionLogic";
    }

    @Override
    public String getOMRType() {
        return "Transformation";
    }

    @Override
    public IEDMFlowVersion getDefaultVersion() {
        return this._defaultVersion;
    }

    protected void setDefaultVersion(IEDMFlowVersion version) {
        this._defaultVersion = version;
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return this.m_usageVersion;
    }

    @Override
    protected void setArchitectureVersionNumber(UsageVersion version) {
        this.m_usageVersion = version;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        super.loadFromOMR(omr);
        ChildServerInterface child = null;
        try {
            child = Workspace.getWorkspace().getUserContext().getAuthServer().newChild(true);
            BaseEDMFlowVersion edmv = new BaseEDMFlowVersion(this);
            edmv.loadFromOMR();
            this.addVersion(edmv);
            this.setDefaultVersion(edmv);
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        finally {
            try {
                if (child != null) {
                    child.destroy();
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }
}

