/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.ILoaderTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.visuals.expression.UserDefinedFunction;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TERADATAType
extends BaseDBMSType {
    private static final String UPSERT_CMD = "multiload=yes upsert=yes";
    public static final Pattern MODE_PATTERN = Pattern.compile("(?i)\\b(mode)\\s*=\\s*(\\\"[^\\\"]*\\\"|[^\\s*]*)");
    private static final String TERADATA = "TERADATA";
    private static final String OPTION_MODE = "MODE";

    public TERADATAType() {
        this.setUpsertSupport(true);
        this.setTruncateSupport(false);
        this.setAddOneKeyPerExecute(true);
        this.setUnquotedTableNameAction("U");
        this.setDBMSTempSupport(true);
    }

    @Override
    public ICodeSegment genTableDelete(ICodeSegment codeSegment, boolean isView, String tableName, String passwordOptions) throws BadLibraryDefinitionException, CodegenException, RemoteException, ServerException, MdException, BadServerDefinitionException {
        return this.genTableProcDelete(codeSegment, isView, tableName, passwordOptions);
    }

    @Override
    public int getDBMSTypeID() {
        return 12;
    }

    @Override
    public String getDBMSTypeName() {
        return "Teradata";
    }

    @Override
    public boolean isModelManagerFunctionSetsSupported() {
        return true;
    }

    @Override
    public StringBuffer getModelManagerProjectsQuery(ILibrary library, boolean quotes) {
        StringBuffer code = new StringBuffer();
        code.append("select distinct project_name, project_uuid ");
        if (library.getLibref() != null) {
            code.append(" from ").append(library.getLibref()).append(".project_metadata");
        } else {
            code.append("from project_metadata");
        }
        return code;
    }

    @Override
    public StringBuffer getModelManagerFunctionSetsQuery(ILibrary library, boolean quotes, List types) {
        StringBuffer code = new StringBuffer();
        String uuidWhere = "project_uuid IN (";
        for (int iType = 0; iType < types.size(); ++iType) {
            String name = (String)types.get(iType);
            int start = name.indexOf("(") + 2;
            int end = name.indexOf(")");
            String uuid = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
            if (iType > 0 && iType < types.size()) {
                uuidWhere = uuidWhere + ",";
            }
            uuidWhere = uuidWhere + "\"" + uuid + "\" ";
        }
        uuidWhere = uuidWhere + ")";
        if (!quotes) {
            code.append("select model_name, udf_name, udf_signature, mining_function, mining_algorithm").append(" from ");
            if (library.getLibref() != null) {
                code.append(library.getLibref()).append(".model_metadata where model_uuid IN ");
            }
            code.append("(select model_uuid ");
            if (library.getLibref() != null) {
                code.append(" from ").append(library.getLibref()).append(".project_model_info").append(" where model_enabled=\"T\" and ").append(uuidWhere).append(");");
            }
        } else {
            code.append("select model_name, udf_name, udf_signature, mining_function, mining_algorithm").append(" from ");
            if (library.getLibref() != null) {
                code.append(library.getLibref()).append(".model_metadata where model_uuid IN ");
            }
            code.append("(select model_uuid ");
            if (library.getLibref() != null) {
                code.append(" from ").append(library.getLibref()).append(".project_model_info").append(" where model_enabled=\"T\" and ").append(uuidWhere).append(");");
            }
        }
        return code;
    }

    @Override
    public boolean isNativeFunctionSetsSupported() {
        return true;
    }

    @Override
    public StringBuffer getNativeFunctionSetsQuery(ILibrary library, boolean quotes) {
        StringBuffer code = new StringBuffer();
        code.append("select a.FunctionName, a.NumParameters, a.databasename, a.ParameterDataTypes, ").append("b.ColumnName, a.SpecificName");
        if (library.getLibref() != null) {
            code.append(" from ").append(library.getLibref()).append(".functions a").append(" left outer join ").append(library.getLibref()).append(".columns b ");
        } else {
            code.append(" from functions a left outer join columns b ");
        }
        code.append("on a.databasename = b.databasename and a.specificname = b.tablename ").append("where b.SPParameterType=\"I\"").append("order by a.databasename, a.specificname, b.columnid;");
        return code;
    }

    @Override
    public List createNativeFunctionsFromQueryResults(MVAResultSet rsltSet) throws SQLException {
        ArrayList<UserDefinedFunction> sets = new ArrayList<UserDefinedFunction>();
        if (rsltSet != null) {
            UserDefinedFunction func;
            StringBuffer sbDatabaseName;
            StringBuffer sbSpecificName;
            String sName = null;
            String sDisplayName = null;
            String sDatabaseName = null;
            String sSpecificName = null;
            String sDescription = null;
            String sFormat = null;
            String sStartDescription = RB.getStringResource("BaseDBMSType.ImportUserDefinedFunctionsDescription.txt");
            String oldName = null;
            String argName = null;
            int position = -1;
            int numParms = 0;
            String argType = null;
            boolean bFirst = true;
            boolean bDone = false;
            while (rsltSet.next()) {
                sName = rsltSet.getString(1).trim();
                sSpecificName = rsltSet.getString(6).trim();
                if (sName == null || sName.equals("")) continue;
                if (!sSpecificName.equals(oldName) && oldName != null) {
                    if (numParms > 0 && position > -1) {
                        sFormat = sFormat + ")";
                        sDisplayName = sDisplayName + ")";
                    }
                    sbSpecificName = new StringBuffer();
                    if (sSpecificName != null) {
                        sbSpecificName.append("<o:p></o:p></span></p>");
                        sbSpecificName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                        sbSpecificName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                        sbSpecificName.append("style='mso-bidi-font-family:Arial'>").append(RB.getStringResource("TERADATAType.SpecificName.txt")).append("<o:p></o:p></span></b></h2>");
                        sbSpecificName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                        sbSpecificName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                        sbSpecificName.append("   Arial'>").append(sSpecificName).append("<o:p></o:p></span></p>");
                    }
                    sbDatabaseName = new StringBuffer();
                    if (sDatabaseName != null) {
                        sbDatabaseName.append("<o:p></o:p></span></p>");
                        sbDatabaseName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                        sbDatabaseName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                        sbDatabaseName.append("style='mso-bidi-font-family:Arial'>").append(RB.getStringResource("TERADATAType.DatabaseName.txt")).append("<o:p></o:p></span></b></h2>");
                        sbDatabaseName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                        sbDatabaseName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                        sbDatabaseName.append("   Arial'>").append(sDatabaseName).append("<o:p></o:p></span></p>");
                    }
                    sDescription = sStartDescription + sbSpecificName + sbDatabaseName;
                    func = new UserDefinedFunction(sName, sDisplayName, sDescription, sFormat);
                    sets.add(func);
                    sDisplayName = null;
                    sDatabaseName = null;
                    sDescription = null;
                    sFormat = null;
                    bFirst = true;
                    numParms = 0;
                    position = 0;
                }
                oldName = sSpecificName;
                sDatabaseName = rsltSet.getString(3).trim();
                argName = rsltSet.getString(5).trim();
                argType = rsltSet.getString(4).trim();
                numParms = rsltSet.getInt(2);
                if (!sSpecificName.equals(oldName) && oldName != null) continue;
                int endIndex = position + 2;
                if (endIndex > argType.length()) {
                    endIndex = argType.length();
                }
                if (numParms == 0) {
                    sFormat = sName + "( )";
                    sDisplayName = sName + "( )";
                    continue;
                }
                if (bFirst) {
                    sFormat = sName + "(<" + argType.substring(0, endIndex).trim() + ">";
                    sDisplayName = sName + "(" + argName;
                    bFirst = false;
                    position = 2;
                    continue;
                }
                if (position <= 0) continue;
                sFormat = sFormat + ", <" + argType.substring(position, endIndex).trim() + ">";
                sDisplayName = sDisplayName + ", " + argName;
                position += 2;
            }
            rsltSet.close();
            if (sName != null) {
                if (numParms > 0 && position > -1) {
                    sFormat = sFormat + ")";
                    sDisplayName = sDisplayName + ")";
                }
                sbSpecificName = new StringBuffer();
                if (sSpecificName != null) {
                    sbSpecificName.append("<o:p></o:p></span></p>");
                    sbSpecificName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                    sbSpecificName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                    sbSpecificName.append("style='mso-bidi-font-family:Arial'>").append(RB.getStringResource("TERADATAType.SpecificName.txt")).append("<o:p></o:p></span></b></h2>");
                    sbSpecificName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                    sbSpecificName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                    sbSpecificName.append("   Arial'>").append(sSpecificName).append("<o:p></o:p></span></p>");
                }
                sbDatabaseName = new StringBuffer();
                if (sDatabaseName != null) {
                    sbDatabaseName.append("<o:p></o:p></span></p>");
                    sbDatabaseName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                    sbDatabaseName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                    sbDatabaseName.append("style='mso-bidi-font-family:Arial'>").append(RB.getStringResource("TERADATAType.DatabaseName.txt")).append("<o:p></o:p></span></b></h2>");
                    sbDatabaseName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                    sbDatabaseName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                    sbDatabaseName.append("   Arial'>").append(sDatabaseName).append("<o:p></o:p></span></p>");
                }
                sDescription = sStartDescription + sbSpecificName + sbDatabaseName;
                func = new UserDefinedFunction(sName, sDisplayName, sDescription, sFormat);
                sets.add(func);
            }
        }
        return sets;
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        boolean quoting = codeSegment.isQuoting();
        if (quoting) {
            codeSegment.addSourceCode("drop index \"%bquote(&etls_indexName)\"");
        } else {
            codeSegment.addSourceCode("drop index &etls_indexName");
        }
        return codeSegment.addSourceCode(" on " + tableName + " \n");
    }

    @Override
    public List getIndexesToCreate(IPhysicalTable table) {
        List indexList = table.getIndexesNotInUniqKeys();
        IIndex primaryIndex = this.getPrimaryIndex(table);
        if (primaryIndex != null) {
            indexList.remove(primaryIndex);
        }
        return indexList;
    }

    private String getDBQuotedColumnString(IColumn[] columns) {
        StringBuffer cols = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            cols.append("\"").append(columns[i].getColumnName(false, true)).append("\"");
            if (i >= columns.length - 1) continue;
            cols.append(",");
        }
        return cols.toString();
    }

    @Override
    public String getDBCreateStatements(IPhysicalTable table) {
        StringBuffer createIndex = new StringBuffer();
        IIndex primaryIndex = this.getPrimaryIndex(table);
        if (primaryIndex != null && (primaryIndex.getColumns().length != 1 || primaryIndex.getColumns()[0] != table.getColumns()[0])) {
            if (primaryIndex.isUnique()) {
                createIndex.append("unique ");
            }
            createIndex.append("primary index " + primaryIndex.getName() + " (").append(this.getDBQuotedColumnString(primaryIndex.getColumns())).append(")");
        }
        return createIndex.toString();
    }

    public IIndex getPrimaryIndex(IPhysicalTable table) {
        if (table == null || table.getColumnCount() == 0) {
            return null;
        }
        IIndex[] inds = table.getIndexes();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].isPrimary()) continue;
            return inds[i];
        }
        IColumn col1 = table.getColumns()[0];
        for (int i = inds.length - 1; i >= 0; --i) {
            IColumn indexCol;
            if (inds[i].getColumnsList().size() != 1 || !col1.equals(indexCol = (IColumn)inds[i].getColumnsList().get(0))) continue;
            return inds[i];
        }
        return null;
    }

    @Override
    public List getUniqueKeysToCreate(IPhysicalTable table) throws CodegenException {
        List keyList = super.getUniqueKeysToCreate(table);
        IKey primaryIndexKey = this.getKeyMatchingPrimaryIndex(table);
        if (primaryIndexKey != null) {
            keyList.remove(primaryIndexKey);
        }
        return keyList;
    }

    public IKey getKeyMatchingPrimaryIndex(IPhysicalTable table) {
        IKey[] keys = table.getKeys();
        IIndex primaryIndex = this.getPrimaryIndex(table);
        for (int i = 0; i < keys.length; ++i) {
            List keyColumns = keys[i].getColumnsList();
            if (!(primaryIndex != null ? primaryIndex.getColumnsList().equals(keyColumns) : keyColumns.size() == 1 && keyColumns.get(0) == table.getColumns()[0])) continue;
            return keys[i];
        }
        return null;
    }

    public void removeUniqueKeyMatchingCol1(List keyList, IPhysicalTable table) {
        IColumn col1 = table.getColumns()[0];
        for (int i = keyList.size() - 1; i >= 0; --i) {
            IKey thisKey = (IKey)keyList.get(i);
            if (thisKey.getColumnsList().size() != 1) continue;
            IColumn keyCol1 = (IColumn)thisKey.getColumnsList().get(0);
            if (!col1.getID().equals(keyCol1.getID())) continue;
            keyList.remove(i);
        }
    }

    @Override
    public ICodeSegment genSingleIndex(ICodeSegment codeSegment, IPhysicalTable table, IIndex index) throws CodegenException, BadLibraryDefinitionException {
        String pre_opts = this.getPreIndexOptions(index);
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        String idxname = this.getIndexName(codeSegment, index, true);
        if (idxname == null || idxname.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.IndexNameUndefined.msg.txt"), (IObject)index);
        }
        List cols = index.getColumnsList();
        int cols_length = cols.size();
        if (cols_length > 0) {
            codeSegment.addSourceCode("create " + pre_opts + "\n").indent().addSourceCode("index " + idxname + "\n");
            codeSegment.indent().addSourceCode("(");
            for (int i = 0; i < cols_length; ++i) {
                IColumn col = (IColumn)cols.get(i);
                String colName = this.getIndexColumnName(codeSegment, col);
                if (i > 0) {
                    codeSegment.addSourceCode(", \n ");
                }
                codeSegment.addSourceCode(colName);
            }
        } else {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoColumnsDefined.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode(")\n").unIndent();
        codeSegment.unIndent().addSourceCode("on " + tableName + "\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getTableName(false, true).toUpperCase();
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        String schema = this.getSchemaName(codeSegment.getCurrentServer(), table, false).toUpperCase();
        codeSegment.indent().addSourceCode("from connection to " + this.getNickName(codeSegment, table) + "\n").addSourceCode("( \n").indent().addSourceCode("select distinct IndexName as idxname, \n").addSourceCode("       TableName as tabname \n").indent().addSourceCode("from DBC.IndicesX\n").indent();
        tableName = tableName.replaceAll("'", "''");
        codeSegment.addSourceCode("where upper(TableName) eq '" + tableName + "' and \n").addSourceCode("      upper(DataBaseName) eq '" + schema + "' and \n").addSourceCode("      IndexName ne ' ' and IndexType not in ('P', 'Q') \n").unIndent().unIndent().unIndent().addSourceCode(");\n").unIndent();
        return codeSegment;
    }

    @Override
    public ICodeSegment genDeleteAll(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("delete from " + tableName + " ALL\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment genExecuteCommit(ICodeSegment codeSegment, IPhysicalTable table, String prefix) throws CodegenException {
        ILibrary library = table.getLibraryForUseInJob();
        IProperty[] props = library.getOptions();
        for (int i = 0; i < props.length; ++i) {
            String x;
            if (OPTION_MODE.equalsIgnoreCase(props[i].getPropertyName()) && TERADATA.equalsIgnoreCase(props[i].getDefaultValue())) {
                return codeSegment;
            }
            if (!"OPTIONSTRING".equalsIgnoreCase(props[i].getPropertyName())) continue;
            Matcher oMatcher = MODE_PATTERN.matcher(props[i].getDefaultValue());
            String value = oMatcher.find() ? oMatcher.group(0) : "";
            String[] values = value.split("\\=");
            String string = x = values.length == 2 ? values[1].trim() : null;
            if (!TERADATA.equalsIgnoreCase(x)) continue;
            return codeSegment;
        }
        return codeSegment.addSourceCode("execute (commit) by " + this.getNickName(codeSegment, table) + "; \n");
    }

    @Override
    public ICodeSegment loadWithUpsert(ICodeSegment codeSegment, IPhysicalTable table, List matchColList, boolean unmappedEqMissingInUpdate, List unmappedColList, String additionalTableOptions, IDataTransform transform) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String tableNameFull = table.getFullNameQuotedAsNeeded(codeSegment);
        StringBuffer gen_opts = new StringBuffer();
        gen_opts.append(transform.getTableOptionObject(table, false).getTableOptions(false, null, "", codeSegment.getCurrentServer()));
        List<IColumn> columnList = Arrays.asList(table.getColumns());
        String matchColStr = codeSegment.makeColumnList(matchColList, false, "   ", false, ",", "", codeSegment.isQuoting(), "", false);
        String colsToKeepStr = "";
        if (!unmappedEqMissingInUpdate && unmappedColList != null && unmappedColList.size() > 0) {
            ArrayList<String> colsToKeep = new ArrayList<String>();
            for (int i = 0; i < columnList.size(); ++i) {
                IColumn col = columnList.get(i);
                if (!unmappedColList.contains(col)) {
                    colsToKeep.add(col.getColumnName(false));
                    continue;
                }
                IColumn loadTimeColumn = ((ILoaderTransform)transform).getLoadTimeColumn();
                if (loadTimeColumn == null || !loadTimeColumn.equals(col)) continue;
                colsToKeep.add(col.getColumnName(false));
            }
            if (colsToKeep.size() > 0) {
                colsToKeepStr = "keep = " + codeSegment.makeColumnList(colsToKeep, false, "     ", false, " ", "", codeSegment.isQuoting(), "", false);
            }
        }
        String optionIndent = "            ";
        codeSegment.addCommentLine(RB.getStringResource("BaseDBMSType.UpsertRequirements.msg.notrans")).addSourceCode("proc append base = " + tableNameFull + " ( \n").addSourceCode(optionIndent + UPSERT_CMD + "\n").addSourceCode(optionIndent + "upsert_where=(").addSourceCode(matchColStr + ")\n");
        if (!colsToKeepStr.equals("")) {
            codeSegment.addSourceCode(optionIndent + colsToKeepStr + "\n");
        }
        codeSegment.addSourceCode(optionIndent + gen_opts.toString());
        if (additionalTableOptions != null && additionalTableOptions.length() > 0) {
            codeSegment.addSourceCode("\n" + optionIndent).addSourceCode(additionalTableOptions).addSourceCode(") \n");
        } else {
            codeSegment.addSourceCode(") \n");
        }
        codeSegment.addSourceCode(optionIndent + "data = &etls_lastTable (");
        if (!colsToKeepStr.equals("")) {
            codeSegment.addSourceCode("\n" + optionIndent + colsToKeepStr + "\n" + optionIndent);
        }
        codeSegment.addSourceCode("&etls_tableOptions) force; \n").addSourceCode("run;\n\n");
        codeSegment.genRCSetCall("&syserr");
        this.genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", transform, table);
        return codeSegment;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_TeradataTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        collection.addModel(optionModel, "table_options_tera", RB.getStringResource("TERADATAType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }
}

