/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.visuals.expression.UserDefinedFunction;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SQLSVRType
extends BaseDBMSType {
    private static final String GLOBAL_TEMP_TABLE_PREFIX = "##";

    public SQLSVRType() {
        this.setAddKeyDelimiter(",");
        this.setRepeatAddKeyCommand(false);
        this.setIndexNameLength("100");
        this.setDBMSTempSupport(true);
    }

    @Override
    public int getDBMSTypeID() {
        return 10;
    }

    @Override
    public String getDBMSTypeName() {
        return "SQL Server";
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String user;
        String tableName = DBMSNamesUtil.getTableNamePart(table.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), false, false));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        if (tableName.indexOf(46) > 0) {
            user = "\"" + tableName.substring(0, tableName.indexOf(46)) + "\"";
            tableName = tableName.substring(tableName.indexOf(46), tableName.indexOf(46));
        } else {
            user = "";
        }
        codeSegment.indent().addSourceCode("from \n").addSourceCode("( \n").indent().addSourceCode("select distinct trim(index_name) as idxname, \n").addSourceCode("       trim(table_name) as tabname \n").indent().addSourceCode("from connection to " + this.getNickName(codeSegment, table) + "\n").indent().addSourceCode("(DBMS::Indexes (\"\", \"" + user.trim() + "\", \"" + tableName.trim() + "\"))\n").unIndent().unIndent().unIndent().addSourceCode(");\n").unIndent();
        return codeSegment;
    }

    @Override
    public String getAdditionalConnectionOptions(ILibrary iLib, String dbmsOptions) throws MdException, RemoteException {
        String retString = "";
        return retString;
    }

    @Override
    public String getDBMSTableName(ILibrary library, String tableName, boolean passthru) {
        if (library.isDBMSTemp(library) && passthru) {
            tableName = GLOBAL_TEMP_TABLE_PREFIX + tableName;
        }
        return tableName;
    }

    @Override
    public String getDBMSTableName(ILibrary library, String tableName, boolean passthru, String schemaName) {
        if (library.isDBMSTemp(library) && passthru) {
            tableName = GLOBAL_TEMP_TABLE_PREFIX + tableName;
        }
        return tableName;
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) {
        return codeSegment.addSourceCode("drop index \"%trim(%bquote(&etls_indexTable))\".\"%trim(%bquote(&etls_indexName))\"\n");
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_SQLServerTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        collection.addModel(optionModel, "table_options_sql", RB.getStringResource("SQLSERVERType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }

    @Override
    public boolean isNativeFunctionSetsSupported() {
        return true;
    }

    @Override
    public StringBuffer getNativeFunctionSetsQuery(ILibrary library, boolean quotes) {
        StringBuffer code = new StringBuffer();
        code.append("select a.name as FunctionName, ").append("b.name as ParameterName, c.name as ParmType, b.parameter_id, b.is_output, b.system_type_id");
        if (library.getLibref() != null) {
            code.append(" from ").append(library.getLibref()).append(".objects a").append(" left outer join ").append(library.getLibref()).append(".parameters b ");
        } else {
            code.append(" from objects a left outer join parameters b ");
        }
        code.append("on a.object_id = b.object_id ");
        if (library.getLibref() != null) {
            code.append(" left outer join ").append(library.getLibref()).append(".types c ");
        } else {
            code.append(" left outer join sys.type c ");
        }
        code.append("on b.system_type_id = c.system_type_id ").append("where a.type in (\"IF\", \"TF\", \"FN\", \"FS\", \"FT\") and b.is_output <> 1 ").append("order by a.name, b.parameter_id;");
        return code;
    }

    @Override
    public List createNativeFunctionsFromQueryResults(MVAResultSet rsltSet) throws SQLException {
        ArrayList<UserDefinedFunction> sets = new ArrayList<UserDefinedFunction>();
        if (rsltSet != null) {
            UserDefinedFunction func;
            String sName = null;
            String sDisplayName = null;
            String sFormat = null;
            String sDescription = RB.getStringResource("BaseDBMSType.ImportUserDefinedFunctionsDescription.txt");
            String oldName = null;
            String argName = null;
            int position = -1;
            String argType = null;
            boolean bFirst = true;
            boolean bDone = false;
            while (rsltSet.next()) {
                sName = rsltSet.getString(1).trim();
                if (sName == null || sName.equals("")) continue;
                if (!sName.equals(oldName) && oldName != null) {
                    if (position > -1 && argType != null) {
                        sFormat = sFormat + ")";
                        sDisplayName = sDisplayName + ")";
                    }
                    func = new UserDefinedFunction(sName, sDisplayName, sDescription, sFormat);
                    sets.add(func);
                    sDisplayName = null;
                    sFormat = null;
                    bFirst = true;
                }
                oldName = sName;
                argName = rsltSet.getString(2).trim();
                position = rsltSet.getInt(4);
                argType = rsltSet.getString(3).trim();
                if (!sName.equals(oldName) && oldName != null) continue;
                if (argType == null) {
                    sFormat = sName + "( )";
                    continue;
                }
                if (bFirst) {
                    sFormat = sName + "(<" + argType + ">";
                    sDisplayName = sName + "(" + argName;
                    bFirst = false;
                    continue;
                }
                if (position <= 0) continue;
                sFormat = sFormat + ", <" + argType + ">";
                sDisplayName = sDisplayName + ", " + argName;
            }
            rsltSet.close();
            if (sName != null) {
                if (position > 0 && argType != null) {
                    sFormat = sFormat + ")";
                    sDisplayName = sDisplayName + ")";
                }
                func = new UserDefinedFunction(sDisplayName, sDisplayName, sDescription, sFormat);
                sets.add(func);
            }
        }
        return sets;
    }
}

