/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class POSTGRESType
extends BaseDBMSType {
    public POSTGRESType() {
        this.setAddOneKeyPerExecute(true);
        this.setDBMSTempSupport(true);
    }

    @Override
    public int getDBMSTypeID() {
        return 26;
    }

    @Override
    public String getDBMSTypeName() {
        return "Postgres";
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getTableName(codeSegment.isQuoting());
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        String schema = this.getSchemaName(codeSegment.getCurrentServer(), table, codeSegment.isQuoting());
        codeSegment.indent().addSourceCode("from \n").indent().addSourceCode("( \n").addSourceCode(" select distinct index_name as idxname, \n").addSourceCode("        table_name as tabname \n").indent().addSourceCode(" from connection to ").addSourceCode(this.getNickName(codeSegment, table)).addSourceCode("\n").indent().addSourceCode(" (DBMS::Indexes (\"\", " + schema + ", " + tableName + ")) \n").unIndent().unIndent().addSourceCode(");\n").unIndent().unIndent();
        return codeSegment;
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        boolean quoting = codeSegment.isQuoting();
        String schema = this.getSchemaName(codeSegment.getCurrentServer(), table, codeSegment.isQuoting());
        if (null != schema && !"".equals(schema.trim())) {
            schema = schema + ".";
        }
        if (quoting) {
            codeSegment.addSourceCode("drop index " + schema + "\"%trim(%bquote(&etls_indexName))\" \n");
        } else {
            codeSegment.addSourceCode("drop index " + schema + "&etls_indexName \n");
        }
        return codeSegment;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_PostgresTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        collection.addModel(optionModel, "table_options_sql", RB.getStringResource("POSTGRESType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }
}

