/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.visuals.expression.UserDefinedFunction;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ORACLEType
extends BaseDBMSType {
    public ORACLEType() {
        this.setConstraintTypesDroppable("PUR");
        this.setUnquotedTableNameAction("U");
        this.setTableAliasKeyword(" ");
        this.setTablespaceSupport(true);
        this.setDBMSTempSupport(true);
        this.setCreateTempIndexAndConstraintAfterLoad(false);
    }

    @Override
    public int getDBMSTypeID() {
        return 7;
    }

    @Override
    public String getDBMSTypeName() {
        return "Oracle";
    }

    @Override
    public boolean isNativeFunctionSetsSupported() {
        return true;
    }

    @Override
    public List createNativeFunctionsFromQueryResults(MVAResultSet rsltSet) throws SQLException {
        ArrayList<UserDefinedFunction> sets = new ArrayList<UserDefinedFunction>();
        if (rsltSet != null) {
            UserDefinedFunction func;
            String sName = null;
            String sDisplayName = null;
            String sFormat = null;
            String sDescription = RB.getStringResource("BaseDBMSType.ImportUserDefinedFunctionsDescription.txt");
            String oldName = null;
            String argName = null;
            int position = -1;
            String argType = null;
            boolean bFirst = true;
            boolean bDone = false;
            while (rsltSet.next()) {
                sName = rsltSet.getString(1).trim();
                if (sName == null || sName.equals("")) continue;
                if (!sName.equals(oldName) && oldName != null) {
                    if (position > -1 && argType != null) {
                        sFormat = sFormat + ")";
                        sDisplayName = sDisplayName + ")";
                    }
                    func = new UserDefinedFunction(sName, sDisplayName, sDescription, sFormat);
                    sets.add(func);
                    sDisplayName = null;
                    sFormat = null;
                    bFirst = true;
                }
                oldName = sName;
                argName = rsltSet.getString(2).trim();
                position = rsltSet.getInt(3);
                argType = rsltSet.getString(4).trim();
                if (!sName.equals(oldName) && oldName != null) continue;
                if (argType == null) {
                    sFormat = sName + "( )";
                    continue;
                }
                if (bFirst) {
                    sFormat = sName + "(<" + argType + ">";
                    sDisplayName = sName + "(" + argName;
                    bFirst = false;
                    continue;
                }
                if (position <= 0) continue;
                sFormat = sFormat + ", <" + argType + ">";
                sDisplayName = sDisplayName + ", " + argName;
            }
            rsltSet.close();
            if (sName != null) {
                if (position > 0 && argType != null) {
                    sFormat = sFormat + ")";
                    sDisplayName = sDisplayName + ")";
                }
                func = new UserDefinedFunction(sDisplayName, sDisplayName, sDescription, sFormat);
                sets.add(func);
            }
        }
        return sets;
    }

    @Override
    public StringBuffer getNativeFunctionSetsQuery(ILibrary library, boolean quotes) {
        StringBuffer code = new StringBuffer();
        if (library != null) {
            if (!quotes) {
                code.append(" select a.OBJECT_NAME, b.ARGUMENT_NAME, b.POSITION, b.DATA_TYPE");
                if (library.getLibref() != null) {
                    code.append(" from ").append(library.getLibref()).append(".user_procedures a left outer join ").append(library.getLibref()).append(".user_arguments b");
                } else {
                    code.append(" from user_procedures a left outer join user_arguments b");
                }
                code.append(" on a.OBJECT_NAME = b.OBJECT_NAME where b.IN_OUT<>\"OUT\"").append(" ORDER BY a.OBJECT_NAME, b.POSITION;");
            } else {
                code.append(" select a.\"OBJECT_NAME\"n, b.\"ARGUMENT_NAME\"n, b.\"POSITION\"n, b.\"DATA_TYPE\"n");
                if (library.getLibref() != null) {
                    code.append(" from ").append(library.getLibref()).append(".\"USER_PROCEDURES\"n a left outer join ").append(library.getLibref()).append(".\"USER_ARGUMENTS\"n b");
                } else {
                    code.append(" from \"USER_PROCEDURES\"n a, \"USER_ARGUMENTS\"n b");
                }
                code.append(" on a.\"OBJECT_NAME\"n = b.\"OBJECT_NAME\"n where b.\"IN_OUT\"n <>\"OUT\"").append(" ORDER BY a.\"OBJECT_NAME\"n, b.\"POSITION\"n;");
            }
        }
        return code;
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = DBMSNamesUtil.getTableNamePart(table.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), true, false, ""));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.indent().addSourceCode("       ,tablespaceName length=100\n").addSourceCode("from connection to " + this.getNickName(codeSegment, table) + "\n").addSourceCode("( \n").indent().addSourceCode("select index_name as idxname , \n").addSourceCode("       table_name as tabName,  \n").addSourceCode("       tablespace_name as tablespaceName \n").indent().addSourceCode("from user_indexes \n").indent();
        tableName = tableName.replaceAll("'", "''");
        codeSegment.addSourceCode("where table_name = '" + tableName + "' \n").addSourceCode("      and generated = 'N' \n").unIndent().unIndent().unIndent().addSourceCode("); \n").unIndent();
        return codeSegment;
    }

    @Override
    public ICodeSegment dropSingleConstraint(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        this.genExecuteBegin(codeSegment, table, "");
        codeSegment.addSourceCode("alter table " + table.getFullNameQuotedAsNeeded(codeSegment, true) + " drop constraint &etls_constName \n");
        this.genExecuteEnd(codeSegment, table, "");
        return codeSegment;
    }

    @Override
    public ICodeSegment queryConstraints(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = DBMSNamesUtil.getTableNamePart(table.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), true, false, ""));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        tableName = tableName.replaceAll("'", "''");
        codeSegment.indent().addSourceCode("from connection to " + this.getNickName(codeSegment, table) + "\n").addSourceCode("( \n").indent().addSourceCode("select constraint_name as constName, constraint_type as constType \n").indent().addSourceCode("from user_constraints \n").indent().addSourceCode("where table_name = '" + tableName + "'").addSourceCode(" and constraint_type IN ('P','U','R') ").addSourceCode(" \n").unIndent().unIndent().unIndent().addSourceCode(") order by consttype desc; /* sort R(eferential) before P(rimary) */ \n").unIndent();
        return codeSegment;
    }

    @Override
    public ICodeSegment genDeleteAll(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("truncate table " + tableName + "\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment genDeleteAll2(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("delete from " + tableName + "\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment getSQLCreateCode(IPhysicalTable table, boolean passThru, ICodeSegment cs) {
        cs.clearSourceCode();
        IColumn[] columns = table.getColumns();
        int size = columns.length;
        String type = null;
        String createTableTxt = null;
        if (passThru) {
            createTableTxt = "CREATE TABLE " + table.getDBMSTableName(true) + "\n";
        } else {
            try {
                createTableTxt = "CREATE TABLE " + table.getFullNameQuotedAsNeeded(cs) + "\n";
            }
            catch (BadLibraryDefinitionException e) {
                e.printStackTrace();
            }
        }
        cs.addSourceCode(createTableTxt);
        cs.indent().addSourceCode("(\n").indent();
        int j = 0;
        for (int i = 0; i < size; ++i) {
            ++j;
            String columnLength = String.valueOf(columns[i].getLength());
            String colName = columns[i].getName();
            int colType = columns[i].getType();
            boolean nullValuesYes = columns[i].isNullable();
            type = passThru ? (colType == 0 ? "VARCHAR2" : "NUMBER") : (colType == 0 ? "CHAR" : "NUM");
            String notNull = nullValuesYes ? "" : "NOT NULL";
            if (j < size) {
                cs.addSourceCode(colName + " ").addSourceCode(type).addSourceCode("(").addSourceCode(columnLength).addSourceCode(") ").addSourceCode(notNull).addSourceCode(",\n");
                continue;
            }
            if (j != size) continue;
            if (passThru) {
                cs.addSourceCode(colName + " ").addSourceCode(type).addSourceCode("(").addSourceCode(columnLength).addSourceCode(") ").addSourceCode(notNull).unIndent().addSourceCode("\n)\n");
                continue;
            }
            cs.addSourceCode(colName + " ").addSourceCode(type).addSourceCode("(").addSourceCode(columnLength).addSourceCode(") ").addSourceCode(notNull).unIndent().addSourceCode("\n);\n");
        }
        return cs;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_OracleTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        collection.addModel(optionModel, "table_options_oracle", RB.getStringResource("ORACLEType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }
}

